/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import kafka.api.BaseConsumerTest$ConsumerAssignmentPoller$;
import kafka.api.IntegrationTestHarness;
import kafka.api.IntegrationTestHarness$class;
import kafka.common.Topic$;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r-e!B\u0001\u0003\u0003\u00039!\u0001\u0005\"bg\u0016\u001cuN\\:v[\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0002ba&T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0005\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tQ!*\u00168jiN+\u0018\u000e^3\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\t\u000b]\u0001A\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005I\u0002CA\n\u0001\u0011\u001dY\u0002A1A\u0005\u0002q\tq!\u001a9tS2|g.F\u0001\u001e!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019!u.\u001e2mK\"1A\u0005\u0001Q\u0001\nu\t\u0001\"\u001a9tS2|g\u000e\t\u0005\bM\u0001\u0011\r\u0011\"\u0001(\u00035\u0001(o\u001c3vG\u0016\u00148i\\;oiV\t\u0001\u0006\u0005\u0002\u001fS%\u0011!f\b\u0002\u0004\u0013:$\bB\u0002\u0017\u0001A\u0003%\u0001&\u0001\bqe>$WoY3s\u0007>,h\u000e\u001e\u0011\t\u000f9\u0002!\u0019!C\u0001O\u0005i1m\u001c8tk6,'oQ8v]RDa\u0001\r\u0001!\u0002\u0013A\u0013AD2p]N,X.\u001a:D_VtG\u000f\t\u0005\be\u0001\u0011\r\u0011\"\u0001(\u0003-\u0019XM\u001d<fe\u000e{WO\u001c;\t\rQ\u0002\u0001\u0015!\u0003)\u00031\u0019XM\u001d<fe\u000e{WO\u001c;!\u0011\u001d1\u0004A1A\u0005\u0002]\nQ\u0001^8qS\u000e,\u0012\u0001\u000f\t\u0003syj\u0011A\u000f\u0006\u0003wq\nA\u0001\\1oO*\tQ(\u0001\u0003kCZ\f\u0017BA ;\u0005\u0019\u0019FO]5oO\"1\u0011\t\u0001Q\u0001\na\na\u0001^8qS\u000e\u0004\u0003bB\"\u0001\u0005\u0004%\taJ\u0001\u0005a\u0006\u0014H\u000f\u0003\u0004F\u0001\u0001\u0006I\u0001K\u0001\u0006a\u0006\u0014H\u000f\t\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0003\t!\b/F\u0001J!\tQ\u0005+D\u0001L\u0015\taU*\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b9S!a\u0014\b\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\t6J\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\rM\u0003\u0001\u0015!\u0003J\u0003\r!\b\u000f\t\u0005\b+\u0002\u0011\r\u0011\"\u0001(\u0003\u0015\u0001\u0018M\u001d;3\u0011\u00199\u0006\u0001)A\u0005Q\u00051\u0001/\u0019:ue\u0001Bq!\u0017\u0001C\u0002\u0013\u0005\u0001*A\u0002uaJBaa\u0017\u0001!\u0002\u0013I\u0015\u0001\u0002;qe\u0001BQ!\u0018\u0001\u0005By\u000bQa]3u+B$\u0012a\u0018\t\u0003=\u0001L!!Y\u0010\u0003\tUs\u0017\u000e\u001e\u0015\u00039\u000e\u0004\"\u0001\u001a4\u000e\u0003\u0015T!a\u0003\b\n\u0005\u001d,'A\u0002\"fM>\u0014X\rC\u0003j\u0001\u0011\u0005a,A\u000buKN$8+[7qY\u0016\u001cuN\\:v[B$\u0018n\u001c8)\u0005!\\\u0007C\u00013m\u0013\tiWM\u0001\u0003UKN$\b\"B8\u0001\t\u0003q\u0016a\u0006;fgR\u001cun\u001c:eS:\fGo\u001c:GC&dwN^3sQ\tq7N\u0002\u0003s\u0001!\u0019(\u0001\t+fgR\u001cuN\\:v[\u0016\u0014(+Z1tg&<g.\\3oi2K7\u000f^3oKJ\u001c2!\u001d;x!\tIT/\u0003\u0002wu\t1qJ\u00196fGR\u0004\"\u0001_?\u000e\u0003eT!A_>\u0002\u0011\r|gn];nKJT!\u0001`'\u0002\u000f\rd\u0017.\u001a8ug&\u0011a0\u001f\u0002\u001a\u0007>t7/^7feJ+'-\u00197b]\u000e,G*[:uK:,'\u000f\u0003\u0004\u0018c\u0012\u0005\u0011\u0011\u0001\u000b\u0003\u0003\u0007\u00012!!\u0002r\u001b\u0005\u0001\u0001\u0002CA\u0005c\u0002\u0007I\u0011A\u0014\u0002\u001f\r\fG\u000e\\:U_\u0006\u001b8/[4oK\u0012D\u0011\"!\u0004r\u0001\u0004%\t!a\u0004\u0002'\r\fG\u000e\\:U_\u0006\u001b8/[4oK\u0012|F%Z9\u0015\u0007}\u000b\t\u0002C\u0005\u0002\u0014\u0005-\u0011\u0011!a\u0001Q\u0005\u0019\u0001\u0010J\u0019\t\u000f\u0005]\u0011\u000f)Q\u0005Q\u0005\u00012-\u00197mgR{\u0017i]:jO:,G\r\t\u0005\t\u00037\t\b\u0019!C\u0001O\u0005q1-\u00197mgR{'+\u001a<pW\u0016$\u0007\"CA\u0010c\u0002\u0007I\u0011AA\u0011\u0003I\u0019\u0017\r\u001c7t)>\u0014VM^8lK\u0012|F%Z9\u0015\u0007}\u000b\u0019\u0003C\u0005\u0002\u0014\u0005u\u0011\u0011!a\u0001Q!9\u0011qE9!B\u0013A\u0013aD2bY2\u001cHk\u001c*fm>\\W\r\u001a\u0011\t\u000f\u0005-\u0012\u000f\"\u0001\u0002.\u0005!rN\u001c)beRLG/[8og\u0006\u001b8/[4oK\u0012$2aXA\u0018\u0011!\t\t$!\u000bA\u0002\u0005M\u0012A\u00039beRLG/[8ogB)\u0011QGA\u001e\u00136\u0011\u0011q\u0007\u0006\u0004\u0003sa\u0014\u0001B;uS2LA!!\u0010\u00028\tQ1i\u001c7mK\u000e$\u0018n\u001c8\t\u000f\u0005\u0005\u0013\u000f\"\u0001\u0002D\u0005\u0019rN\u001c)beRLG/[8ogJ+go\\6fIR\u0019q,!\u0012\t\u0011\u0005E\u0012q\ba\u0001\u0003gAq!!\u0013\u0001\t#\tY%A\u0006tK:$'+Z2pe\u0012\u001cH\u0003BA'\u0003{\u0002b!a\u0014\u0002`\u0005\u0015d\u0002BA)\u00037rA!a\u0015\u0002Z5\u0011\u0011Q\u000b\u0006\u0004\u0003/2\u0011A\u0002\u001fs_>$h(C\u0001!\u0013\r\tifH\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t'a\u0019\u0003\u0007M+\u0017OC\u0002\u0002^}\u0001\u0002\"a\u001a\u0002n\u0005E\u0014\u0011O\u0007\u0003\u0003SR1!a\u001b|\u0003!\u0001(o\u001c3vG\u0016\u0014\u0018\u0002BA8\u0003S\u0012a\u0002\u0015:pIV\u001cWM\u001d*fG>\u0014H\rE\u0003\u001f\u0003g\n9(C\u0002\u0002v}\u0011Q!\u0011:sCf\u00042AHA=\u0013\r\tYh\b\u0002\u0005\u0005f$X\rC\u0004\u0002\u0000\u0005\u001d\u0003\u0019\u0001\u0015\u0002\u00159,XNU3d_J$7\u000fC\u0004\u0002J\u0001!\t\"a!\u0015\r\u00055\u0013QQAD\u0011\u001d\ty(!!A\u0002!BaaRAA\u0001\u0004I\u0005bBA%\u0001\u0011E\u00111\u0012\u000b\t\u0003\u001b\ni)!&\u0002\u0018\"A\u00111NAE\u0001\u0004\ty\t\u0005\u0005\u0002h\u0005E\u0015\u0011OA9\u0013\u0011\t\u0019*!\u001b\u0003\u001b-\u000bgm[1Qe>$WoY3s\u0011\u001d\ty(!#A\u0002!BaaRAE\u0001\u0004I\u0005bBAN\u0001\u0011E\u0011QT\u0001\u0018G>t7/^7f\u0003:$g+\u001a:jMf\u0014VmY8sIN$\u0012cXAP\u0003O\u000bI+!,\u00022\u0006m\u00161ZAg\u0011\u001dQ\u0018\u0011\u0014a\u0001\u0003C\u0003r\u0001_AR\u0003c\n\t(C\u0002\u0002&f\u0014\u0001bQ8ogVlWM\u001d\u0005\b\u0003\u007f\nI\n1\u0001)\u0011\u001d\tY+!'A\u0002!\nab\u001d;beRLgnZ(gMN,G\u000fC\u0005\u00020\u0006e\u0005\u0013!a\u0001Q\u0005A2\u000f^1si&twmS3z\u0003:$g+\u00197vK&sG-\u001a=\t\u0015\u0005M\u0016\u0011\u0014I\u0001\u0002\u0004\t),A\tti\u0006\u0014H/\u001b8h)&lWm\u001d;b[B\u00042AHA\\\u0013\r\tIl\b\u0002\u0005\u0019>tw\r\u0003\u0006\u0002>\u0006e\u0005\u0013!a\u0001\u0003\u007f\u000bQ\u0002^5nKN$\u0018-\u001c9UsB,\u0007\u0003BAa\u0003\u000fl!!a1\u000b\u0007\u0005\u00157*\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003\u0013\f\u0019MA\u0007US6,7\u000f^1naRK\b/\u001a\u0005\t\u000f\u0006e\u0005\u0013!a\u0001\u0013\"I\u0011qZAM!\u0003\u0005\r\u0001K\u0001\u000f[\u0006D\bk\u001c7m%\u0016\u001cwN\u001d3t\u0011\u001d\t\u0019\u000e\u0001C\t\u0003+\fabY8ogVlWMU3d_J$7/\u0006\u0004\u0002X\u0006M(q\u0001\u000b\t\u00033\u0014YAa\u0004\u0003\u0012A1\u00111\\As\u0003Sl!!!8\u000b\t\u0005}\u0017\u0011]\u0001\b[V$\u0018M\u00197f\u0015\r\t\u0019oH\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAt\u0003;\u00141\"\u0011:sCf\u0014UO\u001a4feB9\u00010a;\u0002p\n\u0015\u0011bAAws\nq1i\u001c8tk6,'OU3d_J$\u0007\u0003BAy\u0003gd\u0001\u0001\u0002\u0005\u0002v\u0006E'\u0019AA|\u0005\u0005Y\u0015\u0003BA}\u0003\u007f\u00042AHA~\u0013\r\tip\b\u0002\b\u001d>$\b.\u001b8h!\rq\"\u0011A\u0005\u0004\u0005\u0007y\"aA!osB!\u0011\u0011\u001fB\u0004\t!\u0011I!!5C\u0002\u0005](!\u0001,\t\u000fi\f\t\u000e1\u0001\u0003\u000eA9\u00010a)\u0002p\n\u0015\u0001bBA@\u0003#\u0004\r\u0001\u000b\u0005\n\u0003\u001f\f\t\u000e%AA\u0002!BqA!\u0006\u0001\t#\u00119\"A\nbo\u0006LGoQ8n[&$8)\u00197mE\u0006\u001c7.\u0006\u0004\u0003\u001a\t\u0005\"Q\u0005\u000b\b?\nm!q\u0005B?\u0011\u001dQ(1\u0003a\u0001\u0005;\u0001r\u0001_AR\u0005?\u0011\u0019\u0003\u0005\u0003\u0002r\n\u0005B\u0001CA{\u0005'\u0011\r!a>\u0011\t\u0005E(Q\u0005\u0003\t\u0005\u0013\u0011\u0019B1\u0001\u0002x\"A!\u0011\u0006B\n\u0001\u0004\u0011Y#\u0001\bd_6l\u0017\u000e^\"bY2\u0014\u0017mY6\u0011\t\u0005\u0015!Q\u0006\u0004\u0007\u0005_\u0001\u0001B!\r\u00037\r{WO\u001c;D_:\u001cX/\\3s\u0007>lW.\u001b;DC2d'-Y2l'\u0015\u0011i\u0003\u001eB\u001a!\rA(QG\u0005\u0004\u0005oI(\u0001F(gMN,GoQ8n[&$8)\u00197mE\u0006\u001c7\u000eC\u0004\u0018\u0005[!\tAa\u000f\u0015\u0005\t-\u0002\"\u0003B \u0005[\u0001\r\u0011\"\u0001(\u00031\u0019XoY2fgN\u001cu.\u001e8u\u0011)\u0011\u0019E!\fA\u0002\u0013\u0005!QI\u0001\u0011gV\u001c7-Z:t\u0007>,h\u000e^0%KF$2a\u0018B$\u0011%\t\u0019B!\u0011\u0002\u0002\u0003\u0007\u0001\u0006\u0003\u0005\u0003L\t5\u0002\u0015)\u0003)\u00035\u0019XoY2fgN\u001cu.\u001e8uA!I!q\nB\u0017\u0001\u0004%\taJ\u0001\nM\u0006LGnQ8v]RD!Ba\u0015\u0003.\u0001\u0007I\u0011\u0001B+\u000351\u0017-\u001b7D_VtGo\u0018\u0013fcR\u0019qLa\u0016\t\u0013\u0005M!\u0011KA\u0001\u0002\u0004A\u0003\u0002\u0003B.\u0005[\u0001\u000b\u0015\u0002\u0015\u0002\u0015\u0019\f\u0017\u000e\\\"pk:$\b\u0005\u0003\u0005\u0003`\t5B\u0011\tB1\u0003)ygnQ8na2,G/\u001a\u000b\u0006?\n\r$1\u000f\u0005\t\u0005K\u0012i\u00061\u0001\u0003h\u00059qN\u001a4tKR\u001c\bcBA\u001b\u0005SJ%QN\u0005\u0005\u0005W\n9DA\u0002NCB\u00042\u0001\u001fB8\u0013\r\u0011\t(\u001f\u0002\u0012\u001f\u001a47/\u001a;B]\u0012lU\r^1eCR\f\u0007\u0002\u0003B;\u0005;\u0002\rAa\u001e\u0002\u0013\u0015D8-\u001a9uS>t\u0007\u0003BA(\u0005sJAAa\u001f\u0002d\tIQ\t_2faRLwN\u001c\u0005\n\u0005\u007f\u0012\u0019\u0002%AA\u0002!\nQaY8v]R4aAa!\u0001\u0011\t\u0015%\u0001G\"p]N,X.\u001a:BgNLwM\\7f]R\u0004v\u000e\u001c7feN!!\u0011\u0011BD!\u0011\u0011IIa$\u000e\u0005\t-%b\u0001BG\t\u0005)Q\u000f^5mg&!!\u0011\u0013BF\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\t\u0015i\u0014\tI!A!\u0002\u0013\t\t\u000bC\u0006\u0003\u0018\n\u0005%\u0011!Q\u0001\n\te\u0015!\u0005;pa&\u001c7\u000fV8Tk\n\u001c8M]5cKB1\u0011q\nBN\u0005?KAA!(\u0002d\t!A*[:u!\u0011\u0011\tKa*\u000f\u0007y\u0011\u0019+C\u0002\u0003&~\ta\u0001\u0015:fI\u00164\u0017bA \u0003**\u0019!QU\u0010\t\u000f]\u0011\t\t\"\u0001\u0003.R1!q\u0016BY\u0005g\u0003B!!\u0002\u0003\u0002\"9!Pa+A\u0002\u0005\u0005\u0006\u0002\u0003BL\u0005W\u0003\rA!'\t\u0015\t]&\u0011\u0011a\u0001\n\u0013\u0011I,A\nqCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tG/\u0006\u0002\u0003<B)!\u0011\u0015B_\u0013&!!q\u0018BU\u0005\r\u0019V\r\u001e\u0005\u000b\u0005\u0007\u0014\t\t1A\u0005\n\t\u0015\u0017a\u00069beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$x\fJ3r)\ry&q\u0019\u0005\u000b\u0003'\u0011\t-!AA\u0002\tm\u0006\"\u0003Bf\u0005\u0003\u0003\u000b\u0015\u0002B^\u0003Q\u0001\u0018M\u001d;ji&|g.Q:tS\u001etW.\u001a8uA!\"!\u0011\u001aBh!\rq\"\u0011[\u0005\u0004\u0005'|\"\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0015\t]'\u0011\u0011a\u0001\n\u0013\u0011I.\u0001\nu_BL7m]*vEN\u001c'/\u001b9uS>tWC\u0001BM\u0011)\u0011iN!!A\u0002\u0013%!q\\\u0001\u0017i>\u0004\u0018nY:Tk\n\u001c8M]5qi&|gn\u0018\u0013fcR\u0019qL!9\t\u0015\u0005M!1\\A\u0001\u0002\u0004\u0011I\nC\u0005\u0003f\n\u0005\u0005\u0015)\u0003\u0003\u001a\u0006\u0019Bo\u001c9jGN\u001cVOY:de&\u0004H/[8oA!Q!\u0011\u001eBA\u0001\u0004%IAa;\u0002'M,(m]2sSB$\u0018n\u001c8DQ\u0006tw-\u001a3\u0016\u0005\t5\bc\u0001\u0010\u0003p&\u0019!\u0011_\u0010\u0003\u000f\t{w\u000e\\3b]\"Q!Q\u001fBA\u0001\u0004%IAa>\u0002/M,(m]2sSB$\u0018n\u001c8DQ\u0006tw-\u001a3`I\u0015\fHcA0\u0003z\"Q\u00111\u0003Bz\u0003\u0003\u0005\rA!<\t\u0013\tu(\u0011\u0011Q!\n\t5\u0018\u0001F:vEN\u001c'/\u001b9uS>t7\t[1oO\u0016$\u0007\u0005\u000b\u0003\u0003|\n=\u0007BCB\u0002\u0005\u0003\u0013\r\u0011\"\u0001\u0004\u0006\u0005\t\"/\u001a2bY\u0006t7-\u001a'jgR,g.\u001a:\u0016\u0005\r\u001d!\u0003BB\u0005i^4qaa\u0003\u0004\u000e\u0001\u00199A\u0001\u0007=e\u00164\u0017N\\3nK:$h\bC\u0005\u0004\u0010\t\u0005\u0005\u0015!\u0003\u0004\b\u0005\u0011\"/\u001a2bY\u0006t7-\u001a'jgR,g.\u001a:!\u0011!\u0019\u0019B!!\u0005\u0002\rU\u0011AE2p]N,X.\u001a:BgNLwM\\7f]R$\"Aa/\t\u0011\re!\u0011\u0011C\u0001\u00077\t\u0011b];cg\u000e\u0014\u0018NY3\u0015\u0007}\u001bi\u0002\u0003\u0005\u0004 \r]\u0001\u0019\u0001BM\u0003QqWm\u001e+pa&\u001c7\u000fV8Tk\n\u001c8M]5cK\"A11\u0005BA\t\u0003\u0019)#A\u000ejgN+(m]2sS\n,'+Z9vKN$\bK]8dKN\u001cX\r\u001a\u000b\u0003\u0005[D\u0001b!\u000b\u0003\u0002\u0012\u00053QE\u0001\u0011S:LG/[1uKNCW\u000f\u001e3po:Dqa!\f\u0003\u0002\u0012\u0005c,\u0001\u0004e_^{'o\u001b\u0005\b\u0007c\u0001A\u0011AB\u001a\u0003iI7\u000fU1si&$\u0018n\u001c8BgNLwM\\7f]R4\u0016\r\\5e)\u0019\u0011io!\u000e\u0004@!A1qGB\u0018\u0001\u0004\u0019I$A\u0006bgNLwM\\7f]R\u001c\bCBAn\u0007w\u0011Y,\u0003\u0003\u0004>\u0005u'A\u0002\"vM\u001a,'\u000f\u0003\u0005\u00022\r=\u0002\u0019\u0001B^\u0011%\u0019\u0019\u0005AI\u0001\n#\u0019)%A\u0011d_:\u001cX/\\3B]\u00124VM]5gsJ+7m\u001c:eg\u0012\"WMZ1vYR$C'\u0006\u0002\u0004H)\u001a\u0001f!\u0013,\u0005\r-\u0003\u0003BB'\u0007/j!aa\u0014\u000b\t\rE31K\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!\u0016 \u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00073\u001ayEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011b!\u0018\u0001#\u0003%\tba\u0018\u0002C\r|gn];nK\u0006sGMV3sS\u001aL(+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\r\u0005$\u0006BA[\u0007\u0013B\u0011b!\u001a\u0001#\u0003%\tba\u001a\u0002C\r|gn];nK\u0006sGMV3sS\u001aL(+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\r%$\u0006BA`\u0007\u0013B\u0011b!\u001c\u0001#\u0003%\tba\u001c\u0002C\r|gn];nK\u0006sGMV3sS\u001aL(+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\rE$fA%\u0004J!I1Q\u000f\u0001\u0012\u0002\u0013E1QI\u0001\"G>t7/^7f\u0003:$g+\u001a:jMf\u0014VmY8sIN$C-\u001a4bk2$H\u0005\u000f\u0005\n\u0007s\u0002\u0011\u0013!C\t\u0007w\nQ$Y<bSR\u001cu.\\7ji\u000e\u000bG\u000e\u001c2bG.$C-\u001a4bk2$HeM\u000b\u0007\u0007\u000b\u001aiha \u0005\u0011\u0005U8q\u000fb\u0001\u0003o$\u0001B!\u0003\u0004x\t\u0007\u0011q\u001f\u0005\n\u0007\u0007\u0003\u0011\u0013!C\t\u0007\u000b\u000b\u0001dY8ogVlWMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0019\u0019)ea\"\u0004\n\u0012A\u0011Q_BA\u0005\u0004\t9\u0010\u0002\u0005\u0003\n\r\u0005%\u0019AA|\u0001")
public abstract class BaseConsumerTest
extends JUnitSuite
implements IntegrationTestHarness {
    private final double epsilon;
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final String topic;
    private final int part;
    private final TopicPartition tp;
    private final int part2;
    private final TopicPartition tp2;
    private final Properties producerConfig;
    private final Properties consumerConfig;
    private final Properties serverConfig;
    private final Buffer<KafkaConsumer<byte[], byte[]>> consumers;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile byte bitmap$0;

    private Properties producerConfig$lzycompute() {
        BaseConsumerTest baseConsumerTest = this;
        synchronized (baseConsumerTest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.producerConfig = IntegrationTestHarness$class.producerConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.producerConfig;
        }
    }

    @Override
    public Properties producerConfig() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.producerConfig$lzycompute() : this.producerConfig;
    }

    private Properties consumerConfig$lzycompute() {
        BaseConsumerTest baseConsumerTest = this;
        synchronized (baseConsumerTest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.consumerConfig = IntegrationTestHarness$class.consumerConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.consumerConfig;
        }
    }

    @Override
    public Properties consumerConfig() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.consumerConfig$lzycompute() : this.consumerConfig;
    }

    private Properties serverConfig$lzycompute() {
        BaseConsumerTest baseConsumerTest = this;
        synchronized (baseConsumerTest) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.serverConfig = IntegrationTestHarness$class.serverConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.serverConfig;
        }
    }

    @Override
    public Properties serverConfig() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.serverConfig$lzycompute() : this.serverConfig;
    }

    @Override
    public Buffer<KafkaConsumer<byte[], byte[]>> consumers() {
        return this.consumers;
    }

    @Override
    public Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    @Override
    public void kafka$api$IntegrationTestHarness$$super$setUp() {
        KafkaServerTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$api$IntegrationTestHarness$$super$tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$api$IntegrationTestHarness$_setter_$consumers_$eq(Buffer x$1) {
        this.consumers = x$1;
    }

    @Override
    public void kafka$api$IntegrationTestHarness$_setter_$producers_$eq(Buffer x$1) {
        this.producers = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return IntegrationTestHarness$class.generateConfigs(this);
    }

    @Override
    public KafkaProducer<byte[], byte[]> createNewProducer() {
        return IntegrationTestHarness$class.createNewProducer(this);
    }

    @Override
    public KafkaConsumer<byte[], byte[]> createNewConsumer() {
        return IntegrationTestHarness$class.createNewConsumer(this);
    }

    @Override
    @After
    public void tearDown() {
        IntegrationTestHarness$class.tearDown(this);
    }

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        KafkaServerTestHarness$class.configureSecurityBeforeServersStart(this);
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public int boundPort(KafkaServer server) {
        return KafkaServerTestHarness$class.boundPort(this, server);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public ListenerName listenerName() {
        return KafkaServerTestHarness$class.listenerName(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> serverSaslProperties() {
        return KafkaServerTestHarness$class.serverSaslProperties(this);
    }

    @Override
    public Option<Properties> clientSaslProperties() {
        return KafkaServerTestHarness$class.clientSaslProperties(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void killBroker(int index) {
        KafkaServerTestHarness$class.killBroker(this, index);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        BaseConsumerTest baseConsumerTest = this;
        synchronized (baseConsumerTest) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public double epsilon() {
        return this.epsilon;
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int part2() {
        return this.part2;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    @Override
    @Before
    public void setUp() {
        IntegrationTestHarness$class.setUp(this);
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
    }

    @Test
    public void testSimpleConsumption() {
        int numRecords = 10000;
        this.sendRecords(numRecords);
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().head()).assignment().size());
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((long)1L, (long)((KafkaConsumer)this.consumers().head()).assignment().size());
        ((KafkaConsumer)this.consumers().head()).seek(this.tp(), 0L);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), numRecords, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        CountConsumerCommitCallback commitCallback = new CountConsumerCommitCallback();
        ((KafkaConsumer)this.consumers().head()).commitAsync((OffsetCommitCallback)commitCallback);
        this.awaitCommitCallback((Consumer)this.consumers().head(), commitCallback, this.awaitCommitCallback$default$3());
    }

    @Test
    public void testCoordinatorFailover() {
        TestConsumerReassignmentListener listener = new TestConsumerReassignmentListener();
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "2000");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        consumer0.poll(2000L);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Seq parts = null;
        while (parts == null) {
            parts = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(consumer0.partitionsFor(Topic$.MODULE$.GroupMetadataTopicName())).asScala();
        }
        Assert.assertEquals((long)1L, (long)parts.size());
        Assert.assertNotNull((Object)((PartitionInfo)parts.head()).leader());
        int coordinator = ((PartitionInfo)parts.head()).leader().id();
        ((KafkaServer)this.servers().apply(coordinator)).shutdown();
        consumer0.poll(5000L);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Assert.assertEquals((long)1L, (long)listener.callsToRevoked());
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(int numRecords) {
        return this.sendRecords(numRecords, this.tp());
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(int numRecords, TopicPartition tp) {
        return this.sendRecords((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords, tp);
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp) {
        IndexedSeq records2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, producer, tp){
            public static final long serialVersionUID = 0L;
            private final KafkaProducer producer$1;
            private final TopicPartition tp$1;

            /*
             * WARNING - void declaration
             */
            public final ProducerRecord<byte[], byte[]> apply(int i) {
                void var2_2;
                ProducerRecord record = new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), Predef$.MODULE$.long2Long((long)i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
                this.producer$1.send(record);
                return var2_2;
            }
            {
                this.producer$1 = producer$1;
                this.tp$1 = tp$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
        return records2;
    }

    public void consumeAndVerifyRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, int startingKeyAndValueIndex, long startingTimestamp, TimestampType timestampType, TopicPartition tp, int maxPollRecords) {
        ArrayBuffer<ConsumerRecord<byte[], byte[]>> records2 = this.consumeRecords(consumer, numRecords, maxPollRecords);
        long now = System.currentTimeMillis();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)new Serializable(this, startingOffset, startingKeyAndValueIndex, startingTimestamp, timestampType, tp, records2, now){
            public static final long serialVersionUID = 0L;
            private final int startingOffset$1;
            private final int startingKeyAndValueIndex$1;
            private final long startingTimestamp$1;
            private final TimestampType timestampType$1;
            private final TopicPartition tp$2;
            private final ArrayBuffer records$1;
            private final long now$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ConsumerRecord record = (ConsumerRecord)this.records$1.apply(i);
                int offset = this.startingOffset$1 + i;
                Assert.assertEquals((Object)this.tp$2.topic(), (Object)record.topic());
                Assert.assertEquals((long)this.tp$2.partition(), (long)record.partition());
                TimestampType timestampType = this.timestampType$1;
                TimestampType timestampType2 = TimestampType.CREATE_TIME;
                if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                    Assert.assertEquals((Object)this.timestampType$1, (Object)record.timestampType());
                    long timestamp = this.startingTimestamp$1 + (long)i;
                    Assert.assertEquals((long)timestamp, (long)record.timestamp());
                } else {
                    Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got unexpected timestamp ", ". Timestamp should be between [", ", ", "}]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)record.timestamp()), BoxesRunTime.boxToLong((long)this.startingTimestamp$1), BoxesRunTime.boxToLong((long)this.now$1)})), (record.timestamp() >= this.startingTimestamp$1 && record.timestamp() <= this.now$1 ? 1 : 0) != 0);
                }
                Assert.assertEquals((long)offset, (long)record.offset());
                int keyAndValueIndex = this.startingKeyAndValueIndex$1 + i;
                Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})), (Object)new String((byte[])record.key()));
                Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})), (Object)new String((byte[])record.value()));
                Assert.assertEquals((long)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})).length(), (long)record.serializedKeySize());
                Assert.assertEquals((long)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})).length(), (long)record.serializedValueSize());
            }
            {
                this.startingOffset$1 = startingOffset$1;
                this.startingKeyAndValueIndex$1 = startingKeyAndValueIndex$1;
                this.startingTimestamp$1 = startingTimestamp$1;
                this.timestampType$1 = timestampType$1;
                this.tp$2 = tp$2;
                this.records$1 = records$1;
                this.now$1 = now$1;
            }
        });
    }

    public int consumeAndVerifyRecords$default$4() {
        return 0;
    }

    public long consumeAndVerifyRecords$default$5() {
        return 0L;
    }

    public TimestampType consumeAndVerifyRecords$default$6() {
        return TimestampType.CREATE_TIME;
    }

    public TopicPartition consumeAndVerifyRecords$default$7() {
        return this.tp();
    }

    public int consumeAndVerifyRecords$default$8() {
        return Integer.MAX_VALUE;
    }

    public <K, V> ArrayBuffer<ConsumerRecord<K, V>> consumeRecords(Consumer<K, V> consumer, int numRecords, int maxPollRecords) {
        ArrayBuffer records2 = new ArrayBuffer();
        int maxIters = numRecords * 300;
        int iters = 0;
        while (records2.size() < numRecords) {
            Iterable polledRecords = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(50L)).asScala();
            Assert.assertTrue((polledRecords.size() <= maxPollRecords ? 1 : 0) != 0);
            polledRecords.foreach((Function1)new Serializable(this, records2){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer records$2;

                public final ArrayBuffer<ConsumerRecord<K, V>> apply(ConsumerRecord<K, V> record) {
                    return this.records$2.$plus$eq(record);
                }
                {
                    this.records$2 = records$2;
                }
            });
            if (iters > maxIters) {
                throw new IllegalStateException(new StringBuilder().append((Object)"Failed to consume the expected records after ").append((Object)BoxesRunTime.boxToInteger((int)iters)).append((Object)" iterations.").toString());
            }
            ++iters;
        }
        return records2;
    }

    public <K, V> int consumeRecords$default$3() {
        return Integer.MAX_VALUE;
    }

    public <K, V> void awaitCommitCallback(Consumer<K, V> consumer, CountConsumerCommitCallback commitCallback, int count) {
        long started = System.currentTimeMillis();
        while (commitCallback.successCount() < count && System.currentTimeMillis() - started < 10000L) {
            consumer.poll(50L);
        }
        Assert.assertEquals((long)count, (long)commitCallback.successCount());
    }

    public <K, V> int awaitCommitCallback$default$3() {
        return 1;
    }

    public boolean isPartitionAssignmentValid(Buffer<Set<TopicPartition>> assignments, Set<TopicPartition> partitions) {
        boolean allNonEmptyAssignments = assignments.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Set<TopicPartition> assignment) {
                return assignment.nonEmpty();
            }
        });
        if (allNonEmptyAssignments) {
            Set uniqueAssignedPartitions;
            int n = 0;
            int totalPartitionsInAssignments = BoxesRunTime.unboxToInt((Object)assignments.$div$colon((Object)BoxesRunTime.boxToInteger((int)n), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(int x$2, Set<TopicPartition> x$3) {
                    return x$2 + x$3.size();
                }
            }));
            if (totalPartitionsInAssignments != partitions.size()) {
                return false;
            }
            Set set = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
            Set set2 = uniqueAssignedPartitions = (Set)assignments.$div$colon((Object)set, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Set<TopicPartition> apply(Set<TopicPartition> x$5, Set<TopicPartition> x$6) {
                    return (Set)x$5.$plus$plus(x$6);
                }
            });
            Set<TopicPartition> set3 = partitions;
            return !(set2 != null ? !set2.equals(set3) : set3 != null);
        }
        return false;
    }

    public BaseConsumerTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        IntegrationTestHarness$class.$init$(this);
        this.epsilon = 0.1;
        this.producerCount = 1;
        this.consumerCount = 2;
        this.serverCount = 3;
        this.topic = "topic";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.part2 = 1;
        this.tp2 = new TopicPartition(this.topic(), this.part2());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), "30000");
        this.producerConfig().setProperty("acks", "all");
        this.consumerConfig().setProperty("group.id", "my-test");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
    }

    public class ConsumerAssignmentPoller
    extends ShutdownableThread {
        public final Consumer<byte[], byte[]> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer;
        private volatile Set<TopicPartition> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        private List<String> topicsSubscription;
        private volatile boolean subscriptionChanged;
        private final ConsumerRebalanceListener rebalanceListener;
        public final /* synthetic */ BaseConsumerTest $outer;

        private Set<TopicPartition> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment() {
            return this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        }

        public void kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq(Set<TopicPartition> x$1) {
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = x$1;
        }

        private List<String> topicsSubscription() {
            return this.topicsSubscription;
        }

        private void topicsSubscription_$eq(List<String> x$1) {
            this.topicsSubscription = x$1;
        }

        private boolean subscriptionChanged() {
            return this.subscriptionChanged;
        }

        private void subscriptionChanged_$eq(boolean x$1) {
            this.subscriptionChanged = x$1;
        }

        public ConsumerRebalanceListener rebalanceListener() {
            return this.rebalanceListener;
        }

        public Set<TopicPartition> consumerAssignment() {
            return this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment();
        }

        public void subscribe(List<String> newTopicsToSubscribe) {
            if (this.subscriptionChanged()) {
                throw new IllegalStateException("Do not call subscribe until the previous subsribe request is processed.");
            }
            this.topicsSubscription_$eq(newTopicsToSubscribe);
            this.subscriptionChanged_$eq(true);
        }

        public boolean isSubscribeRequestProcessed() {
            return !this.subscriptionChanged();
        }

        /*
         * WARNING - void declaration
         */
        public boolean initiateShutdown() {
            void var1_1;
            boolean res = super.initiateShutdown();
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.wakeup();
            return (boolean)var1_1;
        }

        public void doWork() {
            if (this.subscriptionChanged()) {
                this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.topicsSubscription()).asJava(), this.rebalanceListener());
                this.subscriptionChanged_$eq(false);
            }
            try {
                this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.poll(50L);
            }
            catch (WakeupException wakeupException) {}
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$$outer() {
            return this.$outer;
        }

        public ConsumerAssignmentPoller(BaseConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer = consumer;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super("daemon-consumer-assignment", false);
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = Predef$.MODULE$.Set().empty();
            this.topicsSubscription = topicsToSubscribe;
            this.subscriptionChanged = false;
            this.rebalanceListener = new ConsumerAssignmentPoller$$anon$1(this);
            consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), this.rebalanceListener());
        }
    }

    public class CountConsumerCommitCallback
    implements OffsetCommitCallback {
        private int successCount;
        private int failCount;

        public int successCount() {
            return this.successCount;
        }

        public void successCount_$eq(int x$1) {
            this.successCount = x$1;
        }

        public int failCount() {
            return this.failCount;
        }

        public void failCount_$eq(int x$1) {
            this.failCount = x$1;
        }

        public void onComplete(Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            if (exception == null) {
                this.successCount_$eq(this.successCount() + 1);
            } else {
                this.failCount_$eq(this.failCount() + 1);
            }
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$CountConsumerCommitCallback$$$outer() {
            return BaseConsumerTest.this;
        }

        public CountConsumerCommitCallback() {
            if (BaseConsumerTest.this == null) {
                throw new NullPointerException();
            }
            this.successCount = 0;
            this.failCount = 0;
        }
    }

    public class TestConsumerReassignmentListener
    implements ConsumerRebalanceListener {
        private int callsToAssigned;
        private int callsToRevoked;

        public int callsToAssigned() {
            return this.callsToAssigned;
        }

        public void callsToAssigned_$eq(int x$1) {
            this.callsToAssigned = x$1;
        }

        public int callsToRevoked() {
            return this.callsToRevoked;
        }

        public void callsToRevoked_$eq(int x$1) {
            this.callsToRevoked = x$1;
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "onPartitionsAssigned called.";
                }
            });
            this.callsToAssigned_$eq(this.callsToAssigned() + 1);
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "onPartitionsRevoked called.";
                }
            });
            this.callsToRevoked_$eq(this.callsToRevoked() + 1);
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer() {
            return BaseConsumerTest.this;
        }

        public TestConsumerReassignmentListener() {
            if (BaseConsumerTest.this == null) {
                throw new NullPointerException();
            }
            this.callsToAssigned = 0;
            this.callsToRevoked = 0;
        }
    }
}

