/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminClient;
import kafka.admin.AdminClient$;
import kafka.api.ConsumerBounceTest$;
import kafka.api.FixedPortTestUtils$;
import kafka.api.IntegrationTestHarness;
import kafka.api.IntegrationTestHarness$class;
import kafka.cluster.Replica;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.ReplicaManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tud\u0001B\u0001\u0003\u0001\u001d\u0011!cQ8ogVlWM\u001d\"pk:\u001cW\rV3ti*\u00111\u0001B\u0001\u0004CBL'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\n\u0017!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!A\u0003&V]&$8+^5uKB\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tgB\u0011qCG\u0007\u00021)\u0011\u0011\u0004B\u0001\u0006kRLGn]\u0005\u00037a\u0011q\u0001T8hO&tw\rC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u00111\u0003\u0001\u0005\bC\u0001\u0011\r\u0011\"\u0001#\u00035\u0001(o\u001c3vG\u0016\u00148i\\;oiV\t1\u0005\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASEA\u0002J]RDaA\u000b\u0001!\u0002\u0013\u0019\u0013A\u00049s_\u0012,8-\u001a:D_VtG\u000f\t\u0005\bY\u0001\u0011\r\u0011\"\u0001#\u00035\u0019wN\\:v[\u0016\u00148i\\;oi\"1a\u0006\u0001Q\u0001\n\r\nabY8ogVlWM]\"pk:$\b\u0005C\u00041\u0001\t\u0007I\u0011\u0001\u0012\u0002\u0017M,'O^3s\u0007>,h\u000e\u001e\u0005\u0007e\u0001\u0001\u000b\u0011B\u0012\u0002\u0019M,'O^3s\u0007>,h\u000e\u001e\u0011\t\u000fQ\u0002!\u0019!C\u0001k\u0005)Ao\u001c9jGV\ta\u0007\u0005\u00028y5\t\u0001H\u0003\u0002:u\u0005!A.\u00198h\u0015\u0005Y\u0014\u0001\u00026bm\u0006L!!\u0010\u001d\u0003\rM#(/\u001b8h\u0011\u0019y\u0004\u0001)A\u0005m\u00051Ao\u001c9jG\u0002Bq!\u0011\u0001C\u0002\u0013\u0005!%\u0001\u0003qCJ$\bBB\"\u0001A\u0003%1%A\u0003qCJ$\b\u0005C\u0004F\u0001\t\u0007I\u0011\u0001$\u0002\u0005Q\u0004X#A$\u0011\u0005!sU\"A%\u000b\u0005)[\u0015AB2p[6|gN\u0003\u0002\u0006\u0019*\u0011QJD\u0001\u0007CB\f7\r[3\n\u0005=K%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007#\u0002\u0001\u000b\u0011B$\u0002\u0007Q\u0004\b\u0005C\u0004T\u0001\t\u0007I\u0011\u0001\u0012\u0002'\u001d\u0014\u0018mY3gk2\u001cEn\\:f)&lW-T:\t\rU\u0003\u0001\u0015!\u0003$\u0003Q9'/Y2fMVd7\t\\8tKRKW.Z'tA!9q\u000b\u0001b\u0001\n\u0003A\u0016\u0001C3yK\u000e,Ho\u001c:\u0016\u0003e\u0003\"AW0\u000e\u0003mS!\u0001X/\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002_u\u0005!Q\u000f^5m\u0013\t\u00017L\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016DaA\u0019\u0001!\u0002\u0013I\u0016!C3yK\u000e,Ho\u001c:!\u0011\u0015!\u0007\u0001\"\u0011f\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cH#\u00014\u0011\u0007\u001d|'O\u0004\u0002i[:\u0011\u0011\u000e\\\u0007\u0002U*\u00111NB\u0001\u0007yI|w\u000e\u001e \n\u0003\u0019J!A\\\u0013\u0002\u000fA\f7m[1hK&\u0011\u0001/\u001d\u0002\u0004'\u0016\f(B\u00018&!\t\u0019h/D\u0001u\u0015\t)H!\u0001\u0004tKJ4XM]\u0005\u0003oR\u00141bS1gW\u0006\u001cuN\u001c4jO\")\u0011\u0010\u0001C!u\u0006)1/\u001a;VaR\t1\u0010\u0005\u0002%y&\u0011Q0\n\u0002\u0005+:LG\u000f\u000b\u0002y\u007fB!\u0011\u0011AA\u0003\u001b\t\t\u0019A\u0003\u0002\f\u001d%!\u0011qAA\u0002\u0005\u0019\u0011UMZ8sK\"1\u00111\u0002\u0001\u0005Bi\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0005\u0003\u0013\ty\u0001\u0005\u0003\u0002\u0002\u0005E\u0011\u0002BA\n\u0003\u0007\u0011Q!\u00114uKJDa!a\u0006\u0001\t\u0003Q\u0018!\t;fgR\u001cuN\\:v[B$\u0018n\u001c8XSRD'I]8lKJ4\u0015-\u001b7ve\u0016\u001c\b\u0006BA\u000b\u00037\u0001B!!\u0001\u0002\u001e%!\u0011qDA\u0002\u0005\u0011!Vm\u001d;\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&\u0005I2m\u001c8tk6,w+\u001b;i\u0005J|7.\u001a:GC&dWO]3t)\rY\u0018q\u0005\u0005\b\u0003S\t\t\u00031\u0001$\u0003!qW/\\%uKJ\u001c\bBBA\u0017\u0001\u0011\u0005!0A\u0012uKN$8+Z3l\u0003:$7i\\7nSR<\u0016\u000e\u001e5Ce>\\WM\u001d$bS2,(/Z:)\t\u0005-\u00121\u0004\u0005\b\u0003g\u0001A\u0011AA\u001b\u0003}\u0019X-Z6B]\u0012\u001cu.\\7ji^KG\u000f\u001b\"s_.,'OR1jYV\u0014Xm\u001d\u000b\u0004w\u0006]\u0002bBA\u0015\u0003c\u0001\ra\t\u0005\u0007\u0003w\u0001A\u0011\u0001>\u0002CQ,7\u000f^*vEN\u001c'/\u001b2f/\",g\u000eV8qS\u000e,f.\u0019<bS2\f'\r\\3)\t\u0005e\u00121\u0004\u0005\u0007\u0003\u0003\u0002A\u0011\u0001>\u0002\u0013Q,7\u000f^\"m_N,\u0007\u0006BA \u00037Aq!a\u0012\u0001\t\u0013\tI%\u0001\ndQ\u0016\u001c7n\u00117pg\u0016<un\u001c3QCRDG#B>\u0002L\u0005=\u0003bBA'\u0003\u000b\u0002\raI\u0001\u000b]Vl'+Z2pe\u0012\u001c\b\u0002CA)\u0003\u000b\u0002\r!a\u0015\u0002\u000f\u001d\u0014x.\u001e9JIB!\u0011QKA.\u001d\r!\u0013qK\u0005\u0004\u00033*\u0013A\u0002)sK\u0012,g-C\u0002>\u0003;R1!!\u0017&\u0011\u001d\t\t\u0007\u0001C\u0005\u0003G\n\u0001e\u00195fG.\u001cEn\\:f/&$\bnQ8pe\u0012Lg.\u0019;pe\u001a\u000b\u0017\u000e\\;sKR910!\u001a\u0002h\u0005-\u0004bBA'\u0003?\u0002\ra\t\u0005\t\u0003S\ny\u00061\u0001\u0002T\u0005aA-\u001f8b[&\u001cwI]8va\"A\u0011QNA0\u0001\u0004\t\u0019&A\u0006nC:,\u0018\r\\$s_V\u0004\bbBA9\u0001\u0011%\u00111O\u0001\u001dG\",7m[\"m_N,w+\u001b;i\u00072,8\u000f^3s\r\u0006LG.\u001e:f)\u001dY\u0018QOA<\u0003wBq!!\u0014\u0002p\u0001\u00071\u0005\u0003\u0005\u0002z\u0005=\u0004\u0019AA*\u0003\u00199'o\\;qc!A\u0011QPA8\u0001\u0004\t\u0019&\u0001\u0004he>,\bO\r\u0005\u0007\u0003\u0003\u0003A\u0011\u0001>\u00021Q,7\u000f^\"m_N,G)\u001e:j]\u001e\u0014VMY1mC:\u001cW\r\u000b\u0003\u0002\u0000\u0005m\u0001bBAD\u0001\u0011%\u0011\u0011R\u0001\u001aG\",7m[\"m_N,G)\u001e:j]\u001e\u0014VMY1mC:\u001cW\rF\u0005|\u0003\u0017\u000bi)a$\u0002\u0018\"A\u0011\u0011KAC\u0001\u0004\t\u0019\u0006C\u00045\u0003\u000b\u0003\r!a\u0015\t\u000f]\u000b)\t1\u0001\u0002\u0012B\u0019!,a%\n\u0007\u0005U5LA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011!\tI*!\"A\u0002\u0005m\u0015a\u00072s_.,'o]!wC&d\u0017M\u00197f\tV\u0014\u0018N\\4DY>\u001cX\rE\u0002%\u0003;K1!a(&\u0005\u001d\u0011un\u001c7fC:Dq!a)\u0001\t\u0013\t)+\u0001\bde\u0016\fG/Z\"p]N,X.\u001a:\u0015\t\u0005\u001d\u00161\u0019\t\t\u0003S\u000b\u0019,a.\u000286\u0011\u00111\u0016\u0006\u0005\u0003[\u000by+\u0001\u0005d_:\u001cX/\\3s\u0015\r\t\tlS\u0001\bG2LWM\u001c;t\u0013\u0011\t),a+\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s!\u0015!\u0013\u0011XA_\u0013\r\tY,\n\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004I\u0005}\u0016bAAaK\t!!)\u001f;f\u0011!\t\t&!)A\u0002\u0005M\u0003bBAd\u0001\u0011%\u0011\u0011Z\u0001\u0019GJ,\u0017\r^3D_:\u001cX/\\3s\u0003:$'+Z2fSZ,G\u0003CAT\u0003\u0017\fi-!5\t\u0011\u0005E\u0013Q\u0019a\u0001\u0003'B\u0001\"a4\u0002F\u0002\u0007\u00111T\u0001\r[\u0006tW/\u00197BgNLwM\u001c\u0005\b\u0003\u001b\n)\r1\u0001$\u0011\u001d\t)\u000e\u0001C\u0005\u0003/\faB]3dK&4XMU3d_J$7\u000fF\u0005|\u00033\fY.!8\u0002`\"A\u0011QVAj\u0001\u0004\t9\u000bC\u0004\u0002N\u0005M\u0007\u0019A\u0012\t\u0013Q\n\u0019\u000e%AA\u0002\u0005M\u0003BCAq\u0003'\u0004\n\u00111\u0001\u0002d\u0006IA/[7f_V$Xj\u001d\t\u0004I\u0005\u0015\u0018bAAtK\t!Aj\u001c8h\u0011\u001d\tY\u000f\u0001C\u0005\u0003[\fac];c[&$8\t\\8tK\u0006sGMV1mS\u0012\fG/\u001a\u000b\u000b\u0003_\fY0!@\u0003\u0002\t-\u0001#\u0002.\u0002r\u0006U\u0018bAAz7\n1a)\u001e;ve\u0016\u00042\u0001JA|\u0013\r\tI0\n\u0002\u0004\u0003:L\b\u0002CAW\u0003S\u0004\r!a*\t\u0011\u0005}\u0018\u0011\u001ea\u0001\u0003G\fab\u00197pg\u0016$\u0016.\\3pkRl5\u000f\u0003\u0005\u0003\u0004\u0005%\b\u0019\u0001B\u0003\u00039i\u0017N\\\"m_N,G+[7f\u001bN\u0004R\u0001\nB\u0004\u0003GL1A!\u0003&\u0005\u0019y\u0005\u000f^5p]\"A!QBAu\u0001\u0004\u0011)!\u0001\bnCb\u001cEn\\:f)&lW-T:\t\u000f\tE\u0001\u0001\"\u0003\u0003\u0014\u0005\u00012\r[3dW\u000ecwn]3e'R\fG/\u001a\u000b\u0006w\nU!q\u0003\u0005\t\u0003#\u0012y\u00011\u0001\u0002T!9!\u0011\u0004B\b\u0001\u0004\u0019\u0013\u0001E2p[6LG\u000f^3e%\u0016\u001cwN\u001d3t\r\u0019\u0011i\u0002\u0001\u0003\u0003 \t)\"i\\;oG\u0016\u0014%o\\6feN\u001b\u0007.\u001a3vY\u0016\u00148\u0003\u0002B\u000e\u0005C\u00012a\u0006B\u0012\u0013\r\u0011)\u0003\u0007\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG\r\u0003\u0006\u0002*\tm!Q1A\u0005\u0002\tB!Ba\u000b\u0003\u001c\t\u0005\t\u0015!\u0003$\u0003%qW/\\%uKJ\u001c\b\u0005C\u0004\u001e\u00057!\tAa\f\u0015\t\tE\"Q\u0007\t\u0005\u0005g\u0011Y\"D\u0001\u0001\u0011\u001d\tIC!\fA\u0002\rB\u0011B!\u000f\u0003\u001c\u0001\u0007I\u0011\u0001\u0012\u0002\t%$XM\u001d\u0005\u000b\u0005{\u0011Y\u00021A\u0005\u0002\t}\u0012\u0001C5uKJ|F%Z9\u0015\u0007m\u0014\t\u0005C\u0005\u0003D\tm\u0012\u0011!a\u0001G\u0005\u0019\u0001\u0010J\u0019\t\u0011\t\u001d#1\u0004Q!\n\r\nQ!\u001b;fe\u0002BqAa\u0013\u0003\u001c\u0011\u0005#0\u0001\u0004e_^{'o\u001b\u0005\b\u0005\u001f\u0002A\u0011\u0002B)\u0003-\u0019XM\u001c3SK\u000e|'\u000fZ:\u0015\u000bm\u0014\u0019F!\u0016\t\u000f\u00055#Q\na\u0001G!IAG!\u0014\u0011\u0002\u0003\u0007\u00111\u000b\u0005\n\u00053\u0002\u0011\u0013!C\u0005\u00057\nQc]3oIJ+7m\u001c:eg\u0012\"WMZ1vYR$#'\u0006\u0002\u0003^)\"\u00111\u000bB0W\t\u0011\t\u0007\u0005\u0003\u0003d\t5TB\u0001B3\u0015\u0011\u00119G!\u001b\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B6K\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t=$Q\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003B:\u0001E\u0005I\u0011\u0002B.\u0003a\u0011XmY3jm\u0016\u0014VmY8sIN$C-\u001a4bk2$He\r\u0005\n\u0005o\u0002\u0011\u0013!C\u0005\u0005s\n\u0001D]3dK&4XMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011YH\u000b\u0003\u0002d\n}\u0003")
public class ConsumerBounceTest
extends JUnitSuite
implements IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final String topic;
    private final int part;
    private final TopicPartition tp;
    private final int gracefulCloseTimeMs;
    private final ScheduledExecutorService executor;
    private final Properties producerConfig;
    private final Properties consumerConfig;
    private final Properties serverConfig;
    private final Buffer<KafkaConsumer<byte[], byte[]>> consumers;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile byte bitmap$0;

    private Properties producerConfig$lzycompute() {
        ConsumerBounceTest consumerBounceTest = this;
        synchronized (consumerBounceTest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.producerConfig = IntegrationTestHarness$class.producerConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.producerConfig;
        }
    }

    @Override
    public Properties producerConfig() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.producerConfig$lzycompute() : this.producerConfig;
    }

    private Properties consumerConfig$lzycompute() {
        ConsumerBounceTest consumerBounceTest = this;
        synchronized (consumerBounceTest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.consumerConfig = IntegrationTestHarness$class.consumerConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.consumerConfig;
        }
    }

    @Override
    public Properties consumerConfig() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.consumerConfig$lzycompute() : this.consumerConfig;
    }

    private Properties serverConfig$lzycompute() {
        ConsumerBounceTest consumerBounceTest = this;
        synchronized (consumerBounceTest) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.serverConfig = IntegrationTestHarness$class.serverConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.serverConfig;
        }
    }

    @Override
    public Properties serverConfig() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.serverConfig$lzycompute() : this.serverConfig;
    }

    @Override
    public Buffer<KafkaConsumer<byte[], byte[]>> consumers() {
        return this.consumers;
    }

    @Override
    public Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    @Override
    public void kafka$api$IntegrationTestHarness$$super$setUp() {
        KafkaServerTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$api$IntegrationTestHarness$$super$tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$api$IntegrationTestHarness$_setter_$consumers_$eq(Buffer x$1) {
        this.consumers = x$1;
    }

    @Override
    public void kafka$api$IntegrationTestHarness$_setter_$producers_$eq(Buffer x$1) {
        this.producers = x$1;
    }

    @Override
    public KafkaProducer<byte[], byte[]> createNewProducer() {
        return IntegrationTestHarness$class.createNewProducer(this);
    }

    @Override
    public KafkaConsumer<byte[], byte[]> createNewConsumer() {
        return IntegrationTestHarness$class.createNewConsumer(this);
    }

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        KafkaServerTestHarness$class.configureSecurityBeforeServersStart(this);
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public int boundPort(KafkaServer server) {
        return KafkaServerTestHarness$class.boundPort(this, server);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public ListenerName listenerName() {
        return KafkaServerTestHarness$class.listenerName(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> serverSaslProperties() {
        return KafkaServerTestHarness$class.serverSaslProperties(this);
    }

    @Override
    public Option<Properties> clientSaslProperties() {
        return KafkaServerTestHarness$class.clientSaslProperties(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void killBroker(int index) {
        KafkaServerTestHarness$class.killBroker(this, index);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ConsumerBounceTest consumerBounceTest = this;
        synchronized (consumerBounceTest) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int gracefulCloseTimeMs() {
        return this.gracefulCloseTimeMs;
    }

    public ScheduledExecutorService executor() {
        return this.executor;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.serverCount(), this.zkConnect(), false, FixedPortTestUtils$.MODULE$.createBrokerConfigs$default$4()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.serverConfig());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @Before
    public void setUp() {
        IntegrationTestHarness$class.setUp(this);
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
    }

    @Override
    @After
    public void tearDown() {
        try {
            this.executor().shutdownNow();
            return;
        }
        finally {
            IntegrationTestHarness$class.tearDown(this);
        }
    }

    @Test
    public void testConsumptionWithBrokerFailures() {
        this.consumeWithBrokerFailures(10);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void consumeWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        this.sendRecords(numRecords, this.sendRecords$default$2());
        this.producers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaProducer<byte[], byte[]> x$2) {
                x$2.close();
            }
        });
        LongRef consumed = new LongRef(0L);
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.subscribe(Collections.singletonList(this.topic()));
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (true) {
            if (!scheduler.isRunning().get()) {
                scheduler.shutdown();
                return;
            }
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)consumer.poll(100L)).asScala()).foreach((Function1)new Serializable(this, consumed){
                public static final long serialVersionUID = 0L;
                private final LongRef consumed$1;

                public final void apply(ConsumerRecord<byte[], byte[]> record) {
                    Assert.assertEquals((long)this.consumed$1.elem, (long)record.offset());
                    ++this.consumed$1.elem;
                }
                {
                    this.consumed$1 = consumed$1;
                }
            });
            {
                consumer.commitSync();
                Assert.assertEquals((long)consumer.position(this.tp()), (long)consumer.committed(this.tp()).offset());
                if (consumer.position(this.tp()) != (long)numRecords) continue;
                consumer.seekToBeginning(Collections.emptyList());
                consumed.elem = 0L;
                continue;
            }
            break;
        }
    }

    @Test
    public void testSeekAndCommitWithBrokerFailures() {
        this.seekAndCommitWithBrokerFailures(5);
    }

    public void seekAndCommitWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        this.sendRecords(numRecords, this.sendRecords$default$2());
        this.producers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaProducer<byte[], byte[]> x$3) {
                x$3.close();
            }
        });
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.assign(Collections.singletonList(this.tp()));
        consumer.seek(this.tp(), 0L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, numRecords){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            public final int numRecords$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$seekAndCommitWithBrokerFailures$1 $outer;

                    public final boolean apply(KafkaServer server) {
                        int x$6;
                        TopicPartition x$5;
                        ReplicaManager qual$1 = server.replicaManager();
                        return ((Replica)qual$1.getReplica(x$5 = this.$outer.kafka$api$ConsumerBounceTest$$anonfun$$$outer().tp(), x$6 = qual$1.getReplica$default$2()).get()).highWatermark().messageOffset() == (long)this.$outer.numRecords$1;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.numRecords$1 = numRecords$1;
            }
        }, "Failed to update high watermark for followers after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning().get()) {
            int coin = TestUtils$.MODULE$.random().nextInt(3);
            if (coin == 0) {
                this.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Seeking to end of log";
                    }
                });
                consumer.seekToEnd(Collections.emptyList());
                Assert.assertEquals((long)numRecords, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin == 1) {
                long pos = TestUtils$.MODULE$.random().nextInt(numRecords);
                this.info((Function0<String>)new Serializable(this, pos){
                    public static final long serialVersionUID = 0L;
                    private final long pos$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Seeking to ").append((Object)BoxesRunTime.boxToLong((long)this.pos$1)).toString();
                    }
                    {
                        this.pos$1 = pos$1;
                    }
                });
                consumer.seek(this.tp(), pos);
                Assert.assertEquals((long)pos, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin != 2) continue;
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Committing offset.";
                }
            });
            consumer.commitSync();
            Assert.assertEquals((long)consumer.position(this.tp()), (long)consumer.committed(this.tp()).offset());
        }
    }

    @Test
    public void testSubscribeWhenTopicUnavailable() {
        int numRecords = 1000;
        String newtopic = "newtopic";
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        consumer.subscribe(Collections.singleton(newtopic));
        this.executor().schedule(new Runnable(this, newtopic){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final String newtopic$1;

            public void run() {
                TestUtils$.MODULE$.createTopic(this.$outer.zkUtils(), this.newtopic$1, this.$outer.serverCount(), this.$outer.serverCount(), (Seq<KafkaServer>)this.$outer.servers(), TestUtils$.MODULE$.createTopic$default$6());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newtopic$1 = newtopic$1;
            }
        }, 2L, TimeUnit.SECONDS);
        consumer.poll(0L);
        this.sendRecords$1(numRecords, newtopic);
        this.kafka$api$ConsumerBounceTest$$receiveRecords((KafkaConsumer<byte[], byte[]>)consumer, numRecords, newtopic, 10000L);
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.killBroker(server.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Thread.sleep(500L);
        this.restartDeadBrokers();
        Future<?> future = this.executor().submit(new Runnable(this, numRecords, newtopic, consumer){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final int numRecords$2;
            private final String newtopic$1;
            private final KafkaConsumer consumer$1;

            public void run() {
                this.$outer.kafka$api$ConsumerBounceTest$$receiveRecords((KafkaConsumer<byte[], byte[]>)this.consumer$1, this.numRecords$2, this.newtopic$1, 10000L);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.numRecords$2 = numRecords$2;
                this.newtopic$1 = newtopic$1;
                this.consumer$1 = consumer$1;
            }
        });
        this.sendRecords$1(numRecords, newtopic);
        future.get();
    }

    @Test
    public void testClose() {
        int numRecords = 10;
        this.sendRecords(numRecords, this.sendRecords$default$2());
        this.checkCloseGoodPath(numRecords, "group1");
        this.checkCloseWithCoordinatorFailure(numRecords, "group2", "group3");
        this.checkCloseWithClusterFailure(numRecords, "group4", "group5");
    }

    private void checkCloseGoodPath(int numRecords, String groupId) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerAndReceive(groupId, false, numRecords);
        Future<Object> future = this.submitCloseAndValidate(consumer, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        future.get();
        this.checkClosedState(groupId, numRecords);
    }

    private void checkCloseWithCoordinatorFailure(int numRecords, String dynamicGroup, String manualGroup) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(dynamicGroup, false, numRecords);
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(manualGroup, true, numRecords);
        AdminClient adminClient = AdminClient$.MODULE$.createSimplePlaintext(this.brokerList());
        this.killBroker(adminClient.findCoordinator(dynamicGroup).id());
        this.killBroker(adminClient.findCoordinator(manualGroup).id());
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        future1.get();
        future2.get();
        this.restartDeadBrokers();
        this.checkClosedState(dynamicGroup, 0);
        this.checkClosedState(manualGroup, numRecords);
    }

    private void checkCloseWithClusterFailure(int numRecords, String group1, String group2) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(group1, false, numRecords);
        int requestTimeout = 6000;
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)requestTimeout)).toString());
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(group2, true, numRecords);
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.killBroker(server.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        int closeTimeout = 2000;
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, closeTimeout, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)));
        future1.get();
        future2.get();
    }

    @Test
    public void testCloseDuringRebalance() {
        String topic = "closetest";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 10, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.checkCloseDuringRebalance("group1", topic, this.executor(), true);
    }

    private void checkCloseDuringRebalance(String groupId, String topic, ExecutorService executor, boolean brokersAvailableDuringClose) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumer(groupId);
        this.waitForRebalance$1(2000L, this.subscribeAndPoll$1(consumer1, this.subscribeAndPoll$default$2$1(), topic, executor), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[0]));
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumer(groupId);
        this.waitForRebalance$1(2000L, this.subscribeAndPoll$1(consumer2, this.subscribeAndPoll$default$2$1(), topic, executor), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer1}));
        Future rebalanceFuture = this.createConsumerToRebalance$1(groupId, topic, executor);
        this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.gracefulCloseTimeMs())));
        this.waitForRebalance$1(2000L, rebalanceFuture, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer2}));
        this.createConsumerToRebalance$1(groupId, topic, executor);
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.killBroker(server.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
    }

    private KafkaConsumer<byte[], byte[]> createConsumer(String groupId) {
        this.consumerConfig().setProperty("group.id", groupId);
        return this.createNewConsumer();
    }

    private KafkaConsumer<byte[], byte[]> createConsumerAndReceive(String groupId, boolean manualAssign, int numRecords) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumer(groupId);
        if (manualAssign) {
            consumer.assign(Collections.singleton(this.tp()));
        } else {
            consumer.subscribe(Collections.singleton(this.topic()));
        }
        this.kafka$api$ConsumerBounceTest$$receiveRecords(consumer, numRecords, this.receiveRecords$default$3(), this.receiveRecords$default$4());
        return consumer;
    }

    public void kafka$api$ConsumerBounceTest$$receiveRecords(KafkaConsumer<byte[], byte[]> consumer, int numRecords, String topic, long timeoutMs) {
        long received;
        long endTimeMs = System.currentTimeMillis() + timeoutMs;
        for (received = 0L; received < (long)numRecords && System.currentTimeMillis() < endTimeMs; received += (long)consumer.poll(1000L).count()) {
        }
        Assert.assertEquals((long)numRecords, (long)received);
    }

    private String receiveRecords$default$3() {
        return this.topic();
    }

    private long receiveRecords$default$4() {
        return 60000L;
    }

    private Future<Object> submitCloseAndValidate(KafkaConsumer<byte[], byte[]> consumer, long closeTimeoutMs, Option<Object> minCloseTimeMs, Option<Object> maxCloseTimeMs) {
        return this.executor().submit(CoreUtils$.MODULE$.runnable((Function0)new Serializable(this, consumer, closeTimeoutMs, minCloseTimeMs, maxCloseTimeMs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final KafkaConsumer consumer$2;
            public final long closeTimeoutMs$1;
            private final Option minCloseTimeMs$1;
            private final Option maxCloseTimeMs$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option option;
                block4: {
                    Option option2;
                    block7: {
                        long timeTakenMs;
                        block6: {
                            block5: {
                                block3: {
                                    block2: {
                                        int closeGraceTimeMs = 2000;
                                        long startNanos = System.nanoTime();
                                        this.$outer.info((Function0<String>)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$submitCloseAndValidate$1 $outer;

                                            public final String apply() {
                                                return new StringBuilder().append((Object)"Closing consumer with timeout ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.closeTimeoutMs$1)).append((Object)" ms.").toString();
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                        this.consumer$2.close(this.closeTimeoutMs$1, TimeUnit.MILLISECONDS);
                                        timeTakenMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                                        option = this.maxCloseTimeMs$1;
                                        if (!(option instanceof Some)) break block2;
                                        Some some = (Some)option;
                                        long ms = BoxesRunTime.unboxToLong((Object)some.x());
                                        Assert.assertTrue((String)new StringBuilder().append((Object)"Close took too long ").append((Object)BoxesRunTime.boxToLong((long)timeTakenMs)).toString(), (timeTakenMs < ms + (long)closeGraceTimeMs ? 1 : 0) != 0);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block3;
                                    }
                                    None$ none$ = None$.MODULE$;
                                    Option option3 = option;
                                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                                option2 = this.minCloseTimeMs$1;
                                if (!(option2 instanceof Some)) break block5;
                                Some some = (Some)option2;
                                long ms = BoxesRunTime.unboxToLong((Object)some.x());
                                Assert.assertTrue((String)new StringBuilder().append((Object)"Close finished too quickly ").append((Object)BoxesRunTime.boxToLong((long)timeTakenMs)).toString(), (timeTakenMs >= ms ? 1 : 0) != 0);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block6;
                            }
                            None$ none$ = None$.MODULE$;
                            Option option4 = option2;
                            if (none$ != null ? !none$.equals(option4) : option4 != null) break block7;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        this.$outer.info((Function0<String>)new Serializable(this, timeTakenMs){
                            public static final long serialVersionUID = 0L;
                            private final long timeTakenMs$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"consumer.close() completed in ").append((Object)BoxesRunTime.boxToLong((long)this.timeTakenMs$1)).append((Object)" ms.").toString();
                            }
                            {
                                this.timeTakenMs$1 = timeTakenMs$1;
                            }
                        });
                        return;
                    }
                    throw new MatchError((Object)option2);
                }
                throw new MatchError((Object)option);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.consumer$2 = consumer$2;
                this.closeTimeoutMs$1 = closeTimeoutMs$1;
                this.minCloseTimeMs$1 = minCloseTimeMs$1;
                this.maxCloseTimeMs$1 = maxCloseTimeMs$1;
            }
        }), BoxesRunTime.boxToInteger((int)0));
    }

    private void checkClosedState(String groupId, int committedRecords) {
        Semaphore assignSemaphore = new Semaphore(0);
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumer(groupId);
        consumer.subscribe(Collections.singletonList(this.topic()), new ConsumerRebalanceListener(this, assignSemaphore){
            private final Semaphore assignSemaphore$1;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.assignSemaphore$1.release();
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.assignSemaphore$1 = assignSemaphore$1;
            }
        });
        consumer.poll(3000L);
        Assert.assertTrue((String)"Assigment did not complete on time", (boolean)assignSemaphore.tryAcquire(1L, TimeUnit.SECONDS));
        if (committedRecords > 0) {
            Assert.assertEquals((long)committedRecords, (long)consumer.committed(this.tp()).offset());
        }
        consumer.close();
    }

    private void sendRecords(int numRecords, String topic) {
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final String topic$1;

            public final Future<RecordMetadata> apply(int i) {
                return ((KafkaProducer)this.$outer.producers().head()).send(new ProducerRecord(this.topic$1, Predef$.MODULE$.int2Integer(this.$outer.part()), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        futures.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$4) {
                return x$4.get();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private String sendRecords$default$2() {
        return this.topic();
    }

    private final void sendRecords$1(int numRecords, String topic) {
        IntRef remainingRecords = new IntRef(numRecords);
        long endTimeMs = System.currentTimeMillis() + 20000L;
        while (remainingRecords.elem > 0 && System.currentTimeMillis() < endTimeMs) {
            IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), remainingRecords.elem).map((Function1)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ConsumerBounceTest $outer;
                private final String topic$2;

                public final Future<RecordMetadata> apply(int i) {
                    return ((KafkaProducer)this.$outer.producers().head()).send(new ProducerRecord(this.topic$2, Predef$.MODULE$.int2Integer(this.$outer.part()), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.topic$2 = topic$2;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            futures.map((Function1)new Serializable(this, remainingRecords){
                public static final long serialVersionUID = 0L;
                private final IntRef remainingRecords$1;

                public final void apply(Future<RecordMetadata> future) {
                    try {
                        future.get();
                        --this.remainingRecords$1.elem;
                    }
                    catch (Exception exception) {}
                }
                {
                    this.remainingRecords$1 = remainingRecords$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
        }
        Assert.assertEquals((long)0L, (long)remainingRecords.elem);
    }

    private final String sendRecords$default$2$1() {
        return this.topic();
    }

    private final Future subscribeAndPoll$1(KafkaConsumer consumer, Option revokeSemaphore, String topic$3, ExecutorService executor$1) {
        return executor$1.submit(CoreUtils$.MODULE$.runnable((Function0)new Serializable(this, topic$3, consumer, revokeSemaphore){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final KafkaConsumer consumer$3;
            public final Option revokeSemaphore$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.consumer$3.subscribe(Collections.singletonList(this.topic$3), new ConsumerRebalanceListener(this){
                    private final /* synthetic */ $anonfun$subscribeAndPoll$1$1 $outer;

                    public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    }

                    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                        this.$outer.revokeSemaphore$1.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Semaphore s) {
                                s.release();
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.consumer$3.poll(0L);
            }
            {
                this.topic$3 = topic$3;
                this.consumer$3 = consumer$3;
                this.revokeSemaphore$1 = revokeSemaphore$1;
            }
        }), BoxesRunTime.boxToInteger((int)0));
    }

    private final Option subscribeAndPoll$default$2$1() {
        return None$.MODULE$;
    }

    private final void waitForRebalance$1(long timeoutMs, Future future, Seq otherConsumers) {
        long startMs = System.currentTimeMillis();
        while (System.currentTimeMillis() < startMs + timeoutMs && !future.isDone()) {
            otherConsumers.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ConsumerRecords<byte[], byte[]> apply(KafkaConsumer<byte[], byte[]> consumer) {
                    return consumer.poll(100L);
                }
            });
        }
        Assert.assertTrue((String)"Rebalance did not complete in time", (boolean)future.isDone());
    }

    private final Future createConsumerToRebalance$1(String groupId$1, String topic$3, ExecutorService executor$1) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumer(groupId$1);
        Semaphore rebalanceSemaphore = new Semaphore(0);
        Future future = this.subscribeAndPoll$1(consumer, (Option)new Some((Object)rebalanceSemaphore), topic$3, executor$1);
        Assert.assertTrue((String)"Rebalance not triggered", (boolean)rebalanceSemaphore.tryAcquire(2000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((String)"Rebalance completed too early", (boolean)future.isDone());
        return future;
    }

    public ConsumerBounceTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        IntegrationTestHarness$class.$init$(this);
        this.producerCount = 1;
        this.consumerCount = 2;
        this.serverCount = 3;
        this.topic = "topic";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.gracefulCloseTimeMs = 1000;
        this.executor = Executors.newScheduledThreadPool(2);
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        this.producerConfig().setProperty("acks", "all");
        this.consumerConfig().setProperty("group.id", "my-test");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)4096)).toString());
        this.consumerConfig().setProperty("session.timeout.ms", "10000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "3000");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
    }

    public class BounceBrokerScheduler
    extends ShutdownableThread {
        private final int numIters;
        private int iter;
        public final /* synthetic */ ConsumerBounceTest $outer;

        public int numIters() {
            return this.numIters;
        }

        public int iter() {
            return this.iter;
        }

        public void iter_$eq(int x$1) {
            this.iter = x$1;
        }

        public void doWork() {
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().killRandomBroker();
            Thread.sleep(500L);
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().restartDeadBrokers();
            this.iter_$eq(this.iter() + 1);
            if (this.iter() == this.numIters()) {
                this.initiateShutdown();
            } else {
                Thread.sleep(500L);
            }
        }

        public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer() {
            return this.$outer;
        }

        public BounceBrokerScheduler(ConsumerBounceTest $outer, int numIters) {
            this.numIters = numIters;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super("daemon-bounce-broker", false);
            this.iter = 0;
        }
    }
}

