/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Collection;
import java.util.Properties;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_9_0$;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerIntegrationTest$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.server.OffsetCheckpoint;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.util.Random;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\t]g\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0004T8h\u00072,\u0017M\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u0011=\u0001!\u0011!Q\u0001\nA\t\u0001cY8naJ,7o]5p]\u000e{G-Z2\u0011\u0005E!bBA\u0005\u0013\u0013\t\u0019\"\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003+Y\u0011aa\u0015;sS:<'BA\n\u000b\u0011\u0015A\u0002\u0001\"\u0001\u001a\u0003\u0019a\u0014N\\5u}Q\u0011!\u0004\b\t\u00037\u0001i\u0011A\u0001\u0005\u0006\u001f]\u0001\r\u0001\u0005\u0005\b=\u0001\u0011\r\u0011\"\u0001 \u0003\u0015\u0019w\u000eZ3d+\u0005\u0001\u0003CA\u0011,\u001b\u0005\u0011#BA\u0012%\u0003\u0019\u0011XmY8sI*\u0011QEJ\u0001\u0007G>lWn\u001c8\u000b\u0005\u00159#B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001eL!\u0001\f\u0012\u0003\u001f\r{W\u000e\u001d:fgNLwN\u001c+za\u0016DaA\f\u0001!\u0002\u0013\u0001\u0013AB2pI\u0016\u001c\u0007\u0005C\u00041\u0001\t\u0007I\u0011A\u0019\u0002\tQLW.Z\u000b\u0002eA\u00111GN\u0007\u0002i)\u0011Q\u0007B\u0001\u0006kRLGn]\u0005\u0003oQ\u0012\u0001\"T8dWRKW.\u001a\u0005\u0007s\u0001\u0001\u000b\u0011\u0002\u001a\u0002\u000bQLW.\u001a\u0011\t\u000fm\u0002!\u0019!C\u0001y\u0005Y1/Z4nK:$8+\u001b>f+\u0005i\u0004CA\u0005?\u0013\ty$BA\u0002J]RDa!\u0011\u0001!\u0002\u0013i\u0014\u0001D:fO6,g\u000e^*ju\u0016\u0004\u0003bB\"\u0001\u0005\u0004%\t\u0001P\u0001\fI\u0016dW\r^3EK2\f\u0017\u0010\u0003\u0004F\u0001\u0001\u0006I!P\u0001\rI\u0016dW\r^3EK2\f\u0017\u0010\t\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0003\u001dawn\u001a(b[\u0016,\u0012!\u0013\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000bA\u0001\\1oO*\ta*\u0001\u0003kCZ\f\u0017BA\u000bL\u0011\u0019\t\u0006\u0001)A\u0005\u0013\u0006AAn\\4OC6,\u0007\u0005C\u0004T\u0001\t\u0007I\u0011\u0001+\u0002\r1|w\rR5s+\u0005)\u0006C\u0001,Z\u001b\u00059&B\u0001-N\u0003\tIw.\u0003\u0002[/\n!a)\u001b7f\u0011\u0019a\u0006\u0001)A\u0005+\u00069An\\4ESJ\u0004\u0003b\u00020\u0001\u0001\u0004%\t\u0001P\u0001\bG>,h\u000e^3s\u0011\u001d\u0001\u0007\u00011A\u0005\u0002\u0005\f1bY8v]R,'o\u0018\u0013fcR\u0011!-\u001a\t\u0003\u0013\rL!\u0001\u001a\u0006\u0003\tUs\u0017\u000e\u001e\u0005\bM~\u000b\t\u00111\u0001>\u0003\rAH%\r\u0005\u0007Q\u0002\u0001\u000b\u0015B\u001f\u0002\u0011\r|WO\u001c;fe\u0002B\u0011B\u001b\u0001A\u0002\u0003\u0007I\u0011A6\u0002\u000f\rdW-\u00198feV\tA\u000e\u0005\u0002\u001c[&\u0011aN\u0001\u0002\u000b\u0019><7\t\\3b]\u0016\u0014\b\"\u00039\u0001\u0001\u0004\u0005\r\u0011\"\u0001r\u0003-\u0019G.Z1oKJ|F%Z9\u0015\u0005\t\u0014\bb\u00024p\u0003\u0003\u0005\r\u0001\u001c\u0005\u0007i\u0002\u0001\u000b\u0015\u00027\u0002\u0011\rdW-\u00198fe\u0002BqA\u001e\u0001C\u0002\u0013\u0005q/\u0001\u0004u_BL7m]\u000b\u0002qB\u0019\u0011\"_>\n\u0005iT!!B!se\u0006L\bC\u0001?~\u001b\u0005!\u0013B\u0001@%\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!!\u0001\u0001A\u0003%\u00010A\u0004u_BL7m\u001d\u0011\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b\u0005Y1\r\\3b]\u0016\u0014H+Z:u)\u0005\u0011\u0007\u0006BA\u0002\u0003\u0017\u0001B!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#I\u0013!\u00026v]&$\u0018\u0002BA\u000b\u0003\u001f\u0011A\u0001V3ti\"9\u0011\u0011\u0004\u0001\u0005\u0002\u0005\u001d\u0011a\n;fgR\u001cE.Z1og\u000e{WNY5oK\u0012\u001cu.\u001c9bGR\fe\u000e\u001a#fY\u0016$X\rV8qS\u000eDC!a\u0006\u0002\f!9\u0011q\u0004\u0001\u0005\n\u0005\u0005\u0012aG2sK\u0006$X\rT1sO\u0016\u001c\u0016N\\4mK6+7o]1hKN+G\u000f\u0006\u0004\u0002$\u0005=\u00121\u0007\t\u0007\u0013\u0005\u0015\u0002#!\u000b\n\u0007\u0005\u001d\"B\u0001\u0004UkBdWM\r\t\u0004C\u0005-\u0012bAA\u0017E\tiQ*Z7pef\u0014VmY8sINDq!!\r\u0002\u001e\u0001\u0007Q(A\u0002lKfD\u0001\"!\u000e\u0002\u001e\u0001\u0007\u0011qG\u0001\u0015[\u0016\u001c8/Y4f\r>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8\u0011\u0007%\tI$C\u0002\u0002<)\u0011AAQ=uK\"9\u0011q\b\u0001\u0005\u0002\u0005\u001d\u0011A\b;fgR\u001cE.Z1oKJ<\u0016\u000e\u001e5NKN\u001c\u0018mZ3G_Jl\u0017\r\u001e,1Q\u0011\ti$a\u0003\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002\b\u0005qC/Z:u\u00072,\u0017M\\5oO:+7\u000f^3e\u001b\u0016\u001c8/Y4fg^KG\u000f['vYRL\u0007\u000f\\3WKJ\u001c\u0018n\u001c8tQ\u0011\t\u0019%a\u0003\t\u000f\u0005-\u0003\u0001\"\u0003\u0002N\u0005\u00012\r[3dW2\u000b7\u000f^\"mK\u0006tW\r\u001a\u000b\bE\u0006=\u00131KA,\u0011\u001d\t\t&!\u0013A\u0002A\tQ\u0001^8qS\u000eDq!!\u0016\u0002J\u0001\u0007Q(A\u0006qCJ$\u0018\u000e^5p]&#\u0007\u0002CA-\u0003\u0013\u0002\r!a\u0017\u0002\u0015\u0019L'o\u001d;ESJ$\u0018\u0010E\u0002\n\u0003;J1!a\u0018\u000b\u0005\u0011auN\\4\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f\u0005Q2\r[3dW2{w-\u00114uKJ\f\u0005\u000f]3oI&tw\rR;qgR9!-a\u001a\u0002p\u0005M\u0004bB\u0002\u0002b\u0001\u0007\u0011\u0011\u000e\t\u00047\u0005-\u0014bAA7\u0005\t\u0019Aj\\4\t\u0011\u0005E\u0014\u0011\ra\u0001\u00037\n\u0011b\u001d;beR\u001c\u0016N_3\t\u0011\u0005U\u0014\u0011\ra\u0001\u0003o\nq!\u00199qK:$7\u000f\u0005\u0004\u0002z\u0005%\u0015q\u0012\b\u0005\u0003w\n)I\u0004\u0003\u0002~\u0005\rUBAA@\u0015\r\t\tIB\u0001\u0007yI|w\u000e\u001e \n\u0003-I1!a\"\u000b\u0003\u001d\u0001\u0018mY6bO\u0016LA!a#\u0002\u000e\n\u00191+Z9\u000b\u0007\u0005\u001d%\u0002E\u0004\n\u0003#k\u0004#a\u0017\n\u0007\u0005M%B\u0001\u0004UkBdWm\r\u0005\b\u0003/\u0003A\u0011BAM\u0003\u0015!x.T1q)\u0011\tY*!+\u0011\u000f\u0005u\u00151U\u001f\u0002(6\u0011\u0011q\u0014\u0006\u0004\u0003CS\u0011AC2pY2,7\r^5p]&!\u0011QUAP\u0005\ri\u0015\r\u001d\t\u0007\u0013\u0005\u0015\u0002#a\u0017\t\u0011\u0005-\u0016Q\u0013a\u0001\u0003[\u000b\u0001\"\\3tg\u0006<Wm\u001d\t\u0007\u0003;\u000by+a$\n\t\u0005E\u0016q\u0014\u0002\t\u0013R,'/\u00192mK\"9\u0011Q\u0017\u0001\u0005\n\u0005]\u0016a\u0003:fC\u00124%o\\7M_\u001e$B!!,\u0002:\"91!a-A\u0002\u0005%\u0004bBA_\u0001\u0011%\u0011qX\u0001\noJLG/\u001a#vaN$b\"a\u001e\u0002B\u0006\u0015\u0017\u0011ZAf\u0003\u001b\f\t\u000eC\u0004\u0002D\u0006m\u0006\u0019A\u001f\u0002\u000f9,XnS3zg\"9\u0011qYA^\u0001\u0004i\u0014a\u00028v[\u0012+\bo\u001d\u0005\b\u0007\u0005m\u0006\u0019AA5\u0011\u0019q\u00121\u0018a\u0001A!I\u0011qZA^!\u0003\u0005\r!P\u0001\tgR\f'\u000f^&fs\"Q\u00111[A^!\u0003\u0005\r!a\u000e\u0002\u00155\fw-[2WC2,X\rC\u0004\u0002X\u0002!I!!7\u00023]\u0014\u0018\u000e^3EkB\u001c8+\u001b8hY\u0016lUm]:bO\u0016\u001cV\r\u001e\u000b\u000f\u0003o\nY.!8\u0002`\u0006\u0005\u00181]As\u0011\u001d\t\u0019-!6A\u0002uBq!a2\u0002V\u0002\u0007Q\bC\u0004\u0004\u0003+\u0004\r!!\u001b\t\ry\t)\u000e1\u0001!\u0011%\ty-!6\u0011\u0002\u0003\u0007Q\b\u0003\u0006\u0002T\u0006U\u0007\u0013!a\u0001\u0003oAq!!;\u0001\t\u0003\t9!\u0001\u0005uK\u0006\u0014Hi\\<oQ\u0011\t9/!<\u0011\t\u00055\u0011q^\u0005\u0005\u0003c\fyAA\u0003BMR,'\u000fC\u0004\u0002v\u0002!I!a>\u0002'1|wmQ8oM&<\u0007K]8qKJ$\u0018.Z:\u0015\u0011\u0005e(Q\u0001B\u0005\u0005\u001b\u0001B!a?\u0003\u00025\u0011\u0011Q \u0006\u0004\u0003\u007fl\u0015\u0001B;uS2LAAa\u0001\u0002~\nQ\u0001K]8qKJ$\u0018.Z:\t\u0015\t\u001d\u00111\u001fI\u0001\u0002\u0004\tI0A\tqe>\u0004XM\u001d;z\u001fZ,'O]5eKNDqAa\u0003\u0002t\u0002\u0007Q(\u0001\bnCblUm]:bO\u0016\u001c\u0016N_3\t\u0015\t=\u00111\u001fI\u0001\u0002\u0004\u0011\t\"\u0001\fnS:\u001cE.Z1oC\ndW\rR5sif\u0014\u0016\r^5p!\rI!1C\u0005\u0004\u0005+Q!!\u0002$m_\u0006$\bb\u0002B\r\u0001\u0011%!1D\u0001\f[\u0006\\Wm\u00117fC:,'\u000fF\u0007m\u0005;\u0011\tCa\t\u0003(\t%\"Q\u0006\u0005\b\u0005?\u00119\u00021\u0001>\u0003\u0015\u0001\u0018M\u001d;t\u0011)\u0011yAa\u0006\u0011\u0002\u0003\u0007!\u0011\u0003\u0005\n\u0005K\u00119\u0002%AA\u0002u\n!B\\;n)\"\u0014X-\u00193t\u0011%\u0011YAa\u0006\u0011\u0002\u0003\u0007Q\b\u0003\u0006\u0003,\t]\u0001\u0013!a\u0001\u00037\nq\u0003\\8h\u00072,\u0017M\\3s\u0005\u0006\u001c7n\u00144g\u001b&dG.[:\t\u0015\t\u001d!q\u0003I\u0001\u0002\u0004\tI\u0010C\u0005\u00032\u0001\t\n\u0011\"\u0003\u00034\u0005)R.Y6f\u00072,\u0017M\\3sI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u001bU\u0011\u0011\tBa\u000e,\u0005\te\u0002\u0003\u0002B\u001e\u0005\u000bj!A!\u0010\u000b\t\t}\"\u0011I\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0011\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u000f\u0012iDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011Ba\u0013\u0001#\u0003%IA!\u0014\u0002+5\f7.Z\"mK\u0006tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\n\u0016\u0004{\t]\u0002\"\u0003B*\u0001E\u0005I\u0011\u0002B'\u0003Ui\u0017m[3DY\u0016\fg.\u001a:%I\u00164\u0017-\u001e7uIQB\u0011Ba\u0016\u0001#\u0003%IA!\u0017\u0002+5\f7.Z\"mK\u0006tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!1\f\u0016\u0005\u00037\u00129\u0004C\u0005\u0003`\u0001\t\n\u0011\"\u0003\u0003b\u0005)R.Y6f\u00072,\u0017M\\3sI\u0011,g-Y;mi\u00122TC\u0001B2U\u0011\tIPa\u000e\t\u0013\t\u001d\u0004!%A\u0005\n\t5\u0013aE<sSR,G)\u001e9tI\u0011,g-Y;mi\u0012*\u0004\"\u0003B6\u0001E\u0005I\u0011\u0002B7\u0003M9(/\u001b;f\tV\u00048\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011yG\u000b\u0003\u00028\t]\u0002\"\u0003B:\u0001E\u0005I\u0011\u0002B1\u0003uawnZ\"p]\u001aLw\r\u0015:pa\u0016\u0014H/[3tI\u0011,g-Y;mi\u0012\n\u0004\"\u0003B<\u0001E\u0005I\u0011\u0002B\u001a\u0003uawnZ\"p]\u001aLw\r\u0015:pa\u0016\u0014H/[3tI\u0011,g-Y;mi\u0012\u001a\u0004\"\u0003B>\u0001E\u0005I\u0011\u0002B'\u0003\r:(/\u001b;f\tV\u00048oU5oO2,W*Z:tC\u001e,7+\u001a;%I\u00164\u0017-\u001e7uIUB\u0011Ba \u0001#\u0003%IA!\u001c\u0002G]\u0014\u0018\u000e^3EkB\u001c8+\u001b8hY\u0016lUm]:bO\u0016\u001cV\r\u001e\u0013eK\u001a\fW\u000f\u001c;%m!:\u0001Aa!\u0003\u0010\nE\u0005\u0003\u0002BC\u0005\u0017k!Aa\"\u000b\t\t%\u0015qB\u0001\u0007eVtg.\u001a:\n\t\t5%q\u0011\u0002\b%Vtw+\u001b;i\u0003\u00151\u0018\r\\;fG\t\u0011\u0019\n\u0005\u0003\u0003\u0016\nmUB\u0001BL\u0015\u0011\u0011I*a\u0004\u0002\u000fI,hN\\3sg&!!Q\u0014BL\u00055\u0001\u0016M]1nKR,'/\u001b>fI\u001e9!\u0011\u0015\u0002\t\u0002\t\r\u0016!\u0007'pO\u000ecW-\u00198fe&sG/Z4sCRLwN\u001c+fgR\u00042a\u0007BS\r\u0019\t!\u0001#\u0001\u0003(N\u0019!Q\u0015\u0005\t\u000fa\u0011)\u000b\"\u0001\u0003,R\u0011!1\u0015\u0005\t\u0005_\u0013)\u000b\"\u0001\u00032\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0016\u0005\tM\u0006CBA~\u0005k\u0013I,\u0003\u0003\u00038\u0006u(AC\"pY2,7\r^5p]B\u0019\u0011\"\u001f\t)\t\t5&Q\u0018\t\u0005\u0005\u007f\u0013\tN\u0004\u0003\u0003B\n5g\u0002\u0002Bb\u0005\u0017tAA!2\u0003J:!\u0011Q\u0010Bd\u0013\u0005Q\u0013bAA\tS%!!\u0011TA\b\u0013\u0011\u0011yMa&\u0002\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u0013\u0011\u0011\u0019N!6\u0003\u0015A\u000b'/Y7fi\u0016\u00148O\u0003\u0003\u0003P\n]\u0005")
public class LogCleanerIntegrationTest {
    private final CompressionType codec;
    private final MockTime time;
    private final int segmentSize;
    private final int deleteDelay;
    private final String logName;
    private final File logDir;
    private int counter;
    private LogCleaner cleaner;
    private final TopicPartition[] topics;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return LogCleanerIntegrationTest$.MODULE$.parameters();
    }

    public CompressionType codec() {
        return this.codec;
    }

    public MockTime time() {
        return this.time;
    }

    public int segmentSize() {
        return this.segmentSize;
    }

    public int deleteDelay() {
        return this.deleteDelay;
    }

    public String logName() {
        return this.logName;
    }

    public File logDir() {
        return this.logDir;
    }

    public int counter() {
        return this.counter;
    }

    public void counter_$eq(int x$1) {
        this.counter = x$1;
    }

    public LogCleaner cleaner() {
        return this.cleaner;
    }

    public void cleaner_$eq(LogCleaner x$1) {
        this.cleaner = x$1;
    }

    public TopicPartition[] topics() {
        return this.topics;
    }

    @Test
    public void cleanerTest() {
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)1);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String largeMessageValue = (String)tuple2._1();
            MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
            String largeMessageValue2 = (String)tuple23._1();
            MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
            int maxMessageSize = largeMessageSet2.sizeInBytes();
            int x$9 = 3;
            int x$10 = maxMessageSize;
            float x$11 = this.makeCleaner$default$2();
            int x$12 = this.makeCleaner$default$3();
            long x$13 = this.makeCleaner$default$5();
            Properties x$14 = this.makeCleaner$default$6();
            this.cleaner_$eq(this.makeCleaner(x$9, x$11, x$12, x$10, x$13, x$14));
            Log log = (Log)this.cleaner().logs().get((Object)this.topics()[0]);
            Seq<Tuple3<Object, String, Object>> appends = this.writeDups(100, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
            long startSize = log.size();
            this.cleaner().startup();
            long firstDirty = log.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty);
            long compactedSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)log.logSegments().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(LogSegment x$2) {
                    return x$2.size();
                }
            }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToLong((long)compactedSize)})), (startSize > compactedSize ? 1 : 0) != 0);
            this.checkLogAfterAppendingDups(log, startSize, appends);
            LogAppendInfo appendInfo = log.append(largeMessageSet2, true);
            long largeMessageOffset = appendInfo.firstOffset();
            int x$15 = largeMessageKey + 1;
            int x$16 = 100;
            int x$17 = 3;
            Log x$18 = log;
            CompressionType x$19 = this.codec();
            byte x$20 = this.writeDups$default$6();
            Seq<Tuple3<Object, String, Object>> dups = this.writeDups(x$16, x$17, x$18, x$19, x$15, x$20);
            Seq appends2 = (Seq)((TraversableLike)appends.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset))})), Seq$.MODULE$.canBuildFrom())).$plus$plus(dups, Seq$.MODULE$.canBuildFrom());
            long firstDirty2 = log.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty2);
            this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
            this.cleaner().logs().remove((Object)this.topics()[0]);
            this.cleaner().updateCheckpoints(this.logDir());
            Map checkpoints = new OffsetCheckpoint(new File(this.logDir(), this.cleaner().cleanerManager().offsetCheckpointFile())).read();
            Assert.assertFalse((boolean)checkpoints.contains((Object)this.topics()[0]));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testCleansCombinedCompactAndDeleteTopic() {
        Properties logProps = new Properties();
        Integer retentionMs = Predef$.MODULE$.int2Integer(100000);
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), retentionMs);
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact,delete");
        Tuple2 tuple2 = this.runCleanerAndCheckCompacted$1(100, logProps);
        if (tuple2 != null) {
            Log log;
            Log log2;
            Log log3 = log2 = (log = (Log)tuple2._1());
            log3.logSegments().foreach((Function1)new Serializable(this, retentionMs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogCleanerIntegrationTest $outer;
                private final Integer retentionMs$1;

                public final boolean apply(LogSegment x$4) {
                    return x$4.lastModified_$eq(this.$outer.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(this.retentionMs$1)));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.retentionMs$1 = retentionMs$1;
                }
            });
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, log3){
                public static final long serialVersionUID = 0L;
                private final Log log$2;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.log$2.numberOfSegments() == 1;
                }
                {
                    this.log$2 = log$2;
                }
            }, "There should only be 1 segment remaining", 10000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
            Assert.assertEquals((long)1L, (long)log3.numberOfSegments());
            this.cleaner().shutdown();
            Tuple2 tuple22 = this.runCleanerAndCheckCompacted$1(20, logProps);
            if (tuple22 != null) {
                Tuple2 tuple23;
                Log log22 = (Log)tuple22._1();
                Seq messages = (Seq)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)log22, (Object)messages);
                Log log23 = (Log)tuple24._1();
                Seq messages2 = (Seq)tuple24._2();
                Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log23);
                Assert.assertEquals((String)"Contents of the map shouldn't change", this.toMap((Iterable<Tuple3<Object, String, Object>>)messages2), this.toMap(read));
                return;
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)tuple2);
    }

    private Tuple2<String, MemoryRecords> createLargeSingleMessageSet(int key, byte messageFormatVersion) {
        String value = this.messageValue$1(128);
        byte[] x$27 = value.getBytes();
        CompressionType x$28 = this.codec();
        byte[] x$29 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte x$30 = messageFormatVersion;
        long x$31 = TestUtils$.MODULE$.singletonRecords$default$4();
        MemoryRecords messageSet = TestUtils$.MODULE$.singletonRecords(x$27, x$29, x$28, x$31, x$30);
        return new Tuple2((Object)value, (Object)messageSet);
    }

    @Test
    public void testCleanerWithMessageFormatV0() {
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)0);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String largeMessageValue = (String)tuple2._1();
            MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
            String largeMessageValue2 = (String)tuple23._1();
            MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
            CompressionType compressionType = this.codec();
            CompressionType compressionType2 = CompressionType.NONE;
            CompressionType compressionType3 = compressionType;
            int n = !(compressionType2 != null ? !compressionType2.equals(compressionType3) : compressionType3 != null) ? largeMessageSet2.sizeInBytes() : largeMessageSet2.sizeInBytes() + 5;
            int maxMessageSize = n;
            int x$32 = 3;
            int x$33 = maxMessageSize;
            float x$34 = this.makeCleaner$default$2();
            int x$35 = this.makeCleaner$default$3();
            long x$36 = this.makeCleaner$default$5();
            Properties x$37 = this.makeCleaner$default$6();
            this.cleaner_$eq(this.makeCleaner(x$32, x$34, x$35, x$33, x$36, x$37));
            Log log = (Log)this.cleaner().logs().get((Object)this.topics()[0]);
            int x$38 = maxMessageSize;
            Properties x$39 = this.logConfigProperties$default$1();
            float x$40 = this.logConfigProperties$default$3();
            Properties props = this.kafka$log$LogCleanerIntegrationTest$$logConfigProperties(x$39, x$38, x$40);
            props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
            log.config_$eq(new LogConfig((java.util.Map)props));
            int x$41 = 100;
            int x$42 = 3;
            Log x$43 = log;
            CompressionType x$44 = this.codec();
            byte x$45 = 0;
            int x$46 = this.writeDups$default$5();
            Seq<Tuple3<Object, String, Object>> appends = this.writeDups(x$41, x$42, x$43, x$44, x$46, x$45);
            long startSize = log.size();
            this.cleaner().startup();
            long firstDirty = log.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty);
            long compactedSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)log.logSegments().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(LogSegment x$7) {
                    return x$7.size();
                }
            }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToLong((long)compactedSize)})), (startSize > compactedSize ? 1 : 0) != 0);
            this.checkLogAfterAppendingDups(log, startSize, appends);
            int x$47 = 40;
            int x$48 = 3;
            Log x$49 = log;
            CompressionType x$50 = this.codec();
            byte x$51 = 0;
            int x$52 = this.writeDups$default$5();
            Seq<Tuple3<Object, String, Object>> dupsV0 = this.writeDups(x$47, x$48, x$49, x$50, x$52, x$51);
            LogAppendInfo appendInfo = log.append(largeMessageSet2, true);
            long largeMessageOffset = appendInfo.firstOffset();
            props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_10_0_IV1$.MODULE$.version());
            log.config_$eq(new LogConfig((java.util.Map)props));
            int x$53 = 30;
            int x$54 = 40;
            int x$55 = 3;
            Log x$56 = log;
            CompressionType x$57 = this.codec();
            byte x$58 = 1;
            Seq<Tuple3<Object, String, Object>> dupsV1 = this.writeDups(x$54, x$55, x$56, x$57, x$53, x$58);
            Seq appends2 = (Seq)((TraversableLike)((TraversableLike)appends.$plus$plus(dupsV0, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset))})), Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV1, Seq$.MODULE$.canBuildFrom());
            long firstDirty2 = log.activeSegment().baseOffset();
            this.checkLastCleaned("log", 0, firstDirty2);
            this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testCleaningNestedMessagesWithMultipleVersions() {
        int maxMessageSize = 192;
        int x$59 = 3;
        int x$60 = maxMessageSize;
        float x$61 = this.makeCleaner$default$2();
        int x$62 = this.makeCleaner$default$3();
        long x$63 = this.makeCleaner$default$5();
        Properties x$64 = this.makeCleaner$default$6();
        this.cleaner_$eq(this.makeCleaner(x$59, x$61, x$62, x$60, x$63, x$64));
        Log log = (Log)this.cleaner().logs().get((Object)this.topics()[0]);
        int x$65 = maxMessageSize;
        Properties x$66 = this.logConfigProperties$default$1();
        float x$67 = this.logConfigProperties$default$3();
        Properties props = this.kafka$log$LogCleanerIntegrationTest$$logConfigProperties(x$66, x$65, x$67);
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
        log.config_$eq(new LogConfig((java.util.Map)props));
        int x$68 = 2;
        int x$69 = 3;
        Log x$70 = log;
        CompressionType x$71 = this.codec();
        byte x$72 = 0;
        int x$73 = this.writeDupsSingleMessageSet$default$5();
        Seq appendsV0 = this.writeDupsSingleMessageSet(x$68, x$69, x$70, x$71, x$73, x$72);
        int x$74 = 2;
        int x$75 = 3;
        int x$76 = 2;
        Log x$77 = log;
        CompressionType x$78 = this.codec();
        byte x$79 = 0;
        appendsV0 = (Seq)appendsV0.$plus$plus(this.writeDupsSingleMessageSet(x$74, x$76, x$77, x$78, x$75, x$79), Seq$.MODULE$.canBuildFrom());
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_10_0_IV1$.MODULE$.version());
        log.config_$eq(new LogConfig((java.util.Map)props));
        int x$80 = 4;
        int x$81 = 2;
        int x$82 = 2;
        Log x$83 = log;
        CompressionType x$84 = this.codec();
        byte x$85 = 1;
        Seq appendsV1 = this.writeDupsSingleMessageSet(x$81, x$82, x$83, x$84, x$80, x$85);
        int x$86 = 4;
        int x$87 = 2;
        int x$88 = 2;
        Log x$89 = log;
        CompressionType x$90 = this.codec();
        byte x$91 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$87, x$88, x$89, x$90, x$86, x$91), Seq$.MODULE$.canBuildFrom());
        int x$92 = 6;
        int x$93 = 2;
        int x$94 = 2;
        Log x$95 = log;
        CompressionType x$96 = this.codec();
        byte x$97 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$93, x$94, x$95, x$96, x$92, x$97), Seq$.MODULE$.canBuildFrom());
        Seq appends = (Seq)appendsV0.$plus$plus((GenTraversableOnce)appendsV1, Seq$.MODULE$.canBuildFrom());
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        Assert.assertTrue((firstDirty > (long)appendsV0.size() ? 1 : 0) != 0);
        this.checkLastCleaned("log", 0, firstDirty);
        long compactedSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)log.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$8) {
                return x$8.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToLong((long)compactedSize)})), (startSize > compactedSize ? 1 : 0) != 0);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends);
    }

    private void checkLastCleaned(String topic, int partitionId, long firstDirty) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionId);
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$98 = topicPartition;
        long x$99 = firstDirty;
        long x$100 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$98, x$99, x$100);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)topicPartition));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log cleaner should have processed up to offset ", ", but lastCleaned=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)firstDirty), BoxesRunTime.boxToLong((long)lastCleaned)})), (lastCleaned >= firstDirty ? 1 : 0) != 0);
    }

    private void checkLogAfterAppendingDups(Log log, long startSize, Seq<Tuple3<Object, String, Object>> appends) {
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log);
        Assert.assertEquals((String)"Contents of the map shouldn't change", this.toMap((Iterable<Tuple3<Object, String, Object>>)appends), this.toMap(read));
        Assert.assertTrue((startSize > log.size() ? 1 : 0) != 0);
    }

    private Map<Object, Tuple2<String, Object>> toMap(Iterable<Tuple3<Object, String, Object>> messages) {
        return ((TraversableOnce)messages.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<String, Object>> apply(Tuple3<Object, String, Object> x0$1) {
                Tuple3<Object, String, Object> tuple3 = x0$1;
                if (tuple3 != null) {
                    int key = BoxesRunTime.unboxToInt((Object)tuple3._1());
                    String value = (String)tuple3._2();
                    long offset = BoxesRunTime.unboxToLong((Object)tuple3._3());
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)new Tuple2((Object)value, (Object)BoxesRunTime.boxToLong((long)offset)));
                    return tuple2;
                }
                throw new MatchError(tuple3);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    private Iterable<Tuple3<Object, String, Object>> readFromLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple3<Object, String, Object>> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().deepEntries()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<Object, String, Object> apply(LogEntry deepLogEntry) {
                        int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(deepLogEntry.record().key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                        String value = TestUtils$.MODULE$.readString(deepLogEntry.record().value(), TestUtils$.MODULE$.readString$default$2());
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)deepLogEntry.offset()));
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<Object, String, Object>> writeDups(int numKeys, int numDups, Log log, CompressionType codec, int startKey, byte magicValue) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, log, codec, startKey, magicValue){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerIntegrationTest $outer;
            private final int numKeys$1;
            public final Log log$1;
            public final CompressionType codec$1;
            private final int startKey$1;
            public final byte magicValue$1;

            public final IndexedSeq<Tuple3<Object, String, Object>> apply(int _) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.startKey$1), this.startKey$1 + this.numKeys$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeDups$1 $outer;

                    public final Tuple3<Object, String, Object> apply(int key) {
                        String value = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter())).toString();
                        byte[] x$101 = value.toString().getBytes();
                        CompressionType x$102 = this.$outer.codec$1;
                        byte[] x$103 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
                        byte x$104 = this.$outer.magicValue$1;
                        long x$105 = TestUtils$.MODULE$.singletonRecords$default$4();
                        LogAppendInfo appendInfo = this.$outer.log$1.append(TestUtils$.MODULE$.singletonRecords(x$101, x$103, x$102, x$105, x$104), true);
                        this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter_$eq(this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter() + 1);
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)appendInfo.firstOffset()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ LogCleanerIntegrationTest kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.numKeys$1 = numKeys$1;
                this.log$1 = log$1;
                this.codec$1 = codec$1;
                this.startKey$1 = startKey$1;
                this.magicValue$1 = magicValue$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private int writeDups$default$5() {
        return 0;
    }

    private byte writeDups$default$6() {
        return 1;
    }

    private Seq<Tuple3<Object, String, Object>> writeDupsSingleMessageSet(int numKeys, int numDups, Log log, CompressionType codec, int startKey, byte magicValue) {
        IndexedSeq kvs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, startKey){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerIntegrationTest $outer;
            private final int numKeys$2;
            private final int startKey$2;

            public final IndexedSeq<Tuple2<Object, String>> apply(int _) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.startKey$2), this.startKey$2 + this.numKeys$2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final Tuple2<Object, String> apply(int key) {
                        String payload = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter())).toString();
                        this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter_$eq(this.$outer.kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer().counter() + 1);
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)key), (Object)payload);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ LogCleanerIntegrationTest kafka$log$LogCleanerIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.numKeys$2 = numKeys$2;
                this.startKey$2 = startKey$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq messages = (IndexedSeq)kvs.map((Function1)new Serializable(this, magicValue){
            public static final long serialVersionUID = 0L;
            private final byte magicValue$2;

            public final Record apply(Tuple2<Object, String> x0$2) {
                Tuple2<Object, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    int key = tuple2._1$mcI$sp();
                    String payload = (String)tuple2._2();
                    Record record = Record.create((byte)this.magicValue$2, (byte[])((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), (byte[])payload.toString().getBytes());
                    return record;
                }
                throw new MatchError(tuple2);
            }
            {
                this.magicValue$2 = magicValue$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecords records2 = MemoryRecords.withRecords((CompressionType)codec, (Record[])((Record[])messages.toArray(ClassTag$.MODULE$.apply(Record.class))));
        LogAppendInfo appendInfo = log.append(records2, true);
        NumericRange.Inclusive offsets = new RichLong(Predef$.MODULE$.longWrapper(appendInfo.firstOffset())).to((Object)BoxesRunTime.boxToLong((long)appendInfo.lastOffset()));
        return (Seq)((TraversableLike)kvs.zip((GenIterable)offsets, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, String, Object> apply(Tuple2<Tuple2<Object, String>, Object> x0$3) {
                Tuple2<Tuple2<Object, String>, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    Tuple2 kv = (Tuple2)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp()), kv._2(), (Object)BoxesRunTime.boxToLong((long)offset));
                    return tuple3;
                }
                throw new MatchError(tuple2);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private int writeDupsSingleMessageSet$default$5() {
        return 0;
    }

    private byte writeDupsSingleMessageSet$default$6() {
        return 1;
    }

    @After
    public void tearDown() {
        this.cleaner().shutdown();
        this.time().scheduler().shutdown();
        Utils.delete((File)this.logDir());
    }

    public Properties kafka$log$LogCleanerIntegrationTest$$logConfigProperties(Properties propertyOverrides, int maxMessageSize, float minCleanableDirtyRatio) {
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(maxMessageSize));
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(this.segmentSize()));
        props.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(102400));
        props.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(this.deleteDelay()));
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.float2Float(minCleanableDirtyRatio));
        props.putAll((java.util.Map<?, ?>)propertyOverrides);
        return props;
    }

    private Properties logConfigProperties$default$1() {
        return new Properties();
    }

    private float logConfigProperties$default$3() {
        return 0.0f;
    }

    private LogCleaner makeCleaner(int parts, float minCleanableDirtyRatio, int numThreads, int maxMessageSize, long logCleanerBackOffMillis, Properties propertyOverrides) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), parts).foreach((Function1)new Serializable(this, minCleanableDirtyRatio, maxMessageSize, propertyOverrides, logs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerIntegrationTest $outer;
            private final float minCleanableDirtyRatio$1;
            private final int maxMessageSize$1;
            private final Properties propertyOverrides$1;
            private final Pool logs$1;

            public final Log apply(int i) {
                File dir = new File(this.$outer.logDir(), new StringBuilder().append((Object)"log-").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                dir.mkdirs();
                Log log = new Log(dir, new LogConfig((java.util.Map)this.$outer.kafka$log$LogCleanerIntegrationTest$$logConfigProperties(this.propertyOverrides$1, this.maxMessageSize$1, this.minCleanableDirtyRatio$1)), 0L, (Scheduler)this.$outer.time().scheduler(), (Time)this.$outer.time());
                return (Log)this.logs$1.put((Object)new TopicPartition("log", i), (Object)log);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.minCleanableDirtyRatio$1 = minCleanableDirtyRatio$1;
                this.maxMessageSize$1 = maxMessageSize$1;
                this.propertyOverrides$1 = propertyOverrides$1;
                this.logs$1 = logs$1;
            }
        });
        int x$106 = numThreads;
        int x$107 = maxMessageSize / 2;
        int x$108 = maxMessageSize;
        long x$109 = logCleanerBackOffMillis;
        long x$110 = CleanerConfig$.MODULE$.apply$default$2();
        double x$111 = CleanerConfig$.MODULE$.apply$default$3();
        double x$112 = CleanerConfig$.MODULE$.apply$default$6();
        boolean x$113 = CleanerConfig$.MODULE$.apply$default$8();
        String x$114 = CleanerConfig$.MODULE$.apply$default$9();
        return new LogCleaner(new CleanerConfig(x$106, x$110, x$111, x$107, x$108, x$112, x$109, x$113, x$114), (File[])((Object[])new File[]{this.logDir()}), logs, (Time)this.time());
    }

    private float makeCleaner$default$2() {
        return 0.0f;
    }

    private int makeCleaner$default$3() {
        return 1;
    }

    private int makeCleaner$default$4() {
        return 128;
    }

    private long makeCleaner$default$5() {
        return 15000L;
    }

    private Properties makeCleaner$default$6() {
        return new Properties();
    }

    private final Tuple2 runCleanerAndCheckCompacted$1(int numKeys, Properties logProps$1) {
        int x$21 = 1;
        Properties x$22 = logProps$1;
        long x$23 = 100L;
        float x$24 = this.makeCleaner$default$2();
        int x$25 = this.makeCleaner$default$3();
        int x$26 = this.makeCleaner$default$4();
        this.cleaner_$eq(this.makeCleaner(x$21, x$24, x$25, x$26, x$23, x$22));
        Log log = (Log)this.cleaner().logs().get((Object)this.topics()[0]);
        Seq<Tuple3<Object, String, Object>> messages = this.writeDups(numKeys, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        long firstDirty = log.activeSegment().baseOffset();
        this.cleaner().startup();
        this.checkLastCleaned("log", 0, firstDirty);
        long compactedSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)log.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$3) {
                return x$3.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToLong((long)compactedSize)})), (startSize > compactedSize ? 1 : 0) != 0);
        return new Tuple2((Object)log, messages);
    }

    private final String messageValue$1(int length) {
        Random random = new Random(0);
        return new String((char[])random.alphanumeric().take(length).toArray(ClassTag$.MODULE$.Char()));
    }

    public LogCleanerIntegrationTest(String compressionCodec) {
        this.codec = CompressionType.forName((String)compressionCodec);
        this.time = new MockTime();
        this.segmentSize = 256;
        this.deleteDelay = 1000;
        this.logName = "log";
        this.logDir = TestUtils$.MODULE$.tempDir();
        this.counter = 0;
        this.topics = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
    }
}

