/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.log.LogSegment;
import kafka.log.LogSegmentTest$;
import kafka.log.OffsetIndex;
import kafka.log.TimeIndex;
import kafka.log.TimestampOffset;
import kafka.server.FetchDataInfo;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h'\u0016<W.\u001a8u)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005A1/Z4nK:$8/F\u0001\u0017!\r9BDH\u0007\u00021)\u0011\u0011DG\u0001\b[V$\u0018M\u00197f\u0015\tY\"\"\u0001\u0006d_2dWm\u0019;j_:L!!\b\r\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003%}I!\u0001\t\u0002\u0003\u00151{wmU3h[\u0016tG\u000f\u0003\u0004#\u0001\u0001\u0006IAF\u0001\ng\u0016<W.\u001a8ug\u0002BQ\u0001\n\u0001\u0005\u0002\u0015\nQb\u0019:fCR,7+Z4nK:$Hc\u0001\u0010'W!)qe\ta\u0001Q\u00051qN\u001a4tKR\u0004\"!C\u0015\n\u0005)R!\u0001\u0002'p]\u001eDq\u0001L\u0012\u0011\u0002\u0003\u0007Q&\u0001\nj]\u0012,\u00070\u00138uKJ4\u0018\r\u001c\"zi\u0016\u001c\bCA\u0005/\u0013\ty#BA\u0002J]RDQ!\r\u0001\u0005\u0002I\nqA]3d_J$7\u000fF\u00024\u0001\u0006\u0003\"\u0001\u000e \u000e\u0003UR!AN\u001c\u0002\rI,7m\u001c:e\u0015\tA\u0014(\u0001\u0004d_6lwN\u001c\u0006\u0003\u000biR!a\u000f\u001f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0014aA8sO&\u0011q(\u000e\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u000b\u001d\u0002\u0004\u0019\u0001\u0015\t\u000bE\u0002\u0004\u0019\u0001\"\u0011\u0007%\u0019U)\u0003\u0002E\u0015\tQAH]3qK\u0006$X\r\u001a \u0011\u0005\u0019KeBA\u0005H\u0013\tA%\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0015.\u0013aa\u0015;sS:<'B\u0001%\u000b\u0011\u0015i\u0005\u0001\"\u0001O\u0003!!X-\u0019:e_^tG#A(\u0011\u0005%\u0001\u0016BA)\u000b\u0005\u0011)f.\u001b;)\u00051\u001b\u0006C\u0001+X\u001b\u0005)&B\u0001,=\u0003\u0015QWO\\5u\u0013\tAVKA\u0003BMR,'\u000fC\u0003[\u0001\u0011\u0005a*\u0001\fuKN$(+Z1e\u001f:,U\u000e\u001d;z'\u0016<W.\u001a8uQ\tIF\f\u0005\u0002U;&\u0011a,\u0016\u0002\u0005)\u0016\u001cH\u000fC\u0003a\u0001\u0011\u0005a*A\ruKN$(+Z1e\u0005\u00164wN]3GSJ\u001cHo\u00144gg\u0016$\bFA0]\u0011\u0015\u0019\u0007\u0001\"\u0001O\u00035!Xm\u001d;NCb|eMZ:fi\"\u0012!\r\u0018\u0005\u0006M\u0002!\tAT\u0001\u0012i\u0016\u001cHOU3bI\u00063G/\u001a:MCN$\bFA3]\u0011\u0015I\u0007\u0001\"\u0001O\u0003=!Xm\u001d;SK\u0006$gI]8n\u000f\u0006\u0004\bF\u00015]\u0011\u0015a\u0007\u0001\"\u0001O\u00031!Xm\u001d;UeVt7-\u0019;fQ\tYG\fC\u0003p\u0001\u0011\u0005a*A\u0015uKN$(+\u001a7pC\u0012d\u0015M]4fgR$\u0016.\\3ti\u0006l\u0007/\u00114uKJ$&/\u001e8dCRLwN\u001c\u0015\u0003]rCQA\u001d\u0001\u0005\u00029\u000b\u0001\u0003^3tiR\u0013XO\\2bi\u00164U\u000f\u001c7)\u0005Ed\u0006\"B;\u0001\t\u0003q\u0015!\u0007;fgR4\u0015N\u001c3PM\u001a\u001cX\r\u001e\"z)&lWm\u001d;b[BD#\u0001\u001e/\t\u000ba\u0004A\u0011\u0001(\u00023Q,7\u000f\u001e(fqR|eMZ:fi\u000e\u000bGnY;mCRLwN\u001c\u0015\u0003orCQa\u001f\u0001\u0005\u00029\u000ba\u0003^3ti\u000eC\u0017M\\4f\r&dWmU;gM&DXm\u001d\u0015\u0003urCQA \u0001\u0005\u00029\u000bQ\u0004^3tiJ+7m\u001c<fef4\u0015\u000e_3t\u0007>\u0014(/\u001e9u\u0013:$W\r\u001f\u0015\u0003{rCa!a\u0001\u0001\t\u0003q\u0015!\t;fgR\u0014VmY8wKJLh)\u001b=fg\u000e{'O];qiRKW.Z%oI\u0016D\bfAA\u00019\"1\u0011\u0011\u0002\u0001\u0005\u00029\u000ba\u0004^3tiJ+7m\u001c<fef<\u0016\u000e\u001e5D_J\u0014X\u000f\u001d;NKN\u001c\u0018mZ3)\u0007\u0005\u001dA\f\u0003\u0004%\u0001\u0011\u0005\u0011q\u0002\u000b\n=\u0005E\u00111CA\u000f\u0003CAaaJA\u0007\u0001\u0004A\u0003\u0002CA\u000b\u0003\u001b\u0001\r!a\u0006\u0002#\u0019LG.Z!me\u0016\fG-_#ySN$8\u000fE\u0002\n\u00033I1!a\u0007\u000b\u0005\u001d\u0011un\u001c7fC:Dq!a\b\u0002\u000e\u0001\u0007Q&\u0001\u0007j]&$h)\u001b7f'&TX\r\u0003\u0005\u0002$\u00055\u0001\u0019AA\f\u0003-\u0001(/Z1mY>\u001c\u0017\r^3\t\r\u0005\u001d\u0002\u0001\"\u0001O\u0003\u001d\"Xm\u001d;De\u0016\fG/Z,ji\"Le.\u001b;GS2,7+\u001b>f\u0003B\u0004XM\u001c3NKN\u001c\u0018mZ3)\u0007\u0005\u0015B\f\u0003\u0004\u0002.\u0001!\tAT\u0001(i\u0016\u001cHo\u0011:fCR,w+\u001b;i\u0013:LGOR5mKNK'0Z\"mK\u0006\u00148\u000b[;uI><h\u000eK\u0002\u0002,qC\u0011\"a\r\u0001#\u0003%\t!!\u000e\u0002/\r\u0014X-\u0019;f'\u0016<W.\u001a8uI\u0011,g-Y;mi\u0012\u0012TCAA\u001cU\ri\u0013\u0011H\u0016\u0003\u0003w\u0001B!!\u0010\u0002H5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\t\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002J\u0005}\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class LogSegmentTest {
    private final ArrayBuffer<LogSegment> segments = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);

    public ArrayBuffer<LogSegment> segments() {
        return this.segments;
    }

    public LogSegment createSegment(long offset, int indexIntervalBytes) {
        File msFile = TestUtils$.MODULE$.tempFile();
        FileRecords ms = FileRecords.open((File)msFile);
        File idxFile = TestUtils$.MODULE$.tempFile();
        File timeIdxFile = TestUtils$.MODULE$.tempFile();
        idxFile.delete();
        timeIdxFile.delete();
        OffsetIndex idx = new OffsetIndex(idxFile, offset, 1000);
        TimeIndex timeIdx = new TimeIndex(timeIdxFile, offset, 1500);
        LogSegment seg = new LogSegment(ms, idx, timeIdx, offset, indexIntervalBytes, 0L, Time.SYSTEM);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public MemoryRecords records(long offset, Seq<String> records2) {
        return MemoryRecords.withRecords((long)offset, (Record[])((Record[])((TraversableOnce)records2.map((Function1)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final long offset$1;

            public final Record apply(String s) {
                return Record.create((byte)1, (long)(this.offset$1 * 10L), (byte[])s.getBytes());
            }
            {
                this.offset$1 = offset$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Record.class))));
    }

    @After
    public void teardown() {
        this.segments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment seg) {
                seg.index().delete();
                return seg.log().delete();
            }
        });
    }

    @Test
    public void testReadOnEmptySegment() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        long x$3 = 40L;
        int x$4 = 300;
        None$ x$5 = None$.MODULE$;
        long x$6 = seg.read$default$4();
        boolean x$7 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$3, (Option)x$5, x$4, x$6, x$7);
        Assert.assertNull((String)"Read beyond the last offset in the segment should be null", (Object)read);
    }

    @Test
    public void testReadBeforeFirstOffset() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "little", "bee"}));
        seg.append(50L, 53L, -1L, -1L, ms);
        long x$8 = 41L;
        int x$9 = 300;
        None$ x$10 = None$.MODULE$;
        long x$11 = seg.read$default$4();
        boolean x$12 = seg.read$default$5();
        Records read = seg.read(x$8, (Option)x$10, x$9, x$11, x$12).records();
        Assert.assertEquals((Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ms.deepEntries()).asScala()).toList(), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(read.deepEntries()).asScala()).toList());
    }

    @Test
    public void testMaxOffset() {
        int baseOffset = 50;
        LogSegment seg = this.createSegment(baseOffset, this.createSegment$default$2());
        MemoryRecords ms = this.records(baseOffset, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "beautiful"}));
        seg.append((long)baseOffset, 52L, -1L, -1L, ms);
        this.validate$1(50L, seg, ms);
        this.validate$1(51L, seg, ms);
        this.validate$1(52L, seg, ms);
    }

    @Test
    public void testReadAfterLast() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, 51L, -1L, -1L, ms);
        long x$18 = 52L;
        int x$19 = 200;
        None$ x$20 = None$.MODULE$;
        long x$21 = seg.read$default$4();
        boolean x$22 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$18, (Option)x$20, x$19, x$21, x$22);
        Assert.assertNull((String)"Read beyond the last offset in the segment should give null", (Object)read);
    }

    @Test
    public void testReadFromGap() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, 51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(60L, 61L, -1L, -1L, ms2);
        long x$23 = 55L;
        int x$24 = 200;
        None$ x$25 = None$.MODULE$;
        long x$26 = seg.read$default$4();
        boolean x$27 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$23, (Option)x$25, x$24, x$26, x$27);
        Assert.assertEquals((Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ms2.deepEntries()).asScala()).toList(), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(read.records().deepEntries()).asScala()).toList());
    }

    @Test
    public void testTruncate() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        IntRef offset = new IntRef(40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 30).foreach$mVc$sp((Function1)new Serializable(this, seg, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$2;
            private final IntRef offset$3;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                MemoryRecords ms1 = this.$outer.records(this.offset$3.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
                this.seg$2.append((long)this.offset$3.elem, (long)this.offset$3.elem, -1L, -1L, ms1);
                MemoryRecords ms2 = this.$outer.records(this.offset$3.elem + 1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
                this.seg$2.append((long)(this.offset$3.elem + 1), (long)(this.offset$3.elem + 1), -1L, -1L, ms2);
                FetchDataInfo read = this.seg$2.read((long)this.offset$3.elem, (Option)None$.MODULE$, 10000, this.seg$2.read$default$4(), this.seg$2.read$default$5());
                Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogEntry[]{(LogEntry)ms1.deepEntries().iterator().next(), (LogEntry)ms2.deepEntries().iterator().next()})), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(read.records().deepEntries()).asScala()).toList());
                this.seg$2.truncateTo((long)(this.offset$3.elem + 1));
                FetchDataInfo read2 = this.seg$2.read((long)this.offset$3.elem, (Option)None$.MODULE$, 10000, this.seg$2.read$default$4(), this.seg$2.read$default$5());
                Assert.assertEquals((long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(read2.records().deepEntries()).asScala()).size());
                Assert.assertEquals(ms1.deepEntries().iterator().next(), read2.records().deepEntries().iterator().next());
                ++this.offset$3.elem;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.seg$2 = seg$2;
                this.offset$3 = offset$3;
            }
        });
    }

    @Test
    public void testReloadLargestTimestampAfterTruncation() {
        int numMessages = 30;
        LogSegment seg = this.createSegment(40L, 2 * this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})).sizeInBytes() - 1);
        IntRef offset = new IntRef(40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, seg, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$3;
            private final IntRef offset$4;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                this.seg$3.append((long)this.offset$4.elem, (long)this.offset$4.elem, (long)this.offset$4.elem, (long)this.offset$4.elem, this.$outer.records(this.offset$4.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
                ++this.offset$4.elem;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.seg$3 = seg$3;
                this.offset$4 = offset$4;
            }
        });
        int expectedNumEntries = numMessages / 2 - 1;
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have ", " time indexes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedNumEntries)})), (long)expectedNumEntries, (long)seg.timeIndex().entries());
        seg.truncateTo(41L);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have 0 time indexes"})).s((Seq)Nil$.MODULE$), (long)0L, (long)seg.timeIndex().entries());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Largest timestamp should be 400"})).s((Seq)Nil$.MODULE$), (long)400L, (long)seg.largestTimestamp());
    }

    @Test
    public void testTruncateFull() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        seg.append(40L, 41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
        seg.truncateTo(0L);
        Assert.assertNull((String)"Segment should be empty.", (Object)seg.read(0L, (Option)None$.MODULE$, 1024, seg.read$default$4(), seg.read$default$5()));
        seg.append(40L, 41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
    }

    @Test
    public void testFindOffsetByTimestamp() {
        int messageSize = this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msg00"})).s((Seq)Nil$.MODULE$)})).sizeInBytes();
        LogSegment seg = this.createSegment(40L, messageSize * 2 - 1);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(40), 50).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$4;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.seg$4.append((long)i, (long)i, (long)(i * 10), (long)i, this.$outer.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msg", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.seg$4 = seg$4;
            }
        });
        Assert.assertEquals((long)490L, (long)seg.largestTimestamp());
        Assert.assertEquals((long)42L, (long)((TimestampOffset)seg.findOffsetByTimestamp(420L).get()).offset());
        Assert.assertEquals((long)43L, (long)((TimestampOffset)seg.findOffsetByTimestamp(421L).get()).offset());
        Assert.assertEquals((long)43L, (long)((TimestampOffset)seg.findOffsetByTimestamp(430L).get()).offset());
        Assert.assertEquals((long)44L, (long)((TimestampOffset)seg.findOffsetByTimestamp(431L).get()).offset());
        Assert.assertEquals((Object)None$.MODULE$, (Object)seg.findOffsetByTimestamp(491L));
        Assert.assertEquals((long)41L, (long)((TimestampOffset)seg.findOffsetByTimestamp(401L).get()).offset());
        Assert.assertEquals((long)40L, (long)((TimestampOffset)seg.findOffsetByTimestamp(399L).get()).offset());
    }

    @Test
    public void testNextOffsetCalculation() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        Assert.assertEquals((long)40L, (long)seg.nextOffset());
        seg.append(50L, 52L, -1L, -1L, this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assert.assertEquals((long)53L, (long)seg.nextOffset());
    }

    @Test
    public void testChangeFileSuffixes() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2());
        File logFile = seg.log().file();
        File indexFile = seg.index().file();
        seg.changeFileSuffixes("", ".deleted");
        Assert.assertEquals((Object)new StringBuilder().append((Object)logFile.getAbsolutePath()).append((Object)".deleted").toString(), (Object)seg.log().file().getAbsolutePath());
        Assert.assertEquals((Object)new StringBuilder().append((Object)indexFile.getAbsolutePath()).append((Object)".deleted").toString(), (Object)seg.index().file().getAbsolutePath());
        Assert.assertTrue((boolean)seg.log().file().exists());
        Assert.assertTrue((boolean)seg.index().file().exists());
    }

    @Test
    public void testRecoveryFixesCorruptIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$5;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.seg$5.append((long)i, (long)i, -1L, -1L, this.$outer.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.seg$5 = seg$5;
            }
        });
        File indexFile = seg.index().file();
        TestUtils$.MODULE$.writeNonsenseToFile(indexFile, 5L, (int)indexFile.length());
        seg.recover(65536);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final LogSegment seg$5;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)i, (long)((LogEntry)this.seg$5.read((long)i, (Option)new Some((Object)BoxesRunTime.boxToLong((long)(i + 1))), 1024, this.seg$5.read$default$4(), this.seg$5.read$default$5()).records().deepEntries().iterator().next()).offset());
            }
            {
                this.seg$5 = seg$5;
            }
        });
    }

    @Test
    public void testRecoveryFixesCorruptTimeIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final LogSegment seg$6;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.seg$6.append((long)i, (long)i, (long)(i * 10), (long)i, this.$outer.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.seg$6 = seg$6;
            }
        });
        File timeIndexFile = seg.timeIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(timeIndexFile, 5L, (int)timeIndexFile.length());
        seg.recover(65536);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, seg){
            public static final long serialVersionUID = 0L;
            private final LogSegment seg$6;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)i, (long)((TimestampOffset)this.seg$6.findOffsetByTimestamp((long)(i * 10)).get()).offset());
                if (i < 99) {
                    Assert.assertEquals((long)(i + 1), (long)((TimestampOffset)this.seg$6.findOffsetByTimestamp((long)(i * 10 + 1)).get()).offset());
                }
            }
            {
                this.seg$6 = seg$6;
            }
        });
    }

    @Test
    public void testRecoveryWithCorruptMessage() {
        int messagesAppended = 20;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, messagesAppended){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegmentTest $outer;
            private final int messagesAppended$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                LogSegment seg = this.$outer.createSegment(0L, this.$outer.createSegment$default$2());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.messagesAppended$1).foreach$mVc$sp((Function1)new Serializable(this, seg){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testRecoveryWithCorruptMessage$1 $outer;
                    private final LogSegment seg$7;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.seg$7.append((long)i, (long)i, -1L, -1L, this.$outer.kafka$log$LogSegmentTest$$anonfun$$$outer().records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)i)).toString()})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.seg$7 = seg$7;
                    }
                });
                int offsetToBeginCorruption = TestUtils$.MODULE$.random().nextInt(this.messagesAppended$1);
                FileRecords.LogEntryPosition recordPosition = seg.log().searchForOffsetWithSize((long)offsetToBeginCorruption, 0);
                int position = recordPosition.position + TestUtils$.MODULE$.random().nextInt(15);
                TestUtils$.MODULE$.writeNonsenseToFile(seg.log().file(), position, (int)(seg.log().file().length() - (long)position));
                seg.recover(65536);
                Assert.assertEquals((String)"Should have truncated off bad messages.", (Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), offsetToBeginCorruption).toList(), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(seg.log().shallowEntries()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(FileLogInputStream.FileChannelLogEntry x$2) {
                        return x$2.offset();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toList());
                seg.delete();
            }

            public /* synthetic */ LogSegmentTest kafka$log$LogSegmentTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.messagesAppended$1 = messagesAppended$1;
            }
        });
    }

    public LogSegment createSegment(long offset, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogSegment seg = new LogSegment(tempDir, offset, 10, 1000, 0L, Time.SYSTEM, fileAlreadyExists, initFileSize, preallocate);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public int createSegment$default$2() {
        return 10;
    }

    @Test
    public void testCreateWithInitFileSizeAppendMessage() {
        LogSegment seg = this.createSegment(40L, false, 0x20000000, true);
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, 51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(60L, 61L, -1L, -1L, ms2);
        long x$28 = 55L;
        int x$29 = 200;
        None$ x$30 = None$.MODULE$;
        long x$31 = seg.read$default$4();
        boolean x$32 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$28, (Option)x$30, x$29, x$31, x$32);
        Assert.assertEquals((Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ms2.deepEntries()).asScala()).toList(), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(read.records().deepEntries()).asScala()).toList());
    }

    @Test
    public void testCreateWithInitFileSizeClearShutdown() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogSegment seg = new LogSegment(tempDir, 40L, 10, 1000, 0L, Time.SYSTEM, false, 0x20000000, true);
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(50L, 51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(60L, 61L, -1L, -1L, ms2);
        long x$33 = 55L;
        int x$34 = 200;
        None$ x$35 = None$.MODULE$;
        long x$36 = seg.read$default$4();
        boolean x$37 = seg.read$default$5();
        FetchDataInfo read = seg.read(x$33, (Option)x$35, x$34, x$36, x$37);
        Assert.assertEquals((Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ms2.deepEntries()).asScala()).toList(), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(read.records().deepEntries()).asScala()).toList());
        int oldSize = seg.log().sizeInBytes();
        long oldPosition = seg.log().channel().position();
        long oldFileSize = seg.log().file().length();
        Assert.assertEquals((long)0x20000000L, (long)oldFileSize);
        seg.close();
        Assert.assertEquals((long)oldSize, (long)seg.log().file().length());
        LogSegment segReopen = new LogSegment(tempDir, 40L, 10, 1000, 0L, Time.SYSTEM, true, 0x20000000, true);
        this.segments().$plus$eq((Object)segReopen);
        long x$38 = 55L;
        int x$39 = 200;
        None$ x$40 = None$.MODULE$;
        long x$41 = segReopen.read$default$4();
        boolean x$42 = segReopen.read$default$5();
        FetchDataInfo readAgain = segReopen.read(x$38, (Option)x$40, x$39, x$41, x$42);
        Assert.assertEquals((Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ms2.deepEntries()).asScala()).toList(), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(readAgain.records().deepEntries()).asScala()).toList());
        int size2 = segReopen.log().sizeInBytes();
        long position = segReopen.log().channel().position();
        long fileSize = segReopen.log().file().length();
        Assert.assertEquals((long)oldPosition, (long)position);
        Assert.assertEquals((long)oldSize, (long)size2);
        Assert.assertEquals((long)size2, (long)fileSize);
    }

    private final void validate$1(long offset, LogSegment seg$1, MemoryRecords ms$1) {
        long x$13 = offset;
        int x$14 = 1024;
        Some x$15 = new Some((Object)BoxesRunTime.boxToLong((long)(offset + 1L)));
        long x$16 = seg$1.read$default$4();
        boolean x$17 = seg$1.read$default$5();
        Assert.assertEquals((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ms$1.deepEntries()).asScala()).filter((Function1)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final long offset$2;

            public final boolean apply(LogEntry x$1) {
                return x$1.offset() == this.offset$2;
            }
            {
                this.offset$2 = offset$2;
            }
        })).toList(), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(seg$1.read(x$13, (Option)x$15, x$14, x$16, x$17).records().deepEntries()).asScala()).toList());
    }
}

