/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.nio.ByteBuffer;
import kafka.log.LogValidator;
import kafka.log.LogValidator$;
import kafka.message.CompressionCodec;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.Message$;
import kafka.message.NoCompressionCodec$;
import kafka.message.SnappyCompressionCodec$;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.record.ByteBufferLogInputStream;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.InvalidRecordException;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.TimestampType;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0003T8h-\u0006d\u0017\u000eZ1u_J$Vm\u001d;\u000b\u0005\r!\u0011a\u00017pO*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u0011\u001b\u0005Q!BA\u0006\r\u0003\u0015QWO\\5u\u0015\tia\"A\u0005tG\u0006d\u0017\r^3ti*\tq\"A\u0002pe\u001eL!!\u0005\u0006\u0003\u0015)+f.\u001b;Tk&$X\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0005!)\u0001\u0004\u0001C\u00013\u0005qB/Z:u\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3O_:\u001cu.\u001c9sKN\u001cX\r\u001a\u000b\u00025A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t!QK\\5uQ\t9\u0012\u0005\u0005\u0002#I5\t1E\u0003\u0002\f\u001d%\u0011Qe\t\u0002\u0005)\u0016\u001cH\u000fC\u0003(\u0001\u0011\u0005\u0011$\u0001\u0012uKN$Hj\\4BaB,g\u000e\u001a+j[\u0016<\u0016\u000e\u001e5SK\u000e|W\u000e\u001d:fgNLwN\u001c\u0015\u0003M\u0005BQA\u000b\u0001\u0005\u0002e\tQ\u0005^3ti2{w-\u00119qK:$G+[7f/&$\bn\\;u%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8)\u0005%\n\u0003\"B\u0017\u0001\t\u0003I\u0012a\u0007;fgR\u001c%/Z1uKRKW.\u001a(p]\u000e{W\u000e\u001d:fgN,G\r\u000b\u0002-C!)\u0001\u0007\u0001C\u00013\u0005AB/Z:u\u0007J,\u0017\r^3US6,7i\\7qe\u0016\u001c8/\u001a3)\u0005=\n\u0003\"B\u001a\u0001\t\u0003I\u0012A\t;fgRLeN^1mS\u0012\u001c%/Z1uKRKW.\u001a(p]\u000e{W\u000e\u001d:fgN,G\r\u000b\u00033CU2\u0014\u0001C3ya\u0016\u001cG/\u001a3$\u0003]\u0002\"\u0001\u000f!\u000e\u0003eR!AO\u001e\u0002\r\u0015\u0014(o\u001c:t\u0015\taT(\u0001\u0004d_6lwN\u001c\u0006\u0003\u000byR!a\u0010\b\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\t\u0015HA\rJ]Z\fG.\u001b3US6,7\u000f^1na\u0016C8-\u001a9uS>t\u0007\"B\"\u0001\t\u0003I\u0012a\b;fgRLeN^1mS\u0012\u001c%/Z1uKRKW.Z\"p[B\u0014Xm]:fI\"\"!)I\u001b7\u0011\u00151\u0005\u0001\"\u0001\u001a\u0003%\"Xm\u001d;BEN|G.\u001e;f\u001f\u001a47/\u001a;BgNLwM\\7f]RtuN\\\"p[B\u0014Xm]:fI\"\u0012Q)\t\u0005\u0006\u0013\u0002!\t!G\u0001'i\u0016\u001cH/\u00112t_2,H/Z(gMN,G/Q:tS\u001etW.\u001a8u\u0007>l\u0007O]3tg\u0016$\u0007F\u0001%\"\u0011\u0015a\u0005\u0001\"\u0001\u001a\u0003%\"Xm\u001d;SK2\fG/\u001b<f\u001f\u001a47/\u001a;BgNLwM\\7f]RtuN\\\"p[B\u0014Xm]:fI\"\u00121*\t\u0005\u0006\u001f\u0002!\t!G\u0001'i\u0016\u001cHOU3mCRLg/Z(gMN,G/Q:tS\u001etW.\u001a8u\u0007>l\u0007O]3tg\u0016$\u0007F\u0001(\"\u0011\u0015\u0011\u0006\u0001\"\u0001\u001a\u0003}\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:NKN\u001c\u0018mZ3G_Jl\u0017\r^\"p]Z,'o]5p]Z\u0003dj\u001c8D_6\u0004(/Z:tK\u0012D#!U\u0011\t\u000bU\u0003A\u0011A\r\u0002yQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM]'fgN\fw-\u001a$pe6\fGoQ8om\u0016\u00148/[8o-B\u001au.\u001c9sKN\u001cX\r\u001a\u0015\u0003)\u0006BQ\u0001\u0017\u0001\u0005\u0002e\tq\b^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;fe6+7o]1hK\u001a{'/\\1u\u0007>tg/\u001a:tS>tg+\r(p]\u000e{W\u000e\u001d:fgN,G\r\u000b\u0002XC!)1\f\u0001C\u00013\u0005aD/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s\u001b\u0016\u001c8/Y4f\r>\u0014X.\u0019;D_:4XM]:j_:4\u0016gQ8naJ,7o]3eQ\tQ\u0016\u0005C\u0003_\u0001\u0011\u0005\u0011$\u0001\u000fuKN$\u0018J\u001c<bY&$\u0017J\u001c8fe6\u000bw-[2WKJ\u001c\u0018n\u001c8)\tu\u000bS\u0007Y\u0012\u0002CB\u0011!-Z\u0007\u0002G*\u0011AmO\u0001\u0007e\u0016\u001cwN\u001d3\n\u0005\u0019\u001c'AF%om\u0006d\u0017\u000e\u001a*fG>\u0014H-\u0012=dKB$\u0018n\u001c8\t\u000b!\u0004A\u0011B5\u0002\u001b\r\u0014X-\u0019;f%\u0016\u001cwN\u001d3t)\u0011QWN]<\u0011\u0005\t\\\u0017B\u00017d\u00055iU-\\8ssJ+7m\u001c:eg\"9an\u001aI\u0001\u0002\u0004y\u0017AC7bO&\u001cg+\u00197vKB\u00111\u0004]\u0005\u0003cr\u0011AAQ=uK\"91o\u001aI\u0001\u0002\u0004!\u0018!\u0003;j[\u0016\u001cH/Y7q!\tYR/\u0003\u0002w9\t!Aj\u001c8h\u0011\u001dAx\r%AA\u0002e\fQaY8eK\u000e\u0004\"A\u0019>\n\u0005m\u001c'aD\"p[B\u0014Xm]:j_:$\u0016\u0010]3\t\u000bu\u0004A\u0011\u0002@\u0002\u0019\rDWmY6PM\u001a\u001cX\r^:\u0015\tiy\u00181\u0001\u0005\u0007\u0003\u0003a\b\u0019\u00016\u0002\u000fI,7m\u001c:eg\"1\u0011Q\u0001?A\u0002Q\f!BY1tK>3gm]3u\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017\tAD]3d_J$7oV5uQ&sg/\u00197jI&sg.\u001a:NC\u001eL7\rF\u0002k\u0003\u001bAq!a\u0004\u0002\b\u0001\u0007A/A\u0007j]&$\u0018.\u00197PM\u001a\u001cX\r\u001e\u0005\b\u0003'\u0001A\u0011AA\u000b\u0003U1\u0018\r\\5eCR,Gj\\4BaB,g\u000e\u001a+j[\u0016$RAGA\f\u00037Aq!!\u0007\u0002\u0012\u0001\u0007A/A\u0002o_^Dq\u0001ZA\t\u0001\u0004\ti\u0002E\u0002c\u0003?I1!!\td\u0005\u0019\u0011VmY8sI\"I\u0011Q\u0005\u0001\u0012\u0002\u0013%\u0011qE\u0001\u0018GJ,\u0017\r^3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIE*\"!!\u000b+\u0007=\fYc\u000b\u0002\u0002.A!\u0011qFA\u001d\u001b\t\t\tD\u0003\u0003\u00024\u0005U\u0012!C;oG\",7m[3e\u0015\r\t9\u0004H\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001e\u0003c\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\ty\u0004AI\u0001\n\u0013\t\t%A\fde\u0016\fG/\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\t\u0016\u0004i\u0006-\u0002\"CA$\u0001E\u0005I\u0011BA%\u0003]\u0019'/Z1uKJ+7m\u001c:eg\u0012\"WMZ1vYR$3'\u0006\u0002\u0002L)\u001a\u00110a\u000b")
public class LogValidatorTest
extends JUnitSuite {
    @Test
    public void testLogAppendTimeNonCompressed() {
        MemoryRecords records2;
        long now = System.currentTimeMillis();
        MemoryRecords x$2 = records2 = this.createRecords((byte)1, 0L, CompressionType.NONE);
        kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
        long x$4 = now;
        NoCompressionCodec$ x$5 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$6 = NoCompressionCodec$.MODULE$;
        byte x$7 = 1;
        TimestampType x$8 = TimestampType.LOG_APPEND_TIME;
        long x$9 = 1000L;
        boolean x$10 = LogValidator$.MODULE$.validateMessagesAndAssignOffsets$default$6();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$2, x$3, x$4, (CompressionCodec)x$5, (CompressionCodec)x$6, x$10, x$7, x$8, x$9);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"number of messages should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.deepEntries()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.deepEntries()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.deepEntries()).asScala()).foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long now$1;

            public final void apply(LogEntry logEntry) {
                this.$outer.validateLogAppendTime(this.now$1, logEntry.record());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.now$1 = now$1;
            }
        });
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)})), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The offset of max timestamp should be 0"})).s((Seq)Nil$.MODULE$), (long)0L, (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
    }

    @Test
    public void testLogAppendTimeWithRecompression() {
        MemoryRecords records2;
        long now = System.currentTimeMillis();
        byte x$11 = 0;
        CompressionType x$12 = CompressionType.GZIP;
        long x$13 = this.createRecords$default$2();
        MemoryRecords x$14 = records2 = this.createRecords(x$11, x$13, x$12);
        kafka.common.LongRef x$15 = new kafka.common.LongRef(0L);
        long x$16 = now;
        DefaultCompressionCodec$ x$17 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$18 = DefaultCompressionCodec$.MODULE$;
        byte x$19 = 1;
        TimestampType x$20 = TimestampType.LOG_APPEND_TIME;
        long x$21 = 1000L;
        boolean x$22 = LogValidator$.MODULE$.validateMessagesAndAssignOffsets$default$6();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$14, x$15, x$16, (CompressionCodec)x$17, (CompressionCodec)x$18, x$22, x$19, x$20, x$21);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"number of messages should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.deepEntries()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.deepEntries()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.deepEntries()).asScala()).foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long now$2;

            public final void apply(LogEntry logEntry) {
                this.$outer.validateLogAppendTime(this.now$2, logEntry.record());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.now$2 = now$2;
            }
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((ByteBufferLogInputStream.ByteBufferLogEntry)validatedRecords.shallowEntries().iterator().next()).record().isValid());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)})), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.deepEntries()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.deepEntries()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size may have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
    }

    @Test
    public void testLogAppendTimeWithoutRecompression() {
        MemoryRecords records2;
        long now = System.currentTimeMillis();
        MemoryRecords x$23 = records2 = this.createRecords((byte)1, 0L, CompressionType.GZIP);
        kafka.common.LongRef x$24 = new kafka.common.LongRef(0L);
        long x$25 = now;
        DefaultCompressionCodec$ x$26 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$27 = DefaultCompressionCodec$.MODULE$;
        byte x$28 = 1;
        TimestampType x$29 = TimestampType.LOG_APPEND_TIME;
        long x$30 = 1000L;
        boolean x$31 = LogValidator$.MODULE$.validateMessagesAndAssignOffsets$default$6();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$23, x$24, x$25, (CompressionCodec)x$26, (CompressionCodec)x$27, x$31, x$28, x$29, x$30);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"number of messages should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.deepEntries()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.deepEntries()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.deepEntries()).asScala()).foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long now$3;

            public final void apply(LogEntry logEntry) {
                this.$outer.validateLogAppendTime(this.now$3, logEntry.record());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.now$3 = now$3;
            }
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((ByteBufferLogInputStream.ByteBufferLogEntry)validatedRecords.shallowEntries().iterator().next()).record().isValid());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)})), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.deepEntries()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.deepEntries()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
    }

    @Test
    public void testCreateTimeNonCompressed() {
        MemoryRecords records2;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        MemoryRecords x$32 = records2 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (Record[])new Record[]{Record.create((byte)1, (long)BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), (byte[])"hello".getBytes()), Record.create((byte)1, (long)BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), (byte[])"there".getBytes()), Record.create((byte)1, (long)BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), (byte[])"beautiful".getBytes())});
        kafka.common.LongRef x$33 = new kafka.common.LongRef(0L);
        long x$34 = System.currentTimeMillis();
        NoCompressionCodec$ x$35 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$36 = NoCompressionCodec$.MODULE$;
        byte x$37 = 1;
        TimestampType x$38 = TimestampType.CREATE_TIME;
        long x$39 = 1000L;
        boolean x$40 = LogValidator$.MODULE$.validateMessagesAndAssignOffsets$default$6();
        LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$32, x$33, x$34, (CompressionCodec)x$35, (CompressionCodec)x$36, x$40, x$37, x$38, x$39);
        MemoryRecords validatedRecords = validatingResults.validatedRecords();
        IntRef i = new IntRef(0);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.deepEntries()).asScala()).foreach((Function1)new Serializable(this, timestampSeq, i){
            public static final long serialVersionUID = 0L;
            private final Seq timestampSeq$1;
            private final IntRef i$1;

            public final void apply(LogEntry logEntry) {
                logEntry.record().ensureValid();
                Assert.assertEquals((long)logEntry.record().timestamp(), (long)BoxesRunTime.unboxToLong((Object)this.timestampSeq$1.apply(this.i$1.elem)));
                Assert.assertEquals((Object)logEntry.record().timestampType(), (Object)TimestampType.CREATE_TIME);
                ++this.i$1.elem;
            }
            {
                this.timestampSeq$1 = timestampSeq$1;
                this.i$1 = i$1;
            }
        });
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now + 1L))})), (long)(now + 1L), (long)validatingResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be 1"})).s((Seq)Nil$.MODULE$), (long)1L, (long)validatingResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
    }

    @Test
    public void testCreateTimeCompressed() {
        MemoryRecords records2;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        MemoryRecords x$41 = records2 = MemoryRecords.withRecords((CompressionType)CompressionType.GZIP, (Record[])new Record[]{Record.create((byte)1, (long)BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), (byte[])"hello".getBytes()), Record.create((byte)1, (long)BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), (byte[])"there".getBytes()), Record.create((byte)1, (long)BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), (byte[])"beautiful".getBytes())});
        kafka.common.LongRef x$42 = new kafka.common.LongRef(0L);
        long x$43 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$44 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$45 = DefaultCompressionCodec$.MODULE$;
        byte x$46 = 1;
        TimestampType x$47 = TimestampType.CREATE_TIME;
        long x$48 = 1000L;
        boolean x$49 = LogValidator$.MODULE$.validateMessagesAndAssignOffsets$default$6();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$41, x$42, x$43, (CompressionCodec)x$44, (CompressionCodec)x$45, x$49, x$46, x$47, x$48);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        IntRef i = new IntRef(0);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.deepEntries()).asScala()).foreach((Function1)new Serializable(this, timestampSeq, i){
            public static final long serialVersionUID = 0L;
            private final Seq timestampSeq$2;
            private final IntRef i$2;

            public final void apply(LogEntry logEntry) {
                logEntry.record().ensureValid();
                Assert.assertEquals((long)logEntry.record().timestamp(), (long)BoxesRunTime.unboxToLong((Object)this.timestampSeq$2.apply(this.i$2.elem)));
                Assert.assertEquals((Object)logEntry.record().timestampType(), (Object)TimestampType.CREATE_TIME);
                ++this.i$2.elem;
            }
            {
                this.timestampSeq$2 = timestampSeq$2;
                this.i$2 = i$2;
            }
        });
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now + 1L))})), (long)(now + 1L), (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.deepEntries()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.deepEntries()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
    }

    @Test(expected=InvalidTimestampException.class)
    public void testInvalidCreateTimeNonCompressed() {
        MemoryRecords records2;
        long now = System.currentTimeMillis();
        MemoryRecords x$50 = records2 = this.createRecords((byte)1, now - 1001L, CompressionType.NONE);
        kafka.common.LongRef x$51 = new kafka.common.LongRef(0L);
        long x$52 = System.currentTimeMillis();
        NoCompressionCodec$ x$53 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$54 = NoCompressionCodec$.MODULE$;
        byte x$55 = 1;
        TimestampType x$56 = TimestampType.CREATE_TIME;
        long x$57 = 1000L;
        boolean x$58 = LogValidator$.MODULE$.validateMessagesAndAssignOffsets$default$6();
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$50, x$51, x$52, (CompressionCodec)x$53, (CompressionCodec)x$54, x$58, x$55, x$56, x$57);
    }

    @Test(expected=InvalidTimestampException.class)
    public void testInvalidCreateTimeCompressed() {
        MemoryRecords records2;
        long now = System.currentTimeMillis();
        MemoryRecords x$59 = records2 = this.createRecords((byte)1, now - 1001L, CompressionType.GZIP);
        kafka.common.LongRef x$60 = new kafka.common.LongRef(0L);
        long x$61 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$62 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$63 = DefaultCompressionCodec$.MODULE$;
        byte x$64 = 1;
        TimestampType x$65 = TimestampType.CREATE_TIME;
        long x$66 = 1000L;
        boolean x$67 = LogValidator$.MODULE$.validateMessagesAndAssignOffsets$default$6();
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$59, x$60, x$61, (CompressionCodec)x$62, (CompressionCodec)x$63, x$67, x$64, x$65, x$66);
    }

    @Test
    public void testAbsoluteOffsetAssignmentNonCompressed() {
        byte x$68 = 0;
        CompressionType x$69 = CompressionType.NONE;
        long x$70 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$68, x$70, x$69);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords x$71 = records2;
        kafka.common.LongRef x$72 = new kafka.common.LongRef((long)offset);
        long x$73 = System.currentTimeMillis();
        NoCompressionCodec$ x$74 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$75 = NoCompressionCodec$.MODULE$;
        byte x$76 = 0;
        TimestampType x$77 = TimestampType.CREATE_TIME;
        long x$78 = 1000L;
        boolean x$79 = LogValidator$.MODULE$.validateMessagesAndAssignOffsets$default$6();
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$71, x$72, x$73, (CompressionCodec)x$74, (CompressionCodec)x$75, x$79, x$76, x$77, x$78).validatedRecords(), offset);
    }

    @Test
    public void testAbsoluteOffsetAssignmentCompressed() {
        byte x$80 = 0;
        CompressionType x$81 = CompressionType.GZIP;
        long x$82 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$80, x$82, x$81);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords x$83 = records2;
        kafka.common.LongRef x$84 = new kafka.common.LongRef((long)offset);
        long x$85 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$86 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$87 = DefaultCompressionCodec$.MODULE$;
        byte x$88 = 0;
        TimestampType x$89 = TimestampType.CREATE_TIME;
        long x$90 = 1000L;
        boolean x$91 = LogValidator$.MODULE$.validateMessagesAndAssignOffsets$default$6();
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$83, x$84, x$85, (CompressionCodec)x$86, (CompressionCodec)x$87, x$91, x$88, x$89, x$90).validatedRecords(), offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressed() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords x$92 = records2;
        kafka.common.LongRef x$93 = new kafka.common.LongRef((long)offset);
        long x$94 = System.currentTimeMillis();
        NoCompressionCodec$ x$95 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$96 = NoCompressionCodec$.MODULE$;
        TimestampType x$97 = TimestampType.CREATE_TIME;
        long x$98 = 5000L;
        boolean x$99 = LogValidator$.MODULE$.validateMessagesAndAssignOffsets$default$6();
        byte x$100 = LogValidator$.MODULE$.validateMessagesAndAssignOffsets$default$7();
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$92, x$93, x$94, (CompressionCodec)x$95, (CompressionCodec)x$96, x$99, x$100, x$97, x$98).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressed() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords x$101 = records2;
        kafka.common.LongRef x$102 = new kafka.common.LongRef((long)offset);
        long x$103 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$104 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$105 = DefaultCompressionCodec$.MODULE$;
        TimestampType x$106 = TimestampType.CREATE_TIME;
        long x$107 = 5000L;
        boolean x$108 = LogValidator$.MODULE$.validateMessagesAndAssignOffsets$default$6();
        byte x$109 = LogValidator$.MODULE$.validateMessagesAndAssignOffsets$default$7();
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$101, x$102, x$103, (CompressionCodec)x$104, (CompressionCodec)x$105, x$108, x$109, x$106, x$107).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testOffsetAssignmentAfterMessageFormatConversionV0NonCompressed() {
        byte x$110 = 0;
        CompressionType x$111 = CompressionType.NONE;
        long x$112 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$110, x$112, x$111);
        this.checkOffsets(records2, 0L);
        int offset = 1234567;
        MemoryRecords x$113 = records2;
        kafka.common.LongRef x$114 = new kafka.common.LongRef((long)offset);
        long x$115 = System.currentTimeMillis();
        NoCompressionCodec$ x$116 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$117 = NoCompressionCodec$.MODULE$;
        byte x$118 = 1;
        TimestampType x$119 = TimestampType.LOG_APPEND_TIME;
        long x$120 = 1000L;
        boolean x$121 = LogValidator$.MODULE$.validateMessagesAndAssignOffsets$default$6();
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$113, x$114, x$115, (CompressionCodec)x$116, (CompressionCodec)x$117, x$121, x$118, x$119, x$120).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterMessageFormatConversionV0Compressed() {
        byte x$122 = 0;
        CompressionType x$123 = CompressionType.GZIP;
        long x$124 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$122, x$124, x$123);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords x$125 = records2;
        kafka.common.LongRef x$126 = new kafka.common.LongRef((long)offset);
        long x$127 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$128 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$129 = DefaultCompressionCodec$.MODULE$;
        byte x$130 = 1;
        TimestampType x$131 = TimestampType.LOG_APPEND_TIME;
        long x$132 = 1000L;
        boolean x$133 = LogValidator$.MODULE$.validateMessagesAndAssignOffsets$default$6();
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$125, x$126, x$127, (CompressionCodec)x$128, (CompressionCodec)x$129, x$133, x$130, x$131, x$132).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterMessageFormatConversionV1NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.NONE);
        this.checkOffsets(records2, 0L);
        MemoryRecords x$134 = records2;
        kafka.common.LongRef x$135 = new kafka.common.LongRef((long)offset);
        long x$136 = System.currentTimeMillis();
        NoCompressionCodec$ x$137 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$138 = NoCompressionCodec$.MODULE$;
        byte x$139 = 0;
        TimestampType x$140 = TimestampType.CREATE_TIME;
        long x$141 = 5000L;
        boolean x$142 = LogValidator$.MODULE$.validateMessagesAndAssignOffsets$default$6();
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$134, x$135, x$136, (CompressionCodec)x$137, (CompressionCodec)x$138, x$142, x$139, x$140, x$141).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterMessageFormatConversionV1Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.GZIP);
        this.checkOffsets(records2, 0L);
        MemoryRecords x$143 = records2;
        kafka.common.LongRef x$144 = new kafka.common.LongRef((long)offset);
        long x$145 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$146 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$147 = DefaultCompressionCodec$.MODULE$;
        byte x$148 = 0;
        TimestampType x$149 = TimestampType.CREATE_TIME;
        long x$150 = 5000L;
        boolean x$151 = LogValidator$.MODULE$.validateMessagesAndAssignOffsets$default$6();
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$143, x$144, x$145, (CompressionCodec)x$146, (CompressionCodec)x$147, x$151, x$148, x$149, x$150).validatedRecords(), offset);
    }

    @Test(expected=InvalidRecordException.class)
    public void testInvalidInnerMagicVersion() {
        MemoryRecords records2;
        int offset = 1234567;
        MemoryRecords x$152 = records2 = this.recordsWithInvalidInnerMagic(offset);
        kafka.common.LongRef x$153 = new kafka.common.LongRef((long)offset);
        long x$154 = System.currentTimeMillis();
        SnappyCompressionCodec$ x$155 = SnappyCompressionCodec$.MODULE$;
        SnappyCompressionCodec$ x$156 = SnappyCompressionCodec$.MODULE$;
        TimestampType x$157 = TimestampType.CREATE_TIME;
        long x$158 = 5000L;
        boolean x$159 = LogValidator$.MODULE$.validateMessagesAndAssignOffsets$default$6();
        byte x$160 = LogValidator$.MODULE$.validateMessagesAndAssignOffsets$default$7();
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$152, x$153, x$154, (CompressionCodec)x$155, (CompressionCodec)x$156, x$159, x$160, x$157, x$158);
    }

    private MemoryRecords createRecords(byte magicValue, long timestamp, CompressionType codec) {
        return magicValue == 0 ? MemoryRecords.withRecords((CompressionType)codec, (Record[])new Record[]{Record.create((byte)0, (long)-1L, (byte[])"hello".getBytes()), Record.create((byte)0, (long)-1L, (byte[])"there".getBytes()), Record.create((byte)0, (long)-1L, (byte[])"beautiful".getBytes())}) : MemoryRecords.withRecords((CompressionType)codec, (Record[])new Record[]{Record.create((byte)1, (long)timestamp, (byte[])"hello".getBytes()), Record.create((byte)1, (long)timestamp, (byte[])"there".getBytes()), Record.create((byte)1, (long)timestamp, (byte[])"beautiful".getBytes())});
    }

    private byte createRecords$default$1() {
        return Message$.MODULE$.CurrentMagicValue();
    }

    private long createRecords$default$2() {
        return Message$.MODULE$.NoTimestamp();
    }

    private CompressionType createRecords$default$3() {
        return CompressionType.NONE;
    }

    private void checkOffsets(MemoryRecords records2, long baseOffset) {
        Assert.assertTrue((String)"Message set should not be empty", (boolean)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.deepEntries()).asScala()).nonEmpty());
        LongRef offset = new LongRef(baseOffset);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.deepEntries()).asScala()).foreach((Function1)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final LongRef offset$1;

            public final void apply(LogEntry entry) {
                Assert.assertEquals((String)"Unexpected offset in message set iterator", (long)this.offset$1.elem, (long)entry.offset());
                ++this.offset$1.elem;
            }
            {
                this.offset$1 = offset$1;
            }
        });
    }

    private MemoryRecords recordsWithInvalidInnerMagic(long initialOffset) {
        IndexedSeq records2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Record apply(int id) {
                return Record.create((byte)0, (long)-1L, (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes(), (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ByteBuffer buffer = ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Record x$1) {
                return x$1.sizeInBytes();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME);
        LongRef offset = new LongRef(initialOffset);
        records2.foreach((Function1)new Serializable(this, builder, offset){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$1;
            private final LongRef offset$2;

            public final void apply(Record record) {
                this.builder$1.appendUnchecked(this.offset$2.elem, record);
                ++this.offset$2.elem;
            }
            {
                this.builder$1 = builder$1;
                this.offset$2 = offset$2;
            }
        });
        return builder.build();
    }

    public void validateLogAppendTime(long now, Record record) {
        record.ensureValid();
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timestamp of message ", " should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record, BoxesRunTime.boxToLong((long)now)})), (long)now, (long)record.timestamp());
        Assert.assertEquals((Object)TimestampType.LOG_APPEND_TIME, (Object)record.timestampType());
    }
}

