/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.CompressionFactory$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.LZ4CompressionCodec$;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.SnappyCompressionCodec$;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.apache.kafka.common.record.KafkaLZ4BlockInputStream;
import org.apache.kafka.common.record.KafkaLZ4BlockOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import org.xerial.snappy.SnappyError;
import org.xerial.snappy.SnappyOutputStream;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001\u000f\t1R*Z:tC\u001e,7i\\7qe\u0016\u001c8/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u00059Q.Z:tC\u001e,'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013Ai\u0011A\u0003\u0006\u0003\u00171\tQA[;oSRT!!\u0004\b\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\b\u0002\u0007=\u0014x-\u0003\u0002\u0012\u0015\tQ!*\u00168jiN+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001\"\u0002\r\u0001\t\u0003I\u0012\u0001\u0005;fgRd%\f\u000e$sC6Lgn\u001a,1)\u0005Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"\u0001B+oSRD#aF\u0011\u0011\u0005\t\"S\"A\u0012\u000b\u0005-q\u0011BA\u0013$\u0005\u0011!Vm\u001d;\t\u000b\u001d\u0002A\u0011A\r\u0002!Q,7\u000f\u001e'[i\u0019\u0013\u0018-\\5oOZ\u000b\u0004F\u0001\u0014\"\u0011\u0015Q\u0003\u0001\"\u0001\u001a\u0003q!Xm\u001d;TS6\u0004H.Z\"p[B\u0014Xm]:EK\u000e|W\u000e\u001d:fgND#!K\u0011\t\u000b5\u0002A\u0011A\r\u0002!Q,7\u000f^\"p[B\u0014Xm]:TSj,\u0007F\u0001\u0017\"\u0011\u0015Q\u0003\u0001\"\u00011)\tQ\u0012\u0007C\u00033_\u0001\u00071'\u0001\td_6\u0004(/Z:tS>t7i\u001c3fGB\u0011a\u0003N\u0005\u0003k\t\u0011\u0001cQ8naJ,7o]5p]\u000e{G-Z2\t\u000b5\u0002A\u0011A\u001c\u0015\tiA\u0014H\u0013\u0005\u0006eY\u0002\ra\r\u0005\u0006uY\u0002\raO\u0001\t[\u0016\u001c8/Y4fgB\u0019A\bR$\u000f\u0005u\u0012eB\u0001 B\u001b\u0005y$B\u0001!\u0007\u0003\u0019a$o\\8u}%\tQ$\u0003\u0002D9\u00059\u0001/Y2lC\u001e,\u0017BA#G\u0005\u0011a\u0015n\u001d;\u000b\u0005\rc\u0002C\u0001\fI\u0013\tI%AA\u0004NKN\u001c\u0018mZ3\t\u000b-3\u0004\u0019\u0001'\u0002\u0019\u0015D\b/Z2uK\u0012\u001c\u0016N_3\u0011\u0005mi\u0015B\u0001(\u001d\u0005\rIe\u000e\u001e\u0005\u0006!\u0002!\t!U\u0001\u0012SN\u001cf.\u00199qs\u00063\u0018-\u001b7bE2,W#\u0001*\u0011\u0005m\u0019\u0016B\u0001+\u001d\u0005\u001d\u0011un\u001c7fC:DQA\u0016\u0001\u0005\u0002E\u000ba\"[:M5R\ne/Y5mC\ndW\r")
public class MessageCompressionTest
extends JUnitSuite {
    @Test
    public void testLZ4FramingV0() {
        OutputStream output = CompressionFactory$.MODULE$.apply((CompressionCodec)LZ4CompressionCodec$.MODULE$, Message$.MODULE$.MagicValue_V0(), (OutputStream)new ByteArrayOutputStream());
        Assert.assertTrue((boolean)((KafkaLZ4BlockOutputStream)output).useBrokenFlagDescriptorChecksum());
        InputStream input = CompressionFactory$.MODULE$.apply((CompressionCodec)LZ4CompressionCodec$.MODULE$, Message$.MODULE$.MagicValue_V0(), ByteBuffer.wrap((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{4, 34, 77, 24, 96, 64, 26}), ClassTag$.MODULE$.Byte())));
        Assert.assertTrue((boolean)((KafkaLZ4BlockInputStream)input).ignoreFlagDescriptorChecksum());
    }

    @Test
    public void testLZ4FramingV1() {
        OutputStream output = CompressionFactory$.MODULE$.apply((CompressionCodec)LZ4CompressionCodec$.MODULE$, Message$.MODULE$.MagicValue_V1(), (OutputStream)new ByteArrayOutputStream());
        Assert.assertFalse((boolean)((KafkaLZ4BlockOutputStream)output).useBrokenFlagDescriptorChecksum());
        InputStream input = CompressionFactory$.MODULE$.apply((CompressionCodec)LZ4CompressionCodec$.MODULE$, Message$.MODULE$.MagicValue_V1(), ByteBuffer.wrap((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{4, 34, 77, 24, 96, 64, -126}), ClassTag$.MODULE$.Byte())));
        Assert.assertFalse((boolean)((KafkaLZ4BlockInputStream)input).ignoreFlagDescriptorChecksum());
    }

    @Test
    public void testSimpleCompressDecompress() {
        ArrayBuffer codecs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CompressionCodec[]{GZIPCompressionCodec$.MODULE$}));
        Object object = this.isSnappyAvailable() ? codecs.$plus$eq((Object)SnappyCompressionCodec$.MODULE$) : BoxedUnit.UNIT;
        Object object2 = this.isLZ4Available() ? codecs.$plus$eq((Object)LZ4CompressionCodec$.MODULE$) : BoxedUnit.UNIT;
        codecs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MessageCompressionTest $outer;

            public final void apply(CompressionCodec codec) {
                this.$outer.testSimpleCompressDecompress(codec);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testCompressSize() {
        byte[] bytes1k = (byte[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply(int x$1) {
                return (byte)x$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte());
        byte[] bytes2k = (byte[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1000), 2000).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply(int x$2) {
                return (byte)x$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte());
        byte[] bytes3k = (byte[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3000), 4000).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply(int x$3) {
                return (byte)x$3;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Byte());
        List messages = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(bytes1k, Message$.MODULE$.NoTimestamp(), Message$.MODULE$.MagicValue_V1()), new Message(bytes2k, Message$.MODULE$.NoTimestamp(), Message$.MODULE$.MagicValue_V1()), new Message(bytes3k, Message$.MODULE$.NoTimestamp(), Message$.MODULE$.MagicValue_V1())}));
        this.testCompressSize((CompressionCodec)GZIPCompressionCodec$.MODULE$, (List<Message>)messages, 396);
        if (this.isSnappyAvailable()) {
            this.testCompressSize((CompressionCodec)SnappyCompressionCodec$.MODULE$, (List<Message>)messages, 1063);
        }
        if (this.isLZ4Available()) {
            this.testCompressSize((CompressionCodec)LZ4CompressionCodec$.MODULE$, (List<Message>)messages, 387);
        }
    }

    public void testSimpleCompressDecompress(CompressionCodec compressionCodec) {
        List messages = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hi there".getBytes()), new Message("I am fine".getBytes()), new Message("I am not so well today".getBytes())}));
        ByteBufferMessageSet messageSet = new ByteBufferMessageSet(compressionCodec, (Seq)messages);
        Assert.assertEquals((Object)compressionCodec, (Object)((MessageAndOffset)messageSet.shallowIterator().next()).message().compressionCodec());
        List decompressed = messageSet.iterator().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(MessageAndOffset x$4) {
                return x$4.message();
            }
        }).toList();
        Assert.assertEquals((Object)messages, (Object)decompressed);
    }

    public void testCompressSize(CompressionCodec compressionCodec, List<Message> messages, int expectedSize) {
        ByteBufferMessageSet messageSet = new ByteBufferMessageSet(compressionCodec, messages);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " size has changed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compressionCodec})), (long)expectedSize, (long)messageSet.sizeInBytes());
    }

    public boolean isSnappyAvailable() {
        Throwable throwable2;
        block2: {
            boolean bl;
            try {
                new SnappyOutputStream((OutputStream)new ByteArrayOutputStream());
                bl = true;
            }
            catch (Throwable throwable2) {
                boolean bl2;
                Throwable throwable3 = throwable2;
                boolean bl3 = throwable3 instanceof UnsatisfiedLinkError ? true : throwable3 instanceof SnappyError;
                if (!bl3) break block2;
                bl = bl2 = false;
            }
            return bl;
        }
        throw throwable2;
    }

    public boolean isLZ4Available() {
        boolean bl;
        try {
            new LZ4BlockOutputStream((OutputStream)new ByteArrayOutputStream());
            bl = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl = false;
        }
        return bl;
    }
}

