/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.Assert;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u0001\u001d\u0011q$\u00112tiJ\f7\r^\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$H+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI!\"D\u0001\u0003\u0013\tY!AA\bCCN,'+Z9vKN$H+Z:u\u0011\u0015i\u0001\u0001\"\u0001\u000f\u0003\u0019a\u0014N\\5u}Q\tq\u0002\u0005\u0002\n\u0001!)\u0011\u0003\u0001C!%\u0005\t\u0002O]8qKJ$\u0018p\u0014<feJLG-Z:\u0015\u0005MI\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"\u0001B+oSRDQA\u0007\tA\u0002m\t!\u0002\u001d:pa\u0016\u0014H/[3t!\ta\u0012%D\u0001\u001e\u0015\tqr$\u0001\u0003vi&d'\"\u0001\u0011\u0002\t)\fg/Y\u0005\u0003Eu\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0015!\u0003\u0001\"\u0005&\u0003\u00052\u0018\r\\5eCR,g+\u00197jI\u000e\u0013X-\u0019;f)>\u0004\u0018nY:SKF,Xm\u001d;t)\t\u0019b\u0005C\u0003(G\u0001\u0007\u0001&A\u0004sKF,Xm\u001d;\u0011\u0005%\u001aT\"\u0001\u0016\u000b\u0005-b\u0013\u0001\u0003:fcV,7\u000f^:\u000b\u00055r\u0013AB2p[6|gN\u0003\u0002\u0006_)\u0011\u0001'M\u0001\u0007CB\f7\r[3\u000b\u0003I\n1a\u001c:h\u0013\t!$FA\nDe\u0016\fG/\u001a+pa&\u001c7OU3rk\u0016\u001cH\u000fC\u00037\u0001\u0011Eq'A\u0003feJ|'\u000fF\u00029\u007f\u0019\u0003\"!\u000f\u001f\u000f\u0005%R\u0014BA\u001e+\u0003Q\u0019%/Z1uKR{\u0007/[2t%\u0016\u001c\bo\u001c8tK&\u0011QH\u0010\u0002\u0006\u000bJ\u0014xN\u001d\u0006\u0003w)BQAN\u001bA\u0002\u0001\u0003\"!\u0011#\u000e\u0003\tS!a\u0011\u0017\u0002\u0011A\u0014x\u000e^8d_2L!!\u0012\"\u0003\r\u0015\u0013(o\u001c:t\u0011\u001d9U\u0007%AA\u0002!\u000bA\"\u001a:s_JlUm]:bO\u0016\u00042\u0001F%L\u0013\tQUC\u0001\u0004PaRLwN\u001c\t\u0003\u0019>s!\u0001F'\n\u00059+\u0012A\u0002)sK\u0012,g-\u0003\u0002Q#\n11\u000b\u001e:j]\u001eT!AT\u000b\t\u000bM\u0003A\u0011\u0003+\u0002'\u0011,\b\u000f\\5dCR,g)\u001b:tiR{\u0007/[2\u0015\u0005!*\u0006\"B\u0014S\u0001\u0004A\u0003\"B,\u0001\t#A\u0016!L1eIB\u000b'\u000f^5uS>t7/\u00118e%\u0016\u0004H.[2bi&|gNR1di>\u0014Hk\u001c$jeN$Hk\u001c9jGR\u0011\u0001&\u0017\u0005\u0006OY\u0003\r\u0001\u000b\u0005\u00067\u0002!\t\u0002X\u0001\"m\u0006d\u0017\u000eZ1uK\u0016\u0013(o\u001c:De\u0016\fG/\u001a+pa&\u001c7OU3rk\u0016\u001cHo\u001d\u000b\u0005'us6\rC\u0003(5\u0002\u0007\u0001\u0006C\u0003`5\u0002\u0007\u0001-\u0001\tfqB,7\r^3e%\u0016\u001c\bo\u001c8tKB!A*Y&9\u0013\t\u0011\u0017KA\u0002NCBDq\u0001\u001a.\u0011\u0002\u0003\u0007Q-A\tdQ\u0016\u001c7.\u0012:s_JlUm]:bO\u0016\u0004\"\u0001\u00064\n\u0005\u001d,\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006S\u0002!\tB[\u0001\u0014m\u0006d\u0017\u000eZ1uKR{\u0007/[2Fq&\u001cHo\u001d\u000b\u0003'-DQ\u0001\u001c5A\u0002-\u000bQ\u0001^8qS\u000eDQA\u001c\u0001\u0005\u0012=\fqC]3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u)>T\u0015M^1\u0015\u0005A\\\b\u0003\u0002\u000frebL!AY\u000f\u0011\u0005M4X\"\u0001;\u000b\u0005U|\u0012\u0001\u00027b]\u001eL!a\u001e;\u0003\u000f%sG/Z4feB\u0019A$\u001f:\n\u0005il\"\u0001\u0002'jgRDQ\u0001`7A\u0002u\f1\"Y:tS\u001etW.\u001a8ugB)A*\u0019@\u0002\u0004A\u0011Ac`\u0005\u0004\u0003\u0003)\"aA%oiB)\u0011QAA\u000b}:!\u0011qAA\t\u001d\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007\r\u00051AH]8pizJ\u0011AF\u0005\u0004\u0003')\u0012a\u00029bG.\fw-Z\u0005\u0004u\u0006]!bAA\n+!9\u00111\u0004\u0001\u0005\u0012\u0005u\u0011AF:f]\u0012\u001c%/Z1uKR{\u0007/[2SKF,Xm\u001d;\u0015\r\u0005}\u0011QEA\u0014!\rI\u0013\u0011E\u0005\u0004\u0003GQ#\u0001F\"sK\u0006$X\rV8qS\u000e\u001c(+Z:q_:\u001cX\r\u0003\u0004(\u00033\u0001\r\u0001\u000b\u0005\u000b\u0003S\tI\u0002%AA\u0002\u0005-\u0012\u0001D:pG.,GoU3sm\u0016\u0014\b\u0003BA\u0017\u0003gi!!a\f\u000b\u0007\u0005EB!A\u0004oKR<xN]6\n\t\u0005U\u0012q\u0006\u0002\r'>\u001c7.\u001a;TKJ4XM\u001d\u0005\b\u0003s\u0001A\u0011CA\u001e\u0003M\u0019XM\u001c3NKR\fG-\u0019;b%\u0016\fX/Z:u)\u0019\ti$a\u0011\u0002LA\u0019\u0011&a\u0010\n\u0007\u0005\u0005#F\u0001\tNKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tK\"9q%a\u000eA\u0002\u0005\u0015\u0003cA\u0015\u0002H%\u0019\u0011\u0011\n\u0016\u0003\u001f5+G/\u00193bi\u0006\u0014V-];fgRD!\"!\u0014\u00028A\u0005\t\u0019AA\u0016\u0003-!Wm\u001d;j]\u0006$\u0018n\u001c8\t\u0013\u0005E\u0003!%A\u0005\u0012\u0005M\u0013\u0001I:f]\u0012\u001c%/Z1uKR{\u0007/[2SKF,Xm\u001d;%I\u00164\u0017-\u001e7uII*\"!!\u0016+\t\u0005-\u0012qK\u0016\u0003\u00033\u0002B!a\u0017\u0002f5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'A\u0005v]\u000eDWmY6fI*\u0019\u00111M\u000b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002h\u0005u#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u00111\u000e\u0001\u0012\u0002\u0013E\u00111K\u0001\u001eg\u0016tG-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%e!I\u0011q\u000e\u0001\u0012\u0002\u0013E\u0011\u0011O\u0001\u0010KJ\u0014xN\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u000f\u0016\u0004\u0011\u0006]\u0003\"CA<\u0001E\u0005I\u0011CA=\u0003-2\u0018\r\\5eCR,WI\u001d:pe\u000e\u0013X-\u0019;f)>\u0004\u0018nY:SKF,Xm\u001d;tI\u0011,g-Y;mi\u0012\u001aTCAA>U\r)\u0017q\u000b")
public class AbstractCreateTopicsRequestTest
extends BaseRequestTest {
    @Override
    public void propertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
    }

    public void validateValidCreateTopicsRequests(CreateTopicsRequest request) {
        CreateTopicsResponse response = this.sendCreateTopicRequest(request, this.sendCreateTopicRequest$default$2());
        Option error = ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.errors().values()).asScala()).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CreateTopicsResponse.Error x$1) {
                return !x$1.is(Errors.NONE);
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There should be no errors, found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.mapAsScalaMapConverter(response.errors()).asScala()})), (boolean)error.isEmpty());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.topics()).asScala()).foreach((Function1)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractCreateTopicsRequestTest $outer;
            private final CreateTopicsRequest request$1;

            public final void apply(Tuple2<String, CreateTopicsRequest.TopicDetails> x0$1) {
                Tuple2<String, CreateTopicsRequest.TopicDetails> tuple2 = x0$1;
                if (tuple2 != null) {
                    String topic = (String)tuple2._1();
                    CreateTopicsRequest.TopicDetails details = (CreateTopicsRequest.TopicDetails)tuple2._2();
                    this.verifyMetadata$1(this.$outer.controllerSocketServer(), topic, details);
                    Object object = this.request$1.validateOnly() ? BoxedUnit.UNIT : BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.$outer.servers(), topic, 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4()));
                    this.verifyMetadata$1(this.$outer.notControllerSocketServer(), topic, details);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            private final void verifyMetadata$1(SocketServer socketServer, String topic$1, CreateTopicsRequest.TopicDetails details$1) {
                int replication;
                Iterable metadata = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.$outer.sendMetadataRequest(new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$1}))).asJava()).build(), this.$outer.sendMetadataRequest$default$2()).topicMetadata()).asScala();
                MetadataResponse.TopicMetadata metadataForTopic = (MetadataResponse.TopicMetadata)((IterableLike)metadata.filter((Function1)new Serializable(this, topic$1){
                    public static final long serialVersionUID = 0L;
                    private final String topic$1;

                    public final boolean apply(MetadataResponse.TopicMetadata x$2) {
                        String string = x$2.topic();
                        String string2 = this.topic$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.topic$1 = topic$1;
                    }
                })).head();
                int partitions = details$1.replicasAssignments.isEmpty() ? details$1.numPartitions : details$1.replicasAssignments.size();
                int n = replication = details$1.replicasAssignments.isEmpty() ? details$1.replicationFactor : ((java.util.List)((Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(details$1.replicasAssignments).asScala()).head())._2()).size();
                if (this.request$1.validateOnly()) {
                    Assert.assertNotNull((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic ", " should be created"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic$1})), (Object)metadataForTopic);
                    Errors errors = metadataForTopic.error();
                    Errors errors2 = Errors.NONE;
                    Assert.assertFalse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error ", " for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metadataForTopic.error(), topic$1})), (!(errors != null ? !errors.equals(errors2) : errors2 != null) ? 1 : 0) != 0);
                    Assert.assertTrue((String)"The topic should have no partitions", (boolean)metadataForTopic.partitionMetadata().isEmpty());
                } else {
                    Assert.assertNotNull((String)"The topic should be created", (Object)metadataForTopic);
                    Assert.assertEquals((Object)Errors.NONE, (Object)metadataForTopic.error());
                    Assert.assertEquals((String)"The topic should have the correct number of partitions", (long)partitions, (long)metadataForTopic.partitionMetadata().size());
                    Assert.assertEquals((String)"The topic should have the correct replication factor", (long)replication, (long)((MetadataResponse.PartitionMetadata)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(metadataForTopic.partitionMetadata()).asScala()).head()).replicas().size());
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.request$1 = request$1;
            }
        });
    }

    public CreateTopicsResponse.Error error(Errors error, Option<String> errorMessage) {
        return new CreateTopicsResponse.Error(error, (String)errorMessage.orNull(Predef$.MODULE$.conforms()));
    }

    public Option<String> error$default$2() {
        return None$.MODULE$;
    }

    public CreateTopicsRequest duplicateFirstTopic(CreateTopicsRequest request) {
        Struct firstTopic;
        Struct struct = request.toStruct();
        Object[] topics = struct.getArray("create_topic_requests");
        Struct struct2 = firstTopic = (Struct)topics[0];
        List newTopics = Predef$.MODULE$.refArrayOps(topics).toList().$colon$colon((Object)struct2);
        struct.set("create_topic_requests", newTopics.toArray(ClassTag$.MODULE$.Object()));
        return new CreateTopicsRequest(struct, request.version());
    }

    public CreateTopicsRequest addPartitionsAndReplicationFactorToFirstTopic(CreateTopicsRequest request) {
        Struct struct = request.toStruct();
        Object[] topics = struct.getArray("create_topic_requests");
        Struct firstTopic = (Struct)topics[0];
        firstTopic.set("num_partitions", (Object)BoxesRunTime.boxToInteger((int)1));
        firstTopic.set("replication_factor", (Object)BoxesRunTime.boxToShort((short)((short)1)));
        return new CreateTopicsRequest(struct, request.version());
    }

    public void validateErrorCreateTopicsRequests(CreateTopicsRequest request, scala.collection.immutable.Map<String, CreateTopicsResponse.Error> expectedResponse, boolean checkErrorMessage) {
        CreateTopicsResponse response = this.sendCreateTopicRequest(request, this.sendCreateTopicRequest$default$2());
        scala.collection.mutable.Map errors = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(response.errors()).asScala();
        Assert.assertEquals((String)"The response size should match", (long)expectedResponse.size(), (long)response.errors().size());
        expectedResponse.foreach((Function1)new Serializable(this, request, expectedResponse, checkErrorMessage, errors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractCreateTopicsRequestTest $outer;
            private final CreateTopicsRequest request$2;
            private final scala.collection.immutable.Map expectedResponse$1;
            private final boolean checkErrorMessage$1;
            private final scala.collection.mutable.Map errors$1;

            public final void apply(Tuple2<String, CreateTopicsResponse.Error> x0$2) {
                Tuple2<String, CreateTopicsResponse.Error> tuple2 = x0$2;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    String topic = (String)tuple2._1();
                    CreateTopicsResponse.Error expectedError = (CreateTopicsResponse.Error)tuple2._2();
                    CreateTopicsResponse.Error expected = (CreateTopicsResponse.Error)this.expectedResponse$1.apply((Object)topic);
                    CreateTopicsResponse.Error actual = (CreateTopicsResponse.Error)this.errors$1.apply((Object)topic);
                    Assert.assertEquals((String)"The response error should match", (Object)expected.error(), (Object)actual.error());
                    if (this.checkErrorMessage$1) {
                        Assert.assertEquals((Object)expected.message(), (Object)actual.message());
                        Assert.assertEquals((Object)expected.messageWithFallback(), (Object)actual.messageWithFallback());
                    }
                    if (expectedError.is(Errors.NONE) && !this.request$2.validateOnly()) {
                        this.$outer.validateTopicExists(topic);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.request$2 = request$2;
                this.expectedResponse$1 = expectedResponse$1;
                this.checkErrorMessage$1 = checkErrorMessage$1;
                this.errors$1 = errors$1;
            }
        });
    }

    public boolean validateErrorCreateTopicsRequests$default$3() {
        return true;
    }

    public void validateTopicExists(String topic) {
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), topic, 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Iterable metadata = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.sendMetadataRequest(new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava()).build(), this.sendMetadataRequest$default$2()).topicMetadata()).asScala();
        Assert.assertTrue((String)"The topic should be created", (boolean)metadata.exists((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$2;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(MetadataResponse.TopicMetadata p) {
                if (!p.topic().equals(this.topic$2)) return false;
                Errors errors = p.error();
                Errors errors2 = Errors.NONE;
                if (errors != null) {
                    if (!errors.equals(errors2)) return false;
                    return true;
                }
                if (errors2 == null) return true;
                return false;
            }
            {
                this.topic$2 = topic$2;
            }
        }));
    }

    public java.util.Map<Integer, java.util.List<Integer>> replicaAssignmentToJava(scala.collection.immutable.Map<Object, List<Object>> assignments) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)assignments.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Integer, java.util.List<Integer>> apply(Tuple2<Object, List<Object>> x0$3) {
                Tuple2<Object, List<Object>> tuple2 = x0$3;
                if (tuple2 != null) {
                    int k = tuple2._1$mcI$sp();
                    List v = (List)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)Predef$.MODULE$.int2Integer(k), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)v.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Integer apply(int i) {
                            return Predef$.MODULE$.int2Integer(i);
                        }
                    }, List$.MODULE$.canBuildFrom())).asJava());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public CreateTopicsResponse sendCreateTopicRequest(CreateTopicsRequest request, SocketServer socketServer) {
        ByteBuffer response = this.send((AbstractRequest)request, ApiKeys.CREATE_TOPICS, socketServer, this.send$default$4());
        return CreateTopicsResponse.parse((ByteBuffer)response, (int)request.version());
    }

    public SocketServer sendCreateTopicRequest$default$2() {
        return this.controllerSocketServer();
    }

    public MetadataResponse sendMetadataRequest(MetadataRequest request, SocketServer destination) {
        short version = ProtoUtils.latestVersion((int)ApiKeys.METADATA.id);
        ByteBuffer response = this.send((AbstractRequest)request, ApiKeys.METADATA, destination, this.send$default$4());
        return MetadataResponse.parse((ByteBuffer)response, (int)version);
    }

    public SocketServer sendMetadataRequest$default$2() {
        return this.anySocketServer();
    }
}

