/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.cluster.Replica;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.OffsetCheckpoint;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005mh\u0001B\u0001\u0003\u0001\u001d\u0011q\u0002T8h%\u0016\u001cwN^3ssR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\n\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u0011!BS+oSR\u001cV/\u001b;f!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0002{W&\u0011q\u0003\u0006\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\u0014e\u0016\u0004H.[2b\u0019\u0006<G+[7f\u001b\u0006DXj]\u000b\u0002AA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t!Aj\u001c8h\u0011\u00199\u0003\u0001)A\u0005A\u0005!\"/\u001a9mS\u000e\fG*Y4US6,W*\u0019=Ng\u0002Bq!\u000b\u0001C\u0002\u0013\u0005q$A\u000bsKBd\u0017nY1MC\u001el\u0015\r_'fgN\fw-Z:\t\r-\u0002\u0001\u0015!\u0003!\u0003Y\u0011X\r\u001d7jG\u0006d\u0015mZ'bq6+7o]1hKN\u0004\u0003bB\u0017\u0001\u0005\u0004%\tAL\u0001\u0016e\u0016\u0004H.[2b\r\u0016$8\r[,bSRl\u0015\r_'t+\u0005y\u0003CA\u00111\u0013\t\t$EA\u0002J]RDaa\r\u0001!\u0002\u0013y\u0013A\u0006:fa2L7-\u0019$fi\u000eDw+Y5u\u001b\u0006DXj\u001d\u0011\t\u000fU\u0002!\u0019!C\u0001]\u0005!\"/\u001a9mS\u000e\fg)\u001a;dQ6KgNQ=uKNDaa\u000e\u0001!\u0002\u0013y\u0013!\u0006:fa2L7-\u0019$fi\u000eDW*\u001b8CsR,7\u000f\t\u0005\bs\u0001\u0011\r\u0011\"\u0001;\u0003=yg/\u001a:sS\u0012Lgn\u001a)s_B\u001cX#A\u001e\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014\u0001B;uS2T\u0011\u0001Q\u0001\u0005U\u00064\u0018-\u0003\u0002C{\tQ\u0001K]8qKJ$\u0018.Z:\t\r\u0011\u0003\u0001\u0015!\u0003<\u0003Ayg/\u001a:sS\u0012Lgn\u001a)s_B\u001c\b\u0005C\u0004G\u0001\u0001\u0007I\u0011A$\u0002\u000f\r|gNZ5hgV\t\u0001\nE\u0002J#Rs!AS(\u000f\u0005-sU\"\u0001'\u000b\u000553\u0011A\u0002\u001fs_>$h(C\u0001$\u0013\t\u0001&%A\u0004qC\u000e\\\u0017mZ3\n\u0005I\u001b&aA*fc*\u0011\u0001K\t\t\u00039UK!A\u0016\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b1\u0002\u0001\r\u0011\"\u0001Z\u0003-\u0019wN\u001c4jON|F%Z9\u0015\u0005ik\u0006CA\u0011\\\u0013\ta&E\u0001\u0003V]&$\bb\u00020X\u0003\u0003\u0005\r\u0001S\u0001\u0004q\u0012\n\u0004B\u00021\u0001A\u0003&\u0001*\u0001\u0005d_:4\u0017nZ:!\u0011\u001d\u0011\u0007A1A\u0005\u0002\r\fQ\u0001^8qS\u000e,\u0012\u0001\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0003O~\nA\u0001\\1oO&\u0011\u0011N\u001a\u0002\u0007'R\u0014\u0018N\\4\t\r-\u0004\u0001\u0015!\u0003e\u0003\u0019!x\u000e]5dA!9Q\u000e\u0001b\u0001\n\u0003q\u0013a\u00039beRLG/[8o\u0013\u0012Daa\u001c\u0001!\u0002\u0013y\u0013\u0001\u00049beRLG/[8o\u0013\u0012\u0004\u0003bB9\u0001\u0005\u0004%\tA]\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\u0005\u0019\bC\u0001;{\u001b\u0005)(B\u0001<x\u0003\u0019\u0019w.\\7p]*\u0011Q\u0001\u001f\u0006\u0003s:\ta!\u00199bG\",\u0017BA>v\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Da! \u0001!\u0002\u0013\u0019\u0018a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\t\u0011}\u0004\u0001\u0019!C\u0001\u0003\u0003\tqa]3sm\u0016\u0014\u0018'\u0006\u0002\u0002\u0004A\u0019A$!\u0002\n\u0007\u0005\u001d!AA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\b\"CA\u0006\u0001\u0001\u0007I\u0011AA\u0007\u0003-\u0019XM\u001d<feFzF%Z9\u0015\u0007i\u000by\u0001C\u0005_\u0003\u0013\t\t\u00111\u0001\u0002\u0004!A\u00111\u0003\u0001!B\u0013\t\u0019!\u0001\u0005tKJ4XM]\u0019!\u0011%\t9\u0002\u0001a\u0001\n\u0003\t\t!A\u0004tKJ4XM\u001d\u001a\t\u0013\u0005m\u0001\u00011A\u0005\u0002\u0005u\u0011aC:feZ,'OM0%KF$2AWA\u0010\u0011%q\u0016\u0011DA\u0001\u0002\u0004\t\u0019\u0001\u0003\u0005\u0002$\u0001\u0001\u000b\u0015BA\u0002\u0003!\u0019XM\u001d<feJ\u0002\u0003bBA\u0014\u0001\u0011\u0005\u0011\u0011F\u0001\rG>tg-[4Qe>\u00048/M\u000b\u0002)\"9\u0011Q\u0006\u0001\u0005\u0002\u0005%\u0012\u0001D2p]\u001aLw\r\u0015:paN\u0014\u0004\u0002CA\u0019\u0001\t\u0007I\u0011A2\u0002\u000f5,7o]1hK\"9\u0011Q\u0007\u0001!\u0002\u0013!\u0017\u0001C7fgN\fw-\u001a\u0011\t\u0013\u0005e\u0002\u00011A\u0005\u0002\u0005m\u0012\u0001\u00039s_\u0012,8-\u001a:\u0016\u0005\u0005u\u0002\u0003CA \u0003\u000f\nY%!\u0015\u000e\u0005\u0005\u0005#\u0002BA\u001d\u0003\u0007R1!!\u0012x\u0003\u001d\u0019G.[3oiNLA!!\u0013\u0002B\ti1*\u00194lCB\u0013x\u000eZ;dKJ\u00042!ZA'\u0013\r\tyE\u001a\u0002\b\u0013:$XmZ3s!\u0011\t\u0019&!\u0017\u000f\u0007\u0005\n)&C\u0002\u0002X\t\na\u0001\u0015:fI\u00164\u0017bA5\u0002\\)\u0019\u0011q\u000b\u0012\t\u0013\u0005}\u0003\u00011A\u0005\u0002\u0005\u0005\u0014\u0001\u00049s_\u0012,8-\u001a:`I\u0015\fHc\u0001.\u0002d!Ia,!\u0018\u0002\u0002\u0003\u0007\u0011Q\b\u0005\t\u0003O\u0002\u0001\u0015)\u0003\u0002>\u0005I\u0001O]8ek\u000e,'\u000f\t\u0005\b\u0003W\u0002A\u0011AA7\u0003\u001dAwOR5mKF*\"!a\u001c\u0011\u0007q\t\t(C\u0002\u0002t\t\u0011\u0001c\u00144gg\u0016$8\t[3dWB|\u0017N\u001c;\t\u000f\u0005]\u0004\u0001\"\u0001\u0002n\u00059\u0001n\u001e$jY\u0016\u0014\u0004\"CA>\u0001\u0001\u0007I\u0011AA?\u0003\u001d\u0019XM\u001d<feN,\"!a \u0011\r\u0005\u0005\u0015qQA\u0002\u001b\t\t\u0019IC\u0002\u0002\u0006\n\n!bY8mY\u0016\u001cG/[8o\u0013\r\u0011\u00161\u0011\u0005\n\u0003\u0017\u0003\u0001\u0019!C\u0001\u0003\u001b\u000b1b]3sm\u0016\u00148o\u0018\u0013fcR\u0019!,a$\t\u0013y\u000bI)!AA\u0002\u0005}\u0004\u0002CAJ\u0001\u0001\u0006K!a \u0002\u0011M,'O^3sg\u0002Bq!a&\u0001\t\u0003\tI*\u0001\bva\u0012\fG/\u001a)s_\u0012,8-\u001a:\u0015\u0003iCq!!(\u0001\t\u0003\nI*A\u0003tKR,\u0006\u000f\u000b\u0003\u0002\u001c\u0006\u0005\u0006\u0003BAR\u0003Ok!!!*\u000b\u0005-q\u0011\u0002BAU\u0003K\u0013aAQ3g_J,\u0007bBAW\u0001\u0011\u0005\u0013\u0011T\u0001\ti\u0016\f'\u000fR8x]\"\"\u00111VAY!\u0011\t\u0019+a-\n\t\u0005U\u0016Q\u0015\u0002\u0006\u0003\u001a$XM\u001d\u0005\b\u0003s\u0003A\u0011AA^\u0003)\"Xm\u001d;I/\u000eCWmY6q_&tGOT8GC&dWO]3t'&tw\r\\3M_\u001e\u001cVmZ7f]R,\u0012A\u0017\u0015\u0005\u0003o\u000by\f\u0005\u0003\u0002$\u0006\u0005\u0017\u0002BAb\u0003K\u0013A\u0001V3ti\"9\u0011q\u0019\u0001\u0005\u0002\u0005m\u0016\u0001\f;fgRDuk\u00115fG.\u0004x.\u001b8u/&$\bNR1jYV\u0014Xm]*j]\u001edW\rT8h'\u0016<W.\u001a8uQ\u0011\t)-a0\t\u000f\u00055\u0007\u0001\"\u0001\u0002<\u0006iC/Z:u\u0011^\u001b\u0005.Z2la>Lg\u000e\u001e(p\r\u0006LG.\u001e:fg6+H\u000e^5qY\u0016dunZ*fO6,g\u000e^:)\t\u0005-\u0017q\u0018\u0005\b\u0003'\u0004A\u0011AA^\u0003=\"Xm\u001d;I/\u000eCWmY6q_&tGoV5uQ\u001a\u000b\u0017\u000e\\;sKNlU\u000f\u001c;ja2,Gj\\4TK\u001elWM\u001c;tQ\u0011\t\t.a0\t\u000f\u0005e\u0007\u0001\"\u0003\u0002\\\u0006a1/\u001a8e\u001b\u0016\u001c8/Y4fgR\u0019!,!8\t\u0013\u0005}\u0017q\u001bI\u0001\u0002\u0004y\u0013!\u00018\t\u0013\u0005\r\b!%A\u0005\n\u0005\u0015\u0018AF:f]\u0012lUm]:bO\u0016\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d(fA\u0018\u0002j.\u0012\u00111\u001e\t\u0005\u0003[\f90\u0004\u0002\u0002p*!\u0011\u0011_Az\u0003%)hn\u00195fG.,GMC\u0002\u0002v\n\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI0a<\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class LogRecoveryTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final long replicaLagTimeMaxMs;
    private final long replicaLagMaxMessages;
    private final int replicaFetchWaitMaxMs;
    private final int replicaFetchMinBytes;
    private final Properties overridingProps;
    private Seq<KafkaConfig> configs;
    private final String topic;
    private final int partitionId;
    private final TopicPartition topicPartition;
    private KafkaServer server1;
    private KafkaServer server2;
    private final String message;
    private KafkaProducer<Integer, String> producer;
    private Seq<KafkaServer> servers;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogRecoveryTest logRecoveryTest = this;
        synchronized (logRecoveryTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public long replicaLagMaxMessages() {
        return this.replicaLagMaxMessages;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int replicaFetchMinBytes() {
        return this.replicaFetchMinBytes;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public KafkaServer server1() {
        return this.server1;
    }

    public void server1_$eq(KafkaServer x$1) {
        this.server1 = x$1;
    }

    public KafkaServer server2() {
        return this.server2;
    }

    public void server2_$eq(KafkaServer x$1) {
        this.server2 = x$1;
    }

    public KafkaConfig configProps1() {
        return (KafkaConfig)this.configs().head();
    }

    public KafkaConfig configProps2() {
        return (KafkaConfig)this.configs().last();
    }

    public String message() {
        return this.message;
    }

    public KafkaProducer<Integer, String> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<Integer, String> x$1) {
        this.producer = x$1;
    }

    public OffsetCheckpoint hwFile1() {
        return new OffsetCheckpoint(new File((String)this.configProps1().logDirs().head(), ReplicaManager$.MODULE$.HighWatermarkFilename()));
    }

    public OffsetCheckpoint hwFile2() {
        return new OffsetCheckpoint(new File((String)this.configProps2().logDirs().head(), ReplicaManager$.MODULE$.HighWatermarkFilename()));
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public void updateProducer() {
        if (this.producer() != null) {
            this.producer().close();
        }
        String x$8 = TestUtils$.MODULE$.getBrokerListStrFromServers(this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$9 = 5;
        IntegerSerializer x$10 = new IntegerSerializer();
        StringSerializer x$11 = new StringSerializer();
        int x$12 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$13 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$14 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$15 = TestUtils$.MODULE$.createNewProducer$default$6();
        long x$16 = TestUtils$.MODULE$.createNewProducer$default$7();
        SecurityProtocol x$17 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$18 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$19 = TestUtils$.MODULE$.createNewProducer$default$10();
        Option<Properties> x$20 = TestUtils$.MODULE$.createNewProducer$default$13();
        this.producer_$eq(TestUtils$.MODULE$.createNewProducer(x$8, x$12, x$13, x$14, x$9, x$15, x$16, x$17, x$18, x$19, x$10, x$11, x$20));
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        this.configs_$eq((Seq<KafkaConfig>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())));
        this.server1_$eq(TestUtils$.MODULE$.createServer(this.configProps1(), TestUtils$.MODULE$.createServer$default$2()));
        this.server2_$eq(TestUtils$.MODULE$.createServer(this.configProps2(), TestUtils$.MODULE$.createServer$default$2()));
        this.servers_$eq((Seq<KafkaServer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1(), this.server2()})));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers());
        this.updateProducer();
    }

    @Override
    @After
    public void tearDown() {
        this.producer().close();
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.shutdown();
                Utils.delete((File)new File((String)server.config().logDirs().head()));
            }
        });
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void testHWCheckpointNoFailuresSingleLogSegment() {
        long numMessages = 2L;
        this.sendMessages((int)numMessages);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, numMessages){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final long numMessages$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                int x$22;
                TopicPartition x$21;
                ReplicaManager qual$1 = this.$outer.server2().replicaManager();
                return ((Replica)qual$1.getReplica(x$21 = this.$outer.topicPartition(), x$22 = qual$1.getReplica$default$2()).get()).highWatermark().messageOffset() == this.numMessages$1;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.numMessages$1 = numMessages$1;
            }
        }, "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$2) {
                x$2.replicaManager().checkpointHighWatermarks();
            }
        });
        long leaderHW = BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((long)numMessages, (long)leaderHW);
        long followerHW = BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((long)numMessages, (long)followerHW);
    }

    @Test
    public void testHWCheckpointWithFailuresSingleLogSegment() {
        Option<Object> leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.sendMessages(1);
        Thread.sleep(1000L);
        LongRef hw = new LongRef(1L);
        this.server1().shutdown();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        ZkUtils x$23 = this.zkUtils();
        String x$24 = this.topic();
        int x$25 = this.partitionId();
        Option<Object> x$26 = leader;
        long x$27 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$28 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$23, x$24, x$25, x$27, x$26, x$28);
        Assert.assertEquals((String)"Leader must move to broker 1", (long)1L, (long)BoxesRunTime.unboxToInt((Object)leader.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })));
        this.server1().startup();
        this.updateProducer();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertTrue((String)"Leader must remain on broker 1, in case of zookeeper session expiration it can move to broker 0", (leader.isDefined() && (BoxesRunTime.unboxToInt((Object)leader.get()) == 0 || BoxesRunTime.unboxToInt((Object)leader.get()) == 1) ? 1 : 0) != 0);
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.server2().shutdown();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.server2().startup();
        this.updateProducer();
        ZkUtils x$29 = this.zkUtils();
        String x$30 = this.topic();
        int x$31 = this.partitionId();
        Option<Object> x$32 = leader;
        long x$33 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$34 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$29, x$30, x$31, x$33, x$32, x$34);
        Assert.assertTrue((String)"Leader must remain on broker 0, in case of zookeeper session expiration it can move to broker 1", (leader.isDefined() && (BoxesRunTime.unboxToInt((Object)leader.get()) == 0 || BoxesRunTime.unboxToInt((Object)leader.get()) == 1) ? 1 : 0) != 0);
        this.sendMessages(1);
        ++hw.elem;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final LongRef hw$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                int x$36;
                TopicPartition x$35;
                ReplicaManager qual$2 = this.$outer.server2().replicaManager();
                return ((Replica)qual$2.getReplica(x$35 = this.$outer.topicPartition(), x$36 = qual$2.getReplica$default$2()).get()).highWatermark().messageOffset() == this.hw$1.elem;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hw$1 = hw$1;
            }
        }, "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$3) {
                x$3.shutdown();
            }
        });
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
    }

    @Test
    public void testHWCheckpointNoFailuresMultipleLogSegments() {
        this.sendMessages(20);
        long hw = 20L;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final long hw$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                int x$38;
                TopicPartition x$37;
                ReplicaManager qual$3 = this.$outer.server2().replicaManager();
                return ((Replica)qual$3.getReplica(x$37 = this.$outer.topicPartition(), x$38 = qual$3.getReplica$default$2()).get()).highWatermark().messageOffset() == this.hw$2;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hw$2 = hw$2;
            }
        }, "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$4) {
                x$4.shutdown();
            }
        });
        long leaderHW = BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((long)hw, (long)leaderHW);
        long followerHW = BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((long)hw, (long)followerHW);
    }

    @Test
    public void testHWCheckpointWithFailuresMultipleLogSegments() {
        Option<Object> leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.sendMessages(2);
        LongRef hw = new LongRef(2L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final LongRef hw$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                int x$40;
                TopicPartition x$39;
                ReplicaManager qual$4 = this.$outer.server2().replicaManager();
                return ((Replica)qual$4.getReplica(x$39 = this.$outer.topicPartition(), x$40 = qual$4.getReplica$default$2()).get()).highWatermark().messageOffset() == this.hw$3.elem;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hw$3 = hw$3;
            }
        }, "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.server1().shutdown();
        this.server2().shutdown();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.server2().startup();
        this.updateProducer();
        ZkUtils x$41 = this.zkUtils();
        String x$42 = this.topic();
        int x$43 = this.partitionId();
        Option<Object> x$44 = leader;
        long x$45 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$46 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$41, x$42, x$43, x$45, x$44, x$46);
        Assert.assertEquals((String)"Leader must move to broker 1", (long)1L, (long)BoxesRunTime.unboxToInt((Object)leader.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.server1().startup();
        this.updateProducer();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.sendMessages(2);
        hw.elem += 2L;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ReplicaManager qual$5 = this.$outer.server1().replicaManager();
                TopicPartition x$47 = this.$outer.topicPartition();
                int x$48 = qual$5.getReplica$default$2();
                return qual$5.getReplica(x$47, x$48).nonEmpty();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "Failed to create replica in follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final LongRef hw$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                int x$50;
                TopicPartition x$49;
                ReplicaManager qual$6 = this.$outer.server1().replicaManager();
                return ((Replica)qual$6.getReplica(x$49 = this.$outer.topicPartition(), x$50 = qual$6.getReplica$default$2()).get()).highWatermark().messageOffset() == this.hw$3.elem;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hw$3 = hw$3;
            }
        }, "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$5) {
                x$5.shutdown();
            }
        });
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
    }

    private void sendMessages(int n) {
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;

            public final Future<RecordMetadata> apply(int x$6) {
                return this.$outer.producer().send(new ProducerRecord(this.$outer.topic(), (Object)Predef$.MODULE$.int2Integer(0), (Object)this.$outer.message()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$7) {
                return x$7.get();
            }
        });
    }

    private int sendMessages$default$1() {
        return 1;
    }

    public LogRecoveryTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.replicaLagTimeMaxMs = 5000L;
        this.replicaLagMaxMessages = 10L;
        this.replicaFetchWaitMaxMs = 1000;
        this.replicaFetchMinBytes = 20;
        this.overridingProps = new Properties();
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.replicaLagTimeMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchWaitMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchMinBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchMinBytes())).toString());
        this.configs = null;
        this.topic = "new-topic";
        this.partitionId = 0;
        this.topicPartition = new TopicPartition(this.topic(), this.partitionId());
        this.server1 = null;
        this.server2 = null;
        this.message = "hello";
        this.producer = null;
        this.servers = (Seq)Seq$.MODULE$.empty();
    }
}

