/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.api.GroupCoordinatorRequest;
import kafka.api.GroupCoordinatorRequest$;
import kafka.api.GroupCoordinatorResponse;
import kafka.api.OffsetCommitRequest;
import kafka.api.OffsetCommitRequest$;
import kafka.api.OffsetCommitResponse;
import kafka.api.OffsetFetchRequest;
import kafka.api.OffsetFetchRequest$;
import kafka.api.OffsetFetchResponse;
import kafka.common.OffsetAndMetadata$;
import kafka.common.OffsetMetadata$;
import kafka.common.OffsetMetadataAndError;
import kafka.common.OffsetMetadataAndError$;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0001\u0003\u0001\u001d\u0011\u0001c\u00144gg\u0016$8i\\7nSR$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u0013!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!A\u0003&V]&$8+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0003u.L!a\u0006\u000b\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0004\u001f\u0001\t\u0007I\u0011A\u0010\u0002\rI\fg\u000eZ8n+\u0005\u0001\u0003CA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\u0011)H/\u001b7\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0012\u0003\rI\u000bg\u000eZ8n\u0011\u0019I\u0003\u0001)A\u0005A\u00059!/\u00198e_6\u0004\u0003bB\u0016\u0001\u0005\u0004%\t\u0001L\u0001\u0006OJ|W\u000f]\u000b\u0002[A\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0005Y\u0006twMC\u00013\u0003\u0011Q\u0017M^1\n\u0005Qz#AB*ue&tw\r\u0003\u00047\u0001\u0001\u0006I!L\u0001\u0007OJ|W\u000f\u001d\u0011\t\u000fa\u0002!\u0019!C\u0001s\u00051\"/\u001a;f]RLwN\\\"iK\u000e\\\u0017J\u001c;feZ\fG.F\u0001;!\tYD(D\u0001%\u0013\tiDE\u0001\u0003M_:<\u0007BB \u0001A\u0003%!(A\fsKR,g\u000e^5p]\u000eCWmY6J]R,'O^1mA!9\u0011\t\u0001a\u0001\n\u0003\u0011\u0015A\u00027pO\u0012K'/F\u0001D!\t!u)D\u0001F\u0015\t1\u0015'\u0001\u0002j_&\u0011\u0001*\u0012\u0002\u0005\r&dW\rC\u0004K\u0001\u0001\u0007I\u0011A&\u0002\u00151|w\rR5s?\u0012*\u0017\u000f\u0006\u0002M\u001fB\u00111(T\u0005\u0003\u001d\u0012\u0012A!\u00168ji\"9\u0001+SA\u0001\u0002\u0004\u0019\u0015a\u0001=%c!1!\u000b\u0001Q!\n\r\u000bq\u0001\\8h\t&\u0014\b\u0005C\u0004U\u0001\u0001\u0007I\u0011\u0001\"\u0002\u0017Q|\u0007/[2M_\u001e$\u0015N\u001d\u0005\b-\u0002\u0001\r\u0011\"\u0001X\u0003=!x\u000e]5d\u0019><G)\u001b:`I\u0015\fHC\u0001'Y\u0011\u001d\u0001V+!AA\u0002\rCaA\u0017\u0001!B\u0013\u0019\u0015\u0001\u0004;pa&\u001cGj\\4ESJ\u0004\u0003bB\u0002\u0001\u0001\u0004%\t\u0001X\u000b\u0002;B\u0011ADX\u0005\u0003?\n\u00111bS1gW\u0006\u001cVM\u001d<fe\"9\u0011\r\u0001a\u0001\n\u0003\u0011\u0017AC:feZ,'o\u0018\u0013fcR\u0011Aj\u0019\u0005\b!\u0002\f\t\u00111\u0001^\u0011\u0019)\u0007\u0001)Q\u0005;\u000691/\u001a:wKJ\u0004\u0003bB4\u0001\u0001\u0004%\t\u0001[\u0001\bY><7+\u001b>f+\u0005I\u0007CA\u001ek\u0013\tYGEA\u0002J]RDq!\u001c\u0001A\u0002\u0013\u0005a.A\u0006m_\u001e\u001c\u0016N_3`I\u0015\fHC\u0001'p\u0011\u001d\u0001F.!AA\u0002%Da!\u001d\u0001!B\u0013I\u0017\u0001\u00037pONK'0\u001a\u0011\t\u000fM\u0004\u0001\u0019!C\u0001i\u0006q1/[7qY\u0016\u001cuN\\:v[\u0016\u0014X#A;\u0011\u0005YLX\"A<\u000b\u0005a$\u0011\u0001C2p]N,X.\u001a:\n\u0005i<(AD*j[BdWmQ8ogVlWM\u001d\u0005\by\u0002\u0001\r\u0011\"\u0001~\u0003I\u0019\u0018.\u001c9mK\u000e{gn];nKJ|F%Z9\u0015\u00051s\bb\u0002)|\u0003\u0003\u0005\r!\u001e\u0005\b\u0003\u0003\u0001\u0001\u0015)\u0003v\u0003=\u0019\u0018.\u001c9mK\u000e{gn];nKJ\u0004\u0003bBA\u0003\u0001\u0011\u0005\u0013qA\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002\u0019\"\"\u00111AA\u0006!\u0011\ti!!\u0005\u000e\u0005\u0005=!BA\u0006\u000f\u0013\u0011\t\u0019\"a\u0004\u0003\r\t+gm\u001c:f\u0011\u001d\t9\u0002\u0001C!\u0003\u000f\t\u0001\u0002^3be\u0012{wO\u001c\u0015\u0005\u0003+\tY\u0002\u0005\u0003\u0002\u000e\u0005u\u0011\u0002BA\u0010\u0003\u001f\u0011Q!\u00114uKJDq!a\t\u0001\t\u0003\t9!A\tuKN$X\u000b\u001d3bi\u0016|eMZ:fiNDC!!\t\u0002(A!\u0011QBA\u0015\u0013\u0011\tY#a\u0004\u0003\tQ+7\u000f\u001e\u0005\b\u0003_\u0001A\u0011AA\u0004\u0003e!Xm\u001d;D_6l\u0017\u000e^!oI\u001a+Go\u00195PM\u001a\u001cX\r^:)\t\u00055\u0012q\u0005\u0005\b\u0003k\u0001A\u0011AA\u0004\u0003a!Xm\u001d;MCJ<W-T3uC\u0012\fG/\u0019)bs2|\u0017\r\u001a\u0015\u0005\u0003g\t9\u0003C\u0004\u0002<\u0001!\t!a\u0002\u0002)Q,7\u000f^(gMN,G/\u0012=qSJ\fG/[8oQ\u0011\tI$a\n\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002\b\u0005\u0001C/Z:u\u001d>tW\t_5ti&tw\rV8qS\u000e|eMZ:fi\u000e{W.\\5uQ\u0011\ty$a\n\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002\b\u0005\u0019C/Z:u\u001f\u001a47/\u001a;t\t\u0016dW\r^3BMR,'\u000fV8qS\u000e$U\r\\3uS>t\u0007\u0006BA#\u0003O\u0001")
public class OffsetCommitTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final Random random;
    private final String group;
    private final long retentionCheckInterval;
    private File logDir;
    private File topicLogDir;
    private KafkaServer server;
    private int logSize;
    private SimpleConsumer simpleConsumer;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        OffsetCommitTest offsetCommitTest = this;
        synchronized (offsetCommitTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public Random random() {
        return this.random;
    }

    public String group() {
        return this.group;
    }

    public long retentionCheckInterval() {
        return this.retentionCheckInterval;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public File topicLogDir() {
        return this.topicLogDir;
    }

    public void topicLogDir_$eq(File x$1) {
        this.topicLogDir = x$1;
    }

    public KafkaServer server() {
        return this.server;
    }

    public void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    public int logSize() {
        return this.logSize;
    }

    public void logSize_$eq(int x$1) {
        this.logSize = x$1;
    }

    public SimpleConsumer simpleConsumer() {
        return this.simpleConsumer;
    }

    public void simpleConsumer_$eq(SimpleConsumer x$1) {
        this.simpleConsumer = x$1;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        int x$1 = 1;
        String x$2 = this.zkConnect();
        boolean x$3 = true;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        int x$5 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties config = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        config.setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
        config.setProperty(KafkaConfig$.MODULE$.OffsetsRetentionCheckIntervalMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.retentionCheckInterval())).toString());
        String logDirPath = config.getProperty("log.dir");
        this.logDir_$eq(new File(logDirPath));
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), Time.SYSTEM));
        this.simpleConsumer_$eq(new SimpleConsumer("localhost", TestUtils$.MODULE$.boundPort(this.server(), TestUtils$.MODULE$.boundPort$default$2()), 1000000, 65536, "test-client"));
        GroupCoordinatorRequest consumerMetadataRequest = new GroupCoordinatorRequest(this.group(), GroupCoordinatorRequest$.MODULE$.apply$default$2(), GroupCoordinatorRequest$.MODULE$.apply$default$3(), GroupCoordinatorRequest$.MODULE$.apply$default$4());
        package$.MODULE$.Stream().continually((Function0)new Serializable(this, consumerMetadataRequest){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetCommitTest $outer;
            private final GroupCoordinatorRequest consumerMetadataRequest$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                GroupCoordinatorResponse consumerMetadataResponse = this.$outer.simpleConsumer().send(this.consumerMetadataRequest$1);
                return consumerMetadataResponse.coordinatorOpt().isDefined();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.consumerMetadataRequest$1 = consumerMetadataRequest$1;
            }
        }).dropWhile((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(boolean success) {
                if (!success) {
                    Thread.sleep(1000L);
                }
                return !success;
            }
        });
    }

    @Override
    @After
    public void tearDown() {
        this.simpleConsumer().close();
        this.server().shutdown();
        Utils.delete((File)this.logDir());
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void testUpdateOffsets() {
        String topic = "topic";
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, 0);
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})))}));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))));
        OffsetCommitRequest commitRequest = new OffsetCommitRequest(this.group(), (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition), (Object)OffsetAndMetadata$.MODULE$.apply(42L))})), OffsetCommitRequest$.MODULE$.apply$default$3(), OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7(), OffsetCommitRequest$.MODULE$.apply$default$8());
        OffsetCommitResponse commitResponse = this.simpleConsumer().commitOffsets(commitRequest);
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)commitResponse.commitStatus().get((Object)topicAndPartition).get()));
        OffsetFetchRequest fetchRequest = new OffsetFetchRequest(this.group(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{topicAndPartition})), OffsetFetchRequest$.MODULE$.apply$default$3(), OffsetFetchRequest$.MODULE$.apply$default$4(), OffsetFetchRequest$.MODULE$.apply$default$5());
        OffsetFetchResponse fetchResponse = this.simpleConsumer().fetchOffsets(fetchRequest);
        Assert.assertEquals((long)Errors.NONE.code(), (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)topicAndPartition).get()).error());
        Assert.assertEquals((Object)OffsetMetadata$.MODULE$.NoMetadata(), (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)topicAndPartition).get()).metadata());
        Assert.assertEquals((long)42L, (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)topicAndPartition).get()).offset());
        OffsetCommitRequest commitRequest1 = new OffsetCommitRequest(this.group(), (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition), (Object)OffsetAndMetadata$.MODULE$.apply(100L, "some metadata"))})), OffsetCommitRequest$.MODULE$.apply$default$3(), OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7(), OffsetCommitRequest$.MODULE$.apply$default$8());
        OffsetCommitResponse commitResponse1 = this.simpleConsumer().commitOffsets(commitRequest1);
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)commitResponse1.commitStatus().get((Object)topicAndPartition).get()));
        OffsetFetchRequest fetchRequest1 = new OffsetFetchRequest(this.group(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{topicAndPartition})), OffsetFetchRequest$.MODULE$.apply$default$3(), OffsetFetchRequest$.MODULE$.apply$default$4(), OffsetFetchRequest$.MODULE$.apply$default$5());
        OffsetFetchResponse fetchResponse1 = this.simpleConsumer().fetchOffsets(fetchRequest1);
        Assert.assertEquals((long)Errors.NONE.code(), (long)((OffsetMetadataAndError)fetchResponse1.requestInfo().get((Object)topicAndPartition).get()).error());
        Assert.assertEquals((Object)"some metadata", (Object)((OffsetMetadataAndError)fetchResponse1.requestInfo().get((Object)topicAndPartition).get()).metadata());
        Assert.assertEquals((long)100L, (long)((OffsetMetadataAndError)fetchResponse1.requestInfo().get((Object)topicAndPartition).get()).offset());
        TopicAndPartition unknownTopicAndPartition = new TopicAndPartition("unknownTopic", 0);
        OffsetFetchRequest fetchRequest2 = new OffsetFetchRequest(this.group(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{unknownTopicAndPartition})), OffsetFetchRequest$.MODULE$.apply$default$3(), OffsetFetchRequest$.MODULE$.apply$default$4(), OffsetFetchRequest$.MODULE$.apply$default$5());
        OffsetFetchResponse fetchResponse2 = this.simpleConsumer().fetchOffsets(fetchRequest2);
        Assert.assertEquals((Object)OffsetMetadataAndError$.MODULE$.NoOffset(), (Object)fetchResponse2.requestInfo().get((Object)unknownTopicAndPartition).get());
        Assert.assertEquals((long)1L, (long)fetchResponse2.requestInfo().size());
    }

    @Test
    public void testCommitAndFetchOffsets() {
        String topic1 = "topic-1";
        String topic2 = "topic-2";
        String topic3 = "topic-3";
        String topic4 = "topic-4";
        String topic5 = "topic-5";
        ZkUtils x$17 = this.zkUtils();
        String x$18 = topic1;
        Seq x$19 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}));
        int x$20 = 1;
        int x$21 = TestUtils$.MODULE$.createTopic$default$4();
        Properties x$22 = TestUtils$.MODULE$.createTopic$default$6();
        TestUtils$.MODULE$.createTopic(x$17, x$18, x$20, x$21, (Seq<KafkaServer>)x$19, x$22);
        ZkUtils x$23 = this.zkUtils();
        String x$24 = topic2;
        Seq x$25 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}));
        int x$26 = 2;
        int x$27 = TestUtils$.MODULE$.createTopic$default$4();
        Properties x$28 = TestUtils$.MODULE$.createTopic$default$6();
        TestUtils$.MODULE$.createTopic(x$23, x$24, x$26, x$27, (Seq<KafkaServer>)x$25, x$28);
        ZkUtils x$29 = this.zkUtils();
        String x$30 = topic3;
        Seq x$31 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}));
        int x$32 = 1;
        int x$33 = TestUtils$.MODULE$.createTopic$default$4();
        Properties x$34 = TestUtils$.MODULE$.createTopic$default$6();
        TestUtils$.MODULE$.createTopic(x$29, x$30, x$32, x$33, (Seq<KafkaServer>)x$31, x$34);
        ZkUtils x$35 = this.zkUtils();
        String x$36 = topic4;
        Seq x$37 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}));
        int x$38 = 1;
        int x$39 = TestUtils$.MODULE$.createTopic$default$4();
        Properties x$40 = TestUtils$.MODULE$.createTopic$default$6();
        TestUtils$.MODULE$.createTopic(x$35, x$36, x$38, x$39, (Seq<KafkaServer>)x$37, x$40);
        OffsetCommitRequest commitRequest = new OffsetCommitRequest("test-group", (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(topic1, 0)), (Object)OffsetAndMetadata$.MODULE$.apply(42L, "metadata one")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(topic2, 0)), (Object)OffsetAndMetadata$.MODULE$.apply(43L, "metadata two")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(topic3, 0)), (Object)OffsetAndMetadata$.MODULE$.apply(44L, "metadata three")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(topic2, 1)), (Object)OffsetAndMetadata$.MODULE$.apply(45L))})), OffsetCommitRequest$.MODULE$.apply$default$3(), OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7(), OffsetCommitRequest$.MODULE$.apply$default$8());
        OffsetCommitResponse commitResponse = this.simpleConsumer().commitOffsets(commitRequest);
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)commitResponse.commitStatus().get((Object)new TopicAndPartition(topic1, 0)).get()));
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)commitResponse.commitStatus().get((Object)new TopicAndPartition(topic2, 0)).get()));
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)commitResponse.commitStatus().get((Object)new TopicAndPartition(topic3, 0)).get()));
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)commitResponse.commitStatus().get((Object)new TopicAndPartition(topic2, 1)).get()));
        OffsetFetchRequest fetchRequest = new OffsetFetchRequest(this.group(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition(topic1, 0), new TopicAndPartition(topic2, 0), new TopicAndPartition(topic3, 0), new TopicAndPartition(topic2, 1), new TopicAndPartition(topic3, 1), new TopicAndPartition(topic4, 0), new TopicAndPartition(topic5, 0)})), OffsetFetchRequest$.MODULE$.apply$default$3(), OffsetFetchRequest$.MODULE$.apply$default$4(), OffsetFetchRequest$.MODULE$.apply$default$5());
        OffsetFetchResponse fetchResponse = this.simpleConsumer().fetchOffsets(fetchRequest);
        Assert.assertEquals((long)Errors.NONE.code(), (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic1, 0)).get()).error());
        Assert.assertEquals((long)Errors.NONE.code(), (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic2, 0)).get()).error());
        Assert.assertEquals((long)Errors.NONE.code(), (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic2, 1)).get()).error());
        Assert.assertEquals((long)Errors.NONE.code(), (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic3, 0)).get()).error());
        Assert.assertEquals((long)Errors.NONE.code(), (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic3, 1)).get()).error());
        Assert.assertEquals((Object)OffsetMetadataAndError$.MODULE$.NoOffset(), (Object)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic3, 1)).get());
        Assert.assertEquals((long)Errors.NONE.code(), (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic4, 0)).get()).error());
        Assert.assertEquals((Object)OffsetMetadataAndError$.MODULE$.NoOffset(), (Object)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic4, 0)).get());
        Assert.assertEquals((long)Errors.NONE.code(), (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic5, 0)).get()).error());
        Assert.assertEquals((Object)OffsetMetadataAndError$.MODULE$.NoOffset(), (Object)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic5, 0)).get());
        Assert.assertEquals((Object)"metadata one", (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic1, 0)).get()).metadata());
        Assert.assertEquals((Object)"metadata two", (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic2, 0)).get()).metadata());
        Assert.assertEquals((Object)"metadata three", (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic3, 0)).get()).metadata());
        Assert.assertEquals((Object)OffsetMetadata$.MODULE$.NoMetadata(), (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic2, 1)).get()).metadata());
        Assert.assertEquals((Object)OffsetMetadata$.MODULE$.NoMetadata(), (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic3, 1)).get()).metadata());
        Assert.assertEquals((Object)OffsetMetadata$.MODULE$.NoMetadata(), (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic4, 0)).get()).metadata());
        Assert.assertEquals((Object)OffsetMetadata$.MODULE$.NoMetadata(), (Object)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic5, 0)).get()).metadata());
        Assert.assertEquals((long)42L, (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic1, 0)).get()).offset());
        Assert.assertEquals((long)43L, (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic2, 0)).get()).offset());
        Assert.assertEquals((long)44L, (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic3, 0)).get()).offset());
        Assert.assertEquals((long)45L, (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic2, 1)).get()).offset());
        Assert.assertEquals((long)OffsetMetadata$.MODULE$.InvalidOffset(), (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic3, 1)).get()).offset());
        Assert.assertEquals((long)OffsetMetadata$.MODULE$.InvalidOffset(), (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic4, 0)).get()).offset());
        Assert.assertEquals((long)OffsetMetadata$.MODULE$.InvalidOffset(), (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic5, 0)).get()).offset());
    }

    @Test
    public void testLargeMetadataPayload() {
        TopicAndPartition topicAndPartition = new TopicAndPartition("large-metadata", 0);
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})))}));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topicAndPartition.topic(), (Map<Object, Seq<Object>>)expectedReplicaAssignment, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))));
        OffsetCommitRequest commitRequest = new OffsetCommitRequest("test-group", (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition), (Object)OffsetAndMetadata$.MODULE$.apply(42L, this.random().nextString(Predef$.MODULE$.Integer2int(this.server().config().offsetMetadataMaxSize()))))})), OffsetCommitRequest$.MODULE$.apply$default$3(), OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7(), OffsetCommitRequest$.MODULE$.apply$default$8());
        OffsetCommitResponse commitResponse = this.simpleConsumer().commitOffsets(commitRequest);
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)commitResponse.commitStatus().get((Object)topicAndPartition).get()));
        OffsetCommitRequest commitRequest1 = new OffsetCommitRequest(this.group(), (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition), (Object)OffsetAndMetadata$.MODULE$.apply(42L, this.random().nextString(Predef$.MODULE$.Integer2int(this.server().config().offsetMetadataMaxSize()) + 1)))})), OffsetCommitRequest$.MODULE$.apply$default$3(), OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7(), OffsetCommitRequest$.MODULE$.apply$default$8());
        OffsetCommitResponse commitResponse1 = this.simpleConsumer().commitOffsets(commitRequest1);
        Assert.assertEquals((long)Errors.OFFSET_METADATA_TOO_LARGE.code(), (long)BoxesRunTime.unboxToShort((Object)commitResponse1.commitStatus().get((Object)topicAndPartition).get()));
    }

    @Test
    public void testOffsetExpiration() {
        String topic = "topic";
        TopicAndPartition topicPartition = new TopicAndPartition(topic, 0);
        ZkUtils x$41 = this.zkUtils();
        String x$42 = topic;
        Seq x$43 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}));
        int x$44 = 1;
        int x$45 = TestUtils$.MODULE$.createTopic$default$4();
        Properties x$46 = TestUtils$.MODULE$.createTopic$default$6();
        TestUtils$.MODULE$.createTopic(x$41, x$42, x$44, x$45, (Seq<KafkaServer>)x$43, x$46);
        OffsetFetchRequest fetchRequest = new OffsetFetchRequest(this.group(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition(topic, 0)})), OffsetFetchRequest$.MODULE$.apply$default$3(), OffsetFetchRequest$.MODULE$.apply$default$4(), OffsetFetchRequest$.MODULE$.apply$default$5());
        OffsetCommitRequest commitRequest0 = new OffsetCommitRequest(this.group(), (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply(1L, "metadata"))})), 0, OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7(), OffsetCommitRequest$.MODULE$.apply$default$8());
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)this.simpleConsumer().commitOffsets(commitRequest0).commitStatus().get((Object)topicPartition).get()));
        Assert.assertEquals((long)-1L, (long)((OffsetMetadataAndError)this.simpleConsumer().fetchOffsets(fetchRequest).requestInfo().get((Object)topicPartition).get()).offset());
        OffsetFetchRequest offsetFetchReq = new OffsetFetchRequest(this.group(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition(topic, 0)})), 0, OffsetFetchRequest$.MODULE$.apply$default$4(), OffsetFetchRequest$.MODULE$.apply$default$5());
        OffsetFetchResponse offsetFetchResp = this.simpleConsumer().fetchOffsets(offsetFetchReq);
        Assert.assertEquals((long)1L, (long)((OffsetMetadataAndError)offsetFetchResp.requestInfo().get((Object)topicPartition).get()).offset());
        OffsetCommitRequest commitRequest1 = new OffsetCommitRequest(this.group(), (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply(2L, "metadata", -1L))})), 1, OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7(), OffsetCommitRequest$.MODULE$.apply$default$8());
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)this.simpleConsumer().commitOffsets(commitRequest1).commitStatus().get((Object)topicPartition).get()));
        Thread.sleep(this.retentionCheckInterval() * 2L);
        Assert.assertEquals((long)2L, (long)((OffsetMetadataAndError)this.simpleConsumer().fetchOffsets(fetchRequest).requestInfo().get((Object)topicPartition).get()).offset());
        OffsetCommitRequest commitRequest2 = new OffsetCommitRequest(this.group(), (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply(3L, "metadata", Time.SYSTEM.milliseconds() - 172800000L))})), 1, OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7(), OffsetCommitRequest$.MODULE$.apply$default$8());
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)this.simpleConsumer().commitOffsets(commitRequest2).commitStatus().get((Object)topicPartition).get()));
        Thread.sleep(this.retentionCheckInterval() * 2L);
        Assert.assertEquals((long)-1L, (long)((OffsetMetadataAndError)this.simpleConsumer().fetchOffsets(fetchRequest).requestInfo().get((Object)topicPartition).get()).offset());
        String x$47 = this.group();
        scala.collection.immutable.Map x$48 = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply(4L, "metadata", -1L))}));
        short x$49 = 2;
        long x$50 = 3600000L;
        int x$51 = OffsetCommitRequest$.MODULE$.apply$default$4();
        String x$52 = OffsetCommitRequest$.MODULE$.apply$default$5();
        int x$53 = OffsetCommitRequest$.MODULE$.apply$default$6();
        String x$54 = OffsetCommitRequest$.MODULE$.apply$default$7();
        OffsetCommitRequest commitRequest3 = new OffsetCommitRequest(x$47, x$48, x$49, x$51, x$52, x$53, x$54, x$50);
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)this.simpleConsumer().commitOffsets(commitRequest3).commitStatus().get((Object)topicPartition).get()));
        Thread.sleep(this.retentionCheckInterval() * 2L);
        Assert.assertEquals((long)4L, (long)((OffsetMetadataAndError)this.simpleConsumer().fetchOffsets(fetchRequest).requestInfo().get((Object)topicPartition).get()).offset());
        String x$55 = "test-group";
        scala.collection.immutable.Map x$56 = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(topic, 0)), (Object)OffsetAndMetadata$.MODULE$.apply(5L, "metadata", -1L))}));
        short x$57 = 2;
        long x$58 = 0L;
        int x$59 = OffsetCommitRequest$.MODULE$.apply$default$4();
        String x$60 = OffsetCommitRequest$.MODULE$.apply$default$5();
        int x$61 = OffsetCommitRequest$.MODULE$.apply$default$6();
        String x$62 = OffsetCommitRequest$.MODULE$.apply$default$7();
        OffsetCommitRequest commitRequest4 = new OffsetCommitRequest(x$55, x$56, x$57, x$59, x$60, x$61, x$62, x$58);
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)this.simpleConsumer().commitOffsets(commitRequest4).commitStatus().get((Object)topicPartition).get()));
        Thread.sleep(this.retentionCheckInterval() * 2L);
        Assert.assertEquals((long)-1L, (long)((OffsetMetadataAndError)this.simpleConsumer().fetchOffsets(fetchRequest).requestInfo().get((Object)topicPartition).get()).offset());
    }

    @Test
    public void testNonExistingTopicOffsetCommit() {
        String topic1 = "topicDoesNotExists";
        String topic2 = "topic-2";
        ZkUtils x$63 = this.zkUtils();
        String x$64 = topic2;
        Seq x$65 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}));
        int x$66 = 1;
        int x$67 = TestUtils$.MODULE$.createTopic$default$4();
        Properties x$68 = TestUtils$.MODULE$.createTopic$default$6();
        TestUtils$.MODULE$.createTopic(x$63, x$64, x$66, x$67, (Seq<KafkaServer>)x$65, x$68);
        OffsetCommitRequest commitRequest = new OffsetCommitRequest(this.group(), (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(topic1, 0)), (Object)OffsetAndMetadata$.MODULE$.apply(42L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(topic2, 0)), (Object)OffsetAndMetadata$.MODULE$.apply(42L))})), OffsetCommitRequest$.MODULE$.apply$default$3(), OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7(), OffsetCommitRequest$.MODULE$.apply$default$8());
        OffsetCommitResponse commitResponse = this.simpleConsumer().commitOffsets(commitRequest);
        Assert.assertEquals((long)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (long)BoxesRunTime.unboxToShort((Object)commitResponse.commitStatus().get((Object)new TopicAndPartition(topic1, 0)).get()));
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)commitResponse.commitStatus().get((Object)new TopicAndPartition(topic2, 0)).get()));
    }

    @Test
    public void testOffsetsDeleteAfterTopicDeletion() {
        String topic = "topic";
        TopicAndPartition topicPartition = new TopicAndPartition(topic, 0);
        ZkUtils x$69 = this.zkUtils();
        String x$70 = topic;
        Seq x$71 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}));
        int x$72 = 1;
        int x$73 = TestUtils$.MODULE$.createTopic$default$4();
        Properties x$74 = TestUtils$.MODULE$.createTopic$default$6();
        TestUtils$.MODULE$.createTopic(x$69, x$70, x$72, x$73, (Seq<KafkaServer>)x$71, x$74);
        OffsetCommitRequest commitRequest = new OffsetCommitRequest(this.group(), (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply(42L))})), OffsetCommitRequest$.MODULE$.apply$default$3(), OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7(), OffsetCommitRequest$.MODULE$.apply$default$8());
        OffsetCommitResponse commitResponse = this.simpleConsumer().commitOffsets(commitRequest);
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)commitResponse.commitStatus().get((Object)topicPartition).get()));
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))));
        Thread.sleep(this.retentionCheckInterval() * 2L);
        OffsetFetchRequest fetchRequest = new OffsetFetchRequest(this.group(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition(topic, 0)})), OffsetFetchRequest$.MODULE$.apply$default$3(), OffsetFetchRequest$.MODULE$.apply$default$4(), OffsetFetchRequest$.MODULE$.apply$default$5());
        OffsetFetchResponse offsetMetadataAndErrorMap = this.simpleConsumer().fetchOffsets(fetchRequest);
        OffsetMetadataAndError offsetMetadataAndError = (OffsetMetadataAndError)offsetMetadataAndErrorMap.requestInfo().apply((Object)topicPartition);
        Assert.assertEquals((Object)OffsetMetadataAndError$.MODULE$.NoOffset(), (Object)offsetMetadataAndError);
    }

    public OffsetCommitTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.random = new Random();
        this.group = "test-group";
        this.retentionCheckInterval = 100L;
        this.logDir = null;
        this.topicLogDir = null;
        this.server = null;
        this.logSize = 100;
        this.simpleConsumer = null;
    }
}

