/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.test.TestUtils;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001\u000f\tY2+\u001a:wKJ<UM\\3sCR,7\t\\;ti\u0016\u0014\u0018\n\u001a+fgRT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!\u0011\u0002CA\u0005\u0011\u001b\u0005Q!BA\u0006\r\u0003\u0015QWO\\5u\u0015\tia\"A\u0005tG\u0006d\u0017\r^3ti*\tq\"A\u0002pe\u001eL!!\u0005\u0006\u0003\u0015)+f.\u001b;Tk&$X\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005\u0011!p[\u0005\u0003/Q\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u001dq\u0002\u00011A\u0005\u0002}\tqaY8oM&<\u0017'F\u0001!!\ta\u0012%\u0003\u0002#\u0005\tY1*\u00194lC\u000e{gNZ5h\u0011\u001d!\u0003\u00011A\u0005\u0002\u0015\n1bY8oM&<\u0017g\u0018\u0013fcR\u0011a\u0005\f\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0005+:LG\u000fC\u0004.G\u0005\u0005\t\u0019\u0001\u0011\u0002\u0007a$\u0013\u0007\u0003\u00040\u0001\u0001\u0006K\u0001I\u0001\tG>tg-[42A!9\u0011\u0007\u0001a\u0001\n\u0003y\u0012aB2p]\u001aLwM\r\u0005\bg\u0001\u0001\r\u0011\"\u00015\u0003-\u0019wN\u001c4jOJzF%Z9\u0015\u0005\u0019*\u0004bB\u00173\u0003\u0003\u0005\r\u0001\t\u0005\u0007o\u0001\u0001\u000b\u0015\u0002\u0011\u0002\u0011\r|gNZ5he\u0001Bq!\u000f\u0001A\u0002\u0013\u0005q$A\u0004d_:4\u0017nZ\u001a\t\u000fm\u0002\u0001\u0019!C\u0001y\u0005Y1m\u001c8gS\u001e\u001ct\fJ3r)\t1S\bC\u0004.u\u0005\u0005\t\u0019\u0001\u0011\t\r}\u0002\u0001\u0015)\u0003!\u0003!\u0019wN\u001c4jON\u0002\u0003\"B!\u0001\t\u0003\u0012\u0015!B:fiV\u0003H#\u0001\u0014)\u0005\u0001#\u0005CA#H\u001b\u00051%BA\u0006\u000f\u0013\tAeI\u0001\u0004CK\u001a|'/\u001a\u0005\u0006\u0015\u0002!\tAQ\u0001\u001ai\u0016\u001cH/Q;u_\u001e+g.\u001a:bi\u0016\u001cE.^:uKJLE\r\u000b\u0002J\u0019B\u0011Q)T\u0005\u0003\u001d\u001a\u0013A\u0001V3ti\")\u0001\u000b\u0001C\u0001\u0005\u0006\u0011D/Z:u\u0003V$xnR3oKJ\fG/Z\"mkN$XM]%e\r>\u00148*\u00194lC\u000ecWo\u001d;feN+\u0017/^3oi&\fG\u000e\u000b\u0002P\u0019\")1\u000b\u0001C\u0001\u0005\u0006\u0001D/Z:u\u0003V$xnR3oKJ\fG/Z\"mkN$XM]%e\r>\u00148*\u00194lC\u000ecWo\u001d;feB\u000b'/\u00197mK2D#A\u0015'")
public class ServerGenerateClusterIdTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private KafkaConfig config1;
    private KafkaConfig config2;
    private KafkaConfig config3;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    @After
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ServerGenerateClusterIdTest serverGenerateClusterIdTest = this;
        synchronized (serverGenerateClusterIdTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public KafkaConfig config1() {
        return this.config1;
    }

    public void config1_$eq(KafkaConfig x$1) {
        this.config1 = x$1;
    }

    public KafkaConfig config2() {
        return this.config2;
    }

    public void config2_$eq(KafkaConfig x$1) {
        this.config2 = x$1;
    }

    public KafkaConfig config3() {
        return this.config3;
    }

    public void config3_$eq(KafkaConfig x$1) {
        this.config3 = x$1;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16())));
        this.config2_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(2, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16())));
        this.config3_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(3, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16())));
    }

    @Test
    public void testAutoGenerateClusterId() {
        Assert.assertFalse((boolean)this.zkUtils().pathExists(ZkUtils$.MODULE$.ClusterIdPath()));
        KafkaServer server1 = TestUtils$.MODULE$.createServer(this.config1(), TestUtils$.MODULE$.createServer$default$2());
        String clusterIdOnFirstBoot = server1.clusterId();
        TestUtils.isValidClusterId((String)clusterIdOnFirstBoot);
        server1.shutdown();
        Assert.assertTrue((boolean)this.zkUtils().pathExists(ZkUtils$.MODULE$.ClusterIdPath()));
        Assert.assertEquals((Object)this.zkUtils().getClusterId(), (Object)new Some((Object)clusterIdOnFirstBoot));
        server1 = new KafkaServer(this.config1(), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4());
        server1.startup();
        String clusterIdOnSecondBoot = server1.clusterId();
        Assert.assertEquals((Object)clusterIdOnFirstBoot, (Object)clusterIdOnSecondBoot);
        server1.shutdown();
        Assert.assertTrue((boolean)this.zkUtils().pathExists(ZkUtils$.MODULE$.ClusterIdPath()));
        Assert.assertEquals((Object)this.zkUtils().getClusterId(), (Object)new Some((Object)clusterIdOnFirstBoot));
        CoreUtils$.MODULE$.delete(server1.config().logDirs());
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    @Test
    public void testAutoGenerateClusterIdForKafkaClusterSequential() {
        KafkaServer server1 = TestUtils$.MODULE$.createServer(this.config1(), TestUtils$.MODULE$.createServer$default$2());
        String clusterIdFromServer1 = server1.clusterId();
        KafkaServer server2 = TestUtils$.MODULE$.createServer(this.config2(), TestUtils$.MODULE$.createServer$default$2());
        String clusterIdFromServer2 = server2.clusterId();
        KafkaServer server3 = TestUtils$.MODULE$.createServer(this.config3(), TestUtils$.MODULE$.createServer$default$2());
        String clusterIdFromServer3 = server3.clusterId();
        server1.shutdown();
        server2.shutdown();
        server3.shutdown();
        TestUtils.isValidClusterId((String)clusterIdFromServer1);
        Assert.assertEquals((String)clusterIdFromServer1, (Object)clusterIdFromServer2, (Object)clusterIdFromServer3);
        server1.startup();
        Assert.assertEquals((Object)clusterIdFromServer1, (Object)server1.clusterId());
        server2.startup();
        Assert.assertEquals((Object)clusterIdFromServer2, (Object)server2.clusterId());
        server3.startup();
        Assert.assertEquals((Object)clusterIdFromServer3, (Object)server3.clusterId());
        server1.shutdown();
        server2.shutdown();
        server3.shutdown();
        CoreUtils$.MODULE$.delete(server1.config().logDirs());
        CoreUtils$.MODULE$.delete(server2.config().logDirs());
        CoreUtils$.MODULE$.delete(server3.config().logDirs());
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    @Test
    public void testAutoGenerateClusterIdForKafkaClusterParallel() {
        Future firstBoot = Future$.MODULE$.traverse((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{this.config1(), this.config2(), this.config3()})), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Future<KafkaServer> apply(KafkaConfig config) {
                return Future$.MODULE$.apply((Function0)new Serializable(this, config){
                    public static final long serialVersionUID = 0L;
                    private final KafkaConfig config$1;

                    public final KafkaServer apply() {
                        return TestUtils$.MODULE$.createServer(this.config$1, TestUtils$.MODULE$.createServer$default$2());
                    }
                    {
                        this.config$1 = config$1;
                    }
                }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
            }
        }, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        Seq seq = (Seq)Await$.MODULE$.result((Awaitable)firstBoot, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(100)).second());
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
            Tuple3 tuple3;
            KafkaServer server1 = (KafkaServer)((SeqLike)some.get()).apply(0);
            KafkaServer server2 = (KafkaServer)((SeqLike)some.get()).apply(1);
            KafkaServer server3 = (KafkaServer)((SeqLike)some.get()).apply(2);
            Tuple3 tuple32 = tuple3 = new Tuple3((Object)server1, (Object)server2, (Object)server3);
            KafkaServer server12 = (KafkaServer)tuple32._1();
            KafkaServer server22 = (KafkaServer)tuple32._2();
            KafkaServer server32 = (KafkaServer)tuple32._3();
            String clusterIdFromServer1 = server12.clusterId();
            String clusterIdFromServer2 = server22.clusterId();
            String clusterIdFromServer3 = server32.clusterId();
            server12.shutdown();
            server22.shutdown();
            server32.shutdown();
            TestUtils.isValidClusterId((String)clusterIdFromServer1);
            Assert.assertEquals((String)clusterIdFromServer1, (Object)clusterIdFromServer2, (Object)clusterIdFromServer3);
            Future secondBoot = Future$.MODULE$.traverse((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server12, server22, server32})), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Future<KafkaServer> apply(KafkaServer server) {
                    return Future$.MODULE$.apply((Function0)new Serializable(this, server){
                        public static final long serialVersionUID = 0L;
                        private final KafkaServer server$1;

                        public final KafkaServer apply() {
                            this.server$1.startup();
                            return this.server$1;
                        }
                        {
                            this.server$1 = server$1;
                        }
                    }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
                }
            }, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
            Seq servers = (Seq)Await$.MODULE$.result((Awaitable)secondBoot, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(100)).second());
            servers.foreach((Function1)new Serializable(this, clusterIdFromServer1){
                public static final long serialVersionUID = 0L;
                private final String clusterIdFromServer1$1;

                public final void apply(KafkaServer server) {
                    Assert.assertEquals((Object)this.clusterIdFromServer1$1, (Object)server.clusterId());
                }
                {
                    this.clusterIdFromServer1$1 = clusterIdFromServer1$1;
                }
            });
            servers.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(KafkaServer x$2) {
                    x$2.shutdown();
                }
            });
            CoreUtils$.MODULE$.delete(server12.config().logDirs());
            CoreUtils$.MODULE$.delete(server22.config().logDirs());
            CoreUtils$.MODULE$.delete(server32.config().logDirs());
            TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
            return;
        }
        throw new MatchError((Object)seq);
    }

    public ServerGenerateClusterIdTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.config1 = null;
        this.config2 = null;
        this.config3 = null;
    }
}

