/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.Request$;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.server.SimpleFetchTest$;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u0001\u0003\u0001\u001d\u0011qbU5na2,g)\u001a;dQR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%\t!F\u0001\u0014e\u0016\u0004H.[2b\u0019\u0006<G+[7f\u001b\u0006DXj]\u000b\u0002-A\u0011\u0011bF\u0005\u00031)\u0011A\u0001T8oO\"1!\u0004\u0001Q\u0001\nY\tAC]3qY&\u001c\u0017\rT1h)&lW-T1y\u001bN\u0004\u0003b\u0002\u000f\u0001\u0005\u0004%\t!H\u0001\u0016e\u0016\u0004H.[2b\r\u0016$8\r[,bSRl\u0015\r_'t+\u0005q\u0002CA\u0005 \u0013\t\u0001#BA\u0002J]RDaA\t\u0001!\u0002\u0013q\u0012A\u0006:fa2L7-\u0019$fi\u000eDw+Y5u\u001b\u0006DXj\u001d\u0011\t\u000f\u0011\u0002!\u0019!C\u0001+\u0005)\"/\u001a9mS\u000e\fG*Y4NCblUm]:bO\u0016\u001c\bB\u0002\u0014\u0001A\u0003%a#\u0001\fsKBd\u0017nY1MC\u001el\u0015\r_'fgN\fw-Z:!\u0011\u001dA\u0003A1A\u0005\u0002%\nqb\u001c<feJLG-\u001b8h!J|\u0007o]\u000b\u0002UA\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\u0005kRLGNC\u00010\u0003\u0011Q\u0017M^1\n\u0005Eb#A\u0003)s_B,'\u000f^5fg\"11\u0007\u0001Q\u0001\n)\n\u0001c\u001c<feJLG-\u001b8h!J|\u0007o\u001d\u0011\t\u000fU\u0002!\u0019!C\u0001m\u000591m\u001c8gS\u001e\u001cX#A\u001c\u0011\u0007aZT(D\u0001:\u0015\tQ$\"\u0001\u0006d_2dWm\u0019;j_:L!\u0001P\u001d\u0003\u0007M+\u0017\u000f\u0005\u0002\u0013}%\u0011qH\u0001\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0004B\u0001\u0001\u0006IaN\u0001\tG>tg-[4tA!91\t\u0001b\u0001\n\u0003!\u0015\u0001\u0002;j[\u0016,\u0012!\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\u0012\tQ!\u001e;jYNL!AS$\u0003\u00115{7m\u001b+j[\u0016Da\u0001\u0014\u0001!\u0002\u0013)\u0015!\u0002;j[\u0016\u0004\u0003b\u0002(\u0001\u0005\u0004%\taT\u0001\b[\u0016$(/[2t+\u0005\u0001\u0006CA)[\u001b\u0005\u0011&B\u0001(T\u0015\t!V+\u0001\u0004d_6lwN\u001c\u0006\u0003\u000bYS!a\u0016-\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0016aA8sO&\u00111L\u0015\u0002\b\u001b\u0016$(/[2t\u0011\u0019i\u0006\u0001)A\u0005!\u0006AQ.\u001a;sS\u000e\u001c\b\u0005C\u0004`\u0001\t\u0007I\u0011A\u000b\u0002\u00131,\u0017\rZ3s\u0019\u0016{\u0005BB1\u0001A\u0003%a#\u0001\u0006mK\u0006$WM\u001d'F\u001f\u0002Bqa\u0019\u0001C\u0002\u0013\u0005Q#A\u0006g_2dwn^3s\u0019\u0016{\u0005BB3\u0001A\u0003%a#\u0001\u0007g_2dwn^3s\u0019\u0016{\u0005\u0005C\u0004h\u0001\t\u0007I\u0011A\u000f\u0002\u0017A\f'\u000f^5uS>t\u0007j\u0016\u0005\u0007S\u0002\u0001\u000b\u0011\u0002\u0010\u0002\u0019A\f'\u000f^5uS>t\u0007j\u0016\u0011\t\u000f-\u0004!\u0019!C\u0001;\u0005Ia-\u001a;dQNK'0\u001a\u0005\u0007[\u0002\u0001\u000b\u0011\u0002\u0010\u0002\u0015\u0019,Go\u00195TSj,\u0007\u0005C\u0004p\u0001\t\u0007I\u0011\u00019\u0002\u00195,7o]1hKN$v\u000eS,\u0016\u0003E\u0004\"A];\u000e\u0003MT!\u0001^*\u0002\rI,7m\u001c:e\u0013\t18O\u0001\u0004SK\u000e|'\u000f\u001a\u0005\u0007q\u0002\u0001\u000b\u0011B9\u0002\u001b5,7o]1hKN$v\u000eS,!\u0011\u001dQ\bA1A\u0005\u0002A\fQ\"\\3tg\u0006<Wm\u001d+p\u0019\u0016{\u0005B\u0002?\u0001A\u0003%\u0011/\u0001\bnKN\u001c\u0018mZ3t)>dUi\u0014\u0011\t\u000fy\u0004!\u0019!C\u0001\u007f\u0006)Ao\u001c9jGV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001\u0018\u0002\t1\fgnZ\u0005\u0005\u0003\u0017\t)A\u0001\u0004TiJLgn\u001a\u0005\t\u0003\u001f\u0001\u0001\u0015!\u0003\u0002\u0002\u00051Ao\u001c9jG\u0002B\u0001\"a\u0005\u0001\u0005\u0004%\t!H\u0001\fa\u0006\u0014H/\u001b;j_:LE\rC\u0004\u0002\u0018\u0001\u0001\u000b\u0011\u0002\u0010\u0002\u0019A\f'\u000f^5uS>t\u0017\n\u001a\u0011\t\u0013\u0005m\u0001A1A\u0005\u0002\u0005u\u0011A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0003\u0003?\u0001B!!\t\u0002$5\t1+C\u0002\u0002&M\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002*\u0001\u0001\u000b\u0011BA\u0010\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0003\"CA\u0017\u0001\t\u0007I\u0011AA\u0018\u0003%1W\r^2i\u0013:4w.\u0006\u0002\u00022A!\u0001hOA\u001a!\u001dI\u0011QGA\u0010\u0003sI1!a\u000e\u000b\u0005\u0019!V\u000f\u001d7feA!\u00111HA0\u001d\u0011\ti$!\u0017\u000f\t\u0005}\u0012Q\u000b\b\u0005\u0003\u0003\n\u0019F\u0004\u0003\u0002D\u0005Ec\u0002BA#\u0003\u001frA!a\u0012\u0002N5\u0011\u0011\u0011\n\u0006\u0004\u0003\u00172\u0011A\u0002\u001fs_>$h(C\u0001Z\u0013\t9\u0006,\u0003\u0002\u0006-&\u0011A+V\u0005\u0004\u0003/\u001a\u0016\u0001\u0003:fcV,7\u000f^:\n\t\u0005m\u0013QL\u0001\r\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u0006\u0004\u0003/\u001a\u0016\u0002BA1\u0003G\u0012Q\u0002U1si&$\u0018n\u001c8ECR\f'\u0002BA.\u0003;B\u0001\"a\u001a\u0001A\u0003%\u0011\u0011G\u0001\u000bM\u0016$8\r[%oM>\u0004\u0003\"CA6\u0001\u0001\u0007I\u0011AA7\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\"!a\u001c\u0011\u0007I\t\t(C\u0002\u0002t\t\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'\u000fC\u0005\u0002x\u0001\u0001\r\u0011\"\u0001\u0002z\u0005\u0011\"/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014x\fJ3r)\u0011\tY(!!\u0011\u0007%\ti(C\u0002\u0002\u0000)\u0011A!\u00168ji\"Q\u00111QA;\u0003\u0003\u0005\r!a\u001c\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002\b\u0002\u0001\u000b\u0015BA8\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0003bBAF\u0001\u0011\u0005\u0011QR\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003wBC!!#\u0002\u0012B!\u00111SAM\u001b\t\t)JC\u0002\u0002\u0018b\u000bQA[;oSRLA!a'\u0002\u0016\n1!)\u001a4pe\u0016Dq!a(\u0001\t\u0003\ti)\u0001\u0005uK\u0006\u0014Hi\\<oQ\u0011\ti*a)\u0011\t\u0005M\u0015QU\u0005\u0005\u0003O\u000b)JA\u0003BMR,'\u000fC\u0004\u0002,\u0002!\t!!$\u0002\u001fQ,7\u000f\u001e*fC\u00124%o\\7M_\u001eDC!!+\u00020B!\u00111SAY\u0013\u0011\t\u0019,!&\u0003\tQ+7\u000f\u001e")
public class SimpleFetchTest {
    private final long replicaLagTimeMaxMs;
    private final int replicaFetchWaitMaxMs;
    private final long replicaLagMaxMessages;
    private final Properties overridingProps = new Properties();
    private final Seq<KafkaConfig> configs;
    private final MockTime time;
    private final Metrics metrics;
    private final long leaderLEO;
    private final long followerLEO;
    private final int partitionHW;
    private final int fetchSize;
    private final Record messagesToHW;
    private final Record messagesToLEO;
    private final String topic;
    private final int partitionId;
    private final TopicPartition topicPartition;
    private final Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo;
    private ReplicaManager replicaManager;

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public long replicaLagMaxMessages() {
        return this.replicaLagMaxMessages;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public long leaderLEO() {
        return this.leaderLEO;
    }

    public long followerLEO() {
        return this.followerLEO;
    }

    public int partitionHW() {
        return this.partitionHW;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public Record messagesToHW() {
        return this.messagesToHW;
    }

    public Record messagesToLEO() {
        return this.messagesToLEO;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo() {
        return this.fetchInfo;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Before
    public void setUp() {
        ZkUtils zkUtils = (ZkUtils)EasyMock.createNiceMock(ZkUtils.class);
        EasyMock.replay((Object[])new Object[]{zkUtils});
        KafkaScheduler scheduler = (KafkaScheduler)EasyMock.createNiceMock(KafkaScheduler.class);
        EasyMock.replay((Object[])new Object[]{scheduler});
        Log log = (Log)EasyMock.createMock(Log.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)this.leaderLEO())).anyTimes();
        EasyMock.expect((Object)log.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata(this.leaderLEO(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)log.read(0L, this.fetchSize(), (Option)new Some((Object)BoxesRunTime.boxToLong((long)this.partitionHW())), true)).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.withRecords((Record[])new Record[]{this.messagesToHW()}), FetchDataInfo$.MODULE$.apply$default$3())).anyTimes();
        EasyMock.expect((Object)log.read(0L, this.fetchSize(), (Option)None$.MODULE$, true)).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.withRecords((Record[])new Record[]{this.messagesToLEO()}), FetchDataInfo$.MODULE$.apply$default$3())).anyTimes();
        EasyMock.replay((Object[])new Object[]{log});
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.getLog(this.topicPartition())).andReturn((Object)new Some((Object)log)).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), zkUtils, (Scheduler)scheduler, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time()).follower(), ReplicaManager$.MODULE$.$lessinit$greater$default$9()));
        Partition partition = this.replicaManager().getOrCreatePartition(new TopicPartition(this.topic(), this.partitionId()));
        Replica leaderReplica = new Replica(((KafkaConfig)this.configs().head()).brokerId(), partition, (Time)this.time(), 0L, (Option)new Some((Object)log));
        leaderReplica.highWatermark_$eq(new LogOffsetMetadata((long)this.partitionHW(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderReplica.brokerId())));
        Replica followerReplica = new Replica(((KafkaConfig)this.configs().apply(1)).brokerId(), partition, (Time)this.time(), Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5());
        LogOffsetMetadata leo = new LogOffsetMetadata(this.followerLEO(), 0L, (int)this.followerLEO());
        followerReplica.updateLogReadResult(new LogReadResult(new FetchDataInfo(leo, (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3()), leo.messageOffset(), leo.messageOffset(), this.time().milliseconds(), -1, LogReadResult$.MODULE$.$lessinit$greater$default$6()));
        List allReplicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Replica[]{leaderReplica, followerReplica}));
        allReplicas.foreach((Function1)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final Partition partition$1;

            public final Replica apply(Replica replica) {
                return this.partition$1.addReplicaIfNotExists(replica);
            }
            {
                this.partition$1 = partition$1;
            }
        });
        partition.inSyncReplicas_$eq(allReplicas.toSet());
    }

    @After
    public void tearDown() {
        this.replicaManager().shutdown(false);
        this.metrics().close();
    }

    @Test
    public void testReadFromLog() {
        long initialTopicCount = BrokerTopicStats$.MODULE$.getBrokerTopicStats(this.topic()).totalFetchRequestRate().count();
        long initialAllTopicsCount = BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().totalFetchRequestRate().count();
        Assert.assertEquals((String)"Reading committed data should return messages only up to high watermark", (Object)this.messagesToHW(), (Object)((LogEntry)((LogReadResult)((Tuple2)this.replicaManager().readFromLocalLog(Request$.MODULE$.OrdinaryConsumerId(), true, true, Integer.MAX_VALUE, false, this.fetchInfo(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleFetchTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$2) {
                Object object = x$2._1();
                TopicPartition topicPartition = this.$outer.topicPartition();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().shallowEntries().iterator().next()).record());
        Assert.assertEquals((String)"Reading any data can return messages up to the end of the log", (Object)this.messagesToLEO(), (Object)((LogEntry)((LogReadResult)((Tuple2)this.replicaManager().readFromLocalLog(Request$.MODULE$.OrdinaryConsumerId(), true, false, Integer.MAX_VALUE, false, this.fetchInfo(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleFetchTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$3) {
                Object object = x$3._1();
                TopicPartition topicPartition = this.$outer.topicPartition();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().shallowEntries().iterator().next()).record());
        Assert.assertEquals((String)"Counts should increment after fetch", (long)(initialTopicCount + 2L), (long)BrokerTopicStats$.MODULE$.getBrokerTopicStats(this.topic()).totalFetchRequestRate().count());
        Assert.assertEquals((String)"Counts should increment after fetch", (long)(initialAllTopicsCount + 2L), (long)BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().totalFetchRequestRate().count());
    }

    public SimpleFetchTest() {
        this.replicaLagTimeMaxMs = 100L;
        this.replicaFetchWaitMaxMs = 100;
        this.replicaLagMaxMessages = 10L;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.replicaLagTimeMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchWaitMaxMs())).toString());
        this.configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new $anonfun$1(this), Seq$.MODULE$.canBuildFrom());
        this.time = new MockTime();
        this.metrics = new Metrics();
        this.leaderLEO = 20L;
        this.followerLEO = 15L;
        this.partitionHW = 5;
        this.fetchSize = 100;
        this.messagesToHW = Record.create((byte[])"messageToHW".getBytes());
        this.messagesToLEO = Record.create((byte[])"messageToLEO".getBytes());
        this.topic = "test-topic";
        this.partitionId = 0;
        this.topicPartition = new TopicPartition(this.topic(), this.partitionId());
        this.fetchInfo = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topicPartition()), (Object)new FetchRequest.PartitionData(0L, this.fetchSize()))}));
        this.replicaManager = null;
    }
}

