/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.List;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001}2A!\u0001\u0002\u0001\u000f\tY!l[+uS2\u001cH+Z:u\u0015\t\u0019A!A\u0003vi&d7OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u0013!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!A\u0003&V]&$8+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0003u.L!a\u0006\u000b\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0004\u001f\u0001\t\u0007I\u0011A\u0010\u0002\tA\fG\u000f[\u000b\u0002AA\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0005Y\u0006twMC\u0001&\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0012#AB*ue&tw\r\u0003\u0004*\u0001\u0001\u0006I\u0001I\u0001\u0006a\u0006$\b\u000e\t\u0005\u0006W\u0001!\t\u0001L\u0001$i\u0016\u001cHoU;dG\u0016\u001c8OZ;m\u0007>tG-\u001b;j_:\fG\u000eR3mKR,\u0007+\u0019;i)\u0005i\u0003C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#\u0001B+oSRD#A\u000b\u001b\u0011\u0005U:T\"\u0001\u001c\u000b\u0005-q\u0011B\u0001\u001d7\u0005\u0011!Vm\u001d;\t\u000bi\u0002A\u0011\u0001\u0017\u0002AQ,7\u000f^!c_J$X\rZ\"p]\u0012LG/[8oC2$U\r\\3uKB\u000bG\u000f\u001b\u0015\u0003sQBQ!\u0010\u0001\u0005\u00021\n\u0001\u0005^3ti\u000ecWo\u001d;fe&#WM\u001c;jM&,'OS:p]B\u000b'o]5oO\"\u0012A\b\u000e")
public class ZkUtilsTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final String path;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ZkUtilsTest zkUtilsTest = this;
        synchronized (zkUtilsTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public String path() {
        return this.path;
    }

    @Test
    public void testSuccessfulConditionalDeletePath() {
        ZkUtils qual$1 = this.zkUtils();
        String x$1 = this.path();
        String x$2 = qual$1.createPersistentPath$default$2();
        List x$3 = qual$1.createPersistentPath$default$3();
        qual$1.createPersistentPath(x$1, x$2, x$3);
        Tuple2 tuple2 = this.zkUtils().readData(this.path());
        if (tuple2 != null) {
            Stat statAfterCreation;
            Stat stat;
            Stat statAfterCreation2 = stat = (statAfterCreation = (Stat)tuple2._2());
            Assert.assertTrue((String)"Deletion should be successful", (boolean)this.zkUtils().conditionalDeletePath(this.path(), statAfterCreation2.getVersion()));
            Tuple2 tuple22 = this.zkUtils().readDataMaybeNull(this.path());
            if (tuple22 != null) {
                Option optionalData;
                Option option;
                Option optionalData2 = option = (optionalData = (Option)tuple22._1());
                Assert.assertTrue((String)"Node should be deleted", (boolean)optionalData2.isEmpty());
                Assert.assertTrue((String)"Deletion should be successful", (boolean)this.zkUtils().conditionalDeletePath(this.path(), 0));
                return;
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testAbortedConditionalDeletePath() {
        ZkUtils qual$2 = this.zkUtils();
        String x$4 = this.path();
        String x$5 = qual$2.createPersistentPath$default$2();
        List x$6 = qual$2.createPersistentPath$default$3();
        qual$2.createPersistentPath(x$4, x$5, x$6);
        Tuple2 tuple2 = this.zkUtils().readData(this.path());
        if (tuple2 != null) {
            Stat statAfterCreation;
            Stat stat;
            Stat statAfterCreation2 = stat = (statAfterCreation = (Stat)tuple2._2());
            ZkUtils qual$3 = this.zkUtils();
            String x$7 = this.path();
            String x$8 = "data";
            List x$9 = qual$3.updatePersistentPath$default$3();
            qual$3.updatePersistentPath(x$7, x$8, x$9);
            Assert.assertFalse((String)"Deletion should be aborted", (boolean)this.zkUtils().conditionalDeletePath(this.path(), statAfterCreation2.getVersion()));
            Tuple2 tuple22 = this.zkUtils().readDataMaybeNull(this.path());
            if (tuple22 != null) {
                Option optionalData;
                Option option;
                Option optionalData2 = option = (optionalData = (Option)tuple22._1());
                Assert.assertTrue((String)"Node should still be there", (boolean)optionalData2.isDefined());
                return;
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testClusterIdentifierJsonParsing() {
        String clusterId = "test";
        Assert.assertEquals((Object)this.zkUtils().ClusterId().fromJson(this.zkUtils().ClusterId().toJson(clusterId)), (Object)clusterId);
    }

    public ZkUtilsTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.path = "/path";
    }
}

