/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.common.KafkaException;
import kafka.log.FileMessageSet$;
import kafka.log.LogFlushStats$;
import kafka.log.OffsetPosition;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.utils.IteratorTemplate;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001B\u0001\u0003\u0001\u001d\u0011aBR5mK6+7o]1hKN+GO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u000f5,7o]1hK&\u0011QB\u0003\u0002\u000b\u001b\u0016\u001c8/Y4f'\u0016$\bCA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011U\u0001!Q1A\u0005\u0002Y\tAAZ5mKV\tq\u0003\u0005\u0002\u0019;5\t\u0011D\u0003\u0002\u001b7\u0005\u0011\u0011n\u001c\u0006\u00029\u0005!!.\u0019<b\u0013\tq\u0012D\u0001\u0003GS2,\u0007\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\u000b\u0019LG.\u001a\u0011\t\u0013\t\u0002!Q1A\u0005\u0002\t\u0019\u0013aB2iC:tW\r\\\u000b\u0002IA\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\tG\"\fgN\\3mg*\u0011\u0011fG\u0001\u0004]&|\u0017BA\u0016'\u0005-1\u0015\u000e\\3DQ\u0006tg.\u001a7\t\u00115\u0002!\u0011!Q\u0001\n\u0011\n\u0001b\u00195b]:,G\u000e\t\u0005\n_\u0001\u0011)\u0019!C\u0001\u0005A\nQa\u001d;beR,\u0012!\r\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0004\u0013:$\b\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\rM$\u0018M\u001d;!\u0011%Q\u0004A!b\u0001\n\u0003\u0011\u0001'A\u0003mS6LG\u000f\u0003\u0005=\u0001\t\u0005\t\u0015!\u00032\u0003\u0019a\u0017.\\5uA!Aa\b\u0001B\u0001B\u0003%q(\u0001\rj]&$8\t[1o]\u0016d\u0007k\\:ji&|g\u000eV8F]\u0012\u0004\"A\r!\n\u0005\u0005\u001b$a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0007\u0002!\t\u0001\u0002#\u0002\rqJg.\u001b;?)\u0019)u\tS%K\u0017B\u0011a\tA\u0007\u0002\u0005!)QC\u0011a\u0001/!)!E\u0011a\u0001I!9qF\u0011I\u0001\u0002\u0004\t\u0004b\u0002\u001eC!\u0003\u0005\r!\r\u0005\b}\t\u0003\n\u00111\u0001@\u0011\u001di\u0005A1A\u0005\n9\u000bQaX:ju\u0016,\u0012a\u0014\t\u0003!^k\u0011!\u0015\u0006\u0003%N\u000ba!\u0019;p[&\u001c'B\u0001+V\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003-n\tA!\u001e;jY&\u0011\u0001,\u0015\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\t\ri\u0003\u0001\u0015!\u0003P\u0003\u0019y6/\u001b>fA!)1\t\u0001C\u00019R\u0019Q)\u00180\t\u000bUY\u0006\u0019A\f\t\u000b\tZ\u0006\u0019\u0001\u0013\t\u000b\r\u0003A\u0011\u00011\u0015\u0005\u0015\u000b\u0007\"B\u000b`\u0001\u00049\u0002\"B2\u0001\t\u0003!\u0017\u0001\u0002:fC\u0012$2!R3h\u0011\u00151'\r1\u00012\u0003!\u0001xn]5uS>t\u0007\"\u00025c\u0001\u0004\t\u0014\u0001B:ju\u0016DaA\u001b\u0001\u0005\u0002\tY\u0017!C:fCJ\u001c\u0007NR8s)\raw\u000e\u001e\t\u0003\r6L!A\u001c\u0002\u0003\u001d=3gm]3u!>\u001c\u0018\u000e^5p]\")\u0001/\u001ba\u0001c\u0006aA/\u0019:hKR|eMZ:fiB\u0011!G]\u0005\u0003gN\u0012A\u0001T8oO\")Q/\u001ba\u0001c\u0005\u00012\u000f^1si&tw\rU8tSRLwN\u001c\u0005\u0006o\u0002!\t\u0001_\u0001\boJLG/\u001a+p)\u0015\t\u0014P`A\u0001\u0011\u0015Qh\u000f1\u0001|\u0003-!Wm\u001d;DQ\u0006tg.\u001a7\u0011\u0005\u0015b\u0018BA?'\u0005Q9\u0015\r\u001e5fe&twMQ=uK\u000eC\u0017M\u001c8fY\")qP\u001ea\u0001c\u0006iqO]5uKB{7/\u001b;j_:DQ\u0001\u001b<A\u0002EBq!!\u0002\u0001\t\u0003\n9!\u0001\u0005ji\u0016\u0014\u0018\r^8s+\t\tI\u0001\u0005\u0004\u0002\f\u0005m\u0011\u0011\u0005\b\u0005\u0003\u001b\t9B\u0004\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019BB\u0001\u0007yI|w\u000e\u001e \n\u0003QJ1!!\u00074\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\b\u0002 \tA\u0011\n^3sCR|'OC\u0002\u0002\u001aM\u00022!CA\u0012\u0013\r\t)C\u0003\u0002\u0011\u001b\u0016\u001c8/Y4f\u0003:$wJ\u001a4tKRDq!!\u000b\u0001\t\u0003\tY#A\u0006tSj,\u0017J\u001c\"zi\u0016\u001cH#A\u0019\t\u000f\u0005=\u0002\u0001\"\u0001\u00022\u00051\u0011\r\u001d9f]\u0012$B!a\r\u0002:A\u0019!'!\u000e\n\u0007\u0005]2G\u0001\u0003V]&$\b\u0002CA\u001e\u0003[\u0001\r!!\u0010\u0002\u00115,7o]1hKN\u00042!CA \u0013\r\t\tE\u0003\u0002\u0015\u0005f$XMQ;gM\u0016\u0014X*Z:tC\u001e,7+\u001a;\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H\u0005)a\r\\;tQR\u0011\u00111\u0007\u0005\b\u0003\u0017\u0002A\u0011AA$\u0003\u0015\u0019Gn\\:f\u0011\u001d\ty\u0005\u0001C\u0001\u0003#\na\u0001Z3mKR,G#A \t\u000f\u0005U\u0003\u0001\"\u0001\u0002X\u0005QAO];oG\u0006$X\rV8\u0015\t\u0005M\u0012\u0011\f\u0005\b\u00037\n\u0019\u00061\u00012\u0003)!\u0018M]4fiNK'0\u001a\u0015\u0004\u0001\u0005}\u0003cA\b\u0002b%\u0019\u00111\r\t\u0003\u001b9|g\u000e\u001e5sK\u0006$7/\u00194f\u000f%\t9GAA\u0001\u0012\u0003\tI'\u0001\bGS2,W*Z:tC\u001e,7+\u001a;\u0011\u0007\u0019\u000bYG\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AA7'\u0011\tY'a\u001c\u0011\u0007I\n\t(C\u0002\u0002tM\u0012a!\u00118z%\u00164\u0007bB\"\u0002l\u0011\u0005\u0011q\u000f\u000b\u0003\u0003SB!\"a\u001f\u0002lE\u0005I\u0011AA?\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u0010\u0016\u0004c\u0005\u00055FAAB!\u0011\t))a$\u000e\u0005\u0005\u001d%\u0002BAE\u0003\u0017\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u000555'\u0001\u0006b]:|G/\u0019;j_:LA!!%\u0002\b\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005U\u00151NI\u0001\n\u0003\ti(A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005\u000e\u0005\u000b\u00033\u000bY'%A\u0005\u0002\u0005m\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0002\u001e*\u001aq(!!")
public class FileMessageSet
extends MessageSet
implements Logging {
    private final File file;
    private final FileChannel channel;
    private final int start;
    private final int limit;
    private final AtomicInteger _size;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$5() {
        return FileMessageSet$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return FileMessageSet$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return FileMessageSet$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        FileMessageSet fileMessageSet = this;
        synchronized (fileMessageSet) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public File file() {
        return this.file;
    }

    public FileChannel channel() {
        return this.channel;
    }

    public int start() {
        return this.start;
    }

    public int limit() {
        return this.limit;
    }

    private AtomicInteger _size() {
        return this._size;
    }

    public FileMessageSet read(int n, int n2) {
        return new FileMessageSet(this.file(), this.channel(), this.start() + n, package$.MODULE$.min(this.start() + n + n2, this.sizeInBytes()), false);
    }

    public OffsetPosition searchFor(long l, int n) {
        int n2 = n;
        ByteBuffer byteBuffer = ByteBuffer.allocate(MessageSet$.MODULE$.LogOverhead());
        int n3 = this._size().get();
        while (n2 + MessageSet$.MODULE$.LogOverhead() < n3) {
            ((Buffer)byteBuffer).rewind();
            this.channel().read(byteBuffer, n2);
            if (byteBuffer.hasRemaining()) {
                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Failed to read complete buffer for targetOffset %d startPosition %d in %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l), BoxesRunTime.boxToInteger((int)n), this.file().getAbsolutePath()})));
            }
            ((Buffer)byteBuffer).rewind();
            long l2 = byteBuffer.getLong();
            if (l2 >= l) {
                return new OffsetPosition(l2, n2);
            }
            int n4 = byteBuffer.getInt();
            n2 += MessageSet$.MODULE$.LogOverhead() + n4;
        }
        return null;
    }

    @Override
    public int writeTo(GatheringByteChannel gatheringByteChannel, long l, int n) {
        int n2 = package$.MODULE$.min((int)this.channel().size(), this.limit()) - this.start();
        if (n2 < this._size().get()) {
            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Size of FileMessageSet %s has been truncated during write: old size %d, new size %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this._size().get()), BoxesRunTime.boxToInteger((int)n2)})));
        }
        int n3 = (int)this.channel().transferTo((long)this.start() + l, package$.MODULE$.min(n, this.sizeInBytes()), gatheringByteChannel);
        this.trace((Function0<String>)new Serializable(this, n, n3){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileMessageSet $outer;
            private final int size$1;
            private final int bytesTransferred$1;

            public final String apply() {
                return new StringBuilder().append((Object)"FileMessageSet ").append((Object)this.$outer.file().getAbsolutePath()).append((Object)" : bytes transferred : ").append((Object)BoxesRunTime.boxToInteger((int)this.bytesTransferred$1)).append((Object)" bytes requested for transfer : ").append((Object)BoxesRunTime.boxToInteger((int)package$.MODULE$.min(this.size$1, this.$outer.sizeInBytes()))).toString();
            }
            {
                if (fileMessageSet == null) {
                    throw new NullPointerException();
                }
                this.$outer = fileMessageSet;
                this.size$1 = n;
                this.bytesTransferred$1 = n2;
            }
        });
        return n3;
    }

    @Override
    public Iterator<MessageAndOffset> iterator() {
        return new IteratorTemplate<MessageAndOffset>(this){
            private int location;
            private final /* synthetic */ FileMessageSet $outer;

            private int location() {
                return this.location;
            }

            private void location_$eq(int n) {
                this.location = n;
            }

            public MessageAndOffset makeNext() {
                ByteBuffer byteBuffer = ByteBuffer.allocate(12);
                this.$outer.channel().read(byteBuffer, this.location());
                if (byteBuffer.hasRemaining()) {
                    return (MessageAndOffset)this.allDone();
                }
                ((Buffer)byteBuffer).rewind();
                long l = byteBuffer.getLong();
                int n = byteBuffer.getInt();
                if (n < Message$.MODULE$.MinHeaderSize()) {
                    return (MessageAndOffset)this.allDone();
                }
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n);
                this.$outer.channel().read(byteBuffer2, this.location() + 12);
                if (byteBuffer2.hasRemaining()) {
                    return (MessageAndOffset)this.allDone();
                }
                ((Buffer)byteBuffer2).rewind();
                this.location_$eq(this.location() + (n + 12));
                return new MessageAndOffset(new Message(byteBuffer2), l);
            }
            {
                if (fileMessageSet == null) {
                    throw new NullPointerException();
                }
                this.$outer = fileMessageSet;
                this.location = fileMessageSet.start();
            }
        };
    }

    @Override
    public int sizeInBytes() {
        return this._size().get();
    }

    public void append(ByteBufferMessageSet byteBufferMessageSet) {
        int n = byteBufferMessageSet.writeTo(this.channel(), 0L, byteBufferMessageSet.sizeInBytes());
        this._size().getAndAdd(n);
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileMessageSet $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.channel().force(true);
            }
            {
                if (fileMessageSet == null) {
                    throw new NullPointerException();
                }
                this.$outer = fileMessageSet;
            }
        });
    }

    public void close() {
        this.flush();
        this.channel().close();
    }

    public boolean delete() {
        Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileMessageSet $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.channel().close();
            }
            {
                if (fileMessageSet == null) {
                    throw new NullPointerException();
                }
                this.$outer = fileMessageSet;
            }
        });
        return this.file().delete();
    }

    public void truncateTo(int n) {
        if (n > this.sizeInBytes()) {
            throw new KafkaException(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Attempt to truncate log segment to %d bytes failed since the current ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)}))).append((Object)new StringOps(Predef$.MODULE$.augmentString(" size of this log segment is only %d bytes")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.sizeInBytes())}))).toString());
        }
        this.channel().truncate(n);
        this.channel().position(n);
        this._size().set(n);
    }

    public FileMessageSet(File file, FileChannel fileChannel, int n, int n2, boolean bl) {
        Object object;
        this.file = file;
        this.channel = fileChannel;
        this.start = n;
        this.limit = n2;
        Logging$class.$init$(this);
        this._size = new AtomicInteger(package$.MODULE$.min((int)fileChannel.size(), n2) - n);
        if (bl) {
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileMessageSet $outer;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Creating or reloading log segment %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.file().getAbsolutePath()}));
                }
                {
                    if (fileMessageSet == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = fileMessageSet;
                }
            });
            object = fileChannel.position(fileChannel.size());
        } else {
            object = BoxedUnit.UNIT;
        }
    }

    public FileMessageSet(File file, FileChannel fileChannel) {
        this(file, fileChannel, 0, Integer.MAX_VALUE, FileMessageSet$.MODULE$.$lessinit$greater$default$5());
    }

    public FileMessageSet(File file) {
        this(file, Utils$.MODULE$.openChannel(file, true));
    }
}

