/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.util.Hashtable;
import java.util.Properties;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.KafkaStream;
import kafka.message.Message;
import kafka.message.MessageAndMetadata;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;

public final class TestEndToEndLatency$ {
    public static final TestEndToEndLatency$ MODULE$;

    static {
        new TestEndToEndLatency$();
    }

    public void main(String[] args) {
        if (args.length != 3) {
            System.err.println(new StringBuilder().append((Object)"USAGE: java ").append((Object)this.getClass().getName()).append((Object)" broker_list zookeeper_connect num_messages").toString());
            System.exit(1);
        }
        String brokerList = args[0];
        String zkConnect = args[1];
        int numMessages = new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt();
        String topic = "test";
        Properties consumerProps = new Properties();
        ((Hashtable)consumerProps).put("group.id", topic);
        ((Hashtable)consumerProps).put("auto.commit", "true");
        ((Hashtable)consumerProps).put("auto.offset.reset", "largest");
        ((Hashtable)consumerProps).put("zookeeper.connect", zkConnect);
        ((Hashtable)consumerProps).put("socket.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)1201000)).toString());
        ConsumerConfig config = new ConsumerConfig(consumerProps);
        ConsumerConnector connector = Consumer$.MODULE$.create(config);
        KafkaStream stream = (KafkaStream)((IterableLike)Option$.MODULE$.option2Iterable(connector.createMessageStreams((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToInteger((int)1))}))).get((Object)topic)).head()).head();
        ConsumerIterator iter = stream.iterator();
        Properties producerProps = new Properties();
        ((Hashtable)producerProps).put("metadata.broker.list", brokerList);
        ((Hashtable)producerProps).put("producer.type", "sync");
        Producer producer = new Producer(new ProducerConfig(producerProps));
        Message message = new Message("hello there beautiful".getBytes());
        DoubleRef totalTime = new DoubleRef(0.0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(topic, iter, producer, message, totalTime){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final ConsumerIterator iter$1;
            private final Producer producer$1;
            private final Message message$1;
            private final DoubleRef totalTime$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                long begin = System.nanoTime();
                this.producer$1.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(this.topic$1, (Object)this.message$1)}));
                MessageAndMetadata received = this.iter$1.next();
                long elapsed = System.nanoTime() - begin;
                if (i % 10000 == 0) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append(i).append((Object)"\t").append((Object)BoxesRunTime.boxToDouble((double)((double)elapsed / 1000.0 / 1000.0))).toString());
                }
                this.totalTime$1.elem += (double)elapsed;
            }
            {
                this.topic$1 = topic$1;
                this.iter$1 = iter$1;
                this.producer$1 = producer$1;
                this.message$1 = message$1;
                this.totalTime$1 = totalTime$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Avg latency: ").append((Object)BoxesRunTime.boxToDouble((double)(totalTime.elem / (double)numMessages / 1000.0 / 1000.0))).append((Object)"ms").toString());
        producer.close();
        connector.shutdown();
        System.exit(0);
    }

    private TestEndToEndLatency$() {
        MODULE$ = this;
    }
}

