/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import junit.framework.Assert;
import kafka.common.LogCleaningAbortedException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner;
import kafka.log.FakeOffsetMap;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import kafka.utils.Throttler$;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.junit.After;
import org.junit.Test;
import org.scalatest.Assertions;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.PendingNothing;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.TestRerunner;
import org.scalatest.Tracker;
import org.scalatest.junit.AssertionsForJUnit;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001B\u0001\u0003\u0001\u001d\u00111b\u00117fC:,'\u000fV3ti*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\t\u0011\u0005%qQ\"\u0001\u0006\u000b\u0005-a\u0011\u0001\u00027b]\u001eT\u0011!D\u0001\u0005U\u00064\u0018-\u0003\u0002\u0010\u0015\t1qJ\u00196fGR\u0004\"!\u0005\r\u000e\u0003IQ!a\u0005\u000b\u0002\u000b),h.\u001b;\u000b\u0005U1\u0012!C:dC2\fG/Z:u\u0015\u00059\u0012aA8sO&\u0011\u0011D\u0005\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005\u0002\u0005\n1\u0001Z5s+\u0005\u0011\u0003CA\u0012'\u001b\u0005!#BA\u0013\r\u0003\tIw.\u0003\u0002(I\t!a)\u001b7f\u0011\u0019I\u0003\u0001)A\u0005E\u0005!A-\u001b:!\u0011\u001dY\u0003A1A\u0005\u00021\n\u0011\u0002\\8h\u0007>tg-[4\u0016\u00035\u0002\"A\b\u0018\n\u0005=\u0012!!\u0003'pO\u000e{gNZ5h\u0011\u0019\t\u0004\u0001)A\u0005[\u0005QAn\\4D_:4\u0017n\u001a\u0011\t\u000fM\u0002!\u0019!C\u0001i\u0005!A/[7f+\u0005)\u0004C\u0001\u001c:\u001b\u00059$B\u0001\u001d\u0005\u0003\u0015)H/\u001b7t\u0013\tQtG\u0001\u0005N_\u000e\\G+[7f\u0011\u0019a\u0004\u0001)A\u0005k\u0005)A/[7fA!9a\b\u0001b\u0001\n\u0003y\u0014!\u0003;ie>$H\u000f\\3s+\u0005\u0001\u0005C\u0001\u001cB\u0013\t\u0011uGA\u0005UQJ|G\u000f\u001e7fe\"1A\t\u0001Q\u0001\n\u0001\u000b!\u0002\u001e5s_R$H.\u001a:!\u0011\u00151\u0005\u0001\"\u0001H\u0003!!X-\u0019:e_^tG#\u0001%\u0011\u0005%cU\"\u0001&\u000b\u0003-\u000bQa]2bY\u0006L!!\u0014&\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u000b>\u0003\"\u0001\u0015*\u000e\u0003ES!a\u0005\f\n\u0005M\u000b&!B!gi\u0016\u0014\b\"B+\u0001\t\u00039\u0015!\u0005;fgR\u001cE.Z1o'\u0016<W.\u001a8ug\"\u0012Ak\u0016\t\u0003!bK!!W)\u0003\tQ+7\u000f\u001e\u0005\u00067\u0002!\taR\u0001\u0018i\u0016\u001cHo\u00117fC:LgnZ,ji\"$U\r\\3uKND#AW,\t\u000by\u0003A\u0011A0\u0002\u0013-,\u0017p]%o\u0019><GC\u00011j!\r\tGMZ\u0007\u0002E*\u00111MS\u0001\u000bG>dG.Z2uS>t\u0017BA3c\u0005!IE/\u001a:bE2,\u0007CA%h\u0013\tA'JA\u0002J]RDQaA/A\u0002)\u0004\"AH6\n\u00051\u0014!a\u0001'pO\")a\u000e\u0001C\u0001_\u0006q\u0011MY8si\u000eCWmY6E_:,GC\u0001%q\u0011\u0015\tX\u000e1\u0001s\u0003E!x\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\t\u0003gZl\u0011\u0001\u001e\u0006\u0003k\u0012\taaY8n[>t\u0017BA<u\u0005E!v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\u0006s\u0002!\taR\u0001\u001bi\u0016\u001cHo\u00117fC:\u001cVmZ7f]R\u001cx+\u001b;i\u0003\n|'\u000f\u001e\u0015\u0003q^CQ\u0001 \u0001\u0005\u0002\u001d\u000b1\u0003^3tiN+w-\\3oi\u001e\u0013x.\u001e9j]\u001eD#a_,\t\r}\u0004A\u0011BA\u0001\u0003E\u0019\u0007.Z2l'\u0016<W.\u001a8u\u001fJ$WM\u001d\u000b\u0004\u0011\u0006\r\u0001bBA\u0003}\u0002\u0007\u0011qA\u0001\u0007OJ|W\u000f]:\u0011\u000b\u0005\fI!!\u0004\n\u0007\u0005-!MA\u0002TKF\u0004R!YA\u0005\u0003\u001f\u00012AHA\t\u0013\r\t\u0019B\u0001\u0002\u000b\u0019><7+Z4nK:$\bBBA\f\u0001\u0011\u0005q)\u0001\nuKN$()^5mI>3gm]3u\u001b\u0006\u0004\bfAA\u000b/\"9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0011aB7bW\u0016dun\u001a\u000b\u0006U\u0006\u0005\u00121\u0005\u0005\tA\u0005m\u0001\u0013!a\u0001E!I\u0011QEA\u000e!\u0003\u0005\r!L\u0001\u0007G>tg-[4\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,\u0005ian\\(q\u0007\",7m\u001b#p]\u0016$2\u0001SA\u0017\u0011\u0019\t\u0018q\u0005a\u0001e\"9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0012aC7bW\u0016\u001cE.Z1oKJ$b!!\u000e\u0002<\u0005}\u0002c\u0001\u0010\u00028%\u0019\u0011\u0011\b\u0002\u0003\u000f\rcW-\u00198fe\"9\u0011QHA\u0018\u0001\u00041\u0017\u0001C2ba\u0006\u001c\u0017\u000e^=\t\u0015\u0005\u0005\u0013q\u0006I\u0001\u0002\u0004\t\u0019%A\u0005dQ\u0016\u001c7\u000eR8oKB)\u0011*!\u0012s\u0011&\u0019\u0011q\t&\u0003\u0013\u0019+hn\u0019;j_:\f\u0004bBA&\u0001\u0011\u0005\u0011QJ\u0001\u000boJLG/\u001a+p\u0019><GCBA(\u0003/\nI\u0006\u0005\u0003bI\u0006E\u0003cA%\u0002T%\u0019\u0011Q\u000b&\u0003\t1{gn\u001a\u0005\u0007\u0007\u0005%\u0003\u0019\u00016\t\u0011\u0005m\u0013\u0011\na\u0001\u0003;\n1a]3r!\u0011\tG-a\u0018\u0011\u000b%\u000b\tG\u001a4\n\u0007\u0005\r$J\u0001\u0004UkBdWM\r\u0005\b\u0003O\u0002A\u0011AA5\u0003\rYW-\u001f\u000b\u0005\u0003W\n9\b\u0005\u0003\u0002n\u0005MTBAA8\u0015\r\t\t\bD\u0001\u0004]&|\u0017\u0002BA;\u0003_\u0012!BQ=uK\n+hMZ3s\u0011\u001d\tI(!\u001aA\u0002\u0019\f!!\u001b3\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000\u00059Q.Z:tC\u001e,GCBAA\u0003\u0017\u000bi\t\u0005\u0003\u0002\u0004\u0006\u001dUBAAC\u0015\r\ti\bB\u0005\u0005\u0003\u0013\u000b)I\u0001\u000bCsR,')\u001e4gKJlUm]:bO\u0016\u001cV\r\u001e\u0005\b\u0003O\nY\b1\u0001g\u0011\u001d\ty)a\u001fA\u0002\u0019\fQA^1mk\u0016Dq!a%\u0001\t\u0003\t)*A\u0007eK2,G/Z'fgN\fw-\u001a\u000b\u0005\u0003\u0003\u000b9\nC\u0004\u0002h\u0005E\u0005\u0019\u00014\t\u0013\u0005m\u0005!%A\u0005\u0002\u0005u\u0015!F7bW\u0016\u001cE.Z1oKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003?SC!a\u0011\u0002\".\u0012\u00111\u0015\t\u0005\u0003K\u000by+\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003%)hn\u00195fG.,GMC\u0002\u0002.*\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\t,a*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u00026\u0002\t\n\u0011\"\u0001\u00028\u0006\tR.Y6f\u0019><G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005e&f\u0001\u0012\u0002\"\"I\u0011Q\u0018\u0001\u0012\u0002\u0013\u0005\u0011qX\u0001\u0012[\u0006\\W\rT8hI\u0011,g-Y;mi\u0012\u0012TCAAaU\ri\u0013\u0011\u0015")
public class CleanerTest
implements JUnitSuite {
    private final File dir;
    private final LogConfig logConfig;
    private final MockTime time;
    private final Throttler throttler;
    private volatile Tracker org$scalatest$junit$JUnitSuite$$theTracker;
    private final String styleName;

    public Tracker org$scalatest$junit$JUnitSuite$$theTracker() {
        return this.org$scalatest$junit$JUnitSuite$$theTracker;
    }

    public void org$scalatest$junit$JUnitSuite$$theTracker_$eq(Tracker x$1) {
        this.org$scalatest$junit$JUnitSuite$$theTracker = x$1;
    }

    public final String styleName() {
        return this.styleName;
    }

    public final void org$scalatest$junit$JUnitSuite$_setter_$styleName_$eq(String x$1) {
        this.styleName = x$1;
    }

    public final void withFixture(Suite.NoArgTest test) {
        JUnitSuite.class.withFixture((JUnitSuite)this, (Suite.NoArgTest)test);
    }

    public final void runNestedSuites(Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runNestedSuites((JUnitSuite)this, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTests(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runTests((JUnitSuite)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        JUnitSuite.class.runTest((JUnitSuite)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    public Set<String> testNames() {
        return JUnitSuite.class.testNames((JUnitSuite)this);
    }

    public int expectedTestCount(Filter filter) {
        return JUnitSuite.class.expectedTestCount((JUnitSuite)this, (Filter)filter);
    }

    public Map<String, Set<String>> tags() {
        return JUnitSuite.class.tags((JUnitSuite)this);
    }

    public void run(Option<String> testName, Reporter report, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.run((JUnitSuite)this, testName, (Reporter)report, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public Throwable newAssertionFailedException(Option<Object> optionalMessage, Option<Throwable> optionalCause, int stackDepth) {
        return AssertionsForJUnit.class.newAssertionFailedException((AssertionsForJUnit)this, optionalMessage, optionalCause, (int)stackDepth);
    }

    public void org$scalatest$Suite$_setter_$styleName_$eq(String x$1) {
    }

    public List<Suite> nestedSuites() {
        return Suite.class.nestedSuites((Suite)this);
    }

    public final void execute(String testName, Map<String, Object> configMap, boolean color, boolean durations, boolean shortstacks, boolean fullstacks, boolean stats) {
        Suite.class.execute((Suite)this, (String)testName, configMap, (boolean)color, (boolean)durations, (boolean)shortstacks, (boolean)fullstacks, (boolean)stats);
    }

    public Method getMethodForTestName(String testName) {
        return Suite.class.getMethodForTestName((Suite)this, (String)testName);
    }

    public Tuple6<Stopper, Reporter, Method, Object, Option<TestRerunner>, Object> getSuiteRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getSuiteRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public Tuple5<Stopper, Reporter, Object, Option<TestRerunner>, Object> getRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public void handleFailedTest(Throwable throwable, boolean hasPublicNoArgConstructor, String testName, Option<Rerunner> rerunnable, Reporter report, Tracker tracker, long duration) {
        Suite.class.handleFailedTest((Suite)this, (Throwable)throwable, (boolean)hasPublicNoArgConstructor, (String)testName, rerunnable, (Reporter)report, (Tracker)tracker, (long)duration);
    }

    public String suiteName() {
        return Suite.class.suiteName((Suite)this);
    }

    public PendingNothing pending() {
        return Suite.class.pending((Suite)this);
    }

    public void pendingUntilFixed(Function0<BoxedUnit> f) {
        Suite.class.pendingUntilFixed((Suite)this, f);
    }

    public Reporter wrapReporterIfNecessary(Reporter reporter) {
        return Suite.class.wrapReporterIfNecessary((Suite)this, (Reporter)reporter);
    }

    public final String execute$default$1() {
        return Suite.class.execute$default$1((Suite)this);
    }

    public final Map<String, Object> execute$default$2() {
        return Suite.class.execute$default$2((Suite)this);
    }

    public final boolean execute$default$3() {
        return Suite.class.execute$default$3((Suite)this);
    }

    public final boolean execute$default$4() {
        return Suite.class.execute$default$4((Suite)this);
    }

    public final boolean execute$default$5() {
        return Suite.class.execute$default$5((Suite)this);
    }

    public final boolean execute$default$6() {
        return Suite.class.execute$default$6((Suite)this);
    }

    public final boolean execute$default$7() {
        return Suite.class.execute$default$7((Suite)this);
    }

    public void assert(boolean condition) {
        Assertions.class.assert((Assertions)this, (boolean)condition);
    }

    public void assert(boolean condition, Object clue) {
        Assertions.class.assert((Assertions)this, (boolean)condition, (Object)clue);
    }

    public void assert(Option<String> o, Object clue) {
        Assertions.class.assert((Assertions)this, o, (Object)clue);
    }

    public void assert(Option<String> o) {
        Assertions.class.assert((Assertions)this, o);
    }

    public Assertions.Equalizer convertToEqualizer(Object left) {
        return Assertions.class.convertToEqualizer((Assertions)this, (Object)left);
    }

    public <T> T intercept(Function0<Object> f, Manifest<T> manifest) {
        return (T)Assertions.class.intercept((Assertions)this, f, manifest);
    }

    public void expectResult(Object expected, Object clue, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expect(Object expected, Object clue, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expectResult(Object expected, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)actual);
    }

    public void expect(Object expected, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)actual);
    }

    public Nothing$ fail() {
        return Assertions.class.fail((Assertions)this);
    }

    public Nothing$ fail(String message) {
        return Assertions.class.fail((Assertions)this, (String)message);
    }

    public Nothing$ fail(String message, Throwable cause) {
        return Assertions.class.fail((Assertions)this, (String)message, (Throwable)cause);
    }

    public Nothing$ fail(Throwable cause) {
        return Assertions.class.fail((Assertions)this, (Throwable)cause);
    }

    public <T> T withClue(Object clue, Function0<T> fun) {
        return (T)Assertions.class.withClue((Assertions)this, (Object)clue, fun);
    }

    public File dir() {
        return this.dir;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    @After
    public void teardown() {
        Utils$.MODULE$.rm(this.dir());
    }

    @Test
    public void testCleanSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        LogConfig x$32 = this.logConfig().copy(1024, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13());
        File x$33 = this.makeLog$default$1();
        Log log = this.makeLog(x$33, x$32);
        while (log.numberOfSegments() < 4) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        Iterable<Object> keysFound = this.keysInLog(log);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap map$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$1.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.map$1 = map$1;
            }
        });
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(3)).toSeq(), (OffsetMap)map, 0L);
        Iterable shouldRemain = (Iterable)this.keysInLog(log).filter((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final ListSet keys$1;

            public final boolean apply(int x$1) {
                return this.apply$mcZI$sp(x$1);
            }

            public boolean apply$mcZI$sp(int x$1) {
                return !this.keys$1.contains((Object)BoxesRunTime.boxToInteger((int)x$1));
            }
            {
                this.keys$1 = keys$1;
            }
        });
        Assert.assertEquals((Object)shouldRemain, this.keysInLog(log));
    }

    @Test
    public void testCleaningWithDeletes() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        LogConfig x$36 = this.logConfig().copy(1024, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13());
        File x$37 = this.makeLog$default$1();
        Log log = this.makeLog(x$37, x$36);
        while (log.numberOfSegments() < 2) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        long leo = log.logEndOffset();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final Log log$1;

            public final Log.LogAppendInfo apply(int key) {
                return this.log$1.append(this.$outer.deleteMessage(key), this.log$1.append$default$2());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.log$1 = log$1;
            }
        });
        while (log.numberOfSegments() < 4) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        cleaner.clean(new LogToClean(new TopicAndPartition("test", 0), log, 0L));
        Set keys = this.keysInLog(log).toSet();
        Assert.assertTrue((String)"None of the keys we deleted should still exist.", (boolean)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).forall((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final Set keys$2;

            public final boolean apply(int x$2) {
                return this.apply$mcZI$sp(x$2);
            }

            public boolean apply$mcZI$sp(int x$2) {
                return !this.keys$2.contains((Object)BoxesRunTime.boxToInteger((int)x$2));
            }
            {
                this.keys$2 = keys$2;
            }
        }));
    }

    public Iterable<Object> keysInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(LogSegment s) {
                return (Iterable)((TraversableLike)s.log().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MessageAndOffset x$3) {
                        return !x$3.message().isNull();
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(MessageAndOffset m) {
                        return new StringOps(Predef$.MODULE$.augmentString(Utils$.MODULE$.readString(m.message().key(), Utils$.MODULE$.readString$default$2()))).toInt();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public void abortCheckDone(TopicAndPartition topicAndPartition) {
        throw new LogCleaningAbortedException();
    }

    @Test
    public void testCleanSegmentsWithAbort() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, (Function1<TopicAndPartition, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;

            public final void apply(TopicAndPartition topicAndPartition) {
                this.$outer.abortCheckDone(topicAndPartition);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        LogConfig x$40 = this.logConfig().copy(1024, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13());
        File x$41 = this.makeLog$default$1();
        Log log = this.makeLog(x$41, x$40);
        while (log.numberOfSegments() < 4) {
            log.append(this.message((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        Iterable<Object> keys = this.keysInLog(log);
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap map$2;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$2.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.map$2 = map$2;
            }
        });
        this.intercept((Function0)new Serializable(this, cleaner, log, map){
            public static final long serialVersionUID = 0L;
            private final Cleaner cleaner$1;
            private final Log log$2;
            private final FakeOffsetMap map$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleaner$1.cleanSegments(this.log$2, ((TraversableOnce)this.log$2.logSegments().take(3)).toSeq(), (OffsetMap)this.map$2, 0L);
            }
            {
                this.cleaner$1 = cleaner$1;
                this.log$2 = log$2;
                this.map$2 = map$2;
            }
        }, ManifestFactory$.MODULE$.classType(LogCleaningAbortedException.class));
    }

    @Test
    public void testSegmentGrouping() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        int x$42 = 300;
        int x$43 = 1;
        long x$44 = this.logConfig().copy$default$2();
        long x$45 = this.logConfig().copy$default$3();
        long x$46 = this.logConfig().copy$default$4();
        long x$47 = this.logConfig().copy$default$5();
        long x$48 = this.logConfig().copy$default$6();
        int x$49 = this.logConfig().copy$default$7();
        int x$50 = this.logConfig().copy$default$8();
        long x$51 = this.logConfig().copy$default$10();
        long x$52 = this.logConfig().copy$default$11();
        double x$53 = this.logConfig().copy$default$12();
        boolean x$54 = this.logConfig().copy$default$13();
        LogConfig x$55 = this.logConfig().copy(x$42, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$43, x$51, x$52, x$53, x$54);
        File x$56 = this.makeLog$default$1();
        Log log = this.makeLog(x$56, x$55);
        int i = 0;
        while (log.numberOfSegments() < 10) {
            log.append(TestUtils$.MODULE$.singleMessageSet("hello".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3()), log.append$default$2());
            ++i;
        }
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertEquals((int)1, (int)groups.size());
        Assert.assertEquals((int)log.numberOfSegments(), (int)((SeqLike)groups.apply(0)).size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), 1, Integer.MAX_VALUE);
        Assert.assertEquals((int)log.numberOfSegments(), (int)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$4) {
                return x$4.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, 1);
        Assert.assertEquals((int)log.numberOfSegments(), (int)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$5) {
                return x$5.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        int groupSize = 3;
        int logSize = (int)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$6) {
                return x$6.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), logSize, Integer.MAX_VALUE);
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$7) {
                return x$7.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
        int indexSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$8) {
                return x$8.index().sizeInBytes();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, indexSize);
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$9) {
                return x$9.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
    }

    private void checkSegmentOrder(Seq<Seq<LogSegment>> groups) {
        Seq offsets = (Seq)groups.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Seq<LogSegment> x$10) {
                return (Seq)x$10.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(LogSegment x$11) {
                        return x$11.baseOffset();
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((String)"Offsets should be in increasing order.", (Object)offsets.sorted((Ordering)Ordering.Long$.MODULE$), (Object)offsets);
    }

    @Test
    public void testBuildOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Log log = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2());
        int start = 0;
        int end = 500;
        Iterable<Object> offsets = this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end), IndexedSeq$.MODULE$.canBuildFrom())));
        Seq segments = log.logSegments().toSeq();
        this.checkRange$1(map, 0, (int)((LogSegment)segments.apply(1)).baseOffset(), log, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(1)).baseOffset(), (int)((LogSegment)segments.apply(3)).baseOffset(), log, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(3)).baseOffset(), (int)log.logEndOffset(), log, cleaner);
    }

    public Log makeLog(File dir, LogConfig config) {
        return new Log(dir, config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
    }

    public File makeLog$default$1() {
        return this.dir();
    }

    public LogConfig makeLog$default$2() {
        return this.logConfig();
    }

    public void noOpCheckDone(TopicAndPartition topicAndPartition) {
    }

    public Cleaner makeCleaner(int capacity, Function1<TopicAndPartition, BoxedUnit> checkDone) {
        return new Cleaner(0, (OffsetMap)new FakeOffsetMap(capacity), 65536, 65536, 0.75, this.throttler(), (Time)this.time(), checkDone);
    }

    public Function1<TopicAndPartition, BoxedUnit> makeCleaner$default$2() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;

            public final void apply(TopicAndPartition topicAndPartition) {
                this.$outer.noOpCheckDone(topicAndPartition);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
    }

    public Iterable<Object> writeToLog(Log log, Iterable<Tuple2<Object, Object>> seq) {
        return (Iterable)seq.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final Log log$4;

            public final long apply(Tuple2<Object, Object> x$12) {
                Tuple2<Object, Object> tuple2 = x$12;
                if (tuple2 != null) {
                    int key = tuple2._1$mcI$sp();
                    int value = tuple2._2$mcI$sp();
                    long l = this.log$4.append(this.$outer.message(key, value), this.log$4.append$default$2()).firstOffset();
                    return l;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.log$4 = log$4;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public ByteBuffer key(int id) {
        return ByteBuffer.wrap(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
    }

    public ByteBufferMessageSet message(int key, int value) {
        Message[] messageArray = new Message[1];
        byte[] x$34 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte[] x$35 = ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes();
        messageArray[0] = new Message(x$35, x$34);
        return new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])messageArray));
    }

    public ByteBufferMessageSet deleteMessage(int key) {
        Message[] messageArray = new Message[1];
        byte[] x$38 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        Object x$39 = null;
        messageArray[0] = new Message(null, x$38);
        return new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])messageArray));
    }

    private final void checkRange$1(FakeOffsetMap map, int start, int end, Log log$3, Cleaner cleaner$2) {
        long endOffset = cleaner$2.buildOffsetMap(log$3, (long)start, (long)end, (OffsetMap)map) + 1L;
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)end, (long)endOffset);
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (int)(end - start), (int)map.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).foreach$mVc$sp((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CleanerTest $outer;
            private final FakeOffsetMap map$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((String)"Should find all the keys", (long)i, (long)this.map$3.get(this.$outer.key(i)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.map$3 = map$3;
            }
        });
        Assert.assertEquals((String)"Should not find a value too small", (long)-1L, (long)map.get(this.key(start - 1)));
        Assert.assertEquals((String)"Should not find a value too large", (long)-1L, (long)map.get(this.key(end)));
    }

    public CleanerTest() {
        Assertions.class.$init$((Assertions)this);
        Suite.class.$init$((Suite)this);
        AssertionsForJUnit.class.$init$((AssertionsForJUnit)this);
        JUnitSuite.class.$init$((JUnitSuite)this);
        this.dir = TestUtils$.MODULE$.tempDir();
        int x$13 = 1024;
        int x$14 = 1024;
        boolean x$15 = true;
        long x$16 = LogConfig$.MODULE$.apply$default$2();
        long x$17 = LogConfig$.MODULE$.apply$default$3();
        long x$18 = LogConfig$.MODULE$.apply$default$4();
        long x$19 = LogConfig$.MODULE$.apply$default$5();
        long x$20 = LogConfig$.MODULE$.apply$default$6();
        int x$21 = LogConfig$.MODULE$.apply$default$7();
        int x$22 = LogConfig$.MODULE$.apply$default$9();
        long x$23 = LogConfig$.MODULE$.apply$default$10();
        long x$24 = LogConfig$.MODULE$.apply$default$11();
        double x$25 = LogConfig$.MODULE$.apply$default$12();
        this.logConfig = new LogConfig(x$13, x$16, x$17, x$18, x$19, x$20, x$21, x$14, x$22, x$23, x$24, x$25, x$15);
        this.time = new MockTime();
        double x$26 = Double.MAX_VALUE;
        long x$27 = Long.MAX_VALUE;
        MockTime x$28 = this.time();
        boolean x$29 = Throttler$.MODULE$.$lessinit$greater$default$3();
        String x$30 = Throttler$.MODULE$.$lessinit$greater$default$4();
        String x$31 = Throttler$.MODULE$.$lessinit$greater$default$5();
        this.throttler = new Throttler(x$26, x$27, x$29, x$30, x$31, (Time)x$28);
    }
}

