/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import org.I0Itec.zkclient.ZkClient;
import org.easymock.EasyMock;
import org.junit.Test;
import org.scalatest.junit.JUnit3Suite;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001)3A!\u0001\u0002\u0001\u000f\t\u0011\"+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014H+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!a\u0003&V]&$8gU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001!\u0019!C\u00013\u0005)Ao\u001c9jGV\t!\u0004\u0005\u0002\u001cA5\tAD\u0003\u0002\u001e=\u0005!A.\u00198h\u0015\u0005y\u0012\u0001\u00026bm\u0006L!!\t\u000f\u0003\rM#(/\u001b8h\u0011\u0019\u0019\u0003\u0001)A\u00055\u00051Ao\u001c9jG\u0002BQ!\n\u0001\u0005\u0002\u0019\n\u0011\u0005^3ti\"Kw\r[,bi\u0016\u0014X*\u0019:l\t&\u0014Xm\u0019;pefl\u0015\r\u001d9j]\u001e$\u0012a\n\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\u0005+:LG\u000f\u000b\u0002%]A\u0011q&M\u0007\u0002a)\u00111BD\u0005\u0003eA\u0012A\u0001V3ti\")A\u0007\u0001C\u0001M\u0005IC/Z:u\u0011&<\u0007n^1uKJl\u0015M]6SK2\fG/\u001b<f\t&\u0014Xm\u0019;pefl\u0015\r\u001d9j]\u001eD#a\r\u0018\t\u000b]\u0002A\u0011\u0002\u001d\u0002!\r\u0014X-\u0019;f\u0019><W*\u00198bO\u0016\u0014HCA\u001d@!\tQT(D\u0001<\u0015\taD!A\u0002m_\u001eL!AP\u001e\u0003\u00151{w-T1oC\u001e,'\u000fC\u0003Am\u0001\u0007\u0011)A\u0004m_\u001e$\u0015N]:\u0011\u0007!\u0012E)\u0003\u0002DS\t)\u0011I\u001d:bsB\u0011Q\tS\u0007\u0002\r*\u0011qIH\u0001\u0003S>L!!\u0013$\u0003\t\u0019KG.\u001a")
public class ReplicaManagerTest
extends JUnit3Suite {
    private final String topic;

    public String topic() {
        return this.topic;
    }

    @Test
    public void testHighWaterMarkDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.createBrokerConfig$default$2());
        KafkaConfig config = new KafkaConfig(props);
        ZkClient zkClient = (ZkClient)EasyMock.createMock(ZkClient.class);
        LogManager mockLogMgr = this.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$1) {
                return new File(x$1);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)));
        MockTime time = new MockTime();
        ReplicaManager rm = new ReplicaManager(config, (Time)time, zkClient, (Scheduler)new MockScheduler(time), mockLogMgr, new AtomicBoolean(false));
        Partition partition = rm.getOrCreatePartition(this.topic(), 1, 1);
        partition.getOrCreateReplica(1);
        rm.checkpointHighWatermarks();
    }

    @Test
    public void testHighwaterMarkRelativeDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.createBrokerConfig$default$2());
        ((Hashtable)props).put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = new KafkaConfig(props);
        ZkClient zkClient = (ZkClient)EasyMock.createMock(ZkClient.class);
        LogManager mockLogMgr = this.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$2) {
                return new File(x$2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)));
        MockTime time = new MockTime();
        ReplicaManager rm = new ReplicaManager(config, (Time)time, zkClient, (Scheduler)new MockScheduler(time), mockLogMgr, new AtomicBoolean(false));
        Partition partition = rm.getOrCreatePartition(this.topic(), 1, 1);
        partition.getOrCreateReplica(1);
        rm.checkpointHighWatermarks();
    }

    private LogManager createLogManager(File[] logDirs) {
        MockTime time = new MockTime();
        boolean x$3 = false;
        int x$4 = CleanerConfig$.MODULE$.apply$default$1();
        long x$5 = CleanerConfig$.MODULE$.apply$default$2();
        double x$6 = CleanerConfig$.MODULE$.apply$default$3();
        int x$7 = CleanerConfig$.MODULE$.apply$default$4();
        int x$8 = CleanerConfig$.MODULE$.apply$default$5();
        double x$9 = CleanerConfig$.MODULE$.apply$default$6();
        long x$10 = CleanerConfig$.MODULE$.apply$default$7();
        String x$11 = CleanerConfig$.MODULE$.apply$default$9();
        return new LogManager(logDirs, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), new LogConfig(LogConfig$.MODULE$.$lessinit$greater$default$1(), LogConfig$.MODULE$.$lessinit$greater$default$2(), LogConfig$.MODULE$.$lessinit$greater$default$3(), LogConfig$.MODULE$.$lessinit$greater$default$4(), LogConfig$.MODULE$.$lessinit$greater$default$5(), LogConfig$.MODULE$.$lessinit$greater$default$6(), LogConfig$.MODULE$.$lessinit$greater$default$7(), LogConfig$.MODULE$.$lessinit$greater$default$8(), LogConfig$.MODULE$.$lessinit$greater$default$9(), LogConfig$.MODULE$.$lessinit$greater$default$10(), LogConfig$.MODULE$.$lessinit$greater$default$11(), LogConfig$.MODULE$.$lessinit$greater$default$12(), LogConfig$.MODULE$.$lessinit$greater$default$13()), new CleanerConfig(x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$3, x$11), 1000L, 100000L, 1000L, (Scheduler)time.scheduler(), (Time)time);
    }

    public ReplicaManagerTest() {
        this.topic = "test-topic";
    }
}

