/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import junit.framework.Assert;
import kafka.api.ProducerRequest;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.server.DelayedRequest;
import kafka.server.RequestPurgatory;
import kafka.server.RequestPurgatory$;
import kafka.utils.TestUtils$;
import org.junit.Test;
import org.scalatest.junit.JUnit3Suite;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y4A!\u0001\u0002\u0001\u000f\t!\"+Z9vKN$\b+\u001e:hCR|'/\u001f+fgRT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\f\u0015Vs\u0017\u000e^\u001aTk&$X\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0005!9\u0001\u0004\u0001b\u0001\n\u0003I\u0012\u0001\u00059s_\u0012,8-\u001a:SKF,Xm\u001d;2+\u0005Q\u0002CA\u000e\u001f\u001b\u0005a\"BA\u000f\u0005\u0003\r\t\u0007/[\u0005\u0003?q\u0011q\u0002\u0015:pIV\u001cWM\u001d*fcV,7\u000f\u001e\u0005\u0007C\u0001\u0001\u000b\u0011\u0002\u000e\u0002#A\u0014x\u000eZ;dKJ\u0014V-];fgR\f\u0004\u0005C\u0004$\u0001\t\u0007I\u0011A\r\u0002!A\u0014x\u000eZ;dKJ\u0014V-];fgR\u0014\u0004BB\u0013\u0001A\u0003%!$A\tqe>$WoY3s%\u0016\fX/Z:ue\u0001Bqa\n\u0001A\u0002\u0013\u0005\u0001&A\u0005qkJ<\u0017\r^8ssV\t\u0011\u0006\u0005\u0002+W5\t\u0001A\u0002\u0003-\u0001\u0001i#\u0001F'pG.\u0014V-];fgR\u0004VO]4bi>\u0014\u0018p\u0005\u0002,]A!acL\u0019\u001b\u0013\t\u0001$A\u0001\tSKF,Xm\u001d;QkJ<\u0017\r^8ssB\u0011aCM\u0005\u0003g\t\u0011a\u0002R3mCf,GMU3rk\u0016\u001cH\u000fC\u0003\u0014W\u0011\u0005Q\u0007F\u0001*\u0011\u001d94F1A\u0005\u0002a\n\u0011b]1uSN4\u0017.\u001a3\u0016\u0003e\u00022AO!2\u001b\u0005Y$B\u0001\u001f>\u0003\u001diW\u000f^1cY\u0016T!AP \u0002\u0015\r|G\u000e\\3di&|gNC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u00115HA\u0002TKRDa\u0001R\u0016!\u0002\u0013I\u0014AC:bi&\u001ch-[3eA!9ai\u000bb\u0001\n\u0003A\u0014aB3ya&\u0014X\r\u001a\u0005\u0007\u0011.\u0002\u000b\u0011B\u001d\u0002\u0011\u0015D\b/\u001b:fI\u0002BQAS\u0016\u0005\u0002-\u000bq\"Y<bSR,\u0005\u0010]5sCRLwN\u001c\u000b\u0003\u0019B\u0003\"!\u0014(\u000e\u0003}J!aT \u0003\tUs\u0017\u000e\u001e\u0005\u0006#&\u0003\r!M\u0001\bI\u0016d\u0017-_3e\u0011\u0015\u00196\u0006\"\u0001U\u00039\u0019\u0007.Z2l'\u0006$\u0018n\u001d4jK\u0012$2!\u0016-[!\tie+\u0003\u0002X\u007f\t9!i\\8mK\u0006t\u0007\"B-S\u0001\u0004Q\u0012a\u0002:fcV,7\u000f\u001e\u0005\u0006#J\u0003\r!\r\u0005\u00069.\"\t!X\u0001\u0007Kb\u0004\u0018N]3\u0015\u00051s\u0006\"B)\\\u0001\u0004\t\u0004b\u00021\u0001\u0001\u0004%\t!Y\u0001\u000eaV\u0014x-\u0019;pef|F%Z9\u0015\u00051\u0013\u0007bB2`\u0003\u0003\u0005\r!K\u0001\u0004q\u0012\n\u0004BB3\u0001A\u0003&\u0011&\u0001\u0006qkJ<\u0017\r^8ss\u0002BQa\u001a\u0001\u0005B!\fQa]3u+B$\u0012\u0001\u0014\u0005\u0006U\u0002!\t\u0005[\u0001\ti\u0016\f'\u000fR8x]\")A\u000e\u0001C\u0001Q\u00069B/Z:u%\u0016\fX/Z:u'\u0006$\u0018n\u001d4bGRLwN\u001c\u0015\u0003W:\u0004\"a\\9\u000e\u0003AT!a\u0003\b\n\u0005I\u0004(\u0001\u0002+fgRDQ\u0001\u001e\u0001\u0005\u0002!\f\u0011\u0003^3tiJ+\u0017/^3ti\u0016C\b/\u001b:zQ\t\u0019h\u000e")
public class RequestPurgatoryTest
extends JUnit3Suite {
    private final ProducerRequest producerRequest1 = TestUtils$.MODULE$.produceRequest("test", 0, new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello1".getBytes())})), TestUtils$.MODULE$.produceRequest$default$4(), TestUtils$.MODULE$.produceRequest$default$5(), TestUtils$.MODULE$.produceRequest$default$6(), TestUtils$.MODULE$.produceRequest$default$7());
    private final ProducerRequest producerRequest2 = TestUtils$.MODULE$.produceRequest("test", 0, new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello2".getBytes())})), TestUtils$.MODULE$.produceRequest$default$4(), TestUtils$.MODULE$.produceRequest$default$5(), TestUtils$.MODULE$.produceRequest$default$6(), TestUtils$.MODULE$.produceRequest$default$7());
    private MockRequestPurgatory purgatory = null;

    public ProducerRequest producerRequest1() {
        return this.producerRequest1;
    }

    public ProducerRequest producerRequest2() {
        return this.producerRequest2;
    }

    public MockRequestPurgatory purgatory() {
        return this.purgatory;
    }

    public void purgatory_$eq(MockRequestPurgatory x$1) {
        this.purgatory = x$1;
    }

    public void setUp() {
        super.setUp();
        this.purgatory_$eq(new MockRequestPurgatory());
    }

    public void tearDown() {
        this.purgatory().shutdown();
        super.tearDown();
    }

    @Test
    public void testRequestSatisfaction() {
        DelayedRequest r1 = new DelayedRequest((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"}), null, 100000L);
        DelayedRequest r2 = new DelayedRequest((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"}), null, 100000L);
        Assert.assertEquals((String)"With no waiting requests, nothing should be satisfied", (int)0, (int)this.purgatory().update("test1", this.producerRequest1()).size());
        this.purgatory().watch(r1);
        Assert.assertEquals((String)"Still nothing satisfied", (int)0, (int)this.purgatory().update("test1", this.producerRequest1()).size());
        this.purgatory().watch(r2);
        Assert.assertEquals((String)"Still nothing satisfied", (int)0, (int)this.purgatory().update("test2", this.producerRequest2()).size());
        this.purgatory().satisfied().$plus$eq((Object)r1);
        Assert.assertEquals((String)"r1 satisfied", (Object)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DelayedRequest[]{r1})), (Object)this.purgatory().update("test1", this.producerRequest1()));
        Assert.assertEquals((String)"Nothing satisfied", (int)0, (int)this.purgatory().update("test1", this.producerRequest2()).size());
        this.purgatory().satisfied().$plus$eq((Object)r2);
        Assert.assertEquals((String)"r2 satisfied", (Object)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DelayedRequest[]{r2})), (Object)this.purgatory().update("test2", this.producerRequest2()));
        Assert.assertEquals((String)"Nothing satisfied", (int)0, (int)this.purgatory().update("test2", this.producerRequest2()).size());
    }

    @Test
    public void testRequestExpiry() {
        long expiration = 20L;
        DelayedRequest r1 = new DelayedRequest((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"}), null, expiration);
        DelayedRequest r2 = new DelayedRequest((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"}), null, 200000L);
        long start = System.currentTimeMillis();
        this.purgatory().watch(r1);
        this.purgatory().watch(r2);
        this.purgatory().awaitExpiration(r1);
        long elapsed = System.currentTimeMillis() - start;
        Assert.assertTrue((String)"r1 expired", (boolean)this.purgatory().expired().contains((Object)r1));
        Assert.assertTrue((String)"r2 hasn't expired", (!this.purgatory().expired().contains((Object)r2) ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringOps(Predef$.MODULE$.augmentString("Time for expiration %d should at least %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)elapsed), BoxesRunTime.boxToLong((long)expiration)})), (elapsed >= expiration ? 1 : 0) != 0);
    }

    public class MockRequestPurgatory
    extends RequestPurgatory<DelayedRequest, ProducerRequest> {
        private final Set<DelayedRequest> satisfied;
        private final Set<DelayedRequest> expired;

        public Set<DelayedRequest> satisfied() {
            return this.satisfied;
        }

        public Set<DelayedRequest> expired() {
            return this.expired;
        }

        public void awaitExpiration(DelayedRequest delayed) {
            DelayedRequest delayedRequest = delayed;
            synchronized (delayedRequest) {
                delayed.wait();
                return;
            }
        }

        public boolean checkSatisfied(ProducerRequest request, DelayedRequest delayed) {
            return this.satisfied().contains((Object)delayed);
        }

        public void expire(DelayedRequest delayed) {
            this.expired().$plus$eq((Object)delayed);
            DelayedRequest delayedRequest = delayed;
            synchronized (delayedRequest) {
                delayed.notify();
                return;
            }
        }

        public /* synthetic */ RequestPurgatoryTest kafka$server$RequestPurgatoryTest$MockRequestPurgatory$$$outer() {
            return RequestPurgatoryTest.this;
        }

        public MockRequestPurgatory() {
            if (RequestPurgatoryTest.this == null) {
                throw new NullPointerException();
            }
            super(RequestPurgatory$.MODULE$.$lessinit$greater$default$1(), RequestPurgatory$.MODULE$.$lessinit$greater$default$2());
            this.satisfied = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.expired = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
    }
}

