/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Hashtable;
import java.util.Properties;
import junit.framework.Assert;
import kafka.admin.AdminUtils$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.Utils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001\u001d\u0011\u0011CU8mY&twMQ8v]\u000e,G+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t%A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"BA\u0006K+:LGoM*vSR,\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\tQ8.\u0003\u0002\u0018)\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgNDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000fy\u0001!\u0019!C\u0001?\u0005I!M]8lKJLE-M\u000b\u0002AA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t\u0019\u0011J\u001c;\t\r\u001d\u0002\u0001\u0015!\u0003!\u0003)\u0011'o\\6fe&#\u0017\u0007\t\u0005\bS\u0001\u0011\r\u0011\"\u0001 \u0003%\u0011'o\\6fe&#'\u0007\u0003\u0004,\u0001\u0001\u0006I\u0001I\u0001\u000bEJ|7.\u001a:JIJ\u0002\u0003bB\u0017\u0001\u0005\u0004%\taH\u0001\nEJ|7.\u001a:JINBaa\f\u0001!\u0002\u0013\u0001\u0013A\u00032s_.,'/\u001334A!9\u0011\u0007\u0001b\u0001\n\u0003y\u0012!\u00032s_.,'/\u001335\u0011\u0019\u0019\u0004\u0001)A\u0005A\u0005Q!M]8lKJLE\r\u000e\u0011\t\u000fU\u0002!\u0019!C\u0001?\u0005)\u0001o\u001c:uc!1q\u0007\u0001Q\u0001\n\u0001\na\u0001]8siF\u0002\u0003bB\u001d\u0001\u0005\u0004%\taH\u0001\u0006a>\u0014HO\r\u0005\u0007w\u0001\u0001\u000b\u0011\u0002\u0011\u0002\rA|'\u000f\u001e\u001a!\u0011\u001di\u0004A1A\u0005\u0002}\tQ\u0001]8siNBaa\u0010\u0001!\u0002\u0013\u0001\u0013A\u00029peR\u001c\u0004\u0005C\u0004B\u0001\t\u0007I\u0011A\u0010\u0002\u000bA|'\u000f\u001e\u001b\t\r\r\u0003\u0001\u0015!\u0003!\u0003\u0019\u0001xN\u001d;5A!9Q\t\u0001b\u0001\n\u00031\u0015AD3oC\ndWm\u00155vi\u0012|wO\\\u000b\u0002\u000fB\u0011\u0011\u0005S\u0005\u0003\u0013\n\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004L\u0001\u0001\u0006IaR\u0001\u0010K:\f'\r\\3TQV$Hm\\<oA!9Q\n\u0001b\u0001\n\u0003q\u0015\u0001D2p]\u001aLw\r\u0015:paN\fT#A(\u0011\u0005A+V\"A)\u000b\u0005I\u001b\u0016\u0001B;uS2T\u0011\u0001V\u0001\u0005U\u00064\u0018-\u0003\u0002W#\nQ\u0001K]8qKJ$\u0018.Z:\t\ra\u0003\u0001\u0015!\u0003P\u00035\u0019wN\u001c4jOB\u0013x\u000e]:2A!9!\f\u0001b\u0001\n\u0003q\u0015\u0001D2p]\u001aLw\r\u0015:paN\u0014\u0004B\u0002/\u0001A\u0003%q*A\u0007d_:4\u0017n\u001a)s_B\u001c(\u0007\t\u0005\b=\u0002\u0011\r\u0011\"\u0001O\u00031\u0019wN\u001c4jOB\u0013x\u000e]:4\u0011\u0019\u0001\u0007\u0001)A\u0005\u001f\u0006i1m\u001c8gS\u001e\u0004&o\u001c9tg\u0001BqA\u0019\u0001C\u0002\u0013\u0005a*\u0001\u0007d_:4\u0017n\u001a)s_B\u001cH\u0007\u0003\u0004e\u0001\u0001\u0006IaT\u0001\u000eG>tg-[4Qe>\u00048\u000f\u000e\u0011\t\u000f\u0019\u0004\u0001\u0019!C\u0001O\u000691/\u001a:wKJ\u001cX#\u00015\u0011\u0007%\fHO\u0004\u0002k_:\u00111N\\\u0007\u0002Y*\u0011QNB\u0001\u0007yI|w\u000e\u001e \n\u0003\rJ!\u0001\u001d\u0012\u0002\u000fA\f7m[1hK&\u0011!o\u001d\u0002\u0004'\u0016\f(B\u00019#!\taR/\u0003\u0002w\u0005\tY1*\u00194lCN+'O^3s\u0011\u001dA\b\u00011A\u0005\u0002e\f1b]3sm\u0016\u00148o\u0018\u0013fcR\u0011!0 \t\u0003CmL!\u0001 \u0012\u0003\tUs\u0017\u000e\u001e\u0005\b}^\f\t\u00111\u0001i\u0003\rAH%\r\u0005\b\u0003\u0003\u0001\u0001\u0015)\u0003i\u0003!\u0019XM\u001d<feN\u0004\u0003\u0002CA\u0003\u0001\t\u0007I\u0011A\u0010\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\b\u0003\u0013\u0001\u0001\u0015!\u0003!\u00031\u0001\u0018M\u001d;ji&|g.\u00133!\u0011\u001d\ti\u0001\u0001C!\u0003\u001f\tQa]3u+B$\u0012A\u001f\u0005\b\u0003'\u0001A\u0011IA\b\u0003!!X-\u0019:E_^t\u0007bBA\f\u0001\u0011\u0005\u0011\u0011D\u0001\u0012i\u0016\u001cHOU8mY&twMQ8v]\u000e,W#\u0001>\t\u000f\u0005u\u0001\u0001\"\u0003\u0002 \u0005a!m\\;oG\u0016\u001cVM\u001d<feR)!0!\t\u00024!A\u00111EA\u000e\u0001\u0004\t)#A\u0003u_BL7\r\u0005\u0003\u0002(\u00055bbA\u0011\u0002*%\u0019\u00111\u0006\u0012\u0002\rA\u0013X\rZ3g\u0013\u0011\ty#!\r\u0003\rM#(/\u001b8h\u0015\r\tYC\t\u0005\b\u0003k\tY\u00021\u0001!\u0003)\u0019H/\u0019:u\u0013:$W\r\u001f")
public class RollingBounceTest
extends JUnit3Suite
implements ZooKeeperTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private final int brokerId3;
    private final int brokerId4;
    private final int port1;
    private final int port2;
    private final int port3;
    private final int port4;
    private final boolean enableShutdown;
    private final Properties configProps1;
    private final Properties configProps2;
    private final Properties configProps3;
    private final Properties configProps4;
    private Seq<KafkaServer> servers;
    private final int partitionId;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public int brokerId3() {
        return this.brokerId3;
    }

    public int brokerId4() {
        return this.brokerId4;
    }

    public int port1() {
        return this.port1;
    }

    public int port2() {
        return this.port2;
    }

    public int port3() {
        return this.port3;
    }

    public int port4() {
        return this.port4;
    }

    public boolean enableShutdown() {
        return this.enableShutdown;
    }

    public Properties configProps1() {
        return this.configProps1;
    }

    public Properties configProps2() {
        return this.configProps2;
    }

    public Properties configProps3() {
        return this.configProps3;
    }

    public Properties configProps4() {
        return this.configProps4;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int partitionId() {
        return this.partitionId;
    }

    @Override
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        KafkaServer server1 = TestUtils$.MODULE$.createServer(new KafkaConfig(this.configProps1()), TestUtils$.MODULE$.createServer$default$2());
        KafkaServer server2 = TestUtils$.MODULE$.createServer(new KafkaConfig(this.configProps2()), TestUtils$.MODULE$.createServer$default$2());
        KafkaServer server3 = TestUtils$.MODULE$.createServer(new KafkaConfig(this.configProps3()), TestUtils$.MODULE$.createServer$default$2());
        KafkaServer server4 = TestUtils$.MODULE$.createServer(new KafkaConfig(this.configProps4()), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)this.servers().$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1, server2, server3, server4})), Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    public void tearDown() {
        this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.shutdown();
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                Utils$.MODULE$.rm(server.config().logDirs());
            }
        }, Seq$.MODULE$.canBuildFrom());
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public void testRollingBounce() {
        String topic1 = "new-topic1";
        String topic2 = "new-topic2";
        String topic3 = "new-topic3";
        String topic4 = "new-topic4";
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), topic1, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), topic2, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), topic3, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), topic4, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        ObjectRef leader1 = new ObjectRef(TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic1, this.partitionId(), 500L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5()));
        Option<Object> leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic2, this.partitionId(), 500L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        Option<Object> leader3 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic3, this.partitionId(), 500L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        Option<Object> leader4 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic4, this.partitionId(), 500L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        TestUtils$.MODULE$.debug((Function0)new Serializable(this, topic1, leader1){
            public static final long serialVersionUID = 0L;
            private final String topic1$1;
            private final ObjectRef leader1$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Leader for ").append((Object)this.topic1$1).append((Object)new StringOps(Predef$.MODULE$.augmentString(" is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Option)this.leader1$1.elem).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return -1;
                    }
                })}))).toString();
            }
            {
                this.topic1$1 = topic1$1;
                this.leader1$1 = leader1$1;
            }
        });
        TestUtils$.MODULE$.debug((Function0)new Serializable(this, topic2, leader1){
            public static final long serialVersionUID = 0L;
            private final String topic2$1;
            private final ObjectRef leader1$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Leader for ").append((Object)this.topic2$1).append((Object)new StringOps(Predef$.MODULE$.augmentString(" is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Option)this.leader1$1.elem).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return -1;
                    }
                })}))).toString();
            }
            {
                this.topic2$1 = topic2$1;
                this.leader1$1 = leader1$1;
            }
        });
        TestUtils$.MODULE$.debug((Function0)new Serializable(this, topic3, leader1){
            public static final long serialVersionUID = 0L;
            private final String topic3$1;
            private final ObjectRef leader1$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Leader for ").append((Object)this.topic3$1).append((Object)new StringOps(Predef$.MODULE$.augmentString("is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Option)this.leader1$1.elem).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return -1;
                    }
                })}))).toString();
            }
            {
                this.topic3$1 = topic3$1;
                this.leader1$1 = leader1$1;
            }
        });
        TestUtils$.MODULE$.debug((Function0)new Serializable(this, topic4, leader1){
            public static final long serialVersionUID = 0L;
            private final String topic4$1;
            private final ObjectRef leader1$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Leader for ").append((Object)this.topic4$1).append((Object)new StringOps(Predef$.MODULE$.augmentString("is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Option)this.leader1$1.elem).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return -1;
                    }
                })}))).toString();
            }
            {
                this.topic4$1 = topic4$1;
                this.leader1$1 = leader1$1;
            }
        });
        Assert.assertTrue((String)"Leader should get elected", (boolean)((Option)leader1.elem).isDefined());
        Assert.assertTrue((String)"Leader should get elected", (boolean)leader2.isDefined());
        Assert.assertTrue((String)"Leader should get elected", (boolean)leader3.isDefined());
        Assert.assertTrue((String)"Leader should get elected", (boolean)leader4.isDefined());
        Assert.assertTrue((String)new StringBuilder().append((Object)"Leader could be broker 0 or broker 1 for ").append((Object)topic1).toString(), (BoxesRunTime.unboxToInt((Object)((Option)leader1.elem).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 0 || BoxesRunTime.unboxToInt((Object)((Option)leader1.elem).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder().append((Object)"Leader could be broker 1 or broker 2 for ").append((Object)topic2).toString(), (BoxesRunTime.unboxToInt((Object)leader2.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 1 || BoxesRunTime.unboxToInt((Object)((Option)leader1.elem).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder().append((Object)"Leader could be broker 2 or broker 3 for ").append((Object)topic3).toString(), (BoxesRunTime.unboxToInt((Object)leader3.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 2 || BoxesRunTime.unboxToInt((Object)((Option)leader1.elem).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder().append((Object)"Leader could be broker 3 or broker 4 for ").append((Object)topic4).toString(), (BoxesRunTime.unboxToInt((Object)leader4.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 0 || BoxesRunTime.unboxToInt((Object)((Option)leader1.elem).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 3 ? 1 : 0) != 0);
        this.bounceServer(topic1, 0);
        this.bounceServer(topic2, 1);
        this.bounceServer(topic3, 2);
        this.bounceServer(topic4, 3);
    }

    private void bounceServer(String topic, int startIndex) {
        int prevLeader = 0;
        if (TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, this.partitionId(), (KafkaServer)this.servers().apply(startIndex))) {
            ((KafkaServer)this.servers().apply(startIndex)).shutdown();
            prevLeader = startIndex;
        } else {
            ((KafkaServer)this.servers().apply((startIndex + 1) % 4)).shutdown();
            prevLeader = (startIndex + 1) % 4;
        }
        Option<Object> newleader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, this.partitionId(), 1500L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        Assert.assertTrue((String)new StringBuilder().append((Object)"Leader transition did not happen for ").append((Object)topic).toString(), (BoxesRunTime.unboxToInt((Object)newleader.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) != -1 && BoxesRunTime.unboxToInt((Object)newleader.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) != prevLeader ? 1 : 0) != 0);
        ((KafkaServer)this.servers().apply(prevLeader)).startup();
    }

    public RollingBounceTest() {
        ZooKeeperTestHarness$class.$init$(this);
        this.brokerId1 = 0;
        this.brokerId2 = 1;
        this.brokerId3 = 2;
        this.brokerId4 = 3;
        this.port1 = TestUtils$.MODULE$.choosePort();
        this.port2 = TestUtils$.MODULE$.choosePort();
        this.port3 = TestUtils$.MODULE$.choosePort();
        this.port4 = TestUtils$.MODULE$.choosePort();
        this.enableShutdown = true;
        this.configProps1 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.port1());
        ((Hashtable)this.configProps1()).put("controlled.shutdown.enable", "true");
        this.configProps2 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.port2());
        ((Hashtable)this.configProps2()).put("controlled.shutdown.enable", "true");
        this.configProps3 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId3(), this.port3());
        ((Hashtable)this.configProps3()).put("controlled.shutdown.enable", "true");
        this.configProps4 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId4(), this.port4());
        ((Hashtable)this.configProps4()).put("controlled.shutdown.enable", "true");
        ((Hashtable)this.configProps4()).put("controlled.shutdown.retry.backoff.ms", "100");
        this.servers = (Seq)Seq$.MODULE$.empty();
        this.partitionId = 0;
    }
}

