/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.KafkaException;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.Assertions;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.PendingNothing;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.TestRerunner;
import org.scalatest.Tracker;
import org.scalatest.junit.AssertionsForJUnit;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001\u000f\tIQ\u000b^5mgR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u001e;jYNT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001\u0002\u0005\t\u0003\u00139i\u0011A\u0003\u0006\u0003\u00171\tA\u0001\\1oO*\tQ\"\u0001\u0003kCZ\f\u0017BA\b\u000b\u0005\u0019y%M[3diB\u0011\u0011\u0003G\u0007\u0002%)\u00111\u0003F\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003+Y\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003]\t1a\u001c:h\u0013\tI\"C\u0001\u0006K+:LGoU;ji\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000f\u0001\u0002!\u0019!C\u0005C\u00051An\\4hKJ,\u0012A\t\t\u0003G!j\u0011\u0001\n\u0006\u0003K\u0019\nQ\u0001\\8hi)T!a\n\f\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tICE\u0001\u0004M_\u001e<WM\u001d\u0005\u0007W\u0001\u0001\u000b\u0011\u0002\u0012\u0002\u000f1|wmZ3sA!)Q\u0006\u0001C\u0001]\u0005YA/Z:u'^\fG\u000e\\8x)\u0005y\u0003C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$\u0001B+oSRD#\u0001\f\u001c\u0011\u0005]JT\"\u0001\u001d\u000b\u0005M1\u0012B\u0001\u001e9\u0005\u0011!Vm\u001d;\t\u000bq\u0002A\u0011\u0001\u0018\u0002)Q,7\u000f^\"je\u000e,H.\u0019:Ji\u0016\u0014\u0018\r^8sQ\tYd\u0007C\u0003@\u0001\u0011\u0005a&A\u0007uKN$(+Z1e\u0005f$Xm\u001d\u0015\u0003}YBQA\u0011\u0001\u0005\u00029\n\u0011\u0003^3tiJ+\u0007\u000f\\1dKN+hMZ5yQ\t\te\u0007C\u0003F\u0001\u0011\u0005a&A\u0006uKN$(+Z1e\u0013:$\bF\u0001#7\u0011\u0015A\u0005\u0001\"\u0001/\u0003-!Xm\u001d;DgZd\u0015n\u001d;)\u0005\u001d3\u0004\"B&\u0001\t\u0003q\u0013A\u0003;fgRLe\u000eT8dW\"\u0012!J\u000e")
public class UtilsTest
implements JUnitSuite {
    private final Logger kafka$utils$UtilsTest$$logger;
    private volatile Tracker org$scalatest$junit$JUnitSuite$$theTracker;
    private final String styleName;

    public Tracker org$scalatest$junit$JUnitSuite$$theTracker() {
        return this.org$scalatest$junit$JUnitSuite$$theTracker;
    }

    public void org$scalatest$junit$JUnitSuite$$theTracker_$eq(Tracker x$1) {
        this.org$scalatest$junit$JUnitSuite$$theTracker = x$1;
    }

    public final String styleName() {
        return this.styleName;
    }

    public final void org$scalatest$junit$JUnitSuite$_setter_$styleName_$eq(String x$1) {
        this.styleName = x$1;
    }

    public final void withFixture(Suite.NoArgTest test) {
        JUnitSuite.class.withFixture((JUnitSuite)this, (Suite.NoArgTest)test);
    }

    public final void runNestedSuites(Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runNestedSuites((JUnitSuite)this, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTests(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runTests((JUnitSuite)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        JUnitSuite.class.runTest((JUnitSuite)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    public Set<String> testNames() {
        return JUnitSuite.class.testNames((JUnitSuite)this);
    }

    public int expectedTestCount(Filter filter) {
        return JUnitSuite.class.expectedTestCount((JUnitSuite)this, (Filter)filter);
    }

    public Map<String, Set<String>> tags() {
        return JUnitSuite.class.tags((JUnitSuite)this);
    }

    public void run(Option<String> testName, Reporter report, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.run((JUnitSuite)this, testName, (Reporter)report, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public Throwable newAssertionFailedException(Option<Object> optionalMessage, Option<Throwable> optionalCause, int stackDepth) {
        return AssertionsForJUnit.class.newAssertionFailedException((AssertionsForJUnit)this, optionalMessage, optionalCause, (int)stackDepth);
    }

    public void org$scalatest$Suite$_setter_$styleName_$eq(String x$1) {
    }

    public List<Suite> nestedSuites() {
        return Suite.class.nestedSuites((Suite)this);
    }

    public final void execute(String testName, Map<String, Object> configMap, boolean color, boolean durations, boolean shortstacks, boolean fullstacks, boolean stats) {
        Suite.class.execute((Suite)this, (String)testName, configMap, (boolean)color, (boolean)durations, (boolean)shortstacks, (boolean)fullstacks, (boolean)stats);
    }

    public Method getMethodForTestName(String testName) {
        return Suite.class.getMethodForTestName((Suite)this, (String)testName);
    }

    public Tuple6<Stopper, Reporter, Method, Object, Option<TestRerunner>, Object> getSuiteRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getSuiteRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public Tuple5<Stopper, Reporter, Object, Option<TestRerunner>, Object> getRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public void handleFailedTest(Throwable throwable, boolean hasPublicNoArgConstructor, String testName, Option<Rerunner> rerunnable, Reporter report, Tracker tracker, long duration) {
        Suite.class.handleFailedTest((Suite)this, (Throwable)throwable, (boolean)hasPublicNoArgConstructor, (String)testName, rerunnable, (Reporter)report, (Tracker)tracker, (long)duration);
    }

    public String suiteName() {
        return Suite.class.suiteName((Suite)this);
    }

    public PendingNothing pending() {
        return Suite.class.pending((Suite)this);
    }

    public void pendingUntilFixed(Function0<BoxedUnit> f) {
        Suite.class.pendingUntilFixed((Suite)this, f);
    }

    public Reporter wrapReporterIfNecessary(Reporter reporter) {
        return Suite.class.wrapReporterIfNecessary((Suite)this, (Reporter)reporter);
    }

    public final String execute$default$1() {
        return Suite.class.execute$default$1((Suite)this);
    }

    public final Map<String, Object> execute$default$2() {
        return Suite.class.execute$default$2((Suite)this);
    }

    public final boolean execute$default$3() {
        return Suite.class.execute$default$3((Suite)this);
    }

    public final boolean execute$default$4() {
        return Suite.class.execute$default$4((Suite)this);
    }

    public final boolean execute$default$5() {
        return Suite.class.execute$default$5((Suite)this);
    }

    public final boolean execute$default$6() {
        return Suite.class.execute$default$6((Suite)this);
    }

    public final boolean execute$default$7() {
        return Suite.class.execute$default$7((Suite)this);
    }

    public void assert(boolean condition) {
        Assertions.class.assert((Assertions)this, (boolean)condition);
    }

    public void assert(boolean condition, Object clue) {
        Assertions.class.assert((Assertions)this, (boolean)condition, (Object)clue);
    }

    public void assert(Option<String> o, Object clue) {
        Assertions.class.assert((Assertions)this, o, (Object)clue);
    }

    public void assert(Option<String> o) {
        Assertions.class.assert((Assertions)this, o);
    }

    public Assertions.Equalizer convertToEqualizer(Object left) {
        return Assertions.class.convertToEqualizer((Assertions)this, (Object)left);
    }

    public <T> T intercept(Function0<Object> f, Manifest<T> manifest) {
        return (T)Assertions.class.intercept((Assertions)this, f, manifest);
    }

    public void expectResult(Object expected, Object clue, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expect(Object expected, Object clue, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expectResult(Object expected, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)actual);
    }

    public void expect(Object expected, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)actual);
    }

    public Nothing$ fail() {
        return Assertions.class.fail((Assertions)this);
    }

    public Nothing$ fail(String message) {
        return Assertions.class.fail((Assertions)this, (String)message);
    }

    public Nothing$ fail(String message, Throwable cause) {
        return Assertions.class.fail((Assertions)this, (String)message, (Throwable)cause);
    }

    public Nothing$ fail(Throwable cause) {
        return Assertions.class.fail((Assertions)this, (Throwable)cause);
    }

    public <T> T withClue(Object clue, Function0<T> fun) {
        return (T)Assertions.class.withClue((Assertions)this, (Object)clue, fun);
    }

    public Logger kafka$utils$UtilsTest$$logger() {
        return this.kafka$utils$UtilsTest$$logger;
    }

    @Test
    public void testSwallow() {
        Utils$.MODULE$.swallow((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UtilsTest $outer;

            public final void apply(Object x$1, Throwable x$2) {
                this.$outer.kafka$utils$UtilsTest$$logger().info(x$1, x$2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new KafkaException("test");
            }
        });
    }

    @Test
    public void testCircularIterator() {
        List l = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        Iterator itl = Utils$.MODULE$.circularIterator((Iterable)l);
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)itl.next());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)2), (Object)itl.next());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)itl.next());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)2), (Object)itl.next());
        Assert.assertFalse((boolean)itl.hasDefiniteSize());
        Set s = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        Iterator its = Utils$.MODULE$.circularIterator((Iterable)s);
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)its.next());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)2), (Object)its.next());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)its.next());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)2), (Object)its.next());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)its.next());
    }

    @Test
    public void testReadBytes() {
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "a", "abcd"})).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String testCase) {
                byte[] bytes = testCase.getBytes();
                Assert.assertTrue((boolean)Arrays.equals(bytes, Utils$.MODULE$.readBytes(ByteBuffer.wrap(bytes))));
            }
        });
    }

    @Test
    public void testReplaceSuffix() {
        Assert.assertEquals((Object)"blah.foo.text", (Object)Utils$.MODULE$.replaceSuffix("blah.foo.txt", ".txt", ".text"));
        Assert.assertEquals((Object)"blah.foo", (Object)Utils$.MODULE$.replaceSuffix("blah.foo.txt", ".txt", ""));
        Assert.assertEquals((Object)"txt.txt", (Object)Utils$.MODULE$.replaceSuffix("txt.txt.txt", ".txt", ""));
        Assert.assertEquals((Object)"foo.txt", (Object)Utils$.MODULE$.replaceSuffix("foo", "", ".txt"));
    }

    @Test
    public void testReadInt() {
        int[] values = new int[]{0, 1, -1, 127, Short.MAX_VALUE, 65534, 0x3FFFFFFF, -1073741824, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE};
        ByteBuffer buffer = ByteBuffer.allocate(4 * Predef$.MODULE$.intArrayOps(values).size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), values.length).foreach$mVc$sp((Function1)new Serializable(this, values, buffer){
            public static final long serialVersionUID = 0L;
            private final int[] values$1;
            private final ByteBuffer buffer$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.buffer$1.putInt(i * 4, this.values$1[i]);
                Assert.assertEquals((String)"Written value should match read value.", (Object)BoxesRunTime.boxToInteger((int)this.values$1[i]), (Object)BoxesRunTime.boxToInteger((int)Utils$.MODULE$.readInt(this.buffer$1.array(), i * 4)));
            }
            {
                this.values$1 = values$1;
                this.buffer$1 = buffer$1;
            }
        });
    }

    @Test
    public void testCsvList() {
        String emptyString = "";
        String nullString = null;
        Seq emptyList = Utils$.MODULE$.parseCsvList(emptyString);
        Seq emptyListFromNullString = Utils$.MODULE$.parseCsvList(nullString);
        Seq emptyStringList = (Seq)Seq$.MODULE$.empty();
        Assert.assertTrue((emptyList != null ? 1 : 0) != 0);
        Assert.assertTrue((emptyListFromNullString != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)emptyStringList.equals((Object)emptyListFromNullString));
        Assert.assertTrue((boolean)emptyStringList.equals((Object)emptyList));
    }

    @Test
    public void testInLock() {
        ReentrantLock lock = new ReentrantLock();
        int result = BoxesRunTime.unboxToInt((Object)Utils$.MODULE$.inLock((Lock)lock, (Function0)new Serializable(this, lock){
            public static final long serialVersionUID = 0L;
            private final ReentrantLock lock$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                Assert.assertTrue((String)"Should be in lock", (boolean)this.lock$1.isHeldByCurrentThread());
                return 2;
            }
            {
                this.lock$1 = lock$1;
            }
        }));
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)result));
        Assert.assertFalse((String)"Should be unlocked", (boolean)lock.isLocked());
    }

    public UtilsTest() {
        Assertions.class.$init$((Assertions)this);
        Suite.class.$init$((Suite)this);
        AssertionsForJUnit.class.$init$((AssertionsForJUnit)this);
        JUnitSuite.class.$init$((JUnitSuite)this);
        this.kafka$utils$UtilsTest$$logger = Logger.getLogger(UtilsTest.class);
    }
}

