/*
 * Decompiled with CFR 0.152.
 */
package kafka.api.test;

import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.test.ProducerCompressionTest$;
import kafka.consumer.SimpleConsumer;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.Utils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.scalatest.junit.JUnit3Suite;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u0001%\u0011q\u0003\u0015:pIV\u001cWM]\"p[B\u0014Xm]:j_:$Vm\u001d;\u000b\u0005\r!\u0011\u0001\u0002;fgRT!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018NC\u0001\b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0006\u0015!\tY!#D\u0001\r\u0015\tia\"A\u0003kk:LGO\u0003\u0002\u0010!\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002#\u0005\u0019qN]4\n\u0005Ma!a\u0003&V]&$8gU;ji\u0016\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u0005i\\\u0017BA\r\u0017\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\"A1\u0004\u0001B\u0001B\u0003%A$A\u0006d_6\u0004(/Z:tS>t\u0007CA\u000f$\u001d\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0003\u0019\u0001&/\u001a3fM&\u0011A%\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\tz\u0002\"B\u0014\u0001\t\u0003A\u0013A\u0002\u001fj]&$h\b\u0006\u0002*WA\u0011!\u0006A\u0007\u0002\u0005!)1D\na\u00019!9Q\u0006\u0001b\u0001\n\u0013q\u0013\u0001\u00032s_.,'/\u00133\u0016\u0003=\u0002\"A\b\u0019\n\u0005Ez\"aA%oi\"11\u0007\u0001Q\u0001\n=\n\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\t\u000fU\u0002!\u0019!C\u0005]\u0005!\u0001o\u001c:u\u0011\u00199\u0004\u0001)A\u0005_\u0005)\u0001o\u001c:uA!9\u0011\b\u0001a\u0001\n\u0013Q\u0014AB:feZ,'/F\u0001<!\tad(D\u0001>\u0015\tId!\u0003\u0002@{\tY1*\u00194lCN+'O^3s\u0011\u001d\t\u0005\u00011A\u0005\n\t\u000b!b]3sm\u0016\u0014x\fJ3r)\t\u0019e\t\u0005\u0002\u001f\t&\u0011Qi\b\u0002\u0005+:LG\u000fC\u0004H\u0001\u0006\u0005\t\u0019A\u001e\u0002\u0007a$\u0013\u0007\u0003\u0004J\u0001\u0001\u0006KaO\u0001\bg\u0016\u0014h/\u001a:!\u0011\u001dY\u0005A1A\u0005\n1\u000bQ\u0001\u001d:paN,\u0012!\u0014\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000bA!\u001e;jY*\t!+\u0001\u0003kCZ\f\u0017B\u0001+P\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u0007-\u0002\u0001\u000b\u0011B'\u0002\rA\u0014x\u000e]:!\u0011\u001dA\u0006A1A\u0005\ne\u000baaY8oM&<W#\u0001.\u0011\u0005qZ\u0016B\u0001/>\u0005-Y\u0015MZ6b\u0007>tg-[4\t\ry\u0003\u0001\u0015!\u0003[\u0003\u001d\u0019wN\u001c4jO\u0002Bq\u0001\u0019\u0001C\u0002\u0013%\u0011-A\u0003u_BL7-F\u0001c!\t\u0019g-D\u0001e\u0015\t)\u0017+\u0001\u0003mC:<\u0017B\u0001\u0013e\u0011\u0019A\u0007\u0001)A\u0005E\u00061Ao\u001c9jG\u0002BqA\u001b\u0001C\u0002\u0013%a&\u0001\u0006ok6\u0014VmY8sINDa\u0001\u001c\u0001!\u0002\u0013y\u0013a\u00038v[J+7m\u001c:eg\u0002BQA\u001c\u0001\u0005B=\fQa]3u+B$\u0012a\u0011\u0015\u0003[F\u0004\"A\u001d;\u000e\u0003MT!!\u0004\t\n\u0005U\u001c(A\u0002\"fM>\u0014X\rC\u0003x\u0001\u0011\u0005s.\u0001\u0005uK\u0006\u0014Hi\\<oQ\t1\u0018\u0010\u0005\u0002su&\u00111p\u001d\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0006{\u0002!\ta\\\u0001\u0010i\u0016\u001cHoQ8naJ,7o]5p]\"\u0012Ap \t\u0004e\u0006\u0005\u0011bAA\u0002g\n!A+Z:uQ\u001d\u0001\u0011qAA\n\u0003+\u0001B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001b\u0019\u0018A\u0002:v]:,'/\u0003\u0003\u0002\u0012\u0005-!a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0003\u0003/\u0001B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;\u0019\u0018a\u0002:v]:,'o]\u0005\u0005\u0003C\tYBA\u0007QCJ\fW.\u001a;fe&TX\rZ\u0004\b\u0003K\u0011\u0001\u0012AA\u0014\u0003]\u0001&o\u001c3vG\u0016\u00148i\\7qe\u0016\u001c8/[8o)\u0016\u001cH\u000fE\u0002+\u0003S1a!\u0001\u0002\t\u0002\u0005-2CBA\u0015\u0003[\t\u0019\u0004E\u0002\u001f\u0003_I1!!\r \u0005\u0019\te.\u001f*fMB\u0019a$!\u000e\n\u0007\u0005]rD\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0004(\u0003S!\t!a\u000f\u0015\u0005\u0005\u001d\u0002\u0002CA \u0003S!\t!!\u0011\u0002\u0015A\f'/Y7fi\u0016\u00148/\u0006\u0002\u0002DA)a*!\u0012\u0002J%\u0019\u0011qI(\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0005\u0003\u001f\u0003\u0017b\u0012bAA'?\t)\u0011I\u001d:bs\"\"\u0011QHA)!\u0011\t\u0019&a\u001b\u000f\t\u0005U\u0013q\r\b\u0005\u0003/\n)G\u0004\u0003\u0002Z\u0005\rd\u0002BA.\u0003Cj!!!\u0018\u000b\u0007\u0005}\u0003\"\u0001\u0004=e>|GOP\u0005\u0002#%\u0011Q\u0002E\u0005\u0004\u0003;\u0019\u0018\u0002BA5\u00037\tQ\u0002U1sC6,G/\u001a:ju\u0016$\u0017\u0002BA7\u0003_\u0012!\u0002U1sC6,G/\u001a:t\u0015\u0011\tI'a\u0007\t\u0015\u0005M\u0014\u0011FA\u0001\n\u0013\t)(A\u0006sK\u0006$'+Z:pYZ,GCAA<!\r\u0019\u0017\u0011P\u0005\u0004\u0003w\"'AB(cU\u0016\u001cG\u000f")
public class ProducerCompressionTest
extends JUnit3Suite
implements ZooKeeperTestHarness {
    private final String compression;
    private final int brokerId;
    private final int port;
    private KafkaServer server;
    private final Properties props;
    private final KafkaConfig config;
    private final String kafka$api$test$ProducerCompressionTest$$topic;
    private final int numRecords;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return ProducerCompressionTest$.MODULE$.parameters();
    }

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private int port() {
        return this.port;
    }

    private KafkaServer server() {
        return this.server;
    }

    private void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    private Properties props() {
        return this.props;
    }

    private KafkaConfig config() {
        return this.config;
    }

    public String kafka$api$test$ProducerCompressionTest$$topic() {
        return this.kafka$api$test$ProducerCompressionTest$$topic;
    }

    private int numRecords() {
        return this.numRecords;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        this.server_$eq(TestUtils$.MODULE$.createServer(this.config(), TestUtils$.MODULE$.createServer$default$2()));
    }

    @Override
    @After
    public void tearDown() {
        this.server().shutdown();
        Utils$.MODULE$.rm(this.server().config().logDirs());
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void testCompression() {
        Properties props = new Properties();
        props.put("bootstrap.servers", TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{this.config()})))));
        props.put("compression.type", this.compression);
        props.put("batch.size", "66000");
        props.put("linger.ms", "200");
        props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        ObjectRef producer = new ObjectRef((Object)new KafkaProducer(props));
        SimpleConsumer consumer = new SimpleConsumer("localhost", this.port(), 100, 0x100000, "");
        try {
            TestUtils$.MODULE$.createTopic(this.zkClient(), this.kafka$api$test$ProducerCompressionTest$$topic(), 1, 1, (Seq<KafkaServer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()})), TestUtils$.MODULE$.createTopic$default$6());
            int partition = 0;
            IndexedSeq messages2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numRecords()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(int i) {
                    return new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes();
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            IndexedSeq responses = (IndexedSeq)messages2.map((Function1)new Serializable(this, producer){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProducerCompressionTest $outer;
                private final ObjectRef producer$1;

                public final Future<RecordMetadata> apply(byte[] message) {
                    return ((KafkaProducer)this.producer$1.elem).send(new ProducerRecord(this.$outer.kafka$api$test$ProducerCompressionTest$$topic(), null, null, (Object)message));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.producer$1 = producer$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            List futures = responses.toList();
            ((TraversableLike)futures.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numRecords()), List$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Future<RecordMetadata>, Object> check$ifrefutable$1) {
                    Tuple2<Future<RecordMetadata>, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<Future<RecordMetadata>, Object> x$1) {
                    Tuple2<Future<RecordMetadata>, Object> tuple2 = x$1;
                    if (tuple2 != null) {
                        Future future = (Future)tuple2._1();
                        int offset = tuple2._2$mcI$sp();
                        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)offset), (Object)BoxesRunTime.boxToLong((long)((RecordMetadata)future.get()).offset()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            FetchResponse fetchResponse = consumer.fetch(new FetchRequestBuilder().addFetch(this.kafka$api$test$ProducerCompressionTest$$topic(), partition, 0L, Integer.MAX_VALUE).build());
            Buffer messageSet = fetchResponse.messageSet(this.kafka$api$test$ProducerCompressionTest$$topic(), partition).iterator().toBuffer();
            Assert.assertEquals((String)new StringBuilder().append((Object)"Should have fetched ").append((Object)BoxesRunTime.boxToInteger((int)this.numRecords())).append((Object)" messages").toString(), (Object)BoxesRunTime.boxToInteger((int)this.numRecords()), (Object)BoxesRunTime.boxToInteger((int)messageSet.size()));
            IntRef index = new IntRef(0);
            messages2.foreach((Function1)new Serializable(this, messageSet, index){
                public static final long serialVersionUID = 0L;
                private final Buffer messageSet$1;
                private final IntRef index$1;

                public final void apply(byte[] message) {
                    Assert.assertEquals((Object)new Message(message), (Object)((MessageAndOffset)this.messageSet$1.apply(this.index$1.elem)).message());
                    Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)this.index$1.elem), (Object)BoxesRunTime.boxToLong((long)((MessageAndOffset)this.messageSet$1.apply(this.index$1.elem)).offset()));
                    ++this.index$1.elem;
                }
                {
                    this.messageSet$1 = messageSet$1;
                    this.index$1 = index$1;
                }
            });
            return;
        }
        finally {
            if ((KafkaProducer)producer.elem != null) {
                ((KafkaProducer)producer.elem).close();
                producer.elem = null;
            }
            if (consumer != null) {
                consumer.close();
            }
        }
    }

    public ProducerCompressionTest(String compression) {
        this.compression = compression;
        ZooKeeperTestHarness$class.$init$(this);
        this.brokerId = 0;
        this.port = TestUtils$.MODULE$.choosePort();
        this.server = null;
        this.props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.port(), TestUtils$.MODULE$.createBrokerConfig$default$3());
        this.config = new KafkaConfig(this.props());
        this.kafka$api$test$ProducerCompressionTest$$topic = "topic";
        this.numRecords = 2000;
    }
}

