/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.util.Properties;
import junit.framework.Assert;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.Utils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001B\u0001\u0003\u0001\u001d\u0011\u0011CU8mY&twMQ8v]\u000e,G+Z:u\u0015\t\u0019A!A\u0006j]R,wM]1uS>t'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\n\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u00111BS+oSR\u001c4+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0003u.L!a\u0006\u000b\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0004\u001f\u0001\t\u0007I\u0011A\u0010\u0002\u0013\t\u0014xn[3s\u0013\u0012\fT#\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\u0007%sG\u000f\u0003\u0004(\u0001\u0001\u0006I\u0001I\u0001\u000bEJ|7.\u001a:JIF\u0002\u0003bB\u0015\u0001\u0005\u0004%\taH\u0001\nEJ|7.\u001a:JIJBaa\u000b\u0001!\u0002\u0013\u0001\u0013A\u00032s_.,'/\u001333A!9Q\u0006\u0001b\u0001\n\u0003y\u0012!\u00032s_.,'/\u001334\u0011\u0019y\u0003\u0001)A\u0005A\u0005Q!M]8lKJLEm\r\u0011\t\u000fE\u0002!\u0019!C\u0001?\u0005I!M]8lKJLE\r\u000e\u0005\u0007g\u0001\u0001\u000b\u0011\u0002\u0011\u0002\u0015\t\u0014xn[3s\u0013\u0012$\u0004\u0005C\u00046\u0001\t\u0007I\u0011A\u0010\u0002\u000bA|'\u000f^\u0019\t\r]\u0002\u0001\u0015!\u0003!\u0003\u0019\u0001xN\u001d;2A!9\u0011\b\u0001b\u0001\n\u0003y\u0012!\u00029peR\u0014\u0004BB\u001e\u0001A\u0003%\u0001%\u0001\u0004q_J$(\u0007\t\u0005\b{\u0001\u0011\r\u0011\"\u0001 \u0003\u0015\u0001xN\u001d;4\u0011\u0019y\u0004\u0001)A\u0005A\u00051\u0001o\u001c:ug\u0001Bq!\u0011\u0001C\u0002\u0013\u0005q$A\u0003q_J$H\u0007\u0003\u0004D\u0001\u0001\u0006I\u0001I\u0001\u0007a>\u0014H\u000f\u000e\u0011\t\u000f\u0015\u0003!\u0019!C\u0001\r\u0006a1m\u001c8gS\u001e\u0004&o\u001c9tcU\tq\t\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006!Q\u000f^5m\u0015\u0005a\u0015\u0001\u00026bm\u0006L!AT%\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0003\u0004Q\u0001\u0001\u0006IaR\u0001\u000eG>tg-[4Qe>\u00048/\r\u0011\t\u000fI\u0003!\u0019!C\u0001\r\u0006a1m\u001c8gS\u001e\u0004&o\u001c9te!1A\u000b\u0001Q\u0001\n\u001d\u000bQbY8oM&<\u0007K]8qgJ\u0002\u0003b\u0002,\u0001\u0005\u0004%\tAR\u0001\rG>tg-[4Qe>\u00048o\r\u0005\u00071\u0002\u0001\u000b\u0011B$\u0002\u001b\r|gNZ5h!J|\u0007o]\u001a!\u0011\u001dQ\u0006A1A\u0005\u0002\u0019\u000bAbY8oM&<\u0007K]8qgRBa\u0001\u0018\u0001!\u0002\u00139\u0015!D2p]\u001aLw\r\u0015:paN$\u0004\u0005C\u0004_\u0001\u0001\u0007I\u0011A0\u0002\u000fM,'O^3sgV\t\u0001\rE\u0002bS2t!AY4\u000f\u0005\r4W\"\u00013\u000b\u0005\u00154\u0011A\u0002\u001fs_>$h(C\u0001$\u0013\tA'%A\u0004qC\u000e\\\u0017mZ3\n\u0005)\\'aA*fc*\u0011\u0001N\t\t\u0003[Bl\u0011A\u001c\u0006\u0003_\u0012\taa]3sm\u0016\u0014\u0018BA9o\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\t\u000fM\u0004\u0001\u0019!C\u0001i\u0006Y1/\u001a:wKJ\u001cx\fJ3r)\t)\b\u0010\u0005\u0002\"m&\u0011qO\t\u0002\u0005+:LG\u000fC\u0004ze\u0006\u0005\t\u0019\u00011\u0002\u0007a$\u0013\u0007\u0003\u0004|\u0001\u0001\u0006K\u0001Y\u0001\tg\u0016\u0014h/\u001a:tA!9Q\u0010\u0001b\u0001\n\u0003y\u0012a\u00039beRLG/[8o\u0013\u0012Daa \u0001!\u0002\u0013\u0001\u0013\u0001\u00049beRLG/[8o\u0013\u0012\u0004\u0003bBA\u0002\u0001\u0011\u0005\u0013QA\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002k\"9\u0011\u0011\u0002\u0001\u0005B\u0005\u0015\u0011\u0001\u0003;fCJ$un\u001e8\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010\u0005\tB/Z:u%>dG.\u001b8h\u0005>,hnY3\u0016\u0003UDq!a\u0005\u0001\t\u0013\t)\"\u0001\u0007c_Vt7-Z*feZ,'\u000fF\u0003v\u0003/\tI\u0003\u0003\u0005\u0002\u001a\u0005E\u0001\u0019AA\u000e\u0003\u0015!x\u000e]5d!\u0011\ti\"a\t\u000f\u0007\u0005\ny\"C\u0002\u0002\"\t\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0013\u0003O\u0011aa\u0015;sS:<'bAA\u0011E!9\u00111FA\t\u0001\u0004\u0001\u0013AC:uCJ$\u0018J\u001c3fq\u0002")
public class RollingBounceTest
extends JUnit3Suite
implements ZooKeeperTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private final int brokerId3;
    private final int brokerId4;
    private final int port1;
    private final int port2;
    private final int port3;
    private final int port4;
    private final Properties configProps1;
    private final Properties configProps2;
    private final Properties configProps3;
    private final Properties configProps4;
    private Seq<KafkaServer> servers;
    private final int partitionId;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public int brokerId3() {
        return this.brokerId3;
    }

    public int brokerId4() {
        return this.brokerId4;
    }

    public int port1() {
        return this.port1;
    }

    public int port2() {
        return this.port2;
    }

    public int port3() {
        return this.port3;
    }

    public int port4() {
        return this.port4;
    }

    public Properties configProps1() {
        return this.configProps1;
    }

    public Properties configProps2() {
        return this.configProps2;
    }

    public Properties configProps3() {
        return this.configProps3;
    }

    public Properties configProps4() {
        return this.configProps4;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int partitionId() {
        return this.partitionId;
    }

    @Override
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        KafkaServer server1 = TestUtils$.MODULE$.createServer(new KafkaConfig(this.configProps1()), TestUtils$.MODULE$.createServer$default$2());
        KafkaServer server2 = TestUtils$.MODULE$.createServer(new KafkaConfig(this.configProps2()), TestUtils$.MODULE$.createServer$default$2());
        KafkaServer server3 = TestUtils$.MODULE$.createServer(new KafkaConfig(this.configProps3()), TestUtils$.MODULE$.createServer$default$2());
        KafkaServer server4 = TestUtils$.MODULE$.createServer(new KafkaConfig(this.configProps4()), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)this.servers().$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1, server2, server3, server4})), Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    public void tearDown() {
        this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.shutdown();
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                Utils$.MODULE$.rm(server.config().logDirs());
            }
        }, Seq$.MODULE$.canBuildFrom());
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public void testRollingBounce() {
        String topic1 = "new-topic1";
        String topic2 = "new-topic2";
        String topic3 = "new-topic3";
        String topic4 = "new-topic4";
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic1, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic2, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic3, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic4, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3})))}))), this.servers());
        this.bounceServer(topic1, 0);
        this.bounceServer(topic2, 1);
        this.bounceServer(topic3, 2);
        this.bounceServer(topic4, 3);
    }

    private void bounceServer(String topic, int startIndex) {
        int prevLeader = 0;
        if (TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, this.partitionId(), (KafkaServer)this.servers().apply(startIndex))) {
            ((KafkaServer)this.servers().apply(startIndex)).shutdown();
            prevLeader = startIndex;
        } else {
            ((KafkaServer)this.servers().apply((startIndex + 1) % 4)).shutdown();
            prevLeader = (startIndex + 1) % 4;
        }
        Option<Object> newleader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertTrue((String)new StringBuilder().append((Object)"Leader transition did not happen for ").append((Object)topic).toString(), (BoxesRunTime.unboxToInt((Object)newleader.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) != -1 && BoxesRunTime.unboxToInt((Object)newleader.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) != prevLeader ? 1 : 0) != 0);
        ((KafkaServer)this.servers().apply(prevLeader)).startup();
    }

    public RollingBounceTest() {
        ZooKeeperTestHarness$class.$init$(this);
        this.brokerId1 = 0;
        this.brokerId2 = 1;
        this.brokerId3 = 2;
        this.brokerId4 = 3;
        this.port1 = TestUtils$.MODULE$.choosePort();
        this.port2 = TestUtils$.MODULE$.choosePort();
        this.port3 = TestUtils$.MODULE$.choosePort();
        this.port4 = TestUtils$.MODULE$.choosePort();
        this.configProps1 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.port1(), TestUtils$.MODULE$.createBrokerConfig$default$3());
        this.configProps2 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.port2(), TestUtils$.MODULE$.createBrokerConfig$default$3());
        this.configProps3 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId3(), this.port3(), TestUtils$.MODULE$.createBrokerConfig$default$3());
        this.configProps4 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId4(), this.port4(), TestUtils$.MODULE$.createBrokerConfig$default$3());
        this.configProps4().put("controlled.shutdown.retry.backoff.ms", "100");
        this.servers = (Seq)Seq$.MODULE$.empty();
        this.partitionId = 0;
    }
}

