/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.util.Properties;
import junit.framework.Assert;
import kafka.admin.AdminUtils$;
import kafka.common.FailedToSendMessageException;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.network.Processor;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.SyncProducer;
import kafka.producer.async.DefaultEventHandler;
import kafka.serializer.StringEncoder;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.Utils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u0001\u0003\u0001\u001d\u0011\u0011$\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g\u000eV3ti*\u00111\u0001B\u0001\fS:$Xm\u001a:bi&|gNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u0013!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!a\u0003&V]&$8gU;ji\u0016\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u0005i\\\u0017BA\f\u0015\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\b=\u0001\u0011\r\u0011\"\u0001 \u0003%\u0011'o\\6fe&#\u0017'F\u0001!!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\rIe\u000e\u001e\u0005\u0007O\u0001\u0001\u000b\u0011\u0002\u0011\u0002\u0015\t\u0014xn[3s\u0013\u0012\f\u0004\u0005C\u0004*\u0001\t\u0007I\u0011A\u0010\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0014\u0004BB\u0016\u0001A\u0003%\u0001%\u0001\u0006ce>\\WM]%ee\u0001Bq!\f\u0001C\u0002\u0013\u0005q$A\u0003q_J$\u0018\u0007\u0003\u00040\u0001\u0001\u0006I\u0001I\u0001\u0007a>\u0014H/\r\u0011\t\u000fE\u0002!\u0019!C\u0001?\u0005)\u0001o\u001c:ue!11\u0007\u0001Q\u0001\n\u0001\na\u0001]8siJ\u0002\u0003bB\u001b\u0001\u0005\u0004%\tAN\u0001\u0019K:\f'\r\\3D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^tW#A\u001c\u0011\u0005\u0005B\u0014BA\u001d#\u0005\u001d\u0011un\u001c7fC:Daa\u000f\u0001!\u0002\u00139\u0014!G3oC\ndWmQ8oiJ|G\u000e\\3e'\",H\u000fZ8x]\u0002Bq!\u0010\u0001C\u0002\u0013\u0005a(\u0001\u0007d_:4\u0017n\u001a)s_B\u001c\u0018'F\u0001@!\t\u0001U)D\u0001B\u0015\t\u00115)\u0001\u0003vi&d'\"\u0001#\u0002\t)\fg/Y\u0005\u0003\r\u0006\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0019A\u0005\u0001)A\u0005\u007f\u0005i1m\u001c8gS\u001e\u0004&o\u001c9tc\u0001BqA\u0013\u0001C\u0002\u0013\u0005a(\u0001\u0007d_:4\u0017n\u001a)s_B\u001c(\u0007\u0003\u0004M\u0001\u0001\u0006IaP\u0001\u000eG>tg-[4Qe>\u00048O\r\u0011\t\u000f9\u0003\u0001\u0019!C\u0001\u001f\u000691m\u001c8gS\u001e\u001cX#\u0001)\u0011\u0007EKFL\u0004\u0002S/:\u00111KV\u0007\u0002)*\u0011QKB\u0001\u0007yI|w\u000e\u001e \n\u0003\rJ!\u0001\u0017\u0012\u0002\u000fA\f7m[1hK&\u0011!l\u0017\u0002\u0004'\u0016\f(B\u0001-#!\ti\u0006-D\u0001_\u0015\tyF!\u0001\u0004tKJ4XM]\u0005\u0003Cz\u00131bS1gW\u0006\u001cuN\u001c4jO\"91\r\u0001a\u0001\n\u0003!\u0017aC2p]\u001aLwm]0%KF$\"!\u001a5\u0011\u0005\u00052\u0017BA4#\u0005\u0011)f.\u001b;\t\u000f%\u0014\u0017\u0011!a\u0001!\u0006\u0019\u0001\u0010J\u0019\t\r-\u0004\u0001\u0015)\u0003Q\u0003!\u0019wN\u001c4jON\u0004\u0003bB7\u0001\u0001\u0004%\tA\\\u0001\bg\u0016\u0014h/\u001a:t+\u0005y\u0007cA)ZaB\u0011Q,]\u0005\u0003ez\u00131bS1gW\u0006\u001cVM\u001d<fe\"9A\u000f\u0001a\u0001\n\u0003)\u0018aC:feZ,'o]0%KF$\"!\u001a<\t\u000f%\u001c\u0018\u0011!a\u0001_\"1\u0001\u0010\u0001Q!\n=\f\u0001b]3sm\u0016\u00148\u000f\t\u0005\bu\u0002\u0011\r\u0011\"\u0001|\u0003\u0019\u0011\u0018M\u001c3p[V\tA\u0010\u0005\u0002~\u007f6\taP\u0003\u0002CE%\u0019\u0011\u0011\u0001@\u0003\rI\u000bg\u000eZ8n\u0011\u001d\t)\u0001\u0001Q\u0001\nq\fqA]1oI>l\u0007\u0005C\u0005\u0002\n\u0001\u0011\r\u0011\"\u0001\u0002\f\u0005)Ao\u001c9jGV\u0011\u0011Q\u0002\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111C\"\u0002\t1\fgnZ\u0005\u0005\u0003/\t\tB\u0001\u0004TiJLgn\u001a\u0005\t\u00037\u0001\u0001\u0015!\u0003\u0002\u000e\u00051Ao\u001c9jG\u0002B\u0001\"a\b\u0001\u0005\u0004%\taH\u0001\fa\u0006\u0014H/\u001b;j_:LE\rC\u0004\u0002$\u0001\u0001\u000b\u0011\u0002\u0011\u0002\u0019A\f'\u000f^5uS>t\u0017\n\u001a\u0011\t\u0013\u0005\u001d\u0002A1A\u0005\u0002\u0005%\u0012aD6bM.\f\u0017\t]5t\u0019><w-\u001a:\u0016\u0005\u0005-\u0002\u0003BA\u0017\u0003oi!!a\f\u000b\t\u0005E\u00121G\u0001\u0006Y><GG\u001b\u0006\u0004\u0003kq\u0011AB1qC\u000eDW-\u0003\u0003\u0002:\u0005=\"A\u0002'pO\u001e,'\u000f\u0003\u0005\u0002>\u0001\u0001\u000b\u0011BA\u0016\u0003AY\u0017MZ6b\u0003BL7\u000fT8hO\u0016\u0014\b\u0005C\u0005\u0002B\u0001\u0011\r\u0011\"\u0001\u0002*\u00051b.\u001a;x_J\\\u0007K]8dKN\u001cxN\u001d'pO\u001e,'\u000f\u0003\u0005\u0002F\u0001\u0001\u000b\u0011BA\u0016\u0003]qW\r^<pe.\u0004&o\\2fgN|'\u000fT8hO\u0016\u0014\b\u0005C\u0005\u0002J\u0001\u0011\r\u0011\"\u0001\u0002*\u0005\u00112/\u001f8d!J|G-^2fe2{wmZ3s\u0011!\ti\u0005\u0001Q\u0001\n\u0005-\u0012aE:z]\u000e\u0004&o\u001c3vG\u0016\u0014Hj\\4hKJ\u0004\u0003\"CA)\u0001\t\u0007I\u0011AA\u0015\u0003I)g/\u001a8u\u0011\u0006tG\r\\3s\u0019><w-\u001a:\t\u0011\u0005U\u0003\u0001)A\u0005\u0003W\t1#\u001a<f]RD\u0015M\u001c3mKJdunZ4fe\u0002Bq!!\u0017\u0001\t\u0003\nY&A\u0003tKR,\u0006\u000fF\u0001f\u0011\u001d\ty\u0006\u0001C!\u00037\n\u0001\u0002^3be\u0012{wO\u001c\u0005\b\u0003G\u0002A\u0011BA3\u00031\u0019H/\u0019:u\u0005J|7.\u001a:t)\r)\u0017q\r\u0005\t\u0003S\n\t\u00071\u0001\u0002l\u000591\r\\;ti\u0016\u0014\bcA)Z\u007f!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0014\u0001\t;fgR,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:,e.\u00192mK\u0012,\u0012!\u001a\u0005\b\u0003k\u0002A\u0011AA9\u0003\u0005\"Xm\u001d;V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8ESN\f'\r\\3e\u0011\u001d\tI\b\u0001C\u0001\u0003c\nq\u0006^3tiVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\u0016s\u0017M\u00197fI\nKHk\u001c9jG>3XM\u001d:jI\u0016Dq!! \u0001\t\u0003\t\t(\u0001\u0018uKN$8\t\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\u0012K7/\u00192mK\u0012\u0014\u0015\u0010V8qS\u000e|e/\u001a:sS\u0012,\u0007bBAA\u0001\u0011\u0005\u0011\u0011O\u0001.i\u0016\u001cH/\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g.\u00138wC2LG\rV8qS\u000e|e/\u001a:sS\u0012,\u0007bBAC\u0001\u0011\u0005\u0011\u0011O\u0001#m\u0016\u0014\u0018NZ=V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8F]\u0006\u0014G.\u001a3\t\u000f\u0005%\u0005\u0001\"\u0001\u0002r\u0005\u0019c/\u001a:jMf,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:$\u0015n]1cY\u0016$\u0007bBAG\u0001\u0011%\u0011qR\u0001\u000fg\",H\u000fZ8x]N+'O^3s)\r)\u0017\u0011\u0013\u0005\u0007?\u0006-\u0005\u0019\u00019\t\u000f\u0005U\u0005\u0001\"\u0003\u0002\u0018\u0006q\u0001O]8ek\u000e,W*Z:tC\u001e,G#B3\u0002\u001a\u0006\u001d\u0006\u0002CA\u0005\u0003'\u0003\r!a'\u0011\t\u0005u\u00151\u0015\b\u0004C\u0005}\u0015bAAQE\u00051\u0001K]3eK\u001aLA!a\u0006\u0002&*\u0019\u0011\u0011\u0015\u0012\t\u0011\u0005%\u00161\u0013a\u0001\u00037\u000bq!\\3tg\u0006<W\rC\u0004\u0002.\u0002!I!a,\u0002%\r|gn];nK\u0006cG.T3tg\u0006<Wm\u001d\u000b\u0005\u0003c\u000b9\fE\u0003R\u0003g\u000bY*C\u0002\u00026n\u0013A\u0001T5ti\"A\u0011\u0011BAV\u0001\u0004\tY\n")
public class UncleanLeaderElectionTest
extends JUnit3Suite
implements ZooKeeperTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private final int port1;
    private final int port2;
    private final boolean enableControlledShutdown;
    private final Properties configProps1;
    private final Properties configProps2;
    private Seq<KafkaConfig> configs;
    private Seq<KafkaServer> servers;
    private final Random random;
    private final String topic;
    private final int partitionId;
    private final Logger kafkaApisLogger;
    private final Logger networkProcessorLogger;
    private final Logger syncProducerLogger;
    private final Logger eventHandlerLogger;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public int port1() {
        return this.port1;
    }

    public int port2() {
        return this.port2;
    }

    public boolean enableControlledShutdown() {
        return this.enableControlledShutdown;
    }

    public Properties configProps1() {
        return this.configProps1;
    }

    public Properties configProps2() {
        return this.configProps2;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public Random random() {
        return this.random;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Logger kafkaApisLogger() {
        return this.kafkaApisLogger;
    }

    public Logger networkProcessorLogger() {
        return this.networkProcessorLogger;
    }

    public Logger syncProducerLogger() {
        return this.syncProducerLogger;
    }

    public Logger eventHandlerLogger() {
        return this.eventHandlerLogger;
    }

    @Override
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        this.kafkaApisLogger().setLevel(Level.FATAL);
        this.networkProcessorLogger().setLevel(Level.FATAL);
        this.syncProducerLogger().setLevel(Level.FATAL);
        this.eventHandlerLogger().setLevel(Level.FATAL);
    }

    @Override
    public void tearDown() {
        this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                Utils$.MODULE$.rm(server.config().logDirs());
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.kafkaApisLogger().setLevel(Level.ERROR);
        this.networkProcessorLogger().setLevel(Level.ERROR);
        this.syncProducerLogger().setLevel(Level.ERROR);
        this.eventHandlerLogger().setLevel(Level.ERROR);
        ZooKeeperTestHarness$class.tearDown(this);
    }

    private void startBrokers(Seq<Properties> cluster) {
        cluster.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(Properties props) {
                KafkaConfig config = new KafkaConfig(props);
                KafkaServer server = TestUtils$.MODULE$.createServer(config, TestUtils$.MODULE$.createServer$default$2());
                this.$outer.configs_$eq((Seq<KafkaConfig>)((Seq)this.$outer.configs().$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{config})), Seq$.MODULE$.canBuildFrom())));
                this.$outer.servers_$eq((Seq<KafkaServer>)((Seq)this.$outer.servers().$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server})), Seq$.MODULE$.canBuildFrom())));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void testUncleanLeaderElectionEnabled() {
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), this.topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        this.verifyUncleanLeaderElectionEnabled();
    }

    public void testUncleanLeaderElectionDisabled() {
        this.configProps1().put("unclean.leader.election.enable", String.valueOf(false));
        this.configProps2().put("unclean.leader.election.enable", String.valueOf(false));
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), this.topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        this.verifyUncleanLeaderElectionDisabled();
    }

    public void testUncleanLeaderElectionEnabledByTopicOverride() {
        this.configProps1().put("unclean.leader.election.enable", String.valueOf(false));
        this.configProps2().put("unclean.leader.election.enable", String.valueOf(false));
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", String.valueOf(true));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), this.topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))})), topicProps, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        this.verifyUncleanLeaderElectionEnabled();
    }

    public void testCleanLeaderElectionDisabledByTopicOverride() {
        this.configProps1().put("unclean.leader.election.enable", String.valueOf(true));
        this.configProps2().put("unclean.leader.election.enable", String.valueOf(true));
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", String.valueOf(false));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkClient(), this.topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))})), topicProps, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        this.verifyUncleanLeaderElectionDisabled();
    }

    public void testUncleanLeaderElectionInvalidTopicOverride() {
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "invalid");
        this.intercept((Function0)new Serializable(this, topicProps){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;
            private final Properties topicProps$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.$outer.zkClient(), this.$outer.topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.$outer.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.brokerId1()})))})), this.topicProps$1, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topicProps$1 = topicProps$1;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
    }

    public void verifyUncleanLeaderElectionEnabled() {
        Option<Object> leaderIdOpt = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertTrue((String)"Leader should get elected", (boolean)leaderIdOpt.isDefined());
        int leaderId = BoxesRunTime.unboxToInt((Object)leaderIdOpt.get());
        TestUtils$.MODULE$.debug((Function0<String>)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;
            private final int leaderId$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Leader for ").append((Object)this.$outer.topic()).append((Object)new StringOps(Predef$.MODULE$.augmentString(" is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leaderId$1)}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.leaderId$1 = leaderId$1;
            }
        });
        Assert.assertTrue((String)new StringBuilder().append((Object)"Leader id is set to expected value for topic: ").append((Object)this.topic()).toString(), (leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0);
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        TestUtils$.MODULE$.debug((Function0<String>)new Serializable(this, followerId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;
            private final int followerId$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Follower for ").append((Object)this.$outer.topic()).append((Object)new StringOps(Predef$.MODULE$.augmentString(" is: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.followerId$1)}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.followerId$1 = followerId$1;
            }
        });
        this.kafka$integration$UncleanLeaderElectionTest$$produceMessage(this.topic(), "first");
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first"})), this.consumeAllMessages(this.topic()));
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, followerId){
            public static final long serialVersionUID = 0L;
            private final int followerId$1;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.followerId$1;
            }
            {
                this.followerId$1 = followerId$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.kafka$integration$UncleanLeaderElectionTest$$produceMessage(this.topic(), "second");
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "second"})), this.consumeAllMessages(this.topic()));
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.leaderId$1;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, followerId){
            public static final long serialVersionUID = 0L;
            private final int followerId$1;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.followerId$1;
            }
            {
                this.followerId$1 = followerId$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.startup();
            }
        }, Seq$.MODULE$.canBuildFrom());
        ZkClient x$6 = this.zkClient();
        String x$7 = this.topic();
        int x$8 = this.partitionId();
        Some x$9 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long x$10 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$11 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$6, x$7, x$8, x$10, x$11, (Option<Object>)x$9);
        this.kafka$integration$UncleanLeaderElectionTest$$produceMessage(this.topic(), "third");
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "third"})), this.consumeAllMessages(this.topic()));
    }

    public void verifyUncleanLeaderElectionDisabled() {
        Option<Object> leaderIdOpt = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertTrue((String)"Leader should get elected", (boolean)leaderIdOpt.isDefined());
        int leaderId = BoxesRunTime.unboxToInt((Object)leaderIdOpt.get());
        TestUtils$.MODULE$.debug((Function0<String>)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;
            private final int leaderId$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Leader for ").append((Object)this.$outer.topic()).append((Object)new StringOps(Predef$.MODULE$.augmentString(" is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leaderId$2)}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.leaderId$2 = leaderId$2;
            }
        });
        Assert.assertTrue((String)new StringBuilder().append((Object)"Leader id is set to expected value for topic: ").append((Object)this.topic()).toString(), (leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0);
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        TestUtils$.MODULE$.debug((Function0<String>)new Serializable(this, followerId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;
            private final int followerId$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Follower for ").append((Object)this.$outer.topic()).append((Object)new StringOps(Predef$.MODULE$.augmentString(" is: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.followerId$2)}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.followerId$2 = followerId$2;
            }
        });
        this.kafka$integration$UncleanLeaderElectionTest$$produceMessage(this.topic(), "first");
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first"})), this.consumeAllMessages(this.topic()));
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, followerId){
            public static final long serialVersionUID = 0L;
            private final int followerId$2;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.followerId$2;
            }
            {
                this.followerId$2 = followerId$2;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.kafka$integration$UncleanLeaderElectionTest$$produceMessage(this.topic(), "second");
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "second"})), this.consumeAllMessages(this.topic()));
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$2;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.leaderId$2;
            }
            {
                this.leaderId$2 = leaderId$2;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, followerId){
            public static final long serialVersionUID = 0L;
            private final int followerId$2;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.followerId$2;
            }
            {
                this.followerId$2 = followerId$2;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.startup();
            }
        }, Seq$.MODULE$.canBuildFrom());
        ZkClient x$12 = this.zkClient();
        String x$13 = this.topic();
        int x$14 = this.partitionId();
        Some x$15 = new Some((Object)BoxesRunTime.boxToInteger((int)-1));
        long x$16 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$17 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$12, x$13, x$14, x$16, x$17, (Option<Object>)x$15);
        this.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$integration$UncleanLeaderElectionTest$$produceMessage(this.$outer.topic(), "third");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ManifestFactory$.MODULE$.classType(FailedToSendMessageException.class));
        Assert.assertEquals((Object)List$.MODULE$.empty(), this.consumeAllMessages(this.topic()));
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$2;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.leaderId$2;
            }
            {
                this.leaderId$2 = leaderId$2;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.startup();
            }
        }, Seq$.MODULE$.canBuildFrom());
        ZkClient x$18 = this.zkClient();
        String x$19 = this.topic();
        int x$20 = this.partitionId();
        Some x$21 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
        long x$22 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$23 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$18, x$19, x$20, x$22, x$23, (Option<Object>)x$21);
        this.kafka$integration$UncleanLeaderElectionTest$$produceMessage(this.topic(), "third");
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$2;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.leaderId$2;
            }
            {
                this.leaderId$2 = leaderId$2;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ZkClient x$24 = this.zkClient();
        String x$25 = this.topic();
        int x$26 = this.partitionId();
        Some x$27 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long x$28 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$29 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$24, x$25, x$26, x$28, x$29, (Option<Object>)x$27);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "second", "third"})), this.consumeAllMessages(this.topic()));
    }

    public void kafka$integration$UncleanLeaderElectionTest$$shutdownServer(KafkaServer server) {
        server.shutdown();
        server.awaitShutdown();
    }

    public void kafka$integration$UncleanLeaderElectionTest$$produceMessage(String topic, String message) {
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromConfigs(this.configs());
        String x$2 = StringEncoder.class.getName();
        String x$3 = TestUtils$.MODULE$.createProducer$default$2();
        String x$4 = TestUtils$.MODULE$.createProducer$default$4();
        Properties x$5 = TestUtils$.MODULE$.createProducer$default$5();
        Producer producer = TestUtils$.MODULE$.createProducer(x$1, x$3, x$2, x$4, x$5);
        producer.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)topic, (Object)message.getBytes())}));
        producer.close();
    }

    private List<String> consumeAllMessages(String topic) {
        Properties consumerProps = TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), new StringBuilder().append((Object)"group").append((Object)BoxesRunTime.boxToLong((long)this.random().nextLong())).toString(), "id", 1000L);
        ConsumerConnector consumerConnector = Consumer$.MODULE$.create(new ConsumerConfig(consumerProps));
        KafkaStream messageStream = (KafkaStream)((IterableLike)consumerConnector.createMessageStreams((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToInteger((int)1))}))).apply((Object)topic)).head();
        MutableList messages2 = new MutableList();
        ConsumerIterator iter = messageStream.iterator();
        try {
            while (iter.hasNext()) {
                messages2.$plus$eq((Object)new String((byte[])iter.next().message()));
            }
        }
        catch (ConsumerTimeoutException consumerTimeoutException) {
            TestUtils$.MODULE$.debug((Function0<String>)new Serializable(this, messages2){
                public static final long serialVersionUID = 0L;
                private final MutableList messages$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"consumer timed out after receiving ").append((Object)BoxesRunTime.boxToInteger((int)this.messages$1.length())).append((Object)" message(s).").toString();
                }
                {
                    this.messages$1 = messages$1;
                }
            });
        }
        finally {
            consumerConnector.shutdown();
        }
        return messages2.toList();
    }

    public UncleanLeaderElectionTest() {
        ZooKeeperTestHarness$class.$init$(this);
        this.brokerId1 = 0;
        this.brokerId2 = 1;
        this.port1 = TestUtils$.MODULE$.choosePort();
        this.port2 = TestUtils$.MODULE$.choosePort();
        this.enableControlledShutdown = true;
        this.configProps1 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.port1(), TestUtils$.MODULE$.createBrokerConfig$default$3());
        this.configProps2 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.port2(), TestUtils$.MODULE$.createBrokerConfig$default$3());
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()})).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final Object apply(Properties configProps) {
                configProps.put("controlled.shutdown.enable", String.valueOf(this.$outer.enableControlledShutdown()));
                configProps.put("controlled.shutdown.max.retries", String.valueOf(1));
                return configProps.put("controlled.shutdown.retry.backoff.ms", String.valueOf(1000));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.configs = (Seq)Seq$.MODULE$.empty();
        this.servers = (Seq)Seq$.MODULE$.empty();
        this.random = new Random();
        this.topic = new StringBuilder().append((Object)"topic").append((Object)BoxesRunTime.boxToLong((long)this.random().nextLong())).toString();
        this.partitionId = 0;
        this.kafkaApisLogger = Logger.getLogger(KafkaApis.class);
        this.networkProcessorLogger = Logger.getLogger(Processor.class);
        this.syncProducerLogger = Logger.getLogger(SyncProducer.class);
        this.eventHandlerLogger = Logger.getLogger(DefaultEventHandler.class);
    }
}

