/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import junit.framework.Assert;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsrRequest;
import kafka.api.LeaderAndIsrResponse;
import kafka.api.PartitionStateInfo;
import kafka.api.RequestOrResponse;
import kafka.cluster.Broker;
import kafka.common.ErrorMapping$;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0001\u0003\u0001\u001d\u0011!\u0003T3bI\u0016\u0014X\t\\3di&|g\u000eV3ti*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011I\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\f\u0015Vs\u0017\u000e^\u001aTk&$X\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005\u0011!p[\u0005\u0003/Q\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u001dq\u0002A1A\u0005\u0002}\t\u0011B\u0019:pW\u0016\u0014\u0018\nZ\u0019\u0016\u0003\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u00121!\u00138u\u0011\u00199\u0003\u0001)A\u0005A\u0005Q!M]8lKJLE-\r\u0011\t\u000f%\u0002!\u0019!C\u0001?\u0005I!M]8lKJLEM\r\u0005\u0007W\u0001\u0001\u000b\u0011\u0002\u0011\u0002\u0015\t\u0014xn[3s\u0013\u0012\u0014\u0004\u0005C\u0004.\u0001\t\u0007I\u0011A\u0010\u0002\u000bA|'\u000f^\u0019\t\r=\u0002\u0001\u0015!\u0003!\u0003\u0019\u0001xN\u001d;2A!9\u0011\u0007\u0001b\u0001\n\u0003y\u0012!\u00029peR\u0014\u0004BB\u001a\u0001A\u0003%\u0001%\u0001\u0004q_J$(\u0007\t\u0005\bk\u0001\u0011\r\u0011\"\u00017\u00031\u0019wN\u001c4jOB\u0013x\u000e]:2+\u00059\u0004C\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003\u0011)H/\u001b7\u000b\u0003q\nAA[1wC&\u0011a(\u000f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bB\u0002!\u0001A\u0003%q'A\u0007d_:4\u0017n\u001a)s_B\u001c\u0018\u0007\t\u0005\b\u0005\u0002\u0011\r\u0011\"\u00017\u00031\u0019wN\u001c4jOB\u0013x\u000e]:3\u0011\u0019!\u0005\u0001)A\u0005o\u0005i1m\u001c8gS\u001e\u0004&o\u001c9te\u0001BqA\u0012\u0001A\u0002\u0013\u0005q)A\u0004tKJ4XM]:\u0016\u0003!\u00032!S)U\u001d\tQuJ\u0004\u0002L\u001d6\tAJ\u0003\u0002N\r\u00051AH]8pizJ\u0011aI\u0005\u0003!\n\nq\u0001]1dW\u0006<W-\u0003\u0002S'\n\u00191+Z9\u000b\u0005A\u0013\u0003C\u0001\u000fV\u0013\t1&AA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bb\u0002-\u0001\u0001\u0004%\t!W\u0001\fg\u0016\u0014h/\u001a:t?\u0012*\u0017\u000f\u0006\u0002[;B\u0011\u0011eW\u0005\u00039\n\u0012A!\u00168ji\"9alVA\u0001\u0002\u0004A\u0015a\u0001=%c!1\u0001\r\u0001Q!\n!\u000b\u0001b]3sm\u0016\u00148\u000f\t\u0005\bE\u0002\u0001\r\u0011\"\u0001d\u0003q\u0019H/\u00197f\u0007>tGO]8mY\u0016\u0014X\t]8dQ\u0012+G/Z2uK\u0012,\u0012\u0001\u001a\t\u0003C\u0015L!A\u001a\u0012\u0003\u000f\t{w\u000e\\3b]\"9\u0001\u000e\u0001a\u0001\n\u0003I\u0017\u0001I:uC2,7i\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000eR3uK\u000e$X\rZ0%KF$\"A\u00176\t\u000fy;\u0017\u0011!a\u0001I\"1A\u000e\u0001Q!\n\u0011\fQd\u001d;bY\u0016\u001cuN\u001c;s_2dWM]#q_\u000eDG)\u001a;fGR,G\r\t\u0005\u0006]\u0002!\te\\\u0001\u0006g\u0016$X\u000b\u001d\u000b\u00025\")\u0011\u000f\u0001C!_\u0006AA/Z1s\t><h\u000eC\u0003t\u0001\u0011\u0005A/\u0001\u000euKN$H*Z1eKJ,E.Z2uS>t\u0017I\u001c3Fa>\u001c\u0007.F\u0001[\u0011\u00151\b\u0001\"\u0001p\u0003)\"Xm\u001d;MK\u0006$WM]#mK\u000e$\u0018n\u001c8XSRD7\u000b^1mK\u000e{g\u000e\u001e:pY2,'/\u00129pG\"DQ\u0001\u001f\u0001\u0005\ne\fAd\u001d;bY\u0016\u001cuN\u001c;s_2dWM]#q_\u000eD7)\u00197mE\u0006\u001c7\u000e\u0006\u0002[u\")1p\u001ea\u0001y\u0006A!/Z:q_:\u001cX\rE\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007f\u0012\t1!\u00199j\u0013\r\t\u0019A \u0002\u0012%\u0016\fX/Z:u\u001fJ\u0014Vm\u001d9p]N,\u0007")
public class LeaderElectionTest
extends JUnit3Suite
implements ZooKeeperTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private final int port1;
    private final int port2;
    private final Properties configProps1;
    private final Properties configProps2;
    private Seq<KafkaServer> servers;
    private boolean staleControllerEpochDetected;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public int port1() {
        return this.port1;
    }

    public int port2() {
        return this.port2;
    }

    public Properties configProps1() {
        return this.configProps1;
    }

    public Properties configProps2() {
        return this.configProps2;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public boolean staleControllerEpochDetected() {
        return this.staleControllerEpochDetected;
    }

    public void staleControllerEpochDetected_$eq(boolean x$1) {
        this.staleControllerEpochDetected = x$1;
    }

    @Override
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        KafkaServer server1 = TestUtils$.MODULE$.createServer(new KafkaConfig(this.configProps1()), TestUtils$.MODULE$.createServer$default$2());
        KafkaServer server2 = TestUtils$.MODULE$.createServer(new KafkaConfig(this.configProps2()), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)this.servers().$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1, server2})), Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    public void tearDown() {
        this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.shutdown();
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                Utils$.MODULE$.rm(server.config().logDirs());
            }
        }, Seq$.MODULE$.canBuildFrom());
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public void testLeaderElectionAndEpoch() {
        String topic = "new-topic";
        int partitionId = 0;
        Option leader1 = (Option)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers()).apply((Object)BoxesRunTime.boxToInteger((int)0));
        int leaderEpoch1 = ZkUtils$.MODULE$.getEpochForPartition(this.zkClient(), topic, partitionId);
        TestUtils$.MODULE$.debug((Function0<String>)new Serializable(this, leaderEpoch1){
            public static final long serialVersionUID = 0L;
            private final int leaderEpoch1$1;

            public final String apply() {
                return new StringBuilder().append((Object)"leader Epoc: ").append((Object)BoxesRunTime.boxToInteger((int)this.leaderEpoch1$1)).toString();
            }
            {
                this.leaderEpoch1$1 = leaderEpoch1$1;
            }
        });
        TestUtils$.MODULE$.debug((Function0<String>)new Serializable(this, leader1){
            public static final long serialVersionUID = 0L;
            private final Option leader1$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Leader is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.leader1$1.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return -1;
                    }
                })}));
            }
            {
                this.leader1$1 = leader1$1;
            }
        });
        Assert.assertTrue((String)"Leader should get elected", (boolean)leader1.isDefined());
        Assert.assertTrue((String)"Leader could be broker 0 or broker 1", (BoxesRunTime.unboxToInt((Object)leader1.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 0 || BoxesRunTime.unboxToInt((Object)leader1.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"First epoch value should be 0", (int)0, (int)leaderEpoch1);
        ((KafkaServer)this.servers().last()).shutdown();
        ZkClient x$1 = this.zkClient();
        String x$2 = topic;
        int x$3 = partitionId;
        None$ x$4 = BoxesRunTime.unboxToInt((Object)leader1.get()) == 0 ? None$.MODULE$ : leader1;
        long x$5 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$6 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        Option<Object> leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$1, x$2, x$3, x$5, (Option<Object>)x$4, x$6);
        int leaderEpoch2 = ZkUtils$.MODULE$.getEpochForPartition(this.zkClient(), topic, partitionId);
        TestUtils$.MODULE$.debug((Function0<String>)new Serializable(this, leader1){
            public static final long serialVersionUID = 0L;
            private final Option leader1$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Leader is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.leader1$1.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return -1;
                    }
                })}));
            }
            {
                this.leader1$1 = leader1$1;
            }
        });
        TestUtils$.MODULE$.debug((Function0<String>)new Serializable(this, leaderEpoch2){
            public static final long serialVersionUID = 0L;
            private final int leaderEpoch2$1;

            public final String apply() {
                return new StringBuilder().append((Object)"leader Epoc: ").append((Object)BoxesRunTime.boxToInteger((int)this.leaderEpoch2$1)).toString();
            }
            {
                this.leaderEpoch2$1 = leaderEpoch2$1;
            }
        });
        Assert.assertEquals((String)"Leader must move to broker 0", (int)0, (int)BoxesRunTime.unboxToInt((Object)leader2.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })));
        if (BoxesRunTime.unboxToInt((Object)leader1.get()) == BoxesRunTime.unboxToInt((Object)leader2.get())) {
            Assert.assertEquals((String)new StringBuilder().append((Object)"Second epoch value should be ").append((Object)BoxesRunTime.boxToInteger((int)leaderEpoch1)).append((Object)BoxesRunTime.boxToInteger((int)1)).toString(), (int)(leaderEpoch1 + 1), (int)leaderEpoch2);
        } else {
            Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("Second epoch value should be %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(leaderEpoch1 + 1))})), (int)(leaderEpoch1 + 1), (int)leaderEpoch2);
        }
        ((KafkaServer)this.servers().last()).startup();
        ((KafkaServer)this.servers().head()).shutdown();
        Thread.sleep(this.zookeeper().tickTime());
        ZkClient x$7 = this.zkClient();
        String x$8 = topic;
        int x$9 = partitionId;
        Option<Object> x$10 = BoxesRunTime.unboxToInt((Object)leader2.get()) == 1 ? None$.MODULE$ : leader2;
        long x$11 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$12 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        Option<Object> leader3 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$7, x$8, x$9, x$11, x$10, x$12);
        int leaderEpoch3 = ZkUtils$.MODULE$.getEpochForPartition(this.zkClient(), topic, partitionId);
        TestUtils$.MODULE$.debug((Function0<String>)new Serializable(this, leaderEpoch3){
            public static final long serialVersionUID = 0L;
            private final int leaderEpoch3$1;

            public final String apply() {
                return new StringBuilder().append((Object)"leader Epoc: ").append((Object)BoxesRunTime.boxToInteger((int)this.leaderEpoch3$1)).toString();
            }
            {
                this.leaderEpoch3$1 = leaderEpoch3$1;
            }
        });
        TestUtils$.MODULE$.debug((Function0<String>)new Serializable(this, leader3){
            public static final long serialVersionUID = 0L;
            private final Option leader3$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Leader is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.leader3$1.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return -1;
                    }
                })}));
            }
            {
                this.leader3$1 = leader3$1;
            }
        });
        Assert.assertEquals((String)"Leader must return to 1", (int)1, (int)BoxesRunTime.unboxToInt((Object)leader3.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })));
        if (BoxesRunTime.unboxToInt((Object)leader2.get()) == BoxesRunTime.unboxToInt((Object)leader3.get())) {
            Assert.assertEquals((String)new StringBuilder().append((Object)"Second epoch value should be ").append((Object)BoxesRunTime.boxToInteger((int)leaderEpoch2)).toString(), (int)leaderEpoch2, (int)leaderEpoch3);
        } else {
            Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("Second epoch value should be %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(leaderEpoch2 + 1))})), (int)(leaderEpoch2 + 1), (int)leaderEpoch3);
        }
    }

    public void testLeaderElectionWithStaleControllerEpoch() {
        String topic = "new-topic";
        int partitionId = 0;
        Option leader1 = (Option)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers()).apply((Object)BoxesRunTime.boxToInteger((int)0));
        int leaderEpoch1 = ZkUtils$.MODULE$.getEpochForPartition(this.zkClient(), topic, partitionId);
        TestUtils$.MODULE$.debug((Function0<String>)new Serializable(this, leaderEpoch1){
            public static final long serialVersionUID = 0L;
            private final int leaderEpoch1$2;

            public final String apply() {
                return new StringBuilder().append((Object)"leader Epoc: ").append((Object)BoxesRunTime.boxToInteger((int)this.leaderEpoch1$2)).toString();
            }
            {
                this.leaderEpoch1$2 = leaderEpoch1$2;
            }
        });
        TestUtils$.MODULE$.debug((Function0<String>)new Serializable(this, leader1){
            public static final long serialVersionUID = 0L;
            private final Option leader1$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Leader is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.leader1$2.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return -1;
                    }
                })}));
            }
            {
                this.leader1$2 = leader1$2;
            }
        });
        Assert.assertTrue((String)"Leader should get elected", (boolean)leader1.isDefined());
        Assert.assertTrue((String)"Leader could be broker 0 or broker 1", (BoxesRunTime.unboxToInt((Object)leader1.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 0 || BoxesRunTime.unboxToInt((Object)leader1.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })) == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"First epoch value should be 0", (int)0, (int)leaderEpoch1);
        int controllerId = 2;
        KafkaConfig controllerConfig = new KafkaConfig(TestUtils$.MODULE$.createBrokerConfig(controllerId, TestUtils$.MODULE$.choosePort(), TestUtils$.MODULE$.createBrokerConfig$default$3()));
        Seq brokers = (Seq)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Broker apply(KafkaServer s) {
                return new Broker(s.config().brokerId(), "localhost", s.config().port());
            }
        }, Seq$.MODULE$.canBuildFrom());
        ControllerContext controllerContext = new ControllerContext(this.zkClient(), 6000);
        controllerContext.liveBrokers_$eq((Set)brokers.toSet());
        ControllerChannelManager controllerChannelManager = new ControllerChannelManager(controllerContext, controllerConfig);
        controllerChannelManager.startup();
        int staleControllerEpoch = 0;
        HashMap leaderAndIsr = new HashMap();
        leaderAndIsr.put((Object)new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)new LeaderIsrAndControllerEpoch(new LeaderAndIsr(this.brokerId2(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}))), 2));
        scala.collection.immutable.Map partitionStateInfo = leaderAndIsr.mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final PartitionStateInfo apply(LeaderIsrAndControllerEpoch l) {
                return new PartitionStateInfo(l, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})));
            }
        }).toMap(Predef$.MODULE$.conforms());
        LeaderAndIsrRequest leaderAndIsrRequest = new LeaderAndIsrRequest(partitionStateInfo, (Set)brokers.toSet(), controllerId, staleControllerEpoch, 0, "");
        controllerChannelManager.sendRequest(this.brokerId2(), (RequestOrResponse)leaderAndIsrRequest, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderElectionTest $outer;

            public final void apply(RequestOrResponse response) {
                this.$outer.kafka$server$LeaderElectionTest$$staleControllerEpochCallback(response);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderElectionTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.staleControllerEpochDetected();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, "Controller epoch should be stale", TestUtils$.MODULE$.waitUntilTrue$default$3());
        Assert.assertTrue((String)"Stale controller epoch not detected by the broker", (boolean)this.staleControllerEpochDetected());
        controllerChannelManager.shutdown();
    }

    public void kafka$server$LeaderElectionTest$$staleControllerEpochCallback(RequestOrResponse response) {
        LeaderAndIsrResponse leaderAndIsrResponse = (LeaderAndIsrResponse)response;
        short s = leaderAndIsrResponse.errorCode();
        boolean bl = ErrorMapping$.MODULE$.StaleControllerEpochCode() == s;
        this.staleControllerEpochDetected_$eq(bl);
    }

    public LeaderElectionTest() {
        ZooKeeperTestHarness$class.$init$(this);
        this.brokerId1 = 0;
        this.brokerId2 = 1;
        this.port1 = TestUtils$.MODULE$.choosePort();
        this.port2 = TestUtils$.MODULE$.choosePort();
        this.configProps1 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.port1(), false);
        this.configProps2 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.port2(), false);
        this.servers = (Seq)Seq$.MODULE$.empty();
        this.staleControllerEpochDetected = false;
    }
}

