/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import junit.framework.Assert;
import kafka.api.ConsumerMetadataRequest;
import kafka.api.ConsumerMetadataRequest$;
import kafka.api.ConsumerMetadataResponse;
import kafka.api.OffsetCommitRequest;
import kafka.api.OffsetCommitRequest$;
import kafka.api.OffsetCommitResponse;
import kafka.api.OffsetFetchRequest;
import kafka.api.OffsetFetchRequest$;
import kafka.api.OffsetFetchResponse;
import kafka.common.ErrorMapping$;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.common.OffsetMetadataAndError;
import kafka.common.OffsetMetadataAndError$;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import kafka.utils.Utils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u0001\u0003\u0001\u001d\u0011\u0001c\u00144gg\u0016$8i\\7nSR$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u0013!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!a\u0003&V]&$8gU;ji\u0016\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u0005i\\\u0017BA\f\u0015\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\b=\u0001\u0011\r\u0011\"\u0001 \u0003\u0019\u0011\u0018M\u001c3p[V\t\u0001\u0005\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005!Q\u000f^5m\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014#\u0005\u0019\u0011\u0016M\u001c3p[\"1\u0011\u0006\u0001Q\u0001\n\u0001\nqA]1oI>l\u0007\u0005C\u0004,\u0001\u0001\u0007I\u0011\u0001\u0017\u0002\r1|w\rR5s+\u0005i\u0003C\u0001\u00184\u001b\u0005y#B\u0001\u00192\u0003\tIwNC\u00013\u0003\u0011Q\u0017M^1\n\u0005Qz#\u0001\u0002$jY\u0016DqA\u000e\u0001A\u0002\u0013\u0005q'\u0001\u0006m_\u001e$\u0015N]0%KF$\"\u0001\u000f\u001f\u0011\u0005eRT\"\u0001\u0013\n\u0005m\"#\u0001B+oSRDq!P\u001b\u0002\u0002\u0003\u0007Q&A\u0002yIEBaa\u0010\u0001!B\u0013i\u0013a\u00027pO\u0012K'\u000f\t\u0005\b\u0003\u0002\u0001\r\u0011\"\u0001-\u0003-!x\u000e]5d\u0019><G)\u001b:\t\u000f\r\u0003\u0001\u0019!C\u0001\t\u0006yAo\u001c9jG2{w\rR5s?\u0012*\u0017\u000f\u0006\u00029\u000b\"9QHQA\u0001\u0002\u0004i\u0003BB$\u0001A\u0003&Q&\u0001\u0007u_BL7\rT8h\t&\u0014\b\u0005C\u0004\u0004\u0001\u0001\u0007I\u0011A%\u0016\u0003)\u0003\"\u0001H&\n\u00051\u0013!aC&bM.\f7+\u001a:wKJDqA\u0014\u0001A\u0002\u0013\u0005q*\u0001\u0006tKJ4XM]0%KF$\"\u0001\u000f)\t\u000fuj\u0015\u0011!a\u0001\u0015\"1!\u000b\u0001Q!\n)\u000bqa]3sm\u0016\u0014\b\u0005C\u0004U\u0001\u0001\u0007I\u0011A+\u0002\u000f1|wmU5{KV\ta\u000b\u0005\u0002:/&\u0011\u0001\f\n\u0002\u0004\u0013:$\bb\u0002.\u0001\u0001\u0004%\taW\u0001\fY><7+\u001b>f?\u0012*\u0017\u000f\u0006\u000299\"9Q(WA\u0001\u0002\u00041\u0006B\u00020\u0001A\u0003&a+\u0001\u0005m_\u001e\u001c\u0016N_3!\u0011\u001d\u0001\u0007A1A\u0005\u0002U\u000b!B\u0019:pW\u0016\u0014\bk\u001c:u\u0011\u0019\u0011\u0007\u0001)A\u0005-\u0006Y!M]8lKJ\u0004vN\u001d;!\u0011\u001d!\u0007A1A\u0005\u0002\u0015\fQa\u001a:pkB,\u0012A\u001a\t\u0003O*l\u0011\u0001\u001b\u0006\u0003SF\nA\u0001\\1oO&\u00111\u000e\u001b\u0002\u0007'R\u0014\u0018N\\4\t\r5\u0004\u0001\u0015!\u0003g\u0003\u00199'o\\;qA!9q\u000e\u0001a\u0001\n\u0003\u0001\u0018AD:j[BdWmQ8ogVlWM]\u000b\u0002cB\u0011!/^\u0007\u0002g*\u0011A\u000fB\u0001\tG>t7/^7fe&\u0011ao\u001d\u0002\u000f'&l\u0007\u000f\\3D_:\u001cX/\\3s\u0011\u001dA\b\u00011A\u0005\u0002e\f!c]5na2,7i\u001c8tk6,'o\u0018\u0013fcR\u0011\u0001H\u001f\u0005\b{]\f\t\u00111\u0001r\u0011\u0019a\b\u0001)Q\u0005c\u0006y1/[7qY\u0016\u001cuN\\:v[\u0016\u0014\b\u0005C\u0004\u007f\u0001\u0001\u0007I\u0011A@\u0002\tQLW.Z\u000b\u0003\u0003\u0003\u0001B!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000f!\u0011!B;uS2\u001c\u0018\u0002BA\u0006\u0003\u000b\u0011A\u0001V5nK\"I\u0011q\u0002\u0001A\u0002\u0013\u0005\u0011\u0011C\u0001\ti&lWm\u0018\u0013fcR\u0019\u0001(a\u0005\t\u0013u\ni!!AA\u0002\u0005\u0005\u0001\u0002CA\f\u0001\u0001\u0006K!!\u0001\u0002\u000bQLW.\u001a\u0011\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u001e\u0005)1/\u001a;VaR\t\u0001\b\u000b\u0003\u0002\u001a\u0005\u0005\u0002\u0003BA\u0012\u0003Oi!!!\n\u000b\u0005-q\u0011\u0002BA\u0015\u0003K\u0011aAQ3g_J,\u0007bBA\u0017\u0001\u0011\u0005\u0013QD\u0001\ti\u0016\f'\u000fR8x]\"\"\u00111FA\u0019!\u0011\t\u0019#a\r\n\t\u0005U\u0012Q\u0005\u0002\u0006\u0003\u001a$XM\u001d\u0005\b\u0003s\u0001A\u0011AA\u000f\u0003E!Xm\u001d;Va\u0012\fG/Z(gMN,Go\u001d\u0015\u0005\u0003o\ti\u0004\u0005\u0003\u0002$\u0005}\u0012\u0002BA!\u0003K\u0011A\u0001V3ti\"9\u0011Q\t\u0001\u0005\u0002\u0005u\u0011!\u0007;fgR\u001cu.\\7ji\u0006sGMR3uG\"|eMZ:fiNDC!a\u0011\u0002>!9\u00111\n\u0001\u0005\u0002\u0005u\u0011\u0001\u0007;fgRd\u0015M]4f\u001b\u0016$\u0018\rZ1uCB\u000b\u0017\u0010\\8bI\"\"\u0011\u0011JA\u001f\u0001")
public class OffsetCommitTest
extends JUnit3Suite
implements ZooKeeperTestHarness {
    private final Random random;
    private File logDir;
    private File topicLogDir;
    private KafkaServer server;
    private int logSize;
    private final int brokerPort;
    private final String group;
    private SimpleConsumer simpleConsumer;
    private Time time;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    public Random random() {
        return this.random;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public File topicLogDir() {
        return this.topicLogDir;
    }

    public void topicLogDir_$eq(File x$1) {
        this.topicLogDir = x$1;
    }

    public KafkaServer server() {
        return this.server;
    }

    public void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    public int logSize() {
        return this.logSize;
    }

    public void logSize_$eq(int x$1) {
        this.logSize = x$1;
    }

    public int brokerPort() {
        return this.brokerPort;
    }

    public String group() {
        return this.group;
    }

    public SimpleConsumer simpleConsumer() {
        return this.simpleConsumer;
    }

    public void simpleConsumer_$eq(SimpleConsumer x$1) {
        this.simpleConsumer = x$1;
    }

    public Time time() {
        return this.time;
    }

    public void time_$eq(Time x$1) {
        this.time = x$1;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        Properties config = TestUtils$.MODULE$.createBrokerConfig(1, this.brokerPort(), TestUtils$.MODULE$.createBrokerConfig$default$3());
        config.put("offsets.topic.replication.factor", "1");
        String logDirPath = config.getProperty("log.dir");
        this.logDir_$eq(new File(logDirPath));
        this.time_$eq(new MockTime());
        this.server_$eq(TestUtils$.MODULE$.createServer(new KafkaConfig(config), this.time()));
        this.simpleConsumer_$eq(new SimpleConsumer("localhost", this.brokerPort(), 1000000, 65536, "test-client"));
        ConsumerMetadataRequest consumerMetadataRequest = new ConsumerMetadataRequest(this.group(), ConsumerMetadataRequest$.MODULE$.apply$default$2(), ConsumerMetadataRequest$.MODULE$.apply$default$3(), ConsumerMetadataRequest$.MODULE$.apply$default$4());
        package$.MODULE$.Stream().continually((Function0)new Serializable(this, consumerMetadataRequest){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetCommitTest $outer;
            private final ConsumerMetadataRequest consumerMetadataRequest$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                ConsumerMetadataResponse consumerMetadataResponse = this.$outer.simpleConsumer().send(this.consumerMetadataRequest$1);
                return consumerMetadataResponse.coordinatorOpt().isDefined();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.consumerMetadataRequest$1 = consumerMetadataRequest$1;
            }
        }).dropWhile((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(boolean success) {
                if (!success) {
                    Thread.sleep(1000L);
                }
                return !success;
            }
        });
    }

    @Override
    @After
    public void tearDown() {
        this.simpleConsumer().close();
        this.server().shutdown();
        Utils$.MODULE$.rm(this.logDir());
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void testUpdateOffsets() {
        String topic = "topic";
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, 0);
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))));
        OffsetCommitRequest commitRequest = new OffsetCommitRequest(this.group(), (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition), (Object)new OffsetAndMetadata(42L, OffsetAndMetadata$.MODULE$.apply$default$2(), OffsetAndMetadata$.MODULE$.apply$default$3()))})), OffsetCommitRequest$.MODULE$.apply$default$3(), OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7());
        OffsetCommitResponse commitResponse = this.simpleConsumer().commitOffsets(commitRequest);
        Assert.assertEquals((short)ErrorMapping$.MODULE$.NoError(), (short)BoxesRunTime.unboxToShort((Object)commitResponse.commitStatus().get((Object)topicAndPartition).get()));
        OffsetFetchRequest fetchRequest = new OffsetFetchRequest(this.group(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{topicAndPartition})), OffsetFetchRequest$.MODULE$.apply$default$3(), OffsetFetchRequest$.MODULE$.apply$default$4(), OffsetFetchRequest$.MODULE$.apply$default$5());
        OffsetFetchResponse fetchResponse = this.simpleConsumer().fetchOffsets(fetchRequest);
        Assert.assertEquals((short)ErrorMapping$.MODULE$.NoError(), (short)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)topicAndPartition).get()).error());
        Assert.assertEquals((String)OffsetAndMetadata$.MODULE$.NoMetadata(), (String)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)topicAndPartition).get()).metadata());
        Assert.assertEquals((long)42L, (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)topicAndPartition).get()).offset());
        OffsetCommitRequest commitRequest1 = new OffsetCommitRequest(this.group(), (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition), (Object)new OffsetAndMetadata(100L, "some metadata", OffsetAndMetadata$.MODULE$.apply$default$3()))})), OffsetCommitRequest$.MODULE$.apply$default$3(), OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7());
        OffsetCommitResponse commitResponse1 = this.simpleConsumer().commitOffsets(commitRequest1);
        Assert.assertEquals((short)ErrorMapping$.MODULE$.NoError(), (short)BoxesRunTime.unboxToShort((Object)commitResponse1.commitStatus().get((Object)topicAndPartition).get()));
        OffsetFetchRequest fetchRequest1 = new OffsetFetchRequest(this.group(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{topicAndPartition})), OffsetFetchRequest$.MODULE$.apply$default$3(), OffsetFetchRequest$.MODULE$.apply$default$4(), OffsetFetchRequest$.MODULE$.apply$default$5());
        OffsetFetchResponse fetchResponse1 = this.simpleConsumer().fetchOffsets(fetchRequest1);
        Assert.assertEquals((short)ErrorMapping$.MODULE$.NoError(), (short)((OffsetMetadataAndError)fetchResponse1.requestInfo().get((Object)topicAndPartition).get()).error());
        Assert.assertEquals((String)"some metadata", (String)((OffsetMetadataAndError)fetchResponse1.requestInfo().get((Object)topicAndPartition).get()).metadata());
        Assert.assertEquals((long)100L, (long)((OffsetMetadataAndError)fetchResponse1.requestInfo().get((Object)topicAndPartition).get()).offset());
        TopicAndPartition unknownTopicAndPartition = new TopicAndPartition("unknownTopic", 0);
        OffsetFetchRequest fetchRequest2 = new OffsetFetchRequest(this.group(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{unknownTopicAndPartition})), OffsetFetchRequest$.MODULE$.apply$default$3(), OffsetFetchRequest$.MODULE$.apply$default$4(), OffsetFetchRequest$.MODULE$.apply$default$5());
        OffsetFetchResponse fetchResponse2 = this.simpleConsumer().fetchOffsets(fetchRequest2);
        Assert.assertEquals((Object)OffsetMetadataAndError$.MODULE$.UnknownTopicOrPartition(), (Object)fetchResponse2.requestInfo().get((Object)unknownTopicAndPartition).get());
        Assert.assertEquals((int)1, (int)fetchResponse2.requestInfo().size());
    }

    @Test
    public void testCommitAndFetchOffsets() {
        String topic1 = "topic-1";
        String topic2 = "topic-2";
        String topic3 = "topic-3";
        String topic4 = "topic-4";
        String topic5 = "topic-5";
        ZkClient x$1 = this.zkClient();
        String x$2 = topic1;
        Seq x$3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}));
        int x$4 = 1;
        int x$5 = TestUtils$.MODULE$.createTopic$default$4();
        Properties x$6 = TestUtils$.MODULE$.createTopic$default$6();
        TestUtils$.MODULE$.createTopic(x$1, x$2, x$4, x$5, (Seq<KafkaServer>)x$3, x$6);
        ZkClient x$7 = this.zkClient();
        String x$8 = topic2;
        Seq x$9 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}));
        int x$10 = 2;
        int x$11 = TestUtils$.MODULE$.createTopic$default$4();
        Properties x$12 = TestUtils$.MODULE$.createTopic$default$6();
        TestUtils$.MODULE$.createTopic(x$7, x$8, x$10, x$11, (Seq<KafkaServer>)x$9, x$12);
        ZkClient x$13 = this.zkClient();
        String x$14 = topic3;
        Seq x$15 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}));
        int x$16 = 1;
        int x$17 = TestUtils$.MODULE$.createTopic$default$4();
        Properties x$18 = TestUtils$.MODULE$.createTopic$default$6();
        TestUtils$.MODULE$.createTopic(x$13, x$14, x$16, x$17, (Seq<KafkaServer>)x$15, x$18);
        ZkClient x$19 = this.zkClient();
        String x$20 = topic4;
        Seq x$21 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}));
        int x$22 = 1;
        int x$23 = TestUtils$.MODULE$.createTopic$default$4();
        Properties x$24 = TestUtils$.MODULE$.createTopic$default$6();
        TestUtils$.MODULE$.createTopic(x$19, x$20, x$22, x$23, (Seq<KafkaServer>)x$21, x$24);
        OffsetCommitRequest commitRequest = new OffsetCommitRequest("test-group", (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(topic1, 0)), (Object)new OffsetAndMetadata(42L, "metadata one", OffsetAndMetadata$.MODULE$.apply$default$3())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(topic2, 0)), (Object)new OffsetAndMetadata(43L, "metadata two", OffsetAndMetadata$.MODULE$.apply$default$3())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(topic3, 0)), (Object)new OffsetAndMetadata(44L, "metadata three", OffsetAndMetadata$.MODULE$.apply$default$3())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(topic2, 1)), (Object)new OffsetAndMetadata(45L, OffsetAndMetadata$.MODULE$.apply$default$2(), OffsetAndMetadata$.MODULE$.apply$default$3()))})), OffsetCommitRequest$.MODULE$.apply$default$3(), OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7());
        OffsetCommitResponse commitResponse = this.simpleConsumer().commitOffsets(commitRequest);
        Assert.assertEquals((short)ErrorMapping$.MODULE$.NoError(), (short)BoxesRunTime.unboxToShort((Object)commitResponse.commitStatus().get((Object)new TopicAndPartition(topic1, 0)).get()));
        Assert.assertEquals((short)ErrorMapping$.MODULE$.NoError(), (short)BoxesRunTime.unboxToShort((Object)commitResponse.commitStatus().get((Object)new TopicAndPartition(topic2, 0)).get()));
        Assert.assertEquals((short)ErrorMapping$.MODULE$.NoError(), (short)BoxesRunTime.unboxToShort((Object)commitResponse.commitStatus().get((Object)new TopicAndPartition(topic3, 0)).get()));
        Assert.assertEquals((short)ErrorMapping$.MODULE$.NoError(), (short)BoxesRunTime.unboxToShort((Object)commitResponse.commitStatus().get((Object)new TopicAndPartition(topic2, 1)).get()));
        OffsetFetchRequest fetchRequest = new OffsetFetchRequest(this.group(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition(topic1, 0), new TopicAndPartition(topic2, 0), new TopicAndPartition(topic3, 0), new TopicAndPartition(topic2, 1), new TopicAndPartition(topic3, 1), new TopicAndPartition(topic4, 0), new TopicAndPartition(topic5, 0)})), OffsetFetchRequest$.MODULE$.apply$default$3(), OffsetFetchRequest$.MODULE$.apply$default$4(), OffsetFetchRequest$.MODULE$.apply$default$5());
        OffsetFetchResponse fetchResponse = this.simpleConsumer().fetchOffsets(fetchRequest);
        Assert.assertEquals((short)ErrorMapping$.MODULE$.NoError(), (short)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic1, 0)).get()).error());
        Assert.assertEquals((short)ErrorMapping$.MODULE$.NoError(), (short)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic2, 0)).get()).error());
        Assert.assertEquals((short)ErrorMapping$.MODULE$.NoError(), (short)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic3, 0)).get()).error());
        Assert.assertEquals((short)ErrorMapping$.MODULE$.NoError(), (short)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic2, 1)).get()).error());
        Assert.assertEquals((short)ErrorMapping$.MODULE$.UnknownTopicOrPartitionCode(), (short)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic3, 1)).get()).error());
        Assert.assertEquals((short)ErrorMapping$.MODULE$.NoError(), (short)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic4, 0)).get()).error());
        Assert.assertEquals((short)ErrorMapping$.MODULE$.UnknownTopicOrPartitionCode(), (short)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic5, 0)).get()).error());
        Assert.assertEquals((Object)OffsetMetadataAndError$.MODULE$.UnknownTopicOrPartition(), (Object)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic3, 1)).get());
        Assert.assertEquals((Object)OffsetMetadataAndError$.MODULE$.NoOffset(), (Object)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic4, 0)).get());
        Assert.assertEquals((Object)OffsetMetadataAndError$.MODULE$.UnknownTopicOrPartition(), (Object)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic5, 0)).get());
        Assert.assertEquals((String)"metadata one", (String)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic1, 0)).get()).metadata());
        Assert.assertEquals((String)"metadata two", (String)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic2, 0)).get()).metadata());
        Assert.assertEquals((String)"metadata three", (String)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic3, 0)).get()).metadata());
        Assert.assertEquals((String)OffsetAndMetadata$.MODULE$.NoMetadata(), (String)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic2, 1)).get()).metadata());
        Assert.assertEquals((String)OffsetAndMetadata$.MODULE$.NoMetadata(), (String)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic3, 1)).get()).metadata());
        Assert.assertEquals((String)OffsetAndMetadata$.MODULE$.NoMetadata(), (String)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic4, 0)).get()).metadata());
        Assert.assertEquals((String)OffsetAndMetadata$.MODULE$.NoMetadata(), (String)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic5, 0)).get()).metadata());
        Assert.assertEquals((long)42L, (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic1, 0)).get()).offset());
        Assert.assertEquals((long)43L, (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic2, 0)).get()).offset());
        Assert.assertEquals((long)44L, (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic3, 0)).get()).offset());
        Assert.assertEquals((long)45L, (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic2, 1)).get()).offset());
        Assert.assertEquals((long)OffsetAndMetadata$.MODULE$.InvalidOffset(), (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic3, 1)).get()).offset());
        Assert.assertEquals((long)OffsetAndMetadata$.MODULE$.InvalidOffset(), (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic4, 0)).get()).offset());
        Assert.assertEquals((long)OffsetAndMetadata$.MODULE$.InvalidOffset(), (long)((OffsetMetadataAndError)fetchResponse.requestInfo().get((Object)new TopicAndPartition(topic5, 0)).get()).offset());
    }

    @Test
    public void testLargeMetadataPayload() {
        TopicAndPartition topicAndPartition = new TopicAndPartition("large-metadata", 0);
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topicAndPartition.topic(), (Map<Object, Seq<Object>>)expectedReplicaAssignment, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server()}))));
        OffsetCommitRequest commitRequest = new OffsetCommitRequest("test-group", (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition), (Object)new OffsetAndMetadata(42L, this.random().nextString(this.server().config().offsetMetadataMaxSize()), OffsetAndMetadata$.MODULE$.apply$default$3()))})), OffsetCommitRequest$.MODULE$.apply$default$3(), OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7());
        OffsetCommitResponse commitResponse = this.simpleConsumer().commitOffsets(commitRequest);
        Assert.assertEquals((short)ErrorMapping$.MODULE$.NoError(), (short)BoxesRunTime.unboxToShort((Object)commitResponse.commitStatus().get((Object)topicAndPartition).get()));
        OffsetCommitRequest commitRequest1 = new OffsetCommitRequest(this.group(), (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition), (Object)new OffsetAndMetadata(42L, this.random().nextString(this.server().config().offsetMetadataMaxSize() + 1), OffsetAndMetadata$.MODULE$.apply$default$3()))})), OffsetCommitRequest$.MODULE$.apply$default$3(), OffsetCommitRequest$.MODULE$.apply$default$4(), OffsetCommitRequest$.MODULE$.apply$default$5(), OffsetCommitRequest$.MODULE$.apply$default$6(), OffsetCommitRequest$.MODULE$.apply$default$7());
        OffsetCommitResponse commitResponse1 = this.simpleConsumer().commitOffsets(commitRequest1);
        Assert.assertEquals((short)ErrorMapping$.MODULE$.OffsetMetadataTooLargeCode(), (short)BoxesRunTime.unboxToShort((Object)commitResponse1.commitStatus().get((Object)topicAndPartition).get()));
    }

    public OffsetCommitTest() {
        ZooKeeperTestHarness$class.$init$(this);
        this.random = new Random();
        this.logDir = null;
        this.topicLogDir = null;
        this.server = null;
        this.logSize = 100;
        this.brokerPort = 9099;
        this.group = "test-group";
        this.simpleConsumer = null;
        this.time = new MockTime();
    }
}

