/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Properties;
import java.util.Random;
import junit.framework.Assert;
import kafka.admin.AdminUtils$;
import kafka.api.LeaderAndIsr;
import kafka.api.PartitionStateInfo;
import kafka.api.ProducerRequest;
import kafka.api.Request$;
import kafka.api.RequestOrResponse;
import kafka.cluster.Broker;
import kafka.cluster.Partition;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.KafkaStream;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.NoCompressionCodec$;
import kafka.producer.DefaultPartitioner;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.producer.SyncProducerConfig$;
import kafka.serializer.DefaultEncoder;
import kafka.serializer.StringEncoder;
import kafka.server.BrokerState;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.FixedValuePartitioner;
import kafka.utils.IntEncoder;
import kafka.utils.IteratorTemplate;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.SystemTime$;
import kafka.utils.TestUtils$;
import kafka.utils.TestUtils$$anonfun$getMessages$2$;
import kafka.utils.TestZKUtils$;
import kafka.utils.Time;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class TestUtils$
implements Logging {
    public static final TestUtils$ MODULE$;
    private final String IoTmpDir;
    private final String Letters;
    private final String Digits;
    private final String LettersAndDigits;
    private final Random seededRandom;
    private final Random random;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new TestUtils$();
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TestUtils$ testUtils$ = this;
        synchronized (testUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public String IoTmpDir() {
        return this.IoTmpDir;
    }

    public String Letters() {
        return this.Letters;
    }

    public String Digits() {
        return this.Digits;
    }

    public String LettersAndDigits() {
        return this.LettersAndDigits;
    }

    public Random seededRandom() {
        return this.seededRandom;
    }

    public Random random() {
        return this.random;
    }

    public List<Object> choosePorts(int count) {
        IndexedSeq sockets = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ServerSocket apply(int i) {
                return new ServerSocket(0);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        List socketList = sockets.toList();
        List ports = (List)socketList.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(ServerSocket x$1) {
                return x$1.getLocalPort();
            }
        }, List$.MODULE$.canBuildFrom());
        socketList.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(ServerSocket x$2) {
                x$2.close();
            }
        }, List$.MODULE$.canBuildFrom());
        return ports;
    }

    public int choosePort() {
        return BoxesRunTime.unboxToInt((Object)this.choosePorts(1).head());
    }

    /*
     * WARNING - void declaration
     */
    public File tempDir() {
        void var1_1;
        File f = new File(this.IoTmpDir(), new StringBuilder().append((Object)"kafka-").append((Object)BoxesRunTime.boxToInteger((int)this.random().nextInt(1000000))).toString());
        f.mkdirs();
        f.deleteOnExit();
        Runtime.getRuntime().addShutdownHook(new Thread(f){
            private final File f$1;

            public void run() {
                Utils$.MODULE$.rm(this.f$1);
            }
            {
                this.f$1 = f$1;
            }
        });
        return var1_1;
    }

    public String tempTopic() {
        return new StringBuilder().append((Object)"testTopic").append((Object)BoxesRunTime.boxToInteger((int)this.random().nextInt(1000000))).toString();
    }

    /*
     * WARNING - void declaration
     */
    public File tempRelativeDir(String parent) {
        void var2_2;
        File f = new File(parent, new StringBuilder().append((Object)"kafka-").append((Object)BoxesRunTime.boxToInteger((int)this.random().nextInt(1000000))).toString());
        f.mkdirs();
        f.deleteOnExit();
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public File tempFile() {
        void var1_1;
        File f = File.createTempFile("kafka", ".tmp");
        f.deleteOnExit();
        return var1_1;
    }

    public FileChannel tempChannel() {
        return new RandomAccessFile(this.tempFile(), "rw").getChannel();
    }

    /*
     * WARNING - void declaration
     */
    public KafkaServer createServer(KafkaConfig config, Time time) {
        void var3_3;
        KafkaServer server = new KafkaServer(config, time);
        server.startup();
        return var3_3;
    }

    public Time createServer$default$2() {
        return SystemTime$.MODULE$;
    }

    public List<Properties> createBrokerConfigs(int numConfigs, boolean enableControlledShutdown) {
        return (List)((TraversableLike)this.choosePorts(numConfigs).zipWithIndex(List$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(enableControlledShutdown){
            public static final long serialVersionUID = 0L;
            private final boolean enableControlledShutdown$1;

            public final Properties apply(Tuple2<Object, Object> x$3) {
                Tuple2<Object, Object> tuple2 = x$3;
                if (tuple2 != null) {
                    int port = tuple2._1$mcI$sp();
                    int node = tuple2._2$mcI$sp();
                    Properties properties = TestUtils$.MODULE$.createBrokerConfig(node, port, this.enableControlledShutdown$1);
                    return properties;
                }
                throw new MatchError(tuple2);
            }
            {
                this.enableControlledShutdown$1 = enableControlledShutdown$1;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public String getBrokerListStrFromConfigs(Seq<KafkaConfig> configs) {
        return ((TraversableOnce)configs.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(KafkaConfig c) {
                return Utils.formatAddress((String)c.hostName(), (Integer)Predef$.MODULE$.int2Integer(c.port()));
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    public Properties createBrokerConfig(int nodeId, int port, boolean enableControlledShutdown) {
        Properties props = new Properties();
        props.put("broker.id", ((Object)BoxesRunTime.boxToInteger((int)nodeId)).toString());
        props.put("host.name", "localhost");
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)port)).toString());
        props.put("log.dir", this.tempDir().getAbsolutePath());
        props.put("zookeeper.connect", TestZKUtils$.MODULE$.zookeeperConnect());
        props.put("replica.socket.timeout.ms", "1500");
        props.put("controlled.shutdown.enable", ((Object)BoxesRunTime.boxToBoolean((boolean)enableControlledShutdown)).toString());
        return props;
    }

    public int createBrokerConfig$default$2() {
        return this.choosePort();
    }

    public boolean createBrokerConfig$default$3() {
        return true;
    }

    public boolean createBrokerConfigs$default$2() {
        return true;
    }

    public scala.collection.immutable.Map<Object, Option<Object>> createTopic(ZkClient zkClient, String topic, int numPartitions, int replicationFactor, Seq<KafkaServer> servers, Properties topicConfig) {
        AdminUtils$.MODULE$.createTopic(zkClient, topic, numPartitions, replicationFactor, topicConfig);
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1)new Serializable(zkClient, topic, servers){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$2;
            private final String topic$2;
            private final Seq servers$2;

            public final Tuple2<Object, Option<Object>> apply(int x0$1) {
                int n = x0$1;
                TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers$2, this.topic$2, n, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n)), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient$2, this.topic$2, n, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6()));
                return tuple2;
            }
            {
                this.zkClient$2 = zkClient$2;
                this.topic$2 = topic$2;
                this.servers$2 = servers$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public scala.collection.immutable.Map<Object, Option<Object>> createTopic(ZkClient zkClient, String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Seq<KafkaServer> servers) {
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(zkClient, topic, partitionReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        return ((TraversableOnce)partitionReplicaAssignment.keySet().map((Function1)new Serializable(zkClient, topic, servers){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$1;
            private final String topic$1;
            private final Seq servers$1;

            public final Tuple2<Object, Option<Object>> apply(int x0$2) {
                int n = x0$2;
                TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers$1, this.topic$1, n, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n)), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient$1, this.topic$1, n, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6()));
                return tuple2;
            }
            {
                this.zkClient$1 = zkClient$1;
                this.topic$1 = topic$1;
                this.servers$1 = servers$1;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public int createTopic$default$3() {
        return 1;
    }

    public int createTopic$default$4() {
        return 1;
    }

    public Properties createTopic$default$6() {
        return new Properties();
    }

    public Properties createConsumerProperties(String zkConnect, String groupId, String consumerId, long consumerTimeout) {
        Properties props = new Properties();
        props.put("zookeeper.connect", zkConnect);
        props.put("group.id", groupId);
        props.put("consumer.id", consumerId);
        props.put("consumer.timeout.ms", ((Object)BoxesRunTime.boxToLong((long)consumerTimeout)).toString());
        props.put("zookeeper.session.timeout.ms", "6000");
        props.put("zookeeper.sync.time.ms", "200");
        props.put("auto.commit.interval.ms", "1000");
        props.put("rebalance.max.retries", "4");
        props.put("auto.offset.reset", "smallest");
        props.put("num.consumer.fetchers", "2");
        return props;
    }

    public long createConsumerProperties$default$4() {
        return -1L;
    }

    public ByteBufferMessageSet singleMessageSet(byte[] payload, CompressionCodec codec, byte[] key) {
        return new ByteBufferMessageSet(codec, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(payload, key)}));
    }

    public CompressionCodec singleMessageSet$default$2() {
        return NoCompressionCodec$.MODULE$;
    }

    public byte[] singleMessageSet$default$3() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] randomBytes(int numBytes) {
        void var2_2;
        byte[] bytes = new byte[numBytes];
        this.seededRandom().nextBytes(bytes);
        return var2_2;
    }

    public String randomString(int len) {
        StringBuilder b = new StringBuilder();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).foreach((Function1)new Serializable(b){
            public static final long serialVersionUID = 0L;
            private final StringBuilder b$1;

            public final StringBuilder apply(int i) {
                return this.b$1.append(TestUtils$.MODULE$.LettersAndDigits().charAt(TestUtils$.MODULE$.seededRandom().nextInt(TestUtils$.MODULE$.LettersAndDigits().length())));
            }
            {
                this.b$1 = b$1;
            }
        });
        return b.toString();
    }

    public void checkEquals(ByteBuffer b1, ByteBuffer b2) {
        Assert.assertEquals((String)"Buffers should have equal length", (int)(b1.limit() - b1.position()), (int)(b2.limit() - b2.position()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), b1.limit() - b1.position()).foreach$mVc$sp((Function1)new Serializable(b1, b2){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer b1$1;
            private final ByteBuffer b2$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((String)new StringBuilder().append((Object)"byte ").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)" byte not equal.").toString(), (byte)this.b1$1.get(this.b1$1.position() + i), (byte)this.b2$1.get(this.b1$1.position() + i));
            }
            {
                this.b1$1 = b1$1;
                this.b2$1 = b2$1;
            }
        });
    }

    public <T> void checkEquals(Iterator<T> expected, Iterator<T> actual) {
        int length = 0;
        while (expected.hasNext() && actual.hasNext()) {
            ++length;
            Assert.assertEquals((Object)expected.next(), (Object)actual.next());
        }
        if (expected.hasNext()) {
            int length1 = length;
            while (expected.hasNext()) {
                expected.next();
                ++length1;
            }
            Assert.assertFalse((String)new StringBuilder().append((Object)"Iterators have uneven length-- first has more: ").append((Object)BoxesRunTime.boxToInteger((int)length1)).append((Object)" > ").append((Object)BoxesRunTime.boxToInteger((int)length)).toString(), (boolean)true);
        }
        if (actual.hasNext()) {
            int length2 = length;
            while (actual.hasNext()) {
                actual.next();
                ++length2;
            }
            Assert.assertFalse((String)new StringBuilder().append((Object)"Iterators have uneven length-- second has more: ").append((Object)BoxesRunTime.boxToInteger((int)length2)).append((Object)" > ").append((Object)BoxesRunTime.boxToInteger((int)length)).toString(), (boolean)true);
        }
    }

    public <T> void checkLength(Iterator<T> s1, int expectedLength) {
        int n = 0;
        while (s1.hasNext()) {
            ++n;
            s1.next();
        }
        Assert.assertEquals((int)expectedLength, (int)n);
    }

    public <T> void checkEquals(java.util.Iterator<T> s1, java.util.Iterator<T> s2) {
        while (s1.hasNext() && s2.hasNext()) {
            Assert.assertEquals(s1.next(), s2.next());
        }
        Assert.assertFalse((String)"Iterators have uneven length--first has more", (boolean)s1.hasNext());
        Assert.assertFalse((String)"Iterators have uneven length--second has more", (boolean)s2.hasNext());
    }

    public <T> Iterator<T> stackedIterator(Seq<Iterator<T>> s) {
        return new Iterator<T>(s){
            private Iterator<T> cur;
            private final Iterator<Iterator<T>> topIterator;

            public Iterator<T> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<T> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<T> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<T> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<T, B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<T, GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<T> filter(Function1<T, Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<T, B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<T> withFilter(Function1<T, Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<T> filterNot(Function1<T, Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<T, B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, T, B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<T, B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<T> takeWhile(Function1<T, Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> partition(Function1<T, Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> span(Function1<T, Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<T> dropWhile(Function1<T, Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<T, B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<T, Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<T, U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<T, Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<T, Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<T> find(Function1<T, Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<T, Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<T> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.class.grouped((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<T>, Iterator<T>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<T> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<T> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<T> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<T> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<T, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<T, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, T, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<T, B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, T, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<T, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(B z, Function2<B, T, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public <B> T min(Ordering<B> cmp) {
                return (T)TraversableOnce.class.min((TraversableOnce)this, cmp);
            }

            public <B> T max(Ordering<B> cmp) {
                return (T)TraversableOnce.class.max((TraversableOnce)this, cmp);
            }

            public <B> T maxBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.class.maxBy((TraversableOnce)this, f, cmp);
            }

            public <B> T minBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.class.minBy((TraversableOnce)this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<T> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<T> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<T> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<T> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<T> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, T, Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<T, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            public <A1> A1 $div$colon$bslash(A1 z, Function2<A1, A1, A1> op) {
                return (A1)GenTraversableOnce.class.$div$colon$bslash((GenTraversableOnce)this, z, op);
            }

            private Iterator<T> cur() {
                return this.cur;
            }

            private void cur_$eq(Iterator<T> x$1) {
                this.cur = x$1;
            }

            private Iterator<Iterator<T>> topIterator() {
                return this.topIterator;
            }

            public boolean hasNext() {
                while (true) {
                    if (this.cur() == null) {
                        if (this.topIterator().hasNext()) {
                            this.cur_$eq((Iterator)this.topIterator().next());
                        } else {
                            return false;
                        }
                    }
                    if (this.cur().hasNext()) {
                        return true;
                    }
                    this.cur_$eq(null);
                }
            }

            public T next() {
                return (T)this.cur().next();
            }
            {
                GenTraversableOnce.class.$init$((GenTraversableOnce)this);
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
                this.cur = null;
                this.topIterator = s$1.iterator();
            }
        };
    }

    public String hexString(byte[] bytes) {
        return this.hexString(ByteBuffer.wrap(bytes));
    }

    public String hexString(ByteBuffer buffer) {
        StringBuilder builder = new StringBuilder("0x");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), buffer.limit()).foreach((Function1)new Serializable(buffer, builder){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer buffer$1;
            private final StringBuilder builder$1;

            public final StringBuilder apply(int i) {
                return this.builder$1.append(String.format("%x", this.buffer$1.get(this.buffer$1.position() + i)));
            }
            {
                this.buffer$1 = buffer$1;
                this.builder$1 = builder$1;
            }
        });
        return builder.toString();
    }

    public <K, V> Producer<K, V> createProducer(String brokerList, String encoder, String keyEncoder, String partitioner, Properties producerProps) {
        Properties props = this.getProducerConfig(brokerList);
        if (producerProps != null) {
            props.putAll((java.util.Map<?, ?>)producerProps);
        }
        props.put("serializer.class", encoder);
        props.put("key.serializer.class", keyEncoder);
        props.put("partitioner.class", partitioner);
        return new Producer(new ProducerConfig(props));
    }

    public <K, V> String createProducer$default$2() {
        return DefaultEncoder.class.getName();
    }

    public <K, V> String createProducer$default$3() {
        return DefaultEncoder.class.getName();
    }

    public <K, V> String createProducer$default$4() {
        return DefaultPartitioner.class.getName();
    }

    public <K, V> Properties createProducer$default$5() {
        return null;
    }

    public KafkaProducer<byte[], byte[]> createNewProducer(String brokerList, int acks, long metadataFetchTimeout, boolean blockOnBufferFull, long bufferSize, int retries) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", brokerList);
        producerProps.put("acks", ((Object)BoxesRunTime.boxToInteger((int)acks)).toString());
        producerProps.put("metadata.fetch.timeout.ms", ((Object)BoxesRunTime.boxToLong((long)metadataFetchTimeout)).toString());
        producerProps.put("block.on.buffer.full", ((Object)BoxesRunTime.boxToBoolean((boolean)blockOnBufferFull)).toString());
        producerProps.put("buffer.memory", ((Object)BoxesRunTime.boxToLong((long)bufferSize)).toString());
        producerProps.put("retries", ((Object)BoxesRunTime.boxToInteger((int)retries)).toString());
        producerProps.put("retry.backoff.ms", "100");
        producerProps.put("reconnect.backoff.ms", "200");
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        return new KafkaProducer(producerProps);
    }

    public int createNewProducer$default$2() {
        return -1;
    }

    public long createNewProducer$default$3() {
        return 3000L;
    }

    public boolean createNewProducer$default$4() {
        return true;
    }

    public long createNewProducer$default$5() {
        return 0x100000L;
    }

    public int createNewProducer$default$6() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public Properties getProducerConfig(String brokerList) {
        void var2_2;
        Properties props = new Properties();
        props.put("metadata.broker.list", brokerList);
        props.put("message.send.max.retries", "5");
        props.put("retry.backoff.ms", "1000");
        props.put("request.timeout.ms", "2000");
        props.put("request.required.acks", "-1");
        props.put("send.buffer.bytes", "65536");
        props.put("connect.timeout.ms", "100000");
        props.put("reconnect.interval", "10000");
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Properties getSyncProducerConfig(int port) {
        void var2_2;
        Properties props = new Properties();
        props.put("host", "localhost");
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)port)).toString());
        props.put("request.timeout.ms", "500");
        props.put("request.required.acks", "1");
        props.put("serializer.class", StringEncoder.class.getName());
        return var2_2;
    }

    public void updateConsumerOffset(ConsumerConfig config, String path, long offset) {
        ZkClient zkClient = new ZkClient(config.zkConnect(), config.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), (ZkSerializer)ZKStringSerializer$.MODULE$);
        ZkUtils$.MODULE$.updatePersistentPath(zkClient, path, ((Object)BoxesRunTime.boxToLong((long)offset)).toString());
    }

    public Iterator<Message> getMessageIterator(Iterator<MessageAndOffset> iter) {
        return new IteratorTemplate<Message>(iter){
            private final Iterator iter$1;

            public Message makeNext() {
                if (this.iter$1.hasNext()) {
                    return ((MessageAndOffset)this.iter$1.next()).message();
                }
                return (Message)this.allDone();
            }
            {
                this.iter$1 = iter$1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Broker> createBrokersInZk(ZkClient zkClient, Seq<Object> ids) {
        void var3_3;
        Seq brokers = (Seq)ids.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Broker apply(int id) {
                return new Broker(id, "localhost", 6667);
            }
        }, Seq$.MODULE$.canBuildFrom());
        brokers.foreach((Function1)new Serializable(zkClient){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$3;

            public final void apply(Broker b) {
                ZkUtils$.MODULE$.registerBrokerInZk(this.zkClient$3, b.id(), b.host(), b.port(), 6000, -1);
            }
            {
                this.zkClient$3 = zkClient$3;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Broker> deleteBrokersInZk(ZkClient zkClient, Seq<Object> ids) {
        void var3_3;
        Seq brokers = (Seq)ids.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Broker apply(int id) {
                return new Broker(id, "localhost", 6667);
            }
        }, Seq$.MODULE$.canBuildFrom());
        brokers.foreach((Function1)new Serializable(zkClient){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$6;

            public final boolean apply(Broker b) {
                return ZkUtils$.MODULE$.deletePath(this.zkClient$6, new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerIdsPath()).append((Object)"/").append((Object)b).toString());
            }
            {
                this.zkClient$6 = zkClient$6;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> getMsgStrings(int n) {
        void var2_2;
        ListBuffer buffer = new ListBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach((Function1)new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            private final ListBuffer buffer$2;

            public final ListBuffer<String> apply(int i) {
                return this.buffer$2.$plus$eq((Object)new StringBuilder().append((Object)"msg").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
            }
            {
                this.buffer$2 = buffer$2;
            }
        });
        return var2_2;
    }

    public ProducerRequest produceRequest(String topic, int partition, ByteBufferMessageSet message, int acks, int timeout, int correlationId, String clientId) {
        return this.produceRequestWithAcks((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{partition}))), message, acks, timeout, correlationId, clientId);
    }

    public int produceRequest$default$4() {
        return SyncProducerConfig$.MODULE$.DefaultRequiredAcks();
    }

    public int produceRequest$default$5() {
        return SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs();
    }

    public int produceRequest$default$6() {
        return 0;
    }

    public String produceRequest$default$7() {
        return SyncProducerConfig$.MODULE$.DefaultClientId();
    }

    public ProducerRequest produceRequestWithAcks(Seq<String> topics, Seq<Object> partitions, ByteBufferMessageSet message, int acks, int timeout, int correlationId, String clientId) {
        Seq data = (Seq)topics.flatMap((Function1)new Serializable(partitions, message){
            public static final long serialVersionUID = 0L;
            private final Seq partitions$1;
            public final ByteBufferMessageSet message$1;

            public final Seq<Tuple2<TopicAndPartition, ByteBufferMessageSet>> apply(String topic) {
                return (Seq)this.partitions$1.map((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.5 $outer;
                    private final String topic$9;

                    public final Tuple2<TopicAndPartition, ByteBufferMessageSet> apply(int partition) {
                        return new Tuple2((Object)new TopicAndPartition(this.topic$9, partition), (Object)this.$outer.message$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.topic$9 = topic$9;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.partitions$1 = partitions$1;
                this.message$1 = message$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new ProducerRequest(correlationId, clientId, (short)acks, timeout, (scala.collection.mutable.Map)Map$.MODULE$.apply(data));
    }

    public int produceRequestWithAcks$default$4() {
        return SyncProducerConfig$.MODULE$.DefaultRequiredAcks();
    }

    public int produceRequestWithAcks$default$5() {
        return SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs();
    }

    public int produceRequestWithAcks$default$6() {
        return 0;
    }

    public String produceRequestWithAcks$default$7() {
        return SyncProducerConfig$.MODULE$.DefaultClientId();
    }

    public void makeLeaderForPartition(ZkClient zkClient, String topic, scala.collection.immutable.Map<Object, Object> leaderPerPartitionMap, int controllerEpoch) {
        leaderPerPartitionMap.foreach((Function1)new Serializable(zkClient, topic, controllerEpoch){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$4;
            public final String topic$5;
            private final int controllerEpoch$1;

            public final void apply(Tuple2<Object, Object> leaderForPartition) {
                int partition = leaderForPartition._1$mcI$sp();
                int leader = leaderForPartition._2$mcI$sp();
                try {
                    Option currentLeaderAndIsrOpt = ZkUtils$.MODULE$.getLeaderAndIsrForPartition(this.zkClient$4, this.topic$5, partition);
                    LeaderAndIsr newLeaderAndIsr = null;
                    Option option = currentLeaderAndIsrOpt;
                    None$ none$ = None$.MODULE$;
                    if (!(option != null ? !option.equals(none$) : none$ != null)) {
                        newLeaderAndIsr = new LeaderAndIsr(leader, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader})));
                    } else {
                        newLeaderAndIsr = (LeaderAndIsr)currentLeaderAndIsrOpt.get();
                        newLeaderAndIsr.leader_$eq(leader);
                        LeaderAndIsr leaderAndIsr = newLeaderAndIsr;
                        leaderAndIsr.leaderEpoch_$eq(leaderAndIsr.leaderEpoch() + 1);
                        LeaderAndIsr leaderAndIsr2 = newLeaderAndIsr;
                        leaderAndIsr2.zkVersion_$eq(leaderAndIsr2.zkVersion() + 1);
                    }
                    ZkUtils$.MODULE$.updatePersistentPath(this.zkClient$4, ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(this.topic$5, partition), ZkUtils$.MODULE$.leaderAndIsrZkData(newLeaderAndIsr, this.controllerEpoch$1));
                }
                catch (Throwable throwable) {
                    TestUtils$.MODULE$.error((Function0<String>)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.makeLeaderForPartition.1 $outer;
                        private final int partition$4;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Error while electing leader for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$5, BoxesRunTime.boxToInteger((int)this.partition$4)}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.partition$4 = partition$4;
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable oe$1;

                        public final Throwable apply() {
                            return this.oe$1;
                        }
                        {
                            this.oe$1 = oe$1;
                        }
                    });
                }
            }
            {
                this.zkClient$4 = zkClient$4;
                this.topic$5 = topic$5;
                this.controllerEpoch$1 = controllerEpoch$1;
            }
        });
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged(ZkClient zkClient, String topic, int partition, long timeoutMs, Option<Object> oldLeaderOpt, Option<Object> newLeaderOpt) {
        Predef$.MODULE$.require(!oldLeaderOpt.isDefined() || !newLeaderOpt.isDefined(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Can't define both the old and the new leader";
            }
        });
        long startTime = System.currentTimeMillis();
        boolean isLeaderElectedOrChanged = false;
        this.trace((Function0<String>)new Serializable(topic, partition, oldLeaderOpt, newLeaderOpt){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final int partition$1;
            private final Option oldLeaderOpt$1;
            private final Option newLeaderOpt$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Waiting for leader to be elected or changed for partition [%s,%d], older leader is %s, new leader is %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$3, BoxesRunTime.boxToInteger((int)this.partition$1), this.oldLeaderOpt$1, this.newLeaderOpt$1}));
            }
            {
                this.topic$3 = topic$3;
                this.partition$1 = partition$1;
                this.oldLeaderOpt$1 = oldLeaderOpt$1;
                this.newLeaderOpt$1 = newLeaderOpt$1;
            }
        });
        None$ leader = None$.MODULE$;
        while (!isLeaderElectedOrChanged && System.currentTimeMillis() < startTime + timeoutMs) {
            None$ none$;
            block13: {
                block12: {
                    BoxedUnit boxedUnit;
                    block11: {
                        BoxedUnit boxedUnit2;
                        leader = ZkUtils$.MODULE$.getLeaderForPartition(zkClient, topic, partition);
                        none$ = leader;
                        if (!(none$ instanceof Some)) break block11;
                        Some some = (Some)none$;
                        int l = BoxesRunTime.unboxToInt((Object)some.x());
                        if (newLeaderOpt.isDefined() && BoxesRunTime.unboxToInt((Object)newLeaderOpt.get()) == l) {
                            this.trace((Function0<String>)new Serializable(topic, partition, l){
                                public static final long serialVersionUID = 0L;
                                private final String topic$3;
                                private final int partition$1;
                                private final int l$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Expected new leader %d is elected for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.l$1), this.topic$3, BoxesRunTime.boxToInteger((int)this.partition$1)}));
                                }
                                {
                                    this.topic$3 = topic$3;
                                    this.partition$1 = partition$1;
                                    this.l$1 = l$1;
                                }
                            });
                            isLeaderElectedOrChanged = true;
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else if (oldLeaderOpt.isDefined() && BoxesRunTime.unboxToInt((Object)oldLeaderOpt.get()) != l) {
                            this.trace((Function0<String>)new Serializable(topic, partition, oldLeaderOpt, l){
                                public static final long serialVersionUID = 0L;
                                private final String topic$3;
                                private final int partition$1;
                                private final Option oldLeaderOpt$1;
                                private final int l$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Leader for partition [%s,%d] is changed from %d to %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$3, BoxesRunTime.boxToInteger((int)this.partition$1), this.oldLeaderOpt$1.get(), BoxesRunTime.boxToInteger((int)this.l$1)}));
                                }
                                {
                                    this.topic$3 = topic$3;
                                    this.partition$1 = partition$1;
                                    this.oldLeaderOpt$1 = oldLeaderOpt$1;
                                    this.l$1 = l$1;
                                }
                            });
                            isLeaderElectedOrChanged = true;
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else if (oldLeaderOpt.isDefined()) {
                            this.trace((Function0<String>)new Serializable(topic, partition, l){
                                public static final long serialVersionUID = 0L;
                                private final String topic$3;
                                private final int partition$1;
                                private final int l$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Current leader for partition [%s,%d] is %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$3, BoxesRunTime.boxToInteger((int)this.partition$1), BoxesRunTime.boxToInteger((int)this.l$1)}));
                                }
                                {
                                    this.topic$3 = topic$3;
                                    this.partition$1 = partition$1;
                                    this.l$1 = l$1;
                                }
                            });
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            this.trace((Function0<String>)new Serializable(topic, partition, l){
                                public static final long serialVersionUID = 0L;
                                private final String topic$3;
                                private final int partition$1;
                                private final int l$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Leader %d is elected for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.l$1), this.topic$3, BoxesRunTime.boxToInteger((int)this.partition$1)}));
                                }
                                {
                                    this.topic$3 = topic$3;
                                    this.partition$1 = partition$1;
                                    this.l$1 = l$1;
                                }
                            });
                            isLeaderElectedOrChanged = true;
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        boxedUnit = boxedUnit2;
                        break block12;
                    }
                    None$ none$2 = None$.MODULE$;
                    None$ none$3 = none$;
                    if (none$2 != null ? !none$2.equals(none$3) : none$3 != null) break block13;
                    this.trace((Function0<String>)new Serializable(topic, partition){
                        public static final long serialVersionUID = 0L;
                        private final String topic$3;
                        private final int partition$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Leader for partition [%s,%d] is not elected yet")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$3, BoxesRunTime.boxToInteger((int)this.partition$1)}));
                        }
                        {
                            this.topic$3 = topic$3;
                            this.partition$1 = partition$1;
                        }
                    });
                    boxedUnit = BoxedUnit.UNIT;
                }
                Thread.sleep(BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(timeoutMs)).min((Object)BoxesRunTime.boxToLong((long)100L))));
                continue;
            }
            throw new MatchError((Object)none$);
        }
        if (!isLeaderElectedOrChanged) {
            Assert.fail((String)new StringOps(Predef$.MODULE$.augmentString("Timing out after %d ms since leader is not elected or changed for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timeoutMs), topic, BoxesRunTime.boxToInteger((int)partition)})));
        }
        return leader;
    }

    public long waitUntilLeaderIsElectedOrChanged$default$4() {
        return 5000L;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged$default$6() {
        return None$.MODULE$;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void retry(long maxWaitMs, Function0<BoxedUnit> block) {
        LongRef wait = new LongRef(1L);
        long startTime = System.currentTimeMillis();
        {
            block.apply$mcV$sp();
            return;
        }
    }

    public boolean waitUntilTrue(Function0<Object> condition, String msg, long waitTime) {
        long startTime = System.currentTimeMillis();
        while (!condition.apply$mcZ$sp()) {
            if (System.currentTimeMillis() > startTime + waitTime) {
                Assert.fail((String)msg);
            }
            Thread.sleep(BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(waitTime)).min((Object)BoxesRunTime.boxToLong((long)100L))));
        }
        return true;
    }

    public long waitUntilTrue$default$3() {
        return 5000L;
    }

    public boolean isLeaderLocalOnBroker(String topic, int partitionId, KafkaServer server) {
        Option option;
        block4: {
            Option option2;
            block7: {
                boolean bl;
                block3: {
                    boolean bl2;
                    block6: {
                        block5: {
                            Option replicaOpt;
                            block2: {
                                Option partitionOpt;
                                option = partitionOpt = server.replicaManager().getPartition(topic, partitionId);
                                None$ none$ = None$.MODULE$;
                                Option option3 = option;
                                if (none$ != null ? !none$.equals(option3) : option3 != null) break block2;
                                bl = false;
                                break block3;
                            }
                            if (!(option instanceof Some)) break block4;
                            Some some = (Some)option;
                            Partition partition = (Partition)some.x();
                            option2 = replicaOpt = partition.leaderReplicaIfLocal();
                            None$ none$ = None$.MODULE$;
                            Option option4 = option2;
                            if (none$ != null ? !none$.equals(option4) : option4 != null) break block5;
                            bl2 = false;
                            break block6;
                        }
                        if (!(option2 instanceof Some)) break block7;
                        bl2 = true;
                    }
                    bl = bl2;
                }
                return bl;
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer createRequestByteBuffer(RequestOrResponse request) {
        void var2_2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(request.sizeInBytes() + 2);
        byteBuffer.putShort(BoxesRunTime.unboxToShort((Object)request.requestId().get()));
        request.writeTo(byteBuffer);
        byteBuffer.rewind();
        return var2_2;
    }

    public int waitUntilMetadataIsPropagated(Seq<KafkaServer> servers, String topic, int partition, long timeout) {
        IntRef leader = new IntRef(-1);
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, topic, partition, leader){
            public static final long serialVersionUID = 0L;
            private final Seq servers$3;
            public final String topic$4;
            public final int partition$2;
            public final IntRef leader$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.servers$3.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.waitUntilMetadataIsPropagated.1 $outer;

                    public final boolean apply(boolean result, KafkaServer server) {
                        Option option;
                        block4: {
                            boolean bl;
                            block3: {
                                block2: {
                                    Option partitionStateOpt;
                                    option = partitionStateOpt = server.apis().metadataCache().getPartitionInfo(this.$outer.topic$4, this.$outer.partition$2);
                                    None$ none$ = None$.MODULE$;
                                    Option option2 = option;
                                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                                    bl = false;
                                    break block3;
                                }
                                if (!(option instanceof Some)) break block4;
                                Some some = (Some)option;
                                PartitionStateInfo partitionState = (PartitionStateInfo)some.x();
                                this.$outer.leader$1.elem = partitionState.leaderIsrAndControllerEpoch().leaderAndIsr().leader();
                                bl = result && Request$.MODULE$.isValidBrokerId(this.$outer.leader$1.elem);
                            }
                            return bl;
                        }
                        throw new MatchError((Object)option);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.servers$3 = servers$3;
                this.topic$4 = topic$4;
                this.partition$2 = partition$2;
                this.leader$1 = leader$1;
            }
        }, new StringOps(Predef$.MODULE$.augmentString("Partition [%s,%d] metadata not propagated after %d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToLong((long)timeout)})), timeout);
        return leader.elem;
    }

    public long waitUntilMetadataIsPropagated$default$4() {
        return 5000L;
    }

    public void writeNonsenseToFile(File fileName, long position, int size) {
        RandomAccessFile file = new RandomAccessFile(fileName, "rw");
        file.seek(position);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final RandomAccessFile file$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.file$1.writeByte(TestUtils$.MODULE$.random().nextInt(255));
            }
            {
                this.file$1 = file$1;
            }
        });
        file.close();
    }

    public void appendNonsenseToFile(File fileName, int size) {
        FileOutputStream file = new FileOutputStream(fileName, true);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final FileOutputStream file$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.file$2.write(TestUtils$.MODULE$.random().nextInt(255));
            }
            {
                this.file$2 = file$2;
            }
        });
        file.close();
    }

    public void checkForPhantomInSyncReplicas(ZkClient zkClient, String topic, int partitionToBeReassigned, Seq<Object> assignedReplicas) {
        Seq inSyncReplicas = ZkUtils$.MODULE$.getInSyncReplicasForPartition(zkClient, topic, partitionToBeReassigned);
        Set phantomInSyncReplicas = (Set)inSyncReplicas.toSet().$minus$minus((GenTraversableOnce)assignedReplicas.toSet());
        Assert.assertTrue((String)new StringOps(Predef$.MODULE$.augmentString("All in sync replicas %s must be in the assigned replica list %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inSyncReplicas, assignedReplicas})), (phantomInSyncReplicas.size() == 0 ? 1 : 0) != 0);
    }

    public void ensureNoUnderReplicatedPartitions(ZkClient zkClient, String topic, int partitionToBeReassigned, Seq<Object> assignedReplicas, Seq<KafkaServer> servers) {
        this.waitUntilTrue((Function0<Object>)new Serializable(zkClient, topic, partitionToBeReassigned, assignedReplicas){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$5;
            private final String topic$6;
            private final int partitionToBeReassigned$1;
            private final Seq assignedReplicas$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Seq inSyncReplicas = ZkUtils$.MODULE$.getInSyncReplicasForPartition(this.zkClient$5, this.topic$6, this.partitionToBeReassigned$1);
                return inSyncReplicas.size() == this.assignedReplicas$1.size();
            }
            {
                this.zkClient$5 = zkClient$5;
                this.topic$6 = topic$6;
                this.partitionToBeReassigned$1 = partitionToBeReassigned$1;
                this.assignedReplicas$1 = assignedReplicas$1;
            }
        }, new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is under replicated")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionToBeReassigned)})), this.waitUntilTrue$default$3());
        ObjectRef leader = new ObjectRef((Object)None$.MODULE$);
        this.waitUntilTrue((Function0<Object>)new Serializable(zkClient, topic, partitionToBeReassigned, leader){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$5;
            private final String topic$6;
            private final int partitionToBeReassigned$1;
            private final ObjectRef leader$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.leader$2.elem = ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient$5, this.topic$6, this.partitionToBeReassigned$1);
                return ((Option)this.leader$2.elem).isDefined();
            }
            {
                this.zkClient$5 = zkClient$5;
                this.topic$6 = topic$6;
                this.partitionToBeReassigned$1 = partitionToBeReassigned$1;
                this.leader$2 = leader$2;
            }
        }, new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is unavailable")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionToBeReassigned)})), this.waitUntilTrue$default$3());
        this.waitUntilTrue((Function0<Object>)new Serializable(servers, leader){
            public static final long serialVersionUID = 0L;
            private final Seq servers$4;
            public final ObjectRef leader$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                KafkaServer leaderBroker = (KafkaServer)((IterableLike)this.servers$4.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.ensureNoUnderReplicatedPartitions.3 $outer;

                    public final boolean apply(KafkaServer s) {
                        return s.config().brokerId() == BoxesRunTime.unboxToInt((Object)((Option)this.$outer.leader$2.elem).get());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })).head();
                return leaderBroker.replicaManager().underReplicatedPartitionCount() == 0;
            }
            {
                this.servers$4 = servers$4;
                this.leader$2 = leader$2;
            }
        }, new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is under-replicated as reported by the leader %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionToBeReassigned), ((Option)leader.elem).get()})), this.waitUntilTrue$default$3());
    }

    public boolean checkIfReassignPartitionPathExists(ZkClient zkClient) {
        return ZkUtils$.MODULE$.pathExists(zkClient, ZkUtils$.MODULE$.ReassignPartitionsPath());
    }

    public LogManager createLogManager(File[] logDirs, LogConfig defaultConfig, CleanerConfig cleanerConfig, MockTime time) {
        File[] x$5 = logDirs;
        Map x$6 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        LogConfig x$7 = defaultConfig;
        CleanerConfig x$8 = cleanerConfig;
        int x$9 = 4;
        long x$10 = 1000L;
        long x$11 = 10000L;
        long x$12 = 1000L;
        MockScheduler x$13 = time.scheduler();
        MockTime x$14 = time;
        BrokerState x$15 = new BrokerState();
        return new LogManager(x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Scheduler)x$13, x$15, (Time)x$14);
    }

    public File[] createLogManager$default$1() {
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    public LogConfig createLogManager$default$2() {
        return new LogConfig(LogConfig$.MODULE$.apply$default$1(), LogConfig$.MODULE$.apply$default$2(), LogConfig$.MODULE$.apply$default$3(), LogConfig$.MODULE$.apply$default$4(), LogConfig$.MODULE$.apply$default$5(), LogConfig$.MODULE$.apply$default$6(), LogConfig$.MODULE$.apply$default$7(), LogConfig$.MODULE$.apply$default$8(), LogConfig$.MODULE$.apply$default$9(), LogConfig$.MODULE$.apply$default$10(), LogConfig$.MODULE$.apply$default$11(), LogConfig$.MODULE$.apply$default$12(), LogConfig$.MODULE$.apply$default$13(), LogConfig$.MODULE$.apply$default$14(), LogConfig$.MODULE$.apply$default$15(), LogConfig$.MODULE$.apply$default$16());
    }

    public CleanerConfig createLogManager$default$3() {
        boolean x$25 = false;
        int x$26 = CleanerConfig$.MODULE$.apply$default$1();
        long x$27 = CleanerConfig$.MODULE$.apply$default$2();
        double x$28 = CleanerConfig$.MODULE$.apply$default$3();
        int x$29 = CleanerConfig$.MODULE$.apply$default$4();
        int x$30 = CleanerConfig$.MODULE$.apply$default$5();
        double x$31 = CleanerConfig$.MODULE$.apply$default$6();
        long x$32 = CleanerConfig$.MODULE$.apply$default$7();
        String x$33 = CleanerConfig$.MODULE$.apply$default$9();
        return new CleanerConfig(x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$25, x$33);
    }

    public MockTime createLogManager$default$4() {
        return new MockTime();
    }

    public List<String> sendMessagesToPartition(Seq<KafkaConfig> configs, String topic, int partition, int numMessages, CompressionCodec compression) {
        String header = new StringOps(Predef$.MODULE$.augmentString("test-%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partition)}));
        Properties props = new Properties();
        props.put("compression.codec", ((Object)BoxesRunTime.boxToInteger((int)compression.codec())).toString());
        Producer producer = this.createProducer(this.getBrokerListStrFromConfigs(configs), StringEncoder.class.getName(), IntEncoder.class.getName(), FixedValuePartitioner.class.getName(), props);
        IndexedSeq ms = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1)new Serializable(header){
            public static final long serialVersionUID = 0L;
            private final String header$2;

            public final String apply(int x) {
                return new StringBuilder().append((Object)this.header$2).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)x)).toString();
            }
            {
                this.header$2 = header$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        producer.send((Seq)ms.map((Function1)new Serializable(topic, partition){
            public static final long serialVersionUID = 0L;
            private final String topic$7;
            private final int partition$3;

            public final KeyedMessage<Object, String> apply(String m) {
                return new KeyedMessage(this.topic$7, (Object)BoxesRunTime.boxToInteger((int)this.partition$3), (Object)m);
            }
            {
                this.topic$7 = topic$7;
                this.partition$3 = partition$3;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()));
        this.debug((Function0<String>)new Serializable(topic, partition, ms){
            public static final long serialVersionUID = 0L;
            private final String topic$7;
            private final int partition$3;
            private final IndexedSeq ms$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Sent %d messages for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.ms$1.size()), this.topic$7, BoxesRunTime.boxToInteger((int)this.partition$3)}));
            }
            {
                this.topic$7 = topic$7;
                this.partition$3 = partition$3;
                this.ms$1 = ms$1;
            }
        });
        producer.close();
        return ms.toList();
    }

    public List<String> sendMessages(Seq<KafkaConfig> configs, String topic, String producerId, int messagesPerNode, String header, CompressionCodec compression, int numParts) {
        ObjectRef messages2 = new ObjectRef((Object)Nil$.MODULE$);
        Properties props = new Properties();
        props.put("compression.codec", ((Object)BoxesRunTime.boxToInteger((int)compression.codec())).toString());
        props.put("client.id", producerId);
        Producer producer = this.createProducer(this.getBrokerListStrFromConfigs(configs), StringEncoder.class.getName(), IntEncoder.class.getName(), FixedValuePartitioner.class.getName(), props);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numParts).foreach$mVc$sp((Function1)new Serializable(topic, messagesPerNode, header, messages2, producer){
            public static final long serialVersionUID = 0L;
            public final String topic$8;
            private final int messagesPerNode$1;
            public final String header$1;
            private final ObjectRef messages$1;
            private final Producer producer$1;

            public final void apply(int partition) {
                this.apply$mcVI$sp(partition);
            }

            public void apply$mcVI$sp(int partition) {
                IndexedSeq ms = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.messagesPerNode$1).map((Function1)new Serializable(this, partition){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.sendMessages.1 $outer;
                    private final int partition$5;

                    public final String apply(int x) {
                        return new StringBuilder().append((Object)this.$outer.header$1).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)this.partition$5)).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)x)).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.partition$5 = partition$5;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                this.producer$1.send((Seq)ms.map((Function1)new Serializable(this, partition){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.sendMessages.1 $outer;
                    private final int partition$5;

                    public final KeyedMessage<Object, String> apply(String m) {
                        return new KeyedMessage(this.$outer.topic$8, (Object)BoxesRunTime.boxToInteger((int)this.partition$5), (Object)m);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.partition$5 = partition$5;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom()));
                this.messages$1.elem = (List)((List)this.messages$1.elem).$plus$plus((GenTraversableOnce)ms, List$.MODULE$.canBuildFrom());
                TestUtils$.MODULE$.debug((Function0<String>)new Serializable(this, ms, partition){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.sendMessages.1 $outer;
                    private final IndexedSeq ms$2;
                    private final int partition$5;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Sent %d messages for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.ms$2.size()), this.$outer.topic$8, BoxesRunTime.boxToInteger((int)this.partition$5)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.ms$2 = ms$2;
                        this.partition$5 = partition$5;
                    }
                });
            }
            {
                this.topic$8 = topic$8;
                this.messagesPerNode$1 = messagesPerNode$1;
                this.header$1 = header$1;
                this.messages$1 = messages$1;
                this.producer$1 = producer$1;
            }
        });
        producer.close();
        return (List)messages2.elem;
    }

    public CompressionCodec sendMessagesToPartition$default$5() {
        return NoCompressionCodec$.MODULE$;
    }

    public List<String> getMessages(int nMessagesPerThread, Map<String, List<KafkaStream<String, String>>> topicMessageStreams) {
        ObjectRef messages2 = new ObjectRef((Object)Nil$.MODULE$);
        topicMessageStreams.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, List<KafkaStream<String, String>>> check$ifrefutable$2) {
                Tuple2<String, List<KafkaStream<String, String>>> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(nMessagesPerThread, messages2){
            public static final long serialVersionUID = 0L;
            public final int nMessagesPerThread$1;
            public final ObjectRef messages$2;

            public final void apply(Tuple2<String, List<KafkaStream<String, String>>> x$4) {
                Tuple2<String, List<KafkaStream<String, String>>> tuple2 = x$4;
                if (tuple2 != null) {
                    List messageStreams = (List)tuple2._2();
                    messageStreams.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.getMessages.2 $outer;

                        public final void apply(KafkaStream<String, String> messageStream) {
                            ConsumerIterator iterator = messageStream.iterator();
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.nMessagesPerThread$1).foreach$mVc$sp((Function1)new Serializable(this, iterator){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$getMessages$2$$anonfun$apply$5 $outer;
                                private final ConsumerIterator iterator$1;

                                public final void apply(int i) {
                                    this.apply$mcVI$sp(i);
                                }

                                public void apply$mcVI$sp(int i) {
                                    Assert.assertTrue((boolean)this.iterator$1.hasNext());
                                    String message = (String)this.iterator$1.next().message();
                                    this.$outer.kafka$utils$TestUtils$$anonfun$$anonfun$$$outer().messages$2.elem = ((List)this.$outer.kafka$utils$TestUtils$$anonfun$$anonfun$$$outer().messages$2.elem).$colon$colon((Object)message);
                                    TestUtils$.MODULE$.debug((Function0<String>)new Serializable(this, message){
                                        public static final long serialVersionUID = 0L;
                                        private final String message$2;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)"received message: ").append((Object)this.message$2).toString();
                                        }
                                        {
                                            this.message$2 = message$2;
                                        }
                                    });
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.iterator$1 = iterator$1;
                                }
                            });
                        }

                        public /* synthetic */ anonfun.getMessages.2 kafka$utils$TestUtils$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.nMessagesPerThread$1 = nMessagesPerThread$1;
                this.messages$2 = messages$2;
            }
        });
        return ((List)messages2.elem).reverse();
    }

    private TestUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.IoTmpDir = System.getProperty("java.io.tmpdir");
        this.Letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        this.Digits = "0123456789";
        this.LettersAndDigits = new StringBuilder().append((Object)this.Letters()).append((Object)this.Digits()).toString();
        this.seededRandom = new Random(192348092834L);
        this.random = new Random();
    }
}

