/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.common;

import junit.framework.Assert;
import kafka.common.InvalidTopicException;
import kafka.common.Topic$;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u00112A!\u0001\u0002\u0001\u0013\tIAk\u001c9jGR+7\u000f\u001e\u0006\u0003\u0007\u0011\taaY8n[>t'BA\u0003\u0007\u0003\u0015Y\u0017MZ6b\u0015\u00059\u0011\u0001B;oSR\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aDQ!\u0005\u0001\u0005\u0002I\ta\u0001P5oSRtD#A\n\u0011\u0005Q\u0001Q\"\u0001\u0002\t\u000bY\u0001A\u0011A\f\u0002+Q,7\u000f^%om\u0006d\u0017\u000e\u001a+pa&\u001cg*Y7fgR\t\u0001\u0004\u0005\u0002\f3%\u0011!\u0004\u0004\u0002\u0005+:LG\u000f\u000b\u0002\u00169A\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002C\u0005\u0019qN]4\n\u0005\rr\"\u0001\u0002+fgR\u0004")
public class TopicTest {
    @Test
    public void testInvalidTopicNames() {
        ArrayBuffer invalidTopicNames = new ArrayBuffer();
        invalidTopicNames.$plus$eq((Object)"", (Object)".", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".."}));
        ObjectRef longName = new ObjectRef((Object)"ATCG");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 6).foreach$mVc$sp((Function1)new Serializable(this, longName){
            public static final long serialVersionUID = 0L;
            private final ObjectRef longName$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.longName$1.elem = new StringBuilder().append((Object)((String)this.longName$1.elem)).append((Object)((String)this.longName$1.elem)).toString();
            }
            {
                this.longName$1 = longName$1;
            }
        });
        invalidTopicNames.$plus$eq((Object)((String)longName.elem));
        Object[] badChars = (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)'/'), BoxesRunTime.boxToCharacter((char)'\\'), BoxesRunTime.boxToCharacter((char)','), BoxesRunTime.boxToCharacter((char)'\u0000'), BoxesRunTime.boxToCharacter((char)':'), "\"", BoxesRunTime.boxToCharacter((char)'\''), BoxesRunTime.boxToCharacter((char)';'), BoxesRunTime.boxToCharacter((char)'*'), BoxesRunTime.boxToCharacter((char)'?'), BoxesRunTime.boxToCharacter((char)' '), BoxesRunTime.boxToCharacter((char)'\t'), BoxesRunTime.boxToCharacter((char)'\r'), BoxesRunTime.boxToCharacter((char)'\n'), BoxesRunTime.boxToCharacter((char)'=')}), ClassTag$.MODULE$.Any());
        Predef$.MODULE$.genericArrayOps((Object)badChars).foreach((Function1)new Serializable(this, invalidTopicNames){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer invalidTopicNames$1;

            public final ArrayBuffer<String> apply(Object weirdChar) {
                return this.invalidTopicNames$1.$plus$eq((Object)new StringBuilder().append((Object)"Is").append(weirdChar).append((Object)"illegal").toString());
            }
            {
                this.invalidTopicNames$1 = invalidTopicNames$1;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), invalidTopicNames.size()).foreach((Function1)new Serializable(this, invalidTopicNames){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer invalidTopicNames$1;

            public final Object apply(int i) {
                String string;
                try {
                    Topic$.MODULE$.validate((String)this.invalidTopicNames$1.apply(i));
                    Assert.fail((String)"Should throw InvalidTopicException.");
                    string = BoxedUnit.UNIT;
                }
                catch (InvalidTopicException invalidTopicException) {
                    string = "This is good.";
                }
                return string;
            }
            {
                this.invalidTopicNames$1 = invalidTopicNames$1;
            }
        });
        ArrayBuffer validTopicNames = new ArrayBuffer();
        validTopicNames.$plus$eq((Object)"valid", (Object)"TOPIC", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"nAmEs", "ar6", "VaL1d", "_0-9_."}));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), validTopicNames.size()).foreach$mVc$sp((Function1)new Serializable(this, validTopicNames){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer validTopicNames$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                try {
                    Topic$.MODULE$.validate((String)this.validTopicNames$1.apply(i));
                }
                catch (Exception exception) {
                    Assert.fail((String)"Should not throw exception.");
                }
            }
            {
                this.validTopicNames$1 = validTopicNames$1;
            }
        });
    }
}

