/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.BaseProducerSendTest;
import kafka.api.BaseProducerSendTest$;
import kafka.api.BaseProducerSendTest$callback$3$;
import kafka.api.BaseProducerSendTest$callback$4$;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.consumer.SimpleConsumer;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.log.LogConfig$;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.VolatileObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Mh!B\u0001\u0003\u0003\u00039!\u0001\u0006\"bg\u0016\u0004&o\u001c3vG\u0016\u00148+\u001a8e)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011I\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u0005]!\"AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001\"\u0002\u0010\u0001\t\u0003y\u0012aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0015\u0003\u0001\u00022!I\u0016/\u001d\t\u0011\u0003F\u0004\u0002$M5\tAE\u0003\u0002&\r\u00051AH]8pizJ\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S)\nq\u0001]1dW\u0006<WMC\u0001(\u0013\taSFA\u0002TKFT!!\u000b\u0016\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\"\u0011AB:feZ,'/\u0003\u00024a\tY1*\u00194lC\u000e{gNZ5h\u0011\u001d)\u0004\u00011A\u0005\nY\n\u0011bY8ogVlWM]\u0019\u0016\u0003]\u0002\"\u0001O\u001e\u000e\u0003eR!A\u000f\u0003\u0002\u0011\r|gn];nKJL!\u0001P\u001d\u0003\u001dMKW\u000e\u001d7f\u0007>t7/^7fe\"9a\b\u0001a\u0001\n\u0013y\u0014!D2p]N,X.\u001a:2?\u0012*\u0017\u000f\u0006\u0002A\tB\u0011\u0011IQ\u0007\u0002U%\u00111I\u000b\u0002\u0005+:LG\u000fC\u0004F{\u0005\u0005\t\u0019A\u001c\u0002\u0007a$\u0013\u0007\u0003\u0004H\u0001\u0001\u0006KaN\u0001\u000bG>t7/^7feF\u0002\u0003bB%\u0001\u0001\u0004%IAN\u0001\nG>t7/^7feJBqa\u0013\u0001A\u0002\u0013%A*A\u0007d_:\u001cX/\\3se}#S-\u001d\u000b\u0003\u00016Cq!\u0012&\u0002\u0002\u0003\u0007q\u0007\u0003\u0004P\u0001\u0001\u0006KaN\u0001\u000bG>t7/^7feJ\u0002\u0003bB)\u0001\u0005\u0004%IAU\u0001\naJ|G-^2feN,\u0012a\u0015\t\u0004)f[V\"A+\u000b\u0005Y;\u0016aB7vi\u0006\u0014G.\u001a\u0006\u00031*\n!bY8mY\u0016\u001cG/[8o\u0013\tQVK\u0001\u0004Ck\u001a4WM\u001d\t\u00059\u00124g-D\u0001^\u0015\tqv,\u0001\u0005qe>$WoY3s\u0015\t\u0001\u0017-A\u0004dY&,g\u000e^:\u000b\u0005\u0015\u0011'BA2\u000f\u0003\u0019\t\u0007/Y2iK&\u0011Q-\u0018\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0011\u0007\u0005;\u0017.\u0003\u0002iU\t)\u0011I\u001d:bsB\u0011\u0011I[\u0005\u0003W*\u0012AAQ=uK\"1Q\u000e\u0001Q\u0001\nM\u000b!\u0002\u001d:pIV\u001cWM]:!\u0011\u001dy\u0007A1A\u0005\u0012A\fQ\u0001^8qS\u000e,\u0012!\u001d\t\u0003e^l\u0011a\u001d\u0006\u0003iV\fA\u0001\\1oO*\ta/\u0001\u0003kCZ\f\u0017B\u0001=t\u0005\u0019\u0019FO]5oO\"1!\u0010\u0001Q\u0001\nE\fa\u0001^8qS\u000e\u0004\u0003b\u0002?\u0001\u0005\u0004%I!`\u0001\u000b]Vl'+Z2pe\u0012\u001cX#\u0001@\u0011\u0005\u0005{\u0018bAA\u0001U\t\u0019\u0011J\u001c;\t\u000f\u0005\u0015\u0001\u0001)A\u0005}\u0006Ya.^7SK\u000e|'\u000fZ:!\u0011\u001d\tI\u0001\u0001C!\u0003\u0017\tQa]3u+B$\u0012\u0001\u0011\u0015\u0005\u0003\u000f\ty\u0001\u0005\u0003\u0002\u0012\u0005UQBAA\n\u0015\tYa\"\u0003\u0003\u0002\u0018\u0005M!A\u0002\"fM>\u0014X\rC\u0004\u0002\u001c\u0001!\t%a\u0003\u0002\u0011Q,\u0017M\u001d#po:DC!!\u0007\u0002 A!\u0011\u0011CA\u0011\u0013\u0011\t\u0019#a\u0005\u0003\u000b\u00053G/\u001a:\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*\u0005q1M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014H#C.\u0002,\u0005m\u0012qHA%\u0011!\ti#!\nA\u0002\u0005=\u0012A\u00032s_.,'\u000fT5tiB!\u0011\u0011GA\u001c\u001d\r\t\u00151G\u0005\u0004\u0003kQ\u0013A\u0002)sK\u0012,g-C\u0002y\u0003sQ1!!\u000e+\u0011%\ti$!\n\u0011\u0002\u0003\u0007a0A\u0004sKR\u0014\u0018.Z:\t\u0015\u0005\u0005\u0013Q\u0005I\u0001\u0002\u0004\t\u0019%\u0001\u0005mS:<WM]'t!\r\t\u0015QI\u0005\u0004\u0003\u000fR#\u0001\u0002'p]\u001eD!\"a\u0013\u0002&A\u0005\t\u0019AA'\u0003\u0015\u0001(o\u001c9t!\u0015\t\u0015qJA*\u0013\r\t\tF\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017v\u0003\u0011)H/\u001b7\n\t\u0005u\u0013q\u000b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBA1\u0001\u0011\u0005\u00111B\u0001\u000fi\u0016\u001cHoU3oI>3gm]3uQ\u0011\ty&!\u001a\u0011\t\u0005E\u0011qM\u0005\u0005\u0003S\n\u0019B\u0001\u0003UKN$\bbBA7\u0001\u0011\u0005\u00111B\u0001(i\u0016\u001cHoU3oI\u000e{W\u000e\u001d:fgN,G-T3tg\u0006<WmV5uQ\u000e\u0013X-\u0019;f)&lW\r\u000b\u0003\u0002l\u0005\u0015\u0004bBA:\u0001\u0011\u0005\u00111B\u0001+i\u0016\u001cHoU3oI:{gnQ8naJ,7o]3e\u001b\u0016\u001c8/Y4f/&$\bn\u0011:fCR,G+[7fQ\u0011\t\t(!\u001a\t\u000f\u0005e\u0004\u0001\"\u0001\u0002\f\u0005QC/Z:u'\u0016tGmQ8naJ,7o]3e\u001b\u0016\u001c8/Y4f/&$\b\u000eT8h\u0003B\u0004XM\u001c3US6,\u0007\u0006BA<\u0003KBq!a \u0001\t\u0003\tY!\u0001\u0017uKN$8+\u001a8e\u001d>t7i\\7qe\u0016\u001c8/\u001a3NKN\u001c\u0018mZ3XSRDGj\\4Ba\u0016tG\rV5nK\"\"\u0011QPA3\u0011\u001d\t)\t\u0001C\u0005\u0003\u000f\u000bac]3oI\u0006sGMV3sS\u001aLH+[7fgR\fW\u000e\u001d\u000b\u0006\u0001\u0006%\u00151\u0012\u0005\u0007=\u0006\r\u0005\u0019A.\t\u0011\u00055\u00151\u0011a\u0001\u0003\u001f\u000bQ\u0002^5nKN$\u0018-\u001c9UsB,\u0007\u0003BAI\u00037k!!a%\u000b\t\u0005U\u0015qS\u0001\u0007e\u0016\u001cwN\u001d3\u000b\u0007\u0005e\u0015-\u0001\u0004d_6lwN\\\u0005\u0005\u0003;\u000b\u0019JA\u0007US6,7\u000f^1naRK\b/\u001a\u0005\b\u0003C\u0003A\u0011AA\u0006\u0003%!Xm\u001d;DY>\u001cX\r\u000b\u0003\u0002 \u0006\u0015\u0004bBAT\u0001\u0011\u0005\u00111B\u0001\u0014i\u0016\u001cHoU3oIR{\u0007+\u0019:uSRLwN\u001c\u0015\u0005\u0003K\u000b)\u0007C\u0004\u0002.\u0002!\t!a\u0003\u0002'Q,7\u000f^!vi>\u001c%/Z1uKR{\u0007/[2)\t\u0005-\u0016Q\r\u0005\b\u0003g\u0003A\u0011AA\u0006\u0003%!Xm\u001d;GYV\u001c\b\u000e\u000b\u0003\u00022\u0006\u0015\u0004bBA]\u0001\u0011\u0005\u00111B\u0001)i\u0016\u001cHo\u00117pg\u0016<\u0016\u000e\u001e5[KJ|G+[7f_V$hI]8n\u0007\u0006dG.\u001a:UQJ,\u0017\r\u001a\u0015\u0005\u0003o\u000b)\u0007C\u0004\u0002@\u0002!\t!a\u0003\u0002QQ,7\u000f^\"m_N,w+\u001b;i5\u0016\u0014x\u000eV5nK>,HO\u0012:p[N+g\u000eZ3s)\"\u0014X-\u00193)\t\u0005u\u0016Q\r\u0005\b\u0003\u000b\u0004A\u0011AA\u0006\u0003u!Xm\u001d;TK:$w+\u001b;i\u0013:4\u0018\r\\5e\u0007J,\u0017\r^3US6,\u0007\u0006BAb\u0003KB\u0011\"a3\u0001#\u0003%I!!4\u00021\r\u0014X-\u0019;f!J|G-^2fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002P*\u001aa0!5,\u0005\u0005M\u0007\u0003BAk\u0003?l!!a6\u000b\t\u0005e\u00171\\\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!8+\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003C\f9NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!:\u0001#\u0003%I!a:\u00021\r\u0014X-\u0019;f!J|G-^2fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002j*\"\u00111IAi\u0011%\ti\u000fAI\u0001\n\u0013\ty/\u0001\rde\u0016\fG/\u001a)s_\u0012,8-\u001a:%I\u00164\u0017-\u001e7uIQ*\"!!=+\t\u00055\u0013\u0011\u001b")
public abstract class BaseProducerSendTest
extends JUnitSuite
implements KafkaServerTestHarness {
    private SimpleConsumer kafka$api$BaseProducerSendTest$$consumer1;
    private SimpleConsumer kafka$api$BaseProducerSendTest$$consumer2;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers;
    private final String topic;
    private final int kafka$api$BaseProducerSendTest$$numRecords;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final Option<Function0<BoxedUnit>> setClusterAcl;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BaseProducerSendTest$callback$3$ kafka$api$BaseProducerSendTest$$callback$1$lzycompute(Integer x$1, VolatileObjectRef x$2) {
        BaseProducerSendTest baseProducerSendTest = this;
        synchronized (baseProducerSendTest) {
            if (x$2.elem != null) return (BaseProducerSendTest$callback$3$)x$2.elem;
            x$2.elem = new BaseProducerSendTest$callback$3$(this, x$1);
            return (BaseProducerSendTest$callback$3$)x$2.elem;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BaseProducerSendTest$callback$4$ kafka$api$BaseProducerSendTest$$callback$2$lzycompute(TimestampType x$1, Integer x$2, long x$3, long x$4, VolatileObjectRef x$5) {
        BaseProducerSendTest baseProducerSendTest = this;
        synchronized (baseProducerSendTest) {
            if (x$5.elem != null) return (BaseProducerSendTest$callback$4$)x$5.elem;
            x$5.elem = new BaseProducerSendTest$callback$4$(this, x$1, x$2, x$3, x$4);
            return (BaseProducerSendTest$callback$4$)x$5.elem;
        }
    }

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public Option<Function0<BoxedUnit>> setClusterAcl() {
        return this.setClusterAcl;
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$setClusterAcl_$eq(Option x$1) {
        this.setClusterAcl = x$1;
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> saslProperties() {
        return KafkaServerTestHarness$class.saslProperties(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        BaseProducerSendTest baseProducerSendTest = this;
        synchronized (baseProducerSendTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Properties overridingProps = new Properties();
        int numServers = 2;
        overridingProps.put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)4)).toString());
        int x$10 = numServers;
        String x$11 = this.zkConnect();
        boolean x$12 = false;
        Some x$13 = new Some((Object)this.securityProtocol());
        Option<File> x$14 = this.trustStoreFile();
        Option<Properties> x$15 = this.saslProperties();
        boolean x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$17 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$19 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$20 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$21 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$10, x$11, x$12, x$16, (Option<SecurityProtocol>)x$13, x$14, x$15, x$17, x$18, x$19, x$20, x$21).map((Function1)new Serializable(this, overridingProps){
            public static final long serialVersionUID = 0L;
            private final Properties overridingProps$1;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps$1);
            }
            {
                this.overridingProps$1 = overridingProps$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public SimpleConsumer kafka$api$BaseProducerSendTest$$consumer1() {
        return this.kafka$api$BaseProducerSendTest$$consumer1;
    }

    private void kafka$api$BaseProducerSendTest$$consumer1_$eq(SimpleConsumer x$1) {
        this.kafka$api$BaseProducerSendTest$$consumer1 = x$1;
    }

    public SimpleConsumer kafka$api$BaseProducerSendTest$$consumer2() {
        return this.kafka$api$BaseProducerSendTest$$consumer2;
    }

    private void kafka$api$BaseProducerSendTest$$consumer2_$eq(SimpleConsumer x$1) {
        this.kafka$api$BaseProducerSendTest$$consumer2 = x$1;
    }

    private Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    public String topic() {
        return this.topic;
    }

    public int kafka$api$BaseProducerSendTest$$numRecords() {
        return this.kafka$api$BaseProducerSendTest$$numRecords;
    }

    @Override
    @Before
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
        KafkaServer qual$1 = (KafkaServer)this.servers().apply(0);
        SecurityProtocol x$22 = qual$1.boundPort$default$1();
        this.kafka$api$BaseProducerSendTest$$consumer1_$eq(new SimpleConsumer("localhost", qual$1.boundPort(x$22), 100, 0x100000, ""));
        KafkaServer qual$2 = (KafkaServer)this.servers().apply(1);
        SecurityProtocol x$23 = qual$2.boundPort$default$1();
        this.kafka$api$BaseProducerSendTest$$consumer2_$eq(new SimpleConsumer("localhost", qual$2.boundPort(x$23), 100, 0x100000, ""));
    }

    @Override
    @After
    public void tearDown() {
        this.kafka$api$BaseProducerSendTest$$consumer1().close();
        this.kafka$api$BaseProducerSendTest$$consumer2().close();
        this.producers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaProducer<byte[], byte[]> x$2) {
                x$2.close();
            }
        });
        KafkaServerTestHarness$class.tearDown(this);
    }

    public KafkaProducer<byte[], byte[]> kafka$api$BaseProducerSendTest$$createProducer(String brokerList, int retries, long lingerMs, Option<Properties> props) {
        String x$24 = brokerList;
        SecurityProtocol x$25 = this.securityProtocol();
        Option<File> x$26 = this.trustStoreFile();
        Option<Properties> x$27 = this.saslProperties();
        int x$28 = retries;
        long x$29 = lingerMs;
        Option<Properties> x$30 = props;
        int x$31 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$32 = TestUtils$.MODULE$.createNewProducer$default$3();
        long x$33 = TestUtils$.MODULE$.createNewProducer$default$4();
        long x$34 = TestUtils$.MODULE$.createNewProducer$default$7();
        ByteArraySerializer x$35 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$36 = TestUtils$.MODULE$.createNewProducer$default$12();
        KafkaProducer producer = TestUtils$.MODULE$.createNewProducer(x$24, x$31, x$32, x$33, x$28, x$29, x$34, x$25, x$26, x$27, x$35, x$36, x$30);
        this.producers().$plus$eq(producer);
        return producer;
    }

    public int kafka$api$BaseProducerSendTest$$createProducer$default$2() {
        return 0;
    }

    private long createProducer$default$3() {
        return 0L;
    }

    public Option<Properties> kafka$api$BaseProducerSendTest$$createProducer$default$4() {
        return None$.MODULE$;
    }

    @Test
    public void testSendOffset() {
        VolatileObjectRef callback$module = VolatileObjectRef.zero();
        Integer partition = new Integer(0);
        try (KafkaProducer<byte[], byte[]> producer = this.kafka$api$BaseProducerSendTest$$createProducer(this.brokerList(), this.kafka$api$BaseProducerSendTest$$createProducer$default$2(), this.createProducer$default$3(), this.kafka$api$BaseProducerSendTest$$createProducer$default$4());){
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            ProducerRecord record0 = new ProducerRecord(this.topic(), partition, (Object)"key".getBytes(), (Object)"value".getBytes());
            Assert.assertEquals((String)"Should have offset 0", (long)0L, (long)((RecordMetadata)producer.send(record0, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record1 = new ProducerRecord(this.topic(), partition, (Object)"key".getBytes(), null);
            Assert.assertEquals((String)"Should have offset 1", (long)1L, (long)((RecordMetadata)producer.send(record1, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record2 = new ProducerRecord(this.topic(), partition, null, (Object)"value".getBytes());
            Assert.assertEquals((String)"Should have offset 2", (long)2L, (long)((RecordMetadata)producer.send(record2, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record3 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            Assert.assertEquals((String)"Should have offset 3", (long)3L, (long)((RecordMetadata)producer.send(record3, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            try {
                ProducerRecord record4 = new ProducerRecord(null, partition, (Object)"key".getBytes(), (Object)"value".getBytes());
                producer.send(record4, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module));
                throw this.fail("Should not allow sending a record without topic");
            }
            catch (Throwable throwable) {
                throw this.fail("Only expecting IllegalArgumentException", throwable);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1)new Serializable(this, producer, partition, record0, callback$module){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseProducerSendTest $outer;
                    private final KafkaProducer producer$1;
                    private final Integer partition$1;
                    private final ProducerRecord record0$1;
                    private final VolatileObjectRef callback$module$1;

                    public final Future<RecordMetadata> apply(int i) {
                        return this.producer$1.send(this.record0$1, (Callback)this.$outer.kafka$api$BaseProducerSendTest$$callback$1(this.partition$1, this.callback$module$1));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.producer$1 = producer$1;
                        this.partition$1 = partition$1;
                        this.record0$1 = record0$1;
                        this.callback$module$1 = callback$module$1;
                    }
                });
                Assert.assertEquals((String)new StringBuilder().append((Object)"Should have offset ").append((Object)BoxesRunTime.boxToInteger((int)(this.kafka$api$BaseProducerSendTest$$numRecords() + 4))).toString(), (long)((long)this.kafka$api$BaseProducerSendTest$$numRecords() + 4L), (long)((RecordMetadata)producer.send(record0, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            }
        }
    }

    @Test
    public void testSendCompressedMessageWithCreateTime() {
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", "gzip");
        String x$37 = this.brokerList();
        long x$38 = Long.MAX_VALUE;
        Some x$39 = new Some((Object)producerProps);
        int x$40 = this.kafka$api$BaseProducerSendTest$$createProducer$default$2();
        KafkaProducer<byte[], byte[]> producer = this.kafka$api$BaseProducerSendTest$$createProducer(x$37, x$40, x$38, (Option<Properties>)x$39);
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    @Test
    public void testSendNonCompressedMessageWithCreateTime() {
        String x$41 = this.brokerList();
        long x$42 = Long.MAX_VALUE;
        int x$43 = this.kafka$api$BaseProducerSendTest$$createProducer$default$2();
        Option<Properties> x$44 = this.kafka$api$BaseProducerSendTest$$createProducer$default$4();
        KafkaProducer<byte[], byte[]> producer = this.kafka$api$BaseProducerSendTest$$createProducer(x$41, x$43, x$42, x$44);
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    @Test
    public void testSendCompressedMessageWithLogAppendTime() {
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", "gzip");
        String x$45 = this.brokerList();
        long x$46 = Long.MAX_VALUE;
        Some x$47 = new Some((Object)producerProps);
        int x$48 = this.kafka$api$BaseProducerSendTest$$createProducer$default$2();
        KafkaProducer<byte[], byte[]> producer = this.kafka$api$BaseProducerSendTest$$createProducer(x$45, x$48, x$46, (Option<Properties>)x$47);
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    @Test
    public void testSendNonCompressedMessageWithLogApendTime() {
        String x$49 = this.brokerList();
        long x$50 = Long.MAX_VALUE;
        int x$51 = this.kafka$api$BaseProducerSendTest$$createProducer$default$2();
        Option<Properties> x$52 = this.kafka$api$BaseProducerSendTest$$createProducer$default$4();
        KafkaProducer<byte[], byte[]> producer = this.kafka$api$BaseProducerSendTest$$createProducer(x$49, x$51, x$50, x$52);
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    private void sendAndVerifyTimestamp(KafkaProducer<byte[], byte[]> producer, TimestampType timestampType) {
        VolatileObjectRef callback$module = VolatileObjectRef.zero();
        Integer partition = new Integer(0);
        long baseTimestamp = 123456L;
        long startTime = System.currentTimeMillis();
        try {
            Properties topicProps = new Properties();
            TimestampType timestampType2 = timestampType;
            TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
            Object object = !(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null) ? topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime") : topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "CreateTime");
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), topicProps);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1)new Serializable(this, producer, timestampType, partition, baseTimestamp, startTime, callback$module){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final KafkaProducer producer$2;
                private final TimestampType timestampType$1;
                private final Integer partition$2;
                private final long baseTimestamp$1;
                private final long startTime$1;
                private final VolatileObjectRef callback$module$2;

                public final Future<RecordMetadata> apply(int i) {
                    ProducerRecord record = new ProducerRecord(this.$outer.topic(), this.partition$2, Predef$.MODULE$.long2Long(this.baseTimestamp$1 + (long)i), (Object)"key".getBytes(), (Object)"value".getBytes());
                    return this.producer$2.send(record, (Callback)this.$outer.kafka$api$BaseProducerSendTest$$callback$2(this.timestampType$1, this.partition$2, this.baseTimestamp$1, this.startTime$1, this.callback$module$2));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producer$2 = producer$2;
                    this.timestampType$1 = timestampType$1;
                    this.partition$2 = partition$2;
                    this.baseTimestamp$1 = baseTimestamp$1;
                    this.startTime$1 = startTime$1;
                    this.callback$module$2 = callback$module$2;
                }
            });
            producer.close(10000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have offset ", " but only successfully sent ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$api$BaseProducerSendTest$$numRecords()), BoxesRunTime.boxToLong((long)this.kafka$api$BaseProducerSendTest$$callback$2(timestampType, partition, baseTimestamp, startTime, callback$module).offset())})), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)this.kafka$api$BaseProducerSendTest$$callback$2(timestampType, partition, baseTimestamp, startTime, callback$module).offset());
            return;
        }
        finally {
            producer.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClose() {
        KafkaProducer<byte[], byte[]> producer = this.kafka$api$BaseProducerSendTest$$createProducer(this.brokerList(), this.kafka$api$BaseProducerSendTest$$createProducer$default$2(), this.createProducer$default$3(), this.kafka$api$BaseProducerSendTest$$createProducer$default$4());
        try {
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            ProducerRecord record0 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1)new Serializable(this, producer, record0){
                public static final long serialVersionUID = 0L;
                private final KafkaProducer producer$3;
                private final ProducerRecord record0$2;

                public final Future<RecordMetadata> apply(int i) {
                    return this.producer$3.send(this.record0$2);
                }
                {
                    this.producer$3 = producer$3;
                    this.record0$2 = record0$2;
                }
            });
            Future response0 = producer.send(record0);
            producer.close();
            Assert.assertTrue((String)"The last message should be acked before producer is shutdown", (boolean)response0.isDone());
            Assert.assertEquals((String)new StringBuilder().append((Object)"Should have offset ").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$api$BaseProducerSendTest$$numRecords())).toString(), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)((RecordMetadata)response0.get()).offset());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        producer.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSendToPartition() {
        KafkaProducer<byte[], byte[]> producer = this.kafka$api$BaseProducerSendTest$$createProducer(this.brokerList(), this.kafka$api$BaseProducerSendTest$$createProducer$default$2(), this.createProducer$default$3(), this.kafka$api$BaseProducerSendTest$$createProducer$default$4());
        try {
            scala.collection.immutable.Map<Object, Option<Object>> leaders = TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 2, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            int partition = 1;
            Option leader1 = (Option)leaders.apply((Object)BoxesRunTime.boxToInteger((int)partition));
            Assert.assertTrue((String)"Leader for topic \"topic\" partition 1 should exist", (boolean)leader1.isDefined());
            long now = System.currentTimeMillis();
            IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, partition, now){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final KafkaProducer producer$4;
                private final int partition$3;
                private final long now$1;

                public final Future<RecordMetadata> apply(int i) {
                    return this.producer$4.send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition$3), Predef$.MODULE$.long2Long(this.now$1), null, (Object)new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producer$4 = producer$4;
                    this.partition$3 = partition$3;
                    this.now$1 = now$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            List futures = responses.toList();
            futures.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$3) {
                    return x$3.get();
                }
            });
            futures.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Future<RecordMetadata> future) {
                    Assert.assertTrue((String)"Request should have completed", (boolean)future.isDone());
                }
            });
            ((TraversableLike)futures.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), List$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Future<RecordMetadata>, Object> check$ifrefutable$1) {
                    Tuple2<Future<RecordMetadata>, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, partition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final int partition$3;

                public final void apply(Tuple2<Future<RecordMetadata>, Object> x$4) {
                    Tuple2<Future<RecordMetadata>, Object> tuple2 = x$4;
                    if (tuple2 != null) {
                        Future future = (Future)tuple2._1();
                        int offset = tuple2._2$mcI$sp();
                        Assert.assertEquals((long)offset, (long)((RecordMetadata)future.get()).offset());
                        Assert.assertEquals((Object)this.$outer.topic(), (Object)((RecordMetadata)future.get()).topic());
                        Assert.assertEquals((long)this.partition$3, (long)((RecordMetadata)future.get()).partition());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.partition$3 = partition$3;
                }
            });
            FetchResponse fetchResponse1 = BoxesRunTime.unboxToInt((Object)leader1.get()) == ((KafkaConfig)this.configs().apply(0)).brokerId() ? this.kafka$api$BaseProducerSendTest$$consumer1().fetch(new FetchRequestBuilder().addFetch(this.topic(), partition, 0L, Integer.MAX_VALUE).build()) : this.kafka$api$BaseProducerSendTest$$consumer2().fetch(new FetchRequestBuilder().addFetch(this.topic(), partition, 0L, Integer.MAX_VALUE).build());
            Buffer messageSet1 = fetchResponse1.messageSet(this.topic(), partition).iterator().toBuffer();
            Assert.assertEquals((String)new StringBuilder().append((Object)"Should have fetched ").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$api$BaseProducerSendTest$$numRecords())).append((Object)" messages").toString(), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)messageSet1.size());
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords() - 1).foreach$mVc$sp((Function1)new Serializable(this, now, messageSet1){
                public static final long serialVersionUID = 0L;
                private final long now$1;
                private final Buffer messageSet1$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    Assert.assertEquals((Object)new Message(new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)(i + 1))).toString().getBytes(), this.now$1, Message$.MODULE$.MagicValue_V1()), (Object)((MessageAndOffset)this.messageSet1$1.apply(i)).message());
                    Assert.assertEquals((long)i, (long)((MessageAndOffset)this.messageSet1$1.apply(i)).offset());
                }
                {
                    this.now$1 = now$1;
                    this.messageSet1$1 = messageSet1$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        producer.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoCreateTopic() {
        KafkaProducer<byte[], byte[]> producer = this.kafka$api$BaseProducerSendTest$$createProducer(this.brokerList(), 5, this.createProducer$default$3(), this.kafka$api$BaseProducerSendTest$$createProducer$default$4());
        try {
            ProducerRecord record = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            Assert.assertEquals((String)"Should have offset 0", (long)0L, (long)((RecordMetadata)producer.send(record).get()).offset());
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        producer.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFlush() {
        String x$53 = this.brokerList();
        long x$54 = Long.MAX_VALUE;
        int x$55 = this.kafka$api$BaseProducerSendTest$$createProducer$default$2();
        Option<Properties> x$56 = this.kafka$api$BaseProducerSendTest$$createProducer$default$4();
        KafkaProducer<byte[], byte[]> producer = this.kafka$api$BaseProducerSendTest$$createProducer(x$53, x$55, x$54, x$56);
        try {
            TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 2, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
            ProducerRecord record = new ProducerRecord(this.topic(), (Object)"value".getBytes());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)new Serializable(this, producer, record){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                public final KafkaProducer producer$5;
                public final ProducerRecord record$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testFlush$1 $outer;

                        public final Future<RecordMetadata> apply(int i) {
                            return this.$outer.producer$5.send(this.$outer.record$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$5) {
                            return !x$5.isDone();
                        }
                    }));
                    this.producer$5.flush();
                    Assert.assertTrue((String)"All requests are complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$6) {
                            return x$6.isDone();
                        }
                    }));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producer$5 = producer$5;
                    this.record$1 = record$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var1_5;
            var1_5.close();
            throw throwable;
        }
        producer.close();
    }

    @Test
    public void testCloseWithZeroTimeoutFromCallerThread() {
        scala.collection.immutable.Map<Object, Option<Object>> leaders = TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 2, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Option leader0 = (Option)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0));
        Option leader1 = (Option)leaders.apply((Object)BoxesRunTime.boxToInteger((int)1));
        ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)"value".getBytes());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)new Serializable(this, leader0, record0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final Option leader0$1;
            public final ProducerRecord record0$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                String x$57 = this.$outer.brokerList();
                long x$58 = Long.MAX_VALUE;
                int x$59 = this.$outer.kafka$api$BaseProducerSendTest$$createProducer$default$2();
                Option<Properties> x$60 = this.$outer.kafka$api$BaseProducerSendTest$$createProducer$default$4();
                KafkaProducer<byte[], byte[]> producer = this.$outer.kafka$api$BaseProducerSendTest$$createProducer(x$57, x$59, x$58, x$60);
                IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCloseWithZeroTimeoutFromCallerThread$1 $outer;
                    private final KafkaProducer producer$6;

                    public final Future<RecordMetadata> apply(int i) {
                        return this.producer$6.send(this.$outer.record0$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.producer$6 = producer$6;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Future<RecordMetadata> x$7) {
                        return !x$7.isDone();
                    }
                }));
                producer.close(0L, TimeUnit.MILLISECONDS);
                responses.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCloseWithZeroTimeoutFromCallerThread$1 $outer;

                    public final void apply(Future<RecordMetadata> future) {
                        try {
                            future.get();
                            throw this.$outer.kafka$api$BaseProducerSendTest$$anonfun$$$outer().fail("No message should be sent successfully.");
                        }
                        catch (Exception exception) {
                            Assert.assertEquals((Object)"java.lang.IllegalStateException: Producer is closed forcefully.", (Object)exception.getMessage());
                            return;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                FetchResponse fetchResponse = BoxesRunTime.unboxToInt((Object)this.leader0$1.get()) == ((KafkaConfig)this.$outer.configs().apply(0)).brokerId() ? this.$outer.kafka$api$BaseProducerSendTest$$consumer1().fetch(new FetchRequestBuilder().addFetch(this.$outer.topic(), 0, 0L, Integer.MAX_VALUE).build()) : this.$outer.kafka$api$BaseProducerSendTest$$consumer2().fetch(new FetchRequestBuilder().addFetch(this.$outer.topic(), 0, 0L, Integer.MAX_VALUE).build());
                Assert.assertEquals((String)"Fetch response should have no message returned.", (long)0L, (long)fetchResponse.messageSet(this.$outer.topic(), 0).size());
            }

            public /* synthetic */ BaseProducerSendTest kafka$api$BaseProducerSendTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leader0$1 = leader0$1;
                this.record0$3 = record0$3;
            }
        });
    }

    @Test
    public void testCloseWithZeroTimeoutFromSenderThread() {
        scala.collection.immutable.Map<Object, Option<Object>> leaders = TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Option leader = (Option)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0));
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)"value".getBytes());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)new Serializable(this, leader, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final Option leader$1;
            public final ProducerRecord record$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            /*
             * WARNING - void declaration
             */
            public void apply$mcVI$sp(int i) {
                String x$61 = this.$outer.brokerList();
                long x$62 = Long.MAX_VALUE;
                int x$63 = this.$outer.kafka$api$BaseProducerSendTest$$createProducer$default$2();
                Option<Properties> x$64 = this.$outer.kafka$api$BaseProducerSendTest$$createProducer$default$4();
                KafkaProducer<byte[], byte[]> producer = this.$outer.kafka$api$BaseProducerSendTest$$createProducer(x$61, x$63, x$62, x$64);
                try {
                    IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testCloseWithZeroTimeoutFromSenderThread$1 $outer;
                        private final KafkaProducer producer$7;

                        public final Future<RecordMetadata> apply(int i) {
                            public class Kafka_api_BaseProducerSendTest$CloseCallback$1
                            implements Callback {
                                public final KafkaProducer<byte[], byte[]> kafka$api$BaseProducerSendTest$CloseCallback$$producer;
                                public final /* synthetic */ BaseProducerSendTest $outer;
                                public final ProducerRecord record$2;

                                public void onCompletion(RecordMetadata metadata, Exception exception) {
                                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$CloseCallback$$$outer().kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ Kafka_api_BaseProducerSendTest$CloseCallback$1 $outer;

                                        public final Future<RecordMetadata> apply(int i) {
                                            return this.$outer.kafka$api$BaseProducerSendTest$CloseCallback$$producer.send(this.$outer.record$2);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    }, IndexedSeq$.MODULE$.canBuildFrom());
                                    this.kafka$api$BaseProducerSendTest$CloseCallback$$producer.close(0L, TimeUnit.MILLISECONDS);
                                    this.kafka$api$BaseProducerSendTest$CloseCallback$$producer.close(Long.MAX_VALUE, TimeUnit.MICROSECONDS);
                                }

                                public /* synthetic */ BaseProducerSendTest kafka$api$BaseProducerSendTest$CloseCallback$$$outer() {
                                    return this.$outer;
                                }

                                public Kafka_api_BaseProducerSendTest$CloseCallback$1(BaseProducerSendTest producer, KafkaProducer<byte[], byte[]> record$2) {
                                    this.kafka$api$BaseProducerSendTest$CloseCallback$$producer = producer;
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.record$2 = record$2;
                                }
                            }
                            return this.producer$7.send(this.$outer.record$2, (Callback)new Kafka_api_BaseProducerSendTest$CloseCallback$1(this.$outer.kafka$api$BaseProducerSendTest$$anonfun$$$outer(), this.producer$7, this.$outer.record$2));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.producer$7 = producer$7;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$8) {
                            return !x$8.isDone();
                        }
                    }));
                    producer.flush();
                    Assert.assertTrue((String)"All request are complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$9) {
                            return x$9.isDone();
                        }
                    }));
                    FetchResponse fetchResponse = BoxesRunTime.unboxToInt((Object)this.leader$1.get()) == ((KafkaConfig)this.$outer.configs().apply(0)).brokerId() ? this.$outer.kafka$api$BaseProducerSendTest$$consumer1().fetch(new FetchRequestBuilder().addFetch(this.$outer.topic(), 0, 0L, Integer.MAX_VALUE).build()) : this.$outer.kafka$api$BaseProducerSendTest$$consumer2().fetch(new FetchRequestBuilder().addFetch(this.$outer.topic(), 0, 0L, Integer.MAX_VALUE).build());
                    int expectedNumRecords = (i + 1) * this.$outer.kafka$api$BaseProducerSendTest$$numRecords();
                    Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("Fetch response to partition 0 should have %d messages.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedNumRecords)})), (long)expectedNumRecords, (long)fetchResponse.messageSet(this.$outer.topic(), 0).size());
                }
                catch (Throwable throwable) {
                    void var2_6;
                    var2_6.close();
                    throw throwable;
                }
                producer.close();
            }

            public /* synthetic */ BaseProducerSendTest kafka$api$BaseProducerSendTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leader$1 = leader$1;
                this.record$2 = record$2;
            }
        });
    }

    @Test
    public void testSendWithInvalidCreateTime() {
        Properties topicProps = new Properties();
        topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), "1000");
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), topicProps);
        try (KafkaProducer<byte[], byte[]> producer = this.kafka$api$BaseProducerSendTest$$createProducer(this.brokerList(), this.kafka$api$BaseProducerSendTest$$createProducer$default$2(), this.createProducer$default$3(), this.kafka$api$BaseProducerSendTest$$createProducer$default$4());){
            try {
                producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(System.currentTimeMillis() - 1001L), (Object)"key".getBytes(), (Object)"value".getBytes())).get();
                throw this.fail("Should throw CorruptedRecordException");
            }
            catch (ExecutionException executionException) {
                Assert.assertTrue((boolean)(executionException.getCause() instanceof InvalidTimestampException));
            }
        }
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", "gzip");
        String x$65 = this.brokerList();
        Some x$66 = new Some((Object)producerProps);
        int x$67 = this.kafka$api$BaseProducerSendTest$$createProducer$default$2();
        long x$68 = this.createProducer$default$3();
        try (KafkaProducer<byte[], byte[]> compressedProducer = this.kafka$api$BaseProducerSendTest$$createProducer(x$65, x$67, x$68, (Option<Properties>)x$66);){
            try {
                compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(System.currentTimeMillis() - 1001L), (Object)"key".getBytes(), (Object)"value".getBytes())).get();
                throw this.fail("Should throw CorruptedRecordException");
            }
            catch (ExecutionException executionException) {
                Assert.assertTrue((boolean)(executionException.getCause() instanceof InvalidTimestampException));
            }
        }
    }

    public final BaseProducerSendTest$callback$3$ kafka$api$BaseProducerSendTest$$callback$1(Integer partition$1, VolatileObjectRef callback$module$1) {
        return callback$module$1.elem == null ? this.kafka$api$BaseProducerSendTest$$callback$1$lzycompute(partition$1, callback$module$1) : (BaseProducerSendTest$callback$3$)callback$module$1.elem;
    }

    public final BaseProducerSendTest$callback$4$ kafka$api$BaseProducerSendTest$$callback$2(TimestampType timestampType$1, Integer partition$2, long baseTimestamp$1, long startTime$1, VolatileObjectRef callback$module$2) {
        return callback$module$2.elem == null ? this.kafka$api$BaseProducerSendTest$$callback$2$lzycompute(timestampType$1, partition$2, baseTimestamp$1, startTime$1, callback$module$2) : (BaseProducerSendTest$callback$4$)callback$module$2.elem;
    }

    public BaseProducerSendTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        this.kafka$api$BaseProducerSendTest$$consumer1 = null;
        this.kafka$api$BaseProducerSendTest$$consumer2 = null;
        this.producers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.topic = "topic";
        this.kafka$api$BaseProducerSendTest$$numRecords = 100;
    }
}

