/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.common.FailedToSendMessageException;
import kafka.consumer.SimpleConsumer;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.serializer.StringEncoder;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.StaticPartitioner;
import kafka.utils.SystemTime$;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.record.TimestampType;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.exceptions.TestFailedException;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001B\u0001\u0003\u0001\u001d\u0011A\u0002\u0015:pIV\u001cWM\u001d+fgRT!a\u0001\u0003\u0002\u0011A\u0014x\u000eZ;dKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0005\r\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u0011!BS+oSR\u001cV/\u001b;f!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0002{W&\u0011q\u0003\u0006\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0011\u0005eaR\"\u0001\u000e\u000b\u0005m!\u0011!B;uS2\u001c\u0018BA\u000f\u001b\u0005\u001daunZ4j]\u001eDQa\b\u0001\u0005\u0002\u0001\na\u0001P5oSRtD#A\u0011\u0011\u0005\t\u0002Q\"\u0001\u0002\t\u000f\u0011\u0002!\u0019!C\u0005K\u0005I!M]8lKJLE-M\u000b\u0002MA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t\u0019\u0011J\u001c;\t\r5\u0002\u0001\u0015!\u0003'\u0003)\u0011'o\\6fe&#\u0017\u0007\t\u0005\b_\u0001\u0011\r\u0011\"\u0003&\u0003%\u0011'o\\6fe&#'\u0007\u0003\u00042\u0001\u0001\u0006IAJ\u0001\u000bEJ|7.\u001a:JIJ\u0002\u0003bB\u001a\u0001\u0001\u0004%I\u0001N\u0001\bg\u0016\u0014h/\u001a:2+\u0005)\u0004C\u0001\u001c:\u001b\u00059$B\u0001\u001d\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011!h\u000e\u0002\f\u0017\u000647.Y*feZ,'\u000fC\u0004=\u0001\u0001\u0007I\u0011B\u001f\u0002\u0017M,'O^3sc}#S-\u001d\u000b\u0003}\u0005\u0003\"aJ \n\u0005\u0001C#\u0001B+oSRDqAQ\u001e\u0002\u0002\u0003\u0007Q'A\u0002yIEBa\u0001\u0012\u0001!B\u0013)\u0014\u0001C:feZ,'/\r\u0011\t\u000f\u0019\u0003\u0001\u0019!C\u0005i\u000591/\u001a:wKJ\u0014\u0004b\u0002%\u0001\u0001\u0004%I!S\u0001\fg\u0016\u0014h/\u001a:3?\u0012*\u0017\u000f\u0006\u0002?\u0015\"9!iRA\u0001\u0002\u0004)\u0004B\u0002'\u0001A\u0003&Q'\u0001\u0005tKJ4XM\u001d\u001a!\u0011\u001dq\u0005\u00011A\u0005\n=\u000b\u0011bY8ogVlWM]\u0019\u0016\u0003A\u0003\"!\u0015+\u000e\u0003IS!a\u0015\u0003\u0002\u0011\r|gn];nKJL!!\u0016*\u0003\u001dMKW\u000e\u001d7f\u0007>t7/^7fe\"9q\u000b\u0001a\u0001\n\u0013A\u0016!D2p]N,X.\u001a:2?\u0012*\u0017\u000f\u0006\u0002?3\"9!IVA\u0001\u0002\u0004\u0001\u0006BB.\u0001A\u0003&\u0001+\u0001\u0006d_:\u001cX/\\3sc\u0001Bq!\u0018\u0001A\u0002\u0013%q*A\u0005d_:\u001cX/\\3se!9q\f\u0001a\u0001\n\u0013\u0001\u0017!D2p]N,X.\u001a:3?\u0012*\u0017\u000f\u0006\u0002?C\"9!IXA\u0001\u0002\u0004\u0001\u0006BB2\u0001A\u0003&\u0001+\u0001\u0006d_:\u001cX/\\3se\u0001Bq!\u001a\u0001C\u0002\u0013%a-\u0001\u000bsKF,Xm\u001d;IC:$G.\u001a:M_\u001e<WM]\u000b\u0002OB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\u0006Y><GG\u001b\u0006\u0003Y:\ta!\u00199bG\",\u0017B\u00018j\u0005\u0019aunZ4fe\"1\u0001\u000f\u0001Q\u0001\n\u001d\fQC]3rk\u0016\u001cH\u000fS1oI2,'\u000fT8hO\u0016\u0014\b\u0005C\u0004s\u0001\u0001\u0007I\u0011B:\u0002\u000fM,'O^3sgV\tA\u000fE\u0002vuVj\u0011A\u001e\u0006\u0003ob\f\u0011\"[7nkR\f'\r\\3\u000b\u0005eD\u0013AC2pY2,7\r^5p]&\u00111P\u001e\u0002\u0005\u0019&\u001cH\u000fC\u0004~\u0001\u0001\u0007I\u0011\u0002@\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003}}DqA\u0011?\u0002\u0002\u0003\u0007A\u000fC\u0004\u0002\u0004\u0001\u0001\u000b\u0015\u0002;\u0002\u0011M,'O^3sg\u0002Bq!a\u0002\u0001\t\u0003\tI!\u0001\u0007hKR\u001cuN\\:v[\u0016\u0014\u0018\u0007F\u0001Q\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u0013\tAbZ3u\u0007>t7/^7feJBq!!\u0005\u0001\t\u0003\n\u0019\"A\u0003tKR,\u0006\u000fF\u0001?Q\u0011\ty!a\u0006\u0011\t\u0005e\u0011QD\u0007\u0003\u00037Q!a\u0003\b\n\t\u0005}\u00111\u0004\u0002\u0007\u0005\u00164wN]3\t\u000f\u0005\r\u0002\u0001\"\u0011\u0002\u0014\u0005AA/Z1s\t><h\u000e\u000b\u0003\u0002\"\u0005\u001d\u0002\u0003BA\r\u0003SIA!a\u000b\u0002\u001c\t)\u0011I\u001a;fe\"9\u0011q\u0006\u0001\u0005\u0002\u0005M\u0011!\b;fgR,\u0006\u000fZ1uK\n\u0013xn[3s!\u0006\u0014H/\u001b;j_:LeNZ8)\t\u00055\u00121\u0007\t\u0005\u00033\t)$\u0003\u0003\u00028\u0005m!\u0001\u0002+fgRDq!a\u000f\u0001\t\u0003\t\u0019\"\u0001\nuKN$8+\u001a8e)>tUm\u001e+pa&\u001c\u0007\u0006BA\u001d\u0003gAq!!\u0011\u0001\t\u0003\t\u0019\"\u0001\fuKN$8+\u001a8e/&$\b\u000eR3bI\n\u0013xn[3sQ\u0011\ty$a\r\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002\u0014\u0005AC/Z:u\u0003NLhnY*f]\u0012\u001c\u0015M\\\"peJ,7\r\u001e7z\r\u0006LGnV5uQRKW.Z8vi\"\"\u0011QIA\u001a\u0011\u001d\ti\u0005\u0001C\u0001\u0003'\t1\u0003^3tiN+g\u000e\u001a(vY2lUm]:bO\u0016DC!a\u0013\u00024!:\u0001!a\u0015\u0002Z\u0005u\u0003cA\u0014\u0002V%\u0019\u0011q\u000b\u0015\u0003\u0015\u0011,\u0007O]3dCR,G-\t\u0002\u0002\\\u0005IE\u000b[5tAQ,7\u000f\u001e\u0011iCN\u0004#-Z3oA\u0011,\u0007O]3dCR,G\rI1oI\u0002JG\u000fI<jY2\u0004#-\u001a\u0011sK6|g/\u001a3!S:\u0004\u0013\r\t4viV\u0014X\r\t:fY\u0016\f7/\u001a\u0018\"\u0005\u0005}\u0013\u0001\u0003\u0019/cAr\u0003G\f\u0019")
public class ProducerTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private KafkaServer server1;
    private KafkaServer server2;
    private SimpleConsumer consumer1;
    private SimpleConsumer consumer2;
    private final Logger requestHandlerLogger;
    private List<KafkaServer> servers;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ProducerTest producerTest = this;
        synchronized (producerTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    private int brokerId1() {
        return this.brokerId1;
    }

    private int brokerId2() {
        return this.brokerId2;
    }

    private KafkaServer server1() {
        return this.server1;
    }

    private void server1_$eq(KafkaServer x$1) {
        this.server1 = x$1;
    }

    private KafkaServer server2() {
        return this.server2;
    }

    private void server2_$eq(KafkaServer x$1) {
        this.server2 = x$1;
    }

    private SimpleConsumer consumer1() {
        return this.consumer1;
    }

    private void consumer1_$eq(SimpleConsumer x$1) {
        this.consumer1 = x$1;
    }

    private SimpleConsumer consumer2() {
        return this.consumer2;
    }

    private void consumer2_$eq(SimpleConsumer x$1) {
        this.consumer2 = x$1;
    }

    private Logger requestHandlerLogger() {
        return this.requestHandlerLogger;
    }

    private List<KafkaServer> servers() {
        return this.servers;
    }

    private void servers_$eq(List<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public SimpleConsumer getConsumer1() {
        if (this.consumer1() == null) {
            KafkaServer qual$1 = this.server1();
            SecurityProtocol x$1 = qual$1.boundPort$default$1();
            this.consumer1_$eq(new SimpleConsumer("localhost", qual$1.boundPort(x$1), 1000000, 65536, ""));
        }
        return this.consumer1();
    }

    public SimpleConsumer getConsumer2() {
        if (this.consumer2() == null) {
            KafkaServer qual$2 = this.server2();
            SecurityProtocol x$2 = qual$2.boundPort$default$1();
            this.consumer2_$eq(new SimpleConsumer("localhost", qual$2.boundPort(x$2), 100, 65536, ""));
        }
        return this.consumer2();
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props1.put("num.partitions", "4");
        KafkaConfig config1 = KafkaConfig$.MODULE$.fromProps(props1);
        Properties props2 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props2.put("num.partitions", "4");
        KafkaConfig config2 = KafkaConfig$.MODULE$.fromProps(props2);
        this.server1_$eq(TestUtils$.MODULE$.createServer(config1, TestUtils$.MODULE$.createServer$default$2()));
        this.server2_$eq(TestUtils$.MODULE$.createServer(config2, TestUtils$.MODULE$.createServer$default$2()));
        this.servers_$eq((List<KafkaServer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1(), this.server2()})));
        Properties props = new Properties();
        props.put("host", "localhost");
        KafkaServer qual$3 = this.server1();
        SecurityProtocol x$3 = qual$3.boundPort$default$1();
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)qual$3.boundPort(x$3))).toString());
        this.requestHandlerLogger().setLevel(Level.FATAL);
    }

    @Override
    @After
    public void tearDown() {
        this.requestHandlerLogger().setLevel(Level.ERROR);
        if (this.consumer1() != null) {
            this.consumer1().close();
        }
        if (this.consumer2() != null) {
            this.consumer2().close();
        }
        this.server1().shutdown();
        this.server2().shutdown();
        CoreUtils$.MODULE$.delete(this.server1().config().logDirs());
        CoreUtils$.MODULE$.delete(this.server2().config().logDirs());
        ZooKeeperTestHarness$class.tearDown(this);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdateBrokerPartitionInfo() {
        String topic = "new-topic";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Properties props = new Properties();
        props.put("message.send.max.retries", "0");
        String x$4 = "localhost:80,localhost:81";
        String x$5 = StringEncoder.class.getName();
        String x$6 = StringEncoder.class.getName();
        Properties x$7 = props;
        String x$8 = TestUtils$.MODULE$.createProducer$default$4();
        try (Producer producer1 = TestUtils$.MODULE$.createProducer(x$4, x$5, x$6, x$8, x$7);){
            try {
                producer1.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test", (Object)"test1")}));
                throw this.fail("Test should fail because the broker list provided are not valid");
            }
            catch (Throwable throwable) {
                throw this.fail("fails with exception", throwable);
            }
            catch (FailedToSendMessageException failedToSendMessageException) {
            }
        }
        Producer producer2 = TestUtils$.MODULE$.createProducer(new StringBuilder().append((Object)"localhost:80,").append((Object)TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1()}))), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2())).toString(), StringEncoder.class.getName(), StringEncoder.class.getName(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5());
        try {
            producer2.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test", (Object)"test1")}));
        }
        catch (Throwable throwable) {
            try {
                throw this.fail("Should succeed sending the message", throwable);
            }
            catch (Throwable throwable2) {
                void var12_12;
                var12_12.close();
                throw throwable2;
            }
        }
        producer2.close();
        Producer producer3 = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1(), this.server2()}))), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), StringEncoder.class.getName(), StringEncoder.class.getName(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5());
        try {
            producer3.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test", (Object)"test1")}));
        }
        catch (Throwable throwable) {
            try {
                throw this.fail("Should succeed sending the message", throwable);
            }
            catch (Throwable throwable3) {
                void var15_13;
                var15_13.close();
                throw throwable3;
            }
        }
        producer3.close();
    }

    @Test
    public void testSendToNewTopic() {
        Buffer buffer;
        Properties props1 = new Properties();
        props1.put("request.required.acks", "-1");
        String topic = "new-topic";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Producer producer1 = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1(), this.server2()}))), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), StringEncoder.class.getName(), StringEncoder.class.getName(), StaticPartitioner.class.getName(), props1);
        long startTime = System.currentTimeMillis();
        producer1.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test", (Object)"test1")}));
        producer1.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test", (Object)"test2")}));
        long endTime = System.currentTimeMillis();
        Option leaderOpt = this.zkUtils().getLeaderForPartition(topic, 0);
        Assert.assertTrue((String)"Leader for topic new-topic partition 0 should exist", (boolean)leaderOpt.isDefined());
        int leader = BoxesRunTime.unboxToInt((Object)leaderOpt.get());
        if (leader == this.server1().config().brokerId()) {
            FetchResponse response1 = this.getConsumer1().fetch(new FetchRequestBuilder().addFetch(topic, 0, 0L, 10000).build());
            buffer = response1.messageSet("new-topic", 0).iterator().toBuffer();
        } else {
            FetchResponse response2 = this.getConsumer2().fetch(new FetchRequestBuilder().addFetch(topic, 0, 0L, 10000).build());
            buffer = response2.messageSet("new-topic", 0).iterator().toBuffer();
        }
        Buffer messageSet = buffer;
        Assert.assertEquals((String)"Should have fetched 2 messages", (long)2L, (long)messageSet.size());
        Assert.assertTrue((boolean)ByteBuffer.wrap("test1".getBytes()).equals(((MessageAndOffset)messageSet.apply(0)).message().payload()));
        Assert.assertTrue((boolean)ByteBuffer.wrap("test".getBytes()).equals(((MessageAndOffset)messageSet.apply(0)).message().key()));
        Assert.assertTrue((((MessageAndOffset)messageSet.apply(0)).message().timestamp() >= startTime && ((MessageAndOffset)messageSet.apply(0)).message().timestamp() < endTime ? 1 : 0) != 0);
        Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)((MessageAndOffset)messageSet.apply(0)).message().timestampType());
        Assert.assertEquals((long)Message$.MODULE$.MagicValue_V1(), (long)((MessageAndOffset)messageSet.apply(0)).message().magic());
        Assert.assertTrue((boolean)ByteBuffer.wrap("test2".getBytes()).equals(((MessageAndOffset)messageSet.apply(1)).message().payload()));
        Assert.assertTrue((boolean)ByteBuffer.wrap("test".getBytes()).equals(((MessageAndOffset)messageSet.apply(1)).message().key()));
        Assert.assertTrue((((MessageAndOffset)messageSet.apply(1)).message().timestamp() >= startTime && ((MessageAndOffset)messageSet.apply(1)).message().timestamp() < endTime ? 1 : 0) != 0);
        Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)((MessageAndOffset)messageSet.apply(1)).message().timestampType());
        Assert.assertEquals((long)Message$.MODULE$.MagicValue_V1(), (long)((MessageAndOffset)messageSet.apply(1)).message().magic());
        producer1.close();
        Properties props2 = new Properties();
        props2.put("request.required.acks", "3");
        props2.put("message.send.max.retries", "0");
        try {
            Producer producer2 = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1(), this.server2()}))), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), StringEncoder.class.getName(), StringEncoder.class.getName(), StaticPartitioner.class.getName(), props2);
            producer2.close();
            throw this.fail("we don't support request.required.acks greater than 1");
        }
        catch (Throwable throwable) {
            throw this.fail("Not expected", throwable);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    /*
     * Loose catch block
     */
    @Test
    public void testSendWithDeadBroker() {
        Properties props = new Properties();
        props.put("request.required.acks", "1");
        props.put("message.send.max.retries", "0");
        String topic = "new-topic";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}))), (Seq<KafkaServer>)this.servers());
        Producer producer = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1(), this.server2()}))), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), StringEncoder.class.getName(), StringEncoder.class.getName(), StaticPartitioner.class.getName(), props);
        long startTime = System.currentTimeMillis();
        try {
            producer.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test", (Object)"test1")}));
        }
        catch (Throwable throwable) {
            throw this.fail(new StringBuilder().append((Object)"Unexpected exception: ").append((Object)throwable).toString());
        }
        long endTime = System.currentTimeMillis();
        this.server1().shutdown();
        this.server1().awaitShutdown();
        try {
            producer.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test", (Object)"test1")}));
            throw this.fail("Should fail since no leader exists for the partition.");
        }
        catch (Throwable throwable) {
            this.server1().startup();
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), topic, 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), topic, 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            TestUtils$.MODULE$.waitUntilLeaderIsKnown((Seq<KafkaServer>)this.servers(), topic, 0, TestUtils$.MODULE$.waitUntilLeaderIsKnown$default$4());
            FetchResponse response1 = this.getConsumer1().fetch(new FetchRequestBuilder().addFetch(topic, 0, 0L, 10000).build());
            Iterator messageSet1 = response1.messageSet(topic, 0).iterator();
            Assert.assertTrue((String)"Message set should have 1 message", (boolean)messageSet1.hasNext());
            Message message = ((MessageAndOffset)messageSet1.next()).message();
            Assert.assertTrue((boolean)ByteBuffer.wrap("test1".getBytes()).equals(message.payload()));
            Assert.assertTrue((boolean)ByteBuffer.wrap("test".getBytes()).equals(message.key()));
            Assert.assertTrue((message.timestamp() >= startTime && message.timestamp() < endTime ? 1 : 0) != 0);
            Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)message.timestampType());
            Assert.assertEquals((long)Message$.MODULE$.MagicValue_V1(), (long)message.magic());
            Assert.assertFalse((String)"Message set should have another message", (boolean)messageSet1.hasNext());
            producer.close();
            return;
        }
        catch (TestFailedException testFailedException) {
            throw testFailedException;
        }
        {
            catch (Exception exception) {
                throw this.fail("Not expected", exception);
            }
        }
    }

    @Test
    public void testAsyncSendCanCorrectlyFailWithTimeout() {
        int timeoutMs = 500;
        Properties props = new Properties();
        props.put("request.timeout.ms", String.valueOf(timeoutMs));
        props.put("request.required.acks", "1");
        props.put("message.send.max.retries", "0");
        props.put("client.id", "ProducerTest-testAsyncSendCanCorrectlyFailWithTimeout");
        Producer producer = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1(), this.server2()}))), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), StringEncoder.class.getName(), StringEncoder.class.getName(), StaticPartitioner.class.getName(), props);
        String topic = "new-topic";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), (Seq<KafkaServer>)this.servers());
        try {
            producer.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test", (Object)"test")}));
            FetchResponse response1 = this.getConsumer1().fetch(new FetchRequestBuilder().addFetch(topic, 0, 0L, 10000).build());
            Iterator messageSet1 = response1.messageSet("new-topic", 0).iterator();
            Assert.assertTrue((String)"Message set should have 1 message", (boolean)messageSet1.hasNext());
            Assert.assertEquals((Object)new Message("test".getBytes()), (Object)((MessageAndOffset)messageSet1.next()).message());
        }
        catch (Exception exception) {
            producer.close();
            throw this.fail("Not expected", exception);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.server1().requestHandlerPool().shutdown();
        long t1 = SystemTime$.MODULE$.milliseconds();
        try {
            try {
                producer.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(topic, (Object)"test", (Object)"test")}));
            }
            catch (Exception exception) {
                throw this.fail("Not expected", exception);
            }
            catch (FailedToSendMessageException failedToSendMessageException) {
            }
        }
        finally {
            producer.close();
        }
        long t2 = SystemTime$.MODULE$.milliseconds();
        Assert.assertTrue((t2 - t1 >= (long)timeoutMs ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSendNullMessage() {
        Producer producer = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1(), this.server2()}))), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), StringEncoder.class.getName(), StringEncoder.class.getName(), StaticPartitioner.class.getName(), TestUtils$.MODULE$.createProducer$default$5());
        try {
            AdminUtils$.MODULE$.createTopic(this.zkUtils(), "new-topic", 2, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProducerTest $outer;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    Errors errors = AdminUtils$.MODULE$.fetchTopicMetadataFromZk("new-topic", this.$outer.zkUtils()).error();
                    Errors errors2 = Errors.UNKNOWN_TOPIC_OR_PARTITION;
                    return errors != null ? !errors.equals(errors2) : errors2 != null;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, "Topic new-topic not created after timeout", this.zookeeper().tickTime());
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), "new-topic", 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            producer.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("new-topic", (Object)"key", null)}));
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        producer.close();
    }

    public ProducerTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.brokerId1 = 0;
        this.brokerId2 = 1;
        this.server1 = null;
        this.server2 = null;
        this.consumer1 = null;
        this.consumer2 = null;
        this.requestHandlerLogger = Logger.getLogger(KafkaRequestHandler.class);
        this.servers = List$.MODULE$.empty();
    }
}

