/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.concurrent.TimeUnit;
import kafka.utils.ByteBoundedBlockingQueue;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q2A!\u0001\u0002\u0001\u000f\ta\")\u001f;f\u0005>,h\u000eZ3e\u00052|7m[5oOF+X-^3UKN$(BA\u0002\u0005\u0003\u0015)H/\u001b7t\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u001d!\u0002A1A\u0005\u0002U\tAb]5{K\u001a+hn\u0019;j_:,\u0012A\u0006\t\u0005\u0013]I\u0002%\u0003\u0002\u0019\u0015\tIa)\u001e8di&|g.\r\t\u00035uq!!C\u000e\n\u0005qQ\u0011A\u0002)sK\u0012,g-\u0003\u0002\u001f?\t11\u000b\u001e:j]\u001eT!\u0001\b\u0006\u0011\u0005%\t\u0013B\u0001\u0012\u000b\u0005\rIe\u000e\u001e\u0005\u0007I\u0001\u0001\u000b\u0011\u0002\f\u0002\u001bML'0\u001a$v]\u000e$\u0018n\u001c8!\u0011\u001d1\u0003A1A\u0005\u0002\u001d\nQ!];fk\u0016,\u0012\u0001\u000b\t\u0004%%J\u0012B\u0001\u0016\u0003\u0005a\u0011\u0015\u0010^3C_VtG-\u001a3CY>\u001c7.\u001b8h#V,W/\u001a\u0005\u0007Y\u0001\u0001\u000b\u0011\u0002\u0015\u0002\rE,X-^3!\u0011\u0015q\u0003\u0001\"\u00010\u0003q!Xm\u001d;CsR,'i\\;oI\u0016$'\t\\8dW&tw-U;fk\u0016$\u0012\u0001\r\t\u0003\u0013EJ!A\r\u0006\u0003\tUs\u0017\u000e\u001e\u0015\u0003[Q\u0002\"!\u000e\u001e\u000e\u0003YR!a\u000e\u001d\u0002\u000b),h.\u001b;\u000b\u0003e\n1a\u001c:h\u0013\tYdG\u0001\u0003UKN$\b")
public class ByteBoundedBlockingQueueTest {
    private final Function1<String, Object> sizeFunction = new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final int apply(String a) {
            return a.length();
        }
    };
    private final ByteBoundedBlockingQueue<String> queue = new ByteBoundedBlockingQueue(5, 15, (Option)new Some(this.sizeFunction()));

    public Function1<String, Object> sizeFunction() {
        return this.sizeFunction;
    }

    public ByteBoundedBlockingQueue<String> queue() {
        return this.queue;
    }

    @Test
    public void testByteBoundedBlockingQueue() {
        Assert.assertEquals((long)5L, (long)this.queue().remainingSize());
        Assert.assertEquals((long)15L, (long)this.queue().remainingByteSize());
        String m0 = new String("0123456789");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)this.queue().offer((Object)m0)));
        Assert.assertEquals((long)1L, (long)this.queue().size());
        Assert.assertEquals((long)10L, (long)this.queue().byteSize());
        Assert.assertEquals((long)4L, (long)this.queue().remainingSize());
        Assert.assertEquals((long)5L, (long)this.queue().remainingByteSize());
        String m1 = new String("1234567890");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)this.queue().offer((Object)m1)));
        Assert.assertEquals((long)2L, (long)this.queue().size());
        Assert.assertEquals((long)20L, (long)this.queue().byteSize());
        Assert.assertEquals((long)3L, (long)this.queue().remainingSize());
        Assert.assertEquals((long)0L, (long)this.queue().remainingByteSize());
        String m2 = new String("2345678901");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.queue().offer((Object)m2, 10L, TimeUnit.MILLISECONDS)));
        Assert.assertEquals((long)2L, (long)this.queue().size());
        Assert.assertEquals((long)20L, (long)this.queue().byteSize());
        Assert.assertEquals((long)3L, (long)this.queue().remainingSize());
        Assert.assertEquals((long)0L, (long)this.queue().remainingByteSize());
        Assert.assertEquals((Object)"0123456789", (Object)this.queue().take());
        Assert.assertEquals((long)1L, (long)this.queue().size());
        Assert.assertEquals((long)10L, (long)this.queue().byteSize());
        Assert.assertEquals((long)4L, (long)this.queue().remainingSize());
        Assert.assertEquals((long)5L, (long)this.queue().remainingByteSize());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)this.queue().put((Object)"a")));
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)this.queue().offer((Object)"b")));
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)this.queue().offer((Object)"c")));
        Assert.assertEquals((long)4L, (long)this.queue().size());
        Assert.assertEquals((long)13L, (long)this.queue().byteSize());
        Assert.assertEquals((long)1L, (long)this.queue().remainingSize());
        Assert.assertEquals((long)2L, (long)this.queue().remainingByteSize());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)this.queue().offer((Object)"d")));
        Assert.assertEquals((long)5L, (long)this.queue().size());
        Assert.assertEquals((long)14L, (long)this.queue().byteSize());
        Assert.assertEquals((long)0L, (long)this.queue().remainingSize());
        Assert.assertEquals((long)1L, (long)this.queue().remainingByteSize());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.queue().offer((Object)"e")));
        Assert.assertEquals((long)5L, (long)this.queue().size());
        Assert.assertEquals((long)14L, (long)this.queue().byteSize());
        Assert.assertEquals((long)0L, (long)this.queue().remainingSize());
        Assert.assertEquals((long)1L, (long)this.queue().remainingByteSize());
        Assert.assertEquals((Object)"1234567890", (Object)this.queue().poll(10L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)"a", (Object)this.queue().poll());
        Assert.assertEquals((Object)"b", (Object)this.queue().poll());
        Assert.assertEquals((Object)"c", (Object)this.queue().poll());
        Assert.assertEquals((Object)"d", (Object)this.queue().poll());
        Assert.assertEquals(null, (Object)this.queue().poll(10L, TimeUnit.MILLISECONDS));
    }
}

