/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.IntegrationTestHarness$class;
import kafka.common.Topic$;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\rEe!B\u0001\u0003\u0003\u00039!\u0001\u0005\"bg\u0016\u001cuN\\:v[\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0002ba&T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0005\f\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u0011!BS+oSR\u001cV/\u001b;f!\t\u0019B#D\u0001\u0003\u0013\t)\"A\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t!\t9\"$D\u0001\u0019\u0015\tIB!A\u0003vi&d7/\u0003\u0002\u001c1\t9Aj\\4hS:<\u0007\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001 !\t\u0019\u0002\u0001C\u0004\"\u0001\t\u0007I\u0011\u0001\u0012\u0002\u000f\u0015\u00048/\u001b7p]V\t1\u0005\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004E_V\u0014G.\u001a\u0005\u0007U\u0001\u0001\u000b\u0011B\u0012\u0002\u0011\u0015\u00048/\u001b7p]\u0002Bq\u0001\f\u0001C\u0002\u0013\u0005Q&A\u0007qe>$WoY3s\u0007>,h\u000e^\u000b\u0002]A\u0011AeL\u0005\u0003a\u0015\u00121!\u00138u\u0011\u0019\u0011\u0004\u0001)A\u0005]\u0005q\u0001O]8ek\u000e,'oQ8v]R\u0004\u0003b\u0002\u001b\u0001\u0005\u0004%\t!L\u0001\u000eG>t7/^7fe\u000e{WO\u001c;\t\rY\u0002\u0001\u0015!\u0003/\u00039\u0019wN\\:v[\u0016\u00148i\\;oi\u0002Bq\u0001\u000f\u0001C\u0002\u0013\u0005Q&A\u0006tKJ4XM]\"pk:$\bB\u0002\u001e\u0001A\u0003%a&\u0001\u0007tKJ4XM]\"pk:$\b\u0005C\u0004=\u0001\t\u0007I\u0011A\u001f\u0002\u000bQ|\u0007/[2\u0016\u0003y\u0002\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\t1\fgn\u001a\u0006\u0002\u0007\u0006!!.\u0019<b\u0013\t)\u0005I\u0001\u0004TiJLgn\u001a\u0005\u0007\u000f\u0002\u0001\u000b\u0011\u0002 \u0002\rQ|\u0007/[2!\u0011\u001dI\u0005A1A\u0005\u00025\nA\u0001]1si\"11\n\u0001Q\u0001\n9\nQ\u0001]1si\u0002Bq!\u0014\u0001C\u0002\u0013\u0005a*\u0001\u0002uaV\tq\n\u0005\u0002Q-6\t\u0011K\u0003\u0002S'\u000611m\\7n_:T!!\u0002+\u000b\u0005Us\u0011AB1qC\u000eDW-\u0003\u0002X#\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007BB-\u0001A\u0003%q*A\u0002ua\u0002Bqa\u0017\u0001C\u0002\u0013\u0005Q&A\u0003qCJ$(\u0007\u0003\u0004^\u0001\u0001\u0006IAL\u0001\u0007a\u0006\u0014HO\r\u0011\t\u000f}\u0003!\u0019!C\u0001\u001d\u0006\u0019A\u000f\u001d\u001a\t\r\u0005\u0004\u0001\u0015!\u0003P\u0003\u0011!\bO\r\u0011\t\u000b\r\u0004A\u0011\t3\u0002\u000bM,G/\u00169\u0015\u0003\u0015\u0004\"\u0001\n4\n\u0005\u001d,#\u0001B+oSRD#AY5\u0011\u0005)dW\"A6\u000b\u0005-q\u0011BA7l\u0005\u0019\u0011UMZ8sK\")q\u000e\u0001C\u0001I\u0006)B/Z:u'&l\u0007\u000f\\3D_:\u001cX/\u001c9uS>t\u0007F\u00018r!\tQ'/\u0003\u0002tW\n!A+Z:u\u0011\u0015)\b\u0001\"\u0001e\u0003]!Xm\u001d;D_>\u0014H-\u001b8bi>\u0014h)Y5m_Z,'\u000f\u000b\u0002uc\u001a!\u0001\u0010\u0001\u0005z\u0005\u0001\"Vm\u001d;D_:\u001cX/\\3s%\u0016\f7o]5h]6,g\u000e\u001e'jgR,g.\u001a:\u0014\u0007]TX\u0010\u0005\u0002@w&\u0011A\u0010\u0011\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007y\f9!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\u0011\r|gn];nKJT1!!\u0002T\u0003\u001d\u0019G.[3oiNL1!!\u0003\u0000\u0005e\u0019uN\\:v[\u0016\u0014(+\u001a2bY\u0006t7-\u001a'jgR,g.\u001a:\t\ru9H\u0011AA\u0007)\t\ty\u0001E\u0002\u0002\u0012]l\u0011\u0001\u0001\u0005\t\u0003+9\b\u0019!C\u0001[\u0005y1-\u00197mgR{\u0017i]:jO:,G\rC\u0005\u0002\u001a]\u0004\r\u0011\"\u0001\u0002\u001c\u0005\u00192-\u00197mgR{\u0017i]:jO:,Gm\u0018\u0013fcR\u0019Q-!\b\t\u0013\u0005}\u0011qCA\u0001\u0002\u0004q\u0013a\u0001=%c!9\u00111E<!B\u0013q\u0013\u0001E2bY2\u001cHk\\!tg&<g.\u001a3!\u0011!\t9c\u001ea\u0001\n\u0003i\u0013AD2bY2\u001cHk\u001c*fm>\\W\r\u001a\u0005\n\u0003W9\b\u0019!C\u0001\u0003[\t!cY1mYN$vNU3w_.,Gm\u0018\u0013fcR\u0019Q-a\f\t\u0013\u0005}\u0011\u0011FA\u0001\u0002\u0004q\u0003bBA\u001ao\u0002\u0006KAL\u0001\u0010G\u0006dGn\u001d+p%\u00164xn[3eA!9\u0011qG<\u0005\u0002\u0005e\u0012\u0001F8o!\u0006\u0014H/\u001b;j_:\u001c\u0018i]:jO:,G\rF\u0002f\u0003wA\u0001\"!\u0010\u00026\u0001\u0007\u0011qH\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b#BA!\u0003\u000fzUBAA\"\u0015\r\t)EQ\u0001\u0005kRLG.\u0003\u0003\u0002J\u0005\r#AC\"pY2,7\r^5p]\"9\u0011QJ<\u0005\u0002\u0005=\u0013aE8o!\u0006\u0014H/\u001b;j_:\u001c(+\u001a<pW\u0016$GcA3\u0002R!A\u0011QHA&\u0001\u0004\ty\u0004C\u0004\u0002V\u0001!\t\"a\u0016\u0002\u0017M,g\u000e\u001a*fG>\u0014Hm\u001d\u000b\u0005\u00033\nI\t\u0005\u0004\u0002\\\u0005-\u0014\u0011\u000f\b\u0005\u0003;\n9G\u0004\u0003\u0002`\u0005\u0015TBAA1\u0015\r\t\u0019GB\u0001\u0007yI|w\u000e\u001e \n\u0003\u0019J1!!\u001b&\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001c\u0002p\t\u00191+Z9\u000b\u0007\u0005%T\u0005\u0005\u0005\u0002t\u0005e\u0014QPA?\u001b\t\t)H\u0003\u0003\u0002x\u0005\r\u0011\u0001\u00039s_\u0012,8-\u001a:\n\t\u0005m\u0014Q\u000f\u0002\u000f!J|G-^2feJ+7m\u001c:e!\u0015!\u0013qPAB\u0013\r\t\t)\n\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004I\u0005\u0015\u0015bAADK\t!!)\u001f;f\u0011\u001d\tY)a\u0015A\u00029\n!B\\;n%\u0016\u001cwN\u001d3t\u0011\u001d\t)\u0006\u0001C\t\u0003\u001f#b!!\u0017\u0002\u0012\u0006M\u0005bBAF\u0003\u001b\u0003\rA\f\u0005\u0007\u001b\u00065\u0005\u0019A(\t\u000f\u0005U\u0003\u0001\"\u0005\u0002\u0018RA\u0011\u0011LAM\u0003C\u000b\u0019\u000b\u0003\u0005\u0002x\u0005U\u0005\u0019AAN!!\t\u0019(!(\u0002~\u0005u\u0014\u0002BAP\u0003k\u0012QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\bbBAF\u0003+\u0003\rA\f\u0005\u0007\u001b\u0006U\u0005\u0019A(\t\u000f\u0005\u001d\u0006\u0001\"\u0005\u0002*\u000692m\u001c8tk6,\u0017I\u001c3WKJLg-\u001f*fG>\u0014Hm\u001d\u000b\u0012K\u0006-\u00161WA[\u0003s\u000bi,a2\u0002X\u0006e\u0007\u0002CA\u0001\u0003K\u0003\r!!,\u0011\u000fy\fy+! \u0002~%\u0019\u0011\u0011W@\u0003\u0011\r{gn];nKJDq!a#\u0002&\u0002\u0007a\u0006C\u0004\u00028\u0006\u0015\u0006\u0019\u0001\u0018\u0002\u001dM$\u0018M\u001d;j]\u001e|eMZ:fi\"I\u00111XAS!\u0003\u0005\rAL\u0001\u0019gR\f'\u000f^5oO.+\u00170\u00118e-\u0006dW/Z%oI\u0016D\bBCA`\u0003K\u0003\n\u00111\u0001\u0002B\u0006\t2\u000f^1si&tw\rV5nKN$\u0018-\u001c9\u0011\u0007\u0011\n\u0019-C\u0002\u0002F\u0016\u0012A\u0001T8oO\"Q\u0011\u0011ZAS!\u0003\u0005\r!a3\u0002\u001bQLW.Z:uC6\u0004H+\u001f9f!\u0011\ti-a5\u000e\u0005\u0005='bAAi#\u00061!/Z2pe\u0012LA!!6\u0002P\niA+[7fgR\fW\u000e\u001d+za\u0016D\u0001\"TAS!\u0003\u0005\ra\u0014\u0005\n\u00037\f)\u000b%AA\u00029\na\"\\1y!>dGNU3d_J$7\u000fC\u0004\u0002`\u0002!\t\"!9\u0002\u001d\r|gn];nKJ+7m\u001c:egV1\u00111]A\u0000\u0005'!\u0002\"!:\u0003\u0018\tm!Q\u0004\t\u0007\u0003O\f\t0!>\u000e\u0005\u0005%(\u0002BAv\u0003[\fq!\\;uC\ndWMC\u0002\u0002p\u0016\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u00190!;\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\b}\u0006]\u00181 B\t\u0013\r\tIp \u0002\u000f\u0007>t7/^7feJ+7m\u001c:e!\u0011\ti0a@\r\u0001\u0011A!\u0011AAo\u0005\u0004\u0011\u0019AA\u0001L#\u0011\u0011)Aa\u0003\u0011\u0007\u0011\u00129!C\u0002\u0003\n\u0015\u0012qAT8uQ&tw\rE\u0002%\u0005\u001bI1Aa\u0004&\u0005\r\te.\u001f\t\u0005\u0003{\u0014\u0019\u0002\u0002\u0005\u0003\u0016\u0005u'\u0019\u0001B\u0002\u0005\u00051\u0006\u0002CA\u0001\u0003;\u0004\rA!\u0007\u0011\u000fy\fy+a?\u0003\u0012!9\u00111RAo\u0001\u0004q\u0003\"CAn\u0003;\u0004\n\u00111\u0001/\u0011\u001d\u0011\t\u0003\u0001C\t\u0005G\t1#Y<bSR\u001cu.\\7ji\u000e\u000bG\u000e\u001c2bG.,bA!\n\u0003.\tEBcB3\u0003(\tM\"\u0011\u0012\u0005\t\u0003\u0003\u0011y\u00021\u0001\u0003*A9a0a,\u0003,\t=\u0002\u0003BA\u007f\u0005[!\u0001B!\u0001\u0003 \t\u0007!1\u0001\t\u0005\u0003{\u0014\t\u0004\u0002\u0005\u0003\u0016\t}!\u0019\u0001B\u0002\u0011!\u0011)Da\bA\u0002\t]\u0012AD2p[6LGoQ1mY\n\f7m\u001b\t\u0005\u0003#\u0011ID\u0002\u0004\u0003<\u0001A!Q\b\u0002\u001c\u0007>,h\u000e^\"p]N,X.\u001a:D_6l\u0017\u000e^\"bY2\u0014\u0017mY6\u0014\u000b\te\"Pa\u0010\u0011\u0007y\u0014\t%C\u0002\u0003D}\u0014Ac\u00144gg\u0016$8i\\7nSR\u001c\u0015\r\u001c7cC\u000e\\\u0007bB\u000f\u0003:\u0011\u0005!q\t\u000b\u0003\u0005oA\u0011Ba\u0013\u0003:\u0001\u0007I\u0011A\u0017\u0002\u0019M,8mY3tg\u000e{WO\u001c;\t\u0015\t=#\u0011\ba\u0001\n\u0003\u0011\t&\u0001\ttk\u000e\u001cWm]:D_VtGo\u0018\u0013fcR\u0019QMa\u0015\t\u0013\u0005}!QJA\u0001\u0002\u0004q\u0003\u0002\u0003B,\u0005s\u0001\u000b\u0015\u0002\u0018\u0002\u001bM,8mY3tg\u000e{WO\u001c;!\u0011%\u0011YF!\u000fA\u0002\u0013\u0005Q&A\u0005gC&d7i\\;oi\"Q!q\fB\u001d\u0001\u0004%\tA!\u0019\u0002\u001b\u0019\f\u0017\u000e\\\"pk:$x\fJ3r)\r)'1\r\u0005\n\u0003?\u0011i&!AA\u00029B\u0001Ba\u001a\u0003:\u0001\u0006KAL\u0001\u000bM\u0006LGnQ8v]R\u0004\u0003\u0002\u0003B6\u0005s!\tE!\u001c\u0002\u0015=t7i\\7qY\u0016$X\rF\u0003f\u0005_\u0012y\b\u0003\u0005\u0003r\t%\u0004\u0019\u0001B:\u0003\u001dygMZ:fiN\u0004r!!\u0011\u0003v=\u0013I(\u0003\u0003\u0003x\u0005\r#aA'baB\u0019aPa\u001f\n\u0007\tutPA\tPM\u001a\u001cX\r^!oI6+G/\u00193bi\u0006D\u0001B!!\u0003j\u0001\u0007!1Q\u0001\nKb\u001cW\r\u001d;j_:\u0004B!a\u0017\u0003\u0006&!!qQA8\u0005%)\u0005pY3qi&|g\u000eC\u0005\u0003\f\n}\u0001\u0013!a\u0001]\u0005)1m\\;oi\u001a1!q\u0012\u0001\t\u0005#\u0013\u0001dQ8ogVlWM]!tg&<g.\\3oiB{G\u000e\\3s'\u0011\u0011iIa%\u0011\u0007]\u0011)*C\u0002\u0003\u0018b\u0011!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bI\"Y\u0011\u0011\u0001BG\u0005\u0003\u0005\u000b\u0011BAW\u0011-\u0011iJ!$\u0003\u0002\u0003\u0006IAa(\u0002#Q|\u0007/[2t)>\u001cVOY:de&\u0014W\r\u0005\u0004\u0002\\\t\u0005&QU\u0005\u0005\u0005G\u000byG\u0001\u0003MSN$\b\u0003\u0002BT\u0005[s1\u0001\nBU\u0013\r\u0011Y+J\u0001\u0007!J,G-\u001a4\n\u0007\u0015\u0013yKC\u0002\u0003,\u0016Bq!\bBG\t\u0003\u0011\u0019\f\u0006\u0004\u00036\n]&\u0011\u0018\t\u0005\u0003#\u0011i\t\u0003\u0005\u0002\u0002\tE\u0006\u0019AAW\u0011!\u0011iJ!-A\u0002\t}\u0005B\u0003B_\u0005\u001b\u0003\r\u0011\"\u0003\u0003@\u0006\u0019\u0002/\u0019:uSRLwN\\!tg&<g.\\3oiV\u0011!\u0011\u0019\t\u0006\u0005O\u0013\u0019mT\u0005\u0005\u0005\u000b\u0014yKA\u0002TKRD!B!3\u0003\u000e\u0002\u0007I\u0011\u0002Bf\u0003]\u0001\u0018M\u001d;ji&|g.Q:tS\u001etW.\u001a8u?\u0012*\u0017\u000fF\u0002f\u0005\u001bD!\"a\b\u0003H\u0006\u0005\t\u0019\u0001Ba\u0011%\u0011\tN!$!B\u0013\u0011\t-\u0001\u000bqCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tG\u000f\t\u0015\u0005\u0005\u001f\u0014)\u000eE\u0002%\u0005/L1A!7&\u0005!1x\u000e\\1uS2,\u0007B\u0003Bo\u0005\u001b\u0003\r\u0011\"\u0003\u0003`\u0006\u0011Bo\u001c9jGN\u001cVOY:de&\u0004H/[8o+\t\u0011y\n\u0003\u0006\u0003d\n5\u0005\u0019!C\u0005\u0005K\fa\u0003^8qS\u000e\u001c8+\u001e2tGJL\u0007\u000f^5p]~#S-\u001d\u000b\u0004K\n\u001d\bBCA\u0010\u0005C\f\t\u00111\u0001\u0003 \"I!1\u001eBGA\u0003&!qT\u0001\u0014i>\u0004\u0018nY:Tk\n\u001c8M]5qi&|g\u000e\t\u0005\u000b\u0005_\u0014i\t1A\u0005\n\tE\u0018aE:vEN\u001c'/\u001b9uS>t7\t[1oO\u0016$WC\u0001Bz!\r!#Q_\u0005\u0004\u0005o,#a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0005w\u0014i\t1A\u0005\n\tu\u0018aF:vEN\u001c'/\u001b9uS>t7\t[1oO\u0016$w\fJ3r)\r)'q \u0005\u000b\u0003?\u0011I0!AA\u0002\tM\b\"CB\u0002\u0005\u001b\u0003\u000b\u0015\u0002Bz\u0003Q\u0019XOY:de&\u0004H/[8o\u0007\"\fgnZ3eA!\"1\u0011\u0001Bk\u0011)\u0019IA!$C\u0002\u0013\u000511B\u0001\u0012e\u0016\u0014\u0017\r\\1oG\u0016d\u0015n\u001d;f]\u0016\u0014XCAB\u0007%\u0011\u0019yA_?\u0007\u000f\rE11\u0003\u0001\u0004\u000e\taAH]3gS:,W.\u001a8u}!I1Q\u0003BGA\u0003%1QB\u0001\u0013e\u0016\u0014\u0017\r\\1oG\u0016d\u0015n\u001d;f]\u0016\u0014\b\u0005\u0003\u0005\u0004\u001a\t5E\u0011AB\u000e\u0003I\u0019wN\\:v[\u0016\u0014\u0018i]:jO:lWM\u001c;\u0015\u0005\t\u0005\u0007\u0002CB\u0010\u0005\u001b#\ta!\t\u0002\u0013M,(m]2sS\n,GcA3\u0004$!A1QEB\u000f\u0001\u0004\u0011y*\u0001\u000boK^$v\u000e]5dgR{7+\u001e2tGJL'-\u001a\u0005\t\u0007S\u0011i\t\"\u0001\u0004,\u0005Y\u0012n]*vEN\u001c'/\u001b2f%\u0016\fX/Z:u!J|7-Z:tK\u0012$\"Aa=\t\u0011\r=\"Q\u0012C!\u0007W\t\u0001#\u001b8ji&\fG/Z*ikR$wn\u001e8\t\u000f\rM\"Q\u0012C!I\u00061Am\\,pe.Dqaa\u000e\u0001\t\u0003\u0019I$\u0001\u000ejgB\u000b'\u000f^5uS>t\u0017i]:jO:lWM\u001c;WC2LG\r\u0006\u0004\u0003t\u000em2Q\t\u0005\t\u0007{\u0019)\u00041\u0001\u0004@\u0005Y\u0011m]:jO:lWM\u001c;t!\u0019\t9o!\u0011\u0003B&!11IAu\u0005\u0019\u0011UO\u001a4fe\"A\u0011QHB\u001b\u0001\u0004\u0011\t\rC\u0005\u0004J\u0001\t\n\u0011\"\u0005\u0004L\u0005\t3m\u001c8tk6,\u0017I\u001c3WKJLg-\u001f*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u00111Q\n\u0016\u0004]\r=3FAB)!\u0011\u0019\u0019f!\u0018\u000e\u0005\rU#\u0002BB,\u00073\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\rmS%\u0001\u0006b]:|G/\u0019;j_:LAaa\u0018\u0004V\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\r\r\u0004!%A\u0005\u0012\r\u0015\u0014!I2p]N,X.Z!oIZ+'/\u001b4z%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012*TCAB4U\u0011\t\tma\u0014\t\u0013\r-\u0004!%A\u0005\u0012\r5\u0014!I2p]N,X.Z!oIZ+'/\u001b4z%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u00122TCAB8U\u0011\tYma\u0014\t\u0013\rM\u0004!%A\u0005\u0012\rU\u0014!I2p]N,X.Z!oIZ+'/\u001b4z%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012:TCAB<U\ry5q\n\u0005\n\u0007w\u0002\u0011\u0013!C\t\u0007\u0017\n\u0011eY8ogVlW-\u00118e-\u0016\u0014\u0018NZ=SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIaB\u0011ba \u0001#\u0003%\tb!!\u0002;\u0005<\u0018-\u001b;D_6l\u0017\u000e^\"bY2\u0014\u0017mY6%I\u00164\u0017-\u001e7uIM*baa\u0013\u0004\u0004\u000e\u0015E\u0001\u0003B\u0001\u0007{\u0012\rAa\u0001\u0005\u0011\tU1Q\u0010b\u0001\u0005\u0007A\u0011b!#\u0001#\u0003%\tba#\u00021\r|gn];nKJ+7m\u001c:eg\u0012\"WMZ1vYR$3'\u0006\u0004\u0004L\r55q\u0012\u0003\t\u0005\u0003\u00199I1\u0001\u0003\u0004\u0011A!QCBD\u0005\u0004\u0011\u0019\u0001")
public abstract class BaseConsumerTest
extends JUnitSuite
implements IntegrationTestHarness {
    private final double epsilon;
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final String topic;
    private final int part;
    private final TopicPartition tp;
    private final int part2;
    private final TopicPartition tp2;
    private final Properties producerConfig;
    private final Properties consumerConfig;
    private final Properties serverConfig;
    private final Buffer<KafkaConsumer<byte[], byte[]>> consumers;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile byte bitmap$0;

    private Properties producerConfig$lzycompute() {
        BaseConsumerTest baseConsumerTest = this;
        synchronized (baseConsumerTest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.producerConfig = IntegrationTestHarness$class.producerConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.producerConfig;
        }
    }

    @Override
    public Properties producerConfig() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.producerConfig$lzycompute() : this.producerConfig;
    }

    private Properties consumerConfig$lzycompute() {
        BaseConsumerTest baseConsumerTest = this;
        synchronized (baseConsumerTest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.consumerConfig = IntegrationTestHarness$class.consumerConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.consumerConfig;
        }
    }

    @Override
    public Properties consumerConfig() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.consumerConfig$lzycompute() : this.consumerConfig;
    }

    private Properties serverConfig$lzycompute() {
        BaseConsumerTest baseConsumerTest = this;
        synchronized (baseConsumerTest) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.serverConfig = IntegrationTestHarness$class.serverConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.serverConfig;
        }
    }

    @Override
    public Properties serverConfig() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.serverConfig$lzycompute() : this.serverConfig;
    }

    @Override
    public Buffer<KafkaConsumer<byte[], byte[]>> consumers() {
        return this.consumers;
    }

    @Override
    public Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    @Override
    public /* synthetic */ void kafka$api$IntegrationTestHarness$$super$setUp() {
        KafkaServerTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$api$IntegrationTestHarness$$super$tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$api$IntegrationTestHarness$_setter_$consumers_$eq(Buffer x$1) {
        this.consumers = x$1;
    }

    @Override
    public void kafka$api$IntegrationTestHarness$_setter_$producers_$eq(Buffer x$1) {
        this.producers = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return IntegrationTestHarness$class.generateConfigs(this);
    }

    @Override
    public KafkaProducer<byte[], byte[]> createNewProducer() {
        return IntegrationTestHarness$class.createNewProducer(this);
    }

    @Override
    public KafkaConsumer<byte[], byte[]> createNewConsumer() {
        return IntegrationTestHarness$class.createNewConsumer(this);
    }

    @Override
    @After
    public void tearDown() {
        IntegrationTestHarness$class.tearDown(this);
    }

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        KafkaServerTestHarness$class.configureSecurityBeforeServersStart(this);
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public int boundPort(KafkaServer server) {
        return KafkaServerTestHarness$class.boundPort(this, server);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public ListenerName listenerName() {
        return KafkaServerTestHarness$class.listenerName(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> serverSaslProperties() {
        return KafkaServerTestHarness$class.serverSaslProperties(this);
    }

    @Override
    public Option<Properties> clientSaslProperties() {
        return KafkaServerTestHarness$class.clientSaslProperties(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void killBroker(int index) {
        KafkaServerTestHarness$class.killBroker(this, index);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        BaseConsumerTest baseConsumerTest = this;
        synchronized (baseConsumerTest) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public double epsilon() {
        return this.epsilon;
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int part2() {
        return this.part2;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    @Override
    @Before
    public void setUp() {
        IntegrationTestHarness$class.setUp(this);
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 2, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
    }

    @Test
    public void testSimpleConsumption() {
        int numRecords = 10000;
        this.sendRecords(numRecords);
        Assert.assertEquals((long)0L, (long)((KafkaConsumer)this.consumers().head()).assignment().size());
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        Assert.assertEquals((long)1L, (long)((KafkaConsumer)this.consumers().head()).assignment().size());
        ((KafkaConsumer)this.consumers().head()).seek(this.tp(), 0L);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), numRecords, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        CountConsumerCommitCallback commitCallback = new CountConsumerCommitCallback();
        ((KafkaConsumer)this.consumers().head()).commitAsync((OffsetCommitCallback)commitCallback);
        this.awaitCommitCallback((Consumer)this.consumers().head(), commitCallback, this.awaitCommitCallback$default$3());
    }

    @Test
    public void testCoordinatorFailover() {
        TestConsumerReassignmentListener listener = new TestConsumerReassignmentListener();
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "2000");
        KafkaConsumer consumer0 = new KafkaConsumer(this.consumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumers().$plus$eq((Object)consumer0);
        consumer0.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (ConsumerRebalanceListener)listener);
        consumer0.poll(2000L);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Seq parts = null;
        while (parts == null) {
            parts = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(consumer0.partitionsFor(Topic$.MODULE$.GroupMetadataTopicName())).asScala();
        }
        Assert.assertEquals((long)1L, (long)parts.size());
        Assert.assertNotNull((Object)((PartitionInfo)parts.head()).leader());
        int coordinator = ((PartitionInfo)parts.head()).leader().id();
        ((KafkaServer)this.servers().apply(coordinator)).shutdown();
        consumer0.poll(5000L);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Assert.assertEquals((long)1L, (long)listener.callsToRevoked());
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(int numRecords) {
        return this.sendRecords(numRecords, this.tp());
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(int numRecords, TopicPartition tp) {
        return this.sendRecords((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords, tp);
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp) {
        IndexedSeq records2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, producer, tp){
            public static final long serialVersionUID = 0L;
            private final KafkaProducer producer$1;
            private final TopicPartition tp$1;

            /*
             * WARNING - void declaration
             */
            public final ProducerRecord<byte[], byte[]> apply(int i) {
                void var2_2;
                ProducerRecord record = new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), Predef$.MODULE$.long2Long((long)i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
                this.producer$1.send(record);
                return var2_2;
            }
            {
                this.producer$1 = producer$1;
                this.tp$1 = tp$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
        return records2;
    }

    public void consumeAndVerifyRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, int startingKeyAndValueIndex, long startingTimestamp, TimestampType timestampType, TopicPartition tp, int maxPollRecords) {
        ArrayBuffer<ConsumerRecord<byte[], byte[]>> records2 = this.consumeRecords(consumer, numRecords, maxPollRecords);
        long now = System.currentTimeMillis();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)new Serializable(this, startingOffset, startingKeyAndValueIndex, startingTimestamp, timestampType, tp, records2, now){
            public static final long serialVersionUID = 0L;
            private final int startingOffset$1;
            private final int startingKeyAndValueIndex$1;
            private final long startingTimestamp$1;
            private final TimestampType timestampType$1;
            private final TopicPartition tp$2;
            private final ArrayBuffer records$1;
            private final long now$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ConsumerRecord record = (ConsumerRecord)this.records$1.apply(i);
                int offset = this.startingOffset$1 + i;
                Assert.assertEquals((Object)this.tp$2.topic(), (Object)record.topic());
                Assert.assertEquals((long)this.tp$2.partition(), (long)record.partition());
                TimestampType timestampType = this.timestampType$1;
                TimestampType timestampType2 = TimestampType.CREATE_TIME;
                if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                    Assert.assertEquals((Object)this.timestampType$1, (Object)record.timestampType());
                    long timestamp = this.startingTimestamp$1 + (long)i;
                    Assert.assertEquals((long)timestamp, (long)record.timestamp());
                } else {
                    Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got unexpected timestamp ", ". Timestamp should be between [", ", ", "}]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)record.timestamp()), BoxesRunTime.boxToLong((long)this.startingTimestamp$1), BoxesRunTime.boxToLong((long)this.now$1)})), (record.timestamp() >= this.startingTimestamp$1 && record.timestamp() <= this.now$1 ? 1 : 0) != 0);
                }
                Assert.assertEquals((long)offset, (long)record.offset());
                int keyAndValueIndex = this.startingKeyAndValueIndex$1 + i;
                Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})), (Object)new String((byte[])record.key()));
                Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})), (Object)new String((byte[])record.value()));
                Assert.assertEquals((long)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})).length(), (long)record.serializedKeySize());
                Assert.assertEquals((long)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)keyAndValueIndex)})).length(), (long)record.serializedValueSize());
            }
            {
                this.startingOffset$1 = startingOffset$1;
                this.startingKeyAndValueIndex$1 = startingKeyAndValueIndex$1;
                this.startingTimestamp$1 = startingTimestamp$1;
                this.timestampType$1 = timestampType$1;
                this.tp$2 = tp$2;
                this.records$1 = records$1;
                this.now$1 = now$1;
            }
        });
    }

    public int consumeAndVerifyRecords$default$4() {
        return 0;
    }

    public long consumeAndVerifyRecords$default$5() {
        return 0L;
    }

    public TimestampType consumeAndVerifyRecords$default$6() {
        return TimestampType.CREATE_TIME;
    }

    public TopicPartition consumeAndVerifyRecords$default$7() {
        return this.tp();
    }

    public int consumeAndVerifyRecords$default$8() {
        return Integer.MAX_VALUE;
    }

    public <K, V> ArrayBuffer<ConsumerRecord<K, V>> consumeRecords(Consumer<K, V> consumer, int numRecords, int maxPollRecords) {
        ArrayBuffer records2 = new ArrayBuffer();
        int maxIters = numRecords * 300;
        int iters = 0;
        while (records2.size() < numRecords) {
            Iterable polledRecords = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(50L)).asScala();
            Assert.assertTrue((polledRecords.size() <= maxPollRecords ? 1 : 0) != 0);
            polledRecords.foreach((Function1)new Serializable(this, records2){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer records$2;

                public final ArrayBuffer<ConsumerRecord<K, V>> apply(ConsumerRecord<K, V> record) {
                    return this.records$2.$plus$eq(record);
                }
                {
                    this.records$2 = records$2;
                }
            });
            if (iters > maxIters) {
                throw new IllegalStateException(new StringBuilder().append((Object)"Failed to consume the expected records after ").append((Object)BoxesRunTime.boxToInteger((int)iters)).append((Object)" iterations.").toString());
            }
            ++iters;
        }
        return records2;
    }

    public <K, V> int consumeRecords$default$3() {
        return Integer.MAX_VALUE;
    }

    public <K, V> void awaitCommitCallback(Consumer<K, V> consumer, CountConsumerCommitCallback commitCallback, int count) {
        long started = System.currentTimeMillis();
        while (commitCallback.successCount() < count && System.currentTimeMillis() - started < 10000L) {
            consumer.poll(50L);
        }
        Assert.assertEquals((long)count, (long)commitCallback.successCount());
    }

    public <K, V> int awaitCommitCallback$default$3() {
        return 1;
    }

    public boolean isPartitionAssignmentValid(Buffer<Set<TopicPartition>> assignments, Set<TopicPartition> partitions) {
        boolean allNonEmptyAssignments = assignments.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Set<TopicPartition> assignment) {
                return assignment.nonEmpty();
            }
        });
        if (allNonEmptyAssignments) {
            Set uniqueAssignedPartitions;
            int n = 0;
            int totalPartitionsInAssignments = BoxesRunTime.unboxToInt((Object)assignments.$div$colon((Object)BoxesRunTime.boxToInteger((int)n), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(int x$2, Set<TopicPartition> x$3) {
                    return x$2 + x$3.size();
                }
            }));
            if (totalPartitionsInAssignments != partitions.size()) {
                return false;
            }
            Set set = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
            Set set2 = uniqueAssignedPartitions = (Set)assignments.$div$colon((Object)set, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Set<TopicPartition> apply(Set<TopicPartition> x$5, Set<TopicPartition> x$6) {
                    return (Set)x$5.$plus$plus(x$6);
                }
            });
            Set<TopicPartition> set3 = partitions;
            return !(set2 != null ? !set2.equals(set3) : set3 != null);
        }
        return false;
    }

    public BaseConsumerTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        IntegrationTestHarness$class.$init$(this);
        this.epsilon = 0.1;
        this.producerCount = 1;
        this.consumerCount = 2;
        this.serverCount = 3;
        this.topic = "topic";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.part2 = 1;
        this.tp2 = new TopicPartition(this.topic(), this.part2());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), "30000");
        this.producerConfig().setProperty("acks", "all");
        this.consumerConfig().setProperty("group.id", "my-test");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
    }

    public class ConsumerAssignmentPoller
    extends ShutdownableThread {
        public final Consumer<byte[], byte[]> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer;
        private volatile Set<TopicPartition> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        private List<String> topicsSubscription;
        private volatile boolean subscriptionChanged;
        private final ConsumerRebalanceListener rebalanceListener;
        public final /* synthetic */ BaseConsumerTest $outer;

        private Set<TopicPartition> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment() {
            return this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        }

        public void kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq(Set<TopicPartition> x$1) {
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = x$1;
        }

        private List<String> topicsSubscription() {
            return this.topicsSubscription;
        }

        private void topicsSubscription_$eq(List<String> x$1) {
            this.topicsSubscription = x$1;
        }

        private boolean subscriptionChanged() {
            return this.subscriptionChanged;
        }

        private void subscriptionChanged_$eq(boolean x$1) {
            this.subscriptionChanged = x$1;
        }

        public ConsumerRebalanceListener rebalanceListener() {
            return this.rebalanceListener;
        }

        public Set<TopicPartition> consumerAssignment() {
            return this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment();
        }

        public void subscribe(List<String> newTopicsToSubscribe) {
            if (this.subscriptionChanged()) {
                throw new IllegalStateException("Do not call subscribe until the previous subsribe request is processed.");
            }
            this.topicsSubscription_$eq(newTopicsToSubscribe);
            this.subscriptionChanged_$eq(true);
        }

        public boolean isSubscribeRequestProcessed() {
            return !this.subscriptionChanged();
        }

        /*
         * WARNING - void declaration
         */
        public boolean initiateShutdown() {
            void var1_1;
            boolean res = super.initiateShutdown();
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.wakeup();
            return (boolean)var1_1;
        }

        public void doWork() {
            if (this.subscriptionChanged()) {
                this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.topicsSubscription()).asJava(), this.rebalanceListener());
                this.subscriptionChanged_$eq(false);
            }
            try {
                this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.poll(50L);
            }
            catch (WakeupException wakeupException) {}
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$$outer() {
            return this.$outer;
        }

        public ConsumerAssignmentPoller(BaseConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer = consumer;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-consumer-assignment", false);
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = Predef$.MODULE$.Set().empty();
            this.topicsSubscription = topicsToSubscribe;
            this.subscriptionChanged = false;
            this.rebalanceListener = new ConsumerRebalanceListener(this){
                private final /* synthetic */ ConsumerAssignmentPoller $outer;

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.assignment()).asScala()).toArray(ClassTag$.MODULE$.apply(TopicPartition.class))))));
                }

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq((Set<TopicPartition>)Predef$.MODULE$.Set().empty());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), this.rebalanceListener());
        }
    }

    public class CountConsumerCommitCallback
    implements OffsetCommitCallback {
        private int successCount;
        private int failCount;

        public int successCount() {
            return this.successCount;
        }

        public void successCount_$eq(int x$1) {
            this.successCount = x$1;
        }

        public int failCount() {
            return this.failCount;
        }

        public void failCount_$eq(int x$1) {
            this.failCount = x$1;
        }

        public void onComplete(Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            if (exception == null) {
                this.successCount_$eq(this.successCount() + 1);
            } else {
                this.failCount_$eq(this.failCount() + 1);
            }
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$CountConsumerCommitCallback$$$outer() {
            return BaseConsumerTest.this;
        }

        public CountConsumerCommitCallback() {
            if (BaseConsumerTest.this == null) {
                throw null;
            }
            this.successCount = 0;
            this.failCount = 0;
        }
    }

    public class TestConsumerReassignmentListener
    implements ConsumerRebalanceListener {
        private int callsToAssigned;
        private int callsToRevoked;

        public int callsToAssigned() {
            return this.callsToAssigned;
        }

        public void callsToAssigned_$eq(int x$1) {
            this.callsToAssigned = x$1;
        }

        public int callsToRevoked() {
            return this.callsToRevoked;
        }

        public void callsToRevoked_$eq(int x$1) {
            this.callsToRevoked = x$1;
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "onPartitionsAssigned called.";
                }
            });
            this.callsToAssigned_$eq(this.callsToAssigned() + 1);
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "onPartitionsRevoked called.";
                }
            });
            this.callsToRevoked_$eq(this.callsToRevoked() + 1);
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer() {
            return BaseConsumerTest.this;
        }

        public TestConsumerReassignmentListener() {
            if (BaseConsumerTest.this == null) {
                throw null;
            }
            this.callsToAssigned = 0;
            this.callsToRevoked = 0;
        }
    }
}

