/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator;

import java.nio.ByteBuffer;
import kafka.api.ApiVersion$;
import kafka.cluster.Partition;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.common.Topic$;
import kafka.coordinator.DelayedStore;
import kafka.coordinator.Empty$;
import kafka.coordinator.GroupMetadata;
import kafka.coordinator.GroupMetadata$;
import kafka.coordinator.GroupMetadataKey;
import kafka.coordinator.GroupMetadataManager;
import kafka.coordinator.GroupMetadataManager$;
import kafka.coordinator.GroupState;
import kafka.coordinator.JoinGroupResult;
import kafka.coordinator.MemberMetadata;
import kafka.coordinator.OffsetConfig;
import kafka.coordinator.OffsetKey;
import kafka.coordinator.PreparingRebalance$;
import kafka.coordinator.Stable$;
import kafka.log.Log;
import kafka.log.LogAppendInfo$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.ReplicaManager;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\tUc\u0001B\u0001\u0003\u0001\u001d\u0011\u0001d\u0012:pkBlU\r^1eCR\fW*\u00198bO\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0001\u0004%\t!F\u0001\u0005i&lW-F\u0001\u0017!\t9\"$D\u0001\u0019\u0015\tIB!A\u0003vi&d7/\u0003\u0002\u001c1\tAQj\\2l)&lW\rC\u0004\u001e\u0001\u0001\u0007I\u0011\u0001\u0010\u0002\u0011QLW.Z0%KF$\"a\b\u0012\u0011\u0005%\u0001\u0013BA\u0011\u000b\u0005\u0011)f.\u001b;\t\u000f\rb\u0012\u0011!a\u0001-\u0005\u0019\u0001\u0010J\u0019\t\r\u0015\u0002\u0001\u0015)\u0003\u0017\u0003\u0015!\u0018.\\3!\u0011\u001d9\u0003\u00011A\u0005\u0002!\naB]3qY&\u001c\u0017-T1oC\u001e,'/F\u0001*!\tQS&D\u0001,\u0015\taC!\u0001\u0004tKJ4XM]\u0005\u0003]-\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'\u000fC\u00041\u0001\u0001\u0007I\u0011A\u0019\u0002%I,\u0007\u000f\\5dC6\u000bg.Y4fe~#S-\u001d\u000b\u0003?IBqaI\u0018\u0002\u0002\u0003\u0007\u0011\u0006\u0003\u00045\u0001\u0001\u0006K!K\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA!9a\u0007\u0001a\u0001\n\u00039\u0014\u0001F4s_V\u0004X*\u001a;bI\u0006$\u0018-T1oC\u001e,'/F\u00019!\t\u0011\u0012(\u0003\u0002;\u0005\t!rI]8va6+G/\u00193bi\u0006l\u0015M\\1hKJDq\u0001\u0010\u0001A\u0002\u0013\u0005Q(\u0001\rhe>,\b/T3uC\u0012\fG/Y'b]\u0006<WM]0%KF$\"a\b \t\u000f\rZ\u0014\u0011!a\u0001q!1\u0001\t\u0001Q!\na\nQc\u001a:pkBlU\r^1eCR\fW*\u00198bO\u0016\u0014\b\u0005C\u0004C\u0001\u0001\u0007I\u0011A\"\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014X#\u0001#\u0011\u0005])\u0015B\u0001$\u0019\u00059Y\u0015MZ6b'\u000eDW\rZ;mKJDq\u0001\u0013\u0001A\u0002\u0013\u0005\u0011*A\u0007tG\",G-\u001e7fe~#S-\u001d\u000b\u0003?)CqaI$\u0002\u0002\u0003\u0007A\t\u0003\u0004M\u0001\u0001\u0006K\u0001R\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0003b\u0002(\u0001\u0001\u0004%\taT\u0001\bu.,F/\u001b7t+\u0005\u0001\u0006CA\fR\u0013\t\u0011\u0006DA\u0004[WV#\u0018\u000e\\:\t\u000fQ\u0003\u0001\u0019!C\u0001+\u0006Y!p[+uS2\u001cx\fJ3r)\tyb\u000bC\u0004$'\u0006\u0005\t\u0019\u0001)\t\ra\u0003\u0001\u0015)\u0003Q\u0003!Q8.\u0016;jYN\u0004\u0003b\u0002.\u0001\u0001\u0004%\taW\u0001\na\u0006\u0014H/\u001b;j_:,\u0012\u0001\u0018\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?\u0012\tqa\u00197vgR,'/\u0003\u0002b=\nI\u0001+\u0019:uSRLwN\u001c\u0005\bG\u0002\u0001\r\u0011\"\u0001e\u00035\u0001\u0018M\u001d;ji&|gn\u0018\u0013fcR\u0011q$\u001a\u0005\bG\t\f\t\u00111\u0001]\u0011\u00199\u0007\u0001)Q\u00059\u0006Q\u0001/\u0019:uSRLwN\u001c\u0011\t\u000f%\u0004!\u0019!C\u0001U\u00069qM]8va&#W#A6\u0011\u00051\fX\"A7\u000b\u00059|\u0017\u0001\u00027b]\u001eT\u0011\u0001]\u0001\u0005U\u00064\u0018-\u0003\u0002s[\n11\u000b\u001e:j]\u001eDa\u0001\u001e\u0001!\u0002\u0013Y\u0017\u0001C4s_V\u0004\u0018\n\u001a\u0011\t\u000fY\u0004!\u0019!C\u0001o\u0006\u0001rM]8vaB\u000b'\u000f^5uS>t\u0017\nZ\u000b\u0002qB\u0011\u0011\"_\u0005\u0003u*\u00111!\u00138u\u0011\u0019a\b\u0001)A\u0005q\u0006\trM]8vaB\u000b'\u000f^5uS>t\u0017\n\u001a\u0011\t\u000fy\u0004!\u0019!C\u0001U\u0006a\u0001O]8u_\u000e|G\u000eV=qK\"9\u0011\u0011\u0001\u0001!\u0002\u0013Y\u0017!\u00049s_R|7m\u001c7UsB,\u0007\u0005\u0003\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0001x\u0003A\u0011XMY1mC:\u001cW\rV5nK>,H\u000fC\u0004\u0002\n\u0001\u0001\u000b\u0011\u0002=\u0002#I,'-\u00197b]\u000e,G+[7f_V$\b\u0005\u0003\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0001x\u00039\u0019Xm]:j_:$\u0016.\\3pkRDq!!\u0005\u0001A\u0003%\u00010A\btKN\u001c\u0018n\u001c8US6,w.\u001e;!\u0011\u001d\t)\u0002\u0001C\u0001\u0003/\tQa]3u+B$\u0012a\b\u0015\u0005\u0003'\tY\u0002\u0005\u0003\u0002\u001e\u0005\u001dRBAA\u0010\u0015\u0011\t\t#a\t\u0002\u000b),h.\u001b;\u000b\u0005\u0005\u0015\u0012aA8sO&!\u0011\u0011FA\u0010\u0005\u0019\u0011UMZ8sK\"9\u0011Q\u0006\u0001\u0005\u0002\u0005]\u0011a\u0007;fgRdu.\u00193PM\u001a\u001cX\r^:XSRDw.\u001e;He>,\b\u000f\u000b\u0003\u0002,\u0005E\u0002\u0003BA\u000f\u0003gIA!!\u000e\u0002 \t!A+Z:u\u0011\u001d\tI\u0004\u0001C\u0001\u0003/\tQ\u0004^3ti2{\u0017\rZ(gMN,Go],ji\"$v.\u001c2ti>tWm\u001d\u0015\u0005\u0003o\t\t\u0004C\u0004\u0002@\u0001!\t!a\u0006\u0002/Q,7\u000f\u001e'pC\u0012|eMZ:fiN\fe\u000eZ$s_V\u0004\b\u0006BA\u001f\u0003cAq!!\u0012\u0001\t\u0003\t9\"\u0001\u000euKN$Hj\\1e\u000fJ|W\u000f],ji\"$v.\u001c2ti>tW\r\u000b\u0003\u0002D\u0005E\u0002bBA&\u0001\u0011\u0005\u0011qC\u0001!i\u0016\u001cHo\u00144gg\u0016$xK]5uK\u00063G/\u001a:He>,\bOU3n_Z,G\r\u000b\u0003\u0002J\u0005E\u0002bBA)\u0001\u0011\u0005\u0011qC\u0001\ri\u0016\u001cH/\u00113e\u000fJ|W\u000f\u001d\u0015\u0005\u0003\u001f\n\t\u0004C\u0004\u0002X\u0001!\t!a\u0006\u0002'Q,7\u000f^*u_J,W)\u001c9us\u001e\u0013x.\u001e9)\t\u0005U\u0013\u0011\u0007\u0005\b\u0003;\u0002A\u0011AA\f\u0003i!Xm\u001d;Ti>\u0014Xm\u0012:pkB,%O]8s\u001b\u0006\u0004\b/\u001b8hQ\u0011\tY&!\r\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f\u0005a\u0012m]:feR\u001cFo\u001c:f\u000fJ|W\u000f]#se>\u0014X*\u00199qS:<G#B\u0010\u0002h\u0005\u0005\u0005\u0002CA5\u0003C\u0002\r!a\u001b\u0002\u0017\u0005\u0004\b/\u001a8e\u000bJ\u0014xN\u001d\t\u0005\u0003[\ni(\u0004\u0002\u0002p)!\u0011\u0011OA:\u0003!\u0001(o\u001c;pG>d'\u0002BA;\u0003o\naaY8n[>t'bA\u0003\u0002z)!\u00111PA\u0012\u0003\u0019\t\u0007/Y2iK&!\u0011qPA8\u0005\u0019)%O]8sg\"A\u00111QA1\u0001\u0004\tY'A\u0007fqB,7\r^3e\u000bJ\u0014xN\u001d\u0005\b\u0003\u000f\u0003A\u0011AA\f\u0003Y!Xm\u001d;Ti>\u0014XMT8o\u000b6\u0004H/_$s_V\u0004\b\u0006BAC\u0003cAq!!$\u0001\t\u0003\t9\"A\u0017uKN$8\u000b^8sK:{g.R7qif<%o\\;q/\",gnQ8pe\u0012Lg.\u0019;pe\"\u000b7/T8wK\u0012DC!a#\u00022!9\u00111\u0013\u0001\u0005\u0002\u0005]\u0011\u0001\u0005;fgR\u001cu.\\7ji>3gm]3uQ\u0011\t\t*!\r\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u0018\u00059C/Z:u\u0007>lW.\u001b;PM\u001a\u001cX\r^,iK:\u001cun\u001c:eS:\fGo\u001c:ICNluN^3eQ\u0011\t9*!\r\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\u0018\u00059B/Z:u\u0007>lW.\u001b;PM\u001a\u001cX\r\u001e$bS2,(/\u001a\u0015\u0005\u0003;\u000b\t\u0004C\u0004\u0002&\u0002!I!a*\u0002=\u0005\u001c8/\u001a:u\u0007>lW.\u001b;PM\u001a\u001cX\r^#se>\u0014X*\u00199qS:<G#B\u0010\u0002*\u0006-\u0006\u0002CA5\u0003G\u0003\r!a\u001b\t\u0011\u0005\r\u00151\u0015a\u0001\u0003WBq!a,\u0001\t\u0003\t9\"\u0001\tuKN$X\t\u001f9je\u0016|eMZ:fi\"\"\u0011QVA\u0019\u0011\u001d\t)\f\u0001C\u0001\u0003/\t\u0001\u0004^3ti\u001e\u0013x.\u001e9NKR\fG-\u0019;b%\u0016lwN^1mQ\u0011\t\u0019,!\r\t\u000f\u0005m\u0006\u0001\"\u0001\u0002\u0018\u0005IC/Z:u\u000fJ|W\u000f]'fi\u0006$\u0017\r^1SK6|g/\u00197XSRDGj\\4BaB,g\u000e\u001a+j[\u0016DC!!/\u00022!9\u0011\u0011\u0019\u0001\u0005\u0002\u0005]\u0011A\b;fgR,\u0005\u0010]5sK\u001e\u0013x.\u001e9XSRDwJ\u001a4tKR\u001cxJ\u001c7zQ\u0011\ty,!\r\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002\u0018\u0005\u0001C/Z:u\u000bb\u0004\u0018N]3PM\u001a\u001cX\r^:XSRD\u0017i\u0019;jm\u0016<%o\\;qQ\u0011\t)-!\r\t\u000f\u00055\u0007\u0001\"\u0003\u0002P\u0006\u0019R\r\u001f9fGR\f\u0005\u000f]3oI6+7o]1hKR\u0019q$!5\t\u0011\u0005M\u00171\u001aa\u0001\u0003W\nQ!\u001a:s_JDq!a6\u0001\t\u0013\tI.\u0001\u0011ck&dGm\u0015;bE2,wI]8vaJ+7m\u001c:e/&$\b.T3nE\u0016\u0014H\u0003BAn\u0003O\u0004B!!8\u0002d6\u0011\u0011q\u001c\u0006\u0005\u0003C\f\u0019(\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003K\fyN\u0001\u0004SK\u000e|'\u000f\u001a\u0005\t\u0003S\f)\u000e1\u0001\u0002l\u0006AQ.Z7cKJLE\r\u0005\u0003\u0002n\u0006MhbA\u0005\u0002p&\u0019\u0011\u0011\u001f\u0006\u0002\rA\u0013X\rZ3g\u0013\r\u0011\u0018Q\u001f\u0006\u0004\u0003cT\u0001bBA}\u0001\u0011%\u00111`\u0001\u0018Kb\u0004Xm\u0019;He>,\b/T3uC\u0012\fG/\u0019'pC\u0012$raHA\u007f\u0005\u0013\u0011\u0019\u0002\u0003\u0005\u0002\u0000\u0006]\b\u0019\u0001B\u0001\u0003m9'o\\;q\u001b\u0016$\u0018\rZ1uCR{\u0007/[2QCJ$\u0018\u000e^5p]B!!1\u0001B\u0003\u001b\t\t\u0019(\u0003\u0003\u0003\b\u0005M$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\t\u0005\u0017\t9\u00101\u0001\u0003\u000e\u0005Y1\u000f^1si>3gm]3u!\rI!qB\u0005\u0004\u0005#Q!\u0001\u0002'p]\u001eD\u0001B!\u0006\u0002x\u0002\u0007!qC\u0001\be\u0016\u001cwN\u001d3t!\u0011\tiN!\u0007\n\t\tm\u0011q\u001c\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u000f\t}\u0001\u0001\"\u0003\u0003\"\u0005a2M]3bi\u0016\u001cu.\\7jiR,Gm\u00144gg\u0016$(+Z2pe\u0012\u001cHC\u0002B\u0012\u0005_\u0011I\u0004\u0005\u0004\u0003&\t-\u00121\\\u0007\u0003\u0005OQ1A!\u000b\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005[\u00119CA\u0002TKFD\u0001B!\r\u0003\u001e\u0001\u0007!1G\u0001\u0011G>lW.\u001b;uK\u0012|eMZ:fiN\u0004\u0002B!\n\u00036\t\u0005!QB\u0005\u0005\u0005o\u00119CA\u0002NCBD\u0011\"\u001bB\u000f!\u0003\u0005\r!a;\t\u0013\tu\u0002!%A\u0005\n\t}\u0012AJ2sK\u0006$XmQ8n[&$H/\u001a3PM\u001a\u001cX\r\u001e*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\t\u0016\u0005\u0003W\u0014\u0019e\u000b\u0002\u0003FA!!q\tB)\u001b\t\u0011IE\u0003\u0003\u0003L\t5\u0013!C;oG\",7m[3e\u0015\r\u0011yEC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B*\u0005\u0013\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class GroupMetadataManagerTest {
    private MockTime time = null;
    private ReplicaManager replicaManager = null;
    private GroupMetadataManager groupMetadataManager = null;
    private KafkaScheduler scheduler = null;
    private ZkUtils zkUtils = null;
    private Partition partition = null;
    private final String groupId;
    private final int groupPartitionId;
    private final String protocolType;
    private final int rebalanceTimeout;
    private final int sessionTimeout;

    public MockTime time() {
        return this.time;
    }

    public void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public GroupMetadataManager groupMetadataManager() {
        return this.groupMetadataManager;
    }

    public void groupMetadataManager_$eq(GroupMetadataManager x$1) {
        this.groupMetadataManager = x$1;
    }

    public KafkaScheduler scheduler() {
        return this.scheduler;
    }

    public void scheduler_$eq(KafkaScheduler x$1) {
        this.scheduler = x$1;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public String groupId() {
        return this.groupId;
    }

    public int groupPartitionId() {
        return this.groupPartitionId;
    }

    public String protocolType() {
        return this.protocolType;
    }

    public int rebalanceTimeout() {
        return this.rebalanceTimeout;
    }

    public int sessionTimeout() {
        return this.sessionTimeout;
    }

    @Before
    public void setUp() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16()));
        OffsetConfig offsetConfig = new OffsetConfig(Predef$.MODULE$.Integer2int(config.offsetMetadataMaxSize()), Predef$.MODULE$.Integer2int(config.offsetsLoadBufferSize()), (long)(Predef$.MODULE$.Integer2int(config.offsetsRetentionMinutes()) * 60) * 1000L, Predef$.MODULE$.Long2long(config.offsetsRetentionCheckIntervalMs()), Predef$.MODULE$.Integer2int(config.offsetsTopicPartitions()), Predef$.MODULE$.Integer2int(config.offsetsTopicSegmentBytes()), Predef$.MODULE$.Short2short(config.offsetsTopicReplicationFactor()), config.offsetsTopicCompressionCodec(), Predef$.MODULE$.Integer2int(config.offsetCommitTimeoutMs()), Predef$.MODULE$.Short2short(config.offsetCommitRequiredAcks()));
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ret.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Topic$.MODULE$.GroupMetadataTopicName()), (Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})))}))));
        this.zkUtils_$eq((ZkUtils)EasyMock.createNiceMock(ZkUtils.class));
        EasyMock.expect((Object)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Topic$.MODULE$.GroupMetadataTopicName()})))).andReturn((Object)ret);
        EasyMock.replay((Object[])new Object[]{this.zkUtils()});
        this.time_$eq(new MockTime());
        this.replicaManager_$eq((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class));
        this.groupMetadataManager_$eq(new GroupMetadataManager(0, ApiVersion$.MODULE$.latestVersion(), offsetConfig, this.replicaManager(), this.zkUtils(), (Time)this.time()));
        this.partition_$eq((Partition)EasyMock.niceMock(Partition.class));
    }

    @Test
    public void testLoadOffsetsWithoutGroup() {
        TopicPartition groupMetadataTopicPartition = new TopicPartition(Topic$.MODULE$.GroupMetadataTopicName(), this.groupPartitionId());
        long startOffset = 15L;
        Map committedOffsets = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        Seq<Record> offsetCommitRecords = this.createCommittedOffsetRecords((Map<TopicPartition, Object>)committedOffsets, this.createCommittedOffsetRecords$default$2());
        MemoryRecords records2 = MemoryRecords.withRecords((long)startOffset, (Record[])((Record[])offsetCommitRecords.toArray(ClassTag$.MODULE$.apply(Record.class))));
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, startOffset, records2);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(GroupMetadata x$1) {
            }
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return TestUtils$.MODULE$.fail("Group was not loaded into the cache");
            }
        });
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)committedOffsets.size(), (long)group.allOffsets().size());
        committedOffsets.foreach((Function1)new Serializable(this, group){
            public static final long serialVersionUID = 0L;
            private final GroupMetadata group$1;

            public final void apply(Tuple2<TopicPartition, Object> x0$1) {
                Tuple2<TopicPartition, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)this.group$1.offset(topicPartition).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(OffsetAndMetadata x$2) {
                            return x$2.offset();
                        }
                    }));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.group$1 = group$1;
            }
        });
    }

    @Test
    public void testLoadOffsetsWithTombstones() {
        TopicPartition groupMetadataTopicPartition = new TopicPartition(Topic$.MODULE$.GroupMetadataTopicName(), this.groupPartitionId());
        long startOffset = 15L;
        TopicPartition tombstonePartition = new TopicPartition("foo", 1);
        Map committedOffsets = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tombstonePartition), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        Seq<Record> offsetCommitRecords = this.createCommittedOffsetRecords((Map<TopicPartition, Object>)committedOffsets, this.createCommittedOffsetRecords$default$2());
        Record tombstone = Record.create((byte[])GroupMetadataManager$.MODULE$.offsetCommitKey(this.groupId(), tombstonePartition, GroupMetadataManager$.MODULE$.offsetCommitKey$default$3()), null);
        MemoryRecords records2 = MemoryRecords.withRecords((long)startOffset, (Record[])((Record[])((TraversableOnce)offsetCommitRecords.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Record[]{tombstone})), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Record.class))));
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, startOffset, records2);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(GroupMetadata x$3) {
            }
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return TestUtils$.MODULE$.fail("Group was not loaded into the cache");
            }
        });
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)(committedOffsets.size() - 1), (long)group.allOffsets().size());
        committedOffsets.foreach((Function1)new Serializable(this, tombstonePartition, group){
            public static final long serialVersionUID = 0L;
            private final TopicPartition tombstonePartition$1;
            private final GroupMetadata group$2;

            public final void apply(Tuple2<TopicPartition, Object> x0$2) {
                Tuple2<TopicPartition, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    TopicPartition topicPartition2 = topicPartition;
                    TopicPartition topicPartition3 = this.tombstonePartition$1;
                    if (!(topicPartition2 != null ? !topicPartition2.equals(topicPartition3) : topicPartition3 != null)) {
                        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group$2.offset(topicPartition));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)this.group$2.offset(topicPartition).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(OffsetAndMetadata x$4) {
                                return x$4.offset();
                            }
                        }));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.tombstonePartition$1 = tombstonePartition$1;
                this.group$2 = group$2;
            }
        });
    }

    @Test
    public void testLoadOffsetsAndGroup() {
        TopicPartition groupMetadataTopicPartition = new TopicPartition(Topic$.MODULE$.GroupMetadataTopicName(), this.groupPartitionId());
        long startOffset = 15L;
        Map committedOffsets = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        Seq<Record> offsetCommitRecords = this.createCommittedOffsetRecords((Map<TopicPartition, Object>)committedOffsets, this.createCommittedOffsetRecords$default$2());
        String memberId = "98098230493";
        Record groupMetadataRecord = this.buildStableGroupRecordWithMember(memberId);
        MemoryRecords records2 = MemoryRecords.withRecords((long)startOffset, (Record[])((Record[])((TraversableOnce)offsetCommitRecords.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Record[]{groupMetadataRecord})), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Record.class))));
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, startOffset, records2);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(GroupMetadata x$5) {
            }
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return TestUtils$.MODULE$.fail("Group was not loaded into the cache");
            }
        });
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Stable$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((Object)memberId, (Object)group.leaderId());
        Assert.assertEquals((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{memberId})), (Object)group.allMembers());
        Assert.assertEquals((long)committedOffsets.size(), (long)group.allOffsets().size());
        committedOffsets.foreach((Function1)new Serializable(this, group){
            public static final long serialVersionUID = 0L;
            private final GroupMetadata group$3;

            public final void apply(Tuple2<TopicPartition, Object> x0$3) {
                Tuple2<TopicPartition, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)this.group$3.offset(topicPartition).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(OffsetAndMetadata x$6) {
                            return x$6.offset();
                        }
                    }));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.group$3 = group$3;
            }
        });
    }

    @Test
    public void testLoadGroupWithTombstone() {
        TopicPartition groupMetadataTopicPartition = new TopicPartition(Topic$.MODULE$.GroupMetadataTopicName(), this.groupPartitionId());
        long startOffset = 15L;
        String memberId = "98098230493";
        Record groupMetadataRecord = this.buildStableGroupRecordWithMember(memberId);
        Record groupMetadataTombstone = Record.create((byte[])GroupMetadataManager$.MODULE$.groupMetadataKey(this.groupId()), null);
        MemoryRecords records2 = MemoryRecords.withRecords((long)startOffset, (Record[])((Record[])((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Record[]{groupMetadataRecord, groupMetadataTombstone}))).toArray(ClassTag$.MODULE$.apply(Record.class))));
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, startOffset, records2);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(GroupMetadata x$7) {
            }
        });
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.groupMetadataManager().getGroup(this.groupId()));
    }

    @Test
    public void testOffsetWriteAfterGroupRemoved() {
        TopicPartition groupMetadataTopicPartition = new TopicPartition(Topic$.MODULE$.GroupMetadataTopicName(), this.groupPartitionId());
        long startOffset = 15L;
        Map committedOffsets = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)BoxesRunTime.boxToLong((long)23L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)BoxesRunTime.boxToLong((long)455L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)BoxesRunTime.boxToLong((long)8992L))}));
        Seq<Record> offsetCommitRecords = this.createCommittedOffsetRecords((Map<TopicPartition, Object>)committedOffsets, this.createCommittedOffsetRecords$default$2());
        String memberId = "98098230493";
        Record groupMetadataRecord = this.buildStableGroupRecordWithMember(memberId);
        Record groupMetadataTombstone = Record.create((byte[])GroupMetadataManager$.MODULE$.groupMetadataKey(this.groupId()), null);
        MemoryRecords records2 = MemoryRecords.withRecords((long)startOffset, (Record[])((Record[])((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Record[]{groupMetadataRecord, groupMetadataTombstone}))).$plus$plus(offsetCommitRecords, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Record.class))));
        this.expectGroupMetadataLoad(groupMetadataTopicPartition, startOffset, records2);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.groupMetadataManager().loadGroupsAndOffsets(groupMetadataTopicPartition, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(GroupMetadata x$8) {
            }
        });
        GroupMetadata group = (GroupMetadata)this.groupMetadataManager().getGroup(this.groupId()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return TestUtils$.MODULE$.fail("Group was not loaded into the cache");
            }
        });
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)group.currentState());
        Assert.assertEquals((long)committedOffsets.size(), (long)group.allOffsets().size());
        committedOffsets.foreach((Function1)new Serializable(this, group){
            public static final long serialVersionUID = 0L;
            private final GroupMetadata group$4;

            public final void apply(Tuple2<TopicPartition, Object> x0$4) {
                Tuple2<TopicPartition, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)offset)), (Object)this.group$4.offset(topicPartition).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(OffsetAndMetadata x$9) {
                            return x$9.offset();
                        }
                    }));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.group$4 = group$4;
            }
        });
    }

    @Test
    public void testAddGroup() {
        GroupMetadata group = new GroupMetadata("foo", GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        Assert.assertEquals((Object)group, (Object)this.groupMetadataManager().addGroup(group));
        Assert.assertEquals((Object)group, (Object)this.groupMetadataManager().addGroup(new GroupMetadata("foo", GroupMetadata$.MODULE$.$lessinit$greater$default$2())));
    }

    @Test
    public void testStoreEmptyGroup() {
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef maybeError = ObjectRef.create((Object)None$.MODULE$);
        DelayedStore delayedStore = (DelayedStore)this.groupMetadataManager().prepareStoreGroup(group, (Map)scala.collection.Map$.MODULE$.empty(), (Function1)new Serializable(this, maybeError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef maybeError$1;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$GroupMetadataManagerTest$$callback$1(error, this.maybeError$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.maybeError$1 = maybeError$1;
            }
        }).get();
        this.groupMetadataManager().store(delayedStore);
        Assert.assertEquals((Object)new Some((Object)Errors.NONE), (Object)((Option)maybeError.elem));
    }

    @Test
    public void testStoreGroupErrorMapping() {
        this.assertStoreGroupErrorMapping(Errors.NONE, Errors.NONE);
        this.assertStoreGroupErrorMapping(Errors.UNKNOWN_TOPIC_OR_PARTITION, Errors.GROUP_COORDINATOR_NOT_AVAILABLE);
        this.assertStoreGroupErrorMapping(Errors.NOT_ENOUGH_REPLICAS, Errors.GROUP_COORDINATOR_NOT_AVAILABLE);
        this.assertStoreGroupErrorMapping(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND, Errors.GROUP_COORDINATOR_NOT_AVAILABLE);
        this.assertStoreGroupErrorMapping(Errors.NOT_LEADER_FOR_PARTITION, Errors.NOT_COORDINATOR_FOR_GROUP);
        this.assertStoreGroupErrorMapping(Errors.MESSAGE_TOO_LARGE, Errors.UNKNOWN);
        this.assertStoreGroupErrorMapping(Errors.RECORD_LIST_TOO_LARGE, Errors.UNKNOWN);
        this.assertStoreGroupErrorMapping(Errors.INVALID_FETCH_SIZE, Errors.UNKNOWN);
        this.assertStoreGroupErrorMapping(Errors.CORRUPT_MESSAGE, Errors.CORRUPT_MESSAGE);
    }

    private void assertStoreGroupErrorMapping(Errors appendError, Errors expectedError) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        this.expectAppendMessage(appendError);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef maybeError = ObjectRef.create((Object)None$.MODULE$);
        DelayedStore delayedStore = (DelayedStore)this.groupMetadataManager().prepareStoreGroup(group, (Map)scala.collection.Map$.MODULE$.empty(), (Function1)new Serializable(this, maybeError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef maybeError$2;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$GroupMetadataManagerTest$$callback$2(error, this.maybeError$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.maybeError$2 = maybeError$2;
            }
        }).get();
        this.groupMetadataManager().store(delayedStore);
        Assert.assertEquals((Object)new Some((Object)expectedError), (Object)((Option)maybeError.elem));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testStoreNonEmptyGroup() {
        String memberId = "memberId";
        String clientId = "clientId";
        String clientHost = "localhost";
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), clientId, clientHost, this.rebalanceTimeout(), this.sessionTimeout(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"protocol", Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))})));
        member.awaitingJoinCallback_$eq((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(JoinGroupResult x$10) {
            }
        });
        group.add(member);
        group.transitionTo((GroupState)PreparingRebalance$.MODULE$);
        group.initNextGeneration();
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef maybeError = ObjectRef.create((Object)None$.MODULE$);
        DelayedStore delayedStore = (DelayedStore)this.groupMetadataManager().prepareStoreGroup(group, (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)memberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))})), (Function1)new Serializable(this, maybeError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef maybeError$3;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$GroupMetadataManagerTest$$callback$3(error, this.maybeError$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.maybeError$3 = maybeError$3;
            }
        }).get();
        this.groupMetadataManager().store(delayedStore);
        Assert.assertEquals((Object)new Some((Object)Errors.NONE), (Object)((Option)maybeError.elem));
    }

    @Test
    public void testStoreNonEmptyGroupWhenCoordinatorHasMoved() {
        EasyMock.expect((Object)this.replicaManager().getMagicAndTimestampType((TopicPartition)EasyMock.anyObject())).andReturn((Object)None$.MODULE$);
        String memberId = "memberId";
        String clientId = "clientId";
        String clientHost = "localhost";
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), clientId, clientHost, this.rebalanceTimeout(), this.sessionTimeout(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"protocol", Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))})));
        member.awaitingJoinCallback_$eq((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(JoinGroupResult x$11) {
            }
        });
        group.add(member);
        group.transitionTo((GroupState)PreparingRebalance$.MODULE$);
        group.initNextGeneration();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef maybeError = ObjectRef.create((Object)None$.MODULE$);
        this.groupMetadataManager().prepareStoreGroup(group, (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)memberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))})), (Function1)new Serializable(this, maybeError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef maybeError$4;

            public final void apply(Errors error) {
                this.$outer.kafka$coordinator$GroupMetadataManagerTest$$callback$4(error, this.maybeError$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.maybeError$4 = maybeError$4;
            }
        });
        Assert.assertEquals((Object)new Some((Object)Errors.NOT_COORDINATOR_FOR_GROUP), (Object)((Option)maybeError.elem));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testCommitOffset() {
        String memberId = "";
        int generationId = -1;
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset))}));
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        DelayedStore delayedStore = (DelayedStore)this.groupMetadataManager().prepareStoreOffsets(group, memberId, generationId, offsets, (Function1)new Serializable(this, commitErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef commitErrors$1;

            public final void apply(scala.collection.immutable.Map<TopicPartition, Object> errors) {
                this.$outer.kafka$coordinator$GroupMetadataManagerTest$$callback$5(errors, this.commitErrors$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commitErrors$1 = commitErrors$1;
            }
        }).get();
        Assert.assertTrue((boolean)group.hasOffsets());
        this.groupMetadataManager().store(delayedStore);
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Option maybeError = ((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), (Object)maybeError);
        Assert.assertTrue((boolean)group.hasOffsets());
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        Option maybePartitionResponse = cachedOffsets.get((Object)topicPartition);
        Assert.assertFalse((boolean)maybePartitionResponse.isEmpty());
        OffsetFetchResponse.PartitionData partitionResponse = (OffsetFetchResponse.PartitionData)maybePartitionResponse.get();
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionResponse.error);
        Assert.assertEquals((long)offset, (long)partitionResponse.offset);
    }

    @Test
    public void testCommitOffsetWhenCoordinatorHasMoved() {
        EasyMock.expect((Object)this.replicaManager().getMagicAndTimestampType((TopicPartition)EasyMock.anyObject())).andReturn((Object)None$.MODULE$);
        String memberId = "";
        int generationId = -1;
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset))}));
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        this.groupMetadataManager().prepareStoreOffsets(group, memberId, generationId, offsets, (Function1)new Serializable(this, commitErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef commitErrors$2;

            public final void apply(scala.collection.immutable.Map<TopicPartition, Object> errors) {
                this.$outer.kafka$coordinator$GroupMetadataManagerTest$$callback$6(errors, this.commitErrors$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commitErrors$2 = commitErrors$2;
            }
        });
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Option maybeError = ((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)Errors.NOT_COORDINATOR_FOR_GROUP.code())), (Object)maybeError);
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testCommitOffsetFailure() {
        this.assertCommitOffsetErrorMapping(Errors.UNKNOWN_TOPIC_OR_PARTITION, Errors.GROUP_COORDINATOR_NOT_AVAILABLE);
        this.assertCommitOffsetErrorMapping(Errors.NOT_ENOUGH_REPLICAS, Errors.GROUP_COORDINATOR_NOT_AVAILABLE);
        this.assertCommitOffsetErrorMapping(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND, Errors.GROUP_COORDINATOR_NOT_AVAILABLE);
        this.assertCommitOffsetErrorMapping(Errors.NOT_LEADER_FOR_PARTITION, Errors.NOT_COORDINATOR_FOR_GROUP);
        this.assertCommitOffsetErrorMapping(Errors.MESSAGE_TOO_LARGE, Errors.INVALID_COMMIT_OFFSET_SIZE);
        this.assertCommitOffsetErrorMapping(Errors.RECORD_LIST_TOO_LARGE, Errors.INVALID_COMMIT_OFFSET_SIZE);
        this.assertCommitOffsetErrorMapping(Errors.INVALID_FETCH_SIZE, Errors.INVALID_COMMIT_OFFSET_SIZE);
        this.assertCommitOffsetErrorMapping(Errors.CORRUPT_MESSAGE, Errors.CORRUPT_MESSAGE);
    }

    private void assertCommitOffsetErrorMapping(Errors appendError, Errors expectedError) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        String memberId = "";
        int generationId = -1;
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset))}));
        this.expectAppendMessage(appendError);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        DelayedStore delayedStore = (DelayedStore)this.groupMetadataManager().prepareStoreOffsets(group, memberId, generationId, offsets, (Function1)new Serializable(this, commitErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef commitErrors$3;

            public final void apply(scala.collection.immutable.Map<TopicPartition, Object> errors) {
                this.$outer.kafka$coordinator$GroupMetadataManagerTest$$callback$7(errors, this.commitErrors$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commitErrors$3 = commitErrors$3;
            }
        }).get();
        Assert.assertTrue((boolean)group.hasOffsets());
        this.groupMetadataManager().store(delayedStore);
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Option maybeError = ((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)expectedError.code())), (Object)maybeError);
        Assert.assertFalse((boolean)group.hasOffsets());
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$12) {
                return x$12.offset;
            }
        }));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testExpireOffset() {
        String memberId = "";
        int generationId = -1;
        TopicPartition topicPartition1 = new TopicPartition("foo", 0);
        TopicPartition topicPartition2 = new TopicPartition("foo", 1);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        long startMs = this.time().milliseconds();
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition1), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition2), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 3L))}));
        EasyMock.expect((Object)this.replicaManager().getPartition(new TopicPartition(Topic$.MODULE$.GroupMetadataTopicName(), this.groupPartitionId()))).andStubReturn((Object)new Some((Object)this.partition()));
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        DelayedStore delayedStore = (DelayedStore)this.groupMetadataManager().prepareStoreOffsets(group, memberId, generationId, offsets, (Function1)new Serializable(this, commitErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef commitErrors$4;

            public final void apply(scala.collection.immutable.Map<TopicPartition, Object> errors) {
                this.$outer.kafka$coordinator$GroupMetadataManagerTest$$callback$8(errors, this.commitErrors$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commitErrors$4 = commitErrors$4;
            }
        }).get();
        Assert.assertTrue((boolean)group.hasOffsets());
        this.groupMetadataManager().store(delayedStore);
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), (Object)((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition1));
        this.time().sleep(2L);
        EasyMock.reset((Object[])new Object[]{this.partition()});
        EasyMock.expect((Object)this.partition().appendRecordsToLeader((MemoryRecords)EasyMock.anyObject(MemoryRecords.class), EasyMock.anyInt())).andReturn((Object)LogAppendInfo$.MODULE$.UnknownLogAppendInfo());
        EasyMock.replay((Object[])new Object[]{this.partition()});
        this.groupMetadataManager().cleanupGroupMetadata();
        Assert.assertEquals((Object)new Some((Object)group), (Object)this.groupMetadataManager().getGroup(this.groupId()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)group.offset(topicPartition1));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)offset)), (Object)group.offset(topicPartition2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetAndMetadata x$13) {
                return x$13.offset();
            }
        }));
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition1, topicPartition2}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition1).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$14) {
                return x$14.offset;
            }
        }));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)offset)), (Object)cachedOffsets.get((Object)topicPartition2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$15) {
                return x$15.offset;
            }
        }));
    }

    @Test
    public void testGroupMetadataRemoval() {
        TopicPartition topicPartition1 = new TopicPartition("foo", 0);
        TopicPartition topicPartition2 = new TopicPartition("foo", 1);
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        group.generationId_$eq(5);
        EasyMock.reset((Object[])new Object[]{this.partition()});
        Capture recordsCapture = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagicAndTimestampType((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)1), (Object)TimestampType.CREATE_TIME)));
        EasyMock.expect((Object)this.replicaManager().getPartition(new TopicPartition(Topic$.MODULE$.GroupMetadataTopicName(), this.groupPartitionId()))).andStubReturn((Object)new Some((Object)this.partition()));
        EasyMock.expect((Object)this.partition().appendRecordsToLeader((MemoryRecords)EasyMock.capture((Capture)recordsCapture), EasyMock.anyInt())).andReturn((Object)LogAppendInfo$.MODULE$.UnknownLogAppendInfo());
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.partition()});
        this.groupMetadataManager().cleanupGroupMetadata();
        Assert.assertTrue((boolean)recordsCapture.hasCaptured());
        List records2 = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((AbstractRecords)recordsCapture.getValue()).records()).asScala()).toList();
        Assert.assertEquals((long)1L, (long)records2.size());
        Record metadataTombstone = (Record)records2.head();
        Assert.assertTrue((boolean)metadataTombstone.hasKey());
        Assert.assertTrue((boolean)metadataTombstone.hasNullValue());
        Assert.assertEquals((long)1L, (long)metadataTombstone.magic());
        Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)metadataTombstone.timestampType());
        Assert.assertTrue((metadataTombstone.timestamp() > 0L ? 1 : 0) != 0);
        GroupMetadataKey groupKey = (GroupMetadataKey)GroupMetadataManager$.MODULE$.readMessageKey(metadataTombstone.key());
        Assert.assertEquals((Object)this.groupId(), (Object)groupKey.key());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.groupMetadataManager().getGroup(this.groupId()));
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition1, topicPartition2}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition1).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$16) {
                return x$16.offset;
            }
        }));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$17) {
                return x$17.offset;
            }
        }));
    }

    @Test
    public void testGroupMetadataRemovalWithLogAppendTime() {
        TopicPartition topicPartition1 = new TopicPartition("foo", 0);
        TopicPartition topicPartition2 = new TopicPartition("foo", 1);
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        group.generationId_$eq(5);
        EasyMock.reset((Object[])new Object[]{this.partition()});
        Capture recordsCapture = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagicAndTimestampType((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)1), (Object)TimestampType.LOG_APPEND_TIME)));
        EasyMock.expect((Object)this.replicaManager().getPartition(new TopicPartition(Topic$.MODULE$.GroupMetadataTopicName(), this.groupPartitionId()))).andStubReturn((Object)new Some((Object)this.partition()));
        EasyMock.expect((Object)this.partition().appendRecordsToLeader((MemoryRecords)EasyMock.capture((Capture)recordsCapture), EasyMock.anyInt())).andReturn((Object)LogAppendInfo$.MODULE$.UnknownLogAppendInfo());
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.partition()});
        this.groupMetadataManager().cleanupGroupMetadata();
        Assert.assertTrue((boolean)recordsCapture.hasCaptured());
        List records2 = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((AbstractRecords)recordsCapture.getValue()).records()).asScala()).toList();
        Assert.assertEquals((long)1L, (long)records2.size());
        Record metadataTombstone = (Record)records2.head();
        Assert.assertTrue((boolean)metadataTombstone.hasKey());
        Assert.assertTrue((boolean)metadataTombstone.hasNullValue());
        Assert.assertEquals((long)1L, (long)metadataTombstone.magic());
        Assert.assertEquals((Object)TimestampType.LOG_APPEND_TIME, (Object)metadataTombstone.timestampType());
        Assert.assertTrue((metadataTombstone.timestamp() > 0L ? 1 : 0) != 0);
        GroupMetadataKey groupKey = (GroupMetadataKey)GroupMetadataManager$.MODULE$.readMessageKey(metadataTombstone.key());
        Assert.assertEquals((Object)this.groupId(), (Object)groupKey.key());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.groupMetadataManager().getGroup(this.groupId()));
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition1, topicPartition2}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition1).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$18) {
                return x$18.offset;
            }
        }));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$19) {
                return x$19.offset;
            }
        }));
    }

    @Test
    public void testExpireGroupWithOffsetsOnly() {
        String memberId = "";
        int generationId = -1;
        TopicPartition topicPartition1 = new TopicPartition("foo", 0);
        TopicPartition topicPartition2 = new TopicPartition("foo", 1);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        long startMs = this.time().milliseconds();
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition1), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition2), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 3L))}));
        EasyMock.expect((Object)this.replicaManager().getPartition(new TopicPartition(Topic$.MODULE$.GroupMetadataTopicName(), this.groupPartitionId()))).andStubReturn((Object)new Some((Object)this.partition()));
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        DelayedStore delayedStore = (DelayedStore)this.groupMetadataManager().prepareStoreOffsets(group, memberId, generationId, offsets, (Function1)new Serializable(this, commitErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef commitErrors$5;

            public final void apply(scala.collection.immutable.Map<TopicPartition, Object> errors) {
                this.$outer.kafka$coordinator$GroupMetadataManagerTest$$callback$9(errors, this.commitErrors$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commitErrors$5 = commitErrors$5;
            }
        }).get();
        Assert.assertTrue((boolean)group.hasOffsets());
        this.groupMetadataManager().store(delayedStore);
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), (Object)((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition1));
        this.time().sleep(4L);
        EasyMock.reset((Object[])new Object[]{this.partition()});
        Capture recordsCapture = EasyMock.newCapture();
        EasyMock.expect((Object)this.partition().appendRecordsToLeader((MemoryRecords)EasyMock.capture((Capture)recordsCapture), EasyMock.anyInt())).andReturn((Object)LogAppendInfo$.MODULE$.UnknownLogAppendInfo());
        EasyMock.replay((Object[])new Object[]{this.partition()});
        this.groupMetadataManager().cleanupGroupMetadata();
        Assert.assertTrue((boolean)recordsCapture.hasCaptured());
        List records2 = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((AbstractRecords)recordsCapture.getValue()).records()).asScala()).toList();
        Assert.assertEquals((long)2L, (long)records2.size());
        records2.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;

            public final void apply(Record message) {
                Assert.assertTrue((boolean)message.hasKey());
                Assert.assertTrue((boolean)message.hasNullValue());
                OffsetKey offsetKey = (OffsetKey)GroupMetadataManager$.MODULE$.readMessageKey(message.key());
                Assert.assertEquals((Object)this.$outer.groupId(), (Object)offsetKey.key().group());
                Assert.assertEquals((Object)"foo", (Object)offsetKey.key().topicPartition().topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.groupMetadataManager().getGroup(this.groupId()));
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition1, topicPartition2}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition1).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$20) {
                return x$20.offset;
            }
        }));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$21) {
                return x$21.offset;
            }
        }));
    }

    @Test
    public void testExpireOffsetsWithActiveGroup() {
        String memberId = "memberId";
        String clientId = "clientId";
        String clientHost = "localhost";
        TopicPartition topicPartition1 = new TopicPartition("foo", 0);
        TopicPartition topicPartition2 = new TopicPartition("foo", 1);
        int offset = 37;
        this.groupMetadataManager().addPartitionOwnership(this.groupPartitionId());
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        this.groupMetadataManager().addGroup(group);
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), clientId, clientHost, this.rebalanceTimeout(), this.sessionTimeout(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"protocol", Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))})));
        member.awaitingJoinCallback_$eq((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(JoinGroupResult x$22) {
            }
        });
        group.add(member);
        group.transitionTo((GroupState)PreparingRebalance$.MODULE$);
        group.initNextGeneration();
        long startMs = this.time().milliseconds();
        scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition1), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition2), (Object)OffsetAndMetadata$.MODULE$.apply((long)offset, "", startMs, startMs + 3L))}));
        EasyMock.expect((Object)this.replicaManager().getPartition(new TopicPartition(Topic$.MODULE$.GroupMetadataTopicName(), this.groupPartitionId()))).andStubReturn((Object)new Some((Object)this.partition()));
        this.expectAppendMessage(Errors.NONE);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef commitErrors = ObjectRef.create((Object)None$.MODULE$);
        DelayedStore delayedStore = (DelayedStore)this.groupMetadataManager().prepareStoreOffsets(group, memberId, group.generationId(), offsets, (Function1)new Serializable(this, commitErrors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final ObjectRef commitErrors$6;

            public final void apply(scala.collection.immutable.Map<TopicPartition, Object> errors) {
                this.$outer.kafka$coordinator$GroupMetadataManagerTest$$callback$10(errors, this.commitErrors$6);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.commitErrors$6 = commitErrors$6;
            }
        }).get();
        Assert.assertTrue((boolean)group.hasOffsets());
        this.groupMetadataManager().store(delayedStore);
        Assert.assertFalse((boolean)((Option)commitErrors.elem).isEmpty());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), (Object)((MapLike)((Option)commitErrors.elem).get()).get((Object)topicPartition1));
        this.time().sleep(4L);
        EasyMock.reset((Object[])new Object[]{this.partition()});
        EasyMock.expect((Object)this.partition().appendRecordsToLeader((MemoryRecords)EasyMock.anyObject(MemoryRecords.class), EasyMock.anyInt())).andReturn((Object)LogAppendInfo$.MODULE$.UnknownLogAppendInfo());
        EasyMock.replay((Object[])new Object[]{this.partition()});
        this.groupMetadataManager().cleanupGroupMetadata();
        Assert.assertEquals((Object)new Some((Object)group), (Object)this.groupMetadataManager().getGroup(this.groupId()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)group.offset(topicPartition1));
        Assert.assertEquals((Object)None$.MODULE$, (Object)group.offset(topicPartition2));
        Map cachedOffsets = this.groupMetadataManager().getOffsets(this.groupId(), (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition1, topicPartition2}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition1).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$23) {
                return x$23.offset;
            }
        }));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)cachedOffsets.get((Object)topicPartition2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(OffsetFetchResponse.PartitionData x$24) {
                return x$24.offset;
            }
        }));
    }

    private void expectAppendMessage(Errors error) {
        Capture capturedArgument = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.anyBoolean(), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)capturedArgument));
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, error, capturedArgument){
            private final /* synthetic */ GroupMetadataManagerTest $outer;
            private final Errors error$1;
            private final Capture capturedArgument$1;

            public void answer() {
                ((Function1)this.capturedArgument$1.getValue()).apply((Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(Topic$.MODULE$.GroupMetadataTopicName(), this.$outer.groupPartitionId())), (Object)new ProduceResponse.PartitionResponse(this.error$1, 0L, -1L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.error$1 = error$1;
                this.capturedArgument$1 = capturedArgument$1;
            }
        });
        EasyMock.expect((Object)this.replicaManager().getMagicAndTimestampType((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)1), (Object)TimestampType.CREATE_TIME)));
    }

    private Record buildStableGroupRecordWithMember(String memberId) {
        GroupMetadata group = new GroupMetadata(this.groupId(), GroupMetadata$.MODULE$.$lessinit$greater$default$2());
        group.transitionTo((GroupState)PreparingRebalance$.MODULE$);
        List memberProtocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", (Object)Array$.MODULE$.emptyByteArray())}));
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), "clientId", "clientHost", 30000, 10000, "consumer", memberProtocols);
        group.add(member);
        member.awaitingJoinCallback_$eq((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(JoinGroupResult x$25) {
            }
        });
        group.initNextGeneration();
        group.transitionTo((GroupState)Stable$.MODULE$);
        byte[] groupMetadataKey = GroupMetadataManager$.MODULE$.groupMetadataKey(this.groupId());
        byte[] groupMetadataValue = GroupMetadataManager$.MODULE$.groupMetadataValue(group, (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)memberId), Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})), GroupMetadataManager$.MODULE$.groupMetadataValue$default$3());
        return Record.create((byte[])groupMetadataKey, (byte[])groupMetadataValue);
    }

    private void expectGroupMetadataLoad(TopicPartition groupMetadataTopicPartition, long startOffset, MemoryRecords records2) {
        long endOffset = startOffset + (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.deepEntries()).asScala()).size();
        Log logMock = (Log)EasyMock.mock(Log.class);
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        EasyMock.expect((Object)this.replicaManager().getLog(groupMetadataTopicPartition)).andStubReturn((Object)new Some((Object)logMock));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)this.replicaManager().getHighWatermark(groupMetadataTopicPartition)).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (Option)EasyMock.eq((Object)None$.MODULE$), EasyMock.eq((boolean)true))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)fileRecordsMock, FetchDataInfo$.MODULE$.apply$default$3()));
        EasyMock.expect((Object)fileRecordsMock.readInto((ByteBuffer)EasyMock.anyObject(ByteBuffer.class), EasyMock.anyInt())).andReturn((Object)records2.buffer());
        EasyMock.replay((Object[])new Object[]{logMock, fileRecordsMock});
    }

    private Seq<Record> createCommittedOffsetRecords(Map<TopicPartition, Object> committedOffsets, String groupId) {
        return ((TraversableOnce)committedOffsets.map((Function1)new Serializable(this, groupId){
            public static final long serialVersionUID = 0L;
            private final String groupId$1;

            public final Record apply(Tuple2<TopicPartition, Object> x0$5) {
                Tuple2<TopicPartition, Object> tuple2 = x0$5;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    OffsetAndMetadata offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offset);
                    byte[] offsetCommitKey = GroupMetadataManager$.MODULE$.offsetCommitKey(this.groupId$1, topicPartition, GroupMetadataManager$.MODULE$.offsetCommitKey$default$3());
                    byte[] offsetCommitValue = GroupMetadataManager$.MODULE$.offsetCommitValue(offsetAndMetadata);
                    Record record = Record.create((byte[])offsetCommitKey, (byte[])offsetCommitValue);
                    return record;
                }
                throw new MatchError(tuple2);
            }
            {
                this.groupId$1 = groupId$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    private String createCommittedOffsetRecords$default$2() {
        return this.groupId();
    }

    public final void kafka$coordinator$GroupMetadataManagerTest$$callback$1(Errors error, ObjectRef maybeError$1) {
        maybeError$1.elem = new Some((Object)error);
    }

    public final void kafka$coordinator$GroupMetadataManagerTest$$callback$2(Errors error, ObjectRef maybeError$2) {
        maybeError$2.elem = new Some((Object)error);
    }

    public final void kafka$coordinator$GroupMetadataManagerTest$$callback$3(Errors error, ObjectRef maybeError$3) {
        maybeError$3.elem = new Some((Object)error);
    }

    public final void kafka$coordinator$GroupMetadataManagerTest$$callback$4(Errors error, ObjectRef maybeError$4) {
        maybeError$4.elem = new Some((Object)error);
    }

    public final void kafka$coordinator$GroupMetadataManagerTest$$callback$5(scala.collection.immutable.Map errors, ObjectRef commitErrors$1) {
        commitErrors$1.elem = new Some((Object)errors);
    }

    public final void kafka$coordinator$GroupMetadataManagerTest$$callback$6(scala.collection.immutable.Map errors, ObjectRef commitErrors$2) {
        commitErrors$2.elem = new Some((Object)errors);
    }

    public final void kafka$coordinator$GroupMetadataManagerTest$$callback$7(scala.collection.immutable.Map errors, ObjectRef commitErrors$3) {
        commitErrors$3.elem = new Some((Object)errors);
    }

    public final void kafka$coordinator$GroupMetadataManagerTest$$callback$8(scala.collection.immutable.Map errors, ObjectRef commitErrors$4) {
        commitErrors$4.elem = new Some((Object)errors);
    }

    public final void kafka$coordinator$GroupMetadataManagerTest$$callback$9(scala.collection.immutable.Map errors, ObjectRef commitErrors$5) {
        commitErrors$5.elem = new Some((Object)errors);
    }

    public final void kafka$coordinator$GroupMetadataManagerTest$$callback$10(scala.collection.immutable.Map errors, ObjectRef commitErrors$6) {
        commitErrors$6.elem = new Some((Object)errors);
    }

    public GroupMetadataManagerTest() {
        this.groupId = "foo";
        this.groupPartitionId = 0;
        this.protocolType = "protocolType";
        this.rebalanceTimeout = 60000;
        this.sessionTimeout = 10000;
    }
}

