/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Properties;
import kafka.common.KafkaException;
import kafka.log.CleanerConfig;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.server.OffsetCheckpoint;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005!A/[7f+\u00051\u0002CA\f\u001b\u001b\u0005A\"BA\r\u0005\u0003\u0015)H/\u001b7t\u0013\tY\u0002D\u0001\u0005N_\u000e\\G+[7f\u0011\u0019i\u0002\u0001)A\u0005-\u0005)A/[7fA!9q\u0004\u0001b\u0001\n\u0003\u0001\u0013aD7bqJ{G\u000e\\%oi\u0016\u0014h/\u00197\u0016\u0003\u0005\u0002\"!\u0003\u0012\n\u0005\rR!aA%oi\"1Q\u0005\u0001Q\u0001\n\u0005\n\u0001#\\1y%>dG.\u00138uKJ4\u0018\r\u001c\u0011\t\u000f\u001d\u0002!\u0019!C\u0001A\u0005YQ.\u0019=M_\u001e\fu-Z't\u0011\u0019I\u0003\u0001)A\u0005C\u0005aQ.\u0019=M_\u001e\fu-Z'tA!91\u0006\u0001b\u0001\n\u0003a\u0013\u0001\u00037pOB\u0013x\u000e]:\u0016\u00035\u0002\"AL\u001a\u000e\u0003=R!\u0001M\u0019\u0002\tU$\u0018\u000e\u001c\u0006\u0002e\u0005!!.\u0019<b\u0013\t!tF\u0001\u0006Qe>\u0004XM\u001d;jKNDaA\u000e\u0001!\u0002\u0013i\u0013!\u00037pOB\u0013x\u000e]:!\u0011\u001dA\u0004A1A\u0005\u0002e\n\u0011\u0002\\8h\u0007>tg-[4\u0016\u0003i\u0002\"AE\u001e\n\u0005q\u0012!!\u0003'pO\u000e{gNZ5h\u0011\u0019q\u0004\u0001)A\u0005u\u0005QAn\\4D_:4\u0017n\u001a\u0011\t\u000f\u0001\u0003\u0001\u0019!C\u0001\u0003\u00061An\\4ESJ,\u0012A\u0011\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000bF\n!![8\n\u0005\u001d#%\u0001\u0002$jY\u0016Dq!\u0013\u0001A\u0002\u0013\u0005!*\u0001\u0006m_\u001e$\u0015N]0%KF$\"a\u0013(\u0011\u0005%a\u0015BA'\u000b\u0005\u0011)f.\u001b;\t\u000f=C\u0015\u0011!a\u0001\u0005\u0006\u0019\u0001\u0010J\u0019\t\rE\u0003\u0001\u0015)\u0003C\u0003\u001dawn\u001a#je\u0002Bqa\u0015\u0001A\u0002\u0013\u0005A+\u0001\u0006m_\u001el\u0015M\\1hKJ,\u0012!\u0016\t\u0003%YK!a\u0016\u0002\u0003\u00151{w-T1oC\u001e,'\u000fC\u0004Z\u0001\u0001\u0007I\u0011\u0001.\u0002\u001d1|w-T1oC\u001e,'o\u0018\u0013fcR\u00111j\u0017\u0005\b\u001fb\u000b\t\u00111\u0001V\u0011\u0019i\u0006\u0001)Q\u0005+\u0006YAn\\4NC:\fw-\u001a:!\u0011\u001dy\u0006A1A\u0005\u0002\u0001\fAA\\1nKV\t\u0011\r\u0005\u0002cK6\t1M\u0003\u0002ec\u0005!A.\u00198h\u0013\t17M\u0001\u0004TiJLgn\u001a\u0005\u0007Q\u0002\u0001\u000b\u0011B1\u0002\u000b9\fW.\u001a\u0011\t\u000f)\u0004!\u0019!C\u0001W\u0006Ib/\u001a:z\u0019\u0006\u0014x-\u001a'pO\u001acWo\u001d5J]R,'O^1m+\u0005a\u0007CA\u0005n\u0013\tq'B\u0001\u0003M_:<\u0007B\u00029\u0001A\u0003%A.\u0001\u000ewKJLH*\u0019:hK2{wM\u00127vg\"Le\u000e^3sm\u0006d\u0007\u0005C\u0003s\u0001\u0011\u00051/A\u0003tKR,\u0006\u000fF\u0001LQ\t\tX\u000f\u0005\u0002ww6\tqO\u0003\u0002ys\u0006)!.\u001e8ji*\t!0A\u0002pe\u001eL!\u0001`<\u0003\r\t+gm\u001c:f\u0011\u0015q\b\u0001\"\u0001t\u0003!!X-\u0019:E_^t\u0007fA?\u0002\u0002A\u0019a/a\u0001\n\u0007\u0005\u0015qOA\u0003BMR,'\u000f\u0003\u0004\u0002\n\u0001!\ta]\u0001\u000ei\u0016\u001cHo\u0011:fCR,Gj\\4)\t\u0005\u001d\u0011Q\u0002\t\u0004m\u0006=\u0011bAA\to\n!A+Z:u\u0011\u0019\t)\u0002\u0001C\u0001g\u0006)B/Z:u\u000f\u0016$hj\u001c8Fq&\u001cH/\u001a8u\u0019><\u0007\u0006BA\n\u0003\u001bAa!a\u0007\u0001\t\u0003\u0019\u0018A\u0007;fgR\u001cE.Z1okB,\u0005\u0010]5sK\u0012\u001cVmZ7f]R\u001c\b\u0006BA\r\u0003\u001bAa!!\t\u0001\t\u0003\u0019\u0018!\t;fgR\u001cE.Z1okB\u001cVmZ7f]R\u001cHk\\'bS:$\u0018-\u001b8TSj,\u0007\u0006BA\u0010\u0003\u001bAa!a\n\u0001\t\u0003\u0019\u0018A\u000b;fgR$u.Z:oi\u000ecW-\u00198M_\u001e\u001cx+\u001b;i\u0007>l\u0007/Y2u\t\u0016dW\r^3Q_2L7-\u001f\u0015\u0005\u0003K\ti\u0001\u0003\u0004\u0002.\u0001!\ta]\u0001\u0013i\u0016\u001cH\u000fV5nK\n\u000b7/\u001a3GYV\u001c\b\u000e\u000b\u0003\u0002,\u00055\u0001BBA\u001a\u0001\u0011\u00051/A\ruKN$H*Z1ti2{\u0017\rZ3e\u0003N\u001c\u0018n\u001a8nK:$\b\u0006BA\u0019\u0003\u001bAa!!\u000f\u0001\t\u0003\u0019\u0018a\t;fgR$vo\u001c'pO6\u000bg.Y4feN,6/\u001b8h'\u0006lW\rR5s\r\u0006LGn\u001d\u0015\u0005\u0003o\ti\u0001\u0003\u0004\u0002@\u0001!\ta]\u0001\u001di\u0016\u001cHo\u00115fG.\u0004x.\u001b8u%\u0016\u001cwN^3ssB{\u0017N\u001c;tQ\u0011\ti$!\u0004\t\r\u0005\u0015\u0003\u0001\"\u0001t\u00035\"Xm\u001d;SK\u000e|g/\u001a:z\t&\u0014Xm\u0019;pefl\u0015\r\u001d9j]\u001e<\u0016\u000e\u001e5Ue\u0006LG.\u001b8h'2\f7\u000f\u001b\u0015\u0005\u0003\u0007\ni\u0001\u0003\u0004\u0002L\u0001!\ta]\u00012i\u0016\u001cHOU3d_Z,'/\u001f#je\u0016\u001cGo\u001c:z\u001b\u0006\u0004\b/\u001b8h/&$\bNU3mCRLg/\u001a#je\u0016\u001cGo\u001c:zQ\u0011\tI%!\u0004\t\u000f\u0005E\u0003\u0001\"\u0003\u0002T\u0005Ab/\u001a:jMf\u001c\u0005.Z2la>Lg\u000e\u001e*fG>4XM]=\u0015\u000b-\u000b)&a!\t\u0011\u0005]\u0013q\na\u0001\u00033\nq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0007\u00037\nY'!\u001d\u000f\t\u0005u\u0013q\r\b\u0005\u0003?\n)'\u0004\u0002\u0002b)\u0019\u00111\r\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011bAA5\u0015\u00059\u0001/Y2lC\u001e,\u0017\u0002BA7\u0003_\u00121aU3r\u0015\r\tIG\u0003\t\u0005\u0003g\ny(\u0004\u0002\u0002v)!\u0011qOA=\u0003\u0019\u0019w.\\7p]*\u0019Q!a\u001f\u000b\u0007\u0005u\u00140\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003\u0003\u000b)H\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\rM\u000by\u00051\u0001V\u0011\u001d\t9\t\u0001C\u0005\u0003\u0013\u000b\u0001c\u0019:fCR,Gj\\4NC:\fw-\u001a:\u0015\u0007U\u000bY\t\u0003\u0006\u0002\u000e\u0006\u0015\u0005\u0013!a\u0001\u0003\u001f\u000bq\u0001\\8h\t&\u00148\u000f\u0005\u0003\n\u0003#\u0013\u0015bAAJ\u0015\t)\u0011I\u001d:bs\"I\u0011q\u0013\u0001\u0012\u0002\u0013%\u0011\u0011T\u0001\u001bGJ,\u0017\r^3M_\u001el\u0015M\\1hKJ$C-\u001a4bk2$H%M\u000b\u0003\u00037SC!a$\u0002\u001e.\u0012\u0011q\u0014\t\u0005\u0003C\u000bY+\u0004\u0002\u0002$*!\u0011QUAT\u0003%)hn\u00195fG.,GMC\u0002\u0002**\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti+a)\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class LogManagerTest {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        this.logDir_$eq(this.logManager().logDirs()[0]);
    }

    @After
    public void tearDown() {
        if (this.logManager() != null) {
            this.logManager().shutdown();
        }
        Utils.delete((File)this.logDir());
        Predef$.MODULE$.refArrayOps((Object[])this.logManager().logDirs()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File x$1) {
                Utils.delete((File)x$1);
            }
        });
    }

    @Test
    public void testCreateLog() {
        Log log = this.logManager().createLog(new TopicPartition(this.name(), 0), this.logConfig());
        File logFile = new File(this.logDir(), new StringBuilder().append((Object)this.name()).append((Object)"-0").toString());
        Assert.assertTrue((boolean)logFile.exists());
        log.append(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), log.append$default$2());
    }

    @Test
    public void testGetNonExistentLog() {
        Option log = this.logManager().getLog(new TopicPartition(this.name(), 0));
        Assert.assertEquals((String)"No log should be found.", (Object)None$.MODULE$, (Object)log);
        File logFile = new File(this.logDir(), new StringBuilder().append((Object)this.name()).append((Object)"-0").toString());
        Assert.assertTrue((!logFile.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testCleanupExpiredSegments() {
        Log log = this.logManager().createLog(new TopicPartition(this.name(), 0), this.logConfig());
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)new Serializable(this, log, offset){
            public static final long serialVersionUID = 0L;
            private final Log log$1;
            private final LongRef offset$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                LogAppendInfo info = this.log$1.append(set, this.log$1.append$default$2());
                this.offset$1.elem = info.lastOffset();
            }
            {
                this.log$1 = log$1;
                this.offset$1 = offset$1;
            }
        });
        Assert.assertTrue((String)"There should be more than one segment now.", (log.numberOfSegments() > 1 ? 1 : 0) != 0);
        log.logSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final boolean apply(LogSegment x$1) {
                return x$1.log().file().setLastModified(this.$outer.time().milliseconds());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assert.assertEquals((String)"Now there should only be only one segment in the index.", (long)1L, (long)log.numberOfSegments());
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().fileDeleteDelayMs()) + 1L);
        Assert.assertEquals((String)"Files should have been deleted", (long)(log.numberOfSegments() * 3), (long)log.dir().list().length);
        Assert.assertEquals((String)"Should get empty fetch off new log.", (long)0L, (long)log.read(offset.elem + 1L, 1024, log.read$default$3(), log.read$default$4()).records().sizeInBytes());
        try {
            log.read(0L, 1024, log.read$default$3(), log.read$default$4());
            Assert.fail((String)"Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {}
        log.append(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), log.append$default$2());
    }

    @Test
    public void testCleanupSegmentsToMaintainSize() {
        int setSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes();
        this.logManager().shutdown();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(10 * setSize));
        logProps.put(LogConfig$.MODULE$.RetentionBytesProp(), Predef$.MODULE$.long2Long(50L * (long)setSize + 10L));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        Log log = this.logManager().createLog(new TopicPartition(this.name(), 0), config);
        LongRef offset = LongRef.create((long)0L);
        int numMessages = 200;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, log, offset){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final LongRef offset$2;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                LogAppendInfo info = this.log$2.append(set, this.log$2.append$default$2());
                this.offset$2.elem = info.firstOffset();
            }
            {
                this.log$2 = log$2;
                this.offset$2 = offset$2;
            }
        });
        Assert.assertEquals((String)"Check we have the expected number of segments.", (long)(numMessages * setSize / Predef$.MODULE$.Integer2int(config.segmentSize())), (long)log.numberOfSegments());
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertEquals((String)"Now there should be exactly 6 segments", (long)6L, (long)log.numberOfSegments());
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().fileDeleteDelayMs()) + 1L);
        Assert.assertEquals((String)"Files should have been deleted", (long)(log.numberOfSegments() * 3), (long)log.dir().list().length);
        Assert.assertEquals((String)"Should get empty fetch off new log.", (long)0L, (long)log.read(offset.elem + 1L, 1024, log.read$default$3(), log.read$default$4()).records().sizeInBytes());
        try {
            log.read(0L, 1024, log.read$default$3(), log.read$default$4());
            Assert.fail((String)"Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {}
        log.append(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), log.append$default$2());
    }

    @Test
    public void testDoesntCleanLogsWithCompactDeletePolicy() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), new StringBuilder().append((Object)LogConfig$.MODULE$.Compact()).append((Object)",").append((Object)LogConfig$.MODULE$.Delete()).toString());
        Log log = this.logManager().createLog(new TopicPartition(this.name(), 0), LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps));
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)new Serializable(this, log, offset){
            public static final long serialVersionUID = 0L;
            private final Log log$3;
            private final LongRef offset$3;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                LogAppendInfo info = this.log$3.append(set, this.log$3.append$default$2());
                this.offset$3.elem = info.lastOffset();
            }
            {
                this.log$3 = log$3;
                this.offset$3 = offset$3;
            }
        });
        int numSegments = log.numberOfSegments();
        Assert.assertTrue((String)"There should be more than one segment now.", (log.numberOfSegments() > 1 ? 1 : 0) != 0);
        log.logSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final boolean apply(LogSegment x$2) {
                return x$2.log().file().setLastModified(this.$outer.time().milliseconds());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assert.assertEquals((String)"number of segments shouldn't have changed", (long)numSegments, (long)log.numberOfSegments());
    }

    @Test
    public void testTimeBasedFlush() {
        this.logManager().shutdown();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMsProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        Log log = this.logManager().createLog(new TopicPartition(this.name(), 0), config);
        long lastFlush = log.lastFlushTime();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final Log log$4;

            public final LogAppendInfo apply(int _) {
                MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
                return this.log$4.append(set, this.log$4.append$default$2());
            }
            {
                this.log$4 = log$4;
            }
        });
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertTrue((String)"Time based flush should have been triggered triggered", (lastFlush != log.lastFlushTime() ? 1 : 0) != 0);
    }

    @Test
    public void testLeastLoadedAssignment() {
        File[] dirs = (File[])((Object[])new File[]{TestUtils$.MODULE$.tempDir(), TestUtils$.MODULE$.tempDir(), TestUtils$.MODULE$.tempDir()});
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager(dirs));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final void apply(int partition) {
                this.apply$mcVI$sp(partition);
            }

            public void apply$mcVI$sp(int partition) {
                this.$outer.logManager().createLog(new TopicPartition("test", partition), this.$outer.logConfig());
                Assert.assertEquals((String)"We should have created the right number of logs", (long)(partition + 1), (long)this.$outer.logManager().allLogs().size());
                Iterable counts = (Iterable)this.$outer.logManager().allLogs().groupBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Log x$3) {
                        return x$3.dir().getParent();
                    }
                }).values().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Iterable<Log> x$4) {
                        return x$4.size();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
                Assert.assertTrue((String)"Load should balance evenly", (BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        try {
            this.createLogManager(this.createLogManager$default$1());
            Assert.fail((String)"Should not be able to create a second log manager instance with the same data directory");
        }
        catch (KafkaException kafkaException) {}
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1), new TopicPartition("test-b", 1)}))), this.logManager());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        this.logManager().shutdown();
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((File[])((Object[])new File[]{new File(new StringBuilder().append((Object)this.logDir().getAbsolutePath()).append((Object)File.separator).toString())}), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4()));
        this.logManager().startup();
        this.verifyCheckpointRecovery((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1)}))), this.logManager());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        this.logManager().shutdown();
        this.logDir_$eq(new File(new StringBuilder().append((Object)"data").append((Object)File.separator).append((Object)this.logDir().getName()).toString()));
        this.logDir().mkdirs();
        this.logDir().deleteOnExit();
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        this.verifyCheckpointRecovery((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test-a", 1)}))), this.logManager());
    }

    private void verifyCheckpointRecovery(Seq<TopicPartition> topicPartitions, LogManager logManager) {
        Seq logs = (Seq)topicPartitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManagerTest $outer;

            public final Log apply(TopicPartition x$5) {
                return this.$outer.logManager().createLog(x$5, this.$outer.logConfig());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        logs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Log log) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1)new Serializable(this, log){
                    public static final long serialVersionUID = 0L;
                    private final Log log$5;

                    public final LogAppendInfo apply(int _) {
                        return this.log$5.append(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), this.log$5.append$default$2());
                    }
                    {
                        this.log$5 = log$5;
                    }
                });
                log.flush();
            }
        });
        logManager.checkpointRecoveryPointOffsets();
        Map checkpoints = new OffsetCheckpoint(new File(this.logDir(), logManager.RecoveryPointCheckpointFile())).read();
        ((IterableLike)topicPartitions.zip((GenIterable)logs, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, checkpoints){
            public static final long serialVersionUID = 0L;
            private final Map checkpoints$1;

            public final void apply(Tuple2<TopicPartition, Log> x0$1) {
                Tuple2<TopicPartition, Log> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Log log = (Log)tuple2._2();
                    Assert.assertEquals((String)"Recovery point should equal checkpoint", (long)BoxesRunTime.unboxToLong((Object)this.checkpoints$1.apply((Object)tp)), (long)log.recoveryPoint());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.checkpoints$1 = checkpoints$1;
            }
        });
    }

    private LogManager createLogManager(File[] logDirs) {
        LogConfig x$6 = this.logConfig();
        File[] x$7 = logDirs;
        MockTime x$8 = this.time();
        CleanerConfig x$9 = TestUtils$.MODULE$.createLogManager$default$3();
        return TestUtils$.MODULE$.createLogManager(x$7, x$6, x$9, x$8);
    }

    private File[] createLogManager$default$1() {
        return (File[])((Object[])new File[]{this.logDir()});
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 36000000;
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(4096));
        this.logProps().put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(this.maxLogAgeMs()));
        this.logConfig = new LogConfig((java.util.Map)this.logProps());
        this.logDir = null;
        this.logManager = null;
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
    }
}

