/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Properties;
import kafka.api.SaslSetup$class;
import kafka.api.SaslSetupMode;
import kafka.api.SaslTestHarness;
import kafka.api.SaslTestHarness$class;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.network.SocketServer;
import kafka.security.minikdc.MiniKdc;
import kafka.server.ApiVersionsRequestTest$;
import kafka.server.BaseRequestTest;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u0001\u001d\u0011!dU1tY\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e+fgRT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!a\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\bCA\u0007\u0011\u001b\u0005q!BA\b\u0005\u0003\r\t\u0007/[\u0005\u0003#9\u0011qbU1tYR+7\u000f\u001e%be:,7o\u001d\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"!\u0003\u0001\t\u000b]\u0001A\u0011\u000b\r\u0002!M,7-\u001e:jif\u0004&o\u001c;pG>dW#A\r\u0011\u0005i!S\"A\u000e\u000b\u0005qi\u0012\u0001\u00039s_R|7m\u001c7\u000b\u0005yy\u0012AB2p[6|gN\u0003\u0002\u0006A)\u0011\u0011EI\u0001\u0007CB\f7\r[3\u000b\u0003\r\n1a\u001c:h\u0013\t)3D\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\"9q\u0005\u0001b\u0001\n#B\u0013\u0001G6bM.\f7\t\\5f]R\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[V\t\u0011\u0006\u0005\u0002+_5\t1F\u0003\u0002-[\u0005!A.\u00198h\u0015\u0005q\u0013\u0001\u00026bm\u0006L!\u0001M\u0016\u0003\rM#(/\u001b8h\u0011\u0019\u0011\u0004\u0001)A\u0005S\u0005I2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7!\u0011\u001d!\u0004A1A\u0005RU\n\u0011d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ngV\ta\u0007E\u00028}%j\u0011\u0001\u000f\u0006\u0003si\n\u0011\"[7nkR\f'\r\\3\u000b\u0005mb\u0014AC2pY2,7\r^5p]*\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@q\t!A*[:u\u0011\u0019\t\u0005\u0001)A\u0005m\u0005Q2.\u00194lCN+'O^3s'\u0006\u001cH.T3dQ\u0006t\u0017n]7tA!91\t\u0001b\u0001\n#\"\u0015\u0001F:feZ,'oU1tYB\u0013x\u000e]3si&,7/F\u0001F!\r1u)S\u0007\u0002y%\u0011\u0001\n\u0010\u0002\u0005'>lW\r\u0005\u0002K\u001b6\t1J\u0003\u0002M[\u0005!Q\u000f^5m\u0013\tq5J\u0001\u0006Qe>\u0004XM\u001d;jKNDa\u0001\u0015\u0001!\u0002\u0013)\u0015!F:feZ,'oU1tYB\u0013x\u000e]3si&,7\u000f\t\u0005\b%\u0002\u0011\r\u0011\"\u0015E\u0003Q\u0019G.[3oiN\u000b7\u000f\u001c)s_B,'\u000f^5fg\"1A\u000b\u0001Q\u0001\n\u0015\u000bQc\u00197jK:$8+Y:m!J|\u0007/\u001a:uS\u0016\u001c\b\u0005C\u0004W\u0001\t\u0007I\u0011K,\u0002\u001bi\\7+Y:m\u000b:\f'\r\\3e+\u0005A\u0006C\u0001$Z\u0013\tQFHA\u0004C_>dW-\u00198\t\rq\u0003\u0001\u0015!\u0003Y\u00039Q8nU1tY\u0016s\u0017M\u00197fI\u0002BQA\u0018\u0001\u0005B}\u000b!B\\;n\u0005J|7.\u001a:t+\u0005\u0001\u0007C\u0001$b\u0013\t\u0011GHA\u0002J]RDQ\u0001\u001a\u0001\u0005\u0002\u0015\f\u0001\u0007^3ti\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e\"fM>\u0014XmU1tY\"\u000bg\u000eZ:iC.,'+Z9vKN$H#\u00014\u0011\u0005\u0019;\u0017B\u00015=\u0005\u0011)f.\u001b;)\u0005\rT\u0007CA6o\u001b\u0005a'BA7#\u0003\u0015QWO\\5u\u0013\tyGN\u0001\u0003UKN$\b\"B9\u0001\t\u0003)\u0017a\f;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;BMR,'oU1tY\"\u000bg\u000eZ:iC.,'+Z9vKN$\bF\u00019k\u0011\u0015!\b\u0001\"\u0001f\u00031\"Xm\u001d;Ba&4VM]:j_:\u001c(+Z9vKN$x+\u001b;i+:\u001cX\u000f\u001d9peR,GMV3sg&|g\u000e\u000b\u0002tU\")q\u000f\u0001C\u0005q\u000612/\u001a8e\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000f\u0006\u0003z\u007f\u0006=\u0001C\u0001>~\u001b\u0005Y(B\u0001?\u001e\u0003!\u0011X-];fgR\u001c\u0018B\u0001@|\u0005M\t\u0005/\u001b,feNLwN\\:SKN\u0004xN\\:f\u0011\u001d\t\tA\u001ea\u0001\u0003\u0007\taa]8dW\u0016$\b\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%Q&A\u0002oKRLA!!\u0004\u0002\b\t11k\\2lKRDq!!\u0005w\u0001\u0004\t\u0019\"A\u0004sKF,Xm\u001d;\u0011\u0007i\f)\"C\u0002\u0002\u0018m\u0014!#\u00119j-\u0016\u00148/[8ogJ+\u0017/^3ti\"9\u00111\u0004\u0001\u0005\n\u0005u\u0011\u0001K:f]\u0012\u001c\u0016m\u001d7IC:$7\u000f[1lKJ+\u0017/^3tiZ\u000bG.\u001b3bi\u0016\u0014Vm\u001d9p]N,Gc\u00014\u0002 !A\u0011\u0011AA\r\u0001\u0004\t\u0019\u0001")
public class SaslApiVersionsRequestTest
extends BaseRequestTest
implements SaslTestHarness {
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final boolean zkSaslEnabled;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public /* synthetic */ void kafka$api$SaslTestHarness$$super$setUp() {
        KafkaServerTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$api$SaslTestHarness$$super$tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$api$SaslTestHarness$_setter_$kafkaClientSaslMechanism_$eq(String x$1) {
    }

    @Override
    public void kafka$api$SaslTestHarness$_setter_$kafkaServerSaslMechanisms_$eq(List x$1) {
    }

    @Override
    @Before
    public void setUp() {
        SaslTestHarness$class.setUp(this);
    }

    @Override
    @After
    public void tearDown() {
        SaslTestHarness$class.tearDown(this);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    @TraitSetter
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    @TraitSetter
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    @TraitSetter
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public void startSasl(SaslSetupMode mode, List<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism) {
        SaslSetup$class.startSasl(this, mode, kafkaServerSaslMechanisms, kafkaClientSaslMechanism);
    }

    @Override
    public void setJaasConfiguration(SaslSetupMode mode, List<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism) {
        SaslSetup$class.setJaasConfiguration(this, mode, kafkaServerSaslMechanisms, kafkaClientSaslMechanism);
    }

    @Override
    public void closeSasl() {
        SaslSetup$class.closeSasl(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup$class.kafkaServerSaslProperties(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup$class.kafkaClientSaslProperties(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism) {
        return SaslSetup$class.jaasClientLoginModule(this, clientSaslMechanism);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup$class.kafkaClientSaslProperties$default$2(this);
    }

    @Override
    public SaslSetupMode startSasl$default$1() {
        return SaslSetup$class.startSasl$default$1(this);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    @Override
    public String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    @Override
    public List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    public boolean zkSaslEnabled() {
        return this.zkSaslEnabled;
    }

    @Override
    public int numBrokers() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testApiVersionsRequestBeforeSaslHandshakeRequest() {
        SecurityProtocol x$1 = this.securityProtocol();
        SocketServer x$2 = this.connect$default$1();
        Socket plaintextSocket = this.connect(x$2, x$1);
        try {
            ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(plaintextSocket, (ApiVersionsRequest)new ApiVersionsRequest.Builder().setVersion((short)0).build());
            ApiVersionsRequestTest$.MODULE$.validateApiVersionsResponse(apiVersionsResponse);
            this.sendSaslHandshakeRequestValidateResponse(plaintextSocket);
        }
        catch (Throwable throwable) {
            void var1_3;
            var1_3.close();
            throw throwable;
        }
        plaintextSocket.close();
    }

    @Test
    public void testApiVersionsRequestAfterSaslHandshakeRequest() {
        SecurityProtocol x$3 = this.securityProtocol();
        SocketServer x$4 = this.connect$default$1();
        Socket plaintextSocket = this.connect(x$4, x$3);
        try {
            this.sendSaslHandshakeRequestValidateResponse(plaintextSocket);
            try {
                this.sendApiVersionsRequest(plaintextSocket, (ApiVersionsRequest)new ApiVersionsRequest.Builder().setVersion((short)0).build());
                throw this.fail("Versions Request during Sasl handshake did not fail", new Position("SaslApiVersionsRequestTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            }
            catch (IOException iOException) {
            }
        }
        finally {
            plaintextSocket.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testApiVersionsRequestWithUnsupportedVersion() {
        SecurityProtocol x$5 = this.securityProtocol();
        SocketServer x$6 = this.connect$default$1();
        Socket plaintextSocket = this.connect(x$6, x$5);
        try {
            ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest(new Struct(ProtoUtils.requestSchema((int)ApiKeys.API_VERSIONS.id, (int)0)), Short.MAX_VALUE);
            ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(plaintextSocket, apiVersionsRequest);
            Assert.assertEquals((long)Errors.UNSUPPORTED_VERSION.code(), (long)apiVersionsResponse.errorCode());
            ApiVersionsResponse apiVersionsResponse2 = this.sendApiVersionsRequest(plaintextSocket, (ApiVersionsRequest)new ApiVersionsRequest.Builder().setVersion((short)0).build());
            ApiVersionsRequestTest$.MODULE$.validateApiVersionsResponse(apiVersionsResponse2);
            this.sendSaslHandshakeRequestValidateResponse(plaintextSocket);
        }
        catch (Throwable throwable) {
            void var1_3;
            var1_3.close();
            throw throwable;
        }
        plaintextSocket.close();
    }

    private ApiVersionsResponse sendApiVersionsRequest(Socket socket, ApiVersionsRequest request) {
        ByteBuffer response = this.send((AbstractRequest)request, ApiKeys.API_VERSIONS, socket);
        return ApiVersionsResponse.parse((ByteBuffer)response);
    }

    private void sendSaslHandshakeRequestValidateResponse(Socket socket) {
        ByteBuffer response = this.send((AbstractRequest)new SaslHandshakeRequest("PLAIN"), ApiKeys.SASL_HANDSHAKE, socket);
        SaslHandshakeResponse handshakeResponse = SaslHandshakeResponse.parse((ByteBuffer)response);
        Assert.assertEquals((long)Errors.NONE.code(), (long)handshakeResponse.errorCode());
        Assert.assertEquals(Collections.singletonList("PLAIN"), (Object)handshakeResponse.enabledMechanisms());
    }

    public SaslApiVersionsRequestTest() {
        SaslSetup$class.$init$(this);
        SaslTestHarness$class.$init$(this);
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PLAIN"}));
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
        this.zkSaslEnabled = false;
    }
}

