/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import kafka.common.KafkaStorageException;
import kafka.log.Log$;
import kafka.log.LogFlushStats$;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.log.TimeIndex;
import kafka.log.TimestampOffset;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.LogOffsetMetadata;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tUg\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h'\u0016<W.\u001a8u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eD\u0001b\u0001\u0001\u0003\u0006\u0004%\t!F\u000b\u0002-A\u0011q#I\u0007\u00021)\u0011\u0011DG\u0001\u0007e\u0016\u001cwN\u001d3\u000b\u0005ma\u0012AB2p[6|gN\u0003\u0002\u0006;)\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0013\t\u0011\u0003DA\u0006GS2,'+Z2pe\u0012\u001c\b\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\t1|w\r\t\u0005\tM\u0001\u0011)\u0019!C\u0001O\u0005)\u0011N\u001c3fqV\t\u0001\u0006\u0005\u0002*U5\t!!\u0003\u0002,\u0005\tYqJ\u001a4tKRLe\u000eZ3y\u0011!i\u0003A!A!\u0002\u0013A\u0013AB5oI\u0016D\b\u0005\u0003\u00050\u0001\t\u0015\r\u0011\"\u00011\u0003%!\u0018.\\3J]\u0012,\u00070F\u00012!\tI#'\u0003\u00024\u0005\tIA+[7f\u0013:$W\r\u001f\u0005\tk\u0001\u0011\t\u0011)A\u0005c\u0005QA/[7f\u0013:$W\r\u001f\u0011\t\u0011]\u0002!Q1A\u0005\u0002a\n!BY1tK>3gm]3u+\u0005I\u0004CA\u0005;\u0013\tY$B\u0001\u0003M_:<\u0007\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\u0002\u0017\t\f7/Z(gMN,G\u000f\t\u0005\t\u007f\u0001\u0011)\u0019!C\u0001\u0001\u0006\u0011\u0012N\u001c3fq&sG/\u001a:wC2\u0014\u0015\u0010^3t+\u0005\t\u0005CA\u0005C\u0013\t\u0019%BA\u0002J]RD\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006I!Q\u0001\u0014S:$W\r_%oi\u0016\u0014h/\u00197CsR,7\u000f\t\u0005\t\u000f\u0002\u0011)\u0019!C\u0001q\u0005a!o\u001c7m\u0015&$H/\u001a:Ng\"A\u0011\n\u0001B\u0001B\u0003%\u0011(A\u0007s_2d'*\u001b;uKJl5\u000f\t\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\u0006!A/[7f!\tiu*D\u0001O\u0015\t\t\"$\u0003\u0002Q\u001d\n!A+[7f\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0003\u0019a\u0014N\\5u}QAA+\u0016,X1fS6\f\u0005\u0002*\u0001!)1!\u0015a\u0001-!)a%\u0015a\u0001Q!)q&\u0015a\u0001c!)q'\u0015a\u0001s!)q(\u0015a\u0001\u0003\")q)\u0015a\u0001s!)1*\u0015a\u0001\u0019\"9Q\f\u0001a\u0001\n\u0013A\u0014aB2sK\u0006$X\r\u001a\u0005\b?\u0002\u0001\r\u0011\"\u0003a\u0003-\u0019'/Z1uK\u0012|F%Z9\u0015\u0005\u0005$\u0007CA\u0005c\u0013\t\u0019'B\u0001\u0003V]&$\bbB3_\u0003\u0003\u0005\r!O\u0001\u0004q\u0012\n\u0004BB4\u0001A\u0003&\u0011(\u0001\u0005de\u0016\fG/\u001a3!\u0011\u001dI\u0007\u00011A\u0005\n\u0001\u000b\u0001DY=uKN\u001c\u0016N\\2f\u0019\u0006\u001cH/\u00138eKb,e\u000e\u001e:z\u0011\u001dY\u0007\u00011A\u0005\n1\fADY=uKN\u001c\u0016N\\2f\u0019\u0006\u001cH/\u00138eKb,e\u000e\u001e:z?\u0012*\u0017\u000f\u0006\u0002b[\"9QM[A\u0001\u0002\u0004\t\u0005BB8\u0001A\u0003&\u0011)A\rcsR,7oU5oG\u0016d\u0015m\u001d;J]\u0012,\u00070\u00128uef\u0004\u0003bB9\u0001\u0001\u0004%IA]\u0001\u0016e>dG.\u001b8h\u0005\u0006\u001cX\r\u001a+j[\u0016\u001cH/Y7q+\u0005\u0019\bcA\u0005us%\u0011QO\u0003\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f]\u0004\u0001\u0019!C\u0005q\u0006I\"o\u001c7mS:<')Y:fIRKW.Z:uC6\u0004x\fJ3r)\t\t\u0017\u0010C\u0004fm\u0006\u0005\t\u0019A:\t\rm\u0004\u0001\u0015)\u0003t\u0003Y\u0011x\u000e\u001c7j]\u001e\u0014\u0015m]3e)&lWm\u001d;b[B\u0004\u0003bB?\u0001\u0001\u0004%I\u0001O\u0001\u0012[\u0006DH+[7fgR\fW\u000e]*p\r\u0006\u0014\b\u0002C@\u0001\u0001\u0004%I!!\u0001\u0002+5\f\u0007\u0010V5nKN$\u0018-\u001c9T_\u001a\u000b'o\u0018\u0013fcR\u0019\u0011-a\u0001\t\u000f\u0015t\u0018\u0011!a\u0001s!9\u0011q\u0001\u0001!B\u0013I\u0014AE7bqRKW.Z:uC6\u00048k\u001c$be\u0002BC!!\u0002\u0002\fA\u0019\u0011\"!\u0004\n\u0007\u0005=!B\u0001\u0005w_2\fG/\u001b7f\u0011!\t\u0019\u0002\u0001a\u0001\n\u0013A\u0014\u0001F8gMN,Go\u00144NCb$\u0016.\\3ti\u0006l\u0007\u000fC\u0005\u0002\u0018\u0001\u0001\r\u0011\"\u0003\u0002\u001a\u0005ArN\u001a4tKR|e-T1y)&lWm\u001d;b[B|F%Z9\u0015\u0007\u0005\fY\u0002\u0003\u0005f\u0003+\t\t\u00111\u0001:\u0011\u001d\ty\u0002\u0001Q!\ne\nQc\u001c4gg\u0016$xJZ'bqRKW.Z:uC6\u0004\b\u0005\u000b\u0003\u0002\u001e\u0005-\u0001B\u0002*\u0001\t\u0003\t)\u0003F\nU\u0003O\tY$a\u0010\u0002B\u0005\u0015\u0013qIA%\u0003'\n9\u0006\u0003\u0005\u0002*\u0005\r\u0002\u0019AA\u0016\u0003\r!\u0017N\u001d\t\u0005\u0003[\t9$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003\tIwN\u0003\u0002\u00026\u0005!!.\u0019<b\u0013\u0011\tI$a\f\u0003\t\u0019KG.\u001a\u0005\b\u0003{\t\u0019\u00031\u0001:\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\t\r}\n\u0019\u00031\u0001B\u0011\u001d\t\u0019%a\tA\u0002\u0005\u000bA\"\\1y\u0013:$W\r_*ju\u0016DaaRA\u0012\u0001\u0004I\u0004BB&\u0002$\u0001\u0007A\n\u0003\u0006\u0002L\u0005\r\u0002\u0013!a\u0001\u0003\u001b\n\u0011CZ5mK\u0006c'/Z1es\u0016C\u0018n\u001d;t!\rI\u0011qJ\u0005\u0004\u0003#R!a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003+\n\u0019\u0003%AA\u0002\u0005\u000bA\"\u001b8ji\u001aKG.Z*ju\u0016D!\"!\u0017\u0002$A\u0005\t\u0019AA'\u0003-\u0001(/Z1mY>\u001c\u0017\r^3\t\r\u0005u\u0003\u0001\"\u00019\u0003\u0011\u0019\u0018N_3\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d\u0005Q2-\u00198D_:4XM\u001d;U_J+G.\u0019;jm\u0016|eMZ:fiR!\u0011QJA3\u0011\u001d\t9'a\u0018A\u0002e\naa\u001c4gg\u0016$\bbBA6\u0001\u0011\u0005\u0011QN\u0001\u0007CB\u0004XM\u001c3\u0015\u0017\u0005\fy'a\u001d\u0002x\u0005m\u0014q\u0010\u0005\b\u0003c\nI\u00071\u0001:\u0003-1\u0017N]:u\u001f\u001a47/\u001a;\t\u000f\u0005U\u0014\u0011\u000ea\u0001s\u0005iA.\u0019:hKN$xJ\u001a4tKRDq!!\u001f\u0002j\u0001\u0007\u0011(\u0001\tmCJ<Wm\u001d;US6,7\u000f^1na\"9\u0011QPA5\u0001\u0004I\u0014aG:iC2dwn^(gMN,Go\u00144NCb$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0005\u0002\u0002\u0006%\u0004\u0019AAB\u0003\u001d\u0011XmY8sIN\u00042aFAC\u0013\r\t9\t\u0007\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:)\t\u0005%\u00141\u0012\t\u0004\u001f\u00055\u0015bAAH!\tian\u001c8uQJ,\u0017\rZ:bM\u0016D\u0001\"a%\u0001\t\u0003\u0011\u0011QS\u0001\u0010iJ\fgn\u001d7bi\u0016|eMZ:fiR1\u0011qSA`\u0003\u0003\u0004B!!'\u0002::!\u00111TA[\u001d\u0011\ti*a-\u000f\t\u0005}\u0015\u0011\u0017\b\u0005\u0003C\u000byK\u0004\u0003\u0002$\u00065f\u0002BAS\u0003Wk!!a*\u000b\u0007\u0005%f!\u0001\u0004=e>|GOP\u0005\u0002A%\u0011adH\u0005\u0003\u000buI!a\u0007\u000f\n\u0005eQ\u0012bAA\\1\u0005Ya)\u001b7f%\u0016\u001cwN\u001d3t\u0013\u0011\tY,!0\u0003!1{w-\u00128uef\u0004vn]5uS>t'bAA\\1!9\u0011qMAI\u0001\u0004I\u0004\"CAb\u0003#\u0003\n\u00111\u0001B\u0003Q\u0019H/\u0019:uS:<g)\u001b7f!>\u001c\u0018\u000e^5p]\"\"\u0011\u0011SAd!\ry\u0011\u0011Z\u0005\u0004\u0003\u0017\u0004\"A\u0003;ie\u0016\fGm]1gK\"9\u0011q\u001a\u0001\u0005\u0002\u0005E\u0017\u0001\u0002:fC\u0012$B\"a5\u0002`\u0006\u0005\u0018Q]Au\u0003[\u0004B!!6\u0002\\6\u0011\u0011q\u001b\u0006\u0004\u00033$\u0011AB:feZ,'/\u0003\u0003\u0002^\u0006]'!\u0004$fi\u000eDG)\u0019;b\u0013:4w\u000eC\u0004\u0002>\u00055\u0007\u0019A\u001d\t\u000f\u0005\r\u0018Q\u001aa\u0001g\u0006IQ.\u0019=PM\u001a\u001cX\r\u001e\u0005\b\u0003O\fi\r1\u0001B\u0003\u001di\u0017\r_*ju\u0016D\u0011\"a;\u0002NB\u0005\t\u0019A\u001d\u0002\u00175\f\u0007\u0010U8tSRLwN\u001c\u0005\u000b\u0003_\fi\r%AA\u0002\u00055\u0013!D7j]>sW-T3tg\u0006<W\r\u000b\u0003\u0002N\u0006\u001d\u0007bBA{\u0001\u0011\u0005\u0011q_\u0001\be\u0016\u001cwN^3s)\r\t\u0015\u0011 \u0005\b\u0003w\f\u0019\u00101\u0001B\u00039i\u0017\r_'fgN\fw-Z*ju\u0016DC!a=\u0002\f\"9!\u0011\u0001\u0001\u0005\u0002\t\r\u0011\u0001\u00067pC\u0012d\u0015M]4fgR$\u0016.\\3ti\u0006l\u0007\u000fF\u0002b\u0005\u000bA!Ba\u0002\u0002\u0000B\u0005\t\u0019AA'\u00031\u0011X-\u00193U_2{w-\u00128e\u0011\u001d\u0011Y\u0001\u0001C!\u0005\u001b\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u001f\u0001BA!\u0005\u0003\u00185\u0011!1\u0003\u0006\u0005\u0005+\t\u0019$\u0001\u0003mC:<\u0017\u0002\u0002B\r\u0005'\u0011aa\u0015;sS:<\u0007b\u0002B\u000f\u0001\u0011\u0005!qD\u0001\u000biJ,hnY1uKR{GcA!\u0003\"!9\u0011q\rB\u000e\u0001\u0004I\u0004\u0006\u0002B\u000e\u0003\u0017CqAa\n\u0001\t\u0003\u0011I#\u0001\u0006oKb$xJ\u001a4tKR$\u0012!\u000f\u0015\u0005\u0005K\t9\rC\u0004\u00030\u0001!\tA!\r\u0002\u000b\u0019dWo\u001d5\u0015\u0003\u0005DCA!\f\u0002H\"9!q\u0007\u0001\u0005\u0002\te\u0012AE2iC:<WMR5mKN+hMZ5yKN$R!\u0019B\u001e\u0005\u0017B\u0001B!\u0010\u00036\u0001\u0007!qH\u0001\n_2$7+\u001e4gSb\u0004BA!\u0011\u0003H9\u0019\u0011Ba\u0011\n\u0007\t\u0015#\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00053\u0011IEC\u0002\u0003F)A\u0001B!\u0014\u00036\u0001\u0007!qH\u0001\n]\u0016<8+\u001e4gSbDqA!\u0015\u0001\t\u0003\u0011\t$A\fp]\n+7m\\7f\u0013:\f7\r^5wKN+w-\\3oi\"9!Q\u000b\u0001\u0005\u0002\t]\u0013!\u0005;j[\u0016<\u0016-\u001b;fI\u001a{'OU8mYR)\u0011H!\u0017\u0003^!9!1\fB*\u0001\u0004I\u0014a\u00018po\"9!q\fB*\u0001\u0004I\u0014\u0001E7fgN\fw-\u001a+j[\u0016\u001cH/Y7q\u0011\u001d\u0011\u0019\u0007\u0001C\u0001\u0005K\nQCZ5oI>3gm]3u\u0005f$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0003\u0003h\t=\u0004\u0003B\u0005u\u0005S\u00022!\u000bB6\u0013\r\u0011iG\u0001\u0002\u0010)&lWm\u001d;b[B|eMZ:fi\"9!\u0011\u000fB1\u0001\u0004I\u0014!\u0003;j[\u0016\u001cH/Y7q\u0011\u001d\u0011)\b\u0001C\u0001\u0005c\tQa\u00197pg\u0016DqA!\u001f\u0001\t\u0003\u0011\t$\u0001\u0004eK2,G/\u001a\u0005\u0007\u0005{\u0002A\u0011\u0001\u001d\u0002\u00191\f7\u000f^'pI&4\u0017.\u001a3\t\r\u0005e\u0004\u0001\"\u00019\u0011\u001d\u0011\u0019\t\u0001C\u0001\u0005\u000b\u000b\u0001\u0003\\1ti6{G-\u001b4jK\u0012|F%Z9\u0015\t\u00055#q\u0011\u0005\b\u0005\u0013\u0013\t\t1\u0001:\u0003\ti7\u000fC\u0005\u0003\u000e\u0002\t\n\u0011\"\u0001\u0003\u0010\u0006q!/Z1eI\u0011,g-Y;mi\u0012\"TC\u0001BIU\rI$1S\u0016\u0003\u0005+\u0003BAa&\u0003\"6\u0011!\u0011\u0014\u0006\u0005\u00057\u0013i*A\u0005v]\u000eDWmY6fI*\u0019!q\u0014\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003$\ne%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!q\u0015\u0001\u0012\u0002\u0013\u0005!\u0011V\u0001\u000fe\u0016\fG\r\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011YK\u000b\u0003\u0002N\tM\u0005\"\u0003BX\u0001E\u0005I\u0011\u0001BY\u0003e!(/\u00198tY\u0006$Xm\u00144gg\u0016$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tM&fA!\u0003\u0014\"I!q\u0017\u0001\u0012\u0002\u0013\u0005!\u0011V\u0001\u001fY>\fG\rT1sO\u0016\u001cH\u000fV5nKN$\u0018-\u001c9%I\u00164\u0017-\u001e7uIEB3\u0001AAF\u000f%\u0011iLAA\u0001\u0012\u0003\u0011y,\u0001\u0006M_\u001e\u001cVmZ7f]R\u00042!\u000bBa\r!\t!!!A\t\u0002\t\r7c\u0001Ba\u0011!9!K!1\u0005\u0002\t\u001dGC\u0001B`\u0011)\u0011YM!1\u0012\u0002\u0013\u0005!\u0011V\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\t\u0015\t='\u0011YI\u0001\n\u0003\u0011\t,A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005\u000f\u0005\u000b\u0005'\u0014\t-%A\u0005\u0002\t%\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013\b")
public class LogSegment
implements Logging {
    private final FileRecords log;
    private final OffsetIndex index;
    private final TimeIndex timeIndex;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private Option<Object> rollingBasedTimestamp;
    private volatile long kafka$log$LogSegment$$maxTimestampSoFar;
    private volatile long kafka$log$LogSegment$$offsetOfMaxTimestamp;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$9() {
        return LogSegment$.MODULE$.$lessinit$greater$default$9();
    }

    public static int $lessinit$greater$default$8() {
        return LogSegment$.MODULE$.$lessinit$greater$default$8();
    }

    public static boolean $lessinit$greater$default$7() {
        return LogSegment$.MODULE$.$lessinit$greater$default$7();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogSegment logSegment = this;
        synchronized (logSegment) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public FileRecords log() {
        return this.log;
    }

    public OffsetIndex index() {
        return this.index;
    }

    public TimeIndex timeIndex() {
        return this.timeIndex;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    private long created() {
        return this.created;
    }

    private void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    private Option<Object> rollingBasedTimestamp() {
        return this.rollingBasedTimestamp;
    }

    private void rollingBasedTimestamp_$eq(Option<Object> x$1) {
        this.rollingBasedTimestamp = x$1;
    }

    public long kafka$log$LogSegment$$maxTimestampSoFar() {
        return this.kafka$log$LogSegment$$maxTimestampSoFar;
    }

    public void kafka$log$LogSegment$$maxTimestampSoFar_$eq(long x$1) {
        this.kafka$log$LogSegment$$maxTimestampSoFar = x$1;
    }

    public long kafka$log$LogSegment$$offsetOfMaxTimestamp() {
        return this.kafka$log$LogSegment$$offsetOfMaxTimestamp;
    }

    public void kafka$log$LogSegment$$offsetOfMaxTimestamp_$eq(long x$1) {
        this.kafka$log$LogSegment$$offsetOfMaxTimestamp = x$1;
    }

    public long size() {
        return this.log().sizeInBytes();
    }

    public boolean canConvertToRelativeOffset(long offset) {
        return offset - this.baseOffset() <= Integer.MAX_VALUE;
    }

    public void append(long firstOffset, long largestOffset, long largestTimestamp, long shallowOffsetOfMaxTimestamp, MemoryRecords records) {
        if (records.sizeInBytes() > 0) {
            this.trace((Function0<String>)new Serializable(this, firstOffset, largestTimestamp, shallowOffsetOfMaxTimestamp, records){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final long firstOffset$1;
                private final long largestTimestamp$1;
                private final long shallowOffsetOfMaxTimestamp$1;
                private final MemoryRecords records$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Inserting %d bytes at offset %d at position %d with largest timestamp %d at shallow offset %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.records$1.sizeInBytes()), BoxesRunTime.boxToLong((long)this.firstOffset$1), BoxesRunTime.boxToInteger((int)this.$outer.log().sizeInBytes()), BoxesRunTime.boxToLong((long)this.largestTimestamp$1), BoxesRunTime.boxToLong((long)this.shallowOffsetOfMaxTimestamp$1)}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.firstOffset$1 = firstOffset$1;
                    this.largestTimestamp$1 = largestTimestamp$1;
                    this.shallowOffsetOfMaxTimestamp$1 = shallowOffsetOfMaxTimestamp$1;
                    this.records$1 = records$1;
                }
            });
            int physicalPosition = this.log().sizeInBytes();
            if (physicalPosition == 0) {
                this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)largestTimestamp)));
            }
            Predef$.MODULE$.require(this.canConvertToRelativeOffset(largestOffset), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "largest offset in message set can not be safely converted to relative offset.";
                }
            });
            int appendedBytes = this.log().append(records);
            this.trace((Function0<String>)new Serializable(this, firstOffset, appendedBytes){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final long firstOffset$1;
                private final int appendedBytes$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Appended ", " to ", " at offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.appendedBytes$1), this.$outer.log().file(), BoxesRunTime.boxToLong((long)this.firstOffset$1)}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.firstOffset$1 = firstOffset$1;
                    this.appendedBytes$1 = appendedBytes$1;
                }
            });
            if (largestTimestamp > this.kafka$log$LogSegment$$maxTimestampSoFar()) {
                this.kafka$log$LogSegment$$maxTimestampSoFar_$eq(largestTimestamp);
                this.kafka$log$LogSegment$$offsetOfMaxTimestamp_$eq(shallowOffsetOfMaxTimestamp);
            }
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.index().append(firstOffset, physicalPosition);
                this.timeIndex().maybeAppend(this.kafka$log$LogSegment$$maxTimestampSoFar(), this.kafka$log$LogSegment$$offsetOfMaxTimestamp(), this.timeIndex().maybeAppend$default$3());
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + records.sizeInBytes());
        }
    }

    public FileRecords.LogEntryPosition translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.index().lookup(offset);
        return this.log().searchForOffsetWithSize(offset, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, Option<Object> maxOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        Option<Object> option;
        block9: {
            int n;
            int adjustedMaxSize;
            LogOffsetMetadata offsetMetadata;
            int startPosition;
            FileRecords.LogEntryPosition startOffsetAndSize;
            block8: {
                int logSize;
                block7: {
                    if (maxSize < 0) {
                        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid max size for log read (%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxSize)})));
                    }
                    logSize = this.log().sizeInBytes();
                    startOffsetAndSize = this.translateOffset(startOffset, this.translateOffset$default$2());
                    if (startOffsetAndSize == null) {
                        return null;
                    }
                    startPosition = startOffsetAndSize.position;
                    offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition);
                    int n2 = adjustedMaxSize = minOneMessage ? package$.MODULE$.max(maxSize, startOffsetAndSize.size) : maxSize;
                    if (adjustedMaxSize == 0) {
                        return new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3());
                    }
                    option = maxOffset;
                    if (!None$.MODULE$.equals(option)) break block7;
                    n = package$.MODULE$.min((int)(maxPosition - (long)startPosition), adjustedMaxSize);
                    break block8;
                }
                if (!(option instanceof Some)) break block9;
                Some some = (Some)option;
                long offset = BoxesRunTime.unboxToLong((Object)some.x());
                if (offset < startOffset) {
                    return new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY, false);
                }
                FileRecords.LogEntryPosition mapping = this.translateOffset(offset, startPosition);
                int endPosition = mapping == null ? logSize : mapping.position;
                n = (int)package$.MODULE$.min(package$.MODULE$.min(maxPosition, (long)endPosition) - (long)startPosition, (long)adjustedMaxSize);
            }
            int length = n;
            return new FetchDataInfo(offsetMetadata, (Records)this.log().read(startPosition, length), adjustedMaxSize < startOffsetAndSize.size);
        }
        throw new MatchError(option);
    }

    public long read$default$4() {
        return this.size();
    }

    public boolean read$default$5() {
        return false;
    }

    public int recover(int maxMessageSize) {
        this.index().truncate();
        this.index().resize(this.index().maxIndexSize());
        this.timeIndex().truncate();
        this.timeIndex().resize(this.timeIndex().maxIndexSize());
        IntRef validBytes = IntRef.create((int)0);
        IntRef lastIndexEntry = IntRef.create((int)0);
        this.kafka$log$LogSegment$$maxTimestampSoFar_$eq(-1L);
        try {
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.log().shallowEntries(maxMessageSize)).asScala()).foreach((Function1)new Serializable(this, validBytes, lastIndexEntry){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogSegment $outer;
                private final IntRef validBytes$1;
                private final IntRef lastIndexEntry$1;

                public final void apply(FileLogInputStream.FileChannelLogEntry entry2) {
                    Record record2 = entry2.record();
                    record2.ensureValid();
                    if (record2.timestamp() > this.$outer.kafka$log$LogSegment$$maxTimestampSoFar()) {
                        this.$outer.kafka$log$LogSegment$$maxTimestampSoFar_$eq(record2.timestamp());
                        this.$outer.kafka$log$LogSegment$$offsetOfMaxTimestamp_$eq(entry2.offset());
                    }
                    if (this.validBytes$1.elem - this.lastIndexEntry$1.elem > this.$outer.indexIntervalBytes()) {
                        long startOffset = entry2.firstOffset();
                        this.$outer.index().append(startOffset, this.validBytes$1.elem);
                        this.$outer.timeIndex().maybeAppend(this.$outer.kafka$log$LogSegment$$maxTimestampSoFar(), this.$outer.kafka$log$LogSegment$$offsetOfMaxTimestamp(), this.$outer.timeIndex().maybeAppend$default$3());
                        this.lastIndexEntry$1.elem = this.validBytes$1.elem;
                    }
                    this.validBytes$1.elem += entry2.sizeInBytes();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.validBytes$1 = validBytes$1;
                    this.lastIndexEntry$1 = lastIndexEntry$1;
                }
            });
        }
        catch (CorruptRecordException corruptRecordException) {
            this.logger().warn((Object)new StringOps(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)validBytes.elem), corruptRecordException.getMessage()})));
        }
        int truncated = this.log().sizeInBytes() - validBytes.elem;
        this.log().truncateTo(validBytes.elem);
        this.index().trimToValidSize();
        this.timeIndex().maybeAppend(this.kafka$log$LogSegment$$maxTimestampSoFar(), this.kafka$log$LogSegment$$offsetOfMaxTimestamp(), true);
        this.timeIndex().trimToValidSize();
        return truncated;
    }

    public void loadLargestTimestamp(boolean readToLogEnd) {
        TimestampOffset lastTimeIndexEntry = this.timeIndex().lastEntry();
        this.kafka$log$LogSegment$$maxTimestampSoFar_$eq(lastTimeIndexEntry.timestamp());
        this.kafka$log$LogSegment$$offsetOfMaxTimestamp_$eq(lastTimeIndexEntry.offset());
        if (readToLogEnd) {
            OffsetPosition offsetPosition = this.index().lookup(lastTimeIndexEntry.offset());
            FileRecords.TimestampAndOffset maxTimestampOffsetAfterLastEntry = this.log().largestTimestampAfter(offsetPosition.position());
            if (maxTimestampOffsetAfterLastEntry.timestamp > lastTimeIndexEntry.timestamp()) {
                this.kafka$log$LogSegment$$maxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.timestamp);
                this.kafka$log$LogSegment$$offsetOfMaxTimestamp_$eq(maxTimestampOffsetAfterLastEntry.offset);
            }
        }
    }

    public boolean loadLargestTimestamp$default$1() {
        return false;
    }

    public String toString() {
        return new StringBuilder().append((Object)"LogSegment(baseOffset=").append((Object)BoxesRunTime.boxToLong((long)this.baseOffset())).append((Object)", size=").append((Object)BoxesRunTime.boxToLong((long)this.size())).append((Object)")").toString();
    }

    public int truncateTo(long offset) {
        FileRecords.LogEntryPosition mapping = this.translateOffset(offset, this.translateOffset$default$2());
        if (mapping == null) {
            return 0;
        }
        this.index().truncateTo(offset);
        this.timeIndex().truncateTo(offset);
        this.index().resize(this.index().maxIndexSize());
        this.timeIndex().resize(this.timeIndex().maxIndexSize());
        int bytesTruncated = this.log().truncateTo(mapping.position);
        if (this.log().sizeInBytes() == 0) {
            this.created_$eq(this.time.milliseconds());
            this.rollingBasedTimestamp_$eq((Option<Object>)None$.MODULE$);
        }
        this.bytesSinceLastIndexEntry_$eq(0);
        if (this.kafka$log$LogSegment$$maxTimestampSoFar() >= 0L) {
            this.loadLargestTimestamp(true);
        }
        return bytesTruncated;
    }

    public long nextOffset() {
        Option option;
        block6: {
            long l;
            block3: {
                long l2;
                block5: {
                    block4: {
                        FetchDataInfo ms;
                        block2: {
                            ms = this.read(this.index().lastOffset(), (Option<Object>)None$.MODULE$, this.log().sizeInBytes(), this.read$default$4(), this.read$default$5());
                            if (ms != null) break block2;
                            l = this.baseOffset();
                            break block3;
                        }
                        option = ((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ms.records().shallowEntries()).asScala()).lastOption();
                        if (!None$.MODULE$.equals(option)) break block4;
                        l2 = this.baseOffset();
                        break block5;
                    }
                    if (!(option instanceof Some)) break block6;
                    Some some = (Some)option;
                    LogEntry last = (LogEntry)some.x();
                    l2 = last.nextOffset();
                }
                l = l2;
            }
            return l;
        }
        throw new MatchError((Object)option);
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().flush();
                this.$outer.index().flush();
                this.$outer.timeIndex().flush();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        try {
            this.log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        }
        catch (IOException iOException) {
            throw this.kafkaStorageException$1("log", iOException, oldSuffix, newSuffix);
        }
        try {
            this.index().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.index().file().getPath(), oldSuffix, newSuffix)));
        }
        catch (IOException iOException) {
            throw this.kafkaStorageException$1("index", iOException, oldSuffix, newSuffix);
        }
        try {
            this.timeIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.timeIndex().file().getPath(), oldSuffix, newSuffix)));
            return;
        }
        catch (IOException iOException) {
            throw this.kafkaStorageException$1("timeindex", iOException, oldSuffix, newSuffix);
        }
    }

    public void onBecomeInactiveSegment() {
        this.timeIndex().maybeAppend(this.kafka$log$LogSegment$$maxTimestampSoFar(), this.kafka$log$LogSegment$$offsetOfMaxTimestamp(), true);
    }

    public long timeWaitedForRoll(long now, long messageTimestamp) {
        Some some;
        long t;
        Option<Object> option;
        Iterator iter;
        if (this.rollingBasedTimestamp().isEmpty() && (iter = this.log().shallowEntries().iterator()).hasNext()) {
            this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)((FileLogInputStream.FileChannelLogEntry)iter.next()).record().timestamp())));
        }
        long l = (option = this.rollingBasedTimestamp()) instanceof Some && (t = BoxesRunTime.unboxToLong((Object)(some = (Some)option).x())) >= 0L ? messageTimestamp - t : now - this.created();
        return l;
    }

    public Option<TimestampOffset> findOffsetByTimestamp(long timestamp2) {
        TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp2);
        int position = this.index().lookup(timestampOffset.offset()).position();
        return Option$.MODULE$.apply((Object)this.log().searchForTimestamp(timestamp2, position)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TimestampOffset apply(FileRecords.TimestampAndOffset timestampAndOffset) {
                return new TimestampOffset(timestampAndOffset.timestamp, timestampAndOffset.offset);
            }
        });
    }

    public void close() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.timeIndex().maybeAppend(this.$outer.kafka$log$LogSegment$$maxTimestampSoFar(), this.$outer.kafka$log$LogSegment$$offsetOfMaxTimestamp(), true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.index().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.timeIndex().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogSegment $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void delete() {
        boolean deletedLog = this.log().delete();
        boolean deletedIndex = this.index().delete();
        boolean deletedTimeIndex = this.timeIndex().delete();
        if (!deletedLog && this.log().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of log ").append((Object)this.log().file().getName()).append((Object)" failed.").toString());
        }
        if (!deletedIndex && this.index().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of index ").append((Object)this.index().file().getName()).append((Object)" failed.").toString());
        }
        if (!deletedTimeIndex && this.timeIndex().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of time index ").append((Object)this.timeIndex().file().getName()).append((Object)" failed.").toString());
        }
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public long largestTimestamp() {
        return this.kafka$log$LogSegment$$maxTimestampSoFar() >= 0L ? this.kafka$log$LogSegment$$maxTimestampSoFar() : this.lastModified();
    }

    public boolean lastModified_$eq(long ms) {
        this.log().file().setLastModified(ms);
        this.index().file().setLastModified(ms);
        return this.timeIndex().file().setLastModified(ms);
    }

    private final KafkaStorageException kafkaStorageException$1(String fileType, IOException e, String oldSuffix$1, String newSuffix$1) {
        return new KafkaStorageException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to change the ", " file suffix from ", " to ", " for log segment ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileType, oldSuffix$1, newSuffix$1, BoxesRunTime.boxToLong((long)this.baseOffset())})), e);
    }

    public LogSegment(FileRecords log, OffsetIndex index, TimeIndex timeIndex, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log;
        this.index = index;
        this.timeIndex = timeIndex;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        Logging$class.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
        this.rollingBasedTimestamp = None$.MODULE$;
        this.kafka$log$LogSegment$$maxTimestampSoFar = timeIndex.lastEntry().timestamp();
        this.kafka$log$LogSegment$$offsetOfMaxTimestamp = timeIndex.lastEntry().offset();
    }

    public LogSegment(File dir, long startOffset, int indexIntervalBytes, int maxIndexSize, long rollJitterMs, Time time, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        this(FileRecords.open((File)Log$.MODULE$.logFile(dir, startOffset), (boolean)fileAlreadyExists, (int)initFileSize, (boolean)preallocate), new OffsetIndex(Log$.MODULE$.indexFilename(dir, startOffset), startOffset, maxIndexSize), new TimeIndex(Log$.MODULE$.timeIndexFilename(dir, startOffset), startOffset, maxIndexSize), startOffset, indexIntervalBytes, rollJitterMs, time);
    }
}

