/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.MockScheduler;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\rEb\u0001B\u0001\u0003\u0001%\u0011!\u0004\u0016:b]N\f7\r^5p]\u000e{wN\u001d3j]\u0006$xN\u001d+fgRT!a\u0001\u0003\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003\u000b\u0019\t1bY8pe\u0012Lg.\u0019;pe*\tq!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g\rC\u0003\u0012\u0001\u0011\u0005!#\u0001\u0004=S:LGO\u0010\u000b\u0002'A\u0011A\u0003A\u0007\u0002\u0005!9a\u0003\u0001b\u0001\n\u00039\u0012\u0001\u0002;j[\u0016,\u0012\u0001\u0007\t\u00033\rj\u0011A\u0007\u0006\u00037q\tQ!\u001e;jYNT!!\b\u0010\u0002\r\r|W.\\8o\u0015\t9qD\u0003\u0002!C\u00051\u0011\r]1dQ\u0016T\u0011AI\u0001\u0004_J<\u0017B\u0001\u0013\u001b\u0005!iunY6US6,\u0007B\u0002\u0014\u0001A\u0003%\u0001$A\u0003uS6,\u0007\u0005C\u0004)\u0001\u0001\u0007I\u0011A\u0015\u0002\u000f9,\u0007\u0010\u001e)jIV\t!\u0006\u0005\u0002\fW%\u0011A\u0006\u0004\u0002\u0005\u0019>tw\rC\u0004/\u0001\u0001\u0007I\u0011A\u0018\u0002\u00179,\u0007\u0010\u001e)jI~#S-\u001d\u000b\u0003aM\u0002\"aC\u0019\n\u0005Ib!\u0001B+oSRDq\u0001N\u0017\u0002\u0002\u0003\u0007!&A\u0002yIEBaA\u000e\u0001!B\u0013Q\u0013\u0001\u00038fqR\u0004\u0016\u000e\u001a\u0011\t\u000fa\u0002!\u0019!C\u0001s\u0005Q\u0001/\u001b3NC:\fw-\u001a:\u0016\u0003i\u0002\"\u0001F\u001e\n\u0005q\u0012!!\u0005)s_\u0012,8-\u001a:JI6\u000bg.Y4fe\"1a\b\u0001Q\u0001\ni\n1\u0002]5e\u001b\u0006t\u0017mZ3sA!9\u0001\t\u0001b\u0001\n\u0003\t\u0015A\u0005;sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hKJ,\u0012A\u0011\t\u0003)\rK!\u0001\u0012\u0002\u0003/Q\u0013\u0018M\\:bGRLwN\\*uCR,W*\u00198bO\u0016\u0014\bB\u0002$\u0001A\u0003%!)A\nue\u0006t7/Y2uS>tW*\u00198bO\u0016\u0014\b\u0005C\u0004I\u0001\t\u0007I\u0011A%\u0002?Q\u0014\u0018M\\:bGRLwN\\'be.,'o\u00115b]:,G.T1oC\u001e,'/F\u0001K!\t!2*\u0003\u0002M\u0005\tyBK]1og\u0006\u001cG/[8o\u001b\u0006\u00148.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\t\r9\u0003\u0001\u0015!\u0003K\u0003\u0001\"(/\u00198tC\u000e$\u0018n\u001c8NCJ\\WM]\"iC:tW\r\\'b]\u0006<WM\u001d\u0011\t\u000fA\u0003!\u0019!C\u0001#\u0006Y1-\u00199ukJ,G\r\u0016=o+\u0005\u0011\u0006cA*W16\tAK\u0003\u0002VC\u0005AQ-Y:z[>\u001c7.\u0003\u0002X)\n91)\u00199ukJ,\u0007C\u0001\u000bZ\u0013\tQ&AA\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\r\u0003\u0004]\u0001\u0001\u0006IAU\u0001\rG\u0006\u0004H/\u001e:fIRCh\u000e\t\u0005\b=\u0002\u0011\r\u0011\"\u0001`\u0003Y\u0019\u0017\r\u001d;ve\u0016$WI\u001d:peN\u001c\u0015\r\u001c7cC\u000e\\W#\u00011\u0011\u0007M3\u0016\r\u0005\u0003\fE\u0012\u0004\u0014BA2\r\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002fQ6\taM\u0003\u0002h9\u0005A\u0001O]8u_\u000e|G.\u0003\u0002jM\n1QI\u001d:peNDaa\u001b\u0001!\u0002\u0013\u0001\u0017aF2baR,(/\u001a3FeJ|'o]\"bY2\u0014\u0017mY6!\u0011\u001di\u0007A1A\u0005\u00029\f\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002_B\u00111\u0002]\u0005\u0003c2\u00111!\u00138u\u0011\u0019\u0019\b\u0001)A\u0005_\u0006I!M]8lKJLE\r\t\u0005\bk\u0002\u0011\r\u0011\"\u0001o\u0003A\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000e\u0003\u0004x\u0001\u0001\u0006Ia\\\u0001\u0012G>|'\u000fZ5oCR|'/\u00129pG\"\u0004\u0003bB=\u0001\u0005\u0004%IA_\u0001\u0010iJ\fgn]1di&|g.\u00197JIV\t1\u0010E\u0002}\u0003\u0007i\u0011! \u0006\u0003}~\fA\u0001\\1oO*\u0011\u0011\u0011A\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0006u\u0014aa\u0015;sS:<\u0007bBA\u0005\u0001\u0001\u0006Ia_\u0001\u0011iJ\fgn]1di&|g.\u00197JI\u0002B\u0001\"!\u0004\u0001\u0005\u0004%IA\\\u0001\u000baJ|G-^2fe&#\u0007bBA\t\u0001\u0001\u0006Ia\\\u0001\faJ|G-^2fe&#\u0007\u0005C\u0005\u0002\u0016\u0001\u0011\r\u0011\"\u0003\u0002\u0018\u0005i\u0001O]8ek\u000e,'/\u00129pG\",\"!!\u0007\u0011\u0007-\tY\"C\u0002\u0002\u001e1\u0011Qa\u00155peRD\u0001\"!\t\u0001A\u0003%\u0011\u0011D\u0001\u000faJ|G-^2fe\u0016\u0003xn\u00195!\u0011!\t)\u0003\u0001b\u0001\n\u0013q\u0017\u0001\u0004;y]RKW.Z8vi6\u001b\bbBA\u0015\u0001\u0001\u0006Ia\\\u0001\u000eibtG+[7f_V$Xj\u001d\u0011\t\u0013\u00055\u0002A1A\u0005\n\u0005=\u0012A\u00039beRLG/[8ogV\u0011\u0011\u0011\u0007\t\u0007\u0003g\ti$!\u0011\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\tq!\\;uC\ndWMC\u0002\u0002<1\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty$!\u000e\u0003\u0007M+G\u000f\u0005\u0003\u0002D\u0005\u0015S\"\u0001\u000f\n\u0007\u0005\u001dCD\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u0011\u0005-\u0003\u0001)A\u0005\u0003c\t1\u0002]1si&$\u0018n\u001c8tA!I\u0011q\n\u0001C\u0002\u0013%\u0011\u0011K\u0001\ng\u000eDW\rZ;mKJ,\"!a\u0015\u0011\t\u0005U\u0013\u0011L\u0007\u0003\u0003/R!a\u0007\u0004\n\t\u0005m\u0013q\u000b\u0002\u000e\u001b>\u001c7nU2iK\u0012,H.\u001a:\t\u0011\u0005}\u0003\u0001)A\u0005\u0003'\n!b]2iK\u0012,H.\u001a:!\u0011!)\u0001A1A\u0005\u0002\u0005\rTCAA3!\r!\u0012qM\u0005\u0004\u0003S\u0012!A\u0006+sC:\u001c\u0018m\u0019;j_:\u001cun\u001c:eS:\fGo\u001c:\t\u0011\u00055\u0004\u0001)A\u0005\u0003K\nAbY8pe\u0012Lg.\u0019;pe\u0002B1\"!\u001d\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002t\u00051!/Z:vYR,\"!!\u001e\u0011\u0007Q\t9(C\u0002\u0002z\t\u0011A#\u00138jiB\u0013x\u000eZ;dKJLEMU3tk2$\bbCA?\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u007f\n!B]3tk2$x\fJ3r)\r\u0001\u0014\u0011\u0011\u0005\ni\u0005m\u0014\u0011!a\u0001\u0003kB\u0001\"!\"\u0001A\u0003&\u0011QO\u0001\be\u0016\u001cX\u000f\u001c;!\u0011%\tI\t\u0001a\u0001\n\u0003\tY)A\u0003feJ|'/F\u0001e\u0011%\ty\t\u0001a\u0001\n\u0003\t\t*A\u0005feJ|'o\u0018\u0013fcR\u0019\u0001'a%\t\u0011Q\ni)!AA\u0002\u0011Dq!a&\u0001A\u0003&A-\u0001\u0004feJ|'\u000f\t\u0005\b\u00037\u0003A\u0011BAO\u00039iwnY6QS\u0012l\u0015M\\1hKJ$\u0012\u0001\r\u0005\b\u0003C\u0003A\u0011BAR\u0003MIg.\u001b;QS\u0012<UM\\3sS\u000elunY6t)\r\u0001\u0014Q\u0015\u0005\bs\u0006}\u0005\u0019AAT!\u0011\tI+a,\u000f\u0007-\tY+C\u0002\u0002.2\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0003\u0003cS1!!,\r\u0011\u001d\t)\f\u0001C\u0001\u0003;\u000bAg\u001d5pk2$'+\u001a;ve:LeN^1mS\u0012\u0014V-];fgR<\u0006.\u001a8Ue\u0006t7/Y2uS>t\u0017\r\\%e\u0013N,U\u000e\u001d;zQ\u0011\t\u0019,!/\u0011\t\u0005m\u0016\u0011Y\u0007\u0003\u0003{S1!a0\"\u0003\u0015QWO\\5u\u0013\u0011\t\u0019-!0\u0003\tQ+7\u000f\u001e\u0005\b\u0003\u000f\u0004A\u0011AAO\u0003q\u001a\bn\\;mI\u0006\u001b7-\u001a9u\u0013:LG\u000fU5e\u0003:$'+\u001a;ve:tU\r\u001f;QS\u0012<\u0006.\u001a8Ue\u0006t7/Y2uS>t\u0017\r\\%e\u0013NtU\u000f\u001c7)\t\u0005\u0015\u0017\u0011\u0018\u0005\b\u0003\u001b\u0004A\u0011AAO\u0003=\u001a\bn\\;mI&s\u0017\u000e\u001e)jI^KG\u000f[#q_\u000eD',\u001a:p\r>\u0014h*Z<Ue\u0006t7/Y2uS>t\u0017\r\\%eQ\u0011\tY-!/\t\u000f\u0005M\u0007\u0001\"\u0001\u0002\u001e\u0006a3\u000f[8vY\u0012<UM\\3sCR,g*Z<Qe>$WoY3s\u0013\u0012Le-\u00129pG\"\u001cX\t\u001f5bkN$X\r\u001a\u0015\u0005\u0003#\fI\fC\u0004\u0002Z\u0002!\t!!(\u0002uMDw.\u001e7e%\u0016\u001c\bo\u001c8e/&$\bNT8u\u0007>|'\u000fZ5oCR|'o\u00148J]&$\b+\u001b3XQ\u0016tgj\u001c;D_>\u0014H-\u001b8bi>\u0014\b\u0006BAl\u0003sCq!a8\u0001\t\u0003\ti*\u0001%tQ>,H\u000e\u001a*fgB|g\u000eZ,ji\"\u001cun\u001c:eS:\fGo\u001c:M_\u0006$\u0017J\u001c)s_\u001e\u0014Xm]:P]&s\u0017\u000e\u001e)jI^CWM\\\"p_J$\u0017N\u001c;pe2{\u0017\rZ5oO\"\"\u0011Q\\A]\u0011\u001d\t)\u000f\u0001C\u0001\u0003;\u000b1l\u001d5pk2$'+Z:q_:$w+\u001b;i\u0013:4\u0018\r\\5e!&$W*\u00199qS:<wJ\\!eIB\u000b'\u000f^5uS>t7\u000fV8Ue\u0006t7/Y2uS>tw\u000b[3o)J\fgn]1di&|g.\u00197JI:{G\u000f\u0015:fg\u0016tG\u000f\u000b\u0003\u0002d\u0006e\u0006bBAv\u0001\u0011\u0005\u0011QT\u0001Tg\"|W\u000f\u001c3SKN\u0004xN\u001c3XSRD\u0017J\u001c<bY&$'+Z9vKN$\u0018\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016:b]N\f7\r^5p]^CWM\u001c+sC:\u001c\u0018m\u0019;j_:\fG.\u00133Jg\u0016k\u0007\u000f^=)\t\u0005%\u0018\u0011\u0018\u0005\b\u0003c\u0004A\u0011AAO\u0003I\u001b\bn\\;mIJ+7\u000f]8oI^KG\u000f[%om\u0006d\u0017\u000e\u001a*fcV,7\u000f^!eIB\u000b'\u000f^5uS>t7\u000fV8Ue\u0006t7/Y2uS>tw\u000b[3o)J\fgn]1di&|g.\u00197JI&\u001bh*\u001e7mQ\u0011\ty/!/\t\u000f\u0005]\b\u0001\"\u0001\u0002\u001e\u0006\u00015\u000f[8vY\u0012\u0014Vm\u001d9p]\u0012<\u0016\u000e\u001e5O_R\u001cun\u001c:eS:\fGo\u001c:P]\u0006#G\rU1si&$\u0018n\u001c8t/\",gNT8u\u0007>|'\u000fZ5oCR|'\u000f\u000b\u0003\u0002v\u0006e\u0006bBA\u007f\u0001\u0011\u0005\u0011QT\u0001Og\"|W\u000f\u001c3SKN\u0004xN\u001c3XSRD7i\\8sI&t\u0017\r^8s\u0019>\fG-\u00138Qe><'/Z:t\u001f:\fE\r\u001a)beRLG/[8og^CWM\\\"p_J$\u0017N\u001c;pe2{\u0017\rZ5oO\"\"\u00111`A]\u0011\u001d\u0011\u0019\u0001\u0001C\u0001\u0003;\u000baj\u001d5pk2$'+Z:q_:$w+\u001b;i\u0007>t7-\u001e:sK:$HK]1og\u0006\u001cG/[8og>s\u0017\t\u001a3QCJ$\u0018\u000e^5p]N<\u0006.\u001a8Ti\u0006$X-S:Qe\u0016\u0004\u0018M]3D_6l\u0017\u000e\u001e\u0015\u0005\u0005\u0003\tI\fC\u0004\u0003\n\u0001!\t!!(\u0002\u0019NDw.\u001e7e%\u0016\u001c\bo\u001c8e/&$\bnQ8oGV\u0014(/\u001a8u)J\fgn]1di&|gn\u00148BI\u0012\u0004\u0016M\u001d;ji&|gn],iK:\u001cF/\u0019;f\u0013N\u0004&/\u001a9be\u0016\f%m\u001c:uQ\u0011\u00119!!/\t\u000f\t=\u0001\u0001\"\u0001\u0003\u0012\u0005qb/\u00197jI\u0006$XmQ8oGV\u0014(/\u001a8u)J\fgn]1di&|gn\u001d\u000b\u0004a\tM\u0001\u0002\u0003B\u000b\u0005\u001b\u0001\rAa\u0006\u0002\u000bM$\u0018\r^3\u0011\u0007Q\u0011I\"C\u0002\u0003\u001c\t\u0011\u0001\u0003\u0016:b]N\f7\r^5p]N#\u0018\r^3\t\u000f\t}\u0001\u0001\"\u0001\u0002\u001e\u0006a5\u000f[8vY\u0012\u0014Vm\u001d9p]\u0012<\u0016\u000e\u001e5J]Z\fG.\u001b3U]b\u0004&o\u001c3vG\u0016,\u0005o\\2i\u001f:\fE\r\u001a)beRLG/[8og^CWM\\#q_\u000eD7/\u0011:f\t&4g-\u001a:f]RDCA!\b\u0002:\"9!Q\u0005\u0001\u0005\u0002\u0005u\u0015AP:i_VdG-\u00119qK:$g*Z<NKR\fG-\u0019;b)>dunZ(o\u0003\u0012$\u0007+\u0019:uSRLwN\\:XQ\u0016t\u0007+\u0019:uSRLwN\\:BI\u0012,G\r\u000b\u0003\u0003$\u0005e\u0006b\u0002B\u0016\u0001\u0011\u0005\u0011QT\u0001:g\"|W\u000f\u001c3SKN\u0004xN\u001c3XSRD7+^2dKN\u001cxJ\\!eIB\u000b'\u000f^5uS>t7o\u00165f]N#\u0018\r^3Jg>swm\\5oO\"\"!\u0011FA]\u0011\u001d\u0011\t\u0004\u0001C\u0001\u0003;\u000b\u0001i\u001d5pk2$'+Z:q_:$w+\u001b;i'V\u001c7-Z:t\u001f:\fE\r\u001a)beRLG/[8og^CWM\\*uCR,\u0017j]\"p[BdW\r^3D_6l\u0017\u000e\u001e\u0015\u0005\u0005_\tI\fC\u0004\u00038\u0001!\t!!(\u0002\u007fMDw.\u001e7e%\u0016\u001c\bo\u001c8e/&$\bnU;dG\u0016\u001c8o\u00148BI\u0012\u0004\u0016M\u001d;ji&|gn],iK:\u001cF/\u0019;f\u0013N\u001cu.\u001c9mKR,\u0017IY8si\"\"!QGA]\u0011\u001d\u0011i\u0004\u0001C\u0001\u0005\u007f\tqD^1mS\u0012\fG/Z*vG\u000e,7o\u001d4vY\u0006#G\rU1si&$\u0018n\u001c8t)\r\u0001$\u0011\t\u0005\t\u0005\u0007\u0012Y\u00041\u0001\u0003\u0018\u0005i\u0001O]3wS>,8o\u0015;bi\u0016DqAa\u0012\u0001\t\u0003\ti*A%tQ>,H\u000e\u001a*fgB|g\u000eZ,ji\",%O]8sg:{g.Z(o\u0003\u0012$\u0007+\u0019:uSRLwN\\,iK:tu.\u0012:s_J\u001c\u0018I\u001c3QCJ$\u0018\u000e^5p]N$\u0006.Z*b[\u0016DCA!\u0012\u0002:\"9!Q\n\u0001\u0005\u0002\u0005u\u0015\u0001P:i_VdGMU3qYf<\u0016\u000e\u001e5J]Z\fG.\u001b3QS\u0012l\u0015\r\u001d9j]\u001e|e.\u00128e)btw\u000b[3o)bt\u0017\n\u001a#pKNtG/\u0012=jgRDCAa\u0013\u0002:\"9!1\u000b\u0001\u0005\u0002\u0005u\u0015\u0001Q:i_VdGMU3qYf<\u0016\u000e\u001e5J]Z\fG.\u001b3QS\u0012l\u0015\r\u001d9j]\u001e|e.\u00128e)btw\u000b[3o!&$Gi\\:f]Rl\u0015\r^2i\u001b\u0006\u0004\b/\u001a3)\t\tE\u0013\u0011\u0018\u0005\b\u00053\u0002A\u0011AAO\u0003\u0011\u001b\bn\\;mIJ+\u0007\u000f\\=XSRD\u0007K]8ek\u000e,'OR3oG\u0016$wJ\\#oIRChn\u00165f]\u0016\u0003xn\u00195Jg:{GoU1nK\u0006\u001bHK]1og\u0006\u001cG/[8oQ\u0011\u00119&!/\t\u000f\t}\u0003\u0001\"\u0001\u0002\u001e\u0006\t5\u000f[8vY\u0012\u0014V\r^;s]>[wJ\\#oIRChn\u00165f]N#\u0018\r^;t\u0013N\u001cu.\u001c9mKR,7i\\7nSR\fe\u000e\u001a*fgVdG/S:D_6l\u0017\u000e\u001e\u0015\u0005\u0005;\nI\fC\u0004\u0003f\u0001!\t!!(\u0002\u007fMDw.\u001e7e%\u0016$XO\u001d8PW>sWI\u001c3Uq:<\u0006.\u001a8Ti\u0006$Xo]%t\u0007>l\u0007\u000f\\3uK\u0006\u0013wN\u001d;B]\u0012\u0014Vm];mi&\u001b\u0018IY8si\"\"!1MA]\u0011\u001d\u0011Y\u0007\u0001C\u0001\u0003;\u000b\u0001l\u001d5pk2$'+\u001a;ve:LeN^1mS\u0012$\u0006P\u001c*fcV,7\u000f^(o\u000b:$G\u000b\u001f8SKF,Xm\u001d;XQ\u0016t7\u000b^1ukNL5oQ8na2,G/Z!c_J$\u0018I\u001c3SKN,H\u000e^%t\u001d>$\u0018IY8si\"\"!\u0011NA]\u0011\u001d\u0011\t\b\u0001C\u0001\u0003;\u000b!l\u001d5pk2$'+\u001a;ve:LeN^1mS\u0012$\u0006P\u001c*fcV,7\u000f^(o\u000b:$G\u000b\u001f8SKF,Xm\u001d;XQ\u0016t7\u000b^1ukNL5oQ8na2,G/Z\"p[6LG/\u00118e%\u0016\u001cX\u000f\u001c;Jg:{GoQ8n[&$\b\u0006\u0002B8\u0003sCqAa\u001e\u0001\t\u0003\ti*\u0001%tQ>,H\u000e\u001a*fiV\u0014hnQ8oGV\u0014(/\u001a8u)bt'+Z9vKN$xJ\\#oIRChNU3rk\u0016\u001cHo\u00165f]N#\u0018\r^;t\u0013N\u0004&/\u001a9be\u0016\u001cu.\\7ji\"\"!QOA]\u0011\u001d\u0011i\b\u0001C\u0001\u0003;\u000bAi\u001d5pk2$'+\u001a;ve:LeN^1mS\u0012$\u0006P\u001c*fcV,7\u000f^(o\u000b:$G\u000b\u001f8SKF,Xm\u001d;XQ\u0016t7\u000b^1ukNL5\u000f\u0015:fa\u0006\u0014X-\u00112peRDCAa\u001f\u0002:\"9!1\u0011\u0001\u0005\u0002\u0005u\u0015AS:i_VdG-\u00119qK:$\u0007K]3qCJ,7i\\7nSR$v\u000eT8h\u001f:,e\u000e\u001a+y]^CWM\\*uCR,8/S:P]\u001e|\u0017N\\4B]\u0012\u0014Vm];mi&\u001b8i\\7nSRDCA!!\u0002:\"9!\u0011\u0012\u0001\u0005\u0002\u0005u\u0015\u0001S:i_VdG-\u00119qK:$\u0007K]3qCJ,\u0017IY8siR{Gj\\4P]\u0016sG\r\u0016=o/\",gn\u0015;biV\u001c\u0018j](oO>LgnZ!oIJ+7/\u001e7u\u0013N\f%m\u001c:uQ\u0011\u00119)!/\t\u000f\t=\u0005\u0001\"\u0001\u0002\u001e\u0006\u00015\u000f[8vY\u0012\u0014Vm\u001d9p]\u0012<\u0016\u000e\u001e5J]Z\fG.\u001b3SKF,Xm\u001d;P]\u0016sG\r\u0016=o/\",g\u000e\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ%t\u001dVdG\u000e\u000b\u0003\u0003\u000e\u0006e\u0006b\u0002BK\u0001\u0011\u0005\u0011QT\u0001Bg\"|W\u000f\u001c3SKN\u0004xN\u001c3XSRD\u0017J\u001c<bY&$'+Z9vKN$xJ\\#oIRChn\u00165f]R\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012L5/R7qifDCAa%\u0002:\"9!1\u0014\u0001\u0005\u0002\u0005u\u0015\u0001Q:i_VdGMU3ta>tGmV5uQ:{GoQ8pe\u0012Lg.\u0019;pe>sWI\u001c3Uq:<\u0006.\u001a8Jg:{GoQ8pe\u0012Lg.\u0019;pe\u001a{'/\u00133)\t\te\u0015\u0011\u0018\u0005\b\u0005C\u0003A\u0011AAO\u0003)\u001b\bn\\;mIJ+7\u000f]8oI^KG\u000f[\"p_J$\u0017N\\1u_Jdu.\u00193J]B\u0013xn\u001a:fgN|e.\u00128e)btw\u000b[3o\u0007>|'\u000fZ5oCR|'/S:M_\u0006$\u0017N\\4)\t\t}\u0015\u0011\u0018\u0005\b\u0005O\u0003A\u0011AAO\u0003A\u001b\bn\\;mI&s7M]3nK:$X\t]8dQ\u0006sG-\u00169eCR,W*\u001a;bI\u0006$\u0018m\u00148IC:$G.Z%oSR\u0004\u0016\u000eZ,iK:,\u00050[:uS:<W)\u001c9usR\u0013\u0018M\\:bGRLwN\u001c\u0015\u0005\u0005K\u000bI\fC\u0004\u0003.\u0002!\t!!(\u0002'NDw.\u001e7e\u0013:\u001c'/Z7f]R,\u0005o\\2i\u0003:$W\u000b\u001d3bi\u0016lU\r^1eCR\fwJ\u001c%b]\u0012dW-\u00138jiBKGm\u00165f]\u0016C\u0018n\u001d;j]\u001e\u001cu.\u001c9mKR,GK]1og\u0006\u001cG/[8oQ\u0011\u0011Y+!/\t\u000f\tM\u0006\u0001\"\u0001\u0002\u001e\u0006I6\u000f[8vY\u0012Len\u0019:f[\u0016tG/\u00129pG\"\fe\u000eZ+qI\u0006$X-T3uC\u0012\fG/Y(o\u0011\u0006tG\r\\3J]&$\b+\u001b3XQ\u0016tW\t_5ti&twmQ8na2,G/Z\"p[6LG\u000f\u0016:b]N\f7\r^5p]\"\"!\u0011WA]\u0011\u001d\u0011I\f\u0001C\u0001\u0003;\u000bak\u001d5pk2$w+Y5u\r>\u00148i\\7nSR$vnQ8na2,G/Z(o\u0011\u0006tG\r\\3J]&$\b+\u001b3B]\u0012,\u00050[:uS:<GK]1og\u0006\u001cG/[8o\u0013:\u0004&/\u001a9be\u0016\u001cu.\\7jiN#\u0018\r^3)\t\t]\u0016\u0011\u0018\u0005\b\u0005\u007f\u0003A\u0011AAO\u0003U\u001b\bn\\;mI^\u000b\u0017\u000e\u001e$pe\u000e{W.\\5u)>\u001cu.\u001c9mKR,wJ\u001c%b]\u0012dW-\u00138jiBKG-\u00118e\u000bbL7\u000f^5oOR\u0013\u0018M\\:bGRLwN\\%o!J,\u0007/\u0019:f\u0003\n|'\u000f^*uCR,\u0007\u0006\u0002B_\u0003sCqA!2\u0001\t\u0003\ti*\u0001&tQ>,H\u000eZ!c_J$HK]1og\u0006\u001cG/[8o\u001f:D\u0015M\u001c3mK&s\u0017\u000e\u001e)jI^CWM\\#ySN$\u0018N\\4Ue\u0006t7/Y2uS>t\u0017J\\(oO>LgnZ*uCR,\u0007\u0006\u0002Bb\u0003sCqAa3\u0001\t\u0003\ti*A\u0018tQ>,H\u000eZ+tK2\u000b7\u000f^#q_\u000eDGk\u001c$f]\u000e,w\u000b[3o\u000bB|7\r[:Be\u0016,\u0005\u0010[1vgR,G\r\u000b\u0003\u0003J\u0006e\u0006b\u0002Bi\u0001\u0011\u0005\u0011QT\u00011g\"|W\u000f\u001c3SK6|g/\u001a+sC:\u001c\u0018m\u0019;j_:\u001chi\u001c:QCJ$\u0018\u000e^5p]>sW)\\5he\u0006$\u0018n\u001c8)\t\t=\u0017\u0011\u0018\u0005\b\u0005/\u0004A\u0011AAO\u00031\u001a\bn\\;mI\u0006\u0013wN\u001d;FqBL'/\u001a3Ue\u0006t7/Y2uS>t7/\u00138P]\u001e|\u0017N\\4Ti\u0006$X\r\u000b\u0003\u0003V\u0006e\u0006b\u0002Bo\u0001\u0011\u0005\u0011QT\u0001Ag\"|W\u000f\u001c3O_R\f%m\u001c:u\u000bb\u0004\u0018N]3e)J\fgn]1di&|gn\u001d+iCRD\u0015M^3B!\u0016tG-\u001b8h'R\fG/\u001a+sC:\u001c\u0018\u000e^5p]\"\"!1\\A]\u0011\u001d\u0011\u0019\u000f\u0001C\u0005\u0005K\fQI^1mS\u0012\fG/\u001a*fgB|g\u000eZ:XSRD7i\u001c8dkJ\u0014XM\u001c;Ue\u0006t7/Y2uS>t7o\u00148J]&$\b+\u001b3XQ\u0016t\u0017J\u001c)sKB\f'/Z*uCR,Gc\u0001\u0019\u0003h\"A!Q\u0003Bq\u0001\u0004\u00119\u0002C\u0004\u0003l\u0002!IA!<\u0002OY\fG.\u001b3bi\u0016Len\u0019:f[\u0016tG/\u00129pG\"\fe\u000eZ+qI\u0006$X-T3uC\u0012\fG/\u0019\u000b\u0004a\t=\b\u0002\u0003B\u000b\u0005S\u0004\rAa\u0006\t\u000f\tM\b\u0001\"\u0003\u0003v\u0006YQn\\2l!J,\u0007/\u0019:f)\u0015A&q\u001fB~\u0011!\u0011IP!=A\u0002\t]\u0011\u0001\u0005;sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u0011)\u0011iP!=\u0011\u0002\u0003\u0007!q`\u0001\feVt7)\u00197mE\u0006\u001c7\u000eE\u0002\f\u0007\u0003I1aa\u0001\r\u0005\u001d\u0011un\u001c7fC:Dqaa\u0002\u0001\t\u0003\u0019I!\u0001\u000ej]&$\bK]8ek\u000e,'/\u00133N_\u000e\\7)\u00197mE\u0006\u001c7\u000eF\u00021\u0007\u0017A\u0001b!\u0004\u0004\u0006\u0001\u0007\u0011QO\u0001\u0004e\u0016$\bbBB\t\u0001\u0011\u000511C\u0001\u000fKJ\u0014xN]:DC2d'-Y2l)\r\u00014Q\u0003\u0005\b\u0007\u001b\u0019y\u00011\u0001e\u0011%\u0019I\u0002AI\u0001\n\u0013\u0019Y\"A\u000bn_\u000e\\\u0007K]3qCJ,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\ru!\u0006\u0002B\u0000\u0007?Y#a!\t\u0011\t\r\r2QF\u0007\u0003\u0007KQAaa\n\u0004*\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007Wa\u0011AC1o]>$\u0018\r^5p]&!1qFB\u0013\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class TransactionCoordinatorTest {
    private final MockTime time = new MockTime();
    private long nextPid = 0L;
    private final ProducerIdManager pidManager = (ProducerIdManager)EasyMock.createNiceMock(ProducerIdManager.class);
    private final TransactionStateManager transactionManager = (TransactionStateManager)EasyMock.createNiceMock(TransactionStateManager.class);
    private final TransactionMarkerChannelManager transactionMarkerChannelManager = (TransactionMarkerChannelManager)EasyMock.createNiceMock(TransactionMarkerChannelManager.class);
    private final Capture<TransactionMetadata> capturedTxn = EasyMock.newCapture();
    private final Capture<Function1<Errors, BoxedUnit>> capturedErrorsCallback = EasyMock.newCapture();
    private final int brokerId;
    private final int coordinatorEpoch;
    private final String transactionalId;
    private final int producerId;
    private final short producerEpoch;
    private final int txnTimeoutMs;
    private final Set<TopicPartition> partitions = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0)}));
    private final MockScheduler scheduler = new MockScheduler((Time)this.time());
    private final TransactionCoordinator coordinator = new TransactionCoordinator(this.brokerId(), (Scheduler)this.scheduler(), this.pidManager(), this.transactionManager(), this.transactionMarkerChannelManager(), (Time)this.time());
    private InitProducerIdResult result;
    private Errors error = Errors.NONE;

    public MockTime time() {
        return this.time;
    }

    public long nextPid() {
        return this.nextPid;
    }

    public void nextPid_$eq(long x$1) {
        this.nextPid = x$1;
    }

    public ProducerIdManager pidManager() {
        return this.pidManager;
    }

    public TransactionStateManager transactionManager() {
        return this.transactionManager;
    }

    public TransactionMarkerChannelManager transactionMarkerChannelManager() {
        return this.transactionMarkerChannelManager;
    }

    public Capture<TransactionMetadata> capturedTxn() {
        return this.capturedTxn;
    }

    public Capture<Function1<Errors, BoxedUnit>> capturedErrorsCallback() {
        return this.capturedErrorsCallback;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    private String transactionalId() {
        return this.transactionalId;
    }

    private int producerId() {
        return this.producerId;
    }

    private short producerEpoch() {
        return this.producerEpoch;
    }

    private int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    private Set<TopicPartition> partitions() {
        return this.partitions;
    }

    private MockScheduler scheduler() {
        return this.scheduler;
    }

    public TransactionCoordinator coordinator() {
        return this.coordinator;
    }

    public InitProducerIdResult result() {
        return this.result;
    }

    public void result_$eq(InitProducerIdResult x$1) {
        this.result = x$1;
    }

    public Errors error() {
        return this.error;
    }

    public void error_$eq(Errors x$1) {
        this.error = x$1;
    }

    private void mockPidManager() {
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)this.pidManager().generateProducerId())).andAnswer((IAnswer)new IAnswer<Object>(this){
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public long answer() {
                this.$outer.nextPid_$eq(this.$outer.nextPid() + 1L);
                return this.$outer.nextPid() - 1L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).anyTimes();
    }

    private void initPidGenericMocks(String transactionalId) {
        this.mockPidManager();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.transactionManager().validateTransactionTimeoutMs(EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
    }

    @Test
    public void shouldReturnInvalidRequestWhenTransactionalIdIsEmpty() {
        this.mockPidManager();
        EasyMock.replay((Object[])new Object[]{this.pidManager()});
        this.coordinator().handleInitProducerId("", this.txnTimeoutMs(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(InitProducerIdResult ret) {
                this.$outer.initProducerIdMockCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)new InitProducerIdResult(-1L, -1, Errors.INVALID_REQUEST), (Object)this.result());
        this.coordinator().handleInitProducerId("", this.txnTimeoutMs(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(InitProducerIdResult ret) {
                this.$outer.initProducerIdMockCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)new InitProducerIdResult(-1L, -1, Errors.INVALID_REQUEST), (Object)this.result());
    }

    @Test
    public void shouldAcceptInitPidAndReturnNextPidWhenTransactionalIdIsNull() {
        this.mockPidManager();
        EasyMock.replay((Object[])new Object[]{this.pidManager()});
        this.coordinator().handleInitProducerId(null, this.txnTimeoutMs(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(InitProducerIdResult ret) {
                this.$outer.initProducerIdMockCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)new InitProducerIdResult(0L, 0, Errors.NONE), (Object)this.result());
        this.coordinator().handleInitProducerId(null, this.txnTimeoutMs(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(InitProducerIdResult ret) {
                this.$outer.initProducerIdMockCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)new InitProducerIdResult(1L, 0, Errors.NONE), (Object)this.result());
    }

    @Test
    public void shouldInitPidWithEpochZeroForNewTransactionalId() {
        this.initPidGenericMocks(this.transactionalId());
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$)).once();
        EasyMock.expect((Object)this.transactionManager().putTransactionStateIfNotExists((String)EasyMock.eq((Object)this.transactionalId()), (TransactionMetadata)EasyMock.capture(this.capturedTxn()))).andAnswer((IAnswer)new IAnswer<Either<Errors, CoordinatorEpochAndTxnMetadata>>(this){
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public Either<Errors, CoordinatorEpochAndTxnMetadata> answer() {
                Assert.assertTrue((boolean)this.$outer.capturedTxn().hasCaptured());
                return package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.$outer.coordinatorEpoch(), (TransactionMetadata)this.$outer.capturedTxn().getValue()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).once();
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.anyObject(), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this){
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public void answer() {
                ((Function1)this.$outer.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.pidManager(), this.transactionManager()});
        this.coordinator().handleInitProducerId(this.transactionalId(), this.txnTimeoutMs(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(InitProducerIdResult ret) {
                this.$outer.initProducerIdMockCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)new InitProducerIdResult(this.nextPid() - 1L, 0, Errors.NONE), (Object)this.result());
    }

    @Test
    public void shouldGenerateNewProducerIdIfEpochsExhausted() {
        this.initPidGenericMocks(this.transactionalId());
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), (short)32766, this.txnTimeoutMs(), (TransactionState)Empty$.MODULE$, Set$.MODULE$.empty(), this.time().milliseconds(), this.time().milliseconds());
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata))));
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.anyObject(), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this){
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public void answer() {
                ((Function1)this.$outer.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        EasyMock.replay((Object[])new Object[]{this.pidManager(), this.transactionManager()});
        this.coordinator().handleInitProducerId(this.transactionalId(), this.txnTimeoutMs(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(InitProducerIdResult ret) {
                this.$outer.initProducerIdMockCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertNotEquals((long)this.producerId(), (long)this.result().producerId());
        Assert.assertEquals((long)0L, (long)this.result().producerEpoch());
        Assert.assertEquals((Object)Errors.NONE, (Object)this.result().error());
    }

    @Test
    public void shouldRespondWithNotCoordinatorOnInitPidWhenNotCoordinator() {
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.transactionManager().validateTransactionTimeoutMs(EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleInitProducerId(this.transactionalId(), this.txnTimeoutMs(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(InitProducerIdResult ret) {
                this.$outer.initProducerIdMockCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)new InitProducerIdResult(-1L, -1, Errors.NOT_COORDINATOR), (Object)this.result());
    }

    @Test
    public void shouldRespondWithCoordinatorLoadInProgressOnInitPidWhenCoordintorLoading() {
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.transactionManager().validateTransactionTimeoutMs(EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleInitProducerId(this.transactionalId(), this.txnTimeoutMs(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(InitProducerIdResult ret) {
                this.$outer.initProducerIdMockCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)new InitProducerIdResult(-1L, -1, Errors.COORDINATOR_LOAD_IN_PROGRESS), (Object)this.result());
    }

    @Test
    public void shouldRespondWithInvalidPidMappingOnAddPartitionsToTransactionWhenTransactionalIdNotPresent() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleAddPartitionsToTransaction(this.transactionalId(), 0L, (short)1, this.partitions(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.INVALID_PRODUCER_ID_MAPPING, (Object)this.error());
    }

    @Test
    public void shouldRespondWithInvalidRequestAddPartitionsToTransactionWhenTransactionalIdIsEmpty() {
        this.coordinator().handleAddPartitionsToTransaction("", 0L, (short)1, this.partitions(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.INVALID_REQUEST, (Object)this.error());
    }

    @Test
    public void shouldRespondWithInvalidRequestAddPartitionsToTransactionWhenTransactionalIdIsNull() {
        this.coordinator().handleAddPartitionsToTransaction(null, 0L, (short)1, this.partitions(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.INVALID_REQUEST, (Object)this.error());
    }

    @Test
    public void shouldRespondWithNotCoordinatorOnAddPartitionsWhenNotCoordinator() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleAddPartitionsToTransaction(this.transactionalId(), 0L, (short)1, this.partitions(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)this.error());
    }

    @Test
    public void shouldRespondWithCoordinatorLoadInProgressOnAddPartitionsWhenCoordintorLoading() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleAddPartitionsToTransaction(this.transactionalId(), 0L, (short)1, this.partitions(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)this.error());
    }

    @Test
    public void shouldRespondWithConcurrentTransactionsOnAddPartitionsWhenStateIsPrepareCommit() {
        this.validateConcurrentTransactions((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void shouldRespondWithConcurrentTransactionOnAddPartitionsWhenStateIsPrepareAbort() {
        this.validateConcurrentTransactions((TransactionState)PrepareAbort$.MODULE$);
    }

    public void validateConcurrentTransactions(TransactionState state) {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), 0L, 0, 0, state, Set$.MODULE$.empty(), 0L, 0L)))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleAddPartitionsToTransaction(this.transactionalId(), 0L, (short)0, this.partitions(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.CONCURRENT_TRANSACTIONS, (Object)this.error());
    }

    @Test
    public void shouldRespondWithInvalidTnxProduceEpochOnAddPartitionsWhenEpochsAreDifferent() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), 0L, 10, 0, (TransactionState)PrepareCommit$.MODULE$, Set$.MODULE$.empty(), 0L, 0L)))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleAddPartitionsToTransaction(this.transactionalId(), 0L, (short)0, this.partitions(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.INVALID_PRODUCER_EPOCH, (Object)this.error());
    }

    @Test
    public void shouldAppendNewMetadataToLogOnAddPartitionsWhenPartitionsAdded() {
        this.validateSuccessfulAddPartitions((TransactionState)Empty$.MODULE$);
    }

    @Test
    public void shouldRespondWithSuccessOnAddPartitionsWhenStateIsOngoing() {
        this.validateSuccessfulAddPartitions((TransactionState)Ongoing$.MODULE$);
    }

    @Test
    public void shouldRespondWithSuccessOnAddPartitionsWhenStateIsCompleteCommit() {
        this.validateSuccessfulAddPartitions((TransactionState)CompleteCommit$.MODULE$);
    }

    @Test
    public void shouldRespondWithSuccessOnAddPartitionsWhenStateIsCompleteAbort() {
        this.validateSuccessfulAddPartitions((TransactionState)CompleteAbort$.MODULE$);
    }

    public void validateSuccessfulAddPartitions(TransactionState previousState) {
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), previousState, Set$.MODULE$.empty(), this.time().milliseconds(), this.time().milliseconds());
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata))));
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.anyObject(), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleAddPartitionsToTransaction(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.partitions(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldRespondWithErrorsNoneOnAddPartitionWhenNoErrorsAndPartitionsTheSame() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), 0L, 0, 0, (TransactionState)Empty$.MODULE$, this.partitions(), 0L, 0L)))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleAddPartitionsToTransaction(this.transactionalId(), 0L, (short)0, this.partitions(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReplyWithInvalidPidMappingOnEndTxnWhenTxnIdDoesntExist() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), 0L, (short)0, TransactionResult.COMMIT, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.INVALID_PRODUCER_ID_MAPPING, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReplyWithInvalidPidMappingOnEndTxnWhenPidDosentMatchMapped() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), 10L, 0, 0, (TransactionState)Ongoing$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds())))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), 0L, (short)0, TransactionResult.COMMIT, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.INVALID_PRODUCER_ID_MAPPING, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReplyWithProducerFencedOnEndTxnWhenEpochIsNotSameAsTransaction() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), (long)this.producerId(), 1, 1, (TransactionState)Ongoing$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds())))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), (short)0, TransactionResult.COMMIT, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.INVALID_PRODUCER_EPOCH, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReturnOkOnEndTxnWhenStatusIsCompleteCommitAndResultIsCommit() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), (long)this.producerId(), 1, 1, (TransactionState)CompleteCommit$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds())))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), (short)1, TransactionResult.COMMIT, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReturnOkOnEndTxnWhenStatusIsCompleteAbortAndResultIsAbort() {
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), 1, 1, (TransactionState)CompleteAbort$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds());
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), (short)1, TransactionResult.ABORT, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReturnInvalidTxnRequestOnEndTxnRequestWhenStatusIsCompleteAbortAndResultIsNotAbort() {
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), 1, 1, (TransactionState)CompleteAbort$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds());
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), (short)1, TransactionResult.COMMIT, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.INVALID_TXN_STATE, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReturnInvalidTxnRequestOnEndTxnRequestWhenStatusIsCompleteCommitAndResultIsNotCommit() {
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), 1, 1, (TransactionState)CompleteCommit$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds());
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), (short)1, TransactionResult.ABORT, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.INVALID_TXN_STATE, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReturnConcurrentTxnRequestOnEndTxnRequestWhenStatusIsPrepareCommit() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), (long)this.producerId(), 1, 1, (TransactionState)PrepareCommit$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds())))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), (short)1, TransactionResult.COMMIT, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.CONCURRENT_TRANSACTIONS, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReturnInvalidTxnRequestOnEndTxnRequestWhenStatusIsPrepareAbort() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), (long)this.producerId(), 1, 1, (TransactionState)PrepareAbort$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds())))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), (short)1, TransactionResult.COMMIT, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.INVALID_TXN_STATE, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldAppendPrepareCommitToLogOnEndTxnWhenStatusIsOngoingAndResultIsCommit() {
        this.mockPrepare((TransactionState)PrepareCommit$.MODULE$, this.mockPrepare$default$2());
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), TransactionResult.COMMIT, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldAppendPrepareAbortToLogOnEndTxnWhenStatusIsOngoingAndResultIsAbort() {
        this.mockPrepare((TransactionState)PrepareAbort$.MODULE$, this.mockPrepare$default$2());
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), TransactionResult.ABORT, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldRespondWithInvalidRequestOnEndTxnWhenTransactionalIdIsNull() {
        this.coordinator().handleEndTransaction(null, 0L, (short)0, TransactionResult.COMMIT, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.INVALID_REQUEST, (Object)this.error());
    }

    @Test
    public void shouldRespondWithInvalidRequestOnEndTxnWhenTransactionalIdIsEmpty() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction("", 0L, (short)0, TransactionResult.COMMIT, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.INVALID_REQUEST, (Object)this.error());
    }

    @Test
    public void shouldRespondWithNotCoordinatorOnEndTxnWhenIsNotCoordinatorForId() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), 0L, (short)0, TransactionResult.COMMIT, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)this.error());
    }

    @Test
    public void shouldRespondWithCoordinatorLoadInProgressOnEndTxnWhenCoordinatorIsLoading() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), 0L, (short)0, TransactionResult.COMMIT, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(Errors ret) {
                this.$outer.errorsCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)this.error());
    }

    @Test
    public void shouldIncrementEpochAndUpdateMetadataOnHandleInitPidWhenExistingEmptyTransaction() {
        this.validateIncrementEpochAndUpdateMetadata((TransactionState)Empty$.MODULE$);
    }

    @Test
    public void shouldIncrementEpochAndUpdateMetadataOnHandleInitPidWhenExistingCompleteTransaction() {
        this.validateIncrementEpochAndUpdateMetadata((TransactionState)CompleteAbort$.MODULE$);
    }

    @Test
    public void shouldIncrementEpochAndUpdateMetadataOnHandleInitPidWhenExistingCompleteCommitTransaction() {
        this.validateIncrementEpochAndUpdateMetadata((TransactionState)CompleteCommit$.MODULE$);
    }

    @Test
    public void shouldWaitForCommitToCompleteOnHandleInitPidAndExistingTransactionInPrepareCommitState() {
        this.validateRespondsWithConcurrentTransactionsOnInitPidWhenInPrepareState((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void shouldWaitForCommitToCompleteOnHandleInitPidAndExistingTransactionInPrepareAbortState() {
        this.validateRespondsWithConcurrentTransactionsOnInitPidWhenInPrepareState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test
    public void shouldAbortTransactionOnHandleInitPidWhenExistingTransactionInOngoingState() {
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (TransactionState)Ongoing$.MODULE$, this.partitions(), this.time().milliseconds(), this.time().milliseconds());
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.transactionManager().validateTransactionTimeoutMs(EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.transactionManager().putTransactionStateIfNotExists((String)EasyMock.eq((Object)this.transactionalId()), (TransactionMetadata)EasyMock.anyObject())).andReturn((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata))).anyTimes();
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata)))).anyTimes();
        TransactionMetadata originalMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), (short)(this.producerEpoch() + 1), this.txnTimeoutMs(), (TransactionState)Ongoing$.MODULE$, this.partitions(), this.time().milliseconds(), this.time().milliseconds());
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)originalMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, this.time().milliseconds())), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this){
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public void answer() {
                ((Function1)this.$outer.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleInitProducerId(this.transactionalId(), this.txnTimeoutMs(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(InitProducerIdResult ret) {
                this.$outer.initProducerIdMockCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)new InitProducerIdResult(-1L, -1, Errors.CONCURRENT_TRANSACTIONS), (Object)this.result());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldUseLastEpochToFenceWhenEpochsAreExhausted() {
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), (short)32766, this.txnTimeoutMs(), (TransactionState)Ongoing$.MODULE$, this.partitions(), this.time().milliseconds(), this.time().milliseconds());
        Assert.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.transactionManager().validateTransactionTimeoutMs(EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.transactionManager().putTransactionStateIfNotExists((String)EasyMock.eq((Object)this.transactionalId()), (TransactionMetadata)EasyMock.anyObject())).andReturn((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata))).anyTimes();
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata)))).anyTimes();
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)new TxnTransitMetadata((long)this.producerId(), Short.MAX_VALUE, this.txnTimeoutMs(), (TransactionState)PrepareAbort$.MODULE$, this.partitions().toSet(), this.time().milliseconds(), this.time().milliseconds())), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this){
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public void answer() {
                ((Function1)this.$outer.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleInitProducerId(this.transactionalId(), this.txnTimeoutMs(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(InitProducerIdResult ret) {
                this.$outer.initProducerIdMockCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((long)32767L, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((Object)new InitProducerIdResult(-1L, -1, Errors.CONCURRENT_TRANSACTIONS), (Object)this.result());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldRemoveTransactionsForPartitionOnEmigration() {
        this.transactionManager().removeTransactionsForTxnTopicPartition(0, this.coordinatorEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.transactionMarkerChannelManager().removeMarkersForTxnTopicPartition(0);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.transactionManager(), this.transactionMarkerChannelManager()});
        this.coordinator().handleTxnEmigration(0, this.coordinatorEpoch());
        EasyMock.verify((Object[])new Object[]{this.transactionManager(), this.transactionMarkerChannelManager()});
    }

    @Test
    public void shouldAbortExpiredTransactionsInOngoingState() {
        long now = this.time().milliseconds();
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (TransactionState)Ongoing$.MODULE$, this.partitions(), now, now);
        EasyMock.expect((Object)this.transactionManager().timedOutTransactions()).andReturn((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransactionalIdAndProducerIdEpoch[]{new TransactionalIdAndProducerIdEpoch(this.transactionalId(), (long)this.producerId(), this.producerEpoch())})));
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata)))).once();
        TxnTransitMetadata expectedTransition = new TxnTransitMetadata((long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (TransactionState)PrepareAbort$.MODULE$, this.partitions().toSet(), now, now + (long)TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs());
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)expectedTransition), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this){

            public void answer() {
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.transactionManager(), this.transactionMarkerChannelManager()});
        this.coordinator().startup(false);
        this.time().sleep((long)TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs());
        this.scheduler().tick();
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldNotAbortExpiredTransactionsThatHaveAPendingStateTransition() {
        TransactionMetadata metadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (TransactionState)Ongoing$.MODULE$, this.partitions(), this.time().milliseconds(), this.time().milliseconds());
        metadata.prepareAbortOrCommit((TransactionState)PrepareCommit$.MODULE$, this.time().milliseconds());
        EasyMock.expect((Object)this.transactionManager().timedOutTransactions()).andReturn((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TransactionalIdAndProducerIdEpoch[]{new TransactionalIdAndProducerIdEpoch(this.transactionalId(), (long)this.producerId(), this.producerEpoch())})));
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), metadata))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager(), this.transactionMarkerChannelManager()});
        this.coordinator().startup(false);
        this.time().sleep((long)TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs());
        this.scheduler().tick();
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    private void validateRespondsWithConcurrentTransactionsOnInitPidWhenInPrepareState(TransactionState state) {
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.transactionManager().validateTransactionTimeoutMs(EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        TransactionMetadata metadata = new TransactionMetadata(this.transactionalId(), 0L, 0, 0, state, (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic", 1)})), 0L, 0L);
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), metadata)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleInitProducerId(this.transactionalId(), 10, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(InitProducerIdResult ret) {
                this.$outer.initProducerIdMockCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)new InitProducerIdResult(-1L, -1, Errors.CONCURRENT_TRANSACTIONS), (Object)this.result());
    }

    private void validateIncrementEpochAndUpdateMetadata(TransactionState state) {
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)this.pidManager().generateProducerId())).andReturn((Object)BoxesRunTime.boxToLong((long)this.producerId())).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.transactionManager().validateTransactionTimeoutMs(EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        TransactionMetadata metadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), state, Set$.MODULE$.empty(), this.time().milliseconds(), this.time().milliseconds());
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), metadata))));
        Capture capturedNewMetadata = EasyMock.newCapture();
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.capture((Capture)capturedNewMetadata), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, metadata, capturedNewMetadata){
            private final /* synthetic */ TransactionCoordinatorTest $outer;
            private final TransactionMetadata metadata$1;
            private final Capture capturedNewMetadata$1;

            public void answer() {
                this.metadata$1.completeTransitionTo((TxnTransitMetadata)this.capturedNewMetadata$1.getValue());
                ((Function1)this.$outer.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.metadata$1 = metadata$1;
                this.capturedNewMetadata$1 = capturedNewMetadata$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{this.pidManager(), this.transactionManager()});
        int newTxnTimeoutMs = 10;
        this.coordinator().handleInitProducerId(this.transactionalId(), newTxnTimeoutMs, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public final void apply(InitProducerIdResult ret) {
                this.$outer.initProducerIdMockCallback(ret);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((Object)new InitProducerIdResult((long)this.producerId(), (short)(this.producerEpoch() + 1), Errors.NONE), (Object)this.result());
        Assert.assertEquals((long)newTxnTimeoutMs, (long)metadata.txnTimeoutMs());
        Assert.assertEquals((long)this.time().milliseconds(), (long)metadata.txnLastUpdateTimestamp());
        Assert.assertEquals((long)((short)(this.producerEpoch() + 1)), (long)metadata.producerEpoch());
        Assert.assertEquals((long)this.producerId(), (long)metadata.producerId());
    }

    private TransactionMetadata mockPrepare(TransactionState transactionState, boolean runCallback) {
        long now = this.time().milliseconds();
        TransactionMetadata originalMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (TransactionState)Ongoing$.MODULE$, this.partitions(), now, now);
        TxnTransitMetadata transition = new TxnTransitMetadata((long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), transactionState, this.partitions().toSet(), now, now);
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), originalMetadata)))).once();
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)transition), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, runCallback){
            private final /* synthetic */ TransactionCoordinatorTest $outer;
            private final boolean runCallback$1;

            public void answer() {
                if (this.runCallback$1) {
                    ((Function1)this.$outer.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.runCallback$1 = runCallback$1;
            }
        }).once();
        return new TransactionMetadata(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), transactionState, this.partitions(), this.time().milliseconds(), this.time().milliseconds());
    }

    private boolean mockPrepare$default$2() {
        return false;
    }

    public void initProducerIdMockCallback(InitProducerIdResult ret) {
        this.result_$eq(ret);
    }

    public void errorsCallback(Errors ret) {
        this.error_$eq(ret);
    }

    public TransactionCoordinatorTest() {
        this.brokerId = 0;
        this.coordinatorEpoch = 0;
        this.transactionalId = "known";
        this.producerId = 10;
        this.producerEpoch = 1;
        this.txnTimeoutMs = 1;
    }
}

