/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.MockTime;
import org.junit.Assert;
import org.junit.Test;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001\u0013\t9BK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uCR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1\u0002\u001e:b]N\f7\r^5p]*\u0011QAB\u0001\fG>|'\u000fZ5oCR|'OC\u0001\b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0006\u0011\u0005-qQ\"\u0001\u0007\u000b\u00035\tQa]2bY\u0006L!a\u0004\u0007\u0003\r\u0005s\u0017PU3g\u0011\u0015\t\u0002\u0001\"\u0001\u0013\u0003\u0019a\u0014N\\5u}Q\t1\u0003\u0005\u0002\u0015\u00015\t!\u0001C\u0004\u0017\u0001\t\u0007I\u0011A\f\u0002\tQLW.Z\u000b\u00021A\u0011\u0011\u0004H\u0007\u00025)\u00111DB\u0001\u0006kRLGn]\u0005\u0003;i\u0011\u0001\"T8dWRKW.\u001a\u0005\u0007?\u0001\u0001\u000b\u0011\u0002\r\u0002\u000bQLW.\u001a\u0011\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002'Q,7\u000f^%oSRL\u0017\r\\5{K\u0016\u0003xn\u00195\u0015\u0003\r\u0002\"a\u0003\u0013\n\u0005\u0015b!\u0001B+oSRD#\u0001I\u0014\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013!\u00026v]&$(\"\u0001\u0017\u0002\u0007=\u0014x-\u0003\u0002/S\t!A+Z:u\u0011\u0015\u0001\u0004\u0001\"\u0001#\u0003M!Xm\u001d;O_Jl\u0017\r\\#q_\u000eD')^7qQ\tys\u0005C\u00034\u0001\u0011\u0005!%\u0001\u0015uKN$()^7q\u000bB|7\r\u001b(pi\u0006cGn\\<fI&3W\t]8dQN,\u0005\u0010[1vgR,G\r\u000b\u00033OU2\u0014\u0001C3ya\u0016\u001cG/\u001a3$\u0003]\u0002\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\t1\fgn\u001a\u0006\u0002y\u0005!!.\u0019<b\u0013\tq\u0014HA\u000bJY2,w-\u00197Ti\u0006$X-\u0012=dKB$\u0018n\u001c8\t\u000b\u0001\u0003A\u0011\u0001\u0012\u0002KQ,7\u000f\u001e$f]\u000e,\u0007K]8ek\u000e,'/\u00114uKJ,\u0005o\\2ig\u0016C\b.Y;ti\u0016$\u0007FA (\u0011\u0015\u0019\u0005\u0001\"\u0001#\u00031\"Xm\u001d;GK:\u001cW\r\u0015:pIV\u001cWM\u001d(pi\u0006cGn\\<fI&3\u0017\n^,pk2$wJ^3sM2|w\u000f\u000b\u0003COU2\u0004\"\u0002$\u0001\t\u0003\u0011\u0013\u0001\u0006;fgR\u0014v\u000e^1uKB\u0013x\u000eZ;dKJLE\r\u000b\u0002FO!)\u0011\n\u0001C\u0001E\u0005\u0011C/Z:u%>$\u0018\r^3Qe>$WoY3s\u0013\u0012Len\u00148h_&twm\u0015;bi\u0016DC\u0001S\u00146m!)A\n\u0001C\u0001E\u00059C/Z:u%>$\u0018\r^3Qe>$WoY3s\u0013\u0012Le\u000e\u0015:fa\u0006\u0014X-\u00112peR\u001cF/\u0019;fQ\u0011Yu%\u000e\u001c\t\u000b=\u0003A\u0011\u0001\u0012\u0002QQ,7\u000f\u001e*pi\u0006$X\r\u0015:pIV\u001cWM]%e\u0013:\u0004&/\u001a9be\u0016\u001cu.\\7jiN#\u0018\r^3)\t9;SG\u000e\u0005\u0006\u0013\u0002!IA\u0015\u000b\u0003GMCQ\u0001V)A\u0002U\u000bQa\u001d;bi\u0016\u0004\"\u0001\u0006,\n\u0005]\u0013!\u0001\u0005+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u0001")
public class TransactionMetadataTest {
    private final MockTime time = new MockTime();

    public MockTime time() {
        return this.time;
    }

    @Test
    public void testInitializeEpoch() {
        String transactionalId = "txnlId";
        long producerId = 23423L;
        short producerEpoch = -1;
        String x$1 = transactionalId;
        long x$2 = producerId;
        short x$3 = producerEpoch;
        int x$4 = 30000;
        Empty$ x$5 = Empty$.MODULE$;
        Set x$6 = Set$.MODULE$.empty();
        long x$7 = this.time().milliseconds();
        long x$8 = TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, x$4, (TransactionState)x$5, x$6, x$8, x$7);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareIncrementProducerEpoch(30000, this.time().milliseconds());
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)producerId, (long)txnMetadata.producerId());
        Assert.assertEquals((long)0L, (long)txnMetadata.producerEpoch());
    }

    @Test
    public void testNormalEpochBump() {
        String transactionalId = "txnlId";
        long producerId = 23423L;
        short producerEpoch = (short)735;
        String x$9 = transactionalId;
        long x$10 = producerId;
        short x$11 = producerEpoch;
        int x$12 = 30000;
        Empty$ x$13 = Empty$.MODULE$;
        Set x$14 = Set$.MODULE$.empty();
        long x$15 = this.time().milliseconds();
        long x$16 = TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$9, x$10, x$11, x$12, (TransactionState)x$13, x$14, x$16, x$15);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareIncrementProducerEpoch(30000, this.time().milliseconds());
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)producerId, (long)txnMetadata.producerId());
        Assert.assertEquals((long)(producerEpoch + 1), (long)txnMetadata.producerEpoch());
    }

    @Test(expected=IllegalStateException.class)
    public void testBumpEpochNotAllowedIfEpochsExhausted() {
        String transactionalId = "txnlId";
        long producerId = 23423L;
        short producerEpoch = (short)32766;
        String x$17 = transactionalId;
        long x$18 = producerId;
        short x$19 = producerEpoch;
        int x$20 = 30000;
        Empty$ x$21 = Empty$.MODULE$;
        Set x$22 = Set$.MODULE$.empty();
        long x$23 = this.time().milliseconds();
        long x$24 = TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$17, x$18, x$19, x$20, (TransactionState)x$21, x$22, x$24, x$23);
        Assert.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        txnMetadata.prepareIncrementProducerEpoch(30000, this.time().milliseconds());
    }

    @Test
    public void testFenceProducerAfterEpochsExhausted() {
        String transactionalId = "txnlId";
        long producerId = 23423L;
        short producerEpoch = (short)32766;
        String x$25 = transactionalId;
        long x$26 = producerId;
        short x$27 = producerEpoch;
        int x$28 = 30000;
        Ongoing$ x$29 = Ongoing$.MODULE$;
        Set x$30 = Set$.MODULE$.empty();
        long x$31 = this.time().milliseconds();
        long x$32 = TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$25, x$26, x$27, x$28, (TransactionState)x$29, x$30, x$32, x$31);
        Assert.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        txnMetadata.prepareFenceProducerEpoch();
        Assert.assertEquals((long)32767L, (long)txnMetadata.producerEpoch());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, this.time().milliseconds());
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)producerId, (long)transitMetadata.producerId());
    }

    @Test(expected=IllegalStateException.class)
    public void testFenceProducerNotAllowedIfItWouldOverflow() {
        String transactionalId = "txnlId";
        long producerId = 23423L;
        short producerEpoch = Short.MAX_VALUE;
        String x$33 = transactionalId;
        long x$34 = producerId;
        short x$35 = producerEpoch;
        int x$36 = 30000;
        Ongoing$ x$37 = Ongoing$.MODULE$;
        Set x$38 = Set$.MODULE$.empty();
        long x$39 = this.time().milliseconds();
        long x$40 = TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$33, x$34, x$35, x$36, (TransactionState)x$37, x$38, x$40, x$39);
        Assert.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        txnMetadata.prepareFenceProducerEpoch();
    }

    @Test
    public void testRotateProducerId() {
        String transactionalId = "txnlId";
        long producerId = 23423L;
        short producerEpoch = (short)32766;
        String x$41 = transactionalId;
        long x$42 = producerId;
        short x$43 = producerEpoch;
        int x$44 = 30000;
        Empty$ x$45 = Empty$.MODULE$;
        Set x$46 = Set$.MODULE$.empty();
        long x$47 = this.time().milliseconds();
        long x$48 = TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$41, x$42, x$43, x$44, (TransactionState)x$45, x$46, x$48, x$47);
        long newProducerId = 9893L;
        TxnTransitMetadata transitMetadata = txnMetadata.prepareProducerIdRotation(newProducerId, 30000, this.time().milliseconds());
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)newProducerId, (long)txnMetadata.producerId());
        Assert.assertEquals((long)0L, (long)txnMetadata.producerEpoch());
    }

    @Test(expected=IllegalStateException.class)
    public void testRotateProducerIdInOngoingState() {
        this.testRotateProducerIdInOngoingState((TransactionState)Ongoing$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testRotateProducerIdInPrepareAbortState() {
        this.testRotateProducerIdInOngoingState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testRotateProducerIdInPrepareCommitState() {
        this.testRotateProducerIdInOngoingState((TransactionState)PrepareCommit$.MODULE$);
    }

    private void testRotateProducerIdInOngoingState(TransactionState state) {
        String transactionalId = "txnlId";
        long producerId = 23423L;
        short producerEpoch = (short)32766;
        String x$49 = transactionalId;
        long x$50 = producerId;
        short x$51 = producerEpoch;
        int x$52 = 30000;
        TransactionState x$53 = state;
        Set x$54 = Set$.MODULE$.empty();
        long x$55 = this.time().milliseconds();
        long x$56 = TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$49, x$50, x$51, x$52, x$53, x$54, x$56, x$55);
        long newProducerId = 9893L;
        txnMetadata.prepareProducerIdRotation(newProducerId, 30000, this.time().milliseconds());
    }
}

