/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import java.io.File;
import java.util.List;
import javax.security.auth.login.Configuration;
import kafka.admin.ZkSecurityMigrator$;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.zookeeper.data.ACL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001B\u0001\u0003\u0001%\u00111CW6BkRDwN]5{CRLwN\u001c+fgRT!a\u0001\u0003\u0002\t\u0005,H\u000f\u001b\u0006\u0003\u000b\u0019\t\u0001b]3dkJLG/\u001f\u0006\u0002\u000f\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u000b!A\u00111BD\u0007\u0002\u0019)\u0011QBB\u0001\u0003u.L!a\u0004\u0007\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\t\tB#D\u0001\u0013\u0015\t\u0019b!A\u0003vi&d7/\u0003\u0002\u0016%\t9Aj\\4hS:<\u0007\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\tQ\u0002!D\u0001\u0003\u0011\u001da\u0002A1A\u0005\u0002u\t\u0001B[1bg\u001aKG.Z\u000b\u0002=A\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\u0003S>T\u0011aI\u0001\u0005U\u00064\u0018-\u0003\u0002&A\t!a)\u001b7f\u0011\u00199\u0003\u0001)A\u0005=\u0005I!.Y1t\r&dW\r\t\u0005\bS\u0001\u0011\r\u0011\"\u0001+\u00031\tW\u000f\u001e5Qe>4\u0018\u000eZ3s+\u0005Y\u0003C\u0001\u00170\u001b\u0005i#B\u0001\u0018#\u0003\u0011a\u0017M\\4\n\u0005Aj#AB*ue&tw\r\u0003\u00043\u0001\u0001\u0006IaK\u0001\u000eCV$\b\u000e\u0015:pm&$WM\u001d\u0011\t\u000bQ\u0002A\u0011I\u001b\u0002\u000bM,G/\u00169\u0015\u0003Y\u0002\"a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u0012A!\u00168ji\"\u00121'\u0010\t\u0003}\rk\u0011a\u0010\u0006\u0003\u0001\u0006\u000bQA[;oSRT\u0011AQ\u0001\u0004_J<\u0017B\u0001#@\u0005\u0019\u0011UMZ8sK\")a\t\u0001C!k\u0005AA/Z1s\t><h\u000e\u000b\u0002F\u0011B\u0011a(S\u0005\u0003\u0015~\u0012Q!\u00114uKJDQ\u0001\u0014\u0001\u0005\u0002U\nq\u0003^3ti&\u001b(l[*fGV\u0014\u0018\u000e^=F]\u0006\u0014G.\u001a3)\u0005-s\u0005C\u0001 P\u0013\t\u0001vH\u0001\u0003UKN$\b\"\u0002*\u0001\t\u0003)\u0014a\u0003;fgRT6.\u0016;jYND#!\u0015(\t\u000bU\u0003A\u0011A\u001b\u0002\u001fQ,7\u000f\u001e.l\u001b&<'/\u0019;j_:D#\u0001\u0016(\t\u000ba\u0003A\u0011A\u001b\u0002'Q,7\u000f\u001e.l\u0003:$\u0018.T5he\u0006$\u0018n\u001c8)\u0005]s\u0005\"B.\u0001\t\u0003)\u0014A\u0003;fgR$U\r\\3uK\"\u0012!L\u0014\u0005\u0006=\u0002!\t!N\u0001\u0014i\u0016\u001cH\u000fR3mKR,'+Z2veNLg/\u001a\u0015\u0003;:CQ!\u0019\u0001\u0005\u0002\t\f!\u0002^3ti\u000eC'o\\8u+\u00051\u0004F\u00011O\u0011\u0015)\u0007\u0001\"\u0003g\u00035!Xm\u001d;NS\u001e\u0014\u0018\r^5p]R!agZ8u\u0011\u0015AG\r1\u0001j\u0003\u0015Q8.\u0016:m!\tQWN\u0004\u00028W&\u0011A\u000eO\u0001\u0007!J,G-\u001a4\n\u0005Ar'B\u000179\u0011\u0015\u0001H\r1\u0001r\u0003\u001d1\u0017N]:u5.\u0004\"!\u0005:\n\u0005M\u0014\"a\u0002.l+RLGn\u001d\u0005\u0006k\u0012\u0004\r!]\u0001\tg\u0016\u001cwN\u001c3[W\")q\u000f\u0001C\u0005q\u00061a/\u001a:jMf$\"!\u001f?\u0011\u0005]R\u0018BA>9\u0005\u001d\u0011un\u001c7fC:DQ! <A\u0002%\fA\u0001]1uQ\"1q\u0010\u0001C\u0005\u0003\u0003\tA\"[:BG2\u001cuN\u001d:fGR$r!_A\u0002\u0003O\tY\u0003C\u0004\u0002\u0006y\u0004\r!a\u0002\u0002\t1L7\u000f\u001e\t\u0007\u0003\u0013\ty!a\u0005\u000e\u0005\u0005-!bAA\u0007E\u0005!Q\u000f^5m\u0013\u0011\t\t\"a\u0003\u0003\t1K7\u000f\u001e\t\u0005\u0003+\t\u0019#\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003\u0011!\u0017\r^1\u000b\t\u0005u\u0011qD\u0001\nu>|7.Z3qKJT1!!\tB\u0003\u0019\t\u0007/Y2iK&!\u0011QEA\f\u0005\r\t5\t\u0014\u0005\u0007\u0003Sq\b\u0019A=\u0002\rM,7-\u001e:f\u0011\u0019\tiC a\u0001s\u0006I1/\u001a8tSRLg/\u001a\u0005\u0007\u0003c\u0001A\u0011B\u001b\u0002#\u0011,G.\u001a;f\u00032dWK\\:fGV\u0014X\rC\u0004\u00026\u0001!I!a\u000e\u0002\u001f\u0011,G.\u001a;f%\u0016\u001cWO]:jm\u0016$b!!\u000f\u0002D\u0005\u001d\u0003#BA\u001e\u0003\u007fIXBAA\u001f\u0015\r\ti\u0001O\u0005\u0005\u0003\u0003\niDA\u0002UefDq!!\u0012\u00024\u0001\u0007\u0011/A\u0004{WV#\u0018\u000e\\:\t\ru\f\u0019\u00041\u0001j\u0001")
public class ZkAuthorizationTest
extends ZooKeeperTestHarness {
    private final File jaasFile = JaasTestUtils$.MODULE$.writeJaasContextsToFile(JaasTestUtils$.MODULE$.zkSections());
    private final String authProvider;

    public File jaasFile() {
        return this.jaasFile;
    }

    public String authProvider() {
        return this.authProvider;
    }

    @Override
    @Before
    public void setUp() {
        System.setProperty("java.security.auth.login.config", this.jaasFile().getAbsolutePath());
        Configuration.setConfiguration(null);
        System.setProperty(this.authProvider(), "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        System.clearProperty("java.security.auth.login.config");
        System.clearProperty(this.authProvider());
        Configuration.setConfiguration(null);
    }

    @Test
    public void testIsZkSecurityEnabled() {
        Assert.assertTrue((boolean)JaasUtils.isZkSecurityEnabled());
        Configuration.setConfiguration(null);
        System.clearProperty("java.security.auth.login.config");
        Assert.assertFalse((boolean)JaasUtils.isZkSecurityEnabled());
        try {
            Configuration.setConfiguration(null);
            System.setProperty("java.security.auth.login.config", "no-such-file-exists.conf");
            JaasUtils.isZkSecurityEnabled();
            throw this.fail("Should have thrown an exception", new Position("ZkAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        }
        catch (KafkaException kafkaException) {
            return;
        }
    }

    @Test
    public void testZkUtils() {
        Assert.assertTrue((boolean)this.zkUtils().isSecure());
        this.zkUtils().persistentZkPaths().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkAuthorizationTest $outer;

            public final void apply(String path) {
                ZkUtils qual$1 = this.$outer.zkUtils();
                String x$3 = path;
                List x$4 = qual$1.makeSurePersistentPathExists$default$2();
                qual$1.makeSurePersistentPathExists(x$3, x$4);
                if (!path.equals(ZkUtils$.MODULE$.ConsumersPath())) {
                    List aclList = (List)this.$outer.zkUtils().zkConnection().getAcl(path).getKey();
                    Assert.assertTrue((aclList.size() == 2 ? 1 : 0) != 0);
                    ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(aclList).asScala()).withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(ACL check$ifrefutable$1) {
                            ACL aCL = check$ifrefutable$1;
                            boolean bl = aCL != null;
                            return bl;
                        }
                    }).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ACL acl) {
                            Assert.assertTrue((boolean)TestUtils$.MODULE$.isAclSecure(acl, false));
                        }
                    });
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ZkUtils qual$2 = this.zkUtils();
        String x$5 = "/a";
        String x$6 = "";
        List x$7 = qual$2.createEphemeralPathExpectConflict$default$3();
        qual$2.createEphemeralPathExpectConflict(x$5, x$6, x$7);
        this.verify("/a");
        ZkUtils qual$3 = this.zkUtils();
        String x$8 = "/b";
        String x$9 = qual$3.createPersistentPath$default$2();
        List x$10 = qual$3.createPersistentPath$default$3();
        qual$3.createPersistentPath(x$8, x$9, x$10);
        this.verify("/b");
        ZkUtils qual$4 = this.zkUtils();
        String x$11 = "/c";
        String x$12 = "";
        List x$13 = qual$4.createSequentialPersistentPath$default$3();
        String seqPath = qual$4.createSequentialPersistentPath(x$11, x$12, x$13);
        this.verify(seqPath);
        ZkUtils qual$5 = this.zkUtils();
        String x$14 = "/a";
        String x$15 = "updated";
        List x$16 = qual$5.updateEphemeralPath$default$3();
        qual$5.updateEphemeralPath(x$14, x$15, x$16);
        String valueA = (String)this.zkUtils().zkClient().readData("/a");
        Assert.assertTrue((boolean)valueA.equals("updated"));
        ZkUtils qual$6 = this.zkUtils();
        String x$17 = "/b";
        String x$18 = "updated";
        List x$19 = qual$6.updatePersistentPath$default$3();
        qual$6.updatePersistentPath(x$17, x$18, x$19);
        String valueB = (String)this.zkUtils().zkClient().readData("/b");
        Assert.assertTrue((boolean)valueB.equals("updated"));
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Leaving testZkUtils";
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkMigration() {
        ZkUtils unsecureZkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), 6000, 6000, false);
        try {
            this.testMigration(this.zkConnect(), unsecureZkUtils, this.zkUtils());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        unsecureZkUtils.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkAntiMigration() {
        ZkUtils unsecureZkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), 6000, 6000, false);
        try {
            this.testMigration(this.zkConnect(), this.zkUtils(), unsecureZkUtils);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        unsecureZkUtils.close();
    }

    @Test
    public void testDelete() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkAuthorizationTest $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zkConnect string: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.zkConnect()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ZkSecurityMigrator$.MODULE$.run((String[])((Object[])new String[]{"--zookeeper.acl=secure", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()}))}));
        this.deleteAllUnsecure();
    }

    @Test
    public void testDeleteRecursive() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkAuthorizationTest $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zkConnect string: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.zkConnect()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ZkUtils$.MODULE$.SecureZkRootPaths().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkAuthorizationTest $outer;

            public final void apply(String path) {
                this.$outer.info((Function0<String>)new Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final String path$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$2}));
                    }
                    {
                        this.path$2 = path$2;
                    }
                });
                ZkUtils qual$7 = this.$outer.zkUtils();
                String x$20 = path;
                List x$21 = qual$7.makeSurePersistentPathExists$default$2();
                qual$7.makeSurePersistentPathExists(x$20, x$21);
                ZkUtils qual$8 = this.$outer.zkUtils();
                String x$22 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/fpjwashere"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}));
                String x$23 = "";
                List x$24 = qual$8.createPersistentPath$default$3();
                qual$8.createPersistentPath(x$22, x$23, x$24);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.zkUtils().zkConnection().setAcl("/", this.zkUtils().defaultAcls("/"), -1);
        this.deleteAllUnsecure();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testChroot() {
        String zkUrl = new StringBuilder().append((Object)this.zkConnect()).append((Object)"/kafka").toString();
        ZkUtils qual$9 = this.zkUtils();
        String x$25 = "/kafka";
        String x$26 = qual$9.createPersistentPath$default$2();
        List x$27 = qual$9.createPersistentPath$default$3();
        qual$9.createPersistentPath(x$25, x$26, x$27);
        ZkUtils unsecureZkUtils = ZkUtils$.MODULE$.apply(zkUrl, 6000, 6000, false);
        ZkUtils secureZkUtils = ZkUtils$.MODULE$.apply(zkUrl, 6000, 6000, true);
        try {
            this.testMigration(zkUrl, unsecureZkUtils, secureZkUtils);
        }
        catch (Throwable throwable) {
            void var7_7;
            void var6_6;
            var6_6.close();
            var7_7.close();
            throw throwable;
        }
        unsecureZkUtils.close();
        secureZkUtils.close();
    }

    private void testMigration(String zkUrl, ZkUtils firstZk, ZkUtils secondZk) {
        String string;
        this.info((Function0<String>)new Serializable(this, zkUrl){
            public static final long serialVersionUID = 0L;
            private final String zkUrl$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zkConnect string: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkUrl$1}));
            }
            {
                this.zkUrl$1 = zkUrl$1;
            }
        });
        ((IterableLike)ZkUtils$.MODULE$.SecureZkRootPaths().$plus$plus((GenTraversableOnce)ZkUtils$.MODULE$.SensitiveZkRootPaths(), Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, firstZk){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkAuthorizationTest $outer;
            private final ZkUtils firstZk$1;

            public final void apply(String path) {
                this.$outer.info((Function0<String>)new Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final String path$3;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$3}));
                    }
                    {
                        this.path$3 = path$3;
                    }
                });
                this.firstZk$1.makeSurePersistentPathExists(path, this.firstZk$1.makeSurePersistentPathExists$default$2());
                this.firstZk$1.createPersistentPath(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/fpjwashere"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), "", this.firstZk$1.createPersistentPath$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.firstZk$1 = firstZk$1;
            }
        });
        if (secondZk.isSecure()) {
            firstZk.createPersistentPath(ZkUtils$.MODULE$.ConsumersPath(), firstZk.createPersistentPath$default$2(), firstZk.createPersistentPath$default$3());
            string = "secure";
        } else {
            secondZk.createPersistentPath(ZkUtils$.MODULE$.ConsumersPath(), secondZk.createPersistentPath$default$2(), secondZk.createPersistentPath$default$3());
            string = "unsecure";
        }
        String secureOpt = string;
        ZkSecurityMigrator$.MODULE$.run((String[])((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--zookeeper.acl=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{secureOpt})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{zkUrl}))}));
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Done with migration";
            }
        });
        ((IterableLike)ZkUtils$.MODULE$.SecureZkRootPaths().$plus$plus((GenTraversableOnce)ZkUtils$.MODULE$.SensitiveZkRootPaths(), Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, secondZk){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkAuthorizationTest $outer;
            private final ZkUtils secondZk$1;

            public final void apply(String path) {
                boolean sensitive = ZkUtils$.MODULE$.sensitivePath(path);
                List listParent = (List)this.secondZk$1.zkConnection().getAcl(path).getKey();
                Assert.assertTrue((String)path, (boolean)this.$outer.kafka$security$auth$ZkAuthorizationTest$$isAclCorrect(listParent, this.secondZk$1.isSecure(), sensitive));
                String childPath = new StringBuilder().append((Object)path).append((Object)"/fpjwashere").toString();
                List listChild = (List)this.secondZk$1.zkConnection().getAcl(childPath).getKey();
                Assert.assertTrue((String)childPath, (boolean)this.$outer.kafka$security$auth$ZkAuthorizationTest$$isAclCorrect(listChild, this.secondZk$1.isSecure(), sensitive));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.secondZk$1 = secondZk$1;
            }
        });
        List consumersAcl = (List)firstZk.zkConnection().getAcl(ZkUtils$.MODULE$.ConsumersPath()).getKey();
        Assert.assertTrue((String)ZkUtils$.MODULE$.ConsumersPath(), (boolean)this.kafka$security$auth$ZkAuthorizationTest$$isAclCorrect(consumersAcl, false, false));
    }

    private boolean verify(String path) {
        boolean sensitive = ZkUtils$.MODULE$.sensitivePath(path);
        List list = (List)this.zkUtils().zkConnection().getAcl(path).getKey();
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).forall((Function1)new Serializable(this, sensitive){
            public static final long serialVersionUID = 0L;
            private final boolean sensitive$2;

            public final boolean apply(ACL x$1) {
                return TestUtils$.MODULE$.isAclSecure(x$1, this.sensitive$2);
            }
            {
                this.sensitive$2 = sensitive$2;
            }
        });
    }

    public boolean kafka$security$auth$ZkAuthorizationTest$$isAclCorrect(List<ACL> list, boolean secure, boolean sensitive) {
        boolean isListSizeCorrect;
        boolean bl = secure && !sensitive ? list.size() == 2 : (isListSizeCorrect = list.size() == 1);
        return isListSizeCorrect && ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).forall((Function1)(secure ? new Serializable(this, sensitive){
            public static final long serialVersionUID = 0L;
            private final boolean sensitive$1;

            public final boolean apply(ACL x$2) {
                return TestUtils$.MODULE$.isAclSecure(x$2, this.sensitive$1);
            }
            {
                this.sensitive$1 = sensitive$1;
            }
        } : new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ACL acl) {
                return TestUtils$.MODULE$.isAclUnsecure(acl);
            }
        }));
    }

    private void deleteAllUnsecure() {
        System.setProperty("zookeeper.sasl.client", "false");
        ZkUtils unsecureZkUtils = ZkUtils$.MODULE$.apply(this.zkConnect(), 6000, 6000, false);
        Try<Object> result = this.kafka$security$auth$ZkAuthorizationTest$$deleteRecursive(unsecureZkUtils, "/");
        unsecureZkUtils.close();
        System.clearProperty("zookeeper.sasl.client");
        Try<Object> try_ = result;
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            throw this.fail(e.getMessage(), new Position("ZkAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        }
        throw new MatchError(try_);
    }

    public Try<Object> kafka$security$auth$ZkAuthorizationTest$$deleteRecursive(ZkUtils zkUtils, String path) {
        Try try_;
        this.info((Function0<String>)new Serializable(this, path){
            public static final long serialVersionUID = 0L;
            private final String path$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
            }
            {
                this.path$1 = path$1;
            }
        });
        ObjectRef result = ObjectRef.create((Object)new Success((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        zkUtils.getChildren(path).foreach((Function1)new Serializable(this, zkUtils, path, result){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZkAuthorizationTest $outer;
            private final ZkUtils zkUtils$1;
            private final String path$1;
            private final ObjectRef result$1;

            public final void apply(String child) {
                Try<Object> try_;
                block4: {
                    Try try_2;
                    block3: {
                        block2: {
                            String string = this.path$1;
                            Try<Object> try_3 = "/".equals(string) ? this.$outer.kafka$security$auth$ZkAuthorizationTest$$deleteRecursive(this.zkUtils$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{child}))) : this.$outer.kafka$security$auth$ZkAuthorizationTest$$deleteRecursive(this.zkUtils$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, child})));
                            try_ = try_3;
                            if (!(try_ instanceof Success)) break block2;
                            try_2 = (Try)this.result$1.elem;
                            break block3;
                        }
                        if (!(try_ instanceof Failure)) break block4;
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        try_2 = new Failure(e);
                    }
                    this.result$1.elem = try_2;
                    return;
                }
                throw new MatchError(try_);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.zkUtils$1 = zkUtils$1;
                this.path$1 = path$1;
                this.result$1 = result$1;
            }
        });
        String string = path;
        if ("/".equals(string)) {
            try_ = (Try)result.elem;
        } else {
            Try try_2;
            try {
                zkUtils.deletePath(string);
                try_2 = new Failure((Throwable)new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Have been able to delete ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string}))));
            }
            catch (Exception exception) {
                try_2 = (Try)result.elem;
            }
            try_ = try_2;
        }
        return try_;
    }

    public ZkAuthorizationTest() {
        this.authProvider = "zookeeper.authProvider.1";
    }
}

