/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientSensors;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaEntity;
import kafka.server.QuotaId;
import kafka.server.QuotaId$;
import kafka.server.QuotaType;
import kafka.server.QuotaTypes$;
import kafka.server.SensorAccess;
import kafka.server.ThrottledResponse;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.Total;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichDouble$;
import scala.runtime.RichLong$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t}d\u0001B\u0001\u0003\u0001\u001d\u0011!c\u00117jK:$\u0018+^8uC6\u000bg.Y4fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011U\u0001!Q1A\u0005\nY\taaY8oM&<W#A\f\u0011\u0005aIR\"\u0001\u0002\n\u0005i\u0011!\u0001G\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\u001cuN\u001c4jO\"AA\u0004\u0001B\u0001B\u0003%q#A\u0004d_:4\u0017n\u001a\u0011\t\u0011y\u0001!Q1A\u0005\n}\tq!\\3ue&\u001c7/F\u0001!!\t\t#&D\u0001#\u0015\tq2E\u0003\u0002%K\u000511m\\7n_:T!!\u0002\u0014\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0005\u0003W\t\u0012q!T3ue&\u001c7\u000f\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003!\u0003!iW\r\u001e:jGN\u0004\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011\u0002\u0019\u0002\u0013E,x\u000e^1UsB,W#A\u0019\u0011\u0005a\u0011\u0014BA\u001a\u0003\u0005%\tVo\u001c;b)f\u0004X\r\u0003\u00056\u0001\t\u0005\t\u0015!\u00032\u0003)\tXo\u001c;b)f\u0004X\r\t\u0005\to\u0001\u0011)\u0019!C\u0005q\u0005!A/[7f+\u0005I\u0004C\u0001\u001e=\u001b\u0005Y$BA\t$\u0013\ti4H\u0001\u0003US6,\u0007\u0002C \u0001\u0005\u0003\u0005\u000b\u0011B\u001d\u0002\u000bQLW.\u001a\u0011\t\u000b\u0005\u0003A\u0011\u0001\"\u0002\rqJg.\u001b;?)\u0015\u0019E)\u0012$H!\tA\u0002\u0001C\u0003\u0016\u0001\u0002\u0007q\u0003C\u0003\u001f\u0001\u0002\u0007\u0001\u0005C\u00030\u0001\u0002\u0007\u0011\u0007C\u00038\u0001\u0002\u0007\u0011\bC\u0004J\u0001\t\u0007I\u0011\u0002&\u0002\u001f=4XM\u001d:jI\u0012,g.U;pi\u0006,\u0012a\u0013\t\u0005\u0019N+\u0006,D\u0001N\u0015\tqu*\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001U)\u0002\tU$\u0018\u000e\u001c\u0006\u0002%\u0006!!.\u0019<b\u0013\t!VJA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004\"\u0001\u0007,\n\u0005]\u0013!aB)v_R\f\u0017\n\u001a\t\u0003CeK!A\u0017\u0012\u0003\u000bE+x\u000e^1\t\rq\u0003\u0001\u0015!\u0003L\u0003Ayg/\u001a:sS\u0012$WM\\)v_R\f\u0007\u0005C\u0004_\u0001\t\u0007I\u0011B0\u00023M$\u0018\r^5d\u0007>tg-[4DY&,g\u000e^%e#V|G/Y\u000b\u00021\"1\u0011\r\u0001Q\u0001\na\u000b!d\u001d;bi&\u001c7i\u001c8gS\u001e\u001cE.[3oi&#\u0017+^8uC\u0002Bqa\u0019\u0001A\u0002\u0013%A-A\trk>$\u0018\rV=qKN,e.\u00192mK\u0012,\u0012!\u001a\t\u0003\u0013\u0019L!a\u001a\u0006\u0003\u0007%sG\u000fC\u0004j\u0001\u0001\u0007I\u0011\u00026\u0002+E,x\u000e^1UsB,7/\u00128bE2,Gm\u0018\u0013fcR\u00111N\u001c\t\u0003\u00131L!!\u001c\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b_\"\f\t\u00111\u0001f\u0003\rAH%\r\u0005\u0007c\u0002\u0001\u000b\u0015B3\u0002%E,x\u000e^1UsB,7/\u00128bE2,G\r\t\u0005\bg\u0002\u0011\r\u0011\"\u0003u\u0003\u0011awnY6\u0016\u0003U\u0004\"A^=\u000e\u0003]T!\u0001_'\u0002\u000b1|7m[:\n\u0005i<(A\u0006*fK:$(/\u00198u%\u0016\fGm\u0016:ji\u0016dunY6\t\rq\u0004\u0001\u0015!\u0003v\u0003\u0015awnY6!\u0011\u001dq\bA1A\u0005\n}\f!\u0002Z3mCf\fV/Z;f+\t\t\t\u0001E\u0003M\u0003\u0007\t9!C\u0002\u0002\u00065\u0013!\u0002R3mCf\fV/Z;f!\rA\u0012\u0011B\u0005\u0004\u0003\u0017\u0011!!\u0005+ie>$H\u000f\\3e%\u0016\u001c\bo\u001c8tK\"A\u0011q\u0002\u0001!\u0002\u0013\t\t!A\u0006eK2\f\u00170U;fk\u0016\u0004\u0003\"CA\n\u0001\t\u0007I\u0011BA\u000b\u00039\u0019XM\\:pe\u0006\u001b7-Z:t_J,\"!a\u0006\u0011\u0007a\tI\"C\u0002\u0002\u001c\t\u0011AbU3og>\u0014\u0018iY2fgND\u0001\"a\b\u0001A\u0003%\u0011qC\u0001\u0010g\u0016t7o\u001c:BG\u000e,7o]8sA!I\u00111\u0005\u0001C\u0002\u0013\u0005\u0011QE\u0001\u0017i\"\u0014x\u000e\u001e;mK\u0012\u0014V-];fgR\u0014V-\u00199feV\u0011\u0011q\u0005\t\u0005\u0003S\tY#D\u0001\u0001\r\u0019\ti\u0003\u0001\u0001\u00020\t1B\u000b\u001b:piRdW\r\u001a*fcV,7\u000f\u001e*fCB,'o\u0005\u0003\u0002,\u0005E\u0002cA\b\u00024%\u0019\u0011Q\u0007\t\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0005\u000b}\u0006-\"\u0011!Q\u0001\n\u0005\u0005\u0001bB!\u0002,\u0011\u0005\u00111\b\u000b\u0005\u0003O\ti\u0004C\u0004\u007f\u0003s\u0001\r!!\u0001\t\u0011\u0005\u0005\u00131\u0006C!\u0003\u0007\na\u0001Z8X_J\\G#A6\t\u0011\u0005\u001d\u0003\u0001)A\u0005\u0003O\tq\u0003\u001e5s_R$H.\u001a3SKF,Xm\u001d;SK\u0006\u0004XM\u001d\u0011\t\u0013\u0005-\u0003A1A\u0005\n\u00055\u0013\u0001\u00053fY\u0006L\u0018+^3vKN+gn]8s+\t\ty\u0005E\u0002\"\u0003#J1!a\u0015#\u0005\u0019\u0019VM\\:pe\"A\u0011q\u000b\u0001!\u0002\u0013\ty%A\teK2\f\u00170U;fk\u0016\u001cVM\\:pe\u0002Bq!a\u0017\u0001\t\u0013\t\u0019%A\u0003ti\u0006\u0014H\u000fC\u0004\u0002`\u0001!\t!!\u0019\u0002-I,7m\u001c:e\u0003:$W*Y=cKRC'o\u001c;uY\u0016$\u0012\"ZA2\u0003k\nI(a!\t\u0011\u0005\u0015\u0014Q\fa\u0001\u0003O\nQb]1oSRL'0\u001a3Vg\u0016\u0014\b\u0003BA5\u0003_r1!CA6\u0013\r\tiGC\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00141\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055$\u0002\u0003\u0005\u0002x\u0005u\u0003\u0019AA4\u0003!\u0019G.[3oi&#\u0007\u0002CA>\u0003;\u0002\r!! \u0002\u000bY\fG.^3\u0011\u0007%\ty(C\u0002\u0002\u0002*\u0011a\u0001R8vE2,\u0007\u0002CAC\u0003;\u0002\r!a\"\u0002\u0011\r\fG\u000e\u001c2bG.\u0004R!CAEK.L1!a#\u000b\u0005%1UO\\2uS>t\u0017\u0007C\u0004\u0002\u0010\u0002!\t!!%\u0002CI,7m\u001c:e\u0003:$G\u000b\u001b:piRdWm\u00148Rk>$\u0018MV5pY\u0006$\u0018n\u001c8\u0015\u000f\u0015\f\u0019*!(\u0002 \"A\u0011QSAG\u0001\u0004\t9*A\u0007dY&,g\u000e^*f]N|'o\u001d\t\u00041\u0005e\u0015bAAN\u0005\ti1\t\\5f]R\u001cVM\\:peND\u0001\"a\u001f\u0002\u000e\u0002\u0007\u0011Q\u0010\u0005\t\u0003\u000b\u000bi\t1\u0001\u0002\b\"9\u00111\u0015\u0001\u0005\u0002\u0005\u0015\u0016\u0001\u0005:fG>\u0014HMT8UQJ|G\u000f\u001e7f)\u0015Y\u0017qUAU\u0011!\t)*!)A\u0002\u0005]\u0005\u0002CA>\u0003C\u0003\r!! \t\u000f\u00055\u0006\u0001\"\u0003\u00020\u0006Y\u0011/^8uC\u0016sG/\u001b;z)\u0019\t\t,a.\u0002:B\u0019\u0001$a-\n\u0007\u0005U&AA\u0006Rk>$\u0018-\u00128uSRL\b\u0002CA3\u0003W\u0003\r!a\u001a\t\u0011\u0005]\u00141\u0016a\u0001\u0003OBq!!0\u0001\t\u0013\ty,\u0001\u0012rk>$\u0018-\u00128uSRLx+\u001b;i\u001bVdG/\u001b9mKF+x\u000e^1MKZ,Gn\u001d\u000b\u0007\u0003c\u000b\t-a1\t\u0011\u0005\u0015\u00141\u0018a\u0001\u0003OB\u0001\"a\u001e\u0002<\u0002\u0007\u0011q\r\u0005\b\u0003\u000f\u0004A\u0011AAe\u0003\u0015\tXo\u001c;b)\u0015A\u00161ZAh\u0011!\ti-!2A\u0002\u0005\u001d\u0014\u0001B;tKJD\u0001\"a\u001e\u0002F\u0002\u0007\u0011q\r\u0005\b\u0003'\u0004A\u0011CAk\u00031!\bN]8ui2,G+[7f)\u0019\t9.!8\u0002hB\u0019\u0011\"!7\n\u0007\u0005m'B\u0001\u0003M_:<\u0007\u0002CAp\u0003#\u0004\r!!9\u0002\u0019\rd\u0017.\u001a8u\u001b\u0016$(/[2\u0011\u0007\u0005\n\u0019/C\u0002\u0002f\n\u00121bS1gW\u0006lU\r\u001e:jG\"9Q#!5A\u0002\u0005%\bcA\u0011\u0002l&\u0019\u0011Q\u001e\u0012\u0003\u00195+GO]5d\u0007>tg-[4\t\u000f\u0005E\b\u0001\"\u0003\u0002t\u0006\u0001R.Z1tkJ\f'\r\\3BgJ\u000bG/\u001a\u000b\u0007\u0003k\u0014\tA!\u0004\u0011\t\u0005]\u0018Q`\u0007\u0003\u0003sT1!a?#\u0003\u0015\u0019H/\u0019;t\u0013\u0011\ty0!?\u0003\tI\u000bG/\u001a\u0005\t\u0005\u0007\ty\u000f1\u0001\u0003\u0006\u0005!a.Y7f!\u0011\u00119A!\u0003\u000e\u0003\rJ1Aa\u0003$\u0005)iU\r\u001e:jG:\u000bW.\u001a\u0005\t\u0005\u001f\ty\u000f1\u0001\u0003\u0012\u0005QQ.Z1tkJ\f'\r\\3\u0011\u0007\u0005\u0012\u0019\"C\u0002\u0003\u0016\t\u0012!\"T3bgV\u0014\u0018M\u00197f\u0011\u001d\u0011I\u0002\u0001C\u0001\u00057\tqcZ3u\u001fJ\u001c%/Z1uKF+x\u000e^1TK:\u001cxN]:\u0015\r\u0005]%Q\u0004B\u0010\u0011!\t)Ga\u0006A\u0002\u0005\u001d\u0004\u0002CA<\u0005/\u0001\r!a\u001a\t\u000f\t\r\u0002\u0001\"\u0003\u0003&\u0005qQ.Z1tkJ\f'\r\\3Ti\u0006$XC\u0001B\u0014!\r\t#\u0011F\u0005\u0004\u0005W\u0011#AD'fCN,(/\u00192mKN#\u0018\r\u001e\u0005\b\u0005_\u0001A\u0011\u0002B\u0019\u0003e9W\r\u001e+ie>$H\u000f\\3US6,7+\u001a8t_Jt\u0015-\\3\u0015\t\u0005\u001d$1\u0007\u0005\b\u0005k\u0011i\u00031\u0001V\u0003\u001d\tXo\u001c;b\u0013\u0012DqA!\u000f\u0001\t\u0013\u0011Y$\u0001\nhKR\fVo\u001c;b'\u0016t7o\u001c:OC6,G\u0003BA4\u0005{AqA!\u000e\u00038\u0001\u0007Q\u000bC\u0004\u0003B\u0001!\tBa\u0011\u0002)\u001d,G/U;pi\u0006lU\r\u001e:jG\u000e{gNZ5h)\u0011\tIO!\u0012\t\u000f\u0005\u001d'q\ba\u00011\"9!\u0011\n\u0001\u0005\u0012\t-\u0013\u0001D2sK\u0006$XmU3og>\u0014HCBA(\u0005\u001b\u0012\t\u0006\u0003\u0005\u0003P\t\u001d\u0003\u0019AA4\u0003)\u0019XM\\:pe:\u000bW.\u001a\u0005\t\u0005'\u00129\u00051\u0001\u0003\u0006\u0005QQ.\u001a;sS\u000et\u0015-\\3\t\u000f\t]\u0003\u0001\"\u0001\u0003Z\u0005YQ\u000f\u001d3bi\u0016\fVo\u001c;b)\u001dY'1\fB2\u0005KB\u0001\"!\u001a\u0003V\u0001\u0007!Q\f\t\u0006\u0013\t}\u0013qM\u0005\u0004\u0005CR!AB(qi&|g\u000e\u0003\u0005\u0002x\tU\u0003\u0019\u0001B/\u0011!\t9M!\u0016A\u0002\t\u001d\u0004\u0003B\u0005\u0003`aCqAa\u001b\u0001\t#\u0011i'\u0001\u000bdY&,g\u000e\u001e*bi\u0016lU\r\u001e:jG:\u000bW.\u001a\u000b\u0007\u0005\u000b\u0011yG!\u001d\t\u0011\u0005\u0015$\u0011\u000ea\u0001\u0003OB\u0001\"a\u001e\u0003j\u0001\u0007\u0011q\r\u0005\b\u0005k\u0002A\u0011\u0002B<\u0003I!\bN]8ui2,W*\u001a;sS\u000et\u0015-\\3\u0015\t\t\u0015!\u0011\u0010\u0005\t\u0003[\u0013\u0019\b1\u0001\u00022\"9!Q\u0010\u0001\u0005\u0002\u0005\r\u0013\u0001C:ikR$wn\u001e8")
public class ClientQuotaManager
implements Logging {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final QuotaType kafka$server$ClientQuotaManager$$quotaType;
    private final Time time;
    private final ConcurrentHashMap<QuotaId, Quota> overriddenQuota;
    private final Quota staticConfigClientIdQuota;
    private int quotaTypesEnabled;
    private final ReentrantReadWriteLock lock;
    private final DelayQueue<ThrottledResponse> delayQueue;
    private final SensorAccess sensorAccessor;
    private final ThrottledRequestReaper throttledRequestReaper;
    private final Sensor kafka$server$ClientQuotaManager$$delayQueueSensor;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ClientQuotaManager clientQuotaManager = this;
        synchronized (clientQuotaManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    public QuotaType kafka$server$ClientQuotaManager$$quotaType() {
        return this.kafka$server$ClientQuotaManager$$quotaType;
    }

    private Time time() {
        return this.time;
    }

    private ConcurrentHashMap<QuotaId, Quota> overriddenQuota() {
        return this.overriddenQuota;
    }

    private Quota staticConfigClientIdQuota() {
        return this.staticConfigClientIdQuota;
    }

    private int quotaTypesEnabled() {
        return this.quotaTypesEnabled;
    }

    private void quotaTypesEnabled_$eq(int x$1) {
        this.quotaTypesEnabled = x$1;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private DelayQueue<ThrottledResponse> delayQueue() {
        return this.delayQueue;
    }

    private SensorAccess sensorAccessor() {
        return this.sensorAccessor;
    }

    public ThrottledRequestReaper throttledRequestReaper() {
        return this.throttledRequestReaper;
    }

    public Sensor kafka$server$ClientQuotaManager$$delayQueueSensor() {
        return this.kafka$server$ClientQuotaManager$$delayQueueSensor;
    }

    private void start() {
        this.throttledRequestReaper().start();
    }

    public int recordAndMaybeThrottle(String sanitizedUser, String clientId, double value2, Function1<Object, BoxedUnit> callback) {
        ClientSensors clientSensors = this.getOrCreateQuotaSensors(sanitizedUser, clientId);
        return this.recordAndThrottleOnQuotaViolation(clientSensors, value2, callback);
    }

    public int recordAndThrottleOnQuotaViolation(ClientSensors clientSensors, double value2, Function1<Object, BoxedUnit> callback) {
        int throttleTimeMs = 0;
        try {
            clientSensors.quotaSensor().record(value2);
            callback.apply$mcVI$sp(0);
        }
        catch (QuotaViolationException quotaViolationException) {
            QuotaEntity clientQuotaEntity = clientSensors.quotaEntity();
            KafkaMetric clientMetric = (KafkaMetric)this.metrics().metrics().get(this.clientRateMetricName(clientQuotaEntity.sanitizedUser(), clientQuotaEntity.clientId()));
            throttleTimeMs = (int)RichLong$.MODULE$.round$extension(Predef$.MODULE$.longWrapper(this.throttleTime(clientMetric, this.getQuotaMetricConfig(clientQuotaEntity.quota()))));
            clientSensors.throttleTimeSensor().record((double)throttleTimeMs);
            this.delayQueue().add(new ThrottledResponse(this.time(), throttleTimeMs, callback));
            this.kafka$server$ClientQuotaManager$$delayQueueSensor().record();
            this.logger().debug((Object)new StringOps(Predef$.MODULE$.augmentString("Quota violated for sensor (%s). Delay time: (%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clientSensors.quotaSensor().name(), BoxesRunTime.boxToInteger((int)throttleTimeMs)})));
        }
        return throttleTimeMs;
    }

    public void recordNoThrottle(ClientSensors clientSensors, double value2) {
        clientSensors.quotaSensor().record(value2, this.time().milliseconds(), false);
    }

    public QuotaEntity kafka$server$ClientQuotaManager$$quotaEntity(String sanitizedUser, String clientId) {
        QuotaEntity quotaEntity;
        int n = this.quotaTypesEnabled();
        boolean bl = QuotaTypes$.MODULE$.NoQuotas() == n ? true : QuotaTypes$.MODULE$.ClientIdQuotaEnabled() == n;
        if (bl) {
            QuotaId quotaId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)clientId));
            Quota quota = this.overriddenQuota().get(quotaId);
            if (quota == null && (quota = this.overriddenQuota().get(ClientQuotaManagerConfig$.MODULE$.DefaultClientIdQuotaId())) == null) {
                quota = this.staticConfigClientIdQuota();
            }
            quotaEntity = new QuotaEntity(quotaId, "", clientId, quota);
        } else if (QuotaTypes$.MODULE$.UserQuotaEnabled() == n) {
            QuotaId quotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)None$.MODULE$);
            Quota quota = this.overriddenQuota().get(quotaId);
            if (quota == null && (quota = this.overriddenQuota().get(ClientQuotaManagerConfig$.MODULE$.DefaultUserQuotaId())) == null) {
                quota = ClientQuotaManagerConfig$.MODULE$.UnlimitedQuota();
            }
            quotaEntity = new QuotaEntity(quotaId, sanitizedUser, "", quota);
        } else if (QuotaTypes$.MODULE$.UserClientIdQuotaEnabled() == n) {
            QuotaId quotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)clientId));
            Quota quota = this.overriddenQuota().get(quotaId);
            if (quota == null && (quota = this.overriddenQuota().get(new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default())))) == null && (quota = this.overriddenQuota().get(new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)clientId)))) == null && (quota = this.overriddenQuota().get(ClientQuotaManagerConfig$.MODULE$.DefaultUserClientIdQuotaId())) == null) {
                quota = ClientQuotaManagerConfig$.MODULE$.UnlimitedQuota();
            }
            quotaEntity = new QuotaEntity(quotaId, sanitizedUser, clientId, quota);
        } else {
            quotaEntity = this.quotaEntityWithMultipleQuotaLevels(sanitizedUser, clientId);
        }
        return quotaEntity;
    }

    private QuotaEntity quotaEntityWithMultipleQuotaLevels(String sanitizedUser, String clientId) {
        QuotaId userClientQuotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)clientId));
        QuotaId userQuotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)None$.MODULE$);
        QuotaId clientQuotaId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)clientId));
        QuotaId quotaId = userClientQuotaId;
        QuotaId quotaConfigId = userClientQuotaId;
        Quota quota = this.overriddenQuota().get(quotaConfigId);
        if (quota == null) {
            quotaId = userClientQuotaId;
            quotaConfigId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
            quota = this.overriddenQuota().get(quotaConfigId);
            if (quota == null) {
                quotaConfigId = quotaId = userQuotaId;
                quota = this.overriddenQuota().get(quotaConfigId);
                if (quota == null) {
                    quotaId = userClientQuotaId;
                    quotaConfigId = new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)clientId));
                    quota = this.overriddenQuota().get(quotaConfigId);
                    if (quota == null) {
                        quotaId = userClientQuotaId;
                        quotaConfigId = new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
                        quota = this.overriddenQuota().get(quotaConfigId);
                        if (quota == null) {
                            quotaId = userQuotaId;
                            quotaConfigId = new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
                            quota = this.overriddenQuota().get(quotaConfigId);
                            if (quota == null) {
                                quotaId = clientQuotaId;
                                quotaConfigId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)clientId));
                                quota = this.overriddenQuota().get(quotaConfigId);
                                if (quota == null) {
                                    quotaId = clientQuotaId;
                                    quotaConfigId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
                                    quota = this.overriddenQuota().get(quotaConfigId);
                                    if (quota == null) {
                                        quotaId = clientQuotaId;
                                        quotaConfigId = null;
                                        quota = this.staticConfigClientIdQuota();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        QuotaId quotaId2 = quotaId;
        QuotaId quotaId3 = clientQuotaId;
        String quotaUser = !(quotaId2 != null ? !((Object)quotaId2).equals(quotaId3) : quotaId3 != null) ? "" : sanitizedUser;
        QuotaId quotaId4 = quotaId;
        QuotaId quotaId5 = userQuotaId;
        String quotaClientId = !(quotaId4 != null ? !((Object)quotaId4).equals(quotaId5) : quotaId5 != null) ? "" : clientId;
        return new QuotaEntity(quotaId, quotaUser, quotaClientId, quota);
    }

    public Quota quota(String user, String clientId) {
        return this.kafka$server$ClientQuotaManager$$quotaEntity(QuotaId$.MODULE$.sanitize(user), clientId).quota();
    }

    public long throttleTime(KafkaMetric clientMetric, MetricConfig config) {
        Rate rateMetric = this.measurableAsRate(clientMetric.metricName(), clientMetric.measurable());
        Quota quota = config.quota();
        double difference = clientMetric.value() - quota.bound();
        double throttleTimeMs = difference / quota.bound() * (double)rateMetric.windowSize(config, this.time().milliseconds());
        return RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(throttleTimeMs));
    }

    private Rate measurableAsRate(MetricName name, Measurable measurable) {
        Measurable measurable2 = measurable;
        if (measurable2 instanceof Rate) {
            Rate rate;
            Rate rate2 = rate = (Rate)measurable2;
            return rate2;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metric ", " is not a Rate metric, value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, measurable})));
    }

    public ClientSensors getOrCreateQuotaSensors(String sanitizedUser, String clientId) {
        QuotaEntity clientQuotaEntity = this.kafka$server$ClientQuotaManager$$quotaEntity(sanitizedUser, clientId);
        return new ClientSensors(clientQuotaEntity, this.sensorAccessor().getOrCreate(this.getQuotaSensorName(clientQuotaEntity.quotaId()), ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), this.lock(), this.metrics(), (Function0<MetricName>)new Serializable(this, clientQuotaEntity){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientQuotaManager $outer;
            private final QuotaEntity clientQuotaEntity$1;

            public final MetricName apply() {
                return this.$outer.clientRateMetricName(this.clientQuotaEntity$1.sanitizedUser(), this.clientQuotaEntity$1.clientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.clientQuotaEntity$1 = clientQuotaEntity$1;
            }
        }, (Function0<MetricConfig>)new Serializable(this, clientQuotaEntity){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientQuotaManager $outer;
            private final QuotaEntity clientQuotaEntity$1;

            public final MetricConfig apply() {
                return this.$outer.getQuotaMetricConfig(this.clientQuotaEntity$1.quota());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.clientQuotaEntity$1 = clientQuotaEntity$1;
            }
        }, (Function0<MeasurableStat>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientQuotaManager $outer;

            public final MeasurableStat apply() {
                return this.$outer.kafka$server$ClientQuotaManager$$measurableStat();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }), this.sensorAccessor().getOrCreate(this.getThrottleTimeSensorName(clientQuotaEntity.quotaId()), ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), this.lock(), this.metrics(), (Function0<MetricName>)new Serializable(this, clientQuotaEntity){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientQuotaManager $outer;
            private final QuotaEntity clientQuotaEntity$1;

            public final MetricName apply() {
                return this.$outer.kafka$server$ClientQuotaManager$$throttleMetricName(this.clientQuotaEntity$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.clientQuotaEntity$1 = clientQuotaEntity$1;
            }
        }, (Function0<MetricConfig>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        }, (Function0<MeasurableStat>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Avg apply() {
                return new Avg();
            }
        }));
    }

    public MeasurableStat kafka$server$ClientQuotaManager$$measurableStat() {
        return new Rate();
    }

    private String getThrottleTimeSensorName(QuotaId quotaId) {
        return new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.kafka$server$ClientQuotaManager$$quotaType()), "ThrottleTime-")).append(quotaId.sanitizedUser().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).append((Object)BoxesRunTime.boxToCharacter((char)':')).append(quotaId.clientId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).toString();
    }

    private String getQuotaSensorName(QuotaId quotaId) {
        return new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.kafka$server$ClientQuotaManager$$quotaType()), "-")).append(quotaId.sanitizedUser().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).append((Object)BoxesRunTime.boxToCharacter((char)':')).append(quotaId.clientId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).toString();
    }

    public MetricConfig getQuotaMetricConfig(Quota quota) {
        return new MetricConfig().timeWindow((long)this.config().quotaWindowSizeSeconds(), TimeUnit.SECONDS).samples(this.config().numQuotaSamples()).quota(quota);
    }

    public Sensor createSensor(String sensorName, MetricName metricName) {
        return this.sensorAccessor().getOrCreate(sensorName, ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), this.lock(), this.metrics(), (Function0<MetricName>)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final MetricName metricName$1;

            public final MetricName apply() {
                return this.metricName$1;
            }
            {
                this.metricName$1 = metricName$1;
            }
        }, (Function0<MetricConfig>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        }, (Function0<MeasurableStat>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientQuotaManager $outer;

            public final MeasurableStat apply() {
                return this.$outer.kafka$server$ClientQuotaManager$$measurableStat();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void updateQuota(Option<String> sanitizedUser, Option<String> clientId, Option<Quota> quota) {
        this.lock().writeLock().lock();
        try {
            Option<String> option;
            block13: {
                Option<String> option2;
                block17: {
                    Option<Quota> option3;
                    block25: {
                        String clientIdInfo;
                        String userInfo;
                        block24: {
                            Quota quota2;
                            QuotaId quotaId;
                            block18: {
                                Tuple2 tuple2;
                                block23: {
                                    block20: {
                                        block22: {
                                            block21: {
                                                block19: {
                                                    String string;
                                                    block15: {
                                                        block16: {
                                                            Some some;
                                                            boolean bl;
                                                            block14: {
                                                                String string2;
                                                                block11: {
                                                                    block12: {
                                                                        Some some2;
                                                                        boolean bl2;
                                                                        block10: {
                                                                            quotaId = new QuotaId(sanitizedUser, clientId);
                                                                            bl2 = false;
                                                                            some2 = null;
                                                                            option = sanitizedUser;
                                                                            if (!(option instanceof Some)) break block10;
                                                                            bl2 = true;
                                                                            some2 = (Some)option;
                                                                            String string3 = (String)some2.x();
                                                                            String string4 = ConfigEntityName$.MODULE$.Default();
                                                                            String string5 = string3;
                                                                            if (string4 != null ? !string4.equals(string5) : string5 != null) break block10;
                                                                            string2 = "default user ";
                                                                            break block11;
                                                                        }
                                                                        if (!bl2) break block12;
                                                                        String user = (String)some2.x();
                                                                        string2 = new StringBuilder().append((Object)"user ").append((Object)user).append((Object)" ").toString();
                                                                        break block11;
                                                                    }
                                                                    if (!None$.MODULE$.equals(option)) break block13;
                                                                    string2 = "";
                                                                }
                                                                userInfo = string2;
                                                                bl = false;
                                                                some = null;
                                                                option2 = clientId;
                                                                if (!(option2 instanceof Some)) break block14;
                                                                bl = true;
                                                                some = (Some)option2;
                                                                String string6 = (String)some.x();
                                                                String string7 = ConfigEntityName$.MODULE$.Default();
                                                                String string8 = string6;
                                                                if (string7 != null ? !string7.equals(string8) : string8 != null) break block14;
                                                                string = "default client-id";
                                                                break block15;
                                                            }
                                                            if (!bl) break block16;
                                                            String id = (String)some.x();
                                                            string = new StringBuilder().append((Object)"client-id ").append((Object)id).toString();
                                                            break block15;
                                                        }
                                                        if (!None$.MODULE$.equals(option2)) break block17;
                                                        string = "";
                                                    }
                                                    clientIdInfo = string;
                                                    option3 = quota;
                                                    if (!(option3 instanceof Some)) break block18;
                                                    Some some = (Some)option3;
                                                    Quota newQuota = (Quota)some.x();
                                                    this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changing ", " quota for ", "", " to ", ".bound}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$server$ClientQuotaManager$$quotaType(), userInfo, clientIdInfo, newQuota})));
                                                    this.overriddenQuota().put(quotaId, newQuota);
                                                    tuple2 = new Tuple2(sanitizedUser, clientId);
                                                    if (tuple2 == null) break block19;
                                                    Option option4 = (Option)tuple2._1();
                                                    Option option5 = (Option)tuple2._2();
                                                    if (!(option4 instanceof Some) || !(option5 instanceof Some)) break block19;
                                                    this.quotaTypesEnabled_$eq(this.quotaTypesEnabled() | QuotaTypes$.MODULE$.UserClientIdQuotaEnabled());
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block20;
                                                }
                                                if (tuple2 == null) break block21;
                                                Option option6 = (Option)tuple2._1();
                                                Option option7 = (Option)tuple2._2();
                                                if (!(option6 instanceof Some) || !None$.MODULE$.equals(option7)) break block21;
                                                this.quotaTypesEnabled_$eq(this.quotaTypesEnabled() | QuotaTypes$.MODULE$.UserQuotaEnabled());
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block20;
                                            }
                                            if (tuple2 == null) break block22;
                                            Option option8 = (Option)tuple2._1();
                                            Option option9 = (Option)tuple2._2();
                                            if (!None$.MODULE$.equals(option8) || !(option9 instanceof Some)) break block22;
                                            this.quotaTypesEnabled_$eq(this.quotaTypesEnabled() | QuotaTypes$.MODULE$.ClientIdQuotaEnabled());
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block20;
                                        }
                                        if (tuple2 == null) break block23;
                                        Option option10 = (Option)tuple2._1();
                                        Option option11 = (Option)tuple2._2();
                                        if (!None$.MODULE$.equals(option10) || !None$.MODULE$.equals(option11)) break block23;
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    }
                                    quota2 = BoxedUnit.UNIT;
                                    break block24;
                                }
                                throw new MatchError((Object)tuple2);
                            }
                            if (!None$.MODULE$.equals(option3)) break block25;
                            this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing ", " quota for ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$server$ClientQuotaManager$$quotaType(), userInfo, clientIdInfo})));
                            quota2 = this.overriddenQuota().remove(quotaId);
                        }
                        MetricName quotaMetricName = this.clientRateMetricName((String)sanitizedUser.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        }), (String)clientId.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        }));
                        Map allMetrics = this.metrics().metrics();
                        int n = this.quotaTypesEnabled();
                        boolean bl = QuotaTypes$.MODULE$.NoQuotas() == n ? true : (QuotaTypes$.MODULE$.ClientIdQuotaEnabled() == n ? true : (QuotaTypes$.MODULE$.UserQuotaEnabled() == n ? true : QuotaTypes$.MODULE$.UserClientIdQuotaEnabled() == n));
                        boolean bl3 = bl ? !sanitizedUser.filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String x$1) {
                                String string = x$1;
                                String string2 = ConfigEntityName$.MODULE$.Default();
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                        }).isDefined() && !clientId.filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String x$2) {
                                String string = x$2;
                                String string2 = ConfigEntityName$.MODULE$.Default();
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                        }).isDefined() : false;
                        boolean singleUpdate = bl3;
                        if (singleUpdate) {
                            KafkaMetric metric = (KafkaMetric)allMetrics.get(quotaMetricName);
                            if (metric != null) {
                                QuotaEntity metricConfigEntity = this.kafka$server$ClientQuotaManager$$quotaEntity((String)sanitizedUser.getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                }), (String)clientId.getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                }));
                                Quota newQuota = metricConfigEntity.quota();
                                this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sensor for ", "", " already exists. Changing quota to ", " in MetricConfig"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{userInfo, clientIdInfo, BoxesRunTime.boxToDouble((double)newQuota.bound())})));
                                metric.config(this.getQuotaMetricConfig(newQuota));
                            }
                        } else {
                            ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(allMetrics).asScala()).filterKeys((Function1)new Serializable(this, quotaMetricName){
                                public static final long serialVersionUID = 0L;
                                private final MetricName quotaMetricName$1;

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final boolean apply(MetricName n) {
                                    String string = n.name();
                                    String string2 = this.quotaMetricName$1.name();
                                    if (string == null) {
                                        if (string2 != null) {
                                            return false;
                                        }
                                    } else if (!string.equals(string2)) return false;
                                    String string3 = n.group();
                                    String string4 = this.quotaMetricName$1.group();
                                    if (string3 == null) {
                                        if (string4 == null) return true;
                                        return false;
                                    } else {
                                        if (!string3.equals(string4)) return false;
                                        return true;
                                    }
                                }
                                {
                                    this.quotaMetricName$1 = quotaMetricName$1;
                                }
                            }).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ ClientQuotaManager $outer;

                                public final void apply(Tuple2<MetricName, KafkaMetric> x0$1) {
                                    Tuple2<MetricName, KafkaMetric> tuple2 = x0$1;
                                    if (tuple2 != null) {
                                        BoxedUnit boxedUnit;
                                        MetricName metricName = (MetricName)tuple2._1();
                                        KafkaMetric metric = (KafkaMetric)tuple2._2();
                                        String userTag = metricName.tags().containsKey("user") ? (String)metricName.tags().get("user") : "";
                                        String clientIdTag = metricName.tags().containsKey("client-id") ? (String)metricName.tags().get("client-id") : "";
                                        QuotaEntity metricConfigEntity = this.$outer.kafka$server$ClientQuotaManager$$quotaEntity(userTag, clientIdTag);
                                        Quota quota = metricConfigEntity.quota();
                                        Quota quota2 = metric.config().quota();
                                        if (!(quota != null ? !quota.equals(quota2) : quota2 != null)) {
                                            boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            Quota newQuota = metricConfigEntity.quota();
                                            this.$outer.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sensor for quota-id ", " already exists. Setting quota to ", " in MetricConfig"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metricConfigEntity.quotaId(), BoxesRunTime.boxToDouble((double)newQuota.bound())})));
                                            metric.config(this.$outer.getQuotaMetricConfig(newQuota));
                                            boxedUnit = BoxedUnit.UNIT;
                                        }
                                        BoxedUnit boxedUnit2 = boxedUnit;
                                        return;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                        return;
                    }
                    throw new MatchError(option3);
                }
                throw new MatchError(option2);
            }
            throw new MatchError(option);
        }
        finally {
            this.lock().writeLock().unlock();
        }
    }

    public MetricName clientRateMetricName(String sanitizedUser, String clientId) {
        return this.metrics().metricName("byte-rate", this.kafka$server$ClientQuotaManager$$quotaType().toString(), "Tracking byte-rate per user/client-id", new String[]{"user", sanitizedUser, "client-id", clientId});
    }

    public MetricName kafka$server$ClientQuotaManager$$throttleMetricName(QuotaEntity quotaEntity) {
        return this.metrics().metricName("throttle-time", this.kafka$server$ClientQuotaManager$$quotaType().toString(), "Tracking average throttle-time per user/client-id", new String[]{"user", quotaEntity.sanitizedUser(), "client-id", quotaEntity.clientId()});
    }

    public void shutdown() {
        this.throttledRequestReaper().shutdown();
    }

    public ClientQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, QuotaType quotaType, Time time) {
        this.config = config;
        this.metrics = metrics;
        this.kafka$server$ClientQuotaManager$$quotaType = quotaType;
        this.time = time;
        Logging$class.$init$(this);
        this.overriddenQuota = new ConcurrentHashMap();
        this.staticConfigClientIdQuota = Quota.upperBound((double)config.quotaBytesPerSecondDefault());
        this.quotaTypesEnabled = config.quotaBytesPerSecondDefault() == Long.MAX_VALUE ? QuotaTypes$.MODULE$.NoQuotas() : QuotaTypes$.MODULE$.ClientIdQuotaEnabled();
        this.lock = new ReentrantReadWriteLock();
        this.delayQueue = new DelayQueue();
        this.sensorAccessor = new SensorAccess();
        this.throttledRequestReaper = new ThrottledRequestReaper(this, this.delayQueue());
        this.kafka$server$ClientQuotaManager$$delayQueueSensor = metrics.sensor(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)quotaType), "-delayQueue"));
        this.kafka$server$ClientQuotaManager$$delayQueueSensor().add(metrics.metricName("queue-size", quotaType.toString(), "Tracks the size of the delay queue"), (MeasurableStat)new Total());
        this.start();
    }

    public class ThrottledRequestReaper
    extends ShutdownableThread {
        private final DelayQueue<ThrottledResponse> delayQueue;
        public final /* synthetic */ ClientQuotaManager $outer;

        @Override
        public void doWork() {
            ThrottledResponse response = (ThrottledResponse)this.delayQueue.poll(1L, TimeUnit.SECONDS);
            if (response != null) {
                this.kafka$server$ClientQuotaManager$ThrottledRequestReaper$$$outer().kafka$server$ClientQuotaManager$$delayQueueSensor().record(-1.0);
                this.trace((Function0<String>)new Serializable(this, response){
                    public static final long serialVersionUID = 0L;
                    private final ThrottledResponse response$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Response throttled for: ").append((Object)BoxesRunTime.boxToInteger((int)this.response$1.throttleTimeMs())).append((Object)" ms").toString();
                    }
                    {
                        this.response$1 = response$1;
                    }
                });
                response.execute();
            }
        }

        public /* synthetic */ ClientQuotaManager kafka$server$ClientQuotaManager$ThrottledRequestReaper$$$outer() {
            return this.$outer;
        }

        public ThrottledRequestReaper(ClientQuotaManager $outer, DelayQueue<ThrottledResponse> delayQueue) {
            this.delayQueue = delayQueue;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(new StringOps(Predef$.MODULE$.augmentString("ThrottledRequestReaper-%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$outer.kafka$server$ClientQuotaManager$$quotaType()})), false);
        }
    }
}

