/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import kafka.common.KafkaException;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class ApiUtils$ {
    public static final ApiUtils$ MODULE$;
    private final String ProtocolEncoding;

    static {
        new ApiUtils$();
    }

    public String ProtocolEncoding() {
        return this.ProtocolEncoding;
    }

    public String readShortString(ByteBuffer buffer) {
        short size = buffer.getShort();
        if (size < 0) {
            return null;
        }
        byte[] bytes = new byte[size];
        buffer.get(bytes);
        return new String(bytes, this.ProtocolEncoding());
    }

    public void writeShortString(ByteBuffer buffer, String string) {
        if (string == null) {
            buffer.putShort((short)-1);
        } else {
            byte[] encodedString = string.getBytes(this.ProtocolEncoding());
            if (encodedString.length > Short.MAX_VALUE) {
                throw new KafkaException(new StringBuilder().append((Object)"String exceeds the maximum size of ").append((Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)).append((Object)".").toString());
            }
            buffer.putShort((short)encodedString.length);
            buffer.put(encodedString);
        }
    }

    public int shortStringLength(String string) {
        int n;
        if (string == null) {
            n = 2;
        } else {
            byte[] encodedString = string.getBytes(this.ProtocolEncoding());
            if (encodedString.length > Short.MAX_VALUE) {
                throw new KafkaException(new StringBuilder().append((Object)"String exceeds the maximum size of ").append((Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)).append((Object)".").toString());
            }
            n = 2 + encodedString.length;
        }
        return n;
    }

    public int readIntInRange(ByteBuffer buffer, String name, Tuple2<Object, Object> range) {
        int value2 = buffer.getInt();
        if (value2 < range._1$mcI$sp() || value2 > range._2$mcI$sp()) {
            throw new KafkaException(new StringBuilder().append((Object)name).append((Object)" has value ").append((Object)BoxesRunTime.boxToInteger((int)value2)).append((Object)" which is not in the range ").append(range).append((Object)".").toString());
        }
        return value2;
    }

    public short readShortInRange(ByteBuffer buffer, String name, Tuple2<Object, Object> range) {
        short value2 = buffer.getShort();
        if (value2 < BoxesRunTime.unboxToShort((Object)range._1()) || value2 > BoxesRunTime.unboxToShort((Object)range._2())) {
            throw new KafkaException(new StringBuilder().append((Object)name).append((Object)" has value ").append((Object)BoxesRunTime.boxToShort((short)value2)).append((Object)" which is not in the range ").append(range).append((Object)".").toString());
        }
        return value2;
    }

    private ApiUtils$() {
        MODULE$ = this;
        this.ProtocolEncoding = "UTF-8";
    }
}

