/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.admin.AclCommand$;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.api.SaslSetup$class;
import kafka.api.SaslSetupMode;
import kafka.common.TopicAndPartition;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Describe$;
import kafka.security.auth.Group$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.Topic$;
import kafka.security.auth.Write$;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\tud!B\u0001\u0003\u0003\u00039!!G#oIR{WI\u001c3BkRDwN]5{CRLwN\u001c+fgRT!a\u0001\u0003\u0002\u0007\u0005\u0004\u0018NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\r!\tI!\"D\u0001\u0003\u0013\tY!A\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t!\tIQ\"\u0003\u0002\u000f\u0005\tI1+Y:m'\u0016$X\u000f\u001d\u0005\u0006!\u0001!\t!E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\u0001\"!\u0003\u0001\t\u000fQ\u0001!\u0019!C!+\u0005i\u0001O]8ek\u000e,'oQ8v]R,\u0012A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0004\u0013:$\bBB\u000f\u0001A\u0003%a#\u0001\bqe>$WoY3s\u0007>,h\u000e\u001e\u0011\t\u000f}\u0001!\u0019!C!+\u0005i1m\u001c8tk6,'oQ8v]RDa!\t\u0001!\u0002\u00131\u0012AD2p]N,X.\u001a:D_VtG\u000f\t\u0005\bG\u0001\u0011\r\u0011\"\u0011\u0016\u0003-\u0019XM\u001d<fe\u000e{WO\u001c;\t\r\u0015\u0002\u0001\u0015!\u0003\u0017\u00031\u0019XM\u001d<fe\u000e{WO\u001c;!\u0011\u00159\u0003\u0001\"\u0011)\u0003\r\u001awN\u001c4jOV\u0014XmU3dkJLG/\u001f\"fM>\u0014XmU3sm\u0016\u00148o\u0015;beR$\u0012!\u000b\t\u0003/)J!a\u000b\r\u0003\tUs\u0017\u000e\u001e\u0005\b[\u0001\u0011\r\u0011\"\u0001\u0016\u0003)qW/\u001c*fG>\u0014Hm\u001d\u0005\u0007_\u0001\u0001\u000b\u0011\u0002\f\u0002\u00179,XNU3d_J$7\u000f\t\u0005\bc\u0001\u0011\r\u0011\"\u00013\u0003\u00159'o\\;q+\u0005\u0019\u0004C\u0001\u001b:\u001b\u0005)$B\u0001\u001c8\u0003\u0011a\u0017M\\4\u000b\u0003a\nAA[1wC&\u0011!(\u000e\u0002\u0007'R\u0014\u0018N\\4\t\rq\u0002\u0001\u0015!\u00034\u0003\u00199'o\\;qA!9a\b\u0001b\u0001\n\u0003\u0011\u0014!\u0002;pa&\u001c\u0007B\u0002!\u0001A\u0003%1'\u0001\u0004u_BL7\r\t\u0005\b\u0005\u0002\u0011\r\u0011\"\u00013\u00035!x\u000e]5d/&dGmY1sI\"1A\t\u0001Q\u0001\nM\na\u0002^8qS\u000e<\u0016\u000e\u001c3dCJ$\u0007\u0005C\u0004G\u0001\t\u0007I\u0011A\u000b\u0002\tA\f'\u000f\u001e\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002\f\u0002\u000bA\f'\u000f\u001e\u0011\t\u000f)\u0003!\u0019!C\u0001\u0017\u0006\u0011A\u000f]\u000b\u0002\u0019B\u0011Q*V\u0007\u0002\u001d*\u0011q\nU\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015\t&B\u0001*T\u0003\u0019\t\u0007/Y2iK*\tA+A\u0002pe\u001eL!A\u0016(\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1\u0001\f\u0001Q\u0001\n1\u000b1\u0001\u001e9!\u0011\u001dQ\u0006A1A\u0005\u0002m\u000b\u0011\u0003^8qS\u000e\fe\u000e\u001a)beRLG/[8o+\u0005a\u0006CA/`\u001b\u0005q&BA(\u0005\u0013\t\u0001gLA\tU_BL7-\u00118e!\u0006\u0014H/\u001b;j_:DaA\u0019\u0001!\u0002\u0013a\u0016A\u0005;pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]\u0002Bq\u0001\u001a\u0001C\u0002\u001b\u0005Q-A\bdY&,g\u000e\u001e)sS:\u001c\u0017\u000e]1m+\u00051\u0007CA4k\u001d\t9\u0002.\u0003\u0002j1\u00051\u0001K]3eK\u001aL!AO6\u000b\u0005%D\u0002bB7\u0001\u0005\u00045\t!Z\u0001\u000fW\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0011!y\u0007\u0001#b\u0001\n#\u0002\u0018A\u0004;skN$8\u000b^8sK\u001aKG.Z\u000b\u0002cB\u0019qC\u001d;\n\u0005MD\"\u0001B*p[\u0016\u0004\"!\u001e=\u000e\u0003YT!a^\u001c\u0002\u0005%|\u0017BA=w\u0005\u00111\u0015\u000e\\3\t\u0011m\u0004\u0001\u0012!Q!\nE\fq\u0002\u001e:vgR\u001cFo\u001c:f\r&dW\r\t\u0005\b{\u0002\u0011\r\u0011\"\u0001\u007f\u00035!x\u000e]5d%\u0016\u001cx.\u001e:dKV\tq\u0010\u0005\u0003\u0002\u0002\u0005-QBAA\u0002\u0015\u0011\t)!a\u0002\u0002\t\u0005,H\u000f\u001b\u0006\u0004\u0003\u0013!\u0011\u0001C:fGV\u0014\u0018\u000e^=\n\t\u00055\u00111\u0001\u0002\t%\u0016\u001cx.\u001e:dK\"9\u0011\u0011\u0003\u0001!\u0002\u0013y\u0018A\u0004;pa&\u001c'+Z:pkJ\u001cW\r\t\u0005\t\u0003+\u0001!\u0019!C\u0001}\u0006iqM]8vaJ+7o\\;sG\u0016Dq!!\u0007\u0001A\u0003%q0\u0001\bhe>,\bOU3t_V\u00148-\u001a\u0011\t\u0011\u0005u\u0001A1A\u0005\u0002y\fqb\u00197vgR,'OU3t_V\u00148-\u001a\u0005\b\u0003C\u0001\u0001\u0015!\u0003\u0000\u0003A\u0019G.^:uKJ\u0014Vm]8ve\u000e,\u0007\u0005C\u0004\u0002&\u0001!\t!a\n\u0002\u001d\rdWo\u001d;fe\u0006\u001bG.\u0011:hgV\u0011\u0011\u0011\u0006\t\u0005/\u0005-b-C\u0002\u0002.a\u0011Q!\u0011:sCfDq!!\r\u0001\t\u0003\t9#\u0001\fu_BL7M\u0011:pW\u0016\u0014(+Z1e\u0003\u000ed\u0017I]4t\u0011\u001d\t)\u0004\u0001C\u0001\u0003O\ta\u0002\u001d:pIV\u001cW-Q2m\u0003J<7\u000fC\u0004\u0002:\u0001!\t!a\n\u0002\u001f\u0011,7o\u0019:jE\u0016\f5\r\\!sONDq!!\u0010\u0001\t\u0003\t9#A\u000beK2,G/\u001a#fg\u000e\u0014\u0018NY3BG2\f%oZ:\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002(\u0005\u0011B-\u001a7fi\u0016<&/\u001b;f\u0003\u000ed\u0017I]4t\u0011\u001d\t)\u0005\u0001C\u0001\u0003O\tabY8ogVlW-Q2m\u0003J<7\u000fC\u0004\u0002J\u0001!\t!a\n\u0002\u0019\u001d\u0014x.\u001e9BG2\f%oZ:\t\u000f\u00055\u0003\u0001\"\u0001\u0002P\u0005\u00012\t\\;ti\u0016\u0014\u0018i\u0019;j_:\f5\r\\\u000b\u0003\u0003#\u0002b!a\u0015\u0002^\u0005\u0005TBAA+\u0015\u0011\t9&!\u0017\u0002\u0013%lW.\u001e;bE2,'bAA.1\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0013Q\u000b\u0002\u0004'\u0016$\b\u0003BA\u0001\u0003GJA!!\u001a\u0002\u0004\t\u0019\u0011i\u00197\t\u000f\u0005%\u0004\u0001\"\u0001\u0002P\u0005\u0011Bk\u001c9jG\n\u0013xn[3s%\u0016\fG-Q2m\u0011\u001d\ti\u0007\u0001C\u0001\u0003\u001f\nAb\u0012:pkB\u0014V-\u00193BG2Dq!!\u001d\u0001\t\u0003\ty%\u0001\u0007U_BL7MU3bI\u0006\u001bG\u000eC\u0004\u0002v\u0001!\t!a\u0014\u0002\u001bQ{\u0007/[2Xe&$X-Q2m\u0011\u001d\tI\b\u0001C\u0001\u0003\u001f\n\u0001\u0003V8qS\u000e$Um]2sS\n,\u0017i\u00197\t\r\u0005u\u0004\u0001\"\u0011)\u0003\u0015\u0019X\r^+qQ\u0011\tY(!!\u0011\t\u0005\r\u0015\u0011R\u0007\u0003\u0003\u000bS1!a\"T\u0003\u0015QWO\\5u\u0013\u0011\tY)!\"\u0003\r\t+gm\u001c:f\u0011\u001d\ty\t\u0001C!\u0003#\u000b\u0011c\u0019:fCR,g*Z<Qe>$WoY3s+\t\t\u0019\n\u0005\u0005\u0002\u0016\u0006}\u00151UAR\u001b\t\t9J\u0003\u0003\u0002\u001a\u0006m\u0015\u0001\u00039s_\u0012,8-\u001a:\u000b\u0007\u0005u\u0005+A\u0004dY&,g\u000e^:\n\t\u0005\u0005\u0016q\u0013\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0011\u000b]\tY#!*\u0011\u0007]\t9+C\u0002\u0002*b\u0011AAQ=uK\"1\u0011Q\u0016\u0001\u0005B!\n\u0001\u0002^3be\u0012{wO\u001c\u0015\u0005\u0003W\u000b\t\f\u0005\u0003\u0002\u0004\u0006M\u0016\u0002BA[\u0003\u000b\u0013Q!\u00114uKJDq!!/\u0001\t\u0003\tY,A\u000euKN$\bK]8ek\u000e,7i\u001c8tk6,g+[1BgNLwM\\\u000b\u0002S!\"\u0011qWA`!\u0011\t\u0019)!1\n\t\u0005\r\u0017Q\u0011\u0002\u0005)\u0016\u001cH\u000fC\u0004\u0002H\u0002!\t!a/\u0002=Q,7\u000f\u001e)s_\u0012,8-Z\"p]N,X.\u001a,jCN+(m]2sS\n,\u0007\u0006BAc\u0003\u007fCa!!4\u0001\t#A\u0013!E:fi\u0006\u001bGn]!oIB\u0013x\u000eZ;dK\"9\u0011\u0011\u001b\u0001\u0005\u0002\u0005m\u0016a\b;fgRtu\u000e\u0015:pIV\u001cWmV5uQ>,H\u000fR3tGJL'-Z!dY\"B\u0011qZA`\u0003+\f9.\u0001\u0005fqB,7\r^3eG\t\tI\u000e\u0005\u0003\u0002\\\u0006\u0005XBAAo\u0015\r\tyNT\u0001\u0007KJ\u0014xN]:\n\t\u0005\r\u0018Q\u001c\u0002\u0011)&lWm\\;u\u000bb\u001cW\r\u001d;j_:Dq!a:\u0001\t\u0003\tY,\u0001\u000fuKN$hj\u001c)s_\u0012,8-Z,ji\"$Um]2sS\n,\u0017i\u00197)\t\u0005\u0015\u0018q\u0018\u0005\b\u0003[\u0004A\u0011AA^\u0003!\"Xm\u001d;O_\u000e{gn];nK^KG\u000f[8vi\u0012+7o\u0019:jE\u0016\f5\r\u001c,jC\u0006\u001b8/[4oQ!\tY/a0\u0002V\u0006E8EAAz!\ri\u0015Q_\u0005\u0004\u0003ot%AD&bM.\fW\t_2faRLwN\u001c\u0005\b\u0003w\u0004A\u0011AA^\u0003-\"Xm\u001d;O_\u000e{gn];nK^KG\u000f[8vi\u0012+7o\u0019:jE\u0016\f5\r\u001c,jCN+(m]2sS\n,\u0007\u0006CA}\u0003\u007f\u000b).a6\t\u000f\t\u0005\u0001\u0001\"\u0003\u0002<\u0006\u0001cn\\\"p]N,X.Z,ji\"|W\u000f\u001e#fg\u000e\u0014\u0018NY3BG2\u001cV\r^;q\u0011\u001d\u0011)\u0001\u0001C\u0001\u0003w\u000bQ\u0005^3ti:{7i\u001c8tk6,w+\u001b;i\t\u0016\u001c8M]5cK\u0006\u001bGNV5b\u0003N\u001c\u0018n\u001a8)\t\t\r\u0011q\u0018\u0005\b\u0005\u0017\u0001A\u0011AA^\u0003!\"Xm\u001d;O_\u000e{gn];nK^KG\u000f\u001b#fg\u000e\u0014\u0018NY3BG24\u0016.Y*vEN\u001c'/\u001b2fQ\u0011\u0011I!a0\t\u000f\tE\u0001\u0001\"\u0003\u0002<\u0006ibn\\\"p]N,X.Z,ji\"$Um]2sS\n,\u0017i\u00197TKR,\b\u000fC\u0004\u0003\u0016\u0001!\t!a/\u0002\u001dQ,7\u000f\u001e(p\u000fJ|W\u000f]!dY\"\"!1CA`\u0011\u001d\u0011Y\u0002\u0001C\u0005\u0005;\t1b]3oIJ+7m\u001c:egR)\u0011Fa\b\u0003\"!1QF!\u0007A\u0002YAaA\u0013B\r\u0001\u0004a\u0005b\u0002B\u0013\u0001\u0011E!qE\u0001\u000fG>t7/^7f%\u0016\u001cwN\u001d3t)5I#\u0011\u0006B\u001c\u0005s\u0011iDa\u0010\u0003B!A!1\u0006B\u0012\u0001\u0004\u0011i#\u0001\u0005d_:\u001cX/\\3s!!\u0011yCa\r\u0002$\u0006\rVB\u0001B\u0019\u0015\u0011\u0011Y#a'\n\t\tU\"\u0011\u0007\u0002\t\u0007>t7/^7fe\"AQFa\t\u0011\u0002\u0003\u0007a\u0003C\u0005\u0003<\t\r\u0002\u0013!a\u0001-\u0005q1\u000f^1si&twm\u00144gg\u0016$\b\u0002\u0003 \u0003$A\u0005\t\u0019\u00014\t\u0011\u0019\u0013\u0019\u0003%AA\u0002YA!Ba\u0011\u0003$A\u0005\t\u0019\u0001B#\u0003\u001d!\u0018.\\3pkR\u00042a\u0006B$\u0013\r\u0011I\u0005\u0007\u0002\u0005\u0019>tw\rC\u0005\u0003N\u0001\t\n\u0011\"\u0005\u0003P\u0005A2m\u001c8tk6,'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tE#f\u0001\f\u0003T-\u0012!Q\u000b\t\u0005\u0005/\u0012\t'\u0004\u0002\u0003Z)!!1\fB/\u0003%)hn\u00195fG.,GMC\u0002\u0003`a\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019G!\u0017\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0003h\u0001\t\n\u0011\"\u0005\u0003P\u0005A2m\u001c8tk6,'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001a\t\u0013\t-\u0004!%A\u0005\u0012\t5\u0014\u0001G2p]N,X.\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!q\u000e\u0016\u0004M\nM\u0003\"\u0003B:\u0001E\u0005I\u0011\u0003B(\u0003a\u0019wN\\:v[\u0016\u0014VmY8sIN$C-\u001a4bk2$H%\u000e\u0005\n\u0005o\u0002\u0011\u0013!C\t\u0005s\n\u0001dY8ogVlWMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011YH\u000b\u0003\u0003F\tM\u0003")
public abstract class EndToEndAuthorizationTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final int numRecords;
    private final String group;
    private final String topic;
    private final String topicWildcard;
    private final int part;
    private final TopicPartition tp;
    private final TopicAndPartition topicAndPartition;
    private Some<File> trustStoreFile;
    private final Resource topicResource;
    private final Resource groupResource;
    private final Resource clusterResource;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;
    private volatile boolean bitmap$0;

    private Some trustStoreFile$lzycompute() {
        EndToEndAuthorizationTest endToEndAuthorizationTest = this;
        synchronized (endToEndAuthorizationTest) {
            if (!this.bitmap$0) {
                this.trustStoreFile = new Some((Object)File.createTempFile("truststore", ".jks"));
                this.bitmap$0 = true;
            }
            return this.trustStoreFile;
        }
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup$class.startSasl(this, jaasSections);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup$class.maybeCreateEmptyKeytabFiles(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup$class.jaasSections(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public void closeSasl() {
        SaslSetup$class.closeSasl(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup$class.kafkaServerSaslProperties(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup$class.kafkaClientSaslProperties(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism) {
        return SaslSetup$class.jaasClientLoginModule(this, clientSaslMechanism);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup$class.kafkaClientSaslProperties$default$2(this);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup$class.jaasSections$default$3(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup$class.jaasSections$default$4(this);
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        AclCommand$.MODULE$.main(this.clusterAclArgs());
        AclCommand$.MODULE$.main(this.topicBrokerReadAclArgs());
    }

    public int numRecords() {
        return this.numRecords;
    }

    public String group() {
        return this.group;
    }

    public String topic() {
        return this.topic;
    }

    public String topicWildcard() {
        return this.topicWildcard;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public TopicAndPartition topicAndPartition() {
        return this.topicAndPartition;
    }

    public abstract String clientPrincipal();

    public abstract String kafkaPrincipal();

    public Some<File> trustStoreFile() {
        return this.bitmap$0 ? this.trustStoreFile : this.trustStoreFile$lzycompute();
    }

    public Resource topicResource() {
        return this.topicResource;
    }

    public Resource groupResource() {
        return this.groupResource;
    }

    public Resource clusterResource() {
        return this.clusterResource;
    }

    public String[] clusterAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--cluster"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--operation=ClusterAction"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.kafkaPrincipal()}))});
    }

    public String[] topicBrokerReadAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicWildcard()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--operation=Read"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.kafkaPrincipal()}))});
    }

    public String[] produceAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--producer"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.clientPrincipal()}))});
    }

    public String[] describeAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--operation=Describe"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.clientPrincipal()}))});
    }

    public String[] deleteDescribeAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--remove"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--force"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--operation=Describe"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.clientPrincipal()}))});
    }

    public String[] deleteWriteAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--remove"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--force"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--operation=Write"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.clientPrincipal()}))});
    }

    public String[] consumeAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--group=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--consumer"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.clientPrincipal()}))});
    }

    public String[] groupAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zookeeper.connect=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--add"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--group=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--operation=Read"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--allow-principal=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafkaPrincipalType(), this.clientPrincipal()}))});
    }

    public scala.collection.immutable.Set<Acl> ClusterActionAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.kafkaPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)ClusterAction$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicBrokerReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.kafkaPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> GroupReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicWriteAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicDescribeAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$)}));
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        AclCommand$.MODULE$.main(this.topicBrokerReadAclArgs());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndAuthorizationTest $outer;

            public final void apply(KafkaServer s) {
                TestUtils$.MODULE$.waitAndVerifyAcls(this.$outer.ClusterActionAcl(), (Authorizer)s.apis().authorizer().get(), Resource$.MODULE$.ClusterResource());
                TestUtils$.MODULE$.waitAndVerifyAcls(this.$outer.TopicBrokerReadAcl(), (Authorizer)s.apis().authorizer().get(), new Resource((ResourceType)Topic$.MODULE$, "*"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
    }

    @Override
    public KafkaProducer<byte[], byte[]> createNewProducer() {
        String x$3 = this.brokerList();
        long x$4 = 3000L;
        SecurityProtocol x$5 = this.securityProtocol();
        Some<File> x$6 = this.trustStoreFile();
        Option<Properties> x$7 = this.clientSaslProperties();
        Some x$8 = new Some((Object)this.producerConfig());
        int x$9 = TestUtils$.MODULE$.createNewProducer$default$2();
        long x$10 = TestUtils$.MODULE$.createNewProducer$default$4();
        int x$11 = TestUtils$.MODULE$.createNewProducer$default$5();
        long x$12 = TestUtils$.MODULE$.createNewProducer$default$6();
        long x$13 = TestUtils$.MODULE$.createNewProducer$default$7();
        ByteArraySerializer x$14 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createNewProducer$default$12();
        return TestUtils$.MODULE$.createNewProducer(x$3, x$9, x$4, x$10, x$11, x$12, x$13, x$5, (Option<File>)x$6, x$7, x$14, x$15, (Option<Properties>)x$8);
    }

    @Override
    @After
    public void tearDown() {
        this.consumers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaConsumer<byte[], byte[]> x$1) {
                x$1.wakeup();
            }
        });
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testProduceConsumeViaAssign() {
        this.setAclsAndProduce();
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
    }

    @Test
    public void testProduceConsumeViaSubscribe() {
        this.setAclsAndProduce();
        ((KafkaConsumer)this.consumers().head()).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
    }

    public void setAclsAndProduce() {
        AclCommand$.MODULE$.main(this.produceAclArgs());
        AclCommand$.MODULE$.main(this.consumeAclArgs());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndAuthorizationTest $outer;

            public final void apply(KafkaServer s) {
                TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)this.$outer.TopicReadAcl().$plus$plus(this.$outer.TopicWriteAcl()).$plus$plus(this.$outer.TopicDescribeAcl())), (Authorizer)s.apis().authorizer().get(), this.$outer.topicResource());
                TestUtils$.MODULE$.waitAndVerifyAcls(this.$outer.GroupReadAcl(), (Authorizer)s.apis().authorizer().get(), this.$outer.groupResource());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.sendRecords(this.numRecords(), this.tp());
    }

    @Test(expected=TimeoutException.class)
    public void testNoProduceWithoutDescribeAcl() {
        this.sendRecords(this.numRecords(), this.tp());
    }

    @Test
    public void testNoProduceWithDescribeAcl() {
        AclCommand$.MODULE$.main(this.describeAclArgs());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndAuthorizationTest $outer;

            public final void apply(KafkaServer s) {
                TestUtils$.MODULE$.waitAndVerifyAcls(this.$outer.TopicDescribeAcl(), (Authorizer)s.apis().authorizer().get(), this.$outer.topicResource());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        try {
            this.sendRecords(this.numRecords(), this.tp());
            throw this.fail("exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
        }
        catch (TopicAuthorizationException topicAuthorizationException) {
            Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)topicAuthorizationException.unauthorizedTopics());
            return;
        }
    }

    @Test(expected=KafkaException.class)
    public void testNoConsumeWithoutDescribeAclViaAssign() {
        this.noConsumeWithoutDescribeAclSetup();
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
    }

    @Test(expected=TimeoutException.class)
    public void testNoConsumeWithoutDescribeAclViaSubscribe() {
        this.noConsumeWithoutDescribeAclSetup();
        ((KafkaConsumer)this.consumers().head()).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        KafkaConsumer x$16 = (KafkaConsumer)this.consumers().head();
        long x$17 = 3000L;
        int x$18 = this.consumeRecords$default$2();
        int x$19 = this.consumeRecords$default$3();
        String x$20 = this.consumeRecords$default$4();
        int x$21 = this.consumeRecords$default$5();
        this.consumeRecords((Consumer<byte[], byte[]>)x$16, x$18, x$19, x$20, x$21, x$17);
    }

    private void noConsumeWithoutDescribeAclSetup() {
        AclCommand$.MODULE$.main(this.produceAclArgs());
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndAuthorizationTest $outer;

            public final void apply(KafkaServer s) {
                TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)this.$outer.TopicWriteAcl().$plus$plus(this.$outer.TopicDescribeAcl())), (Authorizer)s.apis().authorizer().get(), this.$outer.topicResource());
                TestUtils$.MODULE$.waitAndVerifyAcls(this.$outer.GroupReadAcl(), (Authorizer)s.apis().authorizer().get(), this.$outer.groupResource());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.sendRecords(this.numRecords(), this.tp());
        AclCommand$.MODULE$.main(this.deleteDescribeAclArgs());
        AclCommand$.MODULE$.main(this.deleteWriteAclArgs());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndAuthorizationTest $outer;

            public final void apply(KafkaServer s) {
                TestUtils$.MODULE$.waitAndVerifyAcls(this.$outer.GroupReadAcl(), (Authorizer)s.apis().authorizer().get(), this.$outer.groupResource());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testNoConsumeWithDescribeAclViaAssign() {
        this.noConsumeWithDescribeAclSetup();
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            throw this.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
        }
        catch (TopicAuthorizationException topicAuthorizationException) {
            Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)topicAuthorizationException.unauthorizedTopics());
            return;
        }
    }

    @Test
    public void testNoConsumeWithDescribeAclViaSubscribe() {
        this.noConsumeWithDescribeAclSetup();
        ((KafkaConsumer)this.consumers().head()).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            throw this.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
        }
        catch (TopicAuthorizationException topicAuthorizationException) {
            Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)topicAuthorizationException.unauthorizedTopics());
            return;
        }
    }

    private void noConsumeWithDescribeAclSetup() {
        AclCommand$.MODULE$.main(this.produceAclArgs());
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndAuthorizationTest $outer;

            public final void apply(KafkaServer s) {
                TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)this.$outer.TopicWriteAcl().$plus$plus(this.$outer.TopicDescribeAcl())), (Authorizer)s.apis().authorizer().get(), this.$outer.topicResource());
                TestUtils$.MODULE$.waitAndVerifyAcls(this.$outer.GroupReadAcl(), (Authorizer)s.apis().authorizer().get(), this.$outer.groupResource());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.sendRecords(this.numRecords(), this.tp());
    }

    @Test
    public void testNoGroupAcl() {
        AclCommand$.MODULE$.main(this.produceAclArgs());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndAuthorizationTest $outer;

            public final void apply(KafkaServer s) {
                TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)this.$outer.TopicWriteAcl().$plus$plus(this.$outer.TopicDescribeAcl())), (Authorizer)s.apis().authorizer().get(), this.$outer.topicResource());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.sendRecords(this.numRecords(), this.tp());
        ((KafkaConsumer)this.consumers().head()).assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)((Consumer)this.consumers().head()), this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            throw this.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
        }
        catch (GroupAuthorizationException groupAuthorizationException) {
            Assert.assertEquals((Object)this.group(), (Object)groupAuthorizationException.groupId());
            return;
        }
    }

    private void sendRecords(int numRecords, TopicPartition tp) {
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EndToEndAuthorizationTest $outer;
            private final TopicPartition tp$1;

            public final Future<RecordMetadata> apply(int i) {
                ProducerRecord record = new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
                this.$outer.debug((Function0<String>)new Serializable(this, record){
                    public static final long serialVersionUID = 0L;
                    private final ProducerRecord record$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending this record: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.record$1}));
                    }
                    {
                        this.record$1 = record$1;
                    }
                });
                return ((KafkaProducer)this.$outer.producers().head()).send(record);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$1 = tp$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        try {
            futures.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$2) {
                    return x$2.get();
                }
            });
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    public void consumeRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, String topic, int part, long timeout) {
        ArrayList records2 = new ArrayList();
        long deadlineMs = System.currentTimeMillis() + timeout;
        while (records2.size() < numRecords && System.currentTimeMillis() < deadlineMs) {
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)consumer.poll(50L)).asScala()).foreach((Function1)new Serializable(this, records2){
                public static final long serialVersionUID = 0L;
                private final ArrayList records$1;

                public final boolean apply(ConsumerRecord<byte[], byte[]> record) {
                    return this.records$1.add(record);
                }
                {
                    this.records$1 = records$1;
                }
            });
        }
        if (records2.size() < numRecords) {
            throw new TimeoutException();
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)new Serializable(this, startingOffset, topic, part, records2){
            public static final long serialVersionUID = 0L;
            private final int startingOffset$1;
            private final String topic$1;
            private final int part$1;
            private final ArrayList records$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ConsumerRecord record = (ConsumerRecord)this.records$1.get(i);
                int offset = this.startingOffset$1 + i;
                Assert.assertEquals((Object)this.topic$1, (Object)record.topic());
                Assert.assertEquals((long)this.part$1, (long)record.partition());
                Assert.assertEquals((long)offset, (long)record.offset());
            }
            {
                this.startingOffset$1 = startingOffset$1;
                this.topic$1 = topic$1;
                this.part$1 = part$1;
                this.records$1 = records$1;
            }
        });
    }

    public int consumeRecords$default$2() {
        return 1;
    }

    public int consumeRecords$default$3() {
        return 0;
    }

    public String consumeRecords$default$4() {
        return this.topic();
    }

    public int consumeRecords$default$5() {
        return this.part();
    }

    public long consumeRecords$default$6() {
        return 10000L;
    }

    public EndToEndAuthorizationTest() {
        SaslSetup$class.$init$(this);
        this.producerCount = 1;
        this.consumerCount = 2;
        this.serverCount = 3;
        this.numRecords = 1;
        this.group = "group";
        this.topic = "e2etopic";
        this.topicWildcard = "*";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.topicAndPartition = new TopicAndPartition(this.topic(), this.part());
        this.topicResource = new Resource((ResourceType)Topic$.MODULE$, this.topic());
        this.groupResource = new Resource((ResourceType)Group$.MODULE$, this.group());
        this.clusterResource = Resource$.MODULE$.ClusterResource();
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), SimpleAclAuthorizer.class.getName());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), "3");
        this.consumerConfig().setProperty("group.id", "group");
    }
}

