/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001B\u0001\u0003\u0001\u001d\u0011\u0001DU3qY&\u001c\u0017-T1oC\u001e,'/U;pi\u0006\u001cH+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0001\u0016\u0003\u001d\u0019wN\u001c4jON,\u0012A\u0006\t\u0004/iaR\"\u0001\r\u000b\u0005eQ\u0011AC2pY2,7\r^5p]&\u00111\u0004\u0007\u0002\u0004'\u0016\f\bC\u0001\n\u001e\u0013\tq\"AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007B\u0002\u0011\u0001A\u0003%a#\u0001\u0005d_:4\u0017nZ:!\u0011\u001d\u0011\u0003A1A\u0005\u0002\r\nA\u0001^5nKV\tA\u0005\u0005\u0002&Q5\taE\u0003\u0002(\t\u0005)Q\u000f^5mg&\u0011\u0011F\n\u0002\t\u001b>\u001c7\u000eV5nK\"11\u0006\u0001Q\u0001\n\u0011\nQ\u0001^5nK\u0002Bq!\f\u0001C\u0002\u0013\u0005a&A\u0004nKR\u0014\u0018nY:\u0016\u0003=\u0002\"\u0001M\u001d\u000e\u0003ER!!\f\u001a\u000b\u0005M\"\u0014AB2p[6|gN\u0003\u0002\u0006k)\u0011agN\u0001\u0007CB\f7\r[3\u000b\u0003a\n1a\u001c:h\u0013\tQ\u0014GA\u0004NKR\u0014\u0018nY:\t\rq\u0002\u0001\u0015!\u00030\u0003!iW\r\u001e:jGN\u0004\u0003b\u0002 \u0001\u0005\u0004%\taP\u0001\u0007e\u0016\u001cwN\u001d3\u0016\u0003\u0001\u0003\"!Q\"\u000e\u0003\tS!A\u0010\u001a\n\u0005\u0011\u0013%\u0001D*j[BdWMU3d_J$\u0007B\u0002$\u0001A\u0003%\u0001)A\u0004sK\u000e|'\u000f\u001a\u0011\t\u000f!\u0003!\u0019!C\u0001\u0013\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0017'F\u0001K!\tYE*D\u00013\u0013\ti%G\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\r=\u0003\u0001\u0015!\u0003K\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0004\u0005C\u0004R\u0001\t\u0007I\u0011A%\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]JBaa\u0015\u0001!\u0002\u0013Q\u0015\u0001\u0005;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u001a!\u0011\u001d)\u0006A1A\u0005\u0002Y\u000b\u0011BZ3uG\"LeNZ8\u0016\u0003]\u00032a\u0006\u000eY!\u0011I\u0011LS.\n\u0005iS!A\u0002+va2,'\u0007\u0005\u0002]]:\u0011Ql\u001b\b\u0003=&t!a\u00185\u000f\u0005\u0001<gBA1g\u001d\t\u0011W-D\u0001d\u0015\t!g!\u0001\u0004=e>|GOP\u0005\u0002q%\u0011agN\u0005\u0003\u000bUJ!a\r\u001b\n\u0005)\u0014\u0014\u0001\u0003:fcV,7\u000f^:\n\u00051l\u0017\u0001\u0004$fi\u000eD'+Z9vKN$(B\u000163\u0013\ty\u0007OA\u0007QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0006\u0003Y6DaA\u001d\u0001!\u0002\u00139\u0016A\u00034fi\u000eD\u0017J\u001c4pA!IA\u000f\u0001a\u0001\u0002\u0004%\t!^\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\u00051\bC\u0001\nx\u0013\tA(A\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u0013i\u0004\u0001\u0019!a\u0001\n\u0003Y\u0018A\u0005:fa2L7-Y'b]\u0006<WM]0%KF$\"\u0001`@\u0011\u0005%i\u0018B\u0001@\u000b\u0005\u0011)f.\u001b;\t\u0011\u0005\u0005\u00110!AA\u0002Y\f1\u0001\u001f\u00132\u0011\u001d\t)\u0001\u0001Q!\nY\fqB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\t\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0003)\u001a\bn\\;mI\u0016C8\r\\;eKN+(m]3rk\u0016tG\u000f\u00165s_R$H.\u001a3QCJ$\u0018\u000e^5p]N$\u0012\u0001 \u0015\u0005\u0003\u000f\ty\u0001\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)bN\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u00033\t\u0019B\u0001\u0003UKN$\bbBA\u000f\u0001\u0011\u0005\u00111B\u0001:g\"|W\u000f\u001c3HKRtu.T3tg\u0006<Wm]%g#V|G/Y:Fq\u000e,W\rZ3e\u001f:\u001cVOY:fcV,g\u000e\u001e)beRLG/[8og\"\"\u00111DA\b\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003\u0017\t!e\u001d5pk2$w)\u001a;C_RDW*Z:tC\u001e,7/\u00134Rk>$\u0018m]!mY><\b\u0006BA\u0011\u0003\u001fAq!!\u000b\u0001\t\u0003\tY!\u0001\u0013tQ>,H\u000eZ%oG2,H-Z%o'ft7\r\u00165s_R$H.\u001a3SKBd\u0017nY1tQ\u0011\t9#a\u0004\t\u000f\u0005=\u0002\u0001\"\u0001\u00022\u0005Q1/\u001a;Va6{7m[:\u0015\u000fq\f\u0019$!\u0012\u0002H!9Q+!\fA\u0002\u0005U\u0002#BA\u001c\u0003\u0003Bf\u0002BA\u001d\u0003{q1AYA\u001e\u0013\u0005Y\u0011bAA \u0015\u00059\u0001/Y2lC\u001e,\u0017bA\u000e\u0002D)\u0019\u0011q\b\u0006\t\u0011y\ni\u0003%AA\u0002\u0001C!\"!\u0013\u0002.A\u0005\t\u0019AA&\u0003I\u0011w\u000e\u001e5SKBd\u0017nY1t\u0013:\u001c\u0016P\\2\u0011\u0007%\ti%C\u0002\u0002P)\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002T\u0001!\t!a\u0003\u0002\u0011Q,\u0017M\u001d#po:DC!!\u0015\u0002XA!\u0011\u0011CA-\u0013\u0011\tY&a\u0005\u0003\u000b\u00053G/\u001a:\t\u000f\u0005}\u0003\u0001\"\u0001\u0002b\u0005IQn\\2l#V|G/\u0019\u000b\u0005\u0003G\nI\u0007E\u0002\u0013\u0003KJ1!a\u001a\u0003\u00051\u0011V\r\u001d7jG\u0006\fVo\u001c;b\u0011!\tY'!\u0018A\u0002\u00055\u0014!\u00022pk:$\u0007cA\u0005\u0002p%\u0019\u0011\u0011\u000f\u0006\u0003\t1{gn\u001a\u0005\n\u0003k\u0002\u0011\u0013!C\u0001\u0003o\nAc]3u+BlunY6tI\u0011,g-Y;mi\u0012\u0012TCAA=U\r\u0001\u00151P\u0016\u0003\u0003{\u0002B!a \u0002\n6\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b))A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0011\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\f\u0006\u0005%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011q\u0012\u0001\u0012\u0002\u0013\u0005\u0011\u0011S\u0001\u0015g\u0016$X\u000b]'pG.\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005M%\u0006BA&\u0003w\u0002")
public class ReplicaManagerQuotasTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final KafkaConfig apply(Properties x$1) {
            return KafkaConfig$.MODULE$.fromProps(x$1, new Properties());
        }
    }, Seq$.MODULE$.canBuildFrom());
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final SimpleRecord record = new SimpleRecord("some-data-in-a-message".getBytes());
    private final TopicPartition topicPartition1 = new TopicPartition("test-topic", 1);
    private final TopicPartition topicPartition2 = new TopicPartition("test-topic", 2);
    private final Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition1()), (Object)new FetchRequest.PartitionData(0L, 0L, 100)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition2()), (Object)new FetchRequest.PartitionData(0L, 0L, 100))}));
    private ReplicaManager replicaManager;

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public SimpleRecord record() {
        return this.record;
    }

    public TopicPartition topicPartition1() {
        return this.topicPartition1;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo() {
        return this.fetchInfo;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Test
    public void shouldExcludeSubsequentThrottledPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch2 = this.replicaManager().readFromLocalLog(followerReplicaId, true, true, Integer.MAX_VALUE, false, this.fetchInfo(), quota, IsolationLevel.READ_UNCOMMITTED);
        Assert.assertEquals((String)"Given two partitions, with only one throttled, we should get the first", (long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$2) {
                Object object = x$2._1();
                TopicPartition topicPartition = this.$outer.topicPartition1();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().batches()).asScala()).size());
        Assert.assertEquals((String)"But we shouldn't get the second", (long)0L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$3) {
                Object object = x$3._1();
                TopicPartition topicPartition = this.$outer.topicPartition2();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().batches()).asScala()).size());
    }

    @Test
    public void shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch2 = this.replicaManager().readFromLocalLog(followerReplicaId, true, true, Integer.MAX_VALUE, false, this.fetchInfo(), quota, IsolationLevel.READ_UNCOMMITTED);
        Assert.assertEquals((String)"Given two partitions, with both throttled, we should get no messages", (long)0L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$4) {
                Object object = x$4._1();
                TopicPartition topicPartition = this.$outer.topicPartition1();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().batches()).asScala()).size());
        Assert.assertEquals((String)"Given two partitions, with both throttled, we should get no messages", (long)0L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$5) {
                Object object = x$5._1();
                TopicPartition topicPartition = this.$outer.topicPartition2();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().batches()).asScala()).size());
    }

    @Test
    public void shouldGetBothMessagesIfQuotasAllow() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch2 = this.replicaManager().readFromLocalLog(followerReplicaId, true, true, Integer.MAX_VALUE, false, this.fetchInfo(), quota, IsolationLevel.READ_UNCOMMITTED);
        Assert.assertEquals((String)"Given two partitions, with both non-throttled, we should get both messages", (long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$6) {
                Object object = x$6._1();
                TopicPartition topicPartition = this.$outer.topicPartition1();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().batches()).asScala()).size());
        Assert.assertEquals((String)"Given two partitions, with both non-throttled, we should get both messages", (long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$7) {
                Object object = x$7._1();
                TopicPartition topicPartition = this.$outer.topicPartition2();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().batches()).asScala()).size());
    }

    @Test
    public void shouldIncludeInSyncThrottledReplicas() {
        Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> x$11 = this.fetchInfo();
        boolean x$12 = true;
        SimpleRecord x$13 = this.setUpMocks$default$2();
        this.setUpMocks(x$11, x$13, x$12);
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch2 = this.replicaManager().readFromLocalLog(followerReplicaId, true, true, Integer.MAX_VALUE, false, this.fetchInfo(), quota, IsolationLevel.READ_UNCOMMITTED);
        Assert.assertEquals((String)"Given two partitions, with only one throttled, we should get the first", (long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$8) {
                Object object = x$8._1();
                TopicPartition topicPartition = this.$outer.topicPartition1();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().batches()).asScala()).size());
        Assert.assertEquals((String)"But we should get the second too since it's throttled but in sync", (long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$9) {
                Object object = x$9._1();
                TopicPartition topicPartition = this.$outer.topicPartition2();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().batches()).asScala()).size());
    }

    public void setUpMocks(Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo, SimpleRecord record, boolean bothReplicasInSync) {
        ZkUtils zkUtils = (ZkUtils)EasyMock.createNiceMock(ZkUtils.class);
        KafkaScheduler scheduler = (KafkaScheduler)EasyMock.createNiceMock(KafkaScheduler.class);
        Log log2 = (Log)EasyMock.createNiceMock(Log.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log2.logStartOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)0L)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log2.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)20L)).anyTimes();
        EasyMock.expect((Object)log2.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata(20L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)log2.read(BoxesRunTime.unboxToLong((Object)EasyMock.anyObject()), EasyMock.geq((int)1), (Option)EasyMock.anyObject(), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()), (IsolationLevel)EasyMock.eq((Object)IsolationLevel.READ_UNCOMMITTED))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{record}), FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4())).anyTimes();
        EasyMock.expect((Object)log2.read(BoxesRunTime.unboxToLong((Object)EasyMock.anyObject()), EasyMock.eq((int)0), (Option)EasyMock.anyObject(), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()), (IsolationLevel)EasyMock.eq((Object)IsolationLevel.READ_UNCOMMITTED))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4())).anyTimes();
        EasyMock.replay((Object[])new Object[]{log2});
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.getLog((TopicPartition)EasyMock.anyObject())).andReturn((Object)new Some((Object)log2)).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), zkUtils, (Scheduler)scheduler, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time()).follower(), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), ReplicaManager$.MODULE$.$lessinit$greater$default$11()));
        fetchInfo.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicPartition, FetchRequest.PartitionData> check$ifrefutable$1) {
                Tuple2<TopicPartition, FetchRequest.PartitionData> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, bothReplicasInSync, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;
            private final boolean bothReplicasInSync$1;
            private final Log log$1;

            public final void apply(Tuple2<TopicPartition, FetchRequest.PartitionData> x$10) {
                Tuple2<TopicPartition, FetchRequest.PartitionData> tuple2 = x$10;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    TopicPartition p = (TopicPartition)tuple2._1();
                    Partition partition = this.$outer.replicaManager().getOrCreatePartition(p);
                    Replica leaderReplica = new Replica(((KafkaConfig)this.$outer.configs().head()).brokerId(), p, (Time)this.$outer.time(), 0L, (Option)new Some((Object)this.log$1));
                    leaderReplica.highWatermark_$eq(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
                    partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderReplica.brokerId())));
                    Replica followerReplica = new Replica(((KafkaConfig)this.$outer.configs().last()).brokerId(), p, (Time)this.$outer.time(), 0L, (Option)new Some((Object)this.log$1));
                    Set allReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Replica[]{leaderReplica, followerReplica}));
                    allReplicas.foreach((Function1)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final Partition partition$1;

                        public final Replica apply(Replica replica) {
                            return this.partition$1.addReplicaIfNotExists(replica);
                        }
                        {
                            this.partition$1 = partition$1;
                        }
                    });
                    if (this.bothReplicasInSync$1) {
                        partition.inSyncReplicas_$eq(allReplicas);
                        followerReplica.highWatermark_$eq(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        partition.inSyncReplicas_$eq((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Replica[]{leaderReplica})));
                        followerReplica.highWatermark_$eq(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bothReplicasInSync$1 = bothReplicasInSync$1;
                this.log$1 = log$1;
            }
        });
    }

    public SimpleRecord setUpMocks$default$2() {
        return this.record();
    }

    public boolean setUpMocks$default$3() {
        return false;
    }

    @After
    public void tearDown() {
        this.replicaManager().shutdown(false);
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaQuota mockQuota(long bound) {
        void var3_2;
        ReplicaQuota quota = (ReplicaQuota)EasyMock.createMock(ReplicaQuota.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isThrottled((TopicPartition)EasyMock.anyObject()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        return var3_2;
    }
}

