/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.checkpoints.LeaderEpochCheckpointFile;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u0001\u0003\u0001%\u0011\u0001\u0004T3bI\u0016\u0014X\t]8dQ\u001aKG.Z\"bG\",G+Z:u\u0015\t\u0019A!A\u0003fa>\u001c\u0007N\u0003\u0002\u0006\r\u000511/\u001a:wKJT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006#\u0001!\tAE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"\u0001\u0006\u0001\u000e\u0003\tAqA\u0006\u0001C\u0002\u0013\u0005q#\u0001\u0002uaV\t\u0001\u0004\u0005\u0002\u001aC5\t!D\u0003\u0002\u001c9\u000511m\\7n_:T!aB\u000f\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0005\u0003Ei\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004%\u0001\u0001\u0006I\u0001G\u0001\u0004iB\u0004\u0003\"\u0003\u0014\u0001\u0001\u0004\u0005\r\u0011\"\u0001(\u0003)\u0019\u0007.Z2la>Lg\u000e^\u000b\u0002QA\u0011\u0011\u0006L\u0007\u0002U)\u00111\u0006B\u0001\fG\",7m\u001b9pS:$8/\u0003\u0002.U\t)B*Z1eKJ,\u0005o\\2i\u0007\",7m\u001b9pS:$\b\"C\u0018\u0001\u0001\u0004\u0005\r\u0011\"\u00011\u00039\u0019\u0007.Z2la>Lg\u000e^0%KF$\"!\r\u001b\u0011\u0005-\u0011\u0014BA\u001a\r\u0005\u0011)f.\u001b;\t\u000fUr\u0013\u0011!a\u0001Q\u0005\u0019\u0001\u0010J\u0019\t\r]\u0002\u0001\u0015)\u0003)\u0003-\u0019\u0007.Z2la>Lg\u000e\u001e\u0011\t\u000be\u0002A\u0011\u0001\u001e\u0002KMDw.\u001e7e\u0003\u0012$W\t]8dQ\u0006sG-T3tg\u0006<Wm\u00144gg\u0016$Hk\\\"bG\",G#A\u0019)\u0005ab\u0004CA\u001fA\u001b\u0005q$BA  \u0003\u0015QWO\\5u\u0013\t\teH\u0001\u0003UKN$\b\"B\"\u0001\t\u0003Q\u0014AL:i_VdGMU3ukJtGj\\4F]\u0012|eMZ:fi&3G*\u0019;fgR,\u0005o\\2i%\u0016\fX/Z:uK\u0012D#A\u0011\u001f\t\u000b\u0019\u0003A\u0011\u0001\u001e\u0002iMDw.\u001e7e%\u0016$XO\u001d8V]\u0012,g-\u001b8fI>3gm]3u\u0013\u001a,f\u000eZ3gS:,G-\u00129pG\"\u0014V-];fgR,G\r\u000b\u0002Fy!)\u0011\n\u0001C\u0001u\u0005\u00115\u000f[8vY\u0012tu\u000e^(wKJ<(/\u001b;f\u0019><WI\u001c3PM\u001a\u001cX\r\u001e$pe\u0006cU-\u00193fe\u0016\u0003xn\u00195P]\u000e,\u0017\n\u001e%bg\n+WM\\!tg&<g.\u001a3)\u0005!c\u0004\"\u0002'\u0001\t\u0003Q\u0014!M:i_VdG-\u00117m_^dU-\u00193fe\u0016\u0003xn\u00195U_\u000eC\u0017M\\4f\u000bZ,g.\u00134PM\u001a\u001cX\r\u001e#pKNtu\u000e\u001e\u0015\u0003\u0017rBQa\u0014\u0001\u0005\u0002i\nAh\u001d5pk2$gj\u001c;Pm\u0016\u0014xO]5uK>3gm]3u\r>\u0014\u0018\tT3bI\u0016\u0014X\t]8dQ>s7-Z%u\u0011\u0006\u001c()Z3o\u0003N\u001c\u0018n\u001a8fI\"\u0012a\n\u0010\u0005\u0006%\u0002!\tAO\u0001)g\"|W\u000f\u001c3SKR,(O\\+ogV\u0004\bo\u001c:uK\u0012LeMT8Fa>\u001c\u0007NU3d_J$W\r\u001a\u0015\u0003#rBQ!\u0016\u0001\u0005\u0002i\n!i\u001d5pk2$'+\u001a;ve:,fn];qa>\u0014H/\u001a3JM:{W\t]8dQJ+7m\u001c:eK\u0012\fe\u000eZ+oI\u00164\u0017N\\3e\u000bB|7\r\u001b*fcV,7\u000f^3eQ\t!F\bC\u0003Y\u0001\u0011\u0005!(A\u001dtQ>,H\u000e\u001a*fiV\u0014h.\u00168tkB\u0004xN\u001d;fI&3'+Z9vKN$X\rZ#q_\u000eDG*Z:t)\"\fgNR5sgR,\u0005o\\2iQ\t9F\bC\u0003\\\u0001\u0011\u0005!(\u0001%tQ>,H\u000eZ$fi\u001aK'o\u001d;PM\u001a\u001cX\r^(g'V\u00147/Z9vK:$X\t]8dQ^CWM\\(gMN,GOU3rk\u0016\u001cH/\u001a3G_J\u0004&/\u001a<j_V\u001cX\t]8dQ\"\u0012!\f\u0010\u0005\u0006=\u0002!\tAO\u0001Fg\"|W\u000f\u001c3SKR,(O\u001c(fqR\fe/Y5mC\ndW-\u00129pG\"Le\r\u00165fe\u0016L5OT8Fq\u0006\u001cG/\u00129pG\"4uN\u001d+iK>sWMU3rk\u0016\u001cH/\u001a3)\u0005uc\u0004\"B1\u0001\t\u0003Q\u0014AM:i_VdGMT8u+B$\u0017\r^3Fa>\u001c\u0007.\u00118e'R\f'\u000f^(gMN,G/\u00134Ji\u0012KGMT8u\u0007\"\fgnZ3)\u0005\u0001d\u0004\"\u00023\u0001\t\u0003Q\u0014!R:i_VdGMU3ukJt\u0017J\u001c<bY&$wJ\u001a4tKRLe-\u00129pG\"L5OU3rk\u0016\u001cH/\u001a3XQ&\u001c\u0007.S:O_R\u001cUO\u001d:f]Rd\u0017\u0010\u0016:bG.,G\r\u000b\u0002dy!)q\r\u0001C\u0001u\u0005I3\u000f[8vY\u0012\u001cV\u000f\u001d9peR,\u0005o\\2igRC\u0017\r\u001e#p\u001d>$8\u000b^1si\u001a\u0013x.\u001c.fe>D#A\u001a\u001f\t\u000b)\u0004A\u0011\u0001\u001e\u0002GMDw.\u001e7e!\u0016\u00148/[:u\u000bB|7\r[:CKR<X-\u001a8J]N$\u0018M\\2fg\"\u0012\u0011\u000e\u0010\u0005\u0006[\u0002!\tAO\u00012g\"|W\u000f\u001c3O_RdU\r^#q_\u000eDwi\u001c\"bG.<\u0018M\u001d3t\u000bZ,g.\u00134NKN\u001c\u0018mZ3Fa>\u001c\u0007n\u001d#pQ\taG\bC\u0003q\u0001\u0011\u0005!(\u0001\u001atQ>,H\u000e\u001a(pi2+Go\u00144gg\u0016$8oR8CC\u000e\\w/\u0019:eg\u00163XM\\%g\u000bB|7\r[:Qe><'/Z:tQ\tyG\bC\u0003t\u0001\u0011\u0005!(\u0001\u001btQ>,H\u000eZ%oGJ,\u0017m]3B]\u0012$&/Y2l\u000bB|7\r[:Bg2+\u0017\rZ3sg\u000eC\u0017M\\4f\u001b\u0006t\u0017\u0010V5nKND#A\u001d\u001f\t\u000bY\u0004A\u0011\u0001\u001e\u0002uMDw.\u001e7e\u0013:\u001c'/Z1tK\u0006sG\r\u0016:bG.,\u0005o\\2ig\u0006\u001bhi\u001c7m_^,'OU3dK&4Xm]'b]flUm]:bO\u0016\u001c\bFA;=\u0011\u0015I\b\u0001\"\u0001;\u0003e\u001a\bn\\;mI\u0012\u0013x\u000e]#oiJLWm](o\u000bB|7\r\u001b\"pk:$\u0017M]=XQ\u0016t'+Z7pm&tw\rT1uKN$XI\u001c;sS\u0016\u001c\bF\u0001==\u0011\u0015a\b\u0001\"\u0001;\u0003M\u001a\bn\\;mIB\u0013Xm]3sm\u0016\u0014Vm]3u\u001f\u001a47/\u001a;P]\u000ecW-\u0019:FCJd\u0017.Z:u\u0013\u001a|e.Z#ySN$8\u000f\u000b\u0002|y!)q\u0010\u0001C\u0001u\u0005I4\u000f[8vY\u0012,\u0006\u000fZ1uKN\u000bg/\u001a3PM\u001a\u001cX\r^,iK:|eMZ:fiR{7\t\\3beR{\u0017j\u001d\"fi^,WM\\#q_\u000eD7\u000f\u000b\u0002\u007fy!1\u0011Q\u0001\u0001\u0005\u0002i\nQe\u001d5pk2$gj\u001c;DY\u0016\f'/\u00118zi\"LgnZ%g\u001f\u001a47/\u001a;U_\u0016\u000b'\u000f\\=)\u0007\u0005\rA\b\u0003\u0004\u0002\f\u0001!\tAO\u0001,g\"|W\u000f\u001c3O_R\u001cE.Z1s\u0003:LH\u000f[5oO&3wJ\u001a4tKR$vNR5sgR|eMZ:fi\"\u001a\u0011\u0011\u0002\u001f\t\r\u0005E\u0001\u0001\"\u0001;\u0003%\u001a\bn\\;mIJ+G/Y5o\u0019\u0006$Xm\u001d;Fa>\u001c\u0007n\u00148DY\u0016\f'/\u00117m\u000b\u0006\u0014H.[3ti\"\u001a\u0011q\u0002\u001f\t\r\u0005]\u0001\u0001\"\u0001;\u0003]\u001a\bn\\;mIV\u0003H-\u0019;f\u001f\u001a47/\u001a;CKR<X-\u001a8Fa>\u001c\u0007NQ8v]\u0012\f'/[3t\u001f:\u001cE.Z1s\u000b\u0006\u0014H.[3ti\"\u001a\u0011Q\u0003\u001f\t\r\u0005u\u0001\u0001\"\u0001;\u0003a\u001a\bn\\;mIV\u0003H-\u0019;f\u001f\u001a47/\u001a;CKR<X-\u001a8Fa>\u001c\u0007NQ8v]\u0012\f'/[3t\u001f:\u001cE.Z1s\u000b\u0006\u0014H.[3tiJB3!a\u0007=\u0011\u0019\t\u0019\u0003\u0001C\u0001u\u0005Y4\u000f[8vY\u0012\u0014V\r^1j]2\u000bG/Z:u\u000bB|7\r[(o\u00072,\u0017M]!mY\u0016\u000b'\u000f\\5fgR\fe\u000eZ+qI\u0006$X-\u0013;t\u001f\u001a47/\u001a;)\u0007\u0005\u0005B\b\u0003\u0004\u0002*\u0001!\tAO\u00018g\"|W\u000f\u001c3Ee>\u0004XI\u001c;sS\u0016\u001c()\u001a;xK\u0016tW\t]8dQ\n{WO\u001c3bef<\u0006.\u001a8SK6|g/\u001b8h\u001d\u0016<Xm\u001d;)\u0007\u0005\u001dB\b\u0003\u0004\u00020\u0001!\tAO\u0001\u0016g\"|W\u000f\u001c3DY\u0016\f'/\u00117m\u000b:$(/[3tQ\r\ti\u0003\u0010\u0005\u0007\u0003k\u0001A\u0011\u0001\u001e\u0002_MDw.\u001e7e\u001d>$(+Z:fi\u0016\u0003xn\u00195ISN$xN]=IK\u0006$\u0017JZ+oI\u00164\u0017N\\3e!\u0006\u001c8/\u001a3)\u0007\u0005MB\b\u0003\u0004\u0002<\u0001!\tAO\u00010g\"|W\u000f\u001c3O_R\u0014Vm]3u\u000bB|7\r\u001b%jgR|'/\u001f+bS2Le-\u00168eK\u001aLg.\u001a3QCN\u001cX\r\u001a\u0015\u0004\u0003sa\u0004BBA!\u0001\u0011\u0005!(\u0001\u0012tQ>,H\u000e\u001a$fi\u000eDG*\u0019;fgR,\u0005o\\2i\u001f\u001a,U\u000e\u001d;z\u0007\u0006\u001c\u0007.\u001a\u0015\u0004\u0003\u007fa\u0004BBA$\u0001\u0011\u0005!(\u0001\u0011tQ>,H\u000e\u001a$fi\u000eDWI\u001c3PM\u001a\u001cX\r^(g\u000b6\u0004H/_\"bG\",\u0007fAA#y!1\u0011Q\n\u0001\u0005\u0002i\nqd\u001d5pk2$7\t\\3be\u0016\u000b'\u000f\\5fgR|e.R7qif\u001c\u0015m\u00195fQ\r\tY\u0005\u0010\u0005\u0007\u0003'\u0002A\u0011\u0001\u001e\u0002;MDw.\u001e7e\u00072,\u0017M\u001d'bi\u0016\u001cHo\u00148F[B$\u0018pQ1dQ\u0016D3!!\u0015=\u0011\u0019\tI\u0006\u0001C\u0001u\u0005)1/\u001a;Va\"\"\u0011qKA/!\ri\u0014qL\u0005\u0004\u0003Cr$A\u0002\"fM>\u0014X\r")
public class LeaderEpochFileCacheTest {
    private final TopicPartition tp = new TopicPartition("TestTopic", 5);
    private LeaderEpochCheckpoint checkpoint;

    public TopicPartition tp() {
        return this.tp;
    }

    public LeaderEpochCheckpoint checkpoint() {
        return this.checkpoint;
    }

    public void checkpoint_$eq(LeaderEpochCheckpoint x$1) {
        this.checkpoint = x$1;
    }

    @Test
    public void shouldAddEpochAndMessageOffsetToCache() {
        IntRef leo = IntRef.create((int)0);
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this, leo){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;
            private final IntRef leo$1;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$1(this.leo$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leo$1 = leo$1;
            }
        }, this.checkpoint());
        cache.assign(2, 10L);
        leo.elem = 11;
        Assert.assertEquals((long)2L, (long)cache.latestEpoch());
        Assert.assertEquals((Object)new EpochEntry(2, 10L), (Object)cache.epochEntries().apply(0));
        Assert.assertEquals((long)11L, (long)cache.endOffsetFor(2));
    }

    @Test
    public void shouldReturnLogEndOffsetIfLatestEpochRequested() {
        IntRef leo = IntRef.create((int)0);
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this, leo){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;
            private final IntRef leo$2;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$2(this.leo$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leo$2 = leo$2;
            }
        }, this.checkpoint());
        cache.assign(2, 11L);
        cache.assign(2, 12L);
        leo.elem = 14;
        Assert.assertEquals((long)14L, (long)cache.endOffsetFor(2));
    }

    @Test
    public void shouldReturnUndefinedOffsetIfUndefinedEpochRequested() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$3();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.assign(2, 11L);
        cache.assign(3, 12L);
        long offsetFor = cache.endOffsetFor(-1);
        Assert.assertEquals((long)-1L, (long)offsetFor);
    }

    @Test
    public void shouldNotOverwriteLogEndOffsetForALeaderEpochOnceItHasBeenAssigned() {
        IntRef leo = IntRef.create((int)0);
        leo.elem = 9;
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this, leo){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;
            private final IntRef leo$3;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$4(this.leo$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leo$3 = leo$3;
            }
        }, this.checkpoint());
        cache.assign(2, (long)leo.elem);
        cache.assign(2, 10L);
        Assert.assertEquals((long)leo.elem, (long)((EpochEntry)cache.epochEntries().apply(0)).startOffset());
    }

    @Test
    public void shouldAllowLeaderEpochToChangeEvenIfOffsetDoesNot() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$5();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.assign(2, 9L);
        cache.assign(3, 9L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 9L), new EpochEntry(3, 9L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldNotOverwriteOffsetForALeaderEpochOnceItHasBeenAssigned() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LogOffsetMetadata apply() {
                return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
            }
        }, this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(2, 10L);
        Assert.assertEquals((long)6L, (long)((EpochEntry)cache.epochEntries().apply(0)).startOffset());
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecorded() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$6();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        Assert.assertEquals((long)-1L, (long)cache.endOffsetFor(0));
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecordedAndUndefinedEpochRequested() {
        int leo = 73;
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this, leo){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;
            private final int leo$4;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$7(this.leo$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leo$4 = leo$4;
            }
        }, this.checkpoint());
        long offsetFor = cache.endOffsetFor(-1);
        Assert.assertEquals((long)-1L, (long)offsetFor);
    }

    @Test
    public void shouldReturnUnsupportedIfRequestedEpochLessThanFirstEpoch() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$8();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.assign(5, 11L);
        cache.assign(6, 12L);
        cache.assign(7, 13L);
        long offset = cache.endOffsetFor(4);
        Assert.assertEquals((long)-1L, (long)offset);
    }

    @Test
    public void shouldGetFirstOffsetOfSubsequentEpochWhenOffsetRequestedForPreviousEpoch() {
        IntRef leo = IntRef.create((int)0);
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this, leo){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;
            private final IntRef leo$5;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$9(this.leo$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leo$5 = leo$5;
            }
        }, this.checkpoint());
        cache.assign(1, 11L);
        cache.assign(1, 12L);
        cache.assign(2, 13L);
        cache.assign(2, 14L);
        cache.assign(3, 15L);
        cache.assign(3, 16L);
        leo.elem = 17;
        Assert.assertEquals((long)15L, (long)cache.endOffsetFor(2));
    }

    @Test
    public void shouldReturnNextAvailableEpochIfThereIsNoExactEpochForTheOneRequested() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$10();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.assign(0, 10L);
        cache.assign(2, 13L);
        cache.assign(4, 17L);
        Assert.assertEquals((long)13L, (long)cache.endOffsetFor(1));
        Assert.assertEquals((long)17L, (long)cache.endOffsetFor(2));
    }

    @Test
    public void shouldNotUpdateEpochAndStartOffsetIfItDidNotChange() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$11();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(2, 7L);
        Assert.assertEquals((long)1L, (long)cache.epochEntries().size());
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)cache.epochEntries().toList().apply(0));
    }

    @Test
    public void shouldReturnInvalidOffsetIfEpochIsRequestedWhichIsNotCurrentlyTracked() {
        int leo = 100;
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this, leo){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;
            private final int leo$6;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$12(this.leo$6);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leo$6 = leo$6;
            }
        }, this.checkpoint());
        cache.assign(2, 100L);
        Assert.assertEquals((long)-1L, (long)cache.endOffsetFor(3));
    }

    @Test
    public void shouldSupportEpochsThatDoNotStartFromZero() {
        IntRef leo = IntRef.create((int)0);
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this, leo){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;
            private final IntRef leo$7;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$13(this.leo$7);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leo$7 = leo$7;
            }
        }, this.checkpoint());
        cache.assign(2, 6L);
        leo.elem = 7;
        Assert.assertEquals((long)leo.elem, (long)cache.endOffsetFor(2));
        Assert.assertEquals((long)1L, (long)cache.epochEntries().size());
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)cache.epochEntries().apply(0));
    }

    @Test
    public void shouldPersistEpochsBetweenInstances() {
        String checkpointPath = TestUtils$.MODULE$.tempFile().getAbsolutePath();
        this.checkpoint_$eq((LeaderEpochCheckpoint)new LeaderEpochCheckpointFile(new File(checkpointPath)));
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$14();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.assign(2, 6L);
        LeaderEpochCheckpointFile checkpoint2 = new LeaderEpochCheckpointFile(new File(checkpointPath));
        LeaderEpochFileCache cache2 = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$14();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (LeaderEpochCheckpoint)checkpoint2);
        Assert.assertEquals((long)1L, (long)cache2.epochEntries().size());
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)cache2.epochEntries().toList().apply(0));
    }

    @Test
    public void shouldNotLetEpochGoBackwardsEvenIfMessageEpochsDo() {
        IntRef leo = IntRef.create((int)0);
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this, leo){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;
            private final IntRef leo$8;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$15(this.leo$8);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leo$8 = leo$8;
            }
        }, this.checkpoint());
        cache.assign(1, 5L);
        leo.elem = 6;
        cache.assign(2, 6L);
        leo.elem = 7;
        cache.assign(1, 7L);
        leo.elem = 8;
        Assert.assertEquals((long)2L, (long)cache.latestEpoch());
        Assert.assertEquals((long)6L, (long)cache.endOffsetFor(1));
        Assert.assertEquals((long)8L, (long)cache.endOffsetFor(2));
        Assert.assertEquals((Object)new EpochEntry(1, 5L), (Object)cache.epochEntries().apply(0));
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)cache.epochEntries().apply(1));
    }

    @Test
    public void shouldNotLetOffsetsGoBackwardsEvenIfEpochsProgress() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$16();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 5L);
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)cache.epochEntries().toList().apply(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsLeadersChangeManyTimes() {
        IntRef leo = IntRef.create((int)0);
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this, leo){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;
            private final IntRef leo$9;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$17(this.leo$9);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leo$9 = leo$9;
            }
        }, this.checkpoint());
        cache.assign(0, 0L);
        cache.assign(1, 0L);
        Assert.assertEquals((long)1L, (long)cache.latestEpoch());
        Assert.assertEquals((long)0L, (long)cache.endOffsetFor(1));
        Assert.assertEquals((long)0L, (long)cache.endOffsetFor(0));
        leo.elem = 5;
        Assert.assertEquals((long)5L, (long)cache.endOffsetFor(1));
        Assert.assertEquals((long)0L, (long)cache.endOffsetFor(0));
        cache.assign(2, 5L);
        leo.elem = 10;
        Assert.assertEquals((long)10L, (long)cache.endOffsetFor(2));
        Assert.assertEquals((long)5L, (long)cache.endOffsetFor(1));
        Assert.assertEquals((long)0L, (long)cache.endOffsetFor(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsFollowerReceivesManyMessages() {
        IntRef leo = IntRef.create((int)0);
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this, leo){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;
            private final IntRef leo$10;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$18(this.leo$10);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leo$10 = leo$10;
            }
        }, this.checkpoint());
        cache.assign(0, 0L);
        leo.elem = 1;
        cache.assign(0, 1L);
        leo.elem = 2;
        cache.assign(0, 2L);
        leo.elem = 3;
        Assert.assertEquals((long)0L, (long)cache.latestEpoch());
        Assert.assertEquals((long)leo.elem, (long)cache.endOffsetFor(0));
        cache.assign(1, 3L);
        leo.elem = 4;
        cache.assign(1, 4L);
        leo.elem = 5;
        cache.assign(1, 5L);
        leo.elem = 6;
        Assert.assertEquals((long)1L, (long)cache.latestEpoch());
        Assert.assertEquals((long)leo.elem, (long)cache.endOffsetFor(1));
        cache.assign(2, 6L);
        leo.elem = 7;
        cache.assign(2, 7L);
        leo.elem = 8;
        cache.assign(2, 8L);
        leo.elem = 9;
        Assert.assertEquals((long)2L, (long)cache.latestEpoch());
        Assert.assertEquals((long)leo.elem, (long)cache.endOffsetFor(2));
        Assert.assertEquals((long)3L, (long)cache.endOffsetFor(0));
        Assert.assertEquals((long)6L, (long)cache.endOffsetFor(1));
    }

    @Test
    public void shouldDropEntriesOnEpochBoundaryWhenRemovingLatestEntries() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$19();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushLatest(8L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldPreserveResetOffsetOnClearEarliestIfOneExists() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$20();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(8L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldUpdateSavedOffsetWhenOffsetToClearToIsBetweenEpochs() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$21();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(9L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToEarly() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$22();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(1L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToFirstOffset() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$23();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(6L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliest() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$24();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(11L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 11L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$25();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(9L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest2() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$26();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.assign(0, 0L);
        cache.assign(1, 7L);
        cache.assign(2, 10L);
        cache.clearAndFlushEarliest(5L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 5L), new EpochEntry(1, 7L), new EpochEntry(2, 10L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliestAndUpdateItsOffset() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$27();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(15L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 15L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldDropEntriesBetweenEpochBoundaryWhenRemovingNewest() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$28();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushLatest(9L);
        Assert.assertEquals((long)3L, (long)cache.latestEpoch());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldClearAllEntries() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$29();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlush();
        Assert.assertEquals((long)0L, (long)cache.epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryHeadIfUndefinedPassed() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$30();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushLatest(-1L);
        Assert.assertEquals((long)3L, (long)cache.epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryTailIfUndefinedPassed() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$31();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(-1L);
        Assert.assertEquals((long)3L, (long)cache.epochEntries().size());
    }

    @Test
    public void shouldFetchLatestEpochOfEmptyCache() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$32();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        Assert.assertEquals((long)-1L, (long)cache.latestEpoch());
    }

    @Test
    public void shouldFetchEndOffsetOfEmptyCache() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$33();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        Assert.assertEquals((long)-1L, (long)cache.endOffsetFor(7));
    }

    @Test
    public void shouldClearEarliestOnEmptyCache() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$34();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.clearAndFlushEarliest(7L);
    }

    @Test
    public void shouldClearLatestOnEmptyCache() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final LogOffsetMetadata apply() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$35();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.checkpoint());
        cache.clearAndFlushLatest(7L);
    }

    @Before
    public void setUp() {
        this.checkpoint_$eq((LeaderEpochCheckpoint)new LeaderEpochCheckpointFile(TestUtils$.MODULE$.tempFile()));
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$1(IntRef leo$1) {
        return new LogOffsetMetadata((long)leo$1.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$2(IntRef leo$2) {
        return new LogOffsetMetadata((long)leo$2.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$3() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$4(IntRef leo$3) {
        return new LogOffsetMetadata((long)leo$3.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$5() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$6() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$7(int leo$4) {
        return new LogOffsetMetadata((long)leo$4, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$8() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$9(IntRef leo$5) {
        return new LogOffsetMetadata((long)leo$5.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$10() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$11() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$12(int leo$6) {
        return new LogOffsetMetadata((long)leo$6, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$13(IntRef leo$7) {
        return new LogOffsetMetadata((long)leo$7.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$14() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$15(IntRef leo$8) {
        return new LogOffsetMetadata((long)leo$8.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$16() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$17(IntRef leo$9) {
        return new LogOffsetMetadata((long)leo$9.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$18(IntRef leo$10) {
        return new LogOffsetMetadata((long)leo$10.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$19() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$20() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$21() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$22() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$23() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$24() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$25() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$26() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$27() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$28() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$29() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$30() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$31() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$32() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$33() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$34() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public final LogOffsetMetadata kafka$server$epoch$LeaderEpochFileCacheTest$$leoFinder$35() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }
}

