/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ReplicationUtils$;
import kafka.utils.ZkUtils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0001\u0003\u0001\u001d\u00111CU3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016T!a\u0001\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0004\u0001\t\u0005\t\u0015!\u0003\u0016!\t1r#D\u0001\u0003\u0013\tA\"AA\bLC\u001a\\\u0017mQ8oiJ|G\u000e\\3s\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\u0011A$\b\t\u0003-\u0001AQaA\rA\u0002UAqa\b\u0001C\u0002\u0013%\u0001%A\td_:$(o\u001c7mKJ\u001cuN\u001c;fqR,\u0012!\t\t\u0003-\tJ!a\t\u0002\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\u0003\u0004&\u0001\u0001\u0006I!I\u0001\u0013G>tGO]8mY\u0016\u00148i\u001c8uKb$\b\u0005C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\u0002\u0019\r|g\u000e\u001e:pY2,'/\u00133\u0016\u0003%\u0002\"!\u0003\u0016\n\u0005-R!aA%oi\"1Q\u0006\u0001Q\u0001\n%\nQbY8oiJ|G\u000e\\3s\u0013\u0012\u0004\u0003bB\u0018\u0001\u0005\u0004%I\u0001M\u0001\bu.,F/\u001b7t+\u0005\t\u0004CA\b3\u0013\t\u0019\u0004CA\u0004[WV#\u0018\u000e\\:\t\rU\u0002\u0001\u0015!\u00032\u0003!Q8.\u0016;jYN\u0004\u0003bB\u001c\u0001\u0005\u0004%I\u0001O\u0001\re\u0016\u0004H.[2b'R\fG/Z\u000b\u0002sA!!hP!E\u001b\u0005Y$B\u0001\u001f>\u0003\u001diW\u000f^1cY\u0016T!A\u0010\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002Aw\t\u0019Q*\u00199\u0011\u0005Y\u0011\u0015BA\"\u0003\u0005M\u0001\u0016M\u001d;ji&|g.\u00118e%\u0016\u0004H.[2b!\t1R)\u0003\u0002G\u0005\ta!+\u001a9mS\u000e\f7\u000b^1uK\"1\u0001\n\u0001Q\u0001\ne\nQB]3qY&\u001c\u0017m\u0015;bi\u0016\u0004\u0003b\u0002&\u0001\u0005\u0004%IaS\u0001\u0013EJ|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007.F\u0001M!\t1R*\u0003\u0002O\u0005\ta2i\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007B\u0002)\u0001A\u0003%A*A\nce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007\u0005C\u0004S\u0001\t\u0007I\u0011B*\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/F\u0001U!\t)\u0006L\u0004\u0002\u0017-&\u0011qKA\u0001\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe&\u0011\u0011L\u0017\u0002\u0012'R\fG/Z\"iC:<W\rT8hO\u0016\u0014(BA,\u0003\u0011\u0019a\u0006\u0001)A\u0005)\u0006\u00112\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:!\u0011\u0015q\u0006\u0001\"\u0001`\u0003\u001d\u0019H/\u0019:ukB$\u0012\u0001\u0019\t\u0003\u0013\u0005L!A\u0019\u0006\u0003\tUs\u0017\u000e\u001e\u0005\u0006I\u0002!\taX\u0001\tg\",H\u000fZ8x]\")a\r\u0001C\u0001O\u0006\u0011\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3t)\u0011\u0001\u0007N\u001c9\t\u000b%,\u0007\u0019\u00016\u0002\u0011I,\u0007\u000f\\5dCN\u00042a\u001b7B\u001b\u0005i\u0014BA7>\u0005\r\u0019V\r\u001e\u0005\u0006_\u0016\u0004\r\u0001R\u0001\fi\u0006\u0014x-\u001a;Ti\u0006$X\rC\u0004rKB\u0005\t\u0019\u0001:\u0002\u0013\r\fG\u000e\u001c2bG.\u001c\bC\u0001\ft\u0013\t!(AA\u0005DC2d'-Y2lg\")a\u000f\u0001C\u0001o\u0006\t\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3\u0015\t\u0001D(p\u001f\u0005\u0006sV\u0004\r!Q\u0001\u0014a\u0006\u0014H/\u001b;j_:\fe\u000e\u001a*fa2L7-\u0019\u0005\u0006_V\u0004\r\u0001\u0012\u0005\u0006cV\u0004\rA\u001d\u0005\u0006{\u0002!\tA`\u0001\u001eCJ,\u0017\t\u001c7SKBd\u0017nY1t\r>\u0014Hk\u001c9jG\u0012+G.\u001a;fIR\u0019q0!\u0002\u0011\u0007%\t\t!C\u0002\u0002\u0004)\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002\bq\u0004\r!!\u0003\u0002\u000bQ|\u0007/[2\u0011\t\u0005-\u0011\u0011\u0003\b\u0004\u0013\u00055\u0011bAA\b\u0015\u00051\u0001K]3eK\u001aLA!a\u0005\u0002\u0016\t11\u000b\u001e:j]\u001eT1!a\u0004\u000b\u0011\u001d\tI\u0002\u0001C\u0001\u00037\t\u0011&[:Bi2+\u0017m\u001d;P]\u0016\u0014V\r\u001d7jG\u0006Le\u000eR3mKRLwN\\*uCJ$X\rZ*uCR,GcA@\u0002\u001e!A\u0011qAA\f\u0001\u0004\tI\u0001C\u0004\u0002\"\u0001!\t!a\t\u0002\u001fI,\u0007\u000f\\5dCNLen\u0015;bi\u0016$RA[A\u0013\u0003OA\u0001\"a\u0002\u0002 \u0001\u0007\u0011\u0011\u0002\u0005\b\u0003S\ty\u00021\u0001E\u0003\u0015\u0019H/\u0019;f\u0011\u001d\ti\u0003\u0001C\u0001\u0003_\t1#[:B]f\u0014V\r\u001d7jG\u0006Len\u0015;bi\u0016$Ra`A\u0019\u0003gA\u0001\"a\u0002\u0002,\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003S\tY\u00031\u0001E\u0011\u001d\t9\u0004\u0001C\u0001\u0003s\t\u0001D]3qY&\u001c\u0017m]%o\t\u0016dW\r^5p]N#\u0018\r^3t)\rQ\u00171\b\u0005\t\u0003\u000f\t)\u00041\u0001\u0002\n!9\u0011q\b\u0001\u0005\n\u0005\u0005\u0013!F1tg\u0016\u0014HOV1mS\u0012$&/\u00198tSRLwN\u001c\u000b\u0006A\u0006\r\u0013Q\t\u0005\u0007s\u0006u\u0002\u0019A!\t\r=\fi\u00041\u0001E\u0011\u0019\tI\u0005\u0001C\u0005?\u00061\u0012N\\5uS\u0006d\u0017N_3SKBd\u0017nY1Ti\u0006$X\rC\u0004\u0002N\u0001!\t!a\u0014\u00025A\f'\u000f^5uS>t7/Q:tS\u001etW\r\u001a+p\u0005J|7.\u001a:\u0015\r\u0005E\u00131MA5!\u0015Y\u00171KA,\u0013\r\t)&\u0010\u0002\u0004'\u0016\f\b\u0003BA-\u0003?j!!a\u0017\u000b\u0007\u0005uC!\u0001\u0004d_6lwN\\\u0005\u0005\u0003C\nYFA\tU_BL7-\u00118e!\u0006\u0014H/\u001b;j_:D\u0001\"!\u001a\u0002L\u0001\u0007\u0011qM\u0001\u0007i>\u0004\u0018nY:\u0011\u000b-\f\u0019&!\u0003\t\u000f\u0005-\u00141\na\u0001S\u0005A!M]8lKJLE\rC\u0005\u0002p\u0001\t\n\u0011\"\u0001\u0002r\u0005a\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3tI\u0011,g-Y;mi\u0012\u001aTCAA:U\r\u0011\u0018QO\u0016\u0003\u0003o\u0002B!!\u001f\u0002\u00046\u0011\u00111\u0010\u0006\u0005\u0003{\ny(A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0011\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0006\u0006m$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ReplicaStateMachine
implements Logging {
    public final KafkaController kafka$controller$ReplicaStateMachine$$controller;
    private final ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext;
    private final int kafka$controller$ReplicaStateMachine$$controllerId;
    private final ZkUtils zkUtils;
    private final Map<PartitionAndReplica, ReplicaState> kafka$controller$ReplicaStateMachine$$replicaState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final KafkaController.StateChangeLogger stateChangeLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReplicaStateMachine replicaStateMachine = this;
        synchronized (replicaStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext() {
        return this.kafka$controller$ReplicaStateMachine$$controllerContext;
    }

    public int kafka$controller$ReplicaStateMachine$$controllerId() {
        return this.kafka$controller$ReplicaStateMachine$$controllerId;
    }

    private ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public Map<PartitionAndReplica, ReplicaState> kafka$controller$ReplicaStateMachine$$replicaState() {
        return this.kafka$controller$ReplicaStateMachine$$replicaState;
    }

    private ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    private KafkaController.StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public void startup() {
        this.initializeReplicaState();
        this.handleStateChanges(this.kafka$controller$ReplicaStateMachine$$controllerContext().allLiveReplicas(), OnlineReplica$.MODULE$, this.handleStateChanges$default$3());
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Started replica state machine with initial state -> ").append((Object)this.$outer.kafka$controller$ReplicaStateMachine$$replicaState().toString()).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void shutdown() {
        this.kafka$controller$ReplicaStateMachine$$replicaState().clear();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopped replica state machine";
            }
        });
    }

    public void handleStateChanges(Set<PartitionAndReplica> replicas, ReplicaState targetState, Callbacks callbacks) {
        if (replicas.nonEmpty()) {
            this.info((Function0<String>)new Serializable(this, replicas, targetState){
                public static final long serialVersionUID = 0L;
                private final Set replicas$1;
                private final ReplicaState targetState$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Invoking state change to %s for replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1, this.replicas$1.mkString(",")}));
                }
                {
                    this.replicas$1 = replicas$1;
                    this.targetState$1 = targetState$1;
                }
            });
            try {
                this.brokerRequestBatch().newBatch();
                replicas.foreach((Function1)new Serializable(this, targetState, callbacks){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaStateMachine $outer;
                    private final ReplicaState targetState$1;
                    private final Callbacks callbacks$1;

                    public final void apply(PartitionAndReplica r) {
                        this.$outer.handleStateChange(r, this.targetState$1, this.callbacks$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.targetState$1 = targetState$1;
                        this.callbacks$1 = callbacks$1;
                    }
                });
                this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$ReplicaStateMachine$$controller.epoch());
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)new Serializable(this, targetState){
                    public static final long serialVersionUID = 0L;
                    private final ReplicaState targetState$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Error while moving some replicas to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                    }
                    {
                        this.targetState$1 = targetState$1;
                    }
                }, (Function0<Throwable>)new Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$1;

                    public final Throwable apply() {
                        return this.e$1;
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
            }
        }
    }

    public void handleStateChange(PartitionAndReplica partitionAndReplica, ReplicaState targetState, Callbacks callbacks) {
        block15: {
            String topic = partitionAndReplica.topic();
            int partition = partitionAndReplica.partition();
            int replicaId = partitionAndReplica.replica();
            TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
            ReplicaState currState = (ReplicaState)this.kafka$controller$ReplicaStateMachine$$replicaState().getOrElseUpdate((Object)partitionAndReplica, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final NonExistentReplica$ apply() {
                    return NonExistentReplica$.MODULE$;
                }
            });
            try {
                ReplicaState replicaState;
                block26: {
                    Option option;
                    block32: {
                        boolean bl;
                        block31: {
                            block27: {
                                Option<LeaderIsrAndControllerEpoch> option2;
                                block30: {
                                    boolean bl2;
                                    block29: {
                                        block28: {
                                            Seq replicaAssignment;
                                            block20: {
                                                Option option3;
                                                block25: {
                                                    block22: {
                                                        block24: {
                                                            block23: {
                                                                block21: {
                                                                    block16: {
                                                                        Option<LeaderIsrAndControllerEpoch> option4;
                                                                        block19: {
                                                                            block18: {
                                                                                block17: {
                                                                                    replicaAssignment = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                                                                                    this.assertValidTransition(partitionAndReplica, targetState);
                                                                                    replicaState = targetState;
                                                                                    if (!NewReplica$.MODULE$.equals(replicaState)) break block16;
                                                                                    Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt = ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkUtils(), topic, partition);
                                                                                    option4 = leaderIsrAndControllerEpochOpt;
                                                                                    if (!(option4 instanceof Some)) break block17;
                                                                                    Some some = (Some)option4;
                                                                                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                                                                    if (leaderIsrAndControllerEpoch.leaderAndIsr().leader() == replicaId) {
                                                                                        throw new StateChangeFailedException(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Replica %d for partition %s cannot be moved to NewReplica")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition}))).append((Object)"state as it is being requested to become leader").toString());
                                                                                    }
                                                                                    this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, leaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                    break block18;
                                                                                }
                                                                                if (!None$.MODULE$.equals(option4)) break block19;
                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                            }
                                                                            this.kafka$controller$ReplicaStateMachine$$replicaState().put((Object)partitionAndReplica, (Object)NewReplica$.MODULE$);
                                                                            this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState, replicaId, topicAndPartition, currState){
                                                                                public static final long serialVersionUID = 0L;
                                                                                private final /* synthetic */ ReplicaStateMachine $outer;
                                                                                private final ReplicaState targetState$2;
                                                                                private final int replicaId$1;
                                                                                private final TopicAndPartition topicAndPartition$1;
                                                                                private final ReplicaState currState$1;

                                                                                public final String apply() {
                                                                                    return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ReplicaStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)this.replicaId$1), this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                                                                                }
                                                                                {
                                                                                    if ($outer == null) {
                                                                                        throw null;
                                                                                    }
                                                                                    this.$outer = $outer;
                                                                                    this.targetState$2 = targetState$2;
                                                                                    this.replicaId$1 = replicaId$1;
                                                                                    this.topicAndPartition$1 = topicAndPartition$1;
                                                                                    this.currState$1 = currState$1;
                                                                                }
                                                                            });
                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                            break block15;
                                                                        }
                                                                        throw new MatchError(option4);
                                                                    }
                                                                    if (ReplicaDeletionStarted$.MODULE$.equals(replicaState)) {
                                                                        this.kafka$controller$ReplicaStateMachine$$replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionStarted$.MODULE$);
                                                                        this.brokerRequestBatch().addStopReplicaRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, true, callbacks.stopReplicaResponseCallback());
                                                                        this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState, replicaId, topicAndPartition, currState){
                                                                            public static final long serialVersionUID = 0L;
                                                                            private final /* synthetic */ ReplicaStateMachine $outer;
                                                                            private final ReplicaState targetState$2;
                                                                            private final int replicaId$1;
                                                                            private final TopicAndPartition topicAndPartition$1;
                                                                            private final ReplicaState currState$1;

                                                                            public final String apply() {
                                                                                return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ReplicaStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)this.replicaId$1), this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                                                                            }
                                                                            {
                                                                                if ($outer == null) {
                                                                                    throw null;
                                                                                }
                                                                                this.$outer = $outer;
                                                                                this.targetState$2 = targetState$2;
                                                                                this.replicaId$1 = replicaId$1;
                                                                                this.topicAndPartition$1 = topicAndPartition$1;
                                                                                this.currState$1 = currState$1;
                                                                            }
                                                                        });
                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                        break block15;
                                                                    }
                                                                    if (ReplicaDeletionIneligible$.MODULE$.equals(replicaState)) {
                                                                        this.kafka$controller$ReplicaStateMachine$$replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionIneligible$.MODULE$);
                                                                        this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState, replicaId, topicAndPartition, currState){
                                                                            public static final long serialVersionUID = 0L;
                                                                            private final /* synthetic */ ReplicaStateMachine $outer;
                                                                            private final ReplicaState targetState$2;
                                                                            private final int replicaId$1;
                                                                            private final TopicAndPartition topicAndPartition$1;
                                                                            private final ReplicaState currState$1;

                                                                            public final String apply() {
                                                                                return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ReplicaStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)this.replicaId$1), this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                                                                            }
                                                                            {
                                                                                if ($outer == null) {
                                                                                    throw null;
                                                                                }
                                                                                this.$outer = $outer;
                                                                                this.targetState$2 = targetState$2;
                                                                                this.replicaId$1 = replicaId$1;
                                                                                this.topicAndPartition$1 = topicAndPartition$1;
                                                                                this.currState$1 = currState$1;
                                                                            }
                                                                        });
                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                        break block15;
                                                                    }
                                                                    if (ReplicaDeletionSuccessful$.MODULE$.equals(replicaState)) {
                                                                        this.kafka$controller$ReplicaStateMachine$$replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionSuccessful$.MODULE$);
                                                                        this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState, replicaId, topicAndPartition, currState){
                                                                            public static final long serialVersionUID = 0L;
                                                                            private final /* synthetic */ ReplicaStateMachine $outer;
                                                                            private final ReplicaState targetState$2;
                                                                            private final int replicaId$1;
                                                                            private final TopicAndPartition topicAndPartition$1;
                                                                            private final ReplicaState currState$1;

                                                                            public final String apply() {
                                                                                return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ReplicaStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)this.replicaId$1), this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                                                                            }
                                                                            {
                                                                                if ($outer == null) {
                                                                                    throw null;
                                                                                }
                                                                                this.$outer = $outer;
                                                                                this.targetState$2 = targetState$2;
                                                                                this.replicaId$1 = replicaId$1;
                                                                                this.topicAndPartition$1 = topicAndPartition$1;
                                                                                this.currState$1 = currState$1;
                                                                            }
                                                                        });
                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                        break block15;
                                                                    }
                                                                    if (NonExistentReplica$.MODULE$.equals(replicaState)) {
                                                                        Seq currentAssignedReplicas = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                                                                        this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, currentAssignedReplicas.filterNot((Function1)new Serializable(this, replicaId){
                                                                            public static final long serialVersionUID = 0L;
                                                                            private final int replicaId$1;

                                                                            public final boolean apply(int x$1) {
                                                                                return this.apply$mcZI$sp(x$1);
                                                                            }

                                                                            public boolean apply$mcZI$sp(int x$1) {
                                                                                return x$1 == this.replicaId$1;
                                                                            }
                                                                            {
                                                                                this.replicaId$1 = replicaId$1;
                                                                            }
                                                                        }));
                                                                        this.kafka$controller$ReplicaStateMachine$$replicaState().remove((Object)partitionAndReplica);
                                                                        this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState, replicaId, topicAndPartition, currState){
                                                                            public static final long serialVersionUID = 0L;
                                                                            private final /* synthetic */ ReplicaStateMachine $outer;
                                                                            private final ReplicaState targetState$2;
                                                                            private final int replicaId$1;
                                                                            private final TopicAndPartition topicAndPartition$1;
                                                                            private final ReplicaState currState$1;

                                                                            public final String apply() {
                                                                                return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ReplicaStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)this.replicaId$1), this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                                                                            }
                                                                            {
                                                                                if ($outer == null) {
                                                                                    throw null;
                                                                                }
                                                                                this.$outer = $outer;
                                                                                this.targetState$2 = targetState$2;
                                                                                this.replicaId$1 = replicaId$1;
                                                                                this.topicAndPartition$1 = topicAndPartition$1;
                                                                                this.currState$1 = currState$1;
                                                                            }
                                                                        });
                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                        break block15;
                                                                    }
                                                                    if (!OnlineReplica$.MODULE$.equals(replicaState)) break block20;
                                                                    ReplicaState replicaState2 = (ReplicaState)this.kafka$controller$ReplicaStateMachine$$replicaState().apply((Object)partitionAndReplica);
                                                                    if (!NewReplica$.MODULE$.equals(replicaState2)) break block21;
                                                                    Seq currentAssignedReplicas = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                                                                    Object object = currentAssignedReplicas.contains((Object)BoxesRunTime.boxToInteger((int)replicaId)) ? BoxedUnit.UNIT : this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, currentAssignedReplicas.$colon$plus((Object)BoxesRunTime.boxToInteger((int)replicaId), Seq$.MODULE$.canBuildFrom()));
                                                                    this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState, replicaId, topicAndPartition, currState){
                                                                        public static final long serialVersionUID = 0L;
                                                                        private final /* synthetic */ ReplicaStateMachine $outer;
                                                                        private final ReplicaState targetState$2;
                                                                        private final int replicaId$1;
                                                                        private final TopicAndPartition topicAndPartition$1;
                                                                        private final ReplicaState currState$1;

                                                                        public final String apply() {
                                                                            return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ReplicaStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)this.replicaId$1), this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                                                                        }
                                                                        {
                                                                            if ($outer == null) {
                                                                                throw null;
                                                                            }
                                                                            this.$outer = $outer;
                                                                            this.targetState$2 = targetState$2;
                                                                            this.replicaId$1 = replicaId$1;
                                                                            this.topicAndPartition$1 = topicAndPartition$1;
                                                                            this.currState$1 = currState$1;
                                                                        }
                                                                    });
                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                    break block22;
                                                                }
                                                                option3 = this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                                                                if (!(option3 instanceof Some)) break block23;
                                                                Some some = (Some)option3;
                                                                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                                                this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, leaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                                                                this.kafka$controller$ReplicaStateMachine$$replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$);
                                                                this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState, replicaId, topicAndPartition, currState){
                                                                    public static final long serialVersionUID = 0L;
                                                                    private final /* synthetic */ ReplicaStateMachine $outer;
                                                                    private final ReplicaState targetState$2;
                                                                    private final int replicaId$1;
                                                                    private final TopicAndPartition topicAndPartition$1;
                                                                    private final ReplicaState currState$1;

                                                                    public final String apply() {
                                                                        return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ReplicaStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)this.replicaId$1), this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                                                                    }
                                                                    {
                                                                        if ($outer == null) {
                                                                            throw null;
                                                                        }
                                                                        this.$outer = $outer;
                                                                        this.targetState$2 = targetState$2;
                                                                        this.replicaId$1 = replicaId$1;
                                                                        this.topicAndPartition$1 = topicAndPartition$1;
                                                                        this.currState$1 = currState$1;
                                                                    }
                                                                });
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                break block24;
                                                            }
                                                            if (!None$.MODULE$.equals(option3)) break block25;
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        }
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    }
                                                    this.kafka$controller$ReplicaStateMachine$$replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block15;
                                                }
                                                throw new MatchError((Object)option3);
                                            }
                                            if (!OfflineReplica$.MODULE$.equals(replicaState)) break block26;
                                            this.brokerRequestBatch().addStopReplicaRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, false, this.brokerRequestBatch().addStopReplicaRequestForBrokers$default$5());
                                            option = this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                                            if (!(option instanceof Some)) break block27;
                                            option2 = this.kafka$controller$ReplicaStateMachine$$controller.removeReplicaFromIsr(topic, partition, replicaId);
                                            if (!(option2 instanceof Some)) break block28;
                                            Some some = (Some)option2;
                                            LeaderIsrAndControllerEpoch updatedLeaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                            Seq currentAssignedReplicas = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                                            if (!this.kafka$controller$ReplicaStateMachine$$controller.topicDeletionManager().isPartitionToBeDeleted(topicAndPartition)) {
                                                this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)currentAssignedReplicas.filterNot((Function1)new Serializable(this, replicaId){
                                                    public static final long serialVersionUID = 0L;
                                                    private final int replicaId$1;

                                                    public final boolean apply(int x$2) {
                                                        return this.apply$mcZI$sp(x$2);
                                                    }

                                                    public boolean apply$mcZI$sp(int x$2) {
                                                        return x$2 == this.replicaId$1;
                                                    }
                                                    {
                                                        this.replicaId$1 = replicaId$1;
                                                    }
                                                })), topic, partition, updatedLeaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                                            }
                                            this.kafka$controller$ReplicaStateMachine$$replicaState().put((Object)partitionAndReplica, (Object)OfflineReplica$.MODULE$);
                                            this.stateChangeLogger().trace((Function0<String>)new Serializable(this, targetState, replicaId, topicAndPartition, currState){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ ReplicaStateMachine $outer;
                                                private final ReplicaState targetState$2;
                                                private final int replicaId$1;
                                                private final TopicAndPartition topicAndPartition$1;
                                                private final ReplicaState currState$1;

                                                public final String apply() {
                                                    return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ReplicaStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)this.replicaId$1), this.topicAndPartition$1, this.currState$1, this.targetState$2}));
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                    this.targetState$2 = targetState$2;
                                                    this.replicaId$1 = replicaId$1;
                                                    this.topicAndPartition$1 = topicAndPartition$1;
                                                    this.currState$1 = currState$1;
                                                }
                                            });
                                            bl2 = false;
                                            break block29;
                                        }
                                        if (!None$.MODULE$.equals(option2)) break block30;
                                        bl2 = true;
                                    }
                                    bl = bl2;
                                    break block31;
                                }
                                throw new MatchError(option2);
                            }
                            if (!None$.MODULE$.equals(option)) break block32;
                            bl = true;
                        }
                        boolean leaderAndIsrIsEmpty = bl;
                        if (leaderAndIsrIsEmpty && !this.kafka$controller$ReplicaStateMachine$$controller.topicDeletionManager().isPartitionToBeDeleted(topicAndPartition)) {
                            throw new StateChangeFailedException(new StringOps(Predef$.MODULE$.augmentString("Failed to change state of replica %d for partition %s since the leader and isr path in zookeeper is empty")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition})));
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block15;
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError((Object)replicaState);
            }
            catch (Throwable throwable) {
                this.stateChangeLogger().error((Function0<String>)new Serializable(this, targetState, topic, partition, replicaId, currState){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaStateMachine $outer;
                    private final ReplicaState targetState$2;
                    private final String topic$1;
                    private final int partition$1;
                    private final int replicaId$1;
                    private final ReplicaState currState$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change of replica %d for partition [%s,%d] from %s to %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ReplicaStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)this.replicaId$1), this.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1), this.currState$1, this.targetState$2}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.targetState$2 = targetState$2;
                        this.topic$1 = topic$1;
                        this.partition$1 = partition$1;
                        this.replicaId$1 = replicaId$1;
                        this.currState$1 = currState$1;
                    }
                }, (Function0<Throwable>)new Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable t$1;

                    public final Throwable apply() {
                        return this.t$1;
                    }
                    {
                        this.t$1 = t$1;
                    }
                });
            }
        }
    }

    public Callbacks handleStateChanges$default$3() {
        return new Callbacks.CallbackBuilder().build();
    }

    public boolean areAllReplicasForTopicDeleted(String topic) {
        Set<PartitionAndReplica> replicasForTopic2 = this.kafka$controller$ReplicaStateMachine$$controller.controllerContext().replicasForTopic(topic);
        scala.collection.immutable.Map replicaStatesForTopic = ((TraversableOnce)replicasForTopic2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;

            public final Tuple2<PartitionAndReplica, ReplicaState> apply(PartitionAndReplica r) {
                return new Tuple2((Object)r, this.$outer.kafka$controller$ReplicaStateMachine$$replicaState().apply((Object)r));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.debug((Function0<String>)new Serializable(this, topic, replicaStatesForTopic){
            public static final long serialVersionUID = 0L;
            private final String topic$2;
            private final scala.collection.immutable.Map replicaStatesForTopic$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Are all replicas for topic %s deleted %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2, this.replicaStatesForTopic$1}));
            }
            {
                this.topic$2 = topic$2;
                this.replicaStatesForTopic$1 = replicaStatesForTopic$1;
            }
        });
        return replicaStatesForTopic.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<PartitionAndReplica, ReplicaState> x$3) {
                Object object = x$3._2();
                ReplicaDeletionSuccessful$ replicaDeletionSuccessful$ = ReplicaDeletionSuccessful$.MODULE$;
                return !(object != null ? !object.equals(replicaDeletionSuccessful$) : replicaDeletionSuccessful$ != null);
            }
        });
    }

    public boolean isAtLeastOneReplicaInDeletionStartedState(String topic) {
        Set<PartitionAndReplica> replicasForTopic2 = this.kafka$controller$ReplicaStateMachine$$controller.controllerContext().replicasForTopic(topic);
        scala.collection.immutable.Map replicaStatesForTopic = ((TraversableOnce)replicasForTopic2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;

            public final Tuple2<PartitionAndReplica, ReplicaState> apply(PartitionAndReplica r) {
                return new Tuple2((Object)r, this.$outer.kafka$controller$ReplicaStateMachine$$replicaState().apply((Object)r));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return BoxesRunTime.unboxToBoolean((Object)replicaStatesForTopic.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(boolean deletionState, Tuple2<PartitionAndReplica, ReplicaState> r) {
                if (deletionState) return true;
                Object object = r._2();
                ReplicaDeletionStarted$ replicaDeletionStarted$ = ReplicaDeletionStarted$.MODULE$;
                if (object != null) {
                    if (!object.equals(replicaDeletionStarted$)) return false;
                    return true;
                }
                if (replicaDeletionStarted$ == null) return true;
                return false;
            }
        }));
    }

    public Set<PartitionAndReplica> replicasInState(String topic, ReplicaState state) {
        return ((MapLike)this.kafka$controller$ReplicaStateMachine$$replicaState().filter((Function1)new Serializable(this, topic, state){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final ReplicaState state$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Tuple2<PartitionAndReplica, ReplicaState> r) {
                if (!((PartitionAndReplica)r._1()).topic().equals(this.topic$3)) return false;
                Object object = r._2();
                ReplicaState replicaState = this.state$1;
                if (object != null) {
                    if (!object.equals(replicaState)) return false;
                    return true;
                }
                if (replicaState == null) return true;
                return false;
            }
            {
                this.topic$3 = topic$3;
                this.state$1 = state$1;
            }
        })).keySet();
    }

    public boolean isAnyReplicaInState(String topic, ReplicaState state) {
        return this.kafka$controller$ReplicaStateMachine$$replicaState().exists((Function1)new Serializable(this, topic, state){
            public static final long serialVersionUID = 0L;
            private final String topic$4;
            private final ReplicaState state$2;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Tuple2<PartitionAndReplica, ReplicaState> r) {
                if (!((PartitionAndReplica)r._1()).topic().equals(this.topic$4)) return false;
                Object object = r._2();
                ReplicaState replicaState = this.state$2;
                if (object != null) {
                    if (!object.equals(replicaState)) return false;
                    return true;
                }
                if (replicaState == null) return true;
                return false;
            }
            {
                this.topic$4 = topic$4;
                this.state$2 = state$2;
            }
        });
    }

    public Set<PartitionAndReplica> replicasInDeletionStates(String topic) {
        Set deletionStates = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaState[]{ReplicaDeletionStarted$.MODULE$, ReplicaDeletionSuccessful$.MODULE$, ReplicaDeletionIneligible$.MODULE$}));
        return ((MapLike)this.kafka$controller$ReplicaStateMachine$$replicaState().filter((Function1)new Serializable(this, topic, deletionStates){
            public static final long serialVersionUID = 0L;
            private final String topic$5;
            private final Set deletionStates$1;

            public final boolean apply(Tuple2<PartitionAndReplica, ReplicaState> r) {
                return ((PartitionAndReplica)r._1()).topic().equals(this.topic$5) && this.deletionStates$1.contains(r._2());
            }
            {
                this.topic$5 = topic$5;
                this.deletionStates$1 = deletionStates$1;
            }
        })).keySet();
    }

    private void assertValidTransition(PartitionAndReplica partitionAndReplica, ReplicaState targetState) {
        Predef$.MODULE$.assert(targetState.validPreviousStates().contains(this.kafka$controller$ReplicaStateMachine$$replicaState().apply((Object)partitionAndReplica)), (Function0)new Serializable(this, partitionAndReplica, targetState){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;
            private final PartitionAndReplica partitionAndReplica$1;
            private final ReplicaState targetState$3;

            public final String apply() {
                return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Replica %s should be in the %s states before moving to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionAndReplica$1, this.targetState$3.validPreviousStates().mkString(","), this.targetState$3}))).append((Object)new StringOps(Predef$.MODULE$.augmentString(". Instead it is in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$controller$ReplicaStateMachine$$replicaState().apply((Object)this.partitionAndReplica$1)}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionAndReplica$1 = partitionAndReplica$1;
                this.targetState$3 = targetState$3;
            }
        });
    }

    private void initializeReplicaState() {
        this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> check$ifrefutable$1) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;

            public final void apply(Tuple2<TopicAndPartition, Seq<Object>> x$4) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x$4;
                if (tuple2 != null) {
                    TopicAndPartition topicPartition = (TopicAndPartition)tuple2._1();
                    Seq assignedReplicas = (Seq)tuple2._2();
                    String topic = topicPartition.topic();
                    int partition = topicPartition.partition();
                    assignedReplicas.foreach((Function1)new Serializable(this, topic, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$initializeReplicaState$2 $outer;
                        private final String topic$6;
                        private final int partition$2;

                        public final Option<ReplicaState> apply(int replicaId) {
                            PartitionAndReplica partitionAndReplica = new PartitionAndReplica(this.topic$6, this.partition$2, replicaId);
                            return this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)replicaId)) ? this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$$replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$) : this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$$replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionIneligible$.MODULE$);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.topic$6 = topic$6;
                            this.partition$2 = partition$2;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ ReplicaStateMachine kafka$controller$ReplicaStateMachine$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Seq<TopicAndPartition> partitionsAssignedToBroker(Seq<String> topics, int brokerId) {
        return ((MapLike)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new Serializable(this, brokerId){
            public static final long serialVersionUID = 0L;
            private final int brokerId$1;

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> x$5) {
                return ((SeqLike)x$5._2()).contains((Object)BoxesRunTime.boxToInteger((int)this.brokerId$1));
            }
            {
                this.brokerId$1 = brokerId$1;
            }
        })).keySet().toSeq();
    }

    public ReplicaStateMachine(KafkaController controller) {
        this.kafka$controller$ReplicaStateMachine$$controller = controller;
        Logging$class.$init$(this);
        this.kafka$controller$ReplicaStateMachine$$controllerContext = controller.controllerContext();
        this.kafka$controller$ReplicaStateMachine$$controllerId = controller.config().brokerId();
        this.zkUtils = this.kafka$controller$ReplicaStateMachine$$controllerContext().zkUtils();
        this.kafka$controller$ReplicaStateMachine$$replicaState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(controller);
        this.stateChangeLogger = KafkaController$.MODULE$.stateChangeLogger();
        this.logIdent_$eq(new StringBuilder().append((Object)"[Replica state machine on controller ").append((Object)BoxesRunTime.boxToInteger((int)controller.config().brokerId())).append((Object)"]: ").toString());
    }
}

