/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.util.concurrent.TimeUnit;
import kafka.consumer.ConsumerTopicStatsRegistry$;
import kafka.consumer.FetchRequestAndResponseStatsRegistry$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.producer.ProducerRequestStatsRegistry$;
import kafka.producer.ProducerStatsRegistry$;
import kafka.producer.ProducerTopicStatsRegistry$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class KafkaMetricsGroup$
implements KafkaMetricsGroup {
    public static final KafkaMetricsGroup$ MODULE$;
    private final List<MetricName> consumerMetricNameList;
    private final List<MetricName> producerMetricNameList;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new KafkaMetricsGroup$();
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit);
    }

    @Override
    public void removeMetric(String name) {
        KafkaMetricsGroup$class.removeMetric(this, name);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        KafkaMetricsGroup$ kafkaMetricsGroup$ = this;
        synchronized (kafkaMetricsGroup$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private List<MetricName> consumerMetricNameList() {
        return this.consumerMetricNameList;
    }

    private List<MetricName> producerMetricNameList() {
        return this.producerMetricNameList;
    }

    public void removeAllConsumerMetrics(String clientId) {
        FetchRequestAndResponseStatsRegistry$.MODULE$.removeConsumerFetchRequestAndResponseStats(clientId);
        ConsumerTopicStatsRegistry$.MODULE$.removeConsumerTopicStat(clientId);
        ProducerRequestStatsRegistry$.MODULE$.removeProducerRequestStats(clientId);
        this.removeAllMetricsInList(this.consumerMetricNameList(), clientId);
    }

    public void removeAllProducerMetrics(String clientId) {
        ProducerRequestStatsRegistry$.MODULE$.removeProducerRequestStats(clientId);
        ProducerTopicStatsRegistry$.MODULE$.removeProducerTopicStats(clientId);
        ProducerStatsRegistry$.MODULE$.removeProducerStats(clientId);
        this.removeAllMetricsInList(this.producerMetricNameList(), clientId);
    }

    private void removeAllMetricsInList(List<MetricName> metricNameList, String clientId) {
        metricNameList.foreach((Function1)new Serializable(clientId){
            private final String clientId$1;

            public final void apply(MetricName metric) {
                Regex pattern = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)this.clientId$1).append((Object)".*").append((Object)metric.getName()).append((Object)".*").toString())).r();
                Set registeredMetrics = JavaConversions$.MODULE$.asScalaSet(Metrics.defaultRegistry().allMetrics().keySet());
                registeredMetrics.foreach((Function1)new Serializable(this, pattern, metric){
                    private final Regex pattern$1;
                    private final MetricName metric$1;

                    public final void apply(MetricName registeredMetric) {
                        String string = registeredMetric.getGroup();
                        String string2 = this.metric$1.getGroup();
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            String string3 = registeredMetric.getType();
                            String string4 = this.metric$1.getType();
                            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                                Option option = this.pattern$1.findFirstIn((CharSequence)registeredMetric.getName());
                                if (option instanceof Some) {
                                    int beforeRemovalSize = Metrics.defaultRegistry().allMetrics().keySet().size();
                                    Metrics.defaultRegistry().removeMetric(registeredMetric);
                                    int afterRemovalSize = Metrics.defaultRegistry().allMetrics().keySet().size();
                                    KafkaMetricsGroup$.MODULE$.trace((Function0<String>)new Serializable(this, beforeRemovalSize, afterRemovalSize, registeredMetric){
                                        private final int beforeRemovalSize$1;
                                        private final int afterRemovalSize$1;
                                        private final MetricName registeredMetric$1;

                                        public final String apply() {
                                            return new StringOps(Predef$.MODULE$.augmentString("Removing metric %s. Metrics registry size reduced from %d to %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.registeredMetric$1, BoxesRunTime.boxToInteger((int)this.beforeRemovalSize$1), BoxesRunTime.boxToInteger((int)this.afterRemovalSize$1)}));
                                        }
                                        {
                                            this.beforeRemovalSize$1 = beforeRemovalSize$1;
                                            this.afterRemovalSize$1 = afterRemovalSize$1;
                                            this.registeredMetric$1 = registeredMetric$1;
                                        }
                                    });
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                            }
                        }
                    }
                    {
                        this.pattern$1 = pattern$1;
                        this.metric$1 = metric$1;
                    }
                });
            }
            {
                this.clientId$1 = clientId$1;
            }
        });
    }

    private KafkaMetricsGroup$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.consumerMetricNameList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MetricName[]{new MetricName("kafka.consumer", "ZookeeperConsumerConnector", "-FetchQueueSize"), new MetricName("kafka.consumer", "ZookeeperConsumerConnector", "-KafkaCommitsPerSec"), new MetricName("kafka.consumer", "ZookeeperConsumerConnector", "-ZooKeeperCommitsPerSec"), new MetricName("kafka.consumer", "ZookeeperConsumerConnector", "-RebalanceRateAndTime"), new MetricName("kafka.consumer", "ZookeeperConsumerConnector", "-OwnedPartitionsCount"), new MetricName("kafka.consumer", "ZookeeperConsumerConnector", "AllTopicsOwnedPartitionsCount"), new MetricName("kafka.consumer", "ConsumerFetcherManager", "-MaxLag"), new MetricName("kafka.consumer", "ConsumerFetcherManager", "-MinFetchRate"), new MetricName("kafka.server", "FetcherLagMetrics", "-ConsumerLag"), new MetricName("kafka.consumer", "ConsumerTopicMetrics", "-MessagesPerSec"), new MetricName("kafka.consumer", "ConsumerTopicMetrics", "-AllTopicsMessagesPerSec"), new MetricName("kafka.consumer", "ConsumerTopicMetrics", "-BytesPerSec"), new MetricName("kafka.consumer", "ConsumerTopicMetrics", "-AllTopicsBytesPerSec"), new MetricName("kafka.server", "FetcherStats", "-BytesPerSec"), new MetricName("kafka.server", "FetcherStats", "-RequestsPerSec"), new MetricName("kafka.consumer", "FetchRequestAndResponseMetrics", "-FetchResponseSize"), new MetricName("kafka.consumer", "FetchRequestAndResponseMetrics", "-FetchRequestRateAndTimeMs"), new MetricName("kafka.consumer", "FetchRequestAndResponseMetrics", "-AllBrokersFetchResponseSize"), new MetricName("kafka.consumer", "FetchRequestAndResponseMetrics", "-AllBrokersFetchRequestRateAndTimeMs"), new MetricName("kafka.producer", "ProducerRequestMetrics", "-ProducerRequestRateAndTimeMs"), new MetricName("kafka.producer", "ProducerRequestMetrics", "-ProducerRequestSize"), new MetricName("kafka.producer", "ProducerRequestMetrics", "-AllBrokersProducerRequestRateAndTimeMs"), new MetricName("kafka.producer", "ProducerRequestMetrics", "-AllBrokersProducerRequestSize")}));
        this.producerMetricNameList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MetricName[]{new MetricName("kafka.producer", "ProducerStats", "-SerializationErrorsPerSec"), new MetricName("kafka.producer", "ProducerStats", "-ResendsPerSec"), new MetricName("kafka.producer", "ProducerStats", "-FailedSendsPerSec"), new MetricName("kafka.producer.async", "ProducerSendThread", "-ProducerQueueSize"), new MetricName("kafka.producer", "ProducerTopicMetrics", "-MessagesPerSec"), new MetricName("kafka.producer", "ProducerTopicMetrics", "-DroppedMessagesPerSec"), new MetricName("kafka.producer", "ProducerTopicMetrics", "-BytesPerSec"), new MetricName("kafka.producer", "ProducerTopicMetrics", "-AllTopicsMessagesPerSec"), new MetricName("kafka.producer", "ProducerTopicMetrics", "-AllTopicsDroppedMessagesPerSec"), new MetricName("kafka.producer", "ProducerTopicMetrics", "-AllTopicsBytesPerSec"), new MetricName("kafka.producer", "ProducerRequestMetrics", "-ProducerRequestRateAndTimeMs"), new MetricName("kafka.producer", "ProducerRequestMetrics", "-ProducerRequestSize"), new MetricName("kafka.producer", "ProducerRequestMetrics", "-AllBrokersProducerRequestRateAndTimeMs"), new MetricName("kafka.producer", "ProducerRequestMetrics", "-AllBrokersProducerRequestSize")}));
    }
}

