/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Map;
import java.util.Properties;
import kafka.producer.BaseProducer;
import kafka.producer.KeyedMessage;
import kafka.producer.NewShinyProducer;
import kafka.producer.OldProducer;
import kafka.tools.ConsoleProducer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ConsoleProducer$ {
    public static final ConsoleProducer$ MODULE$;

    static {
        new ConsoleProducer$();
    }

    public void main(String[] args) {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(args);
        ConsoleProducer.MessageReader reader = (ConsoleProducer.MessageReader)Class.forName(config.readerClass()).newInstance();
        Properties props = new Properties();
        props.put("topic", config.topic());
        props.putAll((Map<?, ?>)config.cmdLineProps());
        reader.init(System.in, props);
        try {
            BaseProducer baseProducer;
            if (config.useNewProducer()) {
                props.put("bootstrap.servers", config.brokerList());
                props.put("compression.type", config.compressionCodec());
                props.put("send.buffer.bytes", config.socketBuffer().toString());
                props.put("retry.backoff.ms", config.retryBackoffMs().toString());
                props.put("metadata.max.age.ms", config.metadataExpiryMs().toString());
                props.put("metadata.fetch.timeout.ms", config.metadataFetchTimeoutMs().toString());
                props.put("acks", config.requestRequiredAcks().toString());
                props.put("timeout.ms", config.requestTimeoutMs().toString());
                props.put("retries", config.messageSendMaxRetries().toString());
                props.put("linger.ms", config.sendTimeout().toString());
                Object object = BoxesRunTime.equalsNumObject((Number)config.queueEnqueueTimeoutMs(), (Object)BoxesRunTime.boxToInteger((int)-1)) ? BoxedUnit.UNIT : props.put("block.on.buffer.full", "false");
                props.put("buffer.memory", config.maxMemoryBytes().toString());
                props.put("batch.size", config.maxPartitionMemoryBytes().toString());
                props.put("client.id", "console-producer");
                baseProducer = new NewShinyProducer(props);
            } else {
                props.put("metadata.broker.list", config.brokerList());
                props.put("compression.codec", config.compressionCodec());
                props.put("producer.type", config.sync() ? "sync" : "async");
                props.put("batch.num.messages", config.batchSize().toString());
                props.put("message.send.max.retries", config.messageSendMaxRetries().toString());
                props.put("retry.backoff.ms", config.retryBackoffMs().toString());
                props.put("queue.buffering.max.ms", config.sendTimeout().toString());
                props.put("queue.buffering.max.messages", config.queueSize().toString());
                props.put("queue.enqueue.timeout.ms", config.queueEnqueueTimeoutMs().toString());
                props.put("request.required.acks", config.requestRequiredAcks().toString());
                props.put("request.timeout.ms", config.requestTimeoutMs().toString());
                props.put("key.serializer.class", config.keyEncoderClass());
                props.put("serializer.class", config.valueEncoderClass());
                props.put("send.buffer.bytes", config.socketBuffer().toString());
                props.put("topic.metadata.refresh.interval.ms", config.metadataExpiryMs().toString());
                props.put("client.id", "console-producer");
                baseProducer = new OldProducer(props);
            }
            NewShinyProducer producer = baseProducer;
            Runtime.getRuntime().addShutdownHook(new Thread(producer){
                private final BaseProducer producer$1;

                public void run() {
                    this.producer$1.close();
                }
                {
                    this.producer$1 = producer$1;
                }
            });
            KeyedMessage<byte[], byte[]> message = null;
            while (true) {
                if ((message = reader.readMessage()) != null) {
                    producer.send(message.topic(), message.key(), message.message());
                }
                if (message != null) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private ConsoleProducer$() {
        MODULE$ = this;
    }
}

