/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.consumer.Blacklist;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.KafkaStream;
import kafka.consumer.TopicFilter;
import kafka.consumer.Whitelist;
import kafka.consumer.ZookeeperConsumerConnector;
import kafka.producer.BaseProducer;
import kafka.producer.NewShinyProducer;
import kafka.producer.OldProducer;
import kafka.serializer.DefaultDecoder;
import kafka.serializer.DefaultDecoder$;
import kafka.tools.MirrorMaker;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class MirrorMaker$
implements Logging {
    public static final MirrorMaker$ MODULE$;
    private Seq<ZookeeperConsumerConnector> connectors;
    private Seq<MirrorMaker.ConsumerThread> consumerThreads;
    private Seq<MirrorMaker.ProducerThread> producerThreads;
    private final ProducerRecord kafka$tools$MirrorMaker$$shutdownMessage;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new MirrorMaker$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        MirrorMaker$ mirrorMaker$ = this;
        synchronized (mirrorMaker$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private Seq<ZookeeperConsumerConnector> connectors() {
        return this.connectors;
    }

    private void connectors_$eq(Seq<ZookeeperConsumerConnector> x$1) {
        this.connectors = x$1;
    }

    private Seq<MirrorMaker.ConsumerThread> consumerThreads() {
        return this.consumerThreads;
    }

    private void consumerThreads_$eq(Seq<MirrorMaker.ConsumerThread> x$1) {
        this.consumerThreads = x$1;
    }

    private Seq<MirrorMaker.ProducerThread> producerThreads() {
        return this.producerThreads;
    }

    private void producerThreads_$eq(Seq<MirrorMaker.ProducerThread> x$1) {
        this.producerThreads = x$1;
    }

    public ProducerRecord kafka$tools$MirrorMaker$$shutdownMessage() {
        return this.kafka$tools$MirrorMaker$$shutdownMessage;
    }

    public void main(String[] args) {
        OptionSet options;
        this.info((Function0<String>)new Serializable(){

            public final String apply() {
                return "Starting mirror maker";
            }
        });
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec consumerConfigOpt = parser.accepts("consumer.config", "Consumer config to consume from a source cluster. You may specify multiple of these.").withRequiredArg().describedAs("config file").ofType(String.class);
        ArgumentAcceptingOptionSpec producerConfigOpt = parser.accepts("producer.config", "Embedded producer config.").withRequiredArg().describedAs("config file").ofType(String.class);
        OptionSpecBuilder useNewProducerOpt = parser.accepts("new.producer", "Use the new producer implementation.");
        ArgumentAcceptingOptionSpec numProducersOpt = parser.accepts("num.producers", "Number of producer instances").withRequiredArg().describedAs("Number of producers").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec numStreamsOpt = parser.accepts("num.streams", "Number of consumption streams.").withRequiredArg().describedAs("Number of threads").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec bufferSizeOpt = parser.accepts("queue.size", "Number of messages that are buffered between the consumer and producer").withRequiredArg().describedAs("Queue size in terms of number of messages").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(10000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec whitelistOpt = parser.accepts("whitelist", "Whitelist of topics to mirror.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class);
        ArgumentAcceptingOptionSpec blacklistOpt = parser.accepts("blacklist", "Blacklist of topics to mirror.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class);
        OptionSpecBuilder helpOpt = parser.accepts("help", "Print this message.");
        if (args.length == 0) {
            CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Continuously copy data between two Kafka clusters.");
        }
        if ((options = parser.parse(args)).has((OptionSpec)helpOpt)) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{consumerConfigOpt, producerConfigOpt}));
        if (List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{whitelistOpt, blacklistOpt})).count((Function1)new Serializable(options){
            private final OptionSet options$1;

            public final boolean apply(OptionSpec<?> x$1) {
                return this.options$1.has(x$1);
            }
            {
                this.options$1 = options$1;
            }
        }) != 1) {
            Predef$.MODULE$.println((Object)"Exactly one of whitelist or blacklist is required.");
            System.exit(1);
        }
        int numProducers = (Integer)options.valueOf((OptionSpec)numProducersOpt);
        int numStreams = (Integer)options.valueOf((OptionSpec)numStreamsOpt);
        int bufferSize = (Integer)options.valueOf((OptionSpec)bufferSizeOpt);
        this.connectors_$eq((Seq<ZookeeperConsumerConnector>)((Seq)((List)JavaConversions$.MODULE$.asScalaBuffer(options.valuesOf((OptionSpec)consumerConfigOpt)).toList().map((Function1)new Serializable(){

            public final ConsumerConfig apply(String cfg) {
                return new ConsumerConfig(Utils$.MODULE$.loadProps(cfg));
            }
        }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){

            public final ZookeeperConsumerConnector apply(ConsumerConfig x$1) {
                return new ZookeeperConsumerConnector(x$1);
            }
        }, List$.MODULE$.canBuildFrom())));
        int numConsumers = this.connectors().size() * numStreams;
        MirrorMaker.DataChannel mirrorDataChannel = new MirrorMaker.DataChannel(bufferSize, numConsumers, numProducers);
        boolean useNewProducer = options.has((OptionSpec)useNewProducerOpt);
        Properties producerProps = Utils$.MODULE$.loadProps((String)options.valueOf((OptionSpec)producerConfigOpt));
        String clientId = producerProps.getProperty("client.id", "");
        this.producerThreads_$eq((Seq<MirrorMaker.ProducerThread>)((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numProducers).map((Function1)new Serializable(mirrorDataChannel, useNewProducer, producerProps, clientId){
            private final MirrorMaker.DataChannel mirrorDataChannel$1;
            private final boolean useNewProducer$1;
            private final Properties producerProps$1;
            private final String clientId$1;

            public final MirrorMaker.ProducerThread apply(int i) {
                this.producerProps$1.setProperty("client.id", new StringBuilder().append((Object)this.clientId$1).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                BaseProducer producer = this.useNewProducer$1 ? new NewShinyProducer(this.producerProps$1) : new OldProducer(this.producerProps$1);
                return new MirrorMaker.ProducerThread(this.mirrorDataChannel$1, producer, i);
            }
            {
                this.mirrorDataChannel$1 = mirrorDataChannel$1;
                this.useNewProducer$1 = useNewProducer$1;
                this.producerProps$1 = producerProps$1;
                this.clientId$1 = clientId$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())));
        TopicFilter filterSpec = options.has((OptionSpec)whitelistOpt) ? new Whitelist((String)options.valueOf((OptionSpec)whitelistOpt)) : new Blacklist((String)options.valueOf((OptionSpec)blacklistOpt));
        Nil$ streams2 = Nil$.MODULE$;
        try {
            streams2 = (Seq)((GenericTraversableTemplate)this.connectors().map((Function1)new Serializable(numStreams, filterSpec){
                private final int numStreams$1;
                private final TopicFilter filterSpec$1;

                public final Seq<KafkaStream<byte[], byte[]>> apply(ZookeeperConsumerConnector x$2) {
                    return x$2.createMessageStreamsByFilter(this.filterSpec$1, this.numStreams$1, new DefaultDecoder(DefaultDecoder$.MODULE$.$lessinit$greater$default$1()), new DefaultDecoder(DefaultDecoder$.MODULE$.$lessinit$greater$default$1()));
                }
                {
                    this.numStreams$1 = numStreams$1;
                    this.filterSpec$1 = filterSpec$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms());
        }
        catch (Throwable throwable) {
            this.fatal((Function0<String>)new Serializable(){

                public final String apply() {
                    return "Unable to create stream - shutting down mirror maker.";
                }
            });
            this.connectors().foreach((Function1)new Serializable(){

                public final void apply(ZookeeperConsumerConnector x$3) {
                    x$3.shutdown();
                }
            });
        }
        this.consumerThreads_$eq((Seq<MirrorMaker.ConsumerThread>)((Seq)((TraversableLike)streams2.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(mirrorDataChannel){
            private final MirrorMaker.DataChannel mirrorDataChannel$1;

            public final MirrorMaker.ConsumerThread apply(Tuple2<KafkaStream<byte[], byte[]>, Object> streamAndIndex) {
                return new MirrorMaker.ConsumerThread((KafkaStream)streamAndIndex._1(), this.mirrorDataChannel$1, streamAndIndex._2$mcI$sp());
            }
            {
                this.mirrorDataChannel$1 = mirrorDataChannel$1;
            }
        }, Seq$.MODULE$.canBuildFrom())));
        Predef$.MODULE$.assert(this.consumerThreads().size() == numConsumers);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                MirrorMaker$.MODULE$.cleanShutdown();
            }
        });
        this.consumerThreads().foreach((Function1)new Serializable(){

            public final void apply(MirrorMaker.ConsumerThread x$4) {
                x$4.start();
            }
        });
        this.producerThreads().foreach((Function1)new Serializable(){

            public final void apply(MirrorMaker.ProducerThread x$5) {
                x$5.start();
            }
        });
        this.producerThreads().foreach((Function1)new Serializable(){

            public final void apply(MirrorMaker.ProducerThread x$6) {
                x$6.awaitShutdown();
            }
        });
    }

    public void cleanShutdown() {
        if (this.connectors() != null) {
            this.connectors().foreach((Function1)new Serializable(){

                public final void apply(ZookeeperConsumerConnector x$7) {
                    x$7.shutdown();
                }
            });
        }
        if (this.consumerThreads() != null) {
            this.consumerThreads().foreach((Function1)new Serializable(){

                public final void apply(MirrorMaker.ConsumerThread x$8) {
                    x$8.awaitShutdown();
                }
            });
        }
        if (this.producerThreads() != null) {
            this.producerThreads().foreach((Function1)new Serializable(){

                public final void apply(MirrorMaker.ProducerThread x$9) {
                    x$9.shutdown();
                }
            });
            this.producerThreads().foreach((Function1)new Serializable(){

                public final void apply(MirrorMaker.ProducerThread x$10) {
                    x$10.awaitShutdown();
                }
            });
        }
        this.info((Function0<String>)new Serializable(){

            public final String apply() {
                return "Kafka mirror maker shutdown successfully";
            }
        });
    }

    private MirrorMaker$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.connectors = null;
        this.consumerThreads = null;
        this.producerThreads = null;
        this.kafka$tools$MirrorMaker$$shutdownMessage = new ProducerRecord("shutdown", "shutdown".getBytes());
    }
}

