/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.cluster.Broker;
import kafka.common.KafkaException;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.SimpleConsumer;
import kafka.utils.Utils$;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class UpdateOffsetsInZK$ {
    public static final UpdateOffsetsInZK$ MODULE$;
    private final String Earliest;
    private final String Latest;

    static {
        new UpdateOffsetsInZK$();
    }

    public String Earliest() {
        return this.Earliest;
    }

    public String Latest() {
        return this.Latest;
    }

    public void main(String[] args) {
        if (args.length < 3) {
            this.usage();
        }
        ConsumerConfig config = new ConsumerConfig(Utils$.MODULE$.loadProps(args[1]));
        ZkClient zkClient = new ZkClient(config.zkConnect(), config.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), (ZkSerializer)ZKStringSerializer$.MODULE$);
        String string = args[0];
        String string2 = this.Earliest();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.getAndSetOffsets(zkClient, OffsetRequest$.MODULE$.EarliestTime(), config, args[2]);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = this.Latest();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                this.getAndSetOffsets(zkClient, OffsetRequest$.MODULE$.LatestTime(), config, args[2]);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.usage();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private void getAndSetOffsets(ZkClient zkClient, long offsetOption, ConsumerConfig config, String topic) {
        Map<String, Seq<Object>> partitionsPerTopicMap = ZkUtils$.MODULE$.getPartitionsForTopics(zkClient, (Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Nil$ partitions = Nil$.MODULE$;
        Option option = partitionsPerTopicMap.get((Object)topic);
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq l = (Seq)some.x();
            partitions = (Seq)l.sortWith((Function2)new Serializable(){

                public final boolean apply(int s, int t) {
                    return this.apply$mcZII$sp(s, t);
                }

                public boolean apply$mcZII$sp(int s, int t) {
                    return s < t;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            IntRef numParts = IntRef.create((int)0);
            partitions.foreach((Function1)new Serializable(zkClient, offsetOption, config, topic, numParts){
                private final ZkClient zkClient$1;
                private final long offsetOption$1;
                private final ConsumerConfig config$1;
                private final String topic$1;
                private final IntRef numParts$1;

                public final void apply(int partition) {
                    this.apply$mcVI$sp(partition);
                }

                public void apply$mcVI$sp(int partition) {
                    Option<Object> brokerHostingPartition = ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient$1, this.topic$1, partition);
                    Option<Object> option = brokerHostingPartition;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        int b = BoxesRunTime.unboxToInt((Object)some.x());
                        int n = b;
                        int broker = n;
                        Option<Broker> option2 = ZkUtils$.MODULE$.getBrokerInfo(this.zkClient$1, broker);
                        if (option2 instanceof Some) {
                            Some some2 = (Some)option2;
                            Broker brokerInfo = (Broker)some2.x();
                            SimpleConsumer consumer = new SimpleConsumer(brokerInfo.host(), brokerInfo.port(), 10000, 102400, "UpdateOffsetsInZk");
                            TopicAndPartition topicAndPartition = new TopicAndPartition(this.topic$1, partition);
                            OffsetRequest request = new OffsetRequest((scala.collection.immutable.Map<TopicAndPartition, PartitionOffsetRequestInfo>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(this.offsetOption$1, 1))}))), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
                            long offset = BoxesRunTime.unboxToLong((Object)((PartitionOffsetsResponse)consumer.getOffsetsBefore(request).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets().head());
                            ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(this.config$1.groupId(), this.topic$1);
                            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"updating partition ").append((Object)BoxesRunTime.boxToInteger((int)partition)).append((Object)" with new offset: ").append((Object)BoxesRunTime.boxToLong((long)offset)).toString());
                            ZkUtils$.MODULE$.updatePersistentPath(this.zkClient$1, new StringBuilder().append((Object)topicDirs.consumerOffsetDir()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)partition)).toString(), ((Object)BoxesRunTime.boxToLong((long)offset)).toString());
                            ++this.numParts$1.elem;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        if (None$.MODULE$.equals(option2)) {
                            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Broker information for broker id %d does not exist in ZK")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)broker)})));
                        }
                        throw new MatchError(option2);
                    }
                    if (None$.MODULE$.equals(option)) {
                        throw new KafkaException(new StringBuilder().append((Object)"Broker ").append(brokerHostingPartition).append((Object)" is unavailable. Cannot issue ").append((Object)"getOffsetsBefore request").toString());
                    }
                    throw new MatchError(option);
                }
                {
                    this.zkClient$1 = zkClient$1;
                    this.offsetOption$1 = offsetOption$1;
                    this.config$1 = config$1;
                    this.topic$1 = topic$1;
                    this.numParts$1 = numParts$1;
                }
            });
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"updated the offset for ").append((Object)BoxesRunTime.boxToInteger((int)numParts.elem)).append((Object)" partitions").toString());
            return;
        }
        throw new RuntimeException(new StringBuilder().append((Object)"Can't find topic ").append((Object)topic).toString());
    }

    private void usage() {
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"USAGE: ").append((Object)this.getClass().getName()).append((Object)" [earliest | latest] consumer.properties topic").toString());
        System.exit(1);
    }

    private UpdateOffsetsInZK$() {
        MODULE$ = this;
        this.Earliest = "earliest";
        this.Latest = "latest";
    }
}

