/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.log.Log;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.ReplicaManager;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.scalatest.junit.JUnit3Suite;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001\u001d\u0011\u0011#S:s\u000bb\u0004\u0018N]1uS>tG+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!a\u0003&V]&$8gU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001\u0001\u0019!C\u00013\u0005\tBo\u001c9jGB\u000b'\u000f^5uS>t\u0017j\u001d:\u0016\u0003i\u0001Ba\u0007\u0012%e5\tAD\u0003\u0002\u001e=\u00059Q.\u001e;bE2,'BA\u0010!\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\b\u0002\u0004\u001b\u0006\u0004\b\u0003B\u0013'Q=j\u0011\u0001I\u0005\u0003O\u0001\u0012a\u0001V;qY\u0016\u0014\u0004CA\u0015-\u001d\t)#&\u0003\u0002,A\u00051\u0001K]3eK\u001aL!!\f\u0018\u0003\rM#(/\u001b8h\u0015\tY\u0003\u0005\u0005\u0002&a%\u0011\u0011\u0007\t\u0002\u0004\u0013:$\bcA\u001a<_9\u0011A'\u000f\b\u0003kaj\u0011A\u000e\u0006\u0003o\u0019\ta\u0001\u0010:p_Rt\u0014\"A\u0011\n\u0005i\u0002\u0013a\u00029bG.\fw-Z\u0005\u0003yu\u00121aU3r\u0015\tQ\u0004\u0005C\u0004@\u0001\u0001\u0007I\u0011\u0001!\u0002+Q|\u0007/[2QCJ$\u0018\u000e^5p]&\u001b(o\u0018\u0013fcR\u0011\u0011\t\u0012\t\u0003K\tK!a\u0011\u0011\u0003\tUs\u0017\u000e\u001e\u0005\b\u000bz\n\t\u00111\u0001\u001b\u0003\rAH%\r\u0005\u0007\u000f\u0002\u0001\u000b\u0015\u0002\u000e\u0002%Q|\u0007/[2QCJ$\u0018\u000e^5p]&\u001b(\u000f\t\u0005\b\u0013\u0002\u0011\r\u0011\"\u0001K\u0003\u001d\u0019wN\u001c4jON,\u0012a\u0013\t\u0004\u0019>\u000bV\"A'\u000b\u00059s\u0012!C5n[V$\u0018M\u00197f\u0013\t\u0001VJ\u0001\u0003MSN$\bC\u0001\fS\u0013\t\u0019&AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007BB+\u0001A\u0003%1*\u0001\u0005d_:4\u0017nZ:!\u0011\u001d9\u0006A1A\u0005\u0002a\u000bQ\u0001^8qS\u000e,\u0012!\u0017\t\u00035~k\u0011a\u0017\u0006\u00039v\u000bA\u0001\\1oO*\ta,\u0001\u0003kCZ\f\u0017BA\u0017\\\u0011\u0019\t\u0007\u0001)A\u00053\u00061Ao\u001c9jG\u0002BQa\u0019\u0001\u0005\u0002\u0011\f!\u0005^3ti&\u001b(/\u0012=qSJ\fG/[8o\r>\u00148\u000b^;dW\u001a{G\u000e\\8xKJ\u001cH#A!\t\u000b\u0019\u0004A\u0011\u00013\u0002CQ,7\u000f^%te\u0016C\b/\u001b:bi&|gNR8s'2|wOR8mY><XM]:\t\u000b!\u0004A\u0011B5\u0002A\u001d,G\u000fU1si&$\u0018n\u001c8XSRD\u0017\t\u001c7SKBd\u0017nY1t\u0013:L5O\u001d\u000b\u0007UB\f8o_?\u0011\u0005-tW\"\u00017\u000b\u00055$\u0011aB2mkN$XM]\u0005\u0003_2\u0014\u0011\u0002U1si&$\u0018n\u001c8\t\u000b];\u0007\u0019\u0001\u0015\t\u000bI<\u0007\u0019A\u0018\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\u0006i\u001e\u0004\r!^\u0001\u0005i&lW\r\u0005\u0002ws6\tqO\u0003\u0002y\t\u0005)Q\u000f^5mg&\u0011!p\u001e\u0002\u0005)&lW\rC\u0003}O\u0002\u0007\u0011+\u0001\u0004d_:4\u0017n\u001a\u0005\u0006}\u001e\u0004\ra`\u0001\tY>\u001c\u0017\r\u001c'pOB!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006\u0011\t1\u0001\\8h\u0013\u0011\tI!a\u0001\u0003\u00071{w\rC\u0004\u0002\u000e\u0001!I!a\u0004\u0002-\u001d,G\u000fT8h/&$\b\u000eT8h\u000b:$wJ\u001a4tKR$Ra`A\t\u00037A\u0001\"a\u0005\u0002\f\u0001\u0007\u0011QC\u0001\rY><WI\u001c3PM\u001a\u001cX\r\u001e\t\u0004K\u0005]\u0011bAA\rA\t!Aj\u001c8h\u0011\u001d\ti\"a\u0003A\u0002=\nQ\"\u001a=qK\u000e$X\rZ\"bY2\u001c\bbBA\u0011\u0001\u0011%\u00111E\u0001\u0014O\u0016$hi\u001c7m_^,'OU3qY&\u001c\u0017m\u001d\u000b\t\u0003K\ti#!\r\u00026A!1gOA\u0014!\rY\u0017\u0011F\u0005\u0004\u0003Wa'a\u0002*fa2L7-\u0019\u0005\b\u0003_\ty\u00021\u0001k\u0003%\u0001\u0018M\u001d;ji&|g\u000eC\u0004\u00024\u0005}\u0001\u0019A\u0018\u0002\u00111,\u0017\rZ3s\u0013\u0012Da\u0001^A\u0010\u0001\u0004)\b")
public class IsrExpirationTest
extends JUnit3Suite {
    private Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr = new HashMap();
    private final List<KafkaConfig> configs = (List)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.createBrokerConfigs$default$2()).map((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final KafkaConfig apply(Properties x$1) {
            return new KafkaConfig(this, x$1){
                private final long replicaLagTimeMaxMs;
                private final int replicaFetchWaitMaxMs;
                private final long replicaLagMaxMessages;

                public long replicaLagTimeMaxMs() {
                    return this.replicaLagTimeMaxMs;
                }

                public int replicaFetchWaitMaxMs() {
                    return this.replicaFetchWaitMaxMs;
                }

                public long replicaLagMaxMessages() {
                    return this.replicaLagMaxMessages;
                }
                {
                    super(x$1$1);
                    this.replicaLagTimeMaxMs = 100L;
                    this.replicaFetchWaitMaxMs = 100;
                    this.replicaLagMaxMessages = 10L;
                }
            };
        }
    }, List$.MODULE$.canBuildFrom());
    private final String topic;

    public Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr() {
        return this.topicPartitionIsr;
    }

    public void topicPartitionIsr_$eq(Map<Tuple2<String, Object>, Seq<Object>> x$1) {
        this.topicPartitionIsr = x$1;
    }

    public List<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public void testIsrExpirationForStuckFollowers() {
        MockTime time = new MockTime();
        Log log = this.getLogWithLogEndOffset(15L, 2);
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, time, (KafkaConfig)this.configs().head(), log);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaConfig x$2) {
                return x$2.brokerId();
            }
        }, List$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$3) {
                return x$3.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition0.getReplica(((KafkaConfig)this.configs().head()).brokerId()).get();
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Replica r) {
                r.logEndOffset_$eq(new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            }
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, ((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs(), ((KafkaConfig)this.configs().head()).replicaLagMaxMessages());
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$4) {
                return x$4.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        time.sleep(150L);
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, ((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs(), ((KafkaConfig)this.configs().head()).replicaLagMaxMessages());
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$5) {
                return x$5.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        EasyMock.verify((Object[])new Object[]{log});
    }

    public void testIsrExpirationForSlowFollowers() {
        MockTime time = new MockTime();
        Log log = this.getLogWithLogEndOffset(15L, 1);
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, time, (KafkaConfig)this.configs().head(), log);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaConfig x$6) {
                return x$6.brokerId();
            }
        }, List$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$7) {
                return x$7.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition0.getReplica(((KafkaConfig)this.configs().head()).brokerId()).get();
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Replica r) {
                r.logEndOffset_$eq(new LogOffsetMetadata(4L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            }
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, ((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs(), ((KafkaConfig)this.configs().head()).replicaLagMaxMessages());
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Replica x$8) {
                return x$8.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom()));
        EasyMock.verify((Object[])new Object[]{log});
    }

    private Partition getPartitionWithAllReplicasInIsr(String topic, int partitionId, Time time, KafkaConfig config, Log localLog) {
        int leaderId = config.brokerId();
        ReplicaManager replicaManager = new ReplicaManager(config, time, null, null, null, new AtomicBoolean(false));
        Partition partition = replicaManager.getOrCreatePartition(topic, partitionId);
        Replica leaderReplica = new Replica(leaderId, partition, time, 0L, (Option)new Some((Object)localLog));
        Seq allReplicas = (Seq)this.getFollowerReplicas(partition, leaderId, time).$colon$plus((Object)leaderReplica, Seq$.MODULE$.canBuildFrom());
        allReplicas.foreach((Function1)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final Partition partition$1;

            public final Replica apply(Replica r) {
                return this.partition$1.addReplicaIfNotExists(r);
            }
            {
                this.partition$1 = partition$1;
            }
        });
        partition.inSyncReplicas_$eq(allReplicas.toSet());
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderId)));
        return partition;
    }

    private Log getLogWithLogEndOffset(long logEndOffset, int expectedCalls) {
        Log log1 = (Log)EasyMock.createMock(Log.class);
        EasyMock.expect((Object)log1.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata(logEndOffset, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).times(expectedCalls);
        EasyMock.replay((Object[])new Object[]{log1});
        return log1;
    }

    private Seq<Replica> getFollowerReplicas(Partition partition, int leaderId, Time time) {
        return (Seq)((List)this.configs().filter((Function1)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            public final boolean apply(KafkaConfig x$9) {
                return x$9.brokerId() != this.leaderId$1;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        })).map((Function1)new Serializable(this, partition, time){
            public static final long serialVersionUID = 0L;
            private final Partition partition$2;
            private final Time time$1;

            public final Replica apply(KafkaConfig config) {
                return new Replica(config.brokerId(), this.partition$2, this.time$1, Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5());
            }
            {
                this.partition$2 = partition$2;
                this.time$1 = time$1;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public IsrExpirationTest() {
        this.topic = "foo";
    }
}

