/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import kafka.cluster.Replica;
import kafka.common.TopicAndPartition;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.serializer.StringEncoder;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.OffsetCheckpoint;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.utils.IntEncoder;
import kafka.utils.TestUtils$;
import kafka.utils.Utils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.junit.Assert;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\u0001\u0003\u0001\u001d\u0011q\u0002T8h%\u0016\u001cwN^3ssR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\n\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u00111BS+oSR\u001c4+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0003u.L!a\u0006\u000b\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0004\u001f\u0001\t\u0007I\u0011A\u0010\u0002\u000f\r|gNZ5hgV\t\u0001\u0005E\u0002\"Q)j\u0011A\t\u0006\u0003G\u0011\n\u0011\"[7nkR\f'\r\\3\u000b\u0005\u00152\u0013AC2pY2,7\r^5p]*\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*E\t!A*[:u!\ta2&\u0003\u0002-\u0005\tY1*\u00194lC\u000e{gNZ5h\u0011\u0019q\u0003\u0001)A\u0005A\u0005A1m\u001c8gS\u001e\u001c\b\u0005C\u00041\u0001\t\u0007I\u0011A\u0019\u0002\u000bQ|\u0007/[2\u0016\u0003I\u0002\"a\r\u001d\u000e\u0003QR!!\u000e\u001c\u0002\t1\fgn\u001a\u0006\u0002o\u0005!!.\u0019<b\u0013\tIDG\u0001\u0004TiJLgn\u001a\u0005\u0007w\u0001\u0001\u000b\u0011\u0002\u001a\u0002\rQ|\u0007/[2!\u0011\u001di\u0004A1A\u0005\u0002y\n1\u0002]1si&$\u0018n\u001c8JIV\tq\b\u0005\u0002A\u00036\ta%\u0003\u0002CM\t\u0019\u0011J\u001c;\t\r\u0011\u0003\u0001\u0015!\u0003@\u00031\u0001\u0018M\u001d;ji&|g.\u00133!\u0011\u001d1\u0005\u00011A\u0005\u0002\u001d\u000bqa]3sm\u0016\u0014\u0018'F\u0001I!\ta\u0012*\u0003\u0002K\u0005\tY1*\u00194lCN+'O^3s\u0011\u001da\u0005\u00011A\u0005\u00025\u000b1b]3sm\u0016\u0014\u0018g\u0018\u0013fcR\u0011a*\u0015\t\u0003\u0001>K!\u0001\u0015\u0014\u0003\tUs\u0017\u000e\u001e\u0005\b%.\u000b\t\u00111\u0001I\u0003\rAH%\r\u0005\u0007)\u0002\u0001\u000b\u0015\u0002%\u0002\u0011M,'O^3sc\u0001BqA\u0016\u0001A\u0002\u0013\u0005q)A\u0004tKJ4XM\u001d\u001a\t\u000fa\u0003\u0001\u0019!C\u00013\u0006Y1/\u001a:wKJ\u0014t\fJ3r)\tq%\fC\u0004S/\u0006\u0005\t\u0019\u0001%\t\rq\u0003\u0001\u0015)\u0003I\u0003!\u0019XM\u001d<feJ\u0002\u0003b\u00020\u0001\u0005\u0004%\taX\u0001\rG>tg-[4Qe>\u00048/M\u000b\u0002U!1\u0011\r\u0001Q\u0001\n)\nQbY8oM&<\u0007K]8qgF\u0002\u0003bB2\u0001\u0005\u0004%\taX\u0001\rG>tg-[4Qe>\u00048O\r\u0005\u0007K\u0002\u0001\u000b\u0011\u0002\u0016\u0002\u001b\r|gNZ5h!J|\u0007o\u001d\u001a!\u0011\u001d9\u0007A1A\u0005\u0002E\nq!\\3tg\u0006<W\r\u0003\u0004j\u0001\u0001\u0006IAM\u0001\t[\u0016\u001c8/Y4fA!91\u000e\u0001a\u0001\n\u0003a\u0017\u0001\u00039s_\u0012,8-\u001a:\u0016\u00035\u0004BA\u001c9@e6\tqN\u0003\u0002l\t%\u0011\u0011o\u001c\u0002\t!J|G-^2feB\u00111O\u001e\b\u0003\u0001RL!!\u001e\u0014\u0002\rA\u0013X\rZ3g\u0013\tItO\u0003\u0002vM!9\u0011\u0010\u0001a\u0001\n\u0003Q\u0018\u0001\u00049s_\u0012,8-\u001a:`I\u0015\fHC\u0001(|\u0011\u001d\u0011\u00060!AA\u00025Da! \u0001!B\u0013i\u0017!\u00039s_\u0012,8-\u001a:!\u0011!y\b\u00011A\u0005\u0002\u0005\u0005\u0011a\u00025x\r&dW-M\u000b\u0003\u0003\u0007\u00012\u0001HA\u0003\u0013\r\t9A\u0001\u0002\u0011\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]RD\u0011\"a\u0003\u0001\u0001\u0004%\t!!\u0004\u0002\u0017!<h)\u001b7fc}#S-\u001d\u000b\u0004\u001d\u0006=\u0001\"\u0003*\u0002\n\u0005\u0005\t\u0019AA\u0002\u0011!\t\u0019\u0002\u0001Q!\n\u0005\r\u0011\u0001\u00035x\r&dW-\r\u0011\t\u0013\u0005]\u0001\u00011A\u0005\u0002\u0005\u0005\u0011a\u00025x\r&dWM\r\u0005\n\u00037\u0001\u0001\u0019!C\u0001\u0003;\t1\u0002[<GS2,'g\u0018\u0013fcR\u0019a*a\b\t\u0013I\u000bI\"!AA\u0002\u0005\r\u0001\u0002CA\u0012\u0001\u0001\u0006K!a\u0001\u0002\u0011!<h)\u001b7fe\u0001B\u0011\"a\n\u0001\u0001\u0004%\t!!\u000b\u0002\u000fM,'O^3sgV\u0011\u00111\u0006\t\u0006\u0003[\ti\u0004\u0013\b\u0005\u0003_\tID\u0004\u0003\u00022\u0005]RBAA\u001a\u0015\r\t)DB\u0001\u0007yI|w\u000e\u001e \n\u0003\u001dJ1!a\u000f'\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0010\u0002B\t\u00191+Z9\u000b\u0007\u0005mb\u0005C\u0005\u0002F\u0001\u0001\r\u0011\"\u0001\u0002H\u0005Y1/\u001a:wKJ\u001cx\fJ3r)\rq\u0015\u0011\n\u0005\n%\u0006\r\u0013\u0011!a\u0001\u0003WA\u0001\"!\u0014\u0001A\u0003&\u00111F\u0001\tg\u0016\u0014h/\u001a:tA!9\u0011\u0011\u000b\u0001\u0005B\u0005M\u0013!B:fiV\u0003H#\u0001(\t\u000f\u0005]\u0003\u0001\"\u0011\u0002T\u0005AA/Z1s\t><h\u000eC\u0004\u0002\\\u0001!\t!!\u0018\u0002UQ,7\u000f\u001e%X\u0007\",7m\u001b9pS:$hj\u001c$bS2,(/Z:TS:<G.\u001a'pON+w-\\3oiV\ta\nC\u0004\u0002b\u0001!\t!!\u0018\u0002YQ,7\u000f\u001e%X\u0007\",7m\u001b9pS:$x+\u001b;i\r\u0006LG.\u001e:fgNKgn\u001a7f\u0019><7+Z4nK:$\bbBA3\u0001\u0011\u0005\u0011QL\u0001.i\u0016\u001cH\u000fS,DQ\u0016\u001c7\u000e]8j]RtuNR1jYV\u0014Xm]'vYRL\u0007\u000f\\3M_\u001e\u001cVmZ7f]R\u001c\bbBA5\u0001\u0011\u0005\u0011QL\u00010i\u0016\u001cH\u000fS,DQ\u0016\u001c7\u000e]8j]R<\u0016\u000e\u001e5GC&dWO]3t\u001bVdG/\u001b9mK2{wmU3h[\u0016tGo\u001d\u0005\b\u0003[\u0002A\u0011BA8\u00031\u0019XM\u001c3NKN\u001c\u0018mZ3t)\rq\u0015\u0011\u000f\u0005\n\u0003g\nY\u0007%AA\u0002}\n\u0011A\u001c\u0005\n\u0003o\u0002\u0011\u0013!C\u0005\u0003s\nac]3oI6+7o]1hKN$C-\u001a4bk2$H%M\u000b\u0003\u0003wR3aPA?W\t\ty\b\u0005\u0003\u0002\u0002\u0006-UBAAB\u0015\u0011\t))a\"\u0002\u0013Ut7\r[3dW\u0016$'bAAEM\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00151\u0011\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class LogRecoveryTest
extends JUnit3Suite
implements ZooKeeperTestHarness {
    private final List<KafkaConfig> configs;
    private final String topic;
    private final int partitionId;
    private KafkaServer server1;
    private KafkaServer server2;
    private final KafkaConfig configProps1;
    private final KafkaConfig configProps2;
    private final String message;
    private Producer<Object, String> producer;
    private OffsetCheckpoint hwFile1;
    private OffsetCheckpoint hwFile2;
    private Seq<KafkaServer> servers;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public /* synthetic */ void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public /* synthetic */ void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    public List<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public KafkaServer server1() {
        return this.server1;
    }

    public void server1_$eq(KafkaServer x$1) {
        this.server1 = x$1;
    }

    public KafkaServer server2() {
        return this.server2;
    }

    public void server2_$eq(KafkaServer x$1) {
        this.server2 = x$1;
    }

    public KafkaConfig configProps1() {
        return this.configProps1;
    }

    public KafkaConfig configProps2() {
        return this.configProps2;
    }

    public String message() {
        return this.message;
    }

    public Producer<Object, String> producer() {
        return this.producer;
    }

    public void producer_$eq(Producer<Object, String> x$1) {
        this.producer = x$1;
    }

    public OffsetCheckpoint hwFile1() {
        return this.hwFile1;
    }

    public void hwFile1_$eq(OffsetCheckpoint x$1) {
        this.hwFile1 = x$1;
    }

    public OffsetCheckpoint hwFile2() {
        return this.hwFile2;
    }

    public void hwFile2_$eq(OffsetCheckpoint x$1) {
        this.hwFile2 = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        this.server1_$eq(TestUtils$.MODULE$.createServer(this.configProps1(), TestUtils$.MODULE$.createServer$default$2()));
        this.server2_$eq(TestUtils$.MODULE$.createServer(this.configProps2(), TestUtils$.MODULE$.createServer$default$2()));
        this.servers_$eq((Seq<KafkaServer>)((Seq)this.servers().$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1(), this.server2()})), Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers());
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)this.configs()), StringEncoder.class.getName(), IntEncoder.class.getName(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5()));
    }

    @Override
    public void tearDown() {
        this.producer().close();
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.shutdown();
                Utils$.MODULE$.rm((String)server.config().logDirs().apply(0));
            }
        });
        ZooKeeperTestHarness$class.tearDown(this);
    }

    public void testHWCheckpointNoFailuresSingleLogSegment() {
        long numMessages = 2L;
        this.sendMessages((int)numMessages);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, numMessages){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final long numMessages$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                int x$4;
                int x$3;
                String x$2;
                ReplicaManager qual$1 = this.$outer.server2().replicaManager();
                return ((Replica)qual$1.getReplica(x$2 = this.$outer.topic(), x$3 = 0, x$4 = qual$1.getReplica$default$3()).get()).highWatermark().messageOffset() == this.numMessages$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numMessages$1 = numMessages$1;
            }
        }, "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.replicaManager().checkpointHighWatermarks();
            }
        });
        long leaderHW = BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)numMessages), (Object)BoxesRunTime.boxToLong((long)leaderHW));
        long followerHW = BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)numMessages), (Object)BoxesRunTime.boxToLong((long)followerHW));
    }

    public void testHWCheckpointWithFailuresSingleLogSegment() {
        Option<Object> leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), (Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        this.sendMessages(1);
        Thread.sleep(1000L);
        LongRef hw = LongRef.create((long)1L);
        this.server1().shutdown();
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)hw.elem), (Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        ZkClient x$5 = this.zkClient();
        String x$6 = this.topic();
        int x$7 = this.partitionId();
        Option<Object> x$8 = leader;
        long x$9 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$10 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$5, x$6, x$7, x$9, x$8, x$10);
        Assert.assertEquals((String)"Leader must move to broker 1", (Object)BoxesRunTime.boxToInteger((int)1), (Object)leader.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        }));
        this.server1().startup();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertTrue((String)"Leader must remain on broker 1, in case of zookeeper session expiration it can move to broker 0", (leader.isDefined() && (BoxesRunTime.unboxToInt((Object)leader.get()) == 0 || BoxesRunTime.unboxToInt((Object)leader.get()) == 1) ? 1 : 0) != 0);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)hw.elem), (Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        this.server2().shutdown();
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)hw.elem), (Object)this.hwFile2().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        this.server2().startup();
        ZkClient x$11 = this.zkClient();
        String x$12 = this.topic();
        int x$13 = this.partitionId();
        Option<Object> x$14 = leader;
        long x$15 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$16 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$11, x$12, x$13, x$15, x$14, x$16);
        Assert.assertTrue((String)"Leader must remain on broker 0, in case of zookeeper session expiration it can move to broker 1", (leader.isDefined() && (BoxesRunTime.unboxToInt((Object)leader.get()) == 0 || BoxesRunTime.unboxToInt((Object)leader.get()) == 1) ? 1 : 0) != 0);
        this.sendMessages(1);
        ++hw.elem;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final LongRef hw$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                int x$19;
                int x$18;
                String x$17;
                ReplicaManager qual$2 = this.$outer.server2().replicaManager();
                return ((Replica)qual$2.getReplica(x$17 = this.$outer.topic(), x$18 = 0, x$19 = qual$2.getReplica$default$3()).get()).highWatermark().messageOffset() == this.hw$1.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hw$1 = hw$1;
            }
        }, "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.shutdown();
            }
        });
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)hw.elem), (Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)hw.elem), (Object)this.hwFile2().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public void testHWCheckpointNoFailuresMultipleLogSegments() {
        this.sendMessages(20);
        long hw = 20L;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final long hw$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                int x$22;
                int x$21;
                String x$20;
                ReplicaManager qual$3 = this.$outer.server2().replicaManager();
                return ((Replica)qual$3.getReplica(x$20 = this.$outer.topic(), x$21 = 0, x$22 = qual$3.getReplica$default$3()).get()).highWatermark().messageOffset() == this.hw$2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hw$2 = hw$2;
            }
        }, "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.shutdown();
            }
        });
        long leaderHW = BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)hw), (Object)BoxesRunTime.boxToLong((long)leaderHW));
        long followerHW = BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)hw), (Object)BoxesRunTime.boxToLong((long)followerHW));
    }

    public void testHWCheckpointWithFailuresMultipleLogSegments() {
        Option<Object> leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.sendMessages(2);
        LongRef hw = LongRef.create((long)2L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final LongRef hw$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                int x$25;
                int x$24;
                String x$23;
                ReplicaManager qual$4 = this.$outer.server2().replicaManager();
                return ((Replica)qual$4.getReplica(x$23 = this.$outer.topic(), x$24 = 0, x$25 = qual$4.getReplica$default$3()).get()).highWatermark().messageOffset() == this.hw$3.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hw$3 = hw$3;
            }
        }, "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3());
        this.server1().shutdown();
        this.server2().shutdown();
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)hw.elem), (Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)hw.elem), (Object)this.hwFile2().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        this.server2().startup();
        ZkClient x$26 = this.zkClient();
        String x$27 = this.topic();
        int x$28 = this.partitionId();
        Option<Object> x$29 = leader;
        long x$30 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$31 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$26, x$27, x$28, x$30, x$29, x$31);
        Assert.assertEquals((String)"Leader must move to broker 1", (Object)BoxesRunTime.boxToInteger((int)1), (Object)leader.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        }));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)hw.elem), (Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        this.server1().startup();
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)hw.elem), (Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)hw.elem), (Object)this.hwFile2().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        this.sendMessages(2);
        hw.elem += 2L;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final LongRef hw$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                int x$34;
                int x$33;
                String x$32;
                ReplicaManager qual$5 = this.$outer.server1().replicaManager();
                return ((Replica)qual$5.getReplica(x$32 = this.$outer.topic(), x$33 = 0, x$34 = qual$5.getReplica$default$3()).get()).highWatermark().messageOffset() == this.hw$3.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hw$3 = hw$3;
            }
        }, "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.shutdown();
            }
        });
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)hw.elem), (Object)this.hwFile1().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)hw.elem), (Object)this.hwFile2().read().getOrElse((Object)new TopicAndPartition(this.topic(), 0), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    private void sendMessages(int n) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.producer().send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(this.$outer.topic(), (Object)BoxesRunTime.boxToInteger((int)0), (Object)this.$outer.message())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private int sendMessages$default$1() {
        return 1;
    }

    public LogRecoveryTest() {
        ZooKeeperTestHarness$class.$init$(this);
        this.configs = (List)TestUtils$.MODULE$.createBrokerConfigs(2, false).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaConfig apply(Properties x$1) {
                return new KafkaConfig(this, x$1){
                    private final long replicaLagTimeMaxMs;
                    private final long replicaLagMaxMessages;
                    private final int replicaFetchWaitMaxMs;
                    private final int replicaFetchMinBytes;

                    public long replicaLagTimeMaxMs() {
                        return this.replicaLagTimeMaxMs;
                    }

                    public long replicaLagMaxMessages() {
                        return this.replicaLagMaxMessages;
                    }

                    public int replicaFetchWaitMaxMs() {
                        return this.replicaFetchWaitMaxMs;
                    }

                    public int replicaFetchMinBytes() {
                        return this.replicaFetchMinBytes;
                    }
                    {
                        super(x$1$1);
                        this.replicaLagTimeMaxMs = 5000L;
                        this.replicaLagMaxMessages = 10L;
                        this.replicaFetchWaitMaxMs = 1000;
                        this.replicaFetchMinBytes = 20;
                    }
                };
            }
        }, List$.MODULE$.canBuildFrom());
        this.topic = "new-topic";
        this.partitionId = 0;
        this.server1 = null;
        this.server2 = null;
        this.configProps1 = (KafkaConfig)this.configs().head();
        this.configProps2 = (KafkaConfig)this.configs().last();
        this.message = "hello";
        this.producer = null;
        this.hwFile1 = new OffsetCheckpoint(new File((String)this.configProps1().logDirs().apply(0), ReplicaManager$.MODULE$.HighWatermarkFilename()));
        this.hwFile2 = new OffsetCheckpoint(new File((String)this.configProps2().logDirs().apply(0), ReplicaManager$.MODULE$.HighWatermarkFilename()));
        this.servers = (Seq)Seq$.MODULE$.empty();
    }
}

