/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.common;

import junit.framework.Assert;
import kafka.common.InvalidConfigException;
import kafka.consumer.ConsumerConfig$;
import kafka.producer.ProducerConfig$;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u001d2A!\u0001\u0002\u0001\u0013\tQ1i\u001c8gS\u001e$Vm\u001d;\u000b\u0005\r!\u0011AB2p[6|gN\u0003\u0002\u0006\r\u0005)1.\u00194lC*\tq!\u0001\u0003v]&$8\u0001A\n\u0003\u0001)\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\t!\u0002!D\u0001\u0003\u0011\u00151\u0002\u0001\"\u0001\u0018\u0003Q!Xm\u001d;J]Z\fG.\u001b3DY&,g\u000e^%egR\t\u0001\u0004\u0005\u0002\f3%\u0011!\u0004\u0004\u0002\u0005+:LG\u000f\u000b\u0002\u00169A\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002C\u0005\u0019qN]4\n\u0005\rr\"\u0001\u0002+fgRDQ!\n\u0001\u0005\u0002]\t1\u0003^3ti&sg/\u00197jI\u001e\u0013x.\u001e9JIND#\u0001\n\u000f")
public class ConfigTest {
    @Test
    public void testInvalidClientIds() {
        ArrayBuffer invalidClientIds = new ArrayBuffer();
        Object[] badChars = (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)'/'), BoxesRunTime.boxToCharacter((char)'\\'), BoxesRunTime.boxToCharacter((char)','), BoxesRunTime.boxToCharacter((char)'\u0000'), BoxesRunTime.boxToCharacter((char)':'), "\"", BoxesRunTime.boxToCharacter((char)'\''), BoxesRunTime.boxToCharacter((char)';'), BoxesRunTime.boxToCharacter((char)'*'), BoxesRunTime.boxToCharacter((char)'?'), BoxesRunTime.boxToCharacter((char)' '), BoxesRunTime.boxToCharacter((char)'\t'), BoxesRunTime.boxToCharacter((char)'\r'), BoxesRunTime.boxToCharacter((char)'\n'), BoxesRunTime.boxToCharacter((char)'=')}), ClassTag$.MODULE$.Any());
        Predef$.MODULE$.genericArrayOps((Object)badChars).foreach((Function1)new Serializable(this, invalidClientIds){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer invalidClientIds$1;

            public final ArrayBuffer<String> apply(Object weirdChar) {
                return this.invalidClientIds$1.$plus$eq((Object)new StringBuilder().append((Object)"Is").append(weirdChar).append((Object)"illegal").toString());
            }
            {
                this.invalidClientIds$1 = invalidClientIds$1;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), invalidClientIds.size()).foreach((Function1)new Serializable(this, invalidClientIds){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer invalidClientIds$1;

            public final Object apply(int i) {
                String string;
                try {
                    ProducerConfig$.MODULE$.validateClientId((String)this.invalidClientIds$1.apply(i));
                    Assert.fail((String)"Should throw InvalidClientIdException.");
                    string = BoxedUnit.UNIT;
                }
                catch (InvalidConfigException invalidConfigException) {
                    string = "This is good.";
                }
                return string;
            }
            {
                this.invalidClientIds$1 = invalidClientIds$1;
            }
        });
        ArrayBuffer validClientIds = new ArrayBuffer();
        validClientIds.$plus$eq((Object)"valid", (Object)"CLIENT", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"iDs", "ar6", "VaL1d", "_0-9_.", ""}));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), validClientIds.size()).foreach$mVc$sp((Function1)new Serializable(this, validClientIds){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer validClientIds$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                try {
                    ProducerConfig$.MODULE$.validateClientId((String)this.validClientIds$1.apply(i));
                }
                catch (Exception exception) {
                    Assert.fail((String)"Should not throw exception.");
                }
            }
            {
                this.validClientIds$1 = validClientIds$1;
            }
        });
    }

    @Test
    public void testInvalidGroupIds() {
        ArrayBuffer invalidGroupIds = new ArrayBuffer();
        Object[] badChars = (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)'/'), BoxesRunTime.boxToCharacter((char)'\\'), BoxesRunTime.boxToCharacter((char)','), BoxesRunTime.boxToCharacter((char)'\u0000'), BoxesRunTime.boxToCharacter((char)':'), "\"", BoxesRunTime.boxToCharacter((char)'\''), BoxesRunTime.boxToCharacter((char)';'), BoxesRunTime.boxToCharacter((char)'*'), BoxesRunTime.boxToCharacter((char)'?'), BoxesRunTime.boxToCharacter((char)' '), BoxesRunTime.boxToCharacter((char)'\t'), BoxesRunTime.boxToCharacter((char)'\r'), BoxesRunTime.boxToCharacter((char)'\n'), BoxesRunTime.boxToCharacter((char)'=')}), ClassTag$.MODULE$.Any());
        Predef$.MODULE$.genericArrayOps((Object)badChars).foreach((Function1)new Serializable(this, invalidGroupIds){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer invalidGroupIds$1;

            public final ArrayBuffer<String> apply(Object weirdChar) {
                return this.invalidGroupIds$1.$plus$eq((Object)new StringBuilder().append((Object)"Is").append(weirdChar).append((Object)"illegal").toString());
            }
            {
                this.invalidGroupIds$1 = invalidGroupIds$1;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), invalidGroupIds.size()).foreach((Function1)new Serializable(this, invalidGroupIds){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer invalidGroupIds$1;

            public final Object apply(int i) {
                String string;
                try {
                    ConsumerConfig$.MODULE$.validateGroupId((String)this.invalidGroupIds$1.apply(i));
                    Assert.fail((String)"Should throw InvalidGroupIdException.");
                    string = BoxedUnit.UNIT;
                }
                catch (InvalidConfigException invalidConfigException) {
                    string = "This is good.";
                }
                return string;
            }
            {
                this.invalidGroupIds$1 = invalidGroupIds$1;
            }
        });
        ArrayBuffer validGroupIds = new ArrayBuffer();
        validGroupIds.$plus$eq((Object)"valid", (Object)"GROUP", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"iDs", "ar6", "VaL1d", "_0-9_.", ""}));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), validGroupIds.size()).foreach$mVc$sp((Function1)new Serializable(this, validGroupIds){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer validGroupIds$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                try {
                    ConsumerConfig$.MODULE$.validateGroupId((String)this.validGroupIds$1.apply(i));
                }
                catch (Exception exception) {
                    Assert.fail((String)"Should not throw exception.");
                }
            }
            {
                this.validGroupIds$1 = validGroupIds$1;
            }
        });
    }
}

